package com.geoway.landteam.landcloud.service.thirddata.utils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * Created by Walt Chiang(JY)) on 2020/6/15.
 */
public class MaterializedViewUtils {
    @Autowired
    private static JdbcTemplate jdbcTemplate;
    public static void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        MaterializedViewUtils.jdbcTemplate = jdbcTemplate;
    }
    public final static String tbtsk_jbntzy_bhtb_view = "tbtsk_jbntzy_bhtb_view_m";
    public final static String BHYJJBNTTB_ZB = "mView_BHYJJBNTTB_ZB";
    public final static String ZYYJJBNTTB_ZB = "mView_ZYYJJBNTTB_ZB";
    public final static String ZDJSXM_ZB = "mView_ZDJSXM_ZB";
    public final static String LSYD_ZB = "mView_LSYD_ZB";
    public final static String ZZYZS_ZB = "mView_ZZYZS_ZB";
    /**
     * 更新与创建物化视图
     * **/
    @Transactional
    public  static void createOrReplaceMView(){
        createOrReplaceBHJBNTTB2ConflicCheckView();//冲突检测分析图层
        createOrReplaceBHJBNTTB4ZBView();//补划图斑图层(在办)
        createOrReplaceZYYJJBNTTB4ZBView();//占用图斑图层(在办)
        createOrReplaceZDJSXM4ZBView();//重大建设项目图层(在办)
        createOrReplaceZZYZSSXM4ZBView();//设施农用地项目图层(在办)
        createOrReplaceLSYDXM4ZBView();//临时用地项目图层(在办)
    }
    /**
     * 删除基本农田补划图斑图层物化视图，并重新创建
     * */
    public static String createOrReplaceBHJBNTTB2ConflicCheckView(){

        String delView ="DROP MATERIALIZED VIEW IF EXISTS "+tbtsk_jbntzy_bhtb_view+";";
        jdbcTemplate.execute(delView);
        String createView ="CREATE MATERIALIZED VIEW "+tbtsk_jbntzy_bhtb_view+" AS ";
        String selectUnionTable="select o.f_tablename  from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid and p.f_submit_status='1' ";
        List<Map<String, Object>> tableNameList = jdbcTemplate.queryForList(selectUnionTable);

        if(tableNameList!=null&&tableNameList.size()>0) {
            for (int i = 0; i < tableNameList.size(); i++) {
                String tableName=tableNameList.get(i).get("f_tablename").toString();
                if (i != tableNameList.size() - 1) {
                    createView += " select f_tbbh,f_tbmc,f_tbmj,f_xzqdm,f_qsdwdm,f_qsdwmc,f_zldwdm,f_zldwmc,f_shape,f_tablealias from " + tableName + " , tbtsk_objectinfo  where f_tbdatatype='1' and f_tablename='"+tableName+"' union all ";
                } else {
                    createView += " select f_tbbh,f_tbmc,f_tbmj,f_xzqdm,f_qsdwdm,f_qsdwmc,f_zldwdm,f_zldwmc,f_shape,f_tablealias from " + tableName + " , tbtsk_objectinfo where f_tbdatatype='1' and f_tablename='"+tableName+"';";
                }
            }
            jdbcTemplate.execute(createView);
            return "ok";
        }else{
            return "不存在已提交项目";
        }
    }

    /**
     * 删除基本农田 补划图斑图层物化视图(在办)，并重新创建——补划图斑
     * */
    public static String createOrReplaceBHJBNTTB4ZBView() {

        String delView = "DROP MATERIALIZED VIEW IF EXISTS " + BHYJJBNTTB_ZB + ";";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW " + BHYJJBNTTB_ZB + " AS ";
        String selectUnionTable = "select o.f_tablename,p.f_id  from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid and p.f_submit_status='1'  and p.f_check_status in ('0','1','3','4') ";
        List<Map<String, Object>> tableNameList = jdbcTemplate.queryForList(selectUnionTable);

        if (tableNameList != null && tableNameList.size() > 0) {
            for (int i = 0; i < tableNameList.size(); i++) {
                String tableName = tableNameList.get(i).get("f_tablename").toString();
                String xmid = tableNameList.get(i).get("f_id").toString();
                createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '0' as STATUS,'" + xmid + "'as XMID from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='1' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";

            }
            //处理已经完结
            selectUnionTable = "select o.f_tablename,p.f_id    from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid and p.f_submit_status='1'  and p.f_check_status in ('2') ";
            tableNameList = jdbcTemplate.queryForList(selectUnionTable);

            if (tableNameList != null && tableNameList.size() > 0) {
                for (int i = 0; i < tableNameList.size(); i++) {
                    String tableName = tableNameList.get(i).get("f_tablename").toString();
                    String xmid = tableNameList.get(i).get("f_id").toString();
                    createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '1' as STATUS,'" + xmid + "'as XMID from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='1' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";
                }
            }
            createView = createView.substring(0, createView.lastIndexOf("union all "));
            jdbcTemplate.execute(createView);
            return "ok";
        } else {
            return "不存在已提交项目";
        }
    }
    /**
     * 删除基本农田 占用图斑图层物化视图（在办），并重新创建——占用图斑
     * */
    public static String createOrReplaceZYYJJBNTTB4ZBView() {
        String delView = "DROP MATERIALIZED VIEW IF EXISTS " + ZYYJJBNTTB_ZB + ";";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW " + ZYYJJBNTTB_ZB + " AS ";
        String selectUnionTable = "select o.f_tablename,p.f_id    from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid and p.f_submit_status='1'  and p.f_check_status in ('0','1','3','4')";
        List<Map<String, Object>> tableNameList = jdbcTemplate.queryForList(selectUnionTable);

        if (tableNameList != null && tableNameList.size() > 0) {
            for (int i = 0; i < tableNameList.size(); i++) {
                String tableName = tableNameList.get(i).get("f_tablename").toString();
                String xmid = tableNameList.get(i).get("f_id").toString();
                createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '0' as STATUS,'" + xmid + "'as XMID  from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='0' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";
            }

            selectUnionTable = "select o.f_tablename,p.f_id    from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid and p.f_submit_status='1'  and p.f_check_status in ('2')";
            tableNameList = jdbcTemplate.queryForList(selectUnionTable);
            if (tableNameList != null && tableNameList.size() > 0) {
                for (int i = 0; i < tableNameList.size(); i++) {
                    String tableName = tableNameList.get(i).get("f_tablename").toString();
                    String xmid = tableNameList.get(i).get("f_id").toString();
                    createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '1' as STATUS,'" + xmid + "'as XMID  from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='0' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";

                }
            }
            createView = createView.substring(0, createView.lastIndexOf("union all "));
            jdbcTemplate.execute(createView);
            return "ok";
        } else {
            return "不存在已提交项目";
        }
    }

    /**
     * 删除重大建设项目边界物化视图（在办），并重新创建——重大建设项目（在办）
     * */
    public static String createOrReplaceZDJSXM4ZBView() {
        String delView = "DROP MATERIALIZED VIEW IF EXISTS " + ZDJSXM_ZB + ";";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW " + ZDJSXM_ZB + " AS ";

        createView += " select f_id as TBID,f_biz_id as WYID,f_ywid as YWID,f_xmbh as XMBH,f_check_status as SPZT,f_submission as BSLX,f_check_message as MESSAGE,f_name as XMMC,f_xzqmc as QXMC,f_cybgsjnf as CYBGSHNF,f_zymj as ZY_XJ,f_bh_xj as BH_XJ,f_bgcshrq as BGCSHRQ,f_bz as BZ,f_sfzyjbnt as SFZJBNT,f_xmbh as XMTYDM,f_agentcom as ZJDWMC,f_usetype as ZYLX,f_creditno as ZJDWXYDM,f_rank as XMJB,f_sfkqx as SFKQX,null as ZT,null as SE_ANNO_CAD_DATA,f_shape as SHAPE, case when f_check_status ='2' then '1' ELSE '0' END as STATUS from tbtsk_task_ntzy_project where f_usetype='0' and f_check_status != '5'and (f_submit_status='1' or f_submit_status is null) ";

        jdbcTemplate.execute(createView);
        return "ok";
    }

    /**
     * 删除临时用地项目边界物化视图（在办），并重新创建——临时用地项目（在办）
     * */
    public static String createOrReplaceLSYDXM4ZBView() {
        String delView = "DROP MATERIALIZED VIEW IF EXISTS " + LSYD_ZB + ";";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW " + LSYD_ZB + " AS ";

        createView += " select f_id as TBID,f_biz_id as WYID,f_ywid as YWID,f_xmbh as XMBH,f_check_status as SPZT,f_submission as BSLX,f_check_message as MESSAGE,f_name as XMMC,f_xzqmc as QXMC,f_xmwz as XMWZ,f_cybgsjnf as CYBGSJNF,f_lsydmj as LSYDMJ,f_zjbntmj as ZJBNTMJ,f_sysjq as SYSJQ,f_sysjz as SYSJZ,f_pzsj as PZSJ,f_jcyscbh as JCYSCBH,f_bz as BZ,f_sfzyjbnt as SFZJBNT,f_agentcom as ZJDWMC,f_creditno as ZJDWXYDM,f_rank as XMJB,f_bgcshrq as BGCSHRQ,null as ZT,null as SE_ANNO_CAD_DATA,f_shape as SHAPE, case when f_check_status ='2' then '1' ELSE '0' END as STATUS  from tbtsk_task_ntzy_project where f_usetype='4' and f_check_status != '5'  and (f_submit_status='1' or f_submit_status is null) ";

        jdbcTemplate.execute(createView);
        return "ok";
    }

    /**
     * 删除设施农用地项目边界物化视图（在办），并重新创建——设施农用地项目（在办）
     * */
    public static String createOrReplaceZZYZSSXM4ZBView() {
        String delView = "DROP MATERIALIZED VIEW IF EXISTS " + ZZYZS_ZB + ";";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW " + ZZYZS_ZB + " AS ";

        createView += " select f_id as TBID,f_biz_id as WYID,f_ywid as YWID,f_xmbh as XMBH,f_check_status as SPZT,f_submission as BSLX,f_check_message as MESSAGE,f_name as XMMC,f_xzqmc as QXMC,f_ydwz as YDWZ,f_cybgsjnf as CYBGSJNF,f_ydzgm as YDZGM,f_zymj as SYJBNTMJ,f_synydmj as SYNYDMJ,f_bgqk as BGQK,f_scsjq as SYSJQ,f_scsjz as SYSJZ,f_jcyscbh as JCYSCBH,f_bgcsrk as QXJLDSCRQ,f_bz as BZ,f_sfzjbnt as SFZJBNT,f_agentcom as ZJDWMC,f_creditno as ZJDWXYDM,f_rank as XMJB,null as ZT,null as SE_ANNO_CAD_DATA,f_shape as SHAPE, case when f_check_status ='2' then '1' ELSE '0' END as STATUS  from tbtsk_task_ntzy_project where f_usetype='2' and f_check_status != '5'  and (f_submit_status='1' or f_submit_status is null) ";

        jdbcTemplate.execute(createView);
        return "ok";
    }

    public static String createOrReplaceZytbMV() {
        String delView = "DROP MATERIALIZED VIEW IF EXISTS lastzy;";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW lastzy AS ";
        String selectUnionTable = "select o.f_tablename,p.f_id    from first_record p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =b.f_tableid ";
        List<Map<String, Object>> tableNameList = jdbcTemplate.queryForList(selectUnionTable);

        if (tableNameList != null && tableNameList.size() > 0) {
            for (int i = 0; i < tableNameList.size(); i++) {
                String tableName = tableNameList.get(i).get("f_tablename").toString();
                String xmid = tableNameList.get(i).get("f_id").toString();
                createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '0' as STATUS,'" + xmid + "'as XMID  from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='0' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";
            }

            selectUnionTable = "select o.f_tablename,p.f_id    from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid   and p.f_check_status in ('2')";
            tableNameList = jdbcTemplate.queryForList(selectUnionTable);
            if (tableNameList != null && tableNameList.size() > 0) {
                for (int i = 0; i < tableNameList.size(); i++) {
                    String tableName = tableNameList.get(i).get("f_tablename").toString();
                    String xmid = tableNameList.get(i).get("f_id").toString();
                    createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '1' as STATUS,'" + xmid + "'as XMID  from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='0' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";

                }
            }
            createView = createView.substring(0, createView.lastIndexOf("union all "));
            jdbcTemplate.execute(createView);
            return "ok";
        } else {
            return "不存在已提交项目";
        }
    }
    public static String createOrReplaceBhtbMV() {
        String delView = "DROP MATERIALIZED VIEW IF EXISTS lastbh;";
        jdbcTemplate.execute(delView);
        String createView = "CREATE MATERIALIZED VIEW lastbh AS ";
        String selectUnionTable = "select o.f_tablename,p.f_id    from first_record p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =b.f_tableid ";
        List<Map<String, Object>> tableNameList = jdbcTemplate.queryForList(selectUnionTable);

        if (tableNameList != null && tableNameList.size() > 0) {
            for (int i = 0; i < tableNameList.size(); i++) {
                String tableName = tableNameList.get(i).get("f_tablename").toString();
                String xmid = tableNameList.get(i).get("f_id").toString();
                createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '0' as STATUS,'" + xmid + "'as XMID  from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='1' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";
            }

            selectUnionTable = "select o.f_tablename,p.f_id    from tbtsk_task_ntzy_project p, tbtsk_task_biz b,  tbtsk_objectinfo o where p.f_biz_id=b.f_id and( b.f_isdel <>'1' or b.f_isdel is null) and o.f_id =p.f_tableid  and p.f_check_status in ('2')";
            tableNameList = jdbcTemplate.queryForList(selectUnionTable);
            if (tableNameList != null && tableNameList.size() > 0) {
                for (int i = 0; i < tableNameList.size(); i++) {
                    String tableName = tableNameList.get(i).get("f_tablename").toString();
                    String xmid = tableNameList.get(i).get("f_id").toString();
                    createView += " select " + tableName + ".f_id as TBID,f_bsm as BSM,f_ysdm as YSDM,f_jbnttbbh as JBNTTBBH,f_kclx as KCLX,f_tbbh as TBBH,f_dlbm as DLBM,f_dlmc as DLMC,f_qsxz as QSXZ,f_qsdwdm as QSDWDM,f_qsdwmc as QSDWMC,f_zldwdm as ZLDWDM,f_zldwmc as ZLDWMC,f_gdlx as GDLX,f_jbntlx as JBNTLX,f_pdjb as PDJB,f_kcdlbm as KCDLBM,f_tkxs as TKXS,f_xzdwmj as XZDWMJ,f_lxdwmj as LXDWMJ,f_tkmj as TKMJ,f_tbmj as TBMJ,f_jbntmj as JBNTMJ,f_dlbz as DLBZ,f_xzqdm as XZQDM,f_xzqmc as XZQMC,f_xmmc as XMMC1,0 as TBMJM,f_gjlyd as GJLYD,f_sjnf as SJNF,f_bz as BZ,f_shape as SHAPE,null as SE_ANNO_CAD_DATA,f_zldjdm as ZLDJDM,f_zymj as ZYMJ,f_tablealias as XMMC,tbtsk_task_biz.f_id as WYID, '1' as STATUS,'" + xmid + "'as XMID  from " + tableName + " , tbtsk_objectinfo,tbtsk_task_biz   where f_tbdatatype='1' and f_tablename='" + tableName + "' and tbtsk_task_biz.f_tableid =tbtsk_objectinfo.f_id union all ";

                }
            }
            createView = createView.substring(0, createView.lastIndexOf("union all "));
            jdbcTemplate.execute(createView);
            return "ok";
        } else {
            return "不存在已提交项目";
        }
    }
}
