package com.geoway.landteam.landcloud.service.thirddata.utils;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class MyX509TrustManager implements X509TrustManager {

    X509TrustManager sunJSSEX509TrustManager;

    public MyX509TrustManager(String keysStoreFile, String pass) throws Exception{
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(keysStoreFile),pass.toCharArray());
        TrustManagerFactory tmf =TrustManagerFactory.getInstance("SunX509","SunJSSE");
        tmf.init(ks);
        TrustManager[] tms  = tmf.getTrustManagers();
        for(int i = 0; i < tms.length; i++){
            if(tms[i] instanceof X509TrustManager){
                sunJSSEX509TrustManager = (X509TrustManager)tms[i];
                return;
            }
        }
        throw  new Exception("Coun't initialize");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            sunJSSEX509TrustManager.checkClientTrusted(x509Certificates,s);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        try {
            sunJSSEX509TrustManager.checkServerTrusted(x509Certificates,s);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return sunJSSEX509TrustManager.getAcceptedIssuers();
    }
}
