package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.datacq.analyze.*;
import com.itextpdf.text.Image;
import org.apache.commons.lang3.StringUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 云分析数据处理类,，复制与CloudAnalyzeCQService.java
 * Created by licong on 2021/9/23.
 */
public class PdfAnalyzeUtil {

    /**
     * 重庆数据处理
     * @param db
     * @param tableName
     * @param info
     */
    public static void ParseCQ(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "tdqs"://土地权属TDQS
                    info.tdqsInfos = ParseJsyd(db, tableName, "QSXZ", null);
                    break;
                case "tdqs_image":
                    info.tdqsImg = GetImageByBlob(db, tableName, null);
                    break;
                case "image_analyze"://季度监测图斑影像
//                    ParseOwnerShip(db, tableName, info);
                    info.ownershipImg = GetImageByBlob(db, tableName, null);
                    break;
                case "jbntbhq"://基本农田分析
                    info.jbntArea = getMj(db, tableName, null);
                    break;
                case "jbntbhq_image":
                    info.jbntImg = GetImageByBlob(db, tableName, null);
                    break;
                case "jsydgzq"://建设用地管制区
                    info.jsydInfos = ParseJsyd(db, tableName, "GZQLXDM", null);
                    Double jsydArea = 0d;
                    for (int i = 0; i < info.jsydInfos.size(); i++) {
                        jsydArea += info.jsydInfos.get(i).area;
                    }
                    info.jsydgzqArea = jsydArea;
                    break;
                case "jsydgzq_image":
                    info.jsydgzqImg = GetImageByBlob(db, tableName, null);
                    break;
                case "zrbhd"://自然保护地分析
                    info.zrbhdInfos = ParseJsyd(db, tableName, "TYPE", null);
                    break;
                case "zrbhd_image":
                    info.zrbhdImg = GetImageByBlob(db, tableName, null);
                    break;
                case "sthx"://生态红线分析
                    info.sthxArea = getMj(db, tableName, null);
                    break;
                case "sthx_image":
                    info.sthxImg = GetImageByBlob(db, tableName, null);
                    break;
                case "czkfbj"://镇城镇开发边界
                    info.czkfArea = getMj(db, tableName, null);
                    break;
                case "czkfbj_image":
                    info.czkfImg = GetImageByBlob(db, tableName, null);
                    break;
                case "cgtdghdl"://村规划CGTDGHDL
                    info.cghInfos = ParseJsyd(db, tableName, "CGHDLMC", null);
                    break;
                case "cgtdghdl_image":
                    info.cghImg = GetImageByBlob(db, tableName, null);
                    break;
                case "tdghdl"://土地规划地类TDGHDL
                    info.tdghCqInfos = ParseJsyd(db, tableName, "GHDLMC", null);
                    break;
                case "tdghdl_image":
                    info.tdghCqImg = GetImageByBlob(db, tableName, null);
                    break;
                case "dzzhgyfq"://地质灾害高易发区DZZHGYFQ
                    info.dzzhArea = getMj(db, tableName, null);
                    break;
                case "dzzhgyfq_image":
                    info.dzzhImg = GetImageByBlob(db, tableName, null);
                    break;
                case "sd"://湿地sd
                    info.cqsdInfos = ParseJsyd(db, tableName, "湿地型", null);
                    break;
                case "sd_image":
                    info.cqsdImg = GetImageByBlob(db, tableName, null);
                    break;
                case "tdlyxz_image":
                    info.tdlyxzImg = GetImageByBlob(db, tableName, 1);
                    break;
                case "tdlyxz"://土地利用现状
                    info.tdlyxzInfos = ParseJsyd(db, tableName, "DLBM", null);
                    break;
            }
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    /**
     * 通用字段处理
     * @param db
     * @param tableName
     * @param typeField
     * @param areaField
     * @return
     */
    protected static List<CommonInfoCQ> ParseJsyd(SqlliteConnTool db, String tableName, String typeField, String areaField) {
        List<CommonInfoCQ> list = new ArrayList<>();
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return null;
            if (StringUtils.isEmpty(areaField)) {
                areaField = "mj";
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                CommonInfoCQ infoCQ = new CommonInfoCQ();
                double mj = set.getDouble(areaField) * 666.6666;
                String type = set.getString(typeField);
                infoCQ.area = mj;
                infoCQ.type = type;
                list.add(infoCQ);
            }
            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return list;
    }

    /**
     * 通用获取照片数据处理
     * @param db
     * @param tableName
     * @param imageType
     * @return
     */
    protected static Image GetImageByBlob(SqlliteConnTool db, String tableName, Integer imageType) {
        try {
            Image img = null;
            String sql = "select layer_pic from " + tableName;
            if (null != imageType)
                sql += " where image_type = " + imageType;
            ResultSetInfo info = db.doQuery(sql);
            if (info == null)
                return null;
            ResultSet set = info.getResultSet();
            while (set.next()) {
                byte[] imgBytes = set.getBytes("layer_pic");
                if (imgBytes != null) {
                    img = Image.getInstance(imgBytes);
                }
                break;
            }
            info.Close();
            return img;
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    /**
     * 通用获取面积处理
     * @param db
     * @param tableName
     * @param fieldName
     * @return
     */
    protected static double getMj(SqlliteConnTool db, String tableName, String fieldName) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return 0;
            double area = 0;
            ResultSet set = result.getResultSet();
            if (StringUtils.isEmpty(fieldName))
                fieldName = "mj";
            while (set.next()) {
                double mj = set.getDouble(fieldName) * 666.6666;
                area += mj;
            }
            result.Close();
            return area;
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return 0;
    }

    //###########################以下为原有国家代码######################################
    public static void Parse(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "landtype_analyze"://地类分析
                    ParseLandType(db, tableName, info);
                    break;
                case "landtype_analyze_image":
                    ParseLandTypeImage(db, tableName, info);
                    break;
                case "ownership_analyze"://权属分析
                    ParseOwnerShip(db, tableName, info);
                    break;
                case "ownership_analyze_image":
                    ParseOwnerShipImage(db, tableName, info);
                    break;
                case "primefarm_analyze"://基本农田分析
                    ParsePrimeFarm(db, tableName, info);
                    break;
                case "primefarm_analyze_image":
                    ParsePrimeFarmImage(db, tableName, info);
                    break;
                case "plan_analyze"://规划分析
                    ParseTdgh(db, tableName, info);
                    break;
                case "plan_analyze_image":
                    ParseTdghImage(db, tableName, info);
                    break;
                case "spba_analyze"://审批备案分析
                    ParseSpba(db, tableName, info);
                    break;
                case "spba_analyze_image":
                    ParseSpbaImage(db, tableName, info);
                    break;
                case "naturereserve_analyze"://自然保护区分析
                    ParseZrbhq(db, tableName, info);
                    break;
                case "naturereserve_analyze_image":
                    ParseZrbhqImage(db, tableName, info);
                    break;
                case "dzfx_analyze"://地灾风险等级分析
                    ParseDzfx(db, tableName, info);
                    break;
                case "dzfx_analyze_image":
                    ParseDzfxImage(db, tableName, info);
                    break;
                case "ecologicalland_analyze"://生态用地分析
                    ParseEcologicalLand(db, tableName, info);
                    break;
                case "ecologicalland_analyze_image":
                    ParseEcologicalLandImage(db, tableName, info);
                    break;
                case "landprice_analyze"://基准地价分析
                    ParseLandPrice(db, tableName, info);
                    break;
                case "landprice_analyze_image":
                    ParseLandPriceImage(db, tableName, info);
                    break;
                case "aggregate_analyze":
                    ParseLandUseGrade(db, tableName, info);
                    break;
                case "aggregate_analyze_image":
                    ParseLandUseGradeImage(db, tableName, info);
                    break;
                case "image_analyze"://遥感影像分析
                    info.ownershipImgMeta = GetImageMeta(db,
                            "Image_Analyze");
                    break;
            }
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseLandType(SqlliteConnTool db, String tableName,
                                 ProjectInfo info) throws SQLException {
        try {
            if (info.landTypes == null) {
                info.landTypes = new ArrayList<LandType>();
            }
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                LandType land = new LandType();
                land.dlmc = set.getString("name");
                land.dlbm = set.getString("code");
                land.area = set.getDouble("mj") * 666.6666;
                info.landTypes.add(land);
            }
            Collections.sort(info.landTypes);
            Collections.reverse(info.landTypes);
            int count = 0;
            int leng = info.landTypes.size();
            String dlInfo = "";
            double otherArea = 0;
            for (LandType item : info.landTypes) {
                count++;
                if (count > 2) {
                    otherArea += item.area;
                } else {
                    dlInfo += item.dlmc + Round(item.area, 2) + "平方米";
                    if (count < leng) {
                        dlInfo += "/";
                    }
                }

            }
            if (otherArea > 0) {
                dlInfo += ("其他" + Round(otherArea, 2) + "平方米");
            }
            info.landtypeImgMeta = dlInfo;
            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

    }

    protected static void ParseLandTypeImage(SqlliteConnTool db, String tableName,
                                      ProjectInfo info) throws SQLException {
        Image img = GetImageByBlob(db, tableName, 0);
        info.landtypeImg = img;
    }

    protected static void ParseOwnerShip(SqlliteConnTool db, String tableName,
                                  ProjectInfo info) {
        try {
            if (info.ownerships == null) {
                info.ownerships = new ArrayList<Ownership>();
            }
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                Ownership owner = new Ownership();
                String code = set.getString("owner_dept_name");
                String name = set.getString("owner_dept_code");
                String jsonStr = set.getString("area_detail");
                double area = set.getDouble("mj") * 666.6666;

                OwnerDetailInfo detail = new OwnerDetailInfo(jsonStr);
                owner.qsmc = name;
                owner.qsdm = code;
                owner.area = area;
                owner.detail = detail;
                info.ownerships.add(owner);
            }
            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseOwnerShipImage(SqlliteConnTool db, String tableName,
                                       ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 1);
        info.ownershipImg = img;
    }

    protected static void ParsePrimeFarm(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            double area = 0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("type");
                if ("基本农田".equals(type)) {
                    double mj = set.getDouble("mj") * 666.6666;
                    area += mj;
                }
            }
            info.jbntArea = area;
            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParsePrimeFarmImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.jbntImg = img;
    }

    protected static void ParseTdgh(SqlliteConnTool db, String tableName,
                             ProjectInfo info) {
        try {

            if (info.tdghInfos == null) {
                info.tdghInfos = new ArrayList<TdghInfo>();
            }
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            ResultSet set = result.getResultSet();
            while (set.next()) {

                TdghInfo tdgh = new TdghInfo();
                tdgh.jsbm = set.getString("code");
                tdgh.jsmc = set.getString("type");
                tdgh.area = set.getDouble("mj") * 666.6666;
                info.tdghInfos.add(tdgh);
            }

            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

    }

    protected static void ParseTdghImage(SqlliteConnTool db, String tableName,
                                  ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.tdghImg = img;
    }

    protected static void ParseSpba(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select license_number, sum(mj) approval_mj from " + tableName + " group by license_number";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            ResultSet set = result.getResultSet();
            ArrayList<SpbaInfo> spbaArr = new ArrayList<SpbaInfo>();

            while (set.next()) {
                SpbaInfo spba = new SpbaInfo();
                spba.area = set.getDouble("approval_mj");
                String license = set.getString("license_number") + "";
                if (license == null || license.isEmpty()) {
                    license = "未知";
                }
                spba.license = license;
                spbaArr.add(spba);
            }
            info.spbaInfos = spbaArr;
            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseSpbaImage(SqlliteConnTool db, String tableName,
                                  ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.spbaImg = img;

    }

    protected static void ParseZrbhq(SqlliteConnTool db, String tableName,
                              ProjectInfo info) {
        try {

            String sql = "select sum(mj) from " + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = Double.valueOf(obj.toString());
                info.zrbhqArea = area;
            }
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

    }

    protected static void ParseZrbhqImage(SqlliteConnTool db, String tableName,
                                   ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.zrbhqImg = img;

    }

    protected static void ParseDzfx(SqlliteConnTool db, String tableName,
                             ProjectInfo info) {
        try {

            String sql = "select level,sum(area) area from " + tableName + " group by level";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            ResultSet set = result.getResultSet();
            ArrayList<DzfxInfo> dzfxArr = new ArrayList<DzfxInfo>();

            while (set.next()) {
                DzfxInfo dzfx = new DzfxInfo();
                dzfx.area = set.getDouble("area");
                String level = set.getString("level") + "";
                if (level == null || level.isEmpty()) {
                    level = "未知";
                }
                dzfx.level = level;
                dzfxArr.add(dzfx);
            }
            info.dzfxInfos = dzfxArr;
            result.Close();
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

    }

    protected static void ParseDzfxImage(SqlliteConnTool db, String tableName,
                                  ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.dzfxImg = img;

    }

    protected static void ParseEcologicalLand(SqlliteConnTool db, String tableName,
                                       ProjectInfo info) {
        try {

            String sql = "select sum(area) from" + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = Double.valueOf(obj.toString());
                info.sdArea = area;
            }
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

    }

    protected static void ParseEcologicalLandImage(SqlliteConnTool db, String tableName,
                                            ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.sdImg = img;

    }

    protected static void ParseLandPrice(SqlliteConnTool db, String tableName,
                                  ProjectInfo info) {
        try {
            String sql = "select sum(area) mj,sum(price) price from" + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null)
                return;
            ResultSet set = result.getResultSet();
            double mj = 0;
            double price = 0;
            while (set.next()) {
                mj = set.getDouble("mj") * 666.6666;
                price = set.getDouble("price");

            }
            info.landPrice = mj == 0 ? 0 : price / mj;
            result.Close();

        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }

    }

    protected static void ParseLandPriceImage(SqlliteConnTool db, String tableName,
                                       ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, 0);
        info.landPriceImg = img;
    }

    protected static void ParseLandUseGrade(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select content from " + tableName + " where analyze_name ='土地利用等别分析'";

            Object obj = db.queryScale(sql);
            if (obj == null) {
                return;
            }
            String jsonStr = obj.toString();
            List<LandUseGrade> detail = JSONArray.parseArray(jsonStr, LandUseGrade.class);
            if (detail != null) {
                for (LandUseGrade lg : detail) {
                    lg.field1 = lg.field1.replace(",", "-");
                }
            }
            info.gradeInfos = (ArrayList<LandUseGrade>) detail;

        } catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    protected static void ParseLandUseGradeImage(SqlliteConnTool db, String tableName,
                                          ProjectInfo info) {
        Image img = GetImageByBlob(db, tableName, "土地利用等别分析", 0);
        info.gradeImg = img;
    }

    protected static Image GetImageByBlob(SqlliteConnTool db, String tableName,String analyzeName,
                                   int imageType) {
        try {
            Image img = null;
            String sql = "select layer_pic from " + tableName
                    + " where analyze_name = '" + analyzeName +"' and image_subtype = " + imageType;
            ResultSetInfo info = db.doQuery(sql);
            if (info == null)
                return null;
            ResultSet set = info.getResultSet();
            while (set.next()) {

                byte[] imgBytes = set.getBytes("layer_pic");
                if (imgBytes != null) {
                    img = Image.getInstance(imgBytes);
                }
                break;
            }
            info.Close();
            return img;
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    public static String GetImageMeta(SqlliteConnTool db, String tableName) {
        String sql = "select meta_info from Image_Analyze where date is not null order by date desc limit 1";
        Object obj = db.queryScale(sql);
        if (obj == null)
            return null;
        String sjy = "";
        String sx = "";
        String jsonStr = obj.toString();
        JSONObject json = JSONObject.parseObject(jsonStr);
        if (json.containsKey("SJY")) {
            sjy = json.getString("SJY");
        }
        if (json.containsKey("SX")) {
            sx = json.getString("SX");
        }
        if (sjy == null || sjy.isEmpty()) {
            sjy = "未知";
        }
        if (sx == null || sx.isEmpty()) {
            sx = "未知";
        }
        String meta = "数据源：" + sjy + " 时相：" + sx;
        return meta;
    }

    public static double Round(double value, int count) {
        String formate = "#.";
        for (int i = 0; i < count; i++) {
            formate += "0";
        }
        String temp = new java.text.DecimalFormat(formate).format(value);
        return Double.parseDouble(temp);
    }
}
