package com.geoway.landteam.landcloud.service.thirddata.utils;

import org.apache.commons.codec.binary.Hex;
import org.springframework.util.Assert;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.security.MessageDigest;

/**
 * AES加密
 * Created by licong on 2021/6/24.
 */
public class SignUtil {

    public static String getSign(String url, String appSecret) {
        return aesEncrypt(md5For16(appSecret), url).hashCode()+"";
    }

    private static String aesEncrypt(String key, String src) {
        Assert.notNull(key, "参数有误");
        //"算法/模式/补码方式"
        Cipher cipher;
        byte[] encrypted;
        try {
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(key.getBytes(), "AES"));
            encrypted = cipher.doFinal(src.getBytes("utf-8"));
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return Hex.encodeHexString(encrypted);
    }

    private static String md5For16(String source){
        return md5For32(source).substring(8, 24);
    }

    private static String md5For32(String sourceStr) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");//1.初始化MessageDigest信息摘要对象,并指定为MD5不分大小写都可以
            md.update(sourceStr.getBytes());//2.传入需要计算的字符串更新摘要信息，传入的为字节数组byte[],将字符串转换为字节数组使用getBytes()方法完成
            byte[] bytes = md.digest();//3.计算信息摘要digest()方法,返回值为字节数组
            int i;
            StringBuilder buf = new StringBuilder();
            for (byte b : bytes) {
                i = b; //将首个元素赋值给i
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");//前面补0
                }
                buf.append(Integer.toHexString(i));//转换成16进制编码
            }
            return buf.toString();//转换成字符串
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

}
