package com.geoway.landteam.landcloud.service.thirddata.utils;


import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

import java.io.*;

/**
 * 共享文件夹操作工具类
 * Created by licong on 2021/5/24.
 */
public class SmbUtil {
    private GiLoger logger = GwLoger.getLoger(SmbUtil.class);

    public static void putFile(String path, String toPath) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            File localFile = new File(path);
            SmbFile remoteFile = connectFile(toPath);
            in = new BufferedInputStream(new FileInputStream(localFile));
            out = new BufferedOutputStream(new SmbFileOutputStream(remoteFile));

            byte[] buffer = new byte[4096];
            int len = 0; //读取长度
            while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush(); //刷新缓冲的输出流
        } catch (Exception e) {
           throw e;
        } finally {
            try {
                if(out != null) {
                    out.close();
                }
                if(in != null) {
                    in.close();
                }
            } catch (Exception e) {}
        }
    }

    /**
     * 从共享文件夹获取文件
     * @param path 共享文件路径
     * @param toPath 存储目录路径
     * @throws IOException
     */
    public static String getFile(String path, String toPath) throws IOException {
        InputStream in = null ;
        ByteArrayOutputStream out = null ;
        FileOutputStream fos = null;
        try {
            //创建远程文件对象
            SmbFile remoteFile = connectFile(path);
            //创建文件流
            in = new BufferedInputStream(new SmbFileInputStream(remoteFile));
            out = new ByteArrayOutputStream((int)remoteFile.length());
            //读取文件内容
            byte[] buffer = new byte[4096];
            int len = 0; //读取长度
            while ((len = in.read(buffer, 0, buffer.length)) != - 1) {
                out.write(buffer, 0, len);
            }
            out.flush(); //刷新缓冲的输出流

            File file = new File(toPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            File outFile = new File(toPath + File.separator + remoteFile.getName());//判断文件夹是否存在
            outFile.createNewFile();
            fos = new FileOutputStream(outFile);
            out.writeTo(fos);
            return toPath + File.separator + remoteFile.getName();
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if(out != null) {
                    out.close();
                }
                if(in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void deleteFile(String path) throws IOException {
        SmbFile file = connectFile(path);
        file.delete();
    }

    public static SmbFile connectFile(String path) throws IOException {
        SmbFile file = new SmbFile(path);
        file.connect(); //尝试连接
        return file;
    }
}
