package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;

/**
 * Created by zhuyuchen on 2021/10/22.
 */
public class ThumUtil {
    private GiLoger logger = GwLoger.getLoger(ThumUtil.class);
    /**
     * 生成服务缩略图
     *
     */
    public static void getThumImage(String fileUrl, String thumUrl, int width, int height, String imageName) {
        try {
            if (StringUtils.isBlank(fileUrl)) {
                return;
            }
            File file = new File(fileUrl);
            if(!file.canRead()) return;
            BufferedImage bufferedImage = ImageIO.read(file);
            if (null == bufferedImage) return;
            String suffix = StringUtils.substringAfterLast(file.getName(), ".");
            thumUrl = thumUrl+imageName;
            //处理png背景变黑问题
            if(suffix != null && (suffix.trim().toLowerCase().endsWith("png") || suffix.trim().toLowerCase().endsWith("gif"))){
                BufferedImage to= new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
                Graphics2D g2d = to.createGraphics();
                to = g2d.getDeviceConfiguration().createCompatibleImage(width, height, Transparency.TRANSLUCENT);
                g2d.dispose();
                //透明处理
                g2d = to.createGraphics();
                Image from = bufferedImage.getScaledInstance(width, height, Image.SCALE_AREA_AVERAGING);
                g2d.drawImage(from, 0, 0, null);
                g2d.dispose();
                //生成图片
                ImageIO.write(to, suffix, new File(thumUrl));
            }else {
                BufferedImage newImage = new BufferedImage(width, height, bufferedImage.getType());
                Graphics g = newImage.getGraphics();
                g.drawImage(bufferedImage, 0, 0, width, height, null);
                g.dispose();
                ImageIO.write(newImage, suffix, new File(thumUrl));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    public static void main(String[] args) {
//        String fileUrl = "E:/geoway_f/qqq.png";
//        String thumUrl = "E:/geoway_s/";
//        int width = 500;
//        int height = 500;
//        getThumImage(fileUrl, thumUrl, width, height, "www");
//    }
}
