package com.geoway.landteam.landcloud.service.thirddata.utils;


import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;


/***
 * zip压缩包操作类
 * 
 * @author Walt Chiang
 *
 */
public class ZipUtils {
	private ZipEntry zipEntry;

	private static int bufSize; // size of bytes

	private byte[] buf;

	private int readedBytes;
	private String rootDir;

	public ZipUtils() {
		this(512);
	}

	public ZipUtils(int bufSize) {
		this.bufSize = bufSize;
		this.buf = new byte[this.bufSize];
	}

	// -------------------------解压指定zip文件
	public void unZip(String unZipfileName) {// unZipfileName需要解压的zip文件名
		if (unZipfileName.endsWith(".zip")) {
			FileOutputStream fileOut;
			File file;
			String f = unZipfileName.substring(0, unZipfileName.length() - 4);
			String rootName = "";
			f = f.replaceAll("\\\\", "/");
			rootName = f.substring(f.lastIndexOf("/") + 1);
			File ff = new File(f);// f为减压后的存放目标文件夹
			try {
				File zipFile = new File(unZipfileName);
				if (zipFile.exists()) {
					// start----------------------------------------核心语句---------------------------------------
					ZipInputStream zipIn = new ZipInputStream(
							new BufferedInputStream(new FileInputStream(
									unZipfileName)));
					// end----------------------------------------核心语句---------------------------------------
					while ((this.zipEntry = zipIn.getNextEntry()) != null) {
						String path = this.zipEntry.getName();
						path = path.replaceAll("\\\\", "/");
						if (path.lastIndexOf("/") > -1) {
							path = path.substring(0, path.lastIndexOf("/"));
						} else {
							path = "";
						}
						path = path.replaceFirst(rootName, "");
						file = new File(this.zipEntry.getName());// zipEntry.getName()是文件在zip包中的全路径
						if (this.zipEntry.isDirectory()) {
							file.mkdirs();
						} else {// 如果指定文件的目录不存在,则创建之.
							File parent = file.getParentFile();
							if (parent != null && !parent.exists()) {
								parent.mkdirs();
							}
							if (!ff.exists()) {
								ff.mkdir();
							}
							File dir = null;
							if (StringUtils.isBlank(path))
								dir = new File(f);
							else
								dir = new File(f + "/" + path);
							if (!dir.exists()) {
								dir.mkdirs();
							}
							if (StringUtils.isEmpty(path))
								fileOut = new FileOutputStream(f + "/"
										+ file.getName());
							else
								fileOut = new FileOutputStream(f + "/" + path
										+ "/" + file.getName());
							while ((this.readedBytes = zipIn.read(this.buf)) > 0) {
								fileOut.write(this.buf, 0, this.readedBytes);
							}
							fileOut.close();
						}
						zipIn.closeEntry();
					}
					System.out.println("解压完成！");
				} else {
					System.err.println("zip文件不存在！");
				}
			} catch (Exception ioe) {
				ioe.printStackTrace();
			}

		} else {
			System.err.println("您选择的文件不是zip文件！");
		}

	}

	// -----------------压缩文件夹内的文件
	public void doZip(String zipDirectory) {// zipDirectoryPath:需要压缩的文件夹名
		File zipDir;
		zipDir = new File(zipDirectory);
		if (zipDir.exists()) {
			this.rootDir = zipDir.getName();
			String zipFileName = zipDirectory + ".zip";
			;// 压缩后生成的zip文件名
			if (zipDir.isFile()) {
				zipFileName = zipDirectory.substring(0,
						zipDirectory.indexOf("."))
						+ ".zip";
			}
			try {// 压缩zip的核心
				ZipOutputStream zipOut = new ZipOutputStream(
						new BufferedOutputStream(new FileOutputStream(
								zipFileName)));
				handleDir(zipDir, zipOut);
				zipOut.close();
				System.out.println("完成！");
			} catch (IOException e) {
				e.printStackTrace();
				System.out.println(" 请输入正确的文件路径！");
			}
		} else {
			System.err.println("您输入的文件路径不存在！");
		}
	}

	// -----------------------由doZip调用,递归完成目录文件读取
	private void handleDir(File dir, ZipOutputStream zipOut) throws IOException {
		FileInputStream fileIn = null;
		File[] files = null;
		if (dir.isDirectory()) {// 为文件夹
			files = dir.listFiles();// 子文件
			if (null != files && files.length == 0) {// 如果目录为空,则单独创建之.
				// ZipEntry的isDirectory()方法中,目录以"/"结尾. 注意文件夹的创建形式
				zipOut.putNextEntry(new ZipEntry(dir.toString() + "/"));
				zipOut.closeEntry();
			} else {// 如果目录不为空,则分别处理目录和文件.
				for (File fileName : files) {

					if (fileName.isDirectory()) {// 是文件夹
						handleDir(fileName, zipOut);
					} else {// 是文件
						try {
							fileIn = new FileInputStream(fileName);
							String name = dir.getName();
							String path = dir.getPath();
							path = path.substring(path.indexOf(this.rootDir));

							zipOut.putNextEntry(new ZipEntry(path + "/"
									+ fileName.getName().toString()));// 生成的压缩包存放在原目录下//ZipEntry类
							// 文件夹
							// +文件的名字
							while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
								zipOut.write(this.buf, 0, this.readedBytes);
							}
							zipOut.closeEntry();
						}catch (Exception e){
							e.printStackTrace();
						}finally {
							if(fileIn != null){
								try {
									fileIn.close();
								}catch (Exception e){
									e.printStackTrace();
								}
							}
						}
					}
				}
			}

		} else if (dir.isFile()) {// 为文件
			fileIn = new FileInputStream(dir);
			String name = dir.getName();
			String path = dir.getPath();
			zipOut.putNextEntry(new ZipEntry(dir.getName().toString()));// 生成的压缩包存放在原目录下//ZipEntry类
																		// 文件夹
																		// +文件的名字
			while ((this.readedBytes = fileIn.read(this.buf)) > 0) {
				zipOut.write(this.buf, 0, this.readedBytes);
			}
			zipOut.closeEntry();
		}

	}

	public boolean decompressZip(String zipPath, String descDir) throws Exception {
		File zipFile = new File(zipPath);
		boolean flag = false;
		File pathFile = new File(descDir);
		if(!pathFile.exists()){
			pathFile.mkdirs();
		}
		ZipFile zip = null;
		try {
//			Charset gbk = Charset.forName("GBK");
			zip = new ZipFile(zipFile);//防止中文目录，乱码
			for(Enumeration entries = zip.entries(); entries.hasMoreElements();){
				ZipEntry entry = (ZipEntry)entries.nextElement();
				String zipEntryName = entry.getName();
				InputStream in = zip.getInputStream(entry);
				//指定解压后的文件夹+当前zip文件的名称
				String outPath = (descDir+zipEntryName).replace("/", File.separator);
				//判断路径是否存在,不存在则创建文件路径
				File file = new File(outPath.substring(0, outPath.lastIndexOf(File.separator)));
				if(!file.exists()){
					file.mkdirs();
				}
				//判断文件全路径是否为文件夹,如果是上面已经上传,不需要解压
				if(new File(outPath).isDirectory()){
					continue;
				}
				//保存文件路径信息（可利用md5.zip名称的唯一性，来判断是否已经解压）
//				System.err.println("当前zip解压之后的路径为：" + outPath);
				OutputStream out = new FileOutputStream(outPath);
				byte[] buf1 = new byte[2048];
				int len;
				while((len=in.read(buf1))>0){
					out.write(buf1,0,len);
				}
				in.close();
				out.close();
			}
			flag = true;
			//必须关闭，要不然这个zip文件一直被占用着，要删删不掉，改名也不可以，移动也不行，整多了，系统还崩了。
			zip.close();
		} finally {
			if (zip != null) {
				try {
					zip.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return flag;

	}

	public void zipFiles(List<File> srcFiles, File zipFile) {
		// 判断压缩后的文件存在不，不存在则创建
		if (!zipFile.exists()) {
			try {
				zipFile.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		// 创建 FileOutputStream 对象
		FileOutputStream fileOutputStream = null;
		// 创建 ZipOutputStream
		ZipOutputStream zipOutputStream = null;
		// 创建 FileInputStream 对象
		FileInputStream fileInputStream = null;

		try {
			// 实例化 FileOutputStream 对象
			fileOutputStream = new FileOutputStream(zipFile);
			// 实例化 ZipOutputStream 对象
			zipOutputStream = new ZipOutputStream(fileOutputStream);
			// 创建 ZipEntry 对象
			ZipEntry zipEntry = null;
			// 遍历源文件数组
			for (int i = 0; i < srcFiles.size(); i++) {
				// 将源文件数组中的当前文件读入 FileInputStream 流中
				fileInputStream = new FileInputStream(srcFiles.get(i));
				// 实例化 ZipEntry 对象，源文件数组中的当前文件
				zipEntry = new ZipEntry(srcFiles.get(i).getName());
				zipOutputStream.putNextEntry(zipEntry);
				// 该变量记录每次真正读的字节个数
				int len;
				// 定义每次读取的字节数组
				byte[] buffer = new byte[1024];
				while ((len = fileInputStream.read(buffer)) > 0) {
					zipOutputStream.write(buffer, 0, len);
				}
			}
			zipOutputStream.closeEntry();

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				fileInputStream.close();
				zipOutputStream.close();
				fileOutputStream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
}
