package com.geoway.landteam.landcloud.service.tieta;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.landteam.landcloud.model.tieta.dto.*;
import com.geoway.landteam.landcloud.model.tieta.entity.TbCameraInfo;
import com.geoway.landteam.landcloud.model.tieta.paramter.CameraParamter;
import com.geoway.landteam.landcloud.model.tieta.paramter.PtzControlParamter;
import com.geoway.landteam.landcloud.model.tieta.paramter.QueryParameter;
import com.geoway.landteam.landcloud.model.tieta.paramter.TreeCodeParamter;
import com.geoway.landteam.landcloud.repository.tieta.TbCameraInfoRepository;
import com.geoway.landteam.landcloud.servface.tieta.TietaService;
import com.geoway.landteam.landcloud.service.zhdd.TbtskDispatchServiceImpl;
import com.google.gson.Gson;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.hikvision.artemis.sdk.constant.Constants;
import org.apache.commons.lang3.ObjectUtils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.net.URL;
import java.net.MalformedURLException;
import static org.apache.hadoop.util.VersionInfo.getUrl;

/**
 * @Author: xumingjie
 * @Date: 2025/4/3 14:41
 * @Description: TODO
 */
@Service
public class TietaServiceImpl implements TietaService {
    private final GiLoger logger = GwLoger.getLoger(TietaServiceImpl.class);

    private static final String API_URL = "https://10.6.220.20:1443/artemis";

    @Value("${artemis.appKey}")
//    private String appKey = "20996503";
    private String appKey;

    @Value("${artemis.appSecret}")
//    private String appSecret = "ADQRnTIEX0uGbfwoQjcu";
    private String appSecret;

    @Value("${artemis.host}")
//    private String host = "10.6.220.20:1443";
//    private String host = "116.131.157.98:8085";
    private String host;

//    private static final String ARTEMIS_PATH = "/artemis";
    @Value("${artemis.path}")
    private String artemisPath;

    @Value("${artemis.httpProtocol}")
    private String httpProtocol;

    @Autowired
    JdbcTemplate jdbcTemplate;


    @Autowired
    TbCameraInfoRepository tbCameraInfoRepository;

    /**
     * 根据需求调整超时时间
     */
    static {
        //连接超时时间
        Constants.DEFAULT_TIMEOUT = 10000;
        //读取超时时间
        Constants.SOCKET_TIMEOUT = 60000;
    }

    //1.1.4.1分页获取监控点资源
    public GetCamerasResponseDTO getCamerasData(CameraParamter cameraParamter) throws Exception {

        if (ObjectUtils.isEmpty(cameraParamter)) {
            return null;
        }

        Gson gson = new Gson();
        String body = gson.toJson(cameraParamter);

        final String getCamsApi = "/api/resource/v1/cameras";
        GetCamerasResponseDTO getCamerasResponseDTO = executeArtemisRequest(getCamsApi, body, GetCamerasResponseDTO.class);

        if (ObjectUtils.isNotEmpty(getCamerasResponseDTO) && getCamerasResponseDTO.getCode().equals("0")) {
            return getCamerasResponseDTO;
        }

        return null;
    }


    public TalkURLResponseDTO getEncodingDevices(String cameraIndexCode) throws Exception {

        if (StringUtils.isEmpty(cameraIndexCode)) {
            return null;
        }

        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("cameraIndexCode", cameraIndexCode);
        paramMap.put("protocol", "hls");
        String body = JSON.toJSON(paramMap).toString();

        final String getCamsApi = "/api/video/v1/cameras/previewURLs";
        TalkURLResponseDTO talkURLResponseDTO = executeArtemisRequest(getCamsApi, body, TalkURLResponseDTO.class);

        if (ObjectUtils.isNotEmpty(talkURLResponseDTO) && talkURLResponseDTO.getCode().equals("0")) {
            // 用代理地址和端口 替换 真实地址和端口
            if(ObjectUtils.isNotEmpty(talkURLResponseDTO.getData()) && StringUtils.isNotBlank(talkURLResponseDTO.getData().getUrl())){
                String originalUrl = talkURLResponseDTO.getData().getUrl();
                URL url = new URL(originalUrl);
                if(StringUtils.isNotBlank(host)){
                    String originalHostAndPort = url.getHost() + ":" + url.getPort(); // 获取真实主机和端口
                    // 直接替换URL字符串
                    String newUrl = originalUrl.replace(originalHostAndPort, host);
                    talkURLResponseDTO.getData().setUrl(newUrl);
                }
            }
            return talkURLResponseDTO;
        }

        return null;
    }


    public FaceLibResponseDTO getFaceDB(String personLibIds) throws Exception {

        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("personLibIds", personLibIds);
        String body = JSON.toJSON(paramMap).toString();

        final String getCamsApi = "/api/aiapplication/v2/face/faceLib/getPersonLib";
        FaceLibResponseDTO faceLibResponseDTO = executeArtemisRequest(getCamsApi, body, FaceLibResponseDTO.class);

        if (ObjectUtils.isNotEmpty(faceLibResponseDTO) && faceLibResponseDTO.getCode().equals("0")) {
            return faceLibResponseDTO;
        }

        return null;
    }


    public TreeCodeResponseDTO getAllTreeCode(TreeCodeParamter treeCodeParamter) throws Exception {

        if (ObjectUtils.isEmpty(treeCodeParamter)) {
            return null;
        }
        Gson gson = new Gson();
        String body = gson.toJson(treeCodeParamter);

        final String getCamsApi = "/api/aiapplication/v2/face/queryPersonByAttrWithPage";
        TreeCodeResponseDTO treeCodeResponseDTO = executeArtemisRequest(getCamsApi, body, TreeCodeResponseDTO.class);

        if (ObjectUtils.isNotEmpty(treeCodeResponseDTO) && treeCodeResponseDTO.getCode().equals("0")) {
            return treeCodeResponseDTO;
        }

        return null;
    }



    public RootRegionResponseDTO getRootRegion(String treeCode) throws Exception {

        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("treeCode", treeCode);
        String body = JSON.toJSON(paramMap).toString();

        final String getCamsApi = "/api/resource/v1/regions/root";
        RootRegionResponseDTO rootRegionResponseDTO = executeArtemisRequest(getCamsApi, body, RootRegionResponseDTO.class);

        if (ObjectUtils.isNotEmpty(rootRegionResponseDTO) && rootRegionResponseDTO.getCode().equals("0")) {
            return rootRegionResponseDTO;
        }

        return null;
    }

    public RootRegionResponseDTO getSubRegion(String parentIndexCode, String treeCode) throws Exception {

        if(StringUtils.isBlank(parentIndexCode)){
            return null;
        }
        Map<String, String> paramMap = new HashMap<>();
        paramMap.put("parentIndexCode", parentIndexCode);
        paramMap.put("treeCode", treeCode);
        String body = JSON.toJSON(paramMap).toString();

        final String getCamsApi = "/api/resource/v1/regions/subRegions";
        RootRegionResponseDTO rootRegionResponseDTO = executeArtemisRequest(getCamsApi, body, RootRegionResponseDTO.class);

        if (ObjectUtils.isNotEmpty(rootRegionResponseDTO) && rootRegionResponseDTO.getCode().equals("0")) {
            return rootRegionResponseDTO;
        }

        return null;
    }

//    1.1.1.3根据监控点编号进行云台操作
    public PtzControlResponseDTO setPtzControl(PtzControlParamter ptzControlParamter) throws Exception {

        if(ObjectUtils.isEmpty(ptzControlParamter) || StringUtils.isBlank(ptzControlParamter.getCameraIndexCode())){
            return null;
        }
        Gson gson = new Gson();
        String body = gson.toJson(ptzControlParamter);

        final String getCamsApi = "/api/video/v1/ptzs/controlling";
        PtzControlResponseDTO ptzControlResponseDTO = executeArtemisRequest(getCamsApi, body, PtzControlResponseDTO.class);

        if (ObjectUtils.isNotEmpty(ptzControlResponseDTO) && ptzControlResponseDTO.getCode().equals("0")) {
            return ptzControlResponseDTO;
        }
        return null;
    }

//  1.1.3.5获取所属行政区域
    public LocationResponseDTO getrRegionByLonLat(String lon,String lat )  throws Exception {
        if(StringUtils.isBlank(lon) || StringUtils.isBlank(lat)){
            return null;
        }

        Map<String, String> paramMap = new HashMap<String, String>();// post请求Form表单参数
        paramMap.put("latitude", lat);
        paramMap.put("longitude", lon);
        String body = JSON.toJSON(paramMap).toString();

        final String getCamsApi = "/api/iland/v1/place/location";
        LocationResponseDTO locationResponseDTO = executeArtemisRequest(getCamsApi, body, LocationResponseDTO.class);
        if(ObjectUtils.isNotEmpty(locationResponseDTO) && locationResponseDTO.getCode().equals("0")){
            return locationResponseDTO;
        }
        return null;
    }

    /*public void createCamerasToDB(){
        Integer pageIndex = 1;
        Integer pageSize = 1000;
        Integer total = 0;
        CameraParamter cameraParamter = new CameraParamter();
        cameraParamter.setPageNo(pageIndex);
        cameraParamter.setPageSize(pageSize);
        cameraParamter.setTreeCode("0");
        try {
//            获取监控点资源
            GetCamerasResponseDTO camerasResponseDTO = getCamerasData(cameraParamter);
            if(ObjectUtils.isNotEmpty(camerasResponseDTO)){
                CamerasData camerasData =  camerasResponseDTO.getData();
                if (ObjectUtils.isNotEmpty(camerasData)) {
                    total = camerasData.getTotal();
                    List<CameraInfo> cameraInfoList = camerasData.getList();
                    for (CameraInfo cameraInfo : cameraInfoList) {

                        String placeCode = ""; // 行政区划编码
                        String placeName = ""; // 行政区划全称（市县镇）
//                        获取所属行政区域L
                        if(StringUtils.isNotBlank(cameraInfo.getLatitude()) &&
                                StringUtils.isNotBlank(cameraInfo.getLongitude()) ){
                            LocationResponseDTO locationResponseDTO = getrRegionByLonLat(cameraInfo.getLongitude(),cameraInfo.getLatitude());
                            if(ObjectUtils.isNotEmpty(locationResponseDTO) && locationResponseDTO.getCode().equals("0")){
                                LocationData locationData = locationResponseDTO.getData();
                                placeCode = locationData.getPlaceCode();
                                placeName = locationData.getPlaceName();
                            }
                        }

                        String sql = "INSERT INTO camera_info (camera_index_code, gb_index_code, name, device_index_code, longitude, " +
                                "latitude, altitude, pixel, camera_type, camera_type_name, install_place, matrix_code, chan_num, " +
                                "viewshed, capability_set, capability_set_name, intelligent_set, intelligent_set_name, " +
                                "record_location, record_location_name, ptz_controller, ptz_controller_name, device_resource_type, " +
                                "device_resource_type_name, channel_type, channel_type_name, trans_type, trans_type_name, update_time, " +
                                "unit_index_code, treaty_type, treaty_type_name, create_time, status, status_name,xzqh_code) " +
                                "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";

                        jdbcTemplate.update(sql,
                                cameraInfo.getCameraIndexCode(),
                                cameraInfo.getGbIndexCode(),
                                cameraInfo.getName(),
                                cameraInfo.getDeviceIndexCode(),
                                cameraInfo.getLongitude(),
                                cameraInfo.getLatitude(),
                                cameraInfo.getAltitude(),
                                cameraInfo.getPixel(),
                                cameraInfo.getCameraType(),
                                cameraInfo.getCameraTypeName(),
                                cameraInfo.getInstallPlace(),
                                cameraInfo.getMatrixCode(),
                                cameraInfo.getChanNum(),
                                cameraInfo.getViewshed(),
                                cameraInfo.getCapabilitySet(),
                                cameraInfo.getCapabilitySetName(),
                                cameraInfo.getIntelligentSet(),
                                cameraInfo.getIntelligentSetName(),
                                cameraInfo.getRecordLocation(),
                                cameraInfo.getRecordLocationName(),
                                cameraInfo.getPtzController(),
                                cameraInfo.getPtzControllerName(),
                                cameraInfo.getDeviceResourceType(),
                                cameraInfo.getDeviceResourceTypeName(),
                                cameraInfo.getChannelType(),
                                cameraInfo.getChannelTypeName(),
                                cameraInfo.getTransType(),
                                cameraInfo.getTransTypeName(),
                                cameraInfo.getUpdateTime(),
                                cameraInfo.getUnitIndexCode(),
                                cameraInfo.getTreatyType(),
                                cameraInfo.getTreatyTypeName(),
                                cameraInfo.getCreateTime(),
                                cameraInfo.getStatus(),
                                cameraInfo.getStatusName(),
                                placeCode
                        );
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }*/



    // 调用摄像头数据并插入数据库
    public void startCameraImport() throws Exception {
        AtomicInteger processedCount = new AtomicInteger(0);
        // 先清空库数据
        jdbcTemplate.execute("delete from tb_camera_info ");
        // 初始页码为1，每页1000条数据，总记录数初始为0
        createCamerasToDBRecursive(1, 1000, 0, processedCount);

        // 执行更新空间数据f_shape
        jdbcTemplate.execute("UPDATE tb_camera_info SET f_shape = ST_SetSRID(ST_MakePoint(longitude, latitude), 4490)  ");
    }

    @Override
    public Pair<Long, List<TbCameraInfo>> queryTbCameraInfoForList(QueryParameter param) throws Exception {
        if (ObjectUtils.isEmpty(param.getPage())) {
            param.setPage(1);
        }
        if (ObjectUtils.isEmpty(param.getRows())) {
            param.setRows(20);
        }

        Integer offset =  (param.getPage() - 1) * param.getRows();

        List<TbCameraInfo> tbCameraInfos = null;
        Long count = 0l;
        if(ObjectUtils.isNotEmpty(param.getLat()) && ObjectUtils.isNotEmpty(param.getLon()) && ObjectUtils.isNotEmpty(param.getMetre())){
            tbCameraInfos =  tbCameraInfoRepository.findByNearParameter(param.getName(),param.getStatus(),param.getRows(),offset,param.getLon(),param.getLat(),param.getMetre());
            count = tbCameraInfoRepository.findCountByNearParameter(param.getName(),param.getStatus(),param.getLon(),param.getLat(),param.getMetre());
        } else {
            tbCameraInfos =  tbCameraInfoRepository.findByParameter(param.getName(),param.getStatus(),param.getRows(),offset);
            count = tbCameraInfoRepository.findCountByParameter(param.getName(),param.getStatus());
        }
        return Pair.of(count, tbCameraInfos);
    }


    //获取铁塔全部数据
    public Pair<Long, List<TbCameraInfo>> queryAllList() throws Exception {
        List<TbCameraInfo> tbCameraInfos =  tbCameraInfoRepository.findAllList();
        Long count = tbCameraInfoRepository.findAllCount();
        return Pair.of(count, tbCameraInfos);
    }


    // 周边查找铁塔数据
    public List<TbCameraInfo> queryNearList(Double lon, Double lat, Integer metre) throws Exception {
        List<TbCameraInfo> cameraInfoList = null;
        if(ObjectUtils.isNotEmpty(lon) && ObjectUtils.isNotEmpty(lat) && ObjectUtils.isNotEmpty(metre)){
            cameraInfoList = tbCameraInfoRepository.findNearList(lon,lat,metre);
        }
        return cameraInfoList;
    }

    @Override
    public TbCameraInfo queryTbCameraInfoById(String id) {
        TbCameraInfo tbCameraInfo = null;
        if(StringUtils.isNotBlank(id)){
            tbCameraInfo = tbCameraInfoRepository.findTbCameraInfoById(id);
        }
        return tbCameraInfo;
    }


    public Pair<List<Map<String,Object>>, List<Map<String,Object>>> statisticsTieta(String xzqhCode){
        String sql = "";
//        sql = " select substring(xzqh_code,0,7), count(1) from tb_camera_info where xzqh_code is not null and xzqh_code <> '' group by substring(xzqh_code,0,7) ";
        sql = " select tb.f_xzqdm, tb.f_centerx, tb.f_centery, tt.num from tb_region tb, (select substring(xzqh_code,0,7) as xzqdm, count(1) as num from tb_camera_info where xzqh_code is not null and xzqh_code <> '' group by substring(xzqh_code,0,7)) tt where tb.f_xzqdm = tt.xzqdm ";
        List<Map<String,Object>> mapList  = jdbcTemplate.queryForList(sql);

        sql = "select status, count(1) from tb_camera_info where status is not null and status <> '' group by status ";
        List<Map<String,Object>> statusMapLists = jdbcTemplate.queryForList(sql);
        if(ObjectUtils.isNotEmpty(statusMapLists)){
            boolean onLine = false;
            boolean offLine = false;
            for (Map map : statusMapLists){
                String key = (String) map.get("status");
                if(key.equals("1")){
                    map.put("status","在线");
                    onLine = true;
                }
                if(key.equals("0")){
                    map.put("status","离线");
                    offLine = true;
                }
            }
            if(!onLine){
                Map<String,Object> map = new HashMap<>();
                map.put("status","在线");
                map.put("count",0);
                statusMapLists.add(map);
            }
            if(!offLine){
                Map<String,Object> map = new HashMap<>();
                map.put("status","离线");
                map.put("count",0);
                statusMapLists.add(map);
            }
        }

        return Pair.of(mapList,statusMapLists);
    }

    /**
     * 递归方法，分页获取摄像头数据并插入数据库
     *
     * @param pageIndex 当前页码
     * @param pageSize  每页大小
     * @param total     总记录数 (第一次调用时传入 0)
     * @param processedCount 已处理总数
     */
    public void createCamerasToDBRecursive(int pageIndex, int pageSize, int total, AtomicInteger processedCount) throws Exception {
        if(total > 0 && processedCount.get() >= total){
            System.out.println("摄像头数据导入完成,总数：" + total);
            return;
        }
        CameraParamter cameraParamter = new CameraParamter();
        cameraParamter.setPageNo(pageIndex);
        cameraParamter.setPageSize(pageSize);
        cameraParamter.setTreeCode("0");
        try {
            // 获取监控点资源
            GetCamerasResponseDTO camerasResponseDTO = getCamerasData(cameraParamter);
            if (ObjectUtils.isNotEmpty(camerasResponseDTO)) {
                CamerasData camerasData = camerasResponseDTO.getData();
                if (ObjectUtils.isNotEmpty(camerasData)) {
                    // 首次调用赋值total
                    if(total == 0){
                        total = camerasData.getTotal();
                    }
                    List<CameraInfo> cameraInfoList = camerasData.getList();
                    if (ObjectUtils.isEmpty(cameraInfoList)) {
                        System.out.println("当前页没有数据，pageIndex:" + pageIndex);
                        return;
                    }

                    for (CameraInfo cameraInfo : cameraInfoList) {
                        String placeCode = ""; // 行政区划编码
                        String placeName = ""; // 行政区划全称（市县镇）
                        // 获取所属行政区域
                        if (ObjectUtils.isNotEmpty(cameraInfo.getLatitude()) &&
                                ObjectUtils.isNotEmpty(cameraInfo.getLongitude())) {
                            LocationResponseDTO locationResponseDTO = getrRegionByLonLat(cameraInfo.getLongitude()+"", cameraInfo.getLatitude()+""); // Corrected method name
                            if (ObjectUtils.isNotEmpty(locationResponseDTO) && locationResponseDTO.getCode().equals("0")) {
                                Object data = locationResponseDTO.getData();
                                if(ObjectUtils.isNotEmpty(data)){
                                    Map<String,String> map = (Map<String,String>)data;
                                    placeCode = map.get("placeCode");
                                    placeName = map.get("placeName");
                                }
                            }
                        }

                        String sql = "INSERT INTO tb_camera_info (camera_index_code, gb_index_code, name, device_index_code, longitude, " +
                                "latitude, altitude, pixel, camera_type, camera_type_name, install_place, matrix_code, chan_num, " +
                                "viewshed, capability_set, capability_set_name, intelligent_set, intelligent_set_name, " +
                                "record_location, record_location_name, ptz_controller, ptz_controller_name, device_resource_type, " +
                                "device_resource_type_name, channel_type, channel_type_name, trans_type, trans_type_name, update_time, " +
                                "unit_index_code, treaty_type, treaty_type_name, create_time, status, status_name,is_cascade,external_index_code, ptz_controller_set_name, record_location_set_name, xzqh_code) " +
                                "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

                        jdbcTemplate.update(sql,
                                cameraInfo.getCameraIndexCode(),
                                cameraInfo.getGbIndexCode(),
                                cameraInfo.getName(),
                                cameraInfo.getDeviceIndexCode(),
                                cameraInfo.getLongitude(),
                                cameraInfo.getLatitude(),
                                cameraInfo.getAltitude(),
                                cameraInfo.getPixel(),
                                cameraInfo.getCameraType(),
                                cameraInfo.getCameraTypeName(),
                                cameraInfo.getInstallPlace(),
                                cameraInfo.getMatrixCode(),
                                cameraInfo.getChanNum(),
                                cameraInfo.getViewshed(),
                                cameraInfo.getCapabilitySet(),
                                cameraInfo.getCapabilitySetName(),
                                cameraInfo.getIntelligentSet(),
                                cameraInfo.getIntelligentSetName(),
                                cameraInfo.getRecordLocation(),
                                cameraInfo.getRecordLocationName(),
                                cameraInfo.getPtzController(),
                                cameraInfo.getPtzControllerName(),
                                cameraInfo.getDeviceResourceType(),
                                cameraInfo.getDeviceResourceTypeName(),
                                cameraInfo.getChannelType(),
                                cameraInfo.getChannelTypeName(),
                                cameraInfo.getTransType(),
                                cameraInfo.getTransTypeName(),
                                cameraInfo.getUpdateTime(),
                                cameraInfo.getUnitIndexCode(),
                                cameraInfo.getTreatyType(),
                                cameraInfo.getTreatyTypeName(),
                                cameraInfo.getCreateTime(),
                                cameraInfo.getStatus(),
                                cameraInfo.getStatusName(),
                                cameraInfo.getIsCascade(),
                                cameraInfo.getExternalIndexCode(),
                                cameraInfo.getPtzControllerSetName(),
                                cameraInfo.getRecordLocationSetName(),
                                placeCode
                        );
                        processedCount.incrementAndGet();
                        System.out.println("当前处理第：" +processedCount.get() + "条， 总数：" + total );
                    }
                    // 递归调用，处理下一页
                    createCamerasToDBRecursive(pageIndex + 1, pageSize, total, processedCount);
                } else {
                    System.out.println("CamerasData is empty");
                }
            } else {
                System.out.println("CamerasResponseDTO is empty");
            }
        } catch (Exception e) {
            logger.error("铁塔数据第{}条、入库失败：{}", pageIndex, e.getMessage());
            System.err.println("Error processing page " + pageIndex + ": " + e.getMessage());
            e.printStackTrace(); // 打印更详细的错误信息
        }
    }




    /**
     * 封装 Artemis 调用方法
     *
     * @param apiPath  Artemis 接口路径
     * @param body     请求体
     * @param responseType 返回值类型
     * @param <T>      返回值类型泛型
     * @return 解析后的对象
     * @throws Exception 调用或解析失败时抛出异常
     */
    private <T> T executeArtemisRequest(String apiPath, String body, Class<T> responseType) throws Exception {

        ArtemisConfig config = new ArtemisConfig();
        config.setHost(host);
        config.setAppKey(appKey);
        config.setAppSecret(appSecret);

        Map<String, String> path = new HashMap<String, String>(2) {{
            put(httpProtocol+"://", artemisPath + apiPath);
        }};

        String result = ArtemisHttpUtil.doPostStringArtemis(config, path, body, null, null, "application/json");

        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readValue(result, responseType);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("铁塔接口调用{}解析失败：{}", apiPath, result);
            throw new Exception("铁塔接口调用" + apiPath + "解析失败");
        }
    }
}
