package com.geoway.landteam.landcloud.service.uis.impl;


import cn.hutool.core.bean.BeanUtil;

import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserUpdateInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.*;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.user.OrganizationService;
import com.geoway.landteam.landcloud.core.service.base.ApplicationCodeService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
 import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.dao.uis.TbSyncUisNodeDao;
import com.geoway.landteam.landcloud.model.uis.dto.SyncUisNodeDTO;
import com.geoway.landteam.landcloud.model.uis.entity.SyncUisData;
import com.geoway.landteam.landcloud.model.uis.entity.TbSyncNode;
import com.geoway.landteam.landcloud.servface.uis.SyncUisService;
import com.geoway.landteam.landcloud.service.jms.constant.ActiveMQConstant;
import com.geoway.landteam.landcloud.service.jms.send.ProducerService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;

import com.alibaba.fastjson.JSONObject;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author zkn
 * @date 2021年07月23日
 */

@Service
public class SyncUisServiceImpl implements SyncUisService {
    private static final GiLoger log= GwLoger.getLoger();
    private final static String QUEUE_PRE_FIX = "SYNCUIS";
    protected String appkeys;
    @Resource
    ProducerService producerService;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    TbSyncUisNodeDao tbSyncUisNodeDao;
    @Resource
    UserApplicationRepository userApplicationDao;
    @Resource
    UisApplicationRepository UisApplicationDao;
    @Autowired
    UserBizSupervisionRepository userBizSupervisionDao;
    @Resource
    LandUserRepository landUserDao;
    @Resource
    OrganizationRepository organizationRepository;
  /*  @Autowired
    UserBizDao userBizRepository;*/
    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;
    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;
    @Resource
    Organization2UserRepository organization2UserRepository;
    @Autowired
    ApplicationCodeService applicationCodeService;
    @Autowired
    OrganizationService organizationService;

    @Autowired
    LandUserService landUserService;
    @Resource
    LandUser2AreaRepository landUser2AreaDao;
    protected boolean enableSync;
    protected String appkey;


    @Override
    public Map nodeRegister(SyncUisNodeDTO syncUisNodeDTO, long userId) {
        GutilAssert.notNull(syncUisNodeDTO, "parameter 'syncUisNodeDTO' must not be null .");
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("error", StringUtils.EMPTY);

        TbSyncNode node = new TbSyncNode();
        BeanUtil.copyProperties(syncUisNodeDTO, node, true);
        try {
            if (StringUtils.isBlank(node.getNodeAppKey()) ||
                    StringUtils.isBlank(node.getNodeFilter())) {
                retVal.put("error", "同步节点的appkey或filter不能为空。");
                return retVal;
            }
            int count = tbSyncUisNodeDao.create(node);
            if (count == 1) {
                retVal.put("result", true);
            }
        } catch (Exception e) {
            retVal.put("error", e.getMessage());
        }
        return retVal;
    }

    @Override
    public void publishSyncMsg(SyncUisData data, String regionFiler) {
        enableSync = (Boolean) ProjectConfig.getConfig(ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!enableSync) {
            return;
        }
        GutilAssert.notNull(data, "parameter 'data' must not be null .");

        List<TbSyncNode> syncNodeList = tbSyncUisNodeDao.queryAll();
        if (!GutilCollection.isEmpty(syncNodeList)) {
            for (TbSyncNode node : syncNodeList) {
                try {
//                    if (StringUtils.isBlank(regionFiler)) {
//                        // 为空时，发送广播消息
//                    } else {
//                        if (regionFiler.length() > 2) {
//                            regionFiler = regionFiler.substring(0, 2);
//                        }
//                        String nodeRegion = node.getNodeFilter().length() >= 2 ?
//                                node.getNodeFilter().substring(0, 2) : node.getNodeFilter();
//                        if (!regionFiler.equalsIgnoreCase(nodeRegion)) {
//                            continue;
//                        }
//                    }

                    String queueName = getQueueName(node);
                    String content = JSONObject.toJSONString(data).toString();
                    log.info("发送同步消息队列名称：" + queueName + " 内容：" + content);
                    byte[] bytes = content.getBytes();
                    //producerService.sendMessage(queueName, bytes);
                    Map<String, Object> map = new HashMap<>();
                    map.put(ActiveMQConstant.SERVICE_NAME, "SYNCUIS-RECEIVE-MESSAGE");
                    map.put("data", bytes);
                    producerService.sendMapMessage2Queue(map, queueName);
                } catch (Exception e) {
                    log.error("发送同步消息异常：", e);
                }
            }
        }
    }

    @Override
    public void publishSyncMsgNew(JSONObject data, String regionFiler) {
        enableSync = (Boolean) ProjectConfig.getConfig(ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!enableSync) {
            return;
        }
        GutilAssert.notNull(data, "parameter 'data' must not be null .");

        List<TbSyncNode> syncNodeList = tbSyncUisNodeDao.queryAll();
        if (!GutilCollection.isEmpty(syncNodeList)) {
            for (TbSyncNode node : syncNodeList) {
                try {
                    String queueName = getQueueName(node);
                    String content = JSONObject.toJSONString(data).toString();
                    log.info("发送同步消息队列名称：" + queueName + " 内容：" + content);
                    byte[] bytes = content.getBytes();
                    //producerService.sendMessage(queueName, bytes);
                    Map<String, Object> map = new HashMap<>();
                    map.put(ActiveMQConstant.SERVICE_NAME, "SYNCUIS-RECEIVE-MESSAGE");
                    map.put("data", bytes);
                    producerService.sendMapMessage2Queue(map, queueName);
                } catch (Exception e) {
                    log.error("发送同步消息异常：", e);
                }
            }
        }
    }

    @Override
    public void subscribeSyncMsgNew(JSONObject data) throws Exception {
        enableSync = (Boolean) ProjectConfig.getConfig(ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!enableSync) {
            return;
        }
        if (data != null) {
            if (data.get("type").equals("insert")) {
                Object bean = JSONObject.toJavaObject(data.getJSONObject("userInfo"), UserAddInfo.class);
                Object organizationBean = JSONObject.toJavaObject(data.getJSONObject("organization"), Organization.class);
                if (bean != null) {
                    try {
                        UserAddInfo userAddInfo = (UserAddInfo) bean;
                        if (organizationBean != null) {
                            Organization organization = (Organization) organizationBean;
                            if (organization != null) {  //校验单位是否存在，不存在进行新增
                                Organization organizations = organizationRepository.queryByNameAndRegion(organization.getName(), organization.getRegionCode());
                                if (organizations == null) {  //没有单位，新增单位
                                    Organization org = organizationService.create(organization.getName(), organization.getRegionCode(), null, null, organization.getType());
                                    userAddInfo.setDepNo(org.getId());
                                } else {
                                    userAddInfo.setDepNo(organizations.getId());
                                }
                            }
                        }
                        userAddInfo.setId(null);
                        processSyncDataNew(userAddInfo);
                    } catch (Exception e) {
                        log.error("Exception:" + e.getMessage());
                        throw e;
                    }
                }
            } else if (data.get("type").equals("delete")) {
                Object bean = JSONObject.toJavaObject(data.getJSONObject("user"), LandUser.class);
                if (bean != null) {
                    LandUser landUser = (LandUser) bean;
                    LandUser landUser1 = landUserService.queryAppUserByUsernamePhone(landUser.getPhone());
                    if (landUser1 != null) {
                        landUser.setId(landUser1.getId());
                        landUserDao.save(landUser);
                    }
                }
            } else if (data.get("type").equals("update")) {
                Object bean = JSONObject.toJavaObject(data.getJSONObject("userInfo"), UserUpdateInfo.class);
                Object organizationBean = JSONObject.toJavaObject(data.getJSONObject("organization"), Organization.class);
                if (bean != null) {
                    UserUpdateInfo userUpdateInfo = (UserUpdateInfo) bean;
                    if (organizationBean != null) {
                        Organization organization = (Organization) organizationBean;
                        if (organization != null) {  //校验单位是否存在，不存在进行新增
                            Organization organizations = organizationRepository.queryByNameAndRegion(organization.getName(), organization.getRegionCode());
                            if (organizations == null) {  //没有单位，新增单位
                                Organization org = organizationService.create(organization.getName(), organization.getRegionCode(), null, null, organization.getType());
                                userUpdateInfo.setDepNo(org.getId());
                            } else {
                                userUpdateInfo.setDepNo(organizations.getId());
                            }
                        }
                    }
                    LandUser landUser = landUserService.queryAppUserByUsernamePhone(userUpdateInfo.getPhone());
                    if (landUser != null) {
                        userUpdateInfo.setUserId(landUser.getId());
                        landUserService.updateUserByAdmin(userUpdateInfo);
                        // 更新云查询角色
                        String config = userUpdateInfo.getCloudQueryConfig();
                        roleCloudQueryRelRepository.deleteByUserId(userUpdateInfo.getUserId().toString());
                        if (StringUtils.isNotBlank(config)) {
                            String[] strs = config.split(",");
                            List<RoleCloudQueryRel> list = new ArrayList<>();
                            for (int i = 0; i < strs.length; i++) {
                                RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                                ucc.setUid(userUpdateInfo.getUserId().toString());
                                ucc.setCid(strs[i].trim());
                                list.add(ucc);
                            }
                            roleCloudQueryRelRepository.saveAll(list);
                        }
                    }
                }
            } else if (data.get("type").equals("updatePassword")) {
                Object bean = JSONObject.toJavaObject(data.getJSONObject("landUser"), LandUser.class);
                if (bean != null) {
                    LandUser userUpdateInfo = (LandUser) bean;
                    LandUser landUser = landUserService.queryAppUserByUsernamePhone(userUpdateInfo.getPhone());
                    if (landUser != null) {
                        landUserService.updatePassword(landUser.getId(), userUpdateInfo.getPassword(), userUpdateInfo.getPswtip());
                    }
                }
            }
        }
    }

    @Transactional
    public void processSyncDataNew(UserAddInfo userInfo) throws Exception {
        LandUser landUser = landUserService.addUser(userInfo);
        userInfo.setId(landUser.getId() + "");
        //  是管理员且该用户单位下无单位云盘, 则创建单位云盘
        if (userInfo.getRoleIds().indexOf("10020") > -1) {
            Organization organization = organizationRepository.findById(userInfo.getDepNo()).orElse(null);
            if (organization == null) {
                throw new RuntimeException("单位不存在");
            }
            CloudDiskOfOrg cloudDiskOfOrg = cloudDiskOfOrgDao.findById(organization.getId()).orElse(null);
            if (cloudDiskOfOrg == null) {
                List<String> orgIdList = new ArrayList<>();
                orgIdList.add(organization.getId());
                //cloudDiskUtilService.createByOrgIdList(orgIdList, landUser.getId());
            }
        }
        //保存智能管理信息
        // userManageService.addUserBiz(userInfo);
        //保存在线业务种类
        List<String> ywCodes = new ArrayList<String>();
        String zxyw = userInfo.getZxyw();
        if (StringUtils.isNotBlank(zxyw)) {
            String[] split = zxyw.split(",");
            if (zxyw.indexOf(";") > -1) {
                split = zxyw.split(";");
            }
            List<UserBizSupervision> userAppLists = new ArrayList<UserBizSupervision>();
            for (int i = 0; i < split.length; i++) {
               /* if (split[i].equals("6")) {
                    UserBiz lsUbiz = new UserBiz();
                    lsUbiz.setBizId("6");
                    lsUbiz.setUserId(landUser.getId());
                    lsUbiz.setId(UUID.randomUUID().toString());
                    userBizRepository.gwAccess(lsUbiz);
                    continue;
                }*/

                ywCodes.add(split[i]);
                String uid = UUID.randomUUID().toString();
                UserBizSupervision userApp = new UserBizSupervision();
                userApp.setId(uid);
                userApp.setTaskcode(split[i]);
                userApp.setUserid(landUser.getId());
                userAppLists.add(userApp);
            }
            userBizSupervisionDao.saveAll(userAppLists);
        }
        appkey = (String) ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
        appkeys = (String) ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEYS.getKey());
        if (ywCodes.size() > 0) {
            List<String> keys = applicationCodeService.getKeyByCode(ywCodes);
            if (keys.indexOf(appkey) < 0) {
                keys.add(appkey);
            }
            String[] tempKeys = appkeys.split(",");
            for (String tempKey : tempKeys) {
                if (keys.indexOf(tempKey) < 0) {
                    keys.add(tempKey);
                }
            }
            //通过key获取uis_application中的id
            List<String> appIds = UisApplicationDao.getIdByAppKey(keys);

            List<UserApplication> userAppLists = new ArrayList<UserApplication>();
            for (String key : appIds) {
                UserApplication userApp = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp.setId(uid);
                userApp.setApplicationId(key);
                userApp.setUserId(landUser.getId());
                userAppLists.add(userApp);
            }

            if (userAppLists.size() > 0) {
                userApplicationDao.saveAll(userAppLists);
            }
        } else {
            //单独写关联表
            List<String> keys = new ArrayList<String>();
            keys.add(appkey);
            //挂接配置的其他权限
            String[] tempKeys = appkeys.split(",");
            for (String tempKey : tempKeys) {
                if (keys.indexOf(tempKey) < 0) {
                    keys.add(tempKey);
                }
            }

            List<String> appIds = UisApplicationDao.getIdByAppKey(keys);

            for (String key : appIds) {
                UserApplication userApp = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp.setId(uid);
                userApp.setApplicationId(key);
                userApp.setUserId(landUser.getId());
                userApplicationDao.save(userApp);
            }
        }
        // 更新云查询配置
        String config = userInfo.getCloudQueryConfig();
        if (StringUtils.isNotBlank(config)) {
            String[] strs = config.split(",");
            List<RoleCloudQueryRel> list = new ArrayList<>();
            for (int i = 0; i < strs.length; i++) {
                RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                ucc.setUid(landUser.getId().toString());
                ucc.setCid(strs[i].trim());
                list.add(ucc);
            }
            roleCloudQueryRelRepository.saveAll(list);
        }
    }

    private String getQueueName(TbSyncNode node) {
        return String.format("%s|%s|%s", QUEUE_PRE_FIX, node.getNodeAppKey(), node.getNodeFilter());
    }

    @Override
    public void subscribeSyncMsg(Object data) throws Exception {
        enableSync = (Boolean) ProjectConfig.getConfig(ProjectConfigEnum.ENABLE_SYNCUIS.getKey());
        if (!enableSync) {
            return;
        }
        if (data != null && data instanceof JSONObject) {
            Object bean = JSONObject.toJavaObject((JSONObject) data, SyncUisData.class);
            if (bean != null) {
                SyncUisData syncUisData = (SyncUisData) bean;
                try {
                    processSyncData(syncUisData);
                } catch (Exception e) {
                    log.error("Exception:" + e.getMessage());
                    throw e;
                }
            }
        }
    }

    @Override
    public List<String> getSyncUisQueueName() {
        List<String> result = new LinkedList<>();
        List<TbSyncNode> syncNodeList = tbSyncUisNodeDao.queryAll();
        if (!GutilCollection.isEmpty(syncNodeList)) {
            for (TbSyncNode node : syncNodeList) {
                String queueName = getQueueName(node);
                result.add(queueName);
            }
        }
        return result;
    }

    private void processSyncData(SyncUisData syncUisData) throws Exception {
        String msg = checkSyncData(syncUisData);
        if (StringUtils.isNotBlank(msg)) {
            throw new RuntimeException(msg);
        }
        String sql = parseSyncData(syncUisData);
        jdbcTemplate.execute(sql);
    }

    private String parseSyncData(SyncUisData syncUisData) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (syncUisData.getOption().trim().toUpperCase()) {
            case "INSERT": {
                stringBuilder.append(" INSERT INTO ").append(syncUisData.getTableName()).append(" ( ");
                for (int i = 0; i < syncUisData.getColumnNames().size(); i++) {
                    stringBuilder.append(syncUisData.getColumnNames().get(i));
                    if (i < syncUisData.getColumnNames().size() - 1) {
                        stringBuilder.append(" , ");
                    }
                }
                stringBuilder.append(" ) ").append(" VALUES ( ");
                for (int i = 0; i < syncUisData.getColumnValuesAfter().size(); i++) {
                    String valueStr = getValueStr(syncUisData.getColumnValuesAfter().get(i), syncUisData.getColumnTypes().get(i));
                    stringBuilder.append(valueStr);
                    if (i < syncUisData.getColumnNames().size() - 1) {
                        stringBuilder.append(" , ");
                    }
                }
                stringBuilder.append(" );");
                break;
            }
            case "UPDATE": {
                stringBuilder.append(" UPDATE ").append(syncUisData.getTableName()).append(" SET ");
                for (int i = 0; i < syncUisData.getColumnNames().size(); i++) {
                    stringBuilder.append(syncUisData.getColumnNames().get(i)).append(" = ");
                    String valueStr = getValueStr(syncUisData.getColumnValuesAfter().get(i), syncUisData.getColumnTypes().get(i));
                    stringBuilder.append(valueStr);
                    if (i < syncUisData.getColumnNames().size() - 1) {
                        stringBuilder.append(" , ");
                    }
                }
                stringBuilder.append(" WHERE ").append(syncUisData.getKeyName()).append(" = ");
                String keyValueStr = getValueStr(syncUisData.getKeyValue(), syncUisData.getKeyType());
                stringBuilder.append(keyValueStr);
                break;
            }
            case "DELETE": {
                stringBuilder.append(" DELETE FROM ").append(syncUisData.getTableName());
                stringBuilder.append(" WHERE ").append(syncUisData.getKeyName()).append(" = ");
                String keyValueStr = getValueStr(syncUisData.getKeyValue(), syncUisData.getKeyType());
                stringBuilder.append(keyValueStr);
                break;
            }
            default: {
                break;
            }
        }
        return stringBuilder.toString();
    }


    private String getValueStr(Object value, String type) {
        String result = "''";
        switch (type.trim().toUpperCase()) {
            case "NUMBER": {
                result = value.toString();
                break;
            }
            case "STRING":
            case "GEOMETRY": {
                if (value == null) {
                    result = "''";
                } else {
                    result = "'" + value.toString() + "'";
                }
                break;
            }
            case "DATETIME": {
                if (value == null) {
                    result = "''";
                } else {
                    result = "'" + value.toString() + "'";
                }
                break;
            }
            default:
                break;

        }
        return result;
    }

    /**
     * 检查数据合法性
     *
     * @param syncUisData
     * @return java.lang.String 返回错误信息
     * @author zkn
     * @date 2021/7/29
     */
    private String checkSyncData(SyncUisData syncUisData) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isBlank(syncUisData.getTableName())) {
            stringBuilder.append("[tableName]不能为空！/n");
        }
        if (StringUtils.isBlank(syncUisData.getOption())) {
            stringBuilder.append("[option]不能为空！/n");
        } else {
            if (syncUisData.getOption().trim().equalsIgnoreCase("insert")) {
                checkDataColumns(syncUisData, stringBuilder);
            } else if (syncUisData.getOption().trim().equalsIgnoreCase("update")) {
                if (StringUtils.isBlank(syncUisData.getKeyName())) {
                    stringBuilder.append("[keyName]不能为空！/n");
                }
                checkDataColumns(syncUisData, stringBuilder);
            } else if (syncUisData.getOption().trim().equalsIgnoreCase("delete")) {
                if (StringUtils.isBlank(syncUisData.getKeyName())) {
                    stringBuilder.append("[keyName]不能为空！/n");
                }
            } else {
                stringBuilder.append("[option]不在值域范围[insert、update、delete]内！/n");
            }
        }
        return stringBuilder.toString();
    }

    private void checkDataColumns(SyncUisData syncUisData, StringBuilder stringBuilder) {
        if (GutilCollection.isEmpty(syncUisData.getColumnNames())) {
            stringBuilder.append("[columnNames]不能为空！/n");
        } else {
            for (String columnName : syncUisData.getColumnNames()) {
                if (StringUtils.isBlank(columnName)) {
                    stringBuilder.append("[columnNames]中不能包含空列名！/n");
                    break;
                }
            }
        }
        if (GutilCollection.isEmpty(syncUisData.getColumnTypes())) {
            stringBuilder.append("[columnTypes]不能为空！/n");
        } else {
            for (String columnType : syncUisData.getColumnTypes()) {
                if (StringUtils.isBlank(columnType)) {
                    stringBuilder.append("[columnTypes]中不能包含空列类型！/n");
                    break;
                } else {
                    if (!columnType.equalsIgnoreCase("NUMBER") &&
                            !columnType.equalsIgnoreCase("STRING") &&
                            !columnType.equalsIgnoreCase("DATETIME") &&
                            !columnType.equalsIgnoreCase("GEOMETRY")) {
                        stringBuilder.append("[columnTypes]中某列类型不在值域范围[NUMBER、STRING、DATETIME、GEOMETRY]内！/n");
                        break;
                    }
                }
            }
        }
        if (GutilCollection.isEmpty(syncUisData.getColumnValuesAfter())) {
            stringBuilder.append("[columnValuesAfter]不能为空！/n");
        }
        if (syncUisData.getColumnNames().size() != syncUisData.getColumnTypes().size() ||
                syncUisData.getColumnNames().size() != syncUisData.getColumnValuesAfter().size() ||
                syncUisData.getColumnTypes().size() != syncUisData.getColumnValuesAfter().size()) {
            stringBuilder.append("[columnNames、columnTypes、columnValuesAfter]集合的长度不一致！/n");
        }
    }
}
