package com.geoway.landteam.landcloud.service.user;

import com.geoway.landteam.landcloud.core.model.pub.entity.SysFaq;
import com.geoway.landteam.landcloud.core.model.user.entity.Feedback;
import com.geoway.landteam.landcloud.core.repository.pub.SysFaqRepository;
import com.geoway.landteam.landcloud.core.repository.user.FeedbackRepository;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by chenyue on 2018/1/23.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class FeedbackService {

    @Autowired
	FeedbackRepository feedbackDao;
    
    @Autowired
	SysFaqRepository sysFaqDao;
    
    public void addFeedback(Feedback feedback) {
        feedback.setStatus(0);
        feedback.setCreatetime(new Date());
        feedbackDao.save(feedback);
    }

    public Page<Feedback> getFeebackByCondition(final Long userId, final Integer status, final Integer level, Integer page, Integer pageSize, String sort, final String condition) {
        if(pageSize == null){
            pageSize = 30;
        }
        Pageable pageable = null;
        if(sort != null){
            Sort orders = null;
            if ("asc".equals(sort)) {
                orders =  Sort.by(Sort.Direction.ASC, "createtime");
            }else if("desc".equals(sort)){
                orders = Sort.by(Sort.Direction.DESC, "createtime");
            }
            pageable =  PageRequest.of(page, pageSize, orders);
        }else {
            pageable = PageRequest.of(page, pageSize);
        }
        Page<Feedback> result = feedbackDao.findAll(new Specification<Feedback>() {
            @Override
            public Predicate toPredicate(Root<Feedback> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Predicate predicate = null;
                if(userId != null){
                    predicate = cb.equal(root.get("userId"), userId);
                }

                if(status != null){
                    if(predicate == null){
                        predicate = cb.equal(root.get("status"), status);
                    }else {
                        predicate = cb.and(predicate, cb.equal(root.get("status"), status));
                    }

                }
                if(level != null){
                    if(predicate == null){
                        predicate = cb.equal(root.get("level"), level);
                    }else {
                        predicate = cb.and(predicate, cb.equal(root.get("level"), level));
                    }

                }
                if(condition != null){
                    if(predicate == null){
                        predicate = cb.or(cb.like(root.get("content").as(String.class), "%"+condition+"%"), cb.like(root.get("username").as(String.class), "%"+condition+"%"));
                    }else {
                        predicate = cb.and(predicate, cb.or(cb.like(root.get("content").as(String.class), "%"+condition+"%"), cb.like(root.get("username").as(String.class), "%"+condition+"%")));
                    }
                }
                return predicate;
            }
        }, pageable);

        return result;
    }

    public List getStatusCountByGroup() {
        return feedbackDao.getStatusCountByGroup();
    }

    public void addAnswerForFeedback(int feedbackId, String answer) {
        feedbackDao.addAnswerForFeedback(feedbackId, answer,new Date());
    }
    
    public Feedback addAnswer(int feedbackId, String answer) {
    	Feedback feedback = feedbackDao.findById(feedbackId).orElse(null);
    	if(feedback != null) {
    		feedback.setStatus(1);
    		feedback.setAnswer(answer);
    		feedback.setReplytime(new Date());
    		feedbackDao.save(feedback);
    	}
    	return feedback;
    }
    
	/**
	 * unzipFileDir zip文件解压后的路径
	 * userId  当前登录用户
	 */
	public String importJctb(String unzipFileDir){
		File file = null;
		String result = "";
		try {
			file = new File(unzipFileDir);
			File[] content = file.listFiles();
			for (int j = 0; j < content.length; j++) {
				String name = content[j].getName();
				if(name.contains(".xlsx") || name.contains(".xls")){
					String path = content[j].getCanonicalPath();
					importTaskFromExcel(path);
					break;
				}
			}
		} catch (Exception ex) {
			// 忽略，继续处理剩下的文件
			ex.printStackTrace();
		}
		return result;
	}
	
	/**
	 * 从excel中读取数据
	 * @param excelFile
	 * @throws Exception 
	 */
	private void importTaskFromExcel(String excelFile) throws Exception{
		Workbook workbook = null;
		OutputStream out = null; 
		InputStream is = null;
		
		try {
			File file = new File(excelFile);
			InputStream inputStream=new FileInputStream(file);
			
			File parentFile = file.getParentFile();
            if (parentFile != null && (!parentFile.exists())) {
                parentFile.mkdirs();
            }
			
			//这种方式 Excel 2003/2007/2010 都是可以处理的 
			workbook = WorkbookFactory.create(inputStream);
			inputStream.close();
			
			Sheet sheet = workbook.getSheet("faq");
			Row row = sheet.getRow(0);
			int colNumber = row.getPhysicalNumberOfCells();
			int rowCount = sheet.getPhysicalNumberOfRows();
			
			sysFaqDao.deleteAll();
			
			for(int i = 1; i < rowCount; i++){
				row = sheet.getRow(i);
				if(row == null){
					continue;
				}
				
				SysFaq faq = new SysFaq();
				
				for(int j=0;j<colNumber;j++){
					Cell cell = row.getCell(j);
					String txt = findCellValue(cell);
					
					if(StringUtils.isBlank(txt)){
						continue;
					}
					
					if(j == 0){
						faq.setSystem(Integer.parseInt(txt));
					}else if(j == 1){
						faq.setModel(Integer.parseInt(txt));
					}else if(j == 2){
						faq.setQuestionsort(Integer.parseInt(txt));
					}else if(j == 3){
						faq.setQuestion(txt);
					}else if(j == 4){
						faq.setAnswersort(Integer.parseInt(txt));
					}else if(j == 5){
						faq.setAnswer(txt);
					}else if(j == 6){
						//转换成base64
						String imgFile = parentFile.getCanonicalPath() + File.separator + txt;
						String base64 = getImgStr(imgFile);
						faq.setPicture("data:image/png;base64,"+base64);
					}else if(j == 7){
						faq.setAnswerbz(txt);
					}else if(j == 8){
						faq.setExplain(txt);
					}else if(j == 9){
						faq.setExplaindetails(txt);
					}else if(j == 10){
						//转换成base64
						String imgFile = parentFile.getCanonicalPath() + File.separator + txt;
						String base64 = getImgStr(imgFile);
						faq.setExplainpic("data:image/png;base64,"+base64);
					}else if(j == 11){
						faq.setExplainbz(txt);
					}
				}
				
				sysFaqDao.save(faq);
			}
			
		    out = new FileOutputStream(file);  
	        workbook.write(out); 
	        out.flush();
	        out.close();
		}catch(Exception ex){
			throw ex;
		}
	}

	private String findCellValue(Cell cell) {
		String cellValue = "";
		if (cell == null) {
			return "";
		}
		try {
			org.apache.poi.ss.usermodel.CellType cellType = cell.getCellType();
			switch (cellType) {
				case STRING: //文本
					cellValue = cell.getStringCellValue();
					break;
				case NUMERIC: //数字、日期
					if (DateUtil.isCellDateFormatted(cell)) {
						SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
						cellValue = fmt.format(cell.getDateCellValue()); //日期型
					} else {
						cellValue = String.valueOf((long) cell.getNumericCellValue()); //数字
					}
					break;
				case BOOLEAN: //布尔型
					cellValue = String.valueOf(cell.getBooleanCellValue());
					break;
				case BLANK: //空白
					cellValue = cell.getStringCellValue();
					break;
				case ERROR: //错误
					cellValue = "错误";
					break;
				case FORMULA: //公式
					cellValue = "错误";
					break;
				default:
					cellValue = "错误";
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			return "";
		}
		return cellValue.trim();
	}
	
    /**
     * 将图片转换成Base64编码
     * @param imgFile 待处理图片
     * @return
     */
    private String getImgStr(String imgFile){
        //将图片文件转化为字节数组字符串，并对其进行Base64编码处理
        InputStream in = null;
        byte[] data = null;
        String result = "";
        //读取图片字节数组
        try{
            in = new FileInputStream(imgFile);
            if(in != null){
            	data = new byte[in.available()];
                in.read(data);
                in.close();
                result = new String(Base64.encodeBase64(data));
            }
        } catch (IOException e){
            e.printStackTrace();
        }
        return result;
    }
}
