package com.geoway.landteam.landcloud.service.user;

import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.model.user.entity.UserAreaApply;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaApplyRepository;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;


@Service
@Transactional(rollbackFor = Exception.class)
public class MLandUserAreaService {

	@Autowired
    UserAreaApplyRepository userAreaApplyDao;
	
	@Autowired
    LandUser2AreaRepository landUser2AreaDao;
	
	@Autowired
    RegionRepository regionDao;
	
	@Autowired
    TaskNoticeServiceImpl noticeService;
	
	@Autowired
    LandRegUserRepository landRegDao;


	@Autowired
    RegionVersionRepository regionVersionRepository;
	
	public Page<UserAreaApply> queryByFilter(String filterParam, String sortParam, int start, int limit){
		Page<UserAreaApply> results = userAreaApplyDao.findAll(
				new QuerySpecification<UserAreaApply>(filterParam),
				PageRequest.of(start, limit, QueryParamUtil
						.parseSortParams(sortParam)));
		
		return results;
	}
	
	public void avalArea(Long sendUserId,String id,int state){
		UserAreaApply userAreaApply = userAreaApplyDao.findById(id).orElse(null);
		
		boolean isExists = landUser2AreaDao.queryUserAreasIsExists(userAreaApply.getUserId(),userAreaApply.getApplyRegion()) > 0;
    	if(state == 1 && !isExists){
    		LandUser2Area userArea = new LandUser2Area();
        	userArea.setCreateTime(new Date());
        	userArea.setRegionCode(userAreaApply.getApplyRegion());
        	userArea.setUserId(userAreaApply.getUserId());
        	userArea.setState(1);
        	landUser2AreaDao.save(userArea);
    	}
    	userAreaApply.setState(state);
    	userAreaApplyDao.save(userAreaApply);
    	
    	LandUser user = userAreaApply.getUser();
		RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
		String regionName = regionDao.getNameByCodeAndVersion(userAreaApply.getApplyRegion(),defaultVersion!=null?defaultVersion.getVersion():"2018");
    	String message=user.getName() + "你好：你申请的工作区域（" + regionName + "）已经审核通过";
    	if(state == 1){
    		message=user.getName() + "你好：你申请的工作区域（" + regionName + "）未能审核通过";
    	}
    	
    	noticeService.addTextNotice("区域申请结果通知", message, sendUserId, userAreaApply.getUserId());
	}
	
	public void addUserAreaApply(Long userId,String regionCode,String reason) throws Exception{
		int iExists = userAreaApplyDao.queryUserAreaApplyIsExists(userId,regionCode);
		if(iExists > 0){
			throw new GwValidateException("该区域已申请");
		}
		
		int isApply = landUser2AreaDao.queryUserAreasIsApply(userId, regionCode);
		if(isApply > 0){
			throw new GwValidateException("该区域已申请");
		}else{
			int isExists = landUser2AreaDao.queryUserAreasIsExists(userId, regionCode);
			LandRegUser regUser = landRegDao.findByUserID(userId);
			
		/*	if(regUser != null ){
				landRegDao.updateStateAndCodeByUserId(0,regionCode,userId);
			}*/
			
			Date now = new Date();
			if(isExists == 0){
				LandUser2Area userArea = new LandUser2Area();
				userArea.setRegionCode(regionCode);
				userArea.setUserId(userId);
				userArea.setState(0);
				userArea.setCreateTime(now);
				
				landUser2AreaDao.save(userArea);
			}else{
				landUser2AreaDao.updateStateByRegionAndUser(0,now,userId,regionCode);
			}
		}
		
		UserAreaApply apply = userAreaApplyDao.queryUserAreaApply(userId,regionCode);
		if(apply == null || (apply!=null && apply.getState() == 2)){
			
			UserAreaApply userAreaApply = new UserAreaApply();
			userAreaApply.setUserId(userId);
			userAreaApply.setApplyRegion(regionCode);
			userAreaApply.setReason(reason);
			userAreaApply.setCreateTime(new Date());
			
			userAreaApplyDao.save(userAreaApply);
			LandRegUser regUser = landRegDao.findByUserID(userId);
			/*if(regUser != null ){
				landRegDao.updateStateAndCodeByUserId(0,regionCode,userId);
			}*/
			
		}else{
			throw new GwValidateException("该区域已申请");
		}
	}
	
	public boolean findCountByUserId(Long userId){
		return landUser2AreaDao.queryUserAreasCount(userId)>0;
	}
	
	public List<Long> findUserIdByCodeAndState(String regionCode,Integer state){
		List<Long> list = landUser2AreaDao.queryByCodeAndState(regionCode, state);
		return list;
	}
	
	public Integer queryUserAreasIsExists(Long userId,String regionCode){
		return landUser2AreaDao.queryUserAreasIsExists(userId, regionCode);
	}
}

