package com.geoway.landteam.landcloud.service.user;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.User2BizRepository;
import com.geoway.landteam.customtask.servface.task.TbtskUserManageAreaService;
import com.geoway.landteam.customtask.task.entity.User2Biz;
import com.geoway.landteam.landcloud.common.dto.EasyUIResponse;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.common.support.jfunboxUtils.JFunBoxUserUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.pub.dto.Third.UserGrant;
import com.geoway.landteam.landcloud.core.model.pub.dto.Third.UserIdCls;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserUpdateInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.*;
import com.geoway.landteam.landcloud.core.model.user.entity.*;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.*;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.DepartmentServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.LandUserAreaServiceImpl;
import com.geoway.landteam.landcloud.core.service.user.LandUserRoleServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CheckUtil;
import com.geoway.landteam.landcloud.core.service.util.LandUserBuilder;
import cn.hutool.core.collection.ListUtil;
/*import com.gw.base.data.GwValidateException;*/
import com.geoway.landteam.landcloud.servface.oauth.OauthOrganizationService;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.geoway.landteam.platform.ucs.res3.api.user.reso.EpaUserReso;
import com.gw.base.Gw;
import com.gw.base.data.GwValidateException;
import com.gw.base.data.result.GiResult;
import com.gw.base.util.GutilStr;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class MLandUserService {

    @Autowired
    ApplicationContext applicationContext;

    @Autowired
    LandUserRepository landUserDao;

    @Autowired
    LandUserDetailRepository landUserDetailDao;

    @Autowired
    RegionVersionRepository regionVersionRepository;

    @Autowired
    LandRegUserRepository landRegUserDao;

    @Autowired
    RegionService regionService;

    @Autowired
    DeviceRepository deviceDao;

    @Autowired
    User2YXRepository user2YXDao;

    @Autowired
    LandUser2AreaRepository landUser2AreaDao;

    @Autowired
    RegionUserRepository regionUserDao;

    @Autowired
    RegionRepository regionDao;

    @Autowired
    LandUserRoleRepository landUserRoleDao;

    @Autowired
    AvalUserRepository avalUserDao;

    @Autowired
    LandUser2TypeRepository landUser2TypeDao;

    @Autowired
    UserProblemTypesRepository userProblemTypesDao;


    @Autowired
    RightRepository rightDao;

    @Autowired
    UserRoleRightRepository userRoleRightDao;

    @Autowired
    YXUserRepository yxUserRepository;

    @Autowired
    LandRegUserService landRegUserService;

    @Autowired
    LandUserAreaServiceImpl landUserAreaService;

    @Autowired
    OrganizationRepository organizationRepository;

    @Autowired
    Organization2UserRepository organization2UserDao;

    @Autowired
    Department2UserRepository department2UserDao;

    @Autowired
    DepartmentRepository departmentDao;

    @Autowired
    DepartmentServiceImpl departmentService;

    @Autowired
    FriendsRepository friendsDao;

    @Autowired
    UserCloudAreaRepository userCloudAreaDao;

    @Autowired
    UserApplicationRepository userApplicationRepository;


    @Autowired
    CloudDiskOfPersonRepository cloudDiskOfPersonDao;

    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;

    @Autowired
    OrgCloudDiskMemberRepository orgCloudDiskMemberDao;

    @Autowired
    GroupCloudDiskMemberRepository groupCloudDiskMemberDao;

    @Autowired
    OptLogRepository optLogRepository;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    UserRoleInfoRepository userRoleInfoDao;

    @Autowired
    LandUserRoleServiceImpl userRoleService;

    @Autowired
    User2BizRepository user2BizRepository;

    @Autowired
    DepartmentRepository departmentRepository;

    @Autowired
    TbtskUserManageAreaService tbtskUserManageAreaService;

    @Autowired
    OauthUserService oauthUserService;

    @Autowired
    OauthOrganizationService organizationService;



    //管理区table名称
    static final String GLY_TABLE_NAME = "tbtsk_user_manage_area";
    //审核区table名称
    static final String SHY_TABLE_NAME = "tbtsk_user_audit_area";
    //作业区复核区table名称table名称
    static final String ZYY_TABLE_NAME = "tbtsk_right_area";
    //复核区table名称
    static final String FHY_TABLE_NAME = "tbtsk_user_review_area";
    //超级审核区table名称
    static final String CJSHY_TABLE_NAME = "tbtsk_super_user_audit_area";
    //超级审核区table名称
    static final String SCY_TABLE_NAME = "tbtsk_user_upload_area";

    /*
    public LandUser queryAppUserByName(String name) {
        List<LandUser> users = landUserDao.queryAppUserByName(name);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public LandUser queryAppUserByPhone(String name) {
        List<LandUser> users = landUserDao.queryAppUserByPhone(name);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public LandUser queryAppUserByUsernamePhone(String nameOrPhone) {
        List<LandUser> users = landUserDao.queryAppUserByUsernameOrPhone(nameOrPhone);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public LandUser queryAppUserByName(String name, String deviceId) {
        List<LandUser> users = landUserDao.queryAppUserByName(name, deviceId);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }
    */
    public LandUser queryUserByName(String name) {
        List<LandUser> users = landUserDao.queryUserByName(name);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public LandUser queryUserByPhone(String name) {
        List<LandUser> users = landUserDao.queryUserByPhone(name);
        LandUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public RegionUser queryRegionUserByName(String name) {
        List<RegionUser> users = regionUserDao.queryUserByName(name);
        RegionUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public List<Long> queryUserIdByRnameAndRole(String name) {
        List<Long> userIds = landUserDao.queryUserIdByRnameAndRole(name);

        List<Long> result = new ArrayList<Long>();
        if (userIds.size() > 0) {
            result = landUserRoleDao.getUserByRoleAndUser((long) 10004, userIds);
        }
        return result;
    }

    public List<Long> queryUserIdByRname(String name) {
        List<Long> userIds = landUserDao.queryUserIdByRname("%" + name + "%");

        return userIds;
    }

    public Integer findRegUserStatus(String userName) {
        String filterParam = "Q_name_S_EQ=" + userName;
        List<LandRegUser> results = landRegUserDao.findAll(new QuerySpecification<LandRegUser>(filterParam));

        Integer tag = 1;
        if (results != null && results.size() > 0) {
            LandRegUser regUser = results.get(0);
            if (regUser.getState() == 0) {
                tag = 6;
            } else if (regUser.getState() == 2) {
                tag = 7;
            }
        }
        return tag;
    }

    public LandUser saveUser(LandUser user) {
        return landUserDao.save(user);
    }

    public Page<LandUser> queryByFilter(String filterParam, String sortParam, int start, int limit) {
        Page<LandUser> results = landUserDao.findAll(new QuerySpecification<LandUser>(filterParam),
                PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));

        return results;
    }

    public List<UserGrant> getUserOnlyGrantBiz(String bizid, String name, int offset, int limit, String roleid, String regionCode, String orgName) {
        //return landUserDao.getUserOnlyGrantBiz(bizid,"%"+roleid+"%","%"+name+"%",limit,offset);
        BeanPropertyRowMapper<UserGrant> rowMapper = new BeanPropertyRowMapper<UserGrant>(UserGrant.class);
        String sql = "SELECT\n" +
                "\tT.f_userid,\n" +
                "\tT.f_username,\n" +
                "\tT.isgran, \n" +
                "\tT.f_depid,\n" +
                "\tT.f_phonemobile,\n" +
                "\tT.roles, \n" +
                "\tT.f_rname, \n" +
                "\tT.f_regioncode \n" +
                "FROM\n" +
                "\t(\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid ='" + bizid + "' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT * FROM tbsys_user_biz A WHERE A.f_bizid ='" + bizid + "' ) AS P ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T \n" +
                "WHERE\n" +
                "\tT.roles LIKE '%" + roleid + "%'\n" +
                "\tAND T.f_bizid='" + bizid + "'\n" +
                "\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')\n" +
                "\tAND T.f_regioncode like '" + regionCode + "'\n" +
                "\tAND T.f_depid like '%" + orgName + "%'\n" +
                "\tORDER BY\n" +
                "\tT.f_username \n" +
                "\tLIMIT " + limit + " OFFSET " + offset;
        return jdbcTemplate.query(sql, rowMapper);
    }

    public Long getUserOnlyGrantBizCount(String bizid, String name, String roleid, String regionCode, String orgName) {
        //return landUserDao.getUserOnlyGrantBizCount(bizid,"%"+roleid+"%","%"+name+"%");
        String sql = "SELECT count(1)\n" +
                "FROM\n" +
                "\t(\n" +
                "SELECT b\n" +
                "\t.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid='" + bizid + "' as isgrant,\n" +
                "\tarray_to_string(( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid )), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b \n" +
                "\tLEFT JOIN (SELECT * FROM tbsys_user_biz A WHERE A.f_bizid='" + bizid + "') AS P ON P.f_userid = b.f_userid \n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "  WHERE b.f_isdeleted<>'1'\n" +
                "\t) AS T \n" +
                "WHERE\n" +
                "\tT.roles LIKE '%" + roleid + "%'\n" +
                "\tAND T.f_bizid='" + bizid + "'\n" +
                "\tAND T.f_regioncode like '" + regionCode + "'\n" +
                "\tAND T.f_depid like '%" + orgName + "%'\n" +
                "\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')";
        return jdbcTemplate.queryForObject(sql, Long.class);
    }

    public List<UserGrant> getUserAllBiz(String bizid, String name, int offset, int limit, String roleid, String regionCode, String orgName) {
        //return landUserDao.getUserAllBiz(bizid,"%"+roleid+"%","%"+name+"%",limit,offset);
        BeanPropertyRowMapper<UserGrant> rowMapper = new BeanPropertyRowMapper<UserGrant>(UserGrant.class);
        String sql = "SELECT\n" +
                "\tT.f_userid,\n" +
                "\tT.f_username,\n" +
                "\tT.isgran, \n" +
                "\tT.f_depid,\n" +
                "\tT.f_phonemobile,\n" +
                "\tT.roles, \n" +
                "\tT.f_rname, \n" +
                "\tT.f_regioncode \n" +
                "FROM\n" +
                "\t(\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid ='" + bizid + "' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b" +
                ".f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT * FROM tbsys_user_biz A WHERE A.f_bizid ='" + bizid + "' ) AS P ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T \n" +
                "WHERE\n" +
                "\tT.roles LIKE '%" + roleid + "%' \n" +
                "\tAND T.f_regioncode like '" + regionCode + "' \n" +
                "\tAND T.f_depid like '%" + orgName + "%'\n" +
                "\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')\n" +
                "\tORDER BY\n" +
                "\tT.f_username \n" +
                "\tLIMIT " + limit + " OFFSET " + offset;
        return jdbcTemplate.query(sql, rowMapper);
    }

    public Long getUserAllBizCount(String bizid, String name, String roleid, String regionCode, String orgName) {
        //return landUserDao.getUserAllBizCount(bizid,"%"+roleid+"%","%"+name+"%");
        String sql = "SELECT count(1)\n" +
                "FROM\n" +
                "\t(\n" +
                "SELECT b\n" +
                "\t.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_phonemobile,\n" +
                "\tb.f_depid,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid='" + bizid + "' as isgrant,\n" +
                "\tarray_to_string(( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid )), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b \n" +
                "\tLEFT JOIN (SELECT * FROM tbsys_user_biz A WHERE A.f_bizid='" + bizid + "') AS P ON P.f_userid = b.f_userid \n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "  WHERE b.f_isdeleted<>'1'\n" +
                "\t) AS T \n" +
                "WHERE\n" +
                "\tT.roles LIKE '%" + roleid + "%' \n" +
                "\tAND T.f_regioncode like '" + regionCode + "' \n" +
                "\tAND T.f_depid like '%" + orgName + "%'\n" +
                "\tAND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')";
        return jdbcTemplate.queryForObject(sql, Long.class);
    }

    public List<UserIdCls> getUserIdByRoleAndRegion(String roleId, String regionCode) {

        //return landUserDao.getUserIdByRoleAndRegion("%"+roleId+"%",regionCode);
        BeanPropertyRowMapper<UserIdCls> rowMapper = new BeanPropertyRowMapper<UserIdCls>(UserIdCls.class);
        String sql = "SELECT T\n" +
                "\t.f_userid\n" +
                "FROM\n" +
                "\t(\n" +
                "SELECT b\n" +
                "\t.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tC.f_regioncode,\n" +
                "\tarray_to_string(( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid )), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b \n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "\tJOIN tbsys_user_biz d on b.f_userid = d.f_userid" +
                "  WHERE b.f_isdeleted <> '1' and d.f_bizid='6'\n" +
                "\t) AS T \n" +
                "where T.roles like '%" + roleId + "%' and T.f_regioncode='" + regionCode + "'";
        return jdbcTemplate.query(sql, rowMapper);
    }

    public LandRegUser queryRegUserByName(String name) {
        List<LandRegUser> users = landRegUserDao.queryRegUserByName(name);
        LandRegUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public LandRegUser queryRegUserByPhone(String phone) {
        List<LandRegUser> users = landRegUserDao.queryRegUserByPhone(phone);
        LandRegUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public LandRegUser queryRegUserByUserOrPhone(String nameOrPhone) {
        List<LandRegUser> users = landRegUserDao.queryRegUserByNameOrPhone(nameOrPhone);
        LandRegUser myUser = null;
        if (users.size() > 0) {
            myUser = users.get(0);
        }
        return myUser;
    }

    public boolean findUserNameIsExists(String name) {

        List<LandUser> users = landUserDao.queryUserByName(name);
        if (users.size() > 0) {
            return true;
        }

        List<LandRegUser> regUsers = landRegUserDao.queryRightRegUserByName(name);
        return regUsers.size() > 0;
    }

    public boolean findPhoneIsExists(String phone) {

        List<LandUser> users = landUserDao.queryNormalUserByPhone(phone);
        if (users != null && users.size() > 0) {
            return true;
        }

        List<LandRegUser> regUsers = landRegUserDao.queryRegUserByPhone(phone);
        return regUsers != null && regUsers.size() > 0;
    }

    public List<String> queryUserAreas(Long userId) throws Exception {
        String regionCode = oauthUserService.getUserRegion(userId);
        List<String>regions = new ArrayList<>();
        regions.add(regionCode);
        return regions;
        //return landUser2AreaDao.queryUserAreas(userId, 1);
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateUserAreas(Long userId, List<String> regionCodes) {
        landUser2AreaDao.deleteAreaByUserId(userId);
        List<LandUser2Area> userAreaList = regionCodes.stream().map(r -> {
            LandUser2Area userArea = new LandUser2Area();
            userArea.setRegionCode(r);
            userArea.setUserId(userId);
            userArea.setState(1);
            userArea.setCreateTime(new Date());
            return userArea;
        }).collect(Collectors.toList());
        landUser2AreaDao.saveAll(userAreaList);
    }

    public Long findUserIdByName(String name) {
        List<LandUser> users = landUserDao.queryAppUserByName(name);
        if (users.size() == 1) {
            return users.get(0).getId();
        } else if (users.size() == 0) {
            return null;
        } else {
            throw new RuntimeException("用户名有重复");
        }
    }

    public Page<RegionUser> queryRegionUserByFilter(String filterParam, String sortParam, int start, int limit,
                                                    Integer rightType, boolean isContainsRole) {
        Page<RegionUser> results = regionUserDao.findAll(new QuerySpecification<RegionUser>(filterParam),
                PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));

        if (isContainsRole) {
            if (results != null && results.getSize() > 0) {
                for (RegionUser result : results) {
                    Long userId = result.getId();
                    List<SysRoleInfo> roles = getRoleByUser(userId, rightType);
                    result.setRoles(roles);
                }
            }
        }
        return results;
    }

    public LandUserDetail findUserDetail(Long id, Integer rightType) {
        LandUserDetail userDetail = landUserDetailDao.findById(id).orElse(null);
        if (userDetail.getIsdel() == 1) {
            return null;
        }

        LandRegUser regUser = landRegUserDao.findByUserID(id);
        if (regUser != null) {
            userDetail.setAppRoleId(regUser.getRoleIds());
        }

        List<SysRoleInfo> roles = getRoleByUser(id, rightType);
        userDetail.setRoles(roles);

        List<Long> problemTypes = userProblemTypesDao.getTypesByUserId(id);
        if (problemTypes != null && !problemTypes.isEmpty()) {
            userDetail.setProblemTypes(GutilStr.join(problemTypes, ","));
        } else {
            userDetail.setProblemTypes("");
        }

        AvalUser avalUser = avalUserDao.getAvalUserByUserId(id);
        if (avalUser != null) {
            Long approverId = avalUser.getApproverId();
            LandUserDetail user = landUserDetailDao.findById(approverId).orElse(null);
            if (user != null) {
                userDetail.setApprover(user.getName());
            }
        }
        return userDetail;
    }

    public LandUserDetail findUserRole(Long id, Integer rightType) {
        LandUserDetail userDetail = landUserDetailDao.findById(id).orElse(null);
        if (userDetail == null) {
            return userDetail;
        }
        List<SysRoleInfo> roles = getRoleByUser(id, rightType);
        userDetail.setRoles(roles);

        List<Long> problemTypes = userProblemTypesDao.getTypesByUserId(id);
        if (problemTypes != null && !problemTypes.isEmpty()) {
            userDetail.setProblemTypes(GutilStr.join(problemTypes, ","));
        } else {
            userDetail.setProblemTypes("");
        }
        return userDetail;
    }

    public List<SysRoleInfo> getRoleByUser(Long userId, Integer rightType) {
        String filterParam = "Q_userId_N_EQ=" + userId + ";Q_visible_N_EQ=1";
        if (rightType != null) {
            filterParam += ";Q_type_N_EQ=" + rightType;
            if (rightType == 1) {
                // LandRegUser regUser = landRegUserDao.findByUserID(userId);
                // if (regUser != null && GutilStr.isNotBlank(regUser.getRoleIds())) {
                // filterParam += ";Q_roleId_N_EQ=" + regUser.getRoleIds();
                // }
            }
        }

        String sortParam = "SORT_order_ASC;SORT_pid_ASC";
        List<UserRoleRight> userRoleRights = userRoleRightDao
                .findAll(new QuerySpecification<UserRoleRight>(filterParam), QueryParamUtil.parseSortParams(sortParam));

        Map<Long, List<Right>> rightData = new HashMap<Long, List<Right>>();
        for (UserRoleRight userRoleRight : userRoleRights) {
            Right right = new Right();
            right.setId(userRoleRight.getRightId());
            right.setCode(userRoleRight.getRightCode());
            right.setName(userRoleRight.getRightName());
            right.setStatus(userRoleRight.getStatus());
            right.setPid(userRoleRight.getPid());
            right.setOrder(userRoleRight.getOrder());
            right.setType(userRoleRight.getType());
            if (rightData.containsKey(userRoleRight.getRoleId())) {
                rightData.get(userRoleRight.getRoleId()).add(right);
            } else {
                List<Right> rights = new ArrayList<Right>();
                rights.add(right);
                rightData.put(userRoleRight.getRoleId(), rights);
            }
        }

        Map<Long, SysRoleInfo> dataMap = new HashMap<Long, SysRoleInfo>();
        List<SysRoleInfo> roles = new ArrayList<SysRoleInfo>();
        if (userRoleRights != null && !userRoleRights.isEmpty()) {
            SysRoleInfo role = null;
            for (UserRoleRight userRoleRight : userRoleRights) {
                if (dataMap.containsKey(userRoleRight.getRoleId())) {
                    continue;
                } else {
                    role = new SysRoleInfo();
                    role.setId(userRoleRight.getRoleId().toString());
                    role.setName(userRoleRight.getRoleName());
                    role.setTag(userRoleRight.getTag());
                    role.setVisible(userRoleRight.getVisible());
                    if (rightData.containsKey(userRoleRight.getRoleId())) {
                        role.setRights(rightData.get(userRoleRight.getRoleId()));
                    }

                    dataMap.put(userRoleRight.getRoleId(), role);
                }
                roles.add(role);
            }
        }
        return roles;
    }

    public LandUserDetail saveUserDetail(LandUserDetail detail) {
        LandUserDetail userDetail = null;
        if (detail.getId() == null) {
            userDetail = landUserDetailDao.save(detail);
        } else {
            userDetail = landUserDetailDao.findById(detail.getId()).orElse(null);
            userDetail.setName(detail.getName());
            userDetail.setRname(detail.getName());
            userDetail.setDepId(detail.getDepId());
            userDetail.setState(detail.getState());
            userDetail.setSjsf(detail.getSjsf());
            landUserDetailDao.save(userDetail);
        }

        if (GutilStr.isNotBlank(userDetail.getSjsf())) {
            String[] sjsfArr = userDetail.getSjsf().split(",");
            List<String> usableAreas = landUser2AreaDao.queryUserAreas(userDetail.getId(), 1);
            List<String> disabledAreas = landUser2AreaDao.queryUserAreas(userDetail.getId(), 0);

            List<String> newUsableAreas = new ArrayList<String>();
            List<LandUser2Area> newAreas = new ArrayList<LandUser2Area>();
            for (String regionCode : sjsfArr) {
                if (usableAreas.contains(regionCode)) {
                    usableAreas.remove(regionCode);
                } else if (disabledAreas.contains(regionCode)) {
                    newUsableAreas.add(regionCode);
                    disabledAreas.remove(regionCode);
                } else {
                    LandUser2Area userArea = new LandUser2Area();
                    userArea.setCreateTime(new Date());
                    userArea.setRegionCode(regionCode);
                    userArea.setUserId(userDetail.getId());
                    userArea.setState(1);
                    newAreas.add(userArea);
                }
            }

            if (!newAreas.isEmpty()) {
                landUser2AreaDao.saveAll(newAreas);
            }
            if (!newUsableAreas.isEmpty()) {
                landUser2AreaDao.updateStateByRegionAndUser(1, new Date(), userDetail.getId(), newUsableAreas);
            }
            if (!usableAreas.isEmpty()) {
                landUser2AreaDao.updateStateByRegionAndUser(0, new Date(), userDetail.getId(), usableAreas);
            }
        }
        return userDetail;
    }

    public LandUserDetail saveUserDetail(LandUserDetail detail, String regionCode) {

        LandUserDetail userDetail = landUserDetailDao.save(detail);

        boolean isExists = landUser2AreaDao.queryUserAreasIsExists(userDetail.getId(), regionCode) > 0;
        if (!isExists) {
            LandUser2Area userArea = new LandUser2Area();
            userArea.setCreateTime(new Date());
            userArea.setRegionCode(regionCode);
            userArea.setUserId(userDetail.getId());
            userArea.setState(1);
            landUser2AreaDao.save(userArea);
        }

        // 给用户赋“举证人员（10004）”权限
        /*
         * LandUserRole role = new LandUserRole(); role.setUserId(userDetail.getId());
         * role.setRoleId((long)10004); landUserRoleDao.save(role);
         */

        // 给用户赋初始密码123456
        landUserDao.updatePassword(userDetail.getId(), "e10adc3949ba59abbe56e057f20f883e");

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        // 密码过期时间增加3个月
        calendar.add(Calendar.MONTH, 3);
        landUserDao.updatePwdExpirationTime(userDetail.getId(), calendar.getTime());
        return userDetail;
    }

    public void updatePassword(Long userId, String password, String pswtip) {
        landUserDao.updatePassword(userId, password);
        if (pswtip != null && !pswtip.equals("")) {
            landUserDao.updatePwdTip(userId, pswtip);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        // 密码过期时间增加3个月
        calendar.add(Calendar.MONTH, 3);
        landUserDao.updatePwdExpirationTime(userId, calendar.getTime());
        landRegUserDao.updatePassword(userId, password);
    }

    public void updateRname(Long userId, String rname) {
        landUserDao.updateRname(userId, rname);

        landRegUserDao.updateRname(userId, rname);
    }

    public void updatePhone(String phone, Long id) {
        landUserDetailDao.updatePhone(phone, id);
    }

    public List<String> queryUserAreasPendingAval(Long userId) {
        return landUser2AreaDao.queryUserAreasPendingAval(userId);
    }

    public List<Long> queryUserByCode(List<String> codes) {
        return landUser2AreaDao.queryUserByCode(codes);
    }

    public void updateUserYhlb(Integer type, Integer yhlb, Long id) {
        if (yhlb != null) {
            // TODO
            // landRegUserDao.updateUserYhlb(yhlb,0, id);
        }
        // TODO
        // landUserDetailDao.updateEdit(type, id);
    }

    public void updateUserInfo(LandUser user) {
        landUserDao.save(user);
    }

    /**
     * @param yhlb
     * @param userId
     * @param userType
     * @return List<Long>
     * @Title:
     * @author: liux
     * @date: May 5,2018
     * @Description 根据用户类别和用户类型查找用户ID
     */
    public List<Long> queryUserIdByYhlbAndType(Integer yhlb, Long userId, Integer userType) {
        List<Long> result = null;
        if (yhlb != null && userType != null) {
            List<Integer> yhlbs = new ArrayList<Integer>();
            yhlbs.add(1);
            yhlbs.add(2);
            yhlbs.add(3);
            if (yhlb == 1) {// 国家级用户
                // TODO
                // result = landUserDetailDao.queryUserIdByYhlb(userType, yhlbs);
            } else if (yhlb == 2) {// 省级用户
                // 查找省级用户所属的省份
                List<String> code = landUser2AreaDao.queryAreas(userId);
                List<Long> userIdList = landUser2AreaDao.queryUserByCode(code);
                if (userIdList != null && userIdList.size() > 0) {
                    // TODO
                    /*
                     * List<Long> userIdList2 = landUserDetailDao.queryUserIdByYhlb(userType,
                     * yhlbs); if(userIdList2 != null && userIdList2.size()>0){ result =
                     * getRepetition(userIdList,userIdList2); }
                     */
                }
            }
        }
        return result;
    }

    /**
     * 两个list取重复
     *
     * @param list1
     * @param list2
     * @return
     */
    public List<Long> getRepetition(List<Long> list1, List<Long> list2) {
        List<Long> result = new ArrayList<Long>();
        for (Long integer : list2) {// 遍历list1
            if (list1.contains(integer)) {// 如果存在这个数
                result.add(integer);// 放进一个list里面，这个list就是交集
            }
        }
        return result;
    }

    public LandUser queryUserById(Long userId) {
        return landUserDao.queryUserById(userId);
    }

    public LandUser queryUnDelUserById(Long userId) {
        return landUserDao.queryUnDelUserById(userId);
    }

    public List<LandUserDetail> queryListByFilter(String filterParam, String sortParam) {
        return landUserDetailDao.findAll(new QuerySpecification<LandUserDetail>(filterParam),
                QueryParamUtil.parseSortParams(sortParam));
    }

    public List<RegionUser> queryRegionUserList(String filterParam, String sortParam) {
        return regionUserDao.findAll(new QuerySpecification<RegionUser>(filterParam),
                QueryParamUtil.parseSortParams(sortParam));
    }

    public String findSjsf(long userId) {
        return regionUserDao.findSjsf(userId);
    }

    // 获取同事信息
    public List<LandUser> getMyColleagues(Long userid) throws Exception {
        LandUser landUser = landUserDao.findById(userid).orElse(null);
        List<LandUser> users = new ArrayList<LandUser>();
        // 单位名不为空
        if (GutilStr.isNotBlank(landUser.getDepId())) {
            users = landUserDao.queryUsersByDeptid(landUser.getDepId(), userid);
        }
        if (!users.isEmpty()) {
            for (LandUser user : users) {
                YXUser yxUser = yxUserRepository.findById(user.getId()).orElse(null);
                if (yxUser != null) {
                    user.setAccid(yxUser.getAccid());
                }
            }
        }
        return users;
    }


    // 获取同事信息
    /*
    public Page<LandUser> getMyColleagues1(Long ownerId, int start, int limit, String filterParam, String sortParam) throws Exception {

        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(ownerId);
        if (organization2Users.isEmpty()) {
            // 返回空page
            return landUserDao.findAll(new QuerySpecification<LandUser>("Q_id_N_EQ=-1"),
                    PageRequest.of(0, 10, QueryParamUtil.parseSortParams("SORT_id_ASC")));
        }

        String organizationId = organization2Users.get(0).getOrganizationId();

        List<Long> userIds = organization2UserDao.queryUserIdsByOrganizationId(organizationId);
        StringBuilder sb = new StringBuilder();
        for (Long userId : userIds) {
            sb.append(userId);
            sb.append(",");
        }
        filterParam += ";Q_isdel_N_EQ=0;Q_id_N_NE=" + ownerId + ";Q_id_N_IN=" + sb.toString();

        Page<LandUser> myColleagues = this.queryByFilter(filterParam, sortParam, start, limit);
        for (LandUser myColleague : myColleagues) {
            YXUser yxUser = yxUserRepository.findOneByUserId(myColleague.getId());
            if (yxUser != null) {
                myColleague.setAccid(yxUser.getAccid());
            }
            Organization a = new Organization();
            a.setId(organizationId);
            myColleague.setOrganization(a);

            String roleids = "";
            List<String> roleList = userRoleInfoDao.getRoleIdsByUserId(myColleague.getId());
            for (int i = 0; i < roleList.size(); i++) {
                if (GutilStr.isNotBlank(roleids)) {
                    roleids += ",";
                }
                roleids += roleList.get(i);
            }
            myColleague.setRoleIds(roleids);
        }
        return myColleagues;

    }
    */
    public Page<LandUser> getMyColleagues1(Long ownerId, int start, int limit, String filterParam, String sortParam) throws Exception {
        // 通过用户-单位 表查询用户单位信息
        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(ownerId);
        if (organization2Users.isEmpty()) {
            // 返回空page
            return landUserDao.findAll(new QuerySpecification<LandUser>("Q_id_N_EQ=-1"),
                    PageRequest.of(0, 10, QueryParamUtil.parseSortParams("SORT_id_ASC")));
        }
        // 单位id (目前认为只有一个)
        String organizationId = organization2Users.get(0).getOrganizationId();
        // 获取用户id列表
        List<Long> userIds = organization2UserDao.queryUserIdsByOrganizationId(organizationId);
        StringBuilder sb = new StringBuilder();
        for (Long userId : userIds) {
            sb.append(userId);
            sb.append(",");
        }
        filterParam += ";Q_isdel_N_EQ=0;Q_id_N_NE=" + ownerId + ";Q_id_N_IN=" + sb.toString();

        Page<LandUser> myColleagues = this.queryByFilter(filterParam, sortParam, start, limit);
        for (LandUser myColleague : myColleagues) {
            YXUser yxUser = yxUserRepository.findOneByUserId(myColleague.getId());
            if (yxUser != null) {
                myColleague.setAccid(yxUser.getAccid());
            }
            Organization a = new Organization();
            a.setId(organizationId);
            myColleague.setOrganization(a);

            String roleids = "";
            List<String> roleList = userRoleInfoDao.getRoleIdsByUserId(myColleague.getId());
            for (int i = 0; i < roleList.size(); i++) {
                if (GutilStr.isNotBlank(roleids)) {
                    roleids += ",";
                }
                roleids += roleList.get(i);
            }
            myColleague.setRoleIds(roleids);
        }
        return myColleagues;

    }

    /**
     * 李密浩：获取我的同事Service
     *
     * @param userId             用户Id
     * @param pageIndex          页码
     * @param rows               每页条数
     * @param colleaguesDep      同事部门
     * @param colleaguesName     同事姓名
     * @param colleaguesCategory 同事类别
     * @return
     * @throws Exception
     */
    public Map<String, Object> getMyCol(Long userId, int pageIndex, int rows, String colleaguesDep, String colleaguesName, String colleaguesCategory) throws Exception {
        Map<String, Object> map = new HashMap<>();
        //获取用户单位信息
        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(userId);
        //判断用户单位信息是否存在
        if (organization2Users.isEmpty()) {
            // 返回空page
            map.put("list", null);
            map.put("total", 0);
            map.put("filter", 0);
            return map;
        }

        //默认现在只有一个单位
        String organizationId = organization2Users.get(0).getOrganizationId();
        //获取单位下所有用户的id 统计总数时使用
        List<Long> totalUserIds = organization2UserDao.queryUserIdsByOrganizationId(organizationId)
                .stream().filter(r -> !r.equals(userId)).collect(Collectors.toList());

        //通过单位Id查找属于该单位的所有用户
        List<Long> userIds = new ArrayList<>();
        StringBuilder sb = new StringBuilder();

        //判断部门筛选条件是否为空
        if (!"".equals(colleaguesDep)) {
            List<BigDecimal> bigDecimals = departmentDao.getUserIdByDepId(colleaguesDep, organizationId);
            //判断用户类别筛选条件是否为空
            //null代表未筛选类别
            if (colleaguesCategory == null) {
                for (BigDecimal bigDecimal : bigDecimals) {
                    userIds.add(Long.parseLong(bigDecimal.toString()));
                }
            } else if ("".equals(colleaguesCategory)) {
                //空代表普通用户
                String sql = "select g.userid from " +
                        "(select r.f_userid userid, string_agg(r.f_roleinfoid,',') agg from tbsys_user_roleinfo r where f_userid " +
                        "in( " + GutilStr.join(bigDecimals, ",") + " ) group by r.f_userid) g  " +
                        "where g.agg not like '%10020%' and g.agg not like '%10022%'";
                userIds = jdbcTemplate.queryForList(sql, Long.class);
            } else {
                List<Long> tempUserIds = new ArrayList<>();
                for (BigDecimal bigDecimal : bigDecimals) {
                    tempUserIds.add(Long.parseLong(bigDecimal.toString()));
                }
                //否则是联络员管理员查询
                userIds = userRoleInfoDao.queryUserIdsByUserIdAndRole(tempUserIds, colleaguesCategory);
            }
        } else {
            //无部门筛选时
            if (colleaguesCategory == null) {
                userIds = organization2UserDao.queryUserIdsByOrganizationId(organizationId);

            } else if ("".equals(colleaguesCategory)) {
                //空代表普通用户
                String sql = "select g.userid from " +
                        "(select r.f_userid userid, string_agg(r.f_roleinfoid,',') agg from tbsys_user_roleinfo r where f_userid " +
                        "in( " + GutilStr.join(totalUserIds, ",") + " ) group by r.f_userid) g  " +
                        "where g.agg not like '%10020%' and g.agg not like '%10022%'";
                userIds = jdbcTemplate.queryForList(sql, Long.class);
            } else {
                List<BigDecimal> bigDecimals = organization2UserDao.getUserIdsByOrgIdAndRoleId(organizationId, colleaguesCategory);
                for (BigDecimal bigDecimal : bigDecimals) {
                    userIds.add(Long.parseLong(bigDecimal.toString()));
                }
            }
        }
        //去除自身
        userIds = userIds.stream().filter(r -> !r.equals(userId)).collect(Collectors.toList());
        //将按照条件查询到的用户Id拼接
        for (Long userid : userIds) {
            sb.append(userid);
            sb.append(",");
        }
        //根据传递过来的筛选条件动态拼接字符串
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" select g.agg,u.* from tbsys_user u," +
                " (select r.f_userid,string_agg(r.f_roleinfoid,',') agg from tbsys_user_roleinfo r where 1=1  ");
        //拼接用户id
        if (!"".equals(sb.toString())) {
            stringBuilder.append(" and r.f_userid in ( " + sb.toString().substring(0, sb.toString().length() - 1) + " ) ");
        } else {
            stringBuilder.append(" and r.f_userid in ( 0 ) ");
        }
        stringBuilder.append(" group by r.f_userid ) g ");

        stringBuilder.append("where  u.f_isdeleted=0  and g.f_userid=u.f_userid ");
        //用户名真实姓名查询
        if (!"".equals(colleaguesName)) {
            com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject(colleaguesName);
            //判断搜索类型 用户名/真实姓名
            if (jsonObject != null && jsonObject.get("type").equals("username")) {
                stringBuilder.append(" and  u.f_username like '%" + jsonObject.get("name") + "%' ");
            } else if (jsonObject != null && jsonObject.get("type").equals("rname")) {
                stringBuilder.append(" and u.f_rname like '%" + jsonObject.get("name") + "%' ");
            }
        }
        stringBuilder.append(" and u.f_userid != " + userId + " ");

        //筛选数量统计
        String filterCount = stringBuilder.toString().replace("g.agg,u.*", "count(1)");
        Integer filter = jdbcTemplate.queryForObject(filterCount, Integer.class);
        //按照管理员 联络员排序
        stringBuilder.append("order by \n" +
                " case \n" +
                "\t\twhen g.agg like '%10022%' then '400'\n" +
                "\t\twhen g.agg like '%10020%' then '300'\n" +
                "\t\telse '200'\n" +
                " end desc ");
        stringBuilder.append(" limit " + rows + " offset " + pageIndex * rows);
        //设置搜索字段
        String param = stringBuilder.toString();
        //查询同事列表
        List<LandUser> myColleagues = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList(stringBuilder.toString());
        for (Map<String, Object> userMap : list) {
            LandUser landUser = new LandUser();
            landUser.setId(Long.valueOf(userMap.get("f_userid").toString()));
            landUser.setName(userMap.get("f_username").toString());
            landUser.setRname(userMap.get("f_rname") != null ? userMap.get("f_rname").toString() : null);
            landUser.setIsdel(userMap.get("f_isdeleted") != null ? Integer.valueOf(userMap.get("f_isdeleted").toString()) : null);
            landUser.setPhone(userMap.get("f_phonemobile") != null ? userMap.get("f_phonemobile").toString() : null);
            landUser.setState(userMap.get("f_state") != null ? Integer.valueOf(userMap.get("f_state").toString()) : null);
            landUser.setDepId(userMap.get("f_depid") != null ? userMap.get("f_depid").toString() : null);
            landUser.setSjsf(userMap.get("f_sjsf") != null ? userMap.get("f_sjsf").toString() : null);
            myColleagues.add(landUser);
        }

        //根据同事列表查询同事id
        for (LandUser myColleague : myColleagues) {
            YXUser yxUser = yxUserRepository.findOneByUserId(myColleague.getId());
            if (yxUser != null) {
                myColleague.setAccid(yxUser.getAccid());
            }
            Organization a = new Organization();
            a.setId(organizationId);
            myColleague.setOrganization(a);

            String roleids = "";
            List<String> roleList = userRoleInfoDao.getRoleIdsByUserId(myColleague.getId());
            for (int i = 0; i < roleList.size(); i++) {
                if (GutilStr.isNotBlank(roleids)) {
                    roleids += ",";
                }
                roleids += roleList.get(i);
            }
            myColleague.setRoleIds(roleids);
        }
        map.put("list", myColleagues);
        map.put("total", totalUserIds.size());
        map.put("filter", filter);
        return map;
    }

    /**
     * 获取和管理员同一个单位下的所有同事列表
     * <p>
     * 12.24新增 县级主管单位管理员可以获取县级所有用户
     *
     * @param userid
     * @return
     * @throws Exception
     */
    public Page<LandUser> getUserOfSameDept(Long userid, String filterParam, String sortParam, int page, int size)
            throws Exception {
        LandUser landUser = landUserDao.findById(userid).orElse(null);
        String depId = landUser.getDepId();
        if (GutilStr.isNotBlank(depId)) {
            // 判断管理员的单位是否为县级主管单位
            List<Organization> organizations = organizationRepository.queryOneByName(depId);
            if (organizations.isEmpty()) {
                throw new RuntimeException("单位数据异常, 无对应单位");
            }
            Organization organization = organizations.get(0);
            // 如果是, 查询该县所有用户
            if (organization != null && organization.getLevel() != null && organization.getLevel() == 4) {
                filterParam += ";Q_isdel_N_EQ=0;Q_sjsf_S_EQ=" + organization.getRegionCode();
            } else {
                filterParam += ";Q_isdel_N_EQ=0;Q_depId_S_EQ=" + depId;
            }
            Page<LandUser> Colleagues = landUserDao.findAll(new QuerySpecification<LandUser>(filterParam),
                    PageRequest.of(page, size, QueryParamUtil.parseSortParams(sortParam)));
            for (LandUser user : Colleagues) {
                List<String> roles = userRoleInfoDao.getRoleIdsByUserId(user.getId());
                completeLandUserInfo(user, roles);
            }
            return Colleagues;
        } else {
            throw new RuntimeException("管理员数据异常，无单位");
        }
    }

    public Map<String, Object> getUsersByOrgIdAndDepaId(String orgId, String depaId, int userType, String filterParam,
                                                        String sortParam, String phone, int start, int limit, Date date, Integer state, String role) throws
            Exception {
        List<Long> idList = new ArrayList<>();
        if (GutilStr.isNotBlank(depaId)) {
            idList = department2UserDao.queryUserIdsByDepaId(depaId);
        } else {
            if (GutilStr.isBlank(orgId)) {
                throw new RuntimeException("部门和单位id不能同时为空");
            }
            idList = getUserIdsByOrgIdAndUserType(orgId, userType);
        }

        if (idList.isEmpty()) {
            // 没有员工则返回空
            return null;
        } else {

            StringBuffer keyword = new StringBuffer("%");
            if (GutilStr.isNotBlank(filterParam) && filterParam.indexOf("Q_name_S_Lk=") != -1) {
                int index = filterParam.indexOf("=");
                keyword.append(filterParam.substring(index + 1));
            }
            keyword.append("%");
            List<LandUser> landUsers = new ArrayList<>();
            //如果时间未传，则不按照时间查询最新修改的用户
            if (date == null) {
                List<Map<String, Object>> tempUserList = null;
                String sql = "select u.* from tbsys_user as u left join ( select t.f_userid userid,string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t   group by t.f_userid ) as g on g.userid = u.f_userid ";
                sql += " where u.f_userid in (" + GutilStr.join(idList, ",") + " ) ";
                if (!role.equals("")) {
                    if (role.equals("1")) {
                        sql += " and ( g.agg  not like '%" + "10022" + "%' and g.agg  not like '%" + "10020" + "%' )";
                    } else {
                        if (role.equals("2")) {
                            role = "10022";
                            sql += " and g.agg like '%" + role + "%' ";
                        } else {
                            role = "10020";
                            sql += " and g.agg like '%" + role + "%'";
                        }
                    }
                }
                sql += " and u.f_isdeleted =0 and u.f_userid<>101 ";
                sql += " and (u.f_username like '" + keyword + "' or u.f_phonemobile like '" + keyword + "')";
                if (state != null) {
                    sql += " and u.f_state=" + state + " ";
                }
                sql += "order by case when g.agg like '%101%' then '400' when g.agg like '%10022%' then '300' when g.agg like '%10020%' then '200' else '100' end desc, u.f_rname asc";
                tempUserList = jdbcTemplate.queryForList(sql);
                LandUser user = null;
                for (Map<String, Object> map : tempUserList) {
                    user = new LandUser();
                    user.setId(Long.valueOf(map.get("f_userid").toString()));
                    user.setRname(map.get("f_rname") != null ? map.get("f_rname").toString() : "");
                    user.setName(map.get("f_username") != null ? map.get("f_username").toString() : "");
                    user.setPhone(map.get("f_phonemobile") != null ? map.get("f_phonemobile").toString() : "");
                    user.setDepId(map.get("f_depid") != null ? map.get("f_depid").toString() : "");
                    user.setPost(map.get("f_post") != null ? map.get("f_post").toString() : null);
                    user.setDeviceType(map.get("f_devicetype") != null ? Integer.valueOf(map.get("f_devicetype").toString()) : null);
                    landUsers.add(user);
                }

            } else {
                landUsers = landUserDao.queryUserByIds4Time(idList, keyword.toString(), "%" + phone + "%", date);
            }
            // 同时从新表中取出角色关联
//            List<LandUser> landUsers2=landUserDao.queryUserByIds3(idList, keyword.toString());
//            if(landUsers2.size()>0){
//                landUsers.addAll(landUsers2);
//            }

            Set<LandUser> set = new LinkedHashSet<LandUser>(landUsers);
            List<LandUser> users = new ArrayList<LandUser>(set);
            // 手动分页
            List<LandUser> result = new ArrayList<LandUser>();
            int currIdx = (start > 0 ? start * limit : 0);
            for (int i = 0; i < limit && i < users.size() - currIdx; i++) {
                // 注入用户角色 云查询 部门 区域名
                LandUser user = new LandUserBuilder(users.get(currIdx + i)).role().cloudArea().organization().department().regionFullName().build();

                // 用户单位id
                if (GutilStr.isNotBlank(orgId)) {
                    user.setDepNo(orgId);
                } else {
                    Department department = departmentDao.findById(depaId).orElse(null);
                    if (department == null) {
                        throw new RuntimeException("部门id有误");
                    }
                    user.setDepNo(department.getOrgId());
                }
                if (user.getPhone() != null && !user.getPhone().equals("")) {
                    if (user.getPhone().length() == 11) {
                        user.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
                    }
                }
                result.add(user);
            }
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("total", users.size());
            map.put("content", result);
            return map;
        }
    }

    /**
     * 用户管理根据用户用户政区查询
     *
     * @param regionCode
     * @param keyword
     * @param state
     * @param role
     * @param start
     * @param limit
     * @return
     * @throws Exception
     */
    public Map<String, Object> getUsersByRegionCode(String regionCode, String keyword, Integer state, String role, int start, int limit) throws Exception {
        List<LandUser> landUsers = new ArrayList<>();
        List<Map<String, Object>> tempUserList = null;
        String sql = "select u.* from tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid," +
                "string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        String countsql = "select count(1) from tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid," +
                "string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        if (!role.equals("")) {
            if (role.equals("1")) {
                sql += " and ( g.agg  not like '%" + "10022" + "%' and g.agg  not like '%" + "10020" + "%' )";
                countsql += " and ( g.agg  not like '%" + "10022" + "%' and g.agg  not like '%" + "10020" + "%' )";
            } else {
                if (role.equals("2")) {
                    role = "10022";
                    sql += " and g.agg like '%" + role + "%' ";
                    countsql += " and g.agg like '%" + role + "%' ";
                } else {
                    role = "10020";
                    sql += " and g.agg like '%" + role + "%'";
                    countsql += " and g.agg like '%" + role + "%'";
                }
            }
        }
        sql += " and u.f_isdeleted =0 and u.f_userid<>101 ";
        countsql += " and u.f_isdeleted =0 and u.f_userid<>101 ";
        if (!keyword.equals("")) {
            sql += " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
            countsql += " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
        }
        if (state != null) {
            sql += " and u.f_state=" + state + " ";
            countsql += " and u.f_state=" + state + " ";
        }
        if (regionCode != null) {
            sql += " and ua.f_regioncode='" + regionCode + "' ";
            countsql += " and ua.f_regioncode='" + regionCode + "' ";
        }

        sql += "order by case when g.agg like '%101%' then '400' when g.agg like '%10022%' then '300' when g.agg like '%10020%' then '200' else '100' end desc, u.f_rname asc";
        start = (start - 1) * limit;
        sql += " limit " + limit + " offset " + start;
        tempUserList = jdbcTemplate.queryForList(sql);
        Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
        for (Map<String, Object> map : tempUserList) {
            LandUser user = new LandUser();
            user.setId(Long.valueOf(map.get("f_userid").toString()));
            user.setRname(map.get("f_rname") != null ? map.get("f_rname").toString() : "");
            user.setName(map.get("f_username") != null ? map.get("f_username").toString() : "");
            user.setPhone(map.get("f_phonemobile") != null ? map.get("f_phonemobile").toString() : "");
            user.setDepId(map.get("f_depid") != null ? map.get("f_depid").toString() : "");
            user = new LandUserBuilder(user).role().cloudArea().organization().department().regionFullName().build();
            // Department department = departmentDao.findById(user.getDepId());
            //user.setDepNo(department.getOrgId());
            if (user.getPhone() != null && !user.getPhone().equals("")) {
                if (user.getPhone().length() == 11) {
                    user.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
                }
            }
            landUsers.add(user);
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("total", count);
        map.put("content", landUsers);
        return map;
    }

    public Map<String, Object> getHNUsersByRegionCode(String regionCode, String keyword, Integer state, String role,
                                                      int start, int limit) throws Exception {
        List<LandUser> landUsers = new ArrayList<>();
        List<Map<String, Object>> tempUserList = null;
        String sql = "select u.f_userid,u.f_rname,u.f_username,u.f_post,u.f_phonemobile,g.agg,ua.f_regioncode " +
                "from  tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid," +
                "string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        String countsql = "select count(1) from tbsys_user as u,tbsys_user_area as ua,( select t.f_userid userid," +
                "string_agg(t.f_roleinfoid,',') agg from tbsys_user_roleinfo as t group by t.f_userid ) as g where g.userid = u.f_userid and u.f_userid = ua.f_userid ";
        if (!role.equals("") && role != null) {
            sql += " and g.agg like '%" + role + "%'";
            countsql += " and g.agg like '%" + role + "%'";
        }
        sql += " and u.f_isdeleted =0 and u.f_userid<>101 ";
        countsql += " and u.f_isdeleted =0 and u.f_userid<>101 ";
        if (!keyword.equals("")) {
            sql += " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
            countsql += " and (u.f_username like '%" + keyword + "%' or u.f_phonemobile like '%" + keyword + "%')";
        }
        if (state != null) {
            sql += " and u.f_state=" + state + " ";
            countsql += " and u.f_state=" + state + " ";
        }
        if (regionCode != null) {
            if (regionCode.length() <= 6 && regionCode.endsWith("00")) {
                regionCode = regionCode.replace("00", "");
            }
            sql += " and ua.f_regioncode like '" + regionCode + "%' ";
            countsql += " and ua.f_regioncode like '" + regionCode + "%'";
        }

        sql += "order by case when g.agg like '%10038%' then '400' when g.agg like '%10039%' then '300' when g.agg like '%10031%' then '200' " +
                "when g.agg like '%10032%' then '190' when g.agg like '%10033%' then '180' when g.agg like " +
                "'%10034%' then '170' when g.agg like '%10035%' then '160' when g.agg like '%10036%' then '150' else '100' end desc, u.f_rname asc";
        start = (start - 1) * limit;
        sql += " limit " + limit + " offset " + start;
        tempUserList = jdbcTemplate.queryForList(sql);
        Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
        for (Map<String, Object> map : tempUserList) {
            LandUser user = new LandUser();
            user.setId(Long.valueOf(map.get("f_userid").toString()));
            user.setRname(map.get("f_rname") != null ? map.get("f_rname").toString() : "");
            user.setName(map.get("f_username") != null ? map.get("f_username").toString() : "");
            user.setPhone(map.get("f_phonemobile") != null ? map.get("f_phonemobile").toString() : "");
            user.setPost(map.get("f_post") != null ? map.get("f_post").toString() : "");
            user.setRoleIds(map.get("agg") != null ? map.get("agg").toString() : "");
            user.setRegionFullName(regionService.getName(map.get("f_regioncode").toString()));
/*
                    user.setRegionFullName(landRegUserService.getMyRegionByCode(map.get("f_regioncode").toString()).getFullName());
*/
            user = new LandUserBuilder(user).build();
                    /*if(user.getPhone()!=null &&  !user.getPhone().equals("")){
                        if(user.getPhone().length()==11) {
                            user.setPhone(user.getPhone().substring(0, 3) + "****" + user.getPhone().substring(7));
                        }
                    }*/
            landUsers.add(user);
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("total", count);
        map.put("content", landUsers);
        return map;
    }

    private List<Long> getUserIdsByOrgIdAndUserType(String orgId, int userType) {
        List<Long> idList = new ArrayList<>();
        if (userType == 0) {
            idList = organization2UserDao.queryUserIdsByOrganizationId(orgId);
        } else if (userType == 1) {//已启用
            idList = organization2UserDao.queryIdsOfUsedByOrgId(orgId);
        } else if (userType == 2) {//未启用
            idList = organization2UserDao.queryIdsOfNotUsedByOrgId(orgId);
        }
        return idList;
    }


    public Map<String, Object> getUsersByBizIdAndBizArea(String bizId, String name, String phone, String bizArea, int
            start, int limit) throws
            Exception {
        return getUsersByBizIdAndBizAreaAndBizRoleId(null, bizId, name, phone, bizArea, null, start, limit);
    }

    public Map<String, Object> getUsersByBizIdAndBizAreaAndBizRoleId(Long userId, String bizId, String name, String phone, String bizArea, String bizRoleId, int
            start, int limit) throws
            Exception {
        List<LandUser> list = null;
        Long count = 0L;
        boolean phoneFilter=false;
        String nameLike = "%" + name + "%";
        if(StringUtils.isNotBlank(phone))
        {
            if (!CheckUtil.isMobile(phone)) {
                throw  new Exception("手机号码格式不正确");
            }
           BusUserInfoReso busUserInfoReso = oauthUserService.getBusUserByPhone(phone);
            if(busUserInfoReso==null)
            {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("total", count);
                map.put("content", null);
                return map;
            }
            name = busUserInfoReso.getUserName();
            phoneFilter = true;
        }


        if (bizRoleId == null) {
            //list = landUserDao.getUsersByBizIdAndBizArea(bizId, phone, name, bizArea, limit, start);
            //count = landUserDao.getUsersByBizIdAndBizAreaCount(bizId, phone, name, bizArea);
            if(!phoneFilter) {
                list = landUserDao.getUsersByBizIdAndBizAreaAndNameLike(bizId, nameLike, bizArea, limit, start);
                count = landUserDao.getUsersByBizIdAndBizAreaAndNameLikeCount(bizId, nameLike, bizArea);
            }
            else
            {
                list = landUserDao.getUsersByBizIdAndBizAreaAndName(bizId, name,nameLike, bizArea, limit, start);
                count = landUserDao.getUsersByBizIdAndBizAreaAndNameCount(bizId, name,nameLike, bizArea);
            }
        } else {
            //获取当前用户的管理区
            List<String> regionAreas = new ArrayList<>();
            regionAreas = tbtskUserManageAreaService.listManageAreas(bizId, userId.toString()).stream().map(r -> r.getRegioncode()).collect(Collectors.toList());
            if (regionAreas.isEmpty()) {
                throw new GwValidateException("用户无本任务管理区");
            }
            list = createSQLByBizIdAndUserRole(bizId, bizRoleId, regionAreas, limit, start, name, nameLike);
            count = createSQLByBizIdAndUserRoleCount(bizId, bizRoleId, regionAreas, name, nameLike);

        }

        List<LandUser> result = new ArrayList<>(list.size());
        for (int i = 0; i < list.size(); i++) {
            LandUser user =new LandUserBuilder(list.get(i)).hidePhone().build();;// new LandUserBuilder(list.get(i)).regionFullName().organization().hidePhone().build();
              /* LandUser user = new LandUserBuilder(list.get(i)).regionFullName().organization().bizRole(bizId).hidePhone().build();*/
            /*
            if (GutilStr.isNotBlank(user.getDepname())) {
                user.setDepId(user.getDepname());
            }
            */
            if(StringUtils.isNotBlank(user.getSubjectUserId())) {
                BusUserInfoReso userReso = oauthUserService.getBusUser(user.getSubjectUserId());
                if (userReso != null) {
                    user.setRname(userReso.getRealName());
                    user.setPhone(userReso.getPhone());
                    user.setRoleIds(oauthUserService.getRoleIdByOrgRole(userReso.getOrgRole(),userReso.getRegionCode()));
                    user.setSjsf(userReso.getRegionCode());
                    user.setRegionCode(userReso.getRegionCode());
                    Organization org = new Organization();
                    org.setId(userReso.getOrgId());
                    org.setName(userReso.getOrgName());
                    user.setOrganization(org);

                    LandRegUserService landRegUserService = Gw.beans.getBean(LandRegUserService.class);
                    String xzqdm = userReso.getRegionCode();
                    if (GutilStr.isNotBlank(xzqdm)) {
                        String fullRegionName = null;
                        try {
                            fullRegionName = landRegUserService.getMyRegionByCode(xzqdm).getFullName();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        user.setRegionFullName(fullRegionName);
                    }
                }
            }
            if(StringUtils.isNotBlank(bizId)){
                List<User2Biz> user2Bizs = user2BizRepository.getByBizidAndUserid(bizId, user.getId());
                String bizRole = "";
                for (int j = 0; j < user2Bizs.size(); j++) {
                    if (user2Bizs.get(j).getRole() == null) {
                        continue;
                    }
                    if (StringUtils.isNotBlank(bizRole)) {
                        bizRole += "," + user2Bizs.get(j).getRole();
                    } else {
                        bizRole = user2Bizs.get(j).getRole() + "";
                    }
                }
                user.setBizRole(bizRole);
            }
            result.add(user);
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("total", count);
        map.put("content", result);
        return map;
    }


    public Map<String, Object> getUsersByBizIdAndBizAreasAndBizRoleId(String bizId, String name, String phone,
                                                                      List<String> bizAreas, Integer bizRoleId, String orgId, int start, int limit) throws Exception {
        List<LandUser> list = null;
        Map<String, Object> map = new HashMap<String, Object>();
        Long count = 0L;
        if (bizAreas.size() < 1) {
            map.put("total", count);
            map.put("content", null);
            return map;
        }
        String bizAreaList = "(";
        for (String s : bizAreas) {
            Integer regionLevel = regionService.getRegionLevel(s, null);
            if (regionLevel == 0) {
                bizAreaList += "|";
            } else if (regionLevel == 1) {
                bizAreaList += s.substring(0, 2) + "|";
            } else if (regionLevel == 2) {
                bizAreaList += s.substring(0, 4) + "|";
            } else {
                bizAreaList += s + "|";
            }
        }
        if (bizRoleId == null) {
            if (GutilStr.isBlank(orgId)) {
                String s = bizAreaList.substring(0, bizAreaList.length() - 1) + ")%";
                list = landUserDao.getUsersByBizIdAndRightAreas(bizId, name, bizAreaList.substring(0, bizAreaList
                        .length() - 1) + ")%", limit, start);
                count = landUserDao.getUsersByBizIdAndRightAreasCount(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%");

                //list = landUserDao.getUsersByBizIdAndRightAreas(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", limit, start);
                //count = landUserDao.getUsersByBizIdAndRightAreasCount(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%");
            } else {
                list = landUserDao.getUsersByBizIdAndRightAreasAndOrgId(bizId, phone, name, bizAreaList.substring(0, bizAreaList
                        .length() - 1) + ")%", orgId, limit, start);
                count = landUserDao.getUsersByBizIdAndRightAreasAndOrgIdCount(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", orgId);

            }
        } else {
            if (GutilStr.isBlank(orgId)) {
                list = landUserDao.getUsersByBizIdAndBizAreasAndBizRoleId(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, limit, start);
                count = landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdCount(bizId, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId);
                //list = landUserDao.getUsersByBizIdAndBizAreasAndBizRoleId(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, limit, start);
                //count = landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdCount(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId);
            } else {
                list = landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdAndOrgId(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, orgId, limit, start);
                count = landUserDao.getUsersByBizIdAndBizAreasAndBizRoleIdAndOrgIdCount(bizId, phone, name, bizAreaList.substring(0, bizAreaList.length() - 1) + ")%", bizRoleId, orgId);
            }
        }

        List<LandUser> result = new ArrayList<>(list.size());
        for (int i = 0; i < list.size(); i++) {
            /*  LandUser user = new LandUserBuilder(list.get(i)).regionFullName().organization().bizRole(bizId).hidePhone().build();*/
            LandUser user = new LandUserBuilder(list.get(i)).regionFullName().organization().hidePhone().build();
            if (GutilStr.isNotBlank(user.getDepname())) {
                user.setDepId(user.getDepname());
            }
            if(StringUtils.isNotBlank(user.getSubjectUserId())) {
                BusUserInfoReso userReso = oauthUserService.getBusUser(user.getSubjectUserId());
                if (userReso != null) {
                    user.setRname(userReso.getRealName());
                    user.setPhone(userReso.getPhone());
                }
            }
            result.add(user);
        }
        map.put("total", count);
        map.put("content", result);
        return map;
    }

    public EasyUIResponse getUsersHasOrgButDep(String orgId, String filterParam, int start, int limit, Date date) throws Exception {
        if (GutilStr.isBlank(orgId)) {
            throw new RuntimeException("单位id不能为空");
        }
        StringBuffer keyword = new StringBuffer("%");
        if (GutilStr.isNotBlank(filterParam) && filterParam.length() > 14) {
            keyword.append(filterParam, 13, filterParam.length() - 1);
        }
        keyword.append("%");
        List<LandUser> landUsers = null;
        Long count = 0L;
        //判断时间是否为空，不为空查询最新更新的用户信息
        if (date == null) {
            landUsers = landUserDao.hasOrgButDep(orgId, keyword.toString(), start - 1, limit);
            count = landUserDao.countUserhasOrgButDep(orgId, keyword.toString());
        } else {
            landUsers = landUserDao.hasOrgButDepTime(orgId, keyword.toString(), start - 1, limit, date);
            count = landUserDao.countUserhasOrgButDepTime(orgId, keyword.toString(), date);
        }

        for (LandUser user : landUsers) {
            List<String> roles = userRoleInfoDao.getRoleIdsByUserId(user.getId());
            completeLandUserInfo(user, roles);
            user.setDepNo(orgId);
        }
        EasyUIResponse result = new EasyUIResponse();
        result.setRows(landUsers);
        result.setTotal(count);
        return result;
    }

    /**
     * 超级管理员获取所有用户列表
     */
    public Page<LandUser> queryAllUser(String filterParam, String sortParam, int page, int size) throws Exception {
        filterParam += ";Q_isdel_N_EQ=0;Q_name_S_NE=admin;";

        Page<LandUser> allUsers = landUserDao.findAll(new QuerySpecification<LandUser>(filterParam),
                PageRequest.of(page, size, QueryParamUtil.parseSortParams(sortParam)));
        for (LandUser user : allUsers) {
            List<String> roles = userRoleInfoDao.getRoleIdsByUserId(user.getId());
            completeLandUserInfo(user, roles);
        }
        return allUsers;
    }


    // 完善用户信息
    public void completeLandUserInfo2(LandUser user, List<String> roles) throws Exception {
        if (roles.indexOf("10007") > -1) {
            user.setUserType("公众用户");
        } else {
            user.setUserType("管理用户");
        }

        if (roles.indexOf("10012") > -1) {
            user.setRoleNames("国家级用户");
        } else if (roles.indexOf("10003") > -1) {
            user.setRoleNames("省级用户");
        } else if (roles.indexOf("10018") > -1) {
            user.setRoleNames("市级用户");
        } else if (roles.indexOf("10019") > -1) {
            user.setRoleNames("县级用户");
        }
        if (roles.indexOf("10020") > -1) {
            user.setLiaison(true);
        }

        user.setRoleIds(roles.stream().collect(Collectors.joining(",")));

        // 获取用户的行政区代码
        LandUser2Area user2Area = landUser2AreaDao.queryOneByUserId(user.getId());
        if (user2Area == null) {
            return;
            // throw new RuntimeException("用户未挂接行政区信息");
        }
        String xzqdm = user2Area.getRegionCode();
        if (GutilStr.isNotBlank(xzqdm)) {
            String fullRegionName = landRegUserService.getMyRegionByCode(xzqdm).getFullName();
            user.setRegionFullName(fullRegionName);
        }
        List<UserCloudArea> cloudArea = userCloudAreaDao.getCloudArea(user.getId());
        user.setCloudAreas(cloudArea);

    }


    // 完善用户信息
    public void completeLandUserInfo(LandUser user, List<String> roles) throws Exception {
        if (roles.contains("10007")) {
            user.setUserType("公众用户");
        } else {
            user.setUserType("管理用户");
        }

        if (roles.contains("10012")) {
            user.setRoleNames("国家级用户");
        } else if (roles.contains("10003")) {
            user.setRoleNames("省级用户");
        } else if (roles.contains("10018")) {
            user.setRoleNames("市级用户");
        } else if (roles.contains("10019")) {
            user.setRoleNames("县级用户");
        }
        if (roles.contains("10020")) {
            user.setLiaison(true);
        }

        // 获取用户的行政区代码
        LandUser2Area user2Area = landUser2AreaDao.queryOneByUserId(user.getId());
        if (user2Area == null) {
            return;
            // throw new RuntimeException("用户未挂接行政区信息");
        }
        String xzqdm = user2Area.getRegionCode();
        if (GutilStr.isNotBlank(xzqdm)) {
            String fullRegionName = landRegUserService.getMyRegionByCode(xzqdm).getFullName();
            user.setRegionFullName(fullRegionName);
        }
        List<UserCloudArea> cloudArea = userCloudAreaDao.getCloudArea(user.getId());
        user.setCloudAreas(cloudArea);

    }

    // 超级管理员删除用户
    public void deleteUserByAdmin(Long userId, String deleteReason, Long operatorId) throws Exception {
        deleteUser(userId, deleteReason, operatorId);
    }

    // l管理员删除用户
    public void deleteUserByLiaison(Long operatorId, Long userId, String deleteReason) throws Exception {
        //首先获取被删除的用户权限
        List<String> deleUsroldids = userRoleInfoDao.getRoleIdsByUserId(userId);
//        if (deleUsroldids.indexOf("10020")>-1) {
//            throw new RuntimeException("联络员无法被删除！");
//        }

        // 校验;管理员权限
        List<String> operatorRoleIds = userRoleInfoDao.getRoleIdsByUserId(operatorId);
        // List<Long> operatorRoleIds = landUserRoleDao.findRoleIdsByUserId(operatorId);
        if (operatorRoleIds.indexOf("10022") < 0 && operatorRoleIds.indexOf("10020") < 0) {
            throw new RuntimeException("无权限");
        }
        if (deleUsroldids.indexOf("10022") > -1) {
            throw new RuntimeException("管理员不可被注销");
        }
        //操作人员是联络员
        if (operatorRoleIds.indexOf("10020") > -1) {
            if (deleUsroldids.indexOf("10022") > -1 || deleUsroldids.indexOf("10020") > -1) {
                throw new RuntimeException("权限不足");
            }
        }
        // 判断用户是否为管理员
//        List<Long> userRoles = landUserRoleDao.findRoleIdsByUserId(userId);
//        if (userRoles.contains(10020L)) {
//            throw new RuntimeException("不能删除管理员");
//        }
        deleteUser(userId, deleteReason, operatorId);
    }

    // 注销用户
    public void unregister(Long userId) {
        deleteUser(userId, "用户自主注销", userId);
    }

    private void deleteUser(Long userId, String deleteReason, Long operatorId) {

        // 填写操作日志
        LandUser user = landUserDao.findById(userId).orElse(null);
        user.setDeleteTime(new Date());
        user.setLogoffReson(deleteReason);
        JSONObject userJson = JSONObject.parseObject(JSONObject.toJSONString(user));
        OptLog optLog = new OptLog();
        optLog.setData(userJson.toString());
        optLog.setOptTime(new Date());
        optLog.setOptType(4);
        optLog.setUserId(operatorId);
        optLogRepository.save(optLog);

        //删除用户
        landUserDao.deleteById(userId);

        // 删除用户角色信息
        landUserRoleDao.deleteByUserId(userId);

        //删除用户roleInfo信息
        userRoleInfoDao.deleteByUserId(userId);

        //删除biz2信息
        user2BizRepository.deleteByUserId(userId);

        // 删除用户区域信息
        landUser2AreaDao.deleteAreaByUserId(userId);

        //刪除用戶云查询区域
        userCloudAreaDao.delteByUserId(userId);

        // 删除用户单位信息
        organization2UserDao.deleteByUserId(userId);

        // 删除用户部门信息
        department2UserDao.deleteByUserId(userId);

        // 删除用户好友信息
        friendsDao.deleteByUserId(userId);

        // 删除用户注册信息
        landRegUserDao.deleteByUserId(userId);

        // 删除个人云盘
        deleteCloudDiskOfPerson(userId);

        // 删除uis挂载应用
        userApplicationRepository.deleteByUserid(userId);

        //删除云信
        user2YXDao.deleteByUserId(userId);


    }

    private void deleteCloudDiskOfPerson(Long userId) {
        CloudDiskOfPerson cloudDiskOfPerson = cloudDiskOfPersonDao.findById(userId).orElse(null);
        if (cloudDiskOfPerson == null) {
            return;
        }
        GroupCloudDiskMember groupCloudDiskMember = groupCloudDiskMemberDao.queryOneByUserId(userId);
        OrgCloudDiskMember orgCloudDiskMember = orgCloudDiskMemberDao.queryOneByUserId(userId);
        if (orgCloudDiskMember == null && groupCloudDiskMember == null) {
            try {
                JFunBoxUserUtil.deleteUser(cloudDiskOfPerson.getId());
            } catch (Exception e) {
                e.printStackTrace();
                return;
            }
            cloudDiskOfPersonDao.deleteById(userId);
        }
    }

    // 管理员修改用户角色信息
    public void updateUserRoles(Long userId, String roleIds) throws Exception {
        final String MouldId = "10026";
        if (GutilStr.isBlank(roleIds)) {
            throw new RuntimeException("角色信息为空");
        }
        // 更新云盘相关信息
        //updateCloudDiskByRoles(userId, roleIds);

        // 删除原有角色信息
        // 2.0 与 1.0共用期间  暂不删除1.0下的用户权限
        //landUserRoleDao.deleteByUserId(userId);
        userRoleInfoDao.deleteByUserIdExcept(userId, MouldId);

        // 新增新的角色信息
        String[] roles = roleIds.split(",");
        if (roleIds.indexOf(";") > -1) {
            roles = roleIds.split(";");
        }
        for (String role : roles) {
            //landUserRoleDao.insertRolesByUser(userId, Long.valueOf(role));
            String uid = UUID.randomUUID().toString();
            UserRoleInfo userRole = new UserRoleInfo();
            userRole.setId(uid);
            userRole.setRoleinfoid(role);
            userRole.setUserid(userId);
            userRoleInfoDao.save(userRole);
        }

    }

//    private void updateCloudDiskByRoles(Long userId, String roleIds) throws Exception {
//        // 旧角色信息
//        List<String> oldRoleList=userRoleInfoDao.getRoleIdsByUserId(userId);
//        //  非国家级变为国家级且无个人云盘→ 创建个人云盘
//        if (roleIds.contains("10012")) {
//            CloudDiskOfPerson cloudDiskOfPerson = cloudDiskOfPersonDao.findById(userId);
//            if (cloudDiskOfPerson == null || cloudDiskOfPerson.getIsDeleted() == 1) {
//                cloudDiskUtilService.createPersonalCloudDiskByUserId(userId);
//            }
//        }
//
//        // 国家级变为非国家级→ 云盘账号不是单位公账号→ 删除个人云盘
//        if (oldRoleList.indexOf("10012")>-1 && !roleIds.contains("10012")) {
//            deleteCloudDiskOfPerson(userId);
//        }
//        // 非管理员变为管理员→ 无单位云盘→ 创建单位云盘
//        if (roleIds.contains("10020")) {
//            List<Organization2User> organization2Users = organization2UserDao.queryByUserId(userId);
//            if (organization2Users.isEmpty()) {
//                throw new RuntimeException("单位不存在");
//            }
//            String organizationId = organization2Users.get(0).getOrganizationId();
//            CloudDiskOfOrg cloudDiskOfOrg = cloudDiskOfOrgDao.findById(organizationId);
//            if (cloudDiskOfOrg != null) {
//                return;
//            }
//            List<String> orgIdList = new ArrayList<>();
//            orgIdList.add(organizationId);
//            cloudDiskUtilService.createByOrgIdList(orgIdList, userId);
//        }
//    }



    /**
     * 增加用户
     *
     * @param userInfo
     * @throws Exception
     */
    public LandUser addUser(UserAddInfo userInfo) throws Exception {
        // 先替换过来注册时的手机号
        if (GutilStr.isNotBlank(userInfo.getId()) && userInfo.getPhone().contains("*")) {
            LandRegUser one = landRegUserDao.findById(userInfo.getId()).orElse(null);
            userInfo.setPhone(one.getPhone());
        } else {
            String phoneStr = "^[1][3,4,5,6,7,8,9][0-9]{9}$";
            if (!userInfo.getPhone().matches(phoneStr)) {
                throw new RuntimeException("手机号格式错误");
            } else {
                userInfo.setPhone(userInfo.getPhone());
            }
        }
        if (userInfo.getPassword() != null && !userInfo.getPassword().equals("")) {
            userInfo.setPassword(userInfo.getPassword());
        } else {
            LandRegUser one = landRegUserDao.findById(userInfo.getId()).orElse(null);
            userInfo.setPassword(one.getPassword());
        }

        if (GutilStr.isBlank(userInfo.getUsername())) {
            throw new RuntimeException("用户名不能为空");
        }
        List<LandUser> userOfName = landUserDao.queryUserByName(userInfo.getUsername());
        if (!userOfName.isEmpty()) {
            throw new RuntimeException("该用户名已被注册");
        }
        LandRegUser regUserOfName = landRegUserDao.findOneByName(userInfo.getUsername());

        if (userInfo.getId() != null && !userInfo.getUsername().equals(regUserOfName.getName())) {
            throw new RuntimeException("该用户名已被注册");
        } else if (userInfo.getId() == null && regUserOfName != null) {
            throw new RuntimeException("该用户名已被注册");
        }
        if (GutilStr.isBlank(userInfo.getPassword()) && userInfo.getId() == null) {
            throw new RuntimeException("密码不能为空");
        }
        if (!GutilStr.isBlank(userInfo.getPhone())) {
            List<LandUser> landUsersOfPhone = landUserDao.queryNormalUserByPhone(userInfo.getPhone());
            if (!landUsersOfPhone.isEmpty()) {
                throw new RuntimeException("该手机号已被注册，请直接登录");
            }
            LandRegUser regUserOfPhone = landRegUserDao.queryOneByPhoneNum(userInfo.getPhone());
            if (regUserOfPhone != null) {
                if (!regUserOfPhone.getId().equals(userInfo.getId())) {
                    throw new RuntimeException("该手机号已被注册，请直接登录");
                }
            }
        }
        if (GutilStr.isBlank(userInfo.getRoleIds())) {
            throw new RuntimeException("用户名角色不能为空");
        }
        String depNo = userInfo.getDepNo();
        if (GutilStr.isEmpty(depNo)) {
            throw new RuntimeException("请先创建单位");
        }
        Organization org = organizationRepository.findById(depNo).orElse(null);
        if (org == null) {
            throw new RuntimeException("用户单位不存在");
        }

        LandUser user = new LandUser();
        user.setName(userInfo.getUsername());
        user.setRname(userInfo.getRname());
        user.setPost(userInfo.getPost());
        user.setEmail(userInfo.getEmail());
        user.setBusiness(userInfo.getBusiness());
        user.setQqNumber(userInfo.getQqNumber());
        user.setCreateTime(new Date());
        user.setDeviceType(userInfo.getDeviceType());
        //设置过期时间
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH) + 6);
        user.setPwdExpirationTime(calendar.getTime());
        user.setPassword(userInfo.getPassword());
        user.setDepId(org.getName());
        user.setState(1);
        user.setIsdel(0);
        user.setPhone(userInfo.getPhone());
        user.setDepname(userInfo.getDepname());
        user.setQqNumber(userInfo.getQqNumber());
        user.setPost(userInfo.getPost());
        user.setDeviceType(userInfo.getDeviceType());
        LandUser landUser = landUserDao.save(user);

        // 保存到用户注册表
        String lsId = userInfo.getId();
        LandRegUser landRegUser = new LandRegUser();
        if (lsId != null && !lsId.equals("")) {
            landRegUser.setId(lsId);
        }

        landRegUser.setPassword(userInfo.getPassword());
        landRegUser.setName(userInfo.getUsername());
        landRegUser.setRname(userInfo.getRname());
        landRegUser.setPhone(userInfo.getPhone());
        landRegUser.setPostId(userInfo.getPost());
        landRegUser.setState(1);
        landRegUser.setDepNo(userInfo.getDepNo());
        landRegUser.setCreateTime(userInfo.getCreateTime());
        landRegUser.setUserId(landUser.getId());
        landRegUser.setRegOri(userInfo.getRegOri());
        landRegUser.setOriId(userInfo.getOriId());
        landRegUser.setSjsf(userInfo.getRegionCode());
        landRegUser.setBusiness(userInfo.getBusiness());
        landRegUser.setRoleIds(userInfo.getRoleIds());
        landRegUser.setDepName(userInfo.getDepname());
//        landRegUser.setLiaison(u);
        landRegUserDao.save(landRegUser);

        // 保存用户角色信息
        String[] roles = userInfo.getRoleIds().split(",");
        if (userInfo.getRoleIds().indexOf(";") > -1) {
            roles = userInfo.getRoleIds().split(";");
        }

        for (String role : roles) {
            //landUserRoleDao.insertRolesByUser(Long.valueOf(landUser.getId()), Long.valueOf(role));
            String uid = UUID.randomUUID().toString();
            UserRoleInfo userRole = new UserRoleInfo();
            userRole.setId(uid);
            userRole.setRoleinfoid(role);
            userRole.setUserid(landUser.getId());
            userRoleInfoDao.save(userRole);
        }

        // 保存用户行政区信息
        String regionCode = userInfo.getRegionCode();
        if (GutilStr.isNotBlank(regionCode)) {
            LandUser2Area landUser2Area = new LandUser2Area();
            landUser2Area.setUserId(landUser.getId());
            landUser2Area.setCreateTime(userInfo.getCreateTime());
            landUser2Area.setState(1);
            landUser2Area.setRegionCode(regionCode);
            landUser2AreaDao.save(landUser2Area);
        }

        // 保存用户单位（组织机构）信息
        if (GutilStr.isNotBlank(userInfo.getDepNo())) {
            Organization2User organization2User = new Organization2User();
            organization2User.setId(UUID.randomUUID().toString());
            organization2User.setOrganizationId(userInfo.getDepNo());
            organization2User.setUserId(landUser.getId());
            organization2UserDao.save(organization2User);
        }

        if (GutilStr.isNotBlank(userInfo.getDepaId())) {
            // 新增部门信息
            Department2User department2User = new Department2User();
            department2User.setId(UUID.randomUUID().toString());
            department2User.setUserId(landUser.getId());
            department2User.setDepartmentId(userInfo.getDepaId());
            department2UserDao.save(department2User);
        }

        // 保存用户云查询信息
        if (GutilStr.isNotEmpty(userInfo.getCloudArea())) {
            String[] cloudAreas = userInfo.getCloudArea().split(",");
            ArrayList<String> cloudList = ListUtil.toList(cloudAreas);
            List<UserCloudArea> userCloudAreas = new ArrayList<>();
            for (String cloud : cloudList) {
                UserCloudArea userCloudArea = new UserCloudArea();
                userCloudArea.setCode(cloud);
                userCloudArea.setUserId(landUser.getId());
                userCloudArea.setCreateTime(new Date());
                userCloudArea.setState(1);
                userCloudAreas.add(userCloudArea);
            }
            userCloudAreaDao.saveAll(userCloudAreas);
        }

        return user;
    }

    /**
     * 增加用户,直接新增，无须审核，供今第三方调用
     *
     * @param userInfo
     * @throws Exception
     */
    public LandUser addUserThird(UserAddInfo userInfo, List<String> errorCodeList) throws Exception {
        Long userid = -1L;
        List<LandUser> userOfName = landUserDao.queryAppUserByUsernameOrPhone(userInfo.getUsername());
        if (!userOfName.isEmpty()) {
            //throw new RuntimeException("该用户名已被注册");
            errorCodeList.add("E00002");
            userid = userOfName.get(0).getId();
        }
        List<LandRegUser> regUserOfNameList = landRegUserDao.queryRegUserByNameOrPhone(userInfo.getUsername());
        if (regUserOfNameList != null && regUserOfNameList.size() > 0) {
            //throw new RuntimeException("该用户名已被注册");
            if (!errorCodeList.contains("E00002")) {
                errorCodeList.add("E00002");
            }
            userid = regUserOfNameList.get(0).getUserId();
        }
        if (!GutilStr.isBlank(userInfo.getPhone())) {
            List<LandUser> landUsersOfPhone = landUserDao.queryAppUserByUsernameOrPhone(userInfo.getPhone());
            if (!landUsersOfPhone.isEmpty()) {
                //throw new RuntimeException("该手机号已被注册");
                errorCodeList.add("E00003");
            }
            List<LandRegUser> regUserOfPhoneList = landRegUserDao.queryRegUserByNameOrPhone(userInfo.getPhone());
            if (regUserOfPhoneList != null && regUserOfPhoneList.size() > 0) {
                //throw new RuntimeException("该手机号已被注册");
                if (!errorCodeList.contains("E00003")) {
                    errorCodeList.add("E00003");
                }
            }
        }

        if (userid != null && userid > 0) {
            List<Long> roleList = userRoleService.findRoleIdsByUserId(userid);
            // 标记国家级用户
            if ((roleList.contains(10012L) && !userInfo.getRoleIds().contains("10012"))
                    || (roleList.contains(10003L) && !userInfo.getRoleIds().contains("10003"))
                    || (roleList.contains(10018L) && !userInfo.getRoleIds().contains("10018"))
                    || (roleList.contains(10019L) && !userInfo.getRoleIds().contains("10019"))) {

                errorCodeList.add("E00004");
            }

            List<String> cloudArea = landUser2AreaDao.queryAreas(userid);
            if (!cloudArea.contains(userInfo.getRegionCode())) {
                errorCodeList.add("E00005");
            }

            if ((roleList.contains(10020L) && !userInfo.getRoleIds().contains("10020"))
                    || (!roleList.contains(10020L) && userInfo.getRoleIds().contains("10020"))) {
                errorCodeList.add("E00007");
            }
        }

        // 判断管理员是否有误

        if (errorCodeList.size() > 0) {
            return null;
        }

        Organization org = organizationRepository.findById(userInfo.getDepNo()).orElse(null);

        LandUser user = new LandUser();
        user.setName(userInfo.getUsername());
        user.setRname(userInfo.getRname());
        user.setPost(userInfo.getPost());
        user.setBusiness(userInfo.getBusiness());
        user.setQqNumber(userInfo.getQqNumber());
        user.setCreateTime(userInfo.getCreateTime());
        user.setPassword(userInfo.getPassword());
        user.setDepId(org.getName());
        user.setState(1);
        user.setIsdel(0);
        user.setPhone(userInfo.getPhone());
        LandUser landUser = landUserDao.save(user);

        // 保存到用户注册表
        LandRegUser landRegUser = new LandRegUser();
        landRegUser.setName(userInfo.getUsername());
        landRegUser.setRname(userInfo.getRname());
        landRegUser.setPhone(userInfo.getPhone());
        landRegUser.setPostId(userInfo.getPost());
        landRegUser.setState(1);
        landRegUser.setDepNo(userInfo.getDepNo());
        landRegUser.setCreateTime(userInfo.getCreateTime());
        landRegUser.setUserId(landUser.getId());
        landRegUser.setRegOri(userInfo.getRegOri());
        landRegUser.setOriId(userInfo.getOriId());
        landRegUserDao.save(landRegUser);

        // 保存用户角色信息
        String[] roles = userInfo.getRoleIds().split(",");
        for (String role : roles) {
            UserRoleInfo ur = new UserRoleInfo();
            ur.setId(UUID.randomUUID().toString());
            ur.setRoleinfoid(role);
            ur.setUserid(landUser.getId());
            userRoleInfoDao.save(ur);
            //landUserRoleDao.insertRolesByUser(Long.valueOf(landUser.getId()), Long.valueOf(role));
        }

        // 保存用户行政区信息
        String regionCode = userInfo.getRegionCode();
        if (GutilStr.isNotBlank(regionCode)) {
            LandUser2Area landUser2Area = new LandUser2Area();
            landUser2Area.setUserId(landUser.getId());
            landUser2Area.setCreateTime(userInfo.getCreateTime());
            landUser2Area.setState(1);
            landUser2Area.setRegionCode(regionCode);
            landUser2AreaDao.save(landUser2Area);
        }

        // 保存用户单位（组织机构）信息
        if (GutilStr.isNotBlank(userInfo.getDepNo())) {
            Organization2User organization2User = new Organization2User();
            organization2User.setId(UUID.randomUUID().toString());
            organization2User.setOrganizationId(userInfo.getDepNo());
            organization2User.setUserId(landUser.getId());
            organization2UserDao.save(organization2User);
        }

        if (GutilStr.isNotBlank(userInfo.getDepaId())) {
            // 新增部门信息
            Department2User department2User = new Department2User();
            department2User.setId(UUID.randomUUID().toString());
            department2User.setUserId(landUser.getId());
            department2User.setDepartmentId(userInfo.getDepaId());
            department2UserDao.save(department2User);
        }

        // 保存用户云查询信息
        if (GutilStr.isNotEmpty(userInfo.getCloudArea())) {
            String[] cloudAreas = userInfo.getCloudArea().split(",");
            ArrayList<String> cloudList = ListUtil.toList(cloudAreas);
            List<UserCloudArea> userCloudAreas = new ArrayList<>();
            for (String cloud : cloudList) {
                UserCloudArea userCloudArea = new UserCloudArea();
                userCloudArea.setCode(cloud);
                userCloudArea.setUserId(landUser.getId());
                userCloudArea.setCreateTime(new Date());
                userCloudArea.setState(1);
                userCloudAreas.add(userCloudArea);
            }
            userCloudAreaDao.saveAll(userCloudAreas);
        }

        // 保存用户应用程序权限 UIS
//        String appkeysStr = PropertyUtil.getProperty("oauth.appkeys");
//        String[] appkeys = appkeysStr.split(",");
//        if (appkeys.length > 0) {
//            for (String appkey : appkeys) {
//                UserApplication userApplication = new UserApplication();
//                userApplication.setUserId(landUser.getId());
//                userApplication.setApplicationId(appkey);
//                userApplicationRepository.save(userApplication);
//            }
//        }

        return user;
    }

    public void resetPasswordByAdmin(String userId, String newPassword) throws Exception {
        LandUser user = landUserDao.findById(Long.valueOf(userId)).orElse(null);
        if (GutilStr.isBlank(newPassword)) {
            throw new RuntimeException("新密码不能为空");
        }
        // 重置密码设置过期时间
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        // 密码过期时间增加6个月
        calendar.add(Calendar.MONTH, 6);
        landUserDao.updatePwdExpirationTime(Long.valueOf(userId), calendar.getTime());

        //因为有两次保存 所以时间应该用增加6个月的时间
        user.setPwdExpirationTime(calendar.getTime());
        user.setPassword(newPassword);
        landUserDao.save(user);
    }

    /**
     * 根据userids返回用户列表
     *
     * @param ids id列表
     * @return
     */
    public List<LandUser> getUserListByIds(List<Long> ids) {
        List<LandUser> landUsers = landUserDao.queryUserByIds(ids);
        return landUsers;
    }

    public String getReginCodeByUserId(Long userId) {
        LandUser2Area user2Area = landUser2AreaDao.queryOneByUserId(userId);
        if (user2Area != null) {
            return user2Area.getRegionCode();
        }
        return "";
    }

    public Region getRegion(String regionCode) {
        RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
        if (GutilStr.isBlank(regionCode)) {
            throw new RuntimeException("行政区代码为空");
        }
        Region region = regionDao.findByCodeAndVersion(regionCode, defaultVersion != null ? defaultVersion.getVersion() : "2018");
        return region;
    }


    public void changeEmail(Long userId, String email) {
        LandUser one = landUserDao.findById(userId).orElse(null);
        one.setEmail(email);
        landUserDao.save(one);
        LandRegUser regUser = landRegUserDao.findOneByName(one.getName());
        if (regUser != null) {
            regUser.setEmail(email);
            landRegUserDao.save(regUser);
        }
    }

    public void changeRname(Long userId, String rname) {
        LandUser one = landUserDao.findById(userId).orElse(null);
        one.setRname(rname);
        landUserDao.save(one);
        LandRegUser regUser = landRegUserDao.findOneByName(one.getName());
        if (regUser != null) {
            regUser.setRname(rname);
            landRegUserDao.save(regUser);
        }
    }

    public void changePhone(Long userId, String phone) {
        LandUser one = landUserDao.findById(userId).orElse(null);
        one.setPhone(phone);
        landUserDao.save(one);
        LandRegUser regUser = landRegUserDao.findOneByName(one.getName());
        if (regUser != null) {
            regUser.setPhone(phone);
            landRegUserDao.save(regUser);
        }
    }

    public List<LandUser> getMyPublicUsers(List<String> areas) {
        List<LandUser> users = landUserDao.queryUserByArea(areas, "社会公众");
        return users;
    }

    private String createTaskZyqUserSql(String bizId, String region, String phone, String username, String area) {
        String sql = " from tbtsk_right_area_reg tr LEFT JOIN tbsys_user tu ON cast( tu.f_userid AS VARCHAR ) = tr.f_userid " +
                " LEFT JOIN tbsys_user_area ta ON tu.f_userid = ta.f_userid " +
                " JOIN tb_region tb on tb.f_xzqdm = ta.f_regioncode " +
                " where tr.f_status is null ";
        if (GutilStr.isNotBlank(region)) {
            sql += " and ta.f_regioncode='" + region + "'";
        }
        if (GutilStr.isNotBlank(phone)) {
            sql += " and tu.f_phonemobile like '%" + phone + "%'";
        }
        if (GutilStr.isNotBlank(username)) {
            sql += " and tu.f_username like '%" + username + "%'";
        }
        if (GutilStr.isNotBlank(bizId)) {
            sql += " and tr.f_taskid='" + bizId + "'";
        }
        if (GutilStr.isNotBlank(area) && !"1".equalsIgnoreCase(area)) {
            if (area.endsWith("0000")) {
                area = area.substring(0, 2);
            } else if (area.endsWith("00")) {
                area = area.substring(0, 4);
            }
            sql += " and tr.f_xzqdm like '" + area + "%'";
        }
        return sql;
    }

    public List<Map<String, Object>> findTaskZyqUsers(String bizId, String region, String phone, String username, String area, int page, int pageSize) {

        String table = createTaskZyqUserSql(bizId, region, phone, username, area);
        String sql = "select tu.*,ta.f_regioncode,tb.f_xzqmc,tr.f_xzqdm as f_zyqdm,tr.f_id as f_regzyqid, tr.f_createtime as f_zyqsqsj " + table +
                " LIMIT " + pageSize + " OFFSET " + (page - 1) * pageSize;

        return jdbcTemplate.queryForList(sql);
    }

    public Long findCountTaskZyqUsers(String bizId, String region, String phone, String username, String area) {
        String table = createTaskZyqUserSql(bizId, region, phone, username, area);
        String sql = "select count(tu.*) " + table;
        return jdbcTemplate.queryForObject(sql, Long.class);
    }


    public Map<String, Object> getUsersByOrgIdAndRoleId(String orgId, String roleId, int userType, String userName,
                                                        int start, int limit) throws
            Exception {
        if (GutilStr.isBlank(orgId)) {
            throw new RuntimeException("部门id不能为空");
        }
        if (GutilStr.isBlank(userName)) {
            userName = "";
        }
        List<Long> idList = getUserIdsByOrgIdAndUserType(orgId, userType);
        List<LandUser> landUsers = new ArrayList<>();
        if (idList.isEmpty()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("total", 0);
            map.put("content", Collections.emptyList());
            return map;
        }
        if (GutilStr.isBlank(roleId)) {
            landUsers = landUserDao.queryUserByIds4(idList, "%" + userName + "%");
        } else {
            landUsers = landUserDao.queryUserByIdsAndUserNameLikeAndRoleId(idList, "%" + userName + "%", roleId);
        }

        Set<LandUser> set = new LinkedHashSet<LandUser>(landUsers);
        List<LandUser> users = new ArrayList<LandUser>(set);
        // 手动分页
        List<LandUser> result = new ArrayList<LandUser>();
        int currIdx = (start > 0 ? start * limit : 0);
        for (int i = 0; i < limit && i < users.size() - currIdx; i++) {
            // 注入用户角色 云查询 单位 区域名
            LandUser user = new LandUserBuilder(users.get(currIdx + i)).role().cloudArea().organization().regionFullName().build();
            // 用户单位id
            if (GutilStr.isNotBlank(orgId)) {
                user.setDepNo(orgId);
            }
            result.add(user);
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("total", users.size());
        map.put("content", result);
        return map;
    }

    public List<UserGrant> getUserOnlyGrantBizNew(String bizid, String name, int offset, int limit, String roleid,
                                                  String regionCode, String orgName, String role, String phoneNumber, String
                                                          regionFullName) {
        //return landUserDao.getUserOnlyGrantBiz(bizid,"%"+roleid+"%","%"+name+"%",limit,offset);
        BeanPropertyRowMapper<UserGrant> rowMapper = new BeanPropertyRowMapper<UserGrant>(UserGrant.class);
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT T.f_userid,T.f_username,T.isgran,T.f_phonemobile,T.f_depid,T.roles,T.f_rname,T.f_regioncode";
        sqlAll.append(fieldSql);
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(",T.f_role ");
        }
        String tableSql1 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_role,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P" +
                " ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";

        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( " + 1 + " ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( " + 3 + " ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( " + 2 + " ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( " + 4 + " ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (!bizid.equals("")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        }
        sqlAll.append(" ORDER BY T.f_username LIMIT " + limit + " OFFSET " + offset);
        return jdbcTemplate.query(sqlAll.toString(), rowMapper);
    }

    public List<UserGrant> getUserAllBizNew(String bizid, String name, int offset, int limit, String roleid, String
            regionCode, String orgName, String role, String phoneNumber, String regionFullName, String source) {
        //return landUserDao.getUserAllBiz(bizid,"%"+roleid+"%","%"+name+"%",limit,offset);
        BeanPropertyRowMapper<UserGrant> rowMapper = new BeanPropertyRowMapper<UserGrant>(UserGrant.class);
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT T.f_userid,T.f_username,T.isgran,T.f_phonemobile,T.f_depid,T.roles,T.f_rname,T.f_regioncode";
        sqlAll.append(fieldSql);
        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(",T.f_role ");
        }
        String tableSql1 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A) AS P ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_role,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A) AS P" +
                " ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";

        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( " + 1 + " ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( " + 3 + " ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( " + 2 + " ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( " + 4 + " ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (source.equals("1")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        } else if (source.equals("2")) {
            sqlAll.append("and not exists (select * from tbsys_user_biz AA WHERE AA.f_userid = T.f_userid AND AA.f_bizid ='7')");
        }
        sqlAll.append(" ORDER BY T.f_username LIMIT " + limit + " OFFSET " + offset);
        return jdbcTemplate.query(sqlAll.toString(), rowMapper);
    }

    public Long getUserOnlyGrantBizCountNew(String bizid, String name, String roleid, String regionCode, String orgName,
                                            String role, String phoneNumber, String regionFullName) {
        //return landUserDao.getUserOnlyGrantBizCount(bizid,"%"+roleid+"%","%"+name+"%");
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT count(1) ";
        sqlAll.append(fieldSql);
        String tableSql1 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_role,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A WHERE A.f_bizid ='7') AS P" +
                " ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";

        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( " + 1 + " ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( " + 3 + " ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( " + 2 + " ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( " + 4 + " ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (!bizid.equals("")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        }
        return jdbcTemplate.queryForObject(sqlAll.toString(), Long.class);
    }

    public Long getUserAllBizCountNew(String bizid, String name, String roleid, String regionCode, String orgName,
                                      String role, String phoneNumber, String regionFullName, String source) {
        //return landUserDao.getUserAllBizCount(bizid,"%"+roleid+"%","%"+name+"%");
        StringBuffer sqlAll = new StringBuffer();
        String fieldSql = "SELECT count(1) ";
        sqlAll.append(fieldSql);
        String tableSql1 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid FROM tbsys_user_biz A ) AS P ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";
        String tableSql2 = " from (\n" +
                "SELECT\n" +
                "\tb.f_userid,\n" +
                "\tb.f_username,\n" +
                "\tb.f_rname,\n" +
                "\tb.f_depid,\n" +
                "\tb.f_phonemobile,\n" +
                "\tC.f_regioncode,\n" +
                "\tP.f_bizid,\n" +
                "\tP.f_role,\n" +
                "\tP.f_bizid ='7' AS isgran,\n" +
                "\tarray_to_string ( ( ARRAY ( SELECT d.f_roleinfoid FROM tbsys_user_roleinfo d WHERE d.f_userid = b.f_userid ) ), ',' ) AS roles \n" +
                "FROM\n" +
                "\ttbsys_user b\n" +
                "\tLEFT JOIN ( SELECT DISTINCT A.f_userid,A.f_bizid,A.f_role FROM tbsys_user_biz A ) AS P" +
                " ON P.f_userid = b.f_userid\n" +
                "\tLEFT JOIN tbsys_user_area C ON C.f_userid = b.f_userid \n" +
                "WHERE\n" +
                "\tb.f_isdeleted <> '1' \n" +
                "\t) AS T  WHERE  1=1 ";

        if (!role.equals("") && !role.equals("0")) {
            sqlAll.append(tableSql2);
            if (role.equals("1")) {
                sqlAll.append("\tAND T.f_role in ( " + 1 + " ) \n");
            } else if (role.equals("3")) {
                sqlAll.append("\tAND T.f_role in ( " + 3 + " ) \n");
            } else if (role.equals("2")) {
                sqlAll.append("\tAND T.f_role in ( " + 2 + " ) \n");
            } else if (role.equals("4")) {
                sqlAll.append("\tAND T.f_role in ( " + 4 + " ) \n");
            }
        } else {
            sqlAll.append(tableSql1);
        }
        if (!roleid.equals("")) {
            sqlAll.append("AND T.roles LIKE '%" + roleid + "%'");
        }
        if (!name.equalsIgnoreCase("")) {
            sqlAll.append("AND (T.f_username LIKE '%" + name + "%' OR T.f_rname LIKE '%" + name + "%' or T.f_phonemobile LIKE '%" + name + "%')");
        }
        if (!phoneNumber.equals("")) {
            sqlAll.append("AND T.f_phonemobile LIKE '%" + phoneNumber + "%'");
        }
        if (!regionCode.equals("")) {
            sqlAll.append("AND T.f_regioncode like '" + regionCode + "%'");
        }
        if (!orgName.equals("")) {
            sqlAll.append("AND T.f_depid like '%" + orgName + "%'");
        }
        if (source.equals("1")) {
            sqlAll.append("AND T.f_bizid='" + bizid + "'");
        } else if (source.equals("2")) {
            sqlAll.append("and not exists (select * from tbsys_user_biz AA WHERE AA.f_userid = T.f_userid AND AA.f_bizid ='7')");
        }

        return jdbcTemplate.queryForObject(sqlAll.toString(), Long.class);
    }

    private Long createSQLByBizIdAndUserRoleCount(String bizId, String role, List<String> region, String name, String nameLike) {
        //查询表名称
        String tableName = "";
        //查询字段
        String tablefield = "c.f_regioncode";
        //判断是哪个角色
        if (role.equals("1")) {
            //管理员
            tableName = GLY_TABLE_NAME;
        } else if (role.equals("2")) {
            //审核员
            tableName = SHY_TABLE_NAME;
        } else if (role.equals("3")) {
            //作业员
            tableName = ZYY_TABLE_NAME;
            tablefield = "c.f_xzqdm";
        } else if (role.equals("4")) {
            //复核员
            tableName = FHY_TABLE_NAME;
        }else if (role.equals("5")) {
            //复核员
            tableName = CJSHY_TABLE_NAME;
        }else if (role.equals("6")) {
            //上传员
            tableName = SCY_TABLE_NAME;
        }

        String regionStr = "";
        for (int i = 0; i < region.size(); i++) {
            if (!region.get(i).equals("1")) {
                regionStr += " " + tablefield + " ";
                String tempRegion = "";
                if (region.get(i).endsWith("0000") && region.get(i).length() <= 6) {
                    tempRegion = region.get(i).substring(0, 2) + "%";
                } else if (region.get(i).endsWith("00") && region.get(i).length() <= 6) {
                    tempRegion = region.get(i).substring(0, 4) + "%";
                } else {
                    tempRegion = region.get(i) + "%";
                }
                regionStr += "like '" + tempRegion + "'";
                if (i < region.size() - 1) {
                    regionStr += " or ";
                }
            }
        }
        if (GutilStr.isNotBlank(regionStr)) {
            regionStr = " and ( " + regionStr + " ) ";
        }

        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" select count(1) from ( ");
        stringBuffer.append("select distinct(u.*) from tbsys_user u,tbsys_user_biz2 b," + tableName + " c ");

        /*
        stringBuffer.append(" where u.f_userid = b.f_userid and b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and b.f_role=" + role +
                " and (u.f_username like '" + name + "' or u.f_rname like '" + name + "') and u.f_phonemobile like '" + phone + "' and b.f_bizid = '" + bizId + "' " + regionStr +
                " ) m");
        */
        stringBuffer.append(" where u.f_userid = b.f_userid and b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and b.f_role=" + role +(StringUtils.isNotBlank(name)?" and u.f_username = '"+name+"'":"")+
                " and u.f_username like '" + nameLike + "' and b.f_bizid = '" + bizId + "' " + regionStr +
                " ) m");

        Long count = jdbcTemplate.queryForObject(stringBuffer.toString(), Long.class);
        return count;
    }

    private List<LandUser> createSQLByBizIdAndUserRole(String bizId, String role, List<String> region, int limit, int start, String name, String nameLike) {
        //查询表名称
        String tableName = "";
        //查询字段
        String tablefield = "c.f_regioncode";
        //判断是哪个角色
        if (role.equals("1")) {
            //管理员
            tableName = GLY_TABLE_NAME;
        } else if (role.equals("2")) {
            //审核员
            tableName = SHY_TABLE_NAME;
        } else if (role.equals("3")) {
            //作业员
            tableName = ZYY_TABLE_NAME;
            tablefield = "c.f_xzqdm";
        } else if (role.equals("4")) {
            //复核员
            tableName = FHY_TABLE_NAME;
        }else if (role.equals("5")) {
            //复核员
            tableName = CJSHY_TABLE_NAME;
        }else if (role.equals("6")) {
            //上传员
            tableName = SCY_TABLE_NAME;
        }

        String regionStr = "";
        for (int i = 0; i < region.size(); i++) {
            if (!region.get(i).equals("1")) {
                regionStr += " " + tablefield + " ";
                String tempRegion = "";
                if (region.get(i).endsWith("0000") && region.get(i).length() <= 6) {
                    tempRegion = region.get(i).substring(0, 2) + "%";
                } else if (region.get(i).endsWith("00") && region.get(i).length() <= 6) {
                    tempRegion = region.get(i).substring(0, 4) + "%";
                } else {
                    tempRegion = region.get(i) + "%";
                }
                regionStr += "like '" + tempRegion + "'";
                if (i < region.size() - 1) {
                    regionStr += " or ";
                }
            }
        }
        if (GutilStr.isNotBlank(regionStr)) {
            regionStr = " and ( " + regionStr + " ) ";
        }

        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct(u.*) from tbsys_user u,tbsys_user_biz2 b," + tableName + " c ");

        /*
        stringBuffer.append(" where u.f_userid = b.f_userid and b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and b.f_role=" + role +
                " and (u.f_username like '" + name + "' or u.f_rname like '" + name + "') and u.f_phonemobile like '" + phone + "' and b.f_bizid = '" + bizId + "' " + regionStr +
                "limit " + limit + " offset " + start);
        */
        stringBuffer.append(" where u.f_userid = b.f_userid and b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and b.f_role=" + role +(StringUtils.isNotBlank(name)?" and u.f_username = '"+name+"'":"")+
                " and u.f_username like '" + nameLike  + "' and b.f_bizid = '" + bizId + "' " + regionStr +
                "limit " + limit + " offset " + start);

        List<Map<String, Object>> list = jdbcTemplate.queryForList(stringBuffer.toString());
        List<LandUser> landUsers = new ArrayList<>();
        for (Map<String, Object> map : list) {
            LandUser landUser = new LandUser();
            landUser.setId(Long.valueOf(map.get("f_userid").toString()));
            landUser.setName(map.get("f_username").toString());
            landUser.setSubjectUserId(map.get("f_subject_userid").toString());
            landUser.setMidUserId(map.get("f_mid_userid").toString());
            //landUser.setRname(map.get("f_rname").toString());
            //landUser.setPhone(map.get("f_phonemobile").toString());
            landUsers.add(landUser);
        }
        return landUsers;
    }
}
