package com.geoway.landteam.landcloud.service.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserSimpleInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.*;
import com.geoway.landteam.landcloud.core.model.user.dto.AvalUserInfo;
import com.geoway.landteam.landcloud.core.model.user.dto.RegUserInfo;
import com.geoway.landteam.landcloud.core.model.user.entity.*;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.*;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.user.FriendsServiceImpl;
 import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.user.VertifyServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgUtil;
import com.geoway.landteam.landcloud.core.service.util.SMSUtilHuawei;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
/*import com.gw.base.data.GwValidateException;*/
import com.geoway.landteam.landcloud.model.pub.entity.TbsysUserSubjectRel;
import com.geoway.landteam.landcloud.repository.pub.TbsysUserSubjectRelRepository;
import com.gw.base.data.GwValidateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class MSecurityService {

    @Autowired
    LandUserService landUserService;

    @Autowired
    YXUserRepository yxUserRepository;

    @Autowired
    FriendsServiceImpl friendsService;

    @Autowired
    LandRegUserRepository landRegUserRepository;

    @Autowired
    UserRoleInfoRepository userRoleInfoRepository;

    @Autowired
    VertifyServiceImpl vertifyService;

    @Autowired
    RegionService regionService;

    @Autowired
    RegionRepository regionRepository;

    @Autowired
    UserAreaRepository userAreaRepository;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    OrganizationRepository organizationRepository;

    @Autowired
    Organization2UserRepository organization2UserRepository;

    @Autowired
    AvalUserRepository avalUserRepository;

    @Autowired
    LandRegUserService landRegUserService;

    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;

    @Autowired
    UserCloudAreaRepository userCloudAreaDao;

    @Autowired
    UserApplicationRepository userApplicationRepository;

  /*  @Autowired
    UserBizRepository userBizRepository;*/

    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;

    @Autowired
    SysConfigService sysConfigService;



    // 判断用户是否为自己好友
    private boolean isMyFriend(Long ownerId, Long userId) throws Exception {
        List<LandUser> friends = friendsService.getMyFriends(ownerId);
        if (friends.isEmpty()) {
            return false;
        }
        for (LandUser myFriend : friends) {
            if (myFriend.getId().equals(userId)) {
                return true;
            }
        }
        return false;
    }

    // 更新用户云信账号token,并更新当前用户信息token
    public void updateToken(Long userId)  {
        YXUser yxUser = yxUserRepository.findOneByUserId(userId);
        if (yxUser != null) {
            String result = CloudMsgUtil.refreshToken(yxUser.getAccid());
            @SuppressWarnings("unchecked")
            Map<String, Map<String, String>> map = (Map<String, Map<String, String>>) JSON.parse(result);
            String newToken = map.get("info").get("token");
            yxUser.setToken(newToken);
            yxUserRepository.save(yxUser);
        }
    }

    // 用户注册
    public void register(RegUserInfo user) throws Exception {
        // 确认注册表有误手机号重复的
        LandRegUser landRegUser = landRegUserRepository.queryOneByPhoneNum(user.getPhone());
        if (landRegUser != null) {
            throw new RuntimeException("该手机号已被注册");
        }
        // 确认用户表有误手机号重复的
        List<LandUser> userOfPhone = landUserRepository.queryNormalUserByPhone(user.getPhone());
        if (!userOfPhone.isEmpty()) {
            throw new RuntimeException("该手机号已被注册");
        }

        // 确认注册表中是否有重名
        LandRegUser landRegUser1 = landRegUserRepository.findOneByName(user.getName());

        if (landRegUser1 != null) {
            throw new RuntimeException("该用户名已被注册");
        }
        // 确认用户表中有无重名
        List<LandUser> userOfName = landUserRepository.queryUserByName(user.getName());
        if (!userOfName.isEmpty()) {
            throw new RuntimeException("该用户名已被注册");
        }

        if (StringUtils.isBlank(user.getRoleIds())) {
            throw new RuntimeException("角色信息不能为空");
        }

        if (StringUtils.isBlank(user.getSjsf())) {
            throw new RuntimeException("所在区域不能为空");
        }

        LandRegUser newUser = new LandRegUser();
        BeanUtil.copyProperties(user, newUser);
        // 如果是管理用户，所在区域和单位都不能为空
        if (user.getRoleIds().equals("10007")) {
            newUser.setSjsf("1");
            newUser.setPostId(null);
        } else {
            if (StringUtils.isBlank(user.getPostId())) {
                throw new RuntimeException("所在单位不能为空");
            }

            // 判断单位是否存在
            List<Organization> list = organizationRepository.queryOneByName(user.getPostId());
            for (Organization organization : list) {
                if (StringUtils.isBlank(organization.getRegionCode())
                        || !organization.getRegionCode().equals(user.getSjsf())) {
                    throw new RuntimeException("其他行政区已存在名称为[" + user.getPostId() + "]的单位");
                }
            }
        }

        newUser.setState(0);
        newUser.setCreateTime(new Date());
        landRegUserRepository.save(newUser);
    }

    public void register1(RegUserInfo user) throws Exception {
        // 确认有无手机号重复的
        if (isPhoneRegistered(user.getPhone())) {
            throw new RuntimeException("该手机号已被注册");
        }
        // 确认用户表中有无重名
        List<LandUser> userOfName = landUserRepository.queryUserByName(user.getName());
        if (!userOfName.isEmpty()) {
            throw new RuntimeException("该用户名已被注册");
        }

        // 确认注册表中是否有重名
        LandRegUser landRegUser1 = landRegUserRepository.findOneByName(user.getName());
        if (landRegUser1 != null) {
            throw new RuntimeException("该用户名已被注册");
        }

        if (StringUtils.isBlank(user.getRoleIds())) {
            throw new RuntimeException("角色信息不能为空");
        }

        if (StringUtils.isBlank(user.getSjsf())) {
            throw new RuntimeException("所在区域不能为空");
        }

        LandRegUser newUser = new LandRegUser();
        BeanUtil.copyProperties(user, newUser);
        newUser.setDepName(user.getDepName());
        if (user.getRoleIds().equals("10007")) {
            // 公众用户
            SysConfig publicConfig = sysConfigService.findOne("publicConfig");
            String bizId = "";
            String unitId = "";
            if(publicConfig != null){
                JSONObject jsonObject = JSONObject.parseObject(publicConfig.getValue());
                bizId = jsonObject.getString("zngl");
                unitId = jsonObject.getString("unit");
            }

            newUser.setDepNo(unitId);

            if(StringUtils.isNotBlank(newUser.getBizRegion())){
                JSONObject js = new JSONObject();
                js.put(bizId,newUser.getBizRegion());

                String code = newUser.getBizRegion().substring(0,6);
                newUser.setSjsf(code);
                newUser.setRegionCode(code);

                JSONObject js1 = new JSONObject();
                js1.put("zngl",bizId);
                newUser.setBusiness(js1.toJSONString());
                newUser.setBizRegion(js.toJSONString());
            }

        } else {
            // 如果是管理用户，单位不能为空
            // 非公众用户
            if (StringUtils.isBlank(user.getPostId())) {
                throw new RuntimeException("单位名不能为空");
            }

            // 单位id为空,表明是新建的单位,需传父单位id
            if (StringUtils.isBlank(user.getDepNo())) {
                //
                if (StringUtils.isBlank(user.getParentDepNo())) {
                    throw new RuntimeException("新建单位父单位id不能为空");
                }
                // 判断其他地区是否存在同名单位
                List<Organization> list = organizationRepository.queryOneByName(user.getPostId());
                for (Organization organization : list) {
                    if (StringUtils.isBlank(organization.getRegionCode())
                            || !organization.getRegionCode().equals(user.getSjsf())) {
                        throw new RuntimeException("其他行政区已存在名称为[" + user.getPostId() + "]的单位");
                    }
                }
            }
        }
        newUser.setState(0);
        newUser.setCreateTime(new Date());
        newUser.setUserId(1L);//默认
        landRegUserRepository.save(newUser);
    }

    // 注册审核
    @Transactional
    public void reviewRegister(Long adminId, AvalUserInfo info) throws Exception {

        LandRegUser regUser = landRegUserRepository.findById(info.getId()).orElse(null);
        regUser.setState(info.getState());
        regUser.setReason(info.getReason());
        if (StringUtils.isNotBlank(info.getSjsf())) {
            regUser.setSjsf(info.getSjsf());
        }

        regUser.setRoleIds(info.getRoleIds());
        // regUser.setPostId(info.getPostId());
        // regUser.setDepNo(info.getDepNo());
        if ("1".equals(info.getState().toString())) {
            if (!info.getRoleIds().equals("10007")) {
                // 判断单位是否已经创建

                if (StringUtils.isBlank(info.getDepNo()) && StringUtils.isBlank(info.getPostId())) {
                    throw new RuntimeException("单位为空，请先创建");
                }

                if (!StringUtils.isBlank(info.getDepNo())) {
                    Organization organization = organizationRepository.findById(info.getDepNo()).orElse(null);
                    if (organization == null) {
                        throw new RuntimeException("单位[" + info.getPostId() + "]不存在，请先创建");
                    }
                } else if (!StringUtils.isBlank(info.getPostId())) {

                    List<Organization> organizations = organizationRepository.queryOneByName(info.getPostId());
                    if (organizations.size() == 0) {
                        throw new RuntimeException("单位[" + info.getPostId() + "]不存在，请先创建");
                    }
                    if (organizations.size() > 1) {
                        throw new RuntimeException("单位[" + info.getPostId() + "]重复，无法审核");
                    }

                    Organization organization = organizations.get(0);
                    info.setDepNo(organization.getId());
                }

            }
            regUser.setDepNo(info.getDepNo());
            // 写入用户基本/角色/区域/单位信息
            saveFormalUserInfo(regUser, info);

            String appkey = (String) ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
            UserApplication userApplication = new UserApplication();
            userApplication.setUserId(regUser.getUserId());
            userApplication.setApplicationId(appkey);
            userApplicationRepository.save(userApplication);

            // 国家级用户创建个人云盘
//            if (info.getRoleIds().contains("10012")) {
//                List<BigDecimal> list = new ArrayList<>();
//                list.add(new BigDecimal(regUser.getUserId()));
//                cloudDiskUtilService.createByUserIdList(list);
//            }

            //  是管理员且无单位云盘, 则创建单位云盘
            if (info.getRoleIds().contains("10020")) {
                Organization organization = organizationRepository.findById(info.getDepNo()).orElse(null);
                if (organization == null) {
                    throw new RuntimeException("单位不存在");
                }
//                CloudDiskOfOrg cloudDiskOfOrg = cloudDiskOfOrgDao.findOne(organization.getId());
//                if (cloudDiskOfOrg != null) {
//                    return;
//                }
                List<String> orgIdList = new ArrayList<>();
                orgIdList.add(organization.getId());
                //cloudDiskUtilService.createByOrgIdList(orgIdList, regUser.getUserId());

            }


            // 给用户发送成功提醒信息
//			String templateCode = "SMS_153726376";
//			String TemplateParam = "{\"username\":\"" + "[" + regUser.getName() + "]" + "\"}";
//			ShortMessageUtil.sendMessage(regUser.getPhone(), templateCode, TemplateParam);

            String templateParas = "[\"" + regUser.getName() + "\"]";
            String telphone = regUser.getPhone();
            if (!telphone.startsWith("+86")) {
                telphone = "+86" + telphone;
            }
            SMSUtilHuawei.sendSMS("csms18120613", "6b55c247446849a898ded08b578abc4f", templateParas, telphone);

        } else if ("2".equals(info.getState().toString())) {
            if (StringUtils.isBlank(info.getReason())) {
                throw new RuntimeException("不同意申请时意见不能为空");
            }
            // 给用户发送失败提醒信息
//			String templateCode = "SMS_153726379";
//			String TemplateParam = "{\"username\":\"" + "[" + regUser.getName() + "]" + "\"" + ",\"reason\":\"" + "["
//					+ info.getReason() + "]" + "\"}";
//			ShortMessageUtil.sendMessage(regUser.getPhone(), templateCode, TemplateParam);

            String templateParas = "[\"" + regUser.getName() + "\",\"" + info.getReason() + "\"]";
            String telphone = regUser.getPhone();
            if (!telphone.startsWith("+86")) {
                telphone = "+86" + telphone;
            }
            SMSUtilHuawei.sendSMS("csms18120613", "9f172e268a064b4f9b3a6cce263d35a5", templateParas, telphone);

        } else if ("0".equals(info.getState().toString())) {
            regUser.setPostId(info.getPostId());
            regUser.setDepNo(info.getDepNo());
        }
        landRegUserRepository.save(regUser);
        // 不同意时 审核意见写入审核记录表
        if ("2".equals(info.getState().toString())) {
            AvalUser avalUser = new AvalUser();
            avalUser.setApproverId(adminId);
            avalUser.setOpinion(info.getReason());
            avalUser.setRegUserId(regUser.getId());
            avalUserRepository.save(avalUser);
        }
    }

    // 根据注册用户信息写入用户基本/角色/区域/单位信息
    void saveFormalUserInfo(LandRegUser regUser, AvalUserInfo info) throws Exception {

        // 新建一个正式用户
        LandUser user = new LandUser();
        // 保存对应用户信息
        user.setPassword(regUser.getPassword());
        user.setName(regUser.getName());
        user.setIsdel(0);
        user.setRname(regUser.getName());
        user.setPhone(regUser.getPhone());
        user.setDepId(info.getPostId());
        user.setSjsf(regUser.getSjsf());
        user.setState(1);
        user.setCreateTime(new Date());

        synchronized (this) {
            List<LandUser> users = landUserRepository.queryUserByName(regUser.getName());
            if (users != null && users.size() > 0) {
                throw new GwValidateException("请不要重复提交");
            }
            landUserRepository.save(user);
        }
        //syncUisWrapperService.addUser(user);
        // 完善用户注册信息
        regUser.setUserId(user.getId());
        regUser.setRname(user.getName());
        landRegUserRepository.save(regUser);

        // 写入用户角色信息
        String[] roleArr = regUser.getRoleIds().split(",");
        for (String roleId : roleArr) {
            UserRoleInfo ur = new UserRoleInfo();
            ur.setId(UUID.randomUUID().toString());
            ur.setRoleinfoid(roleId);
            ur.setUserid(user.getId());
            userRoleInfoRepository.save(ur);
            //landUserRoleRepository.insertRolesByUser(user.getId(), Long.valueOf(roleId));
        }

        // 写入云查询角色
        String roleCloudIds = info.getCloudRoles();
        if (StringUtils.isNotBlank(roleCloudIds)) {
            String[] ids = roleCloudIds.split(",");
            for (String id : ids) {
                RoleCloudQueryRel roleCloudQueryRel = new RoleCloudQueryRel();
                roleCloudQueryRel.setCid(id);
                roleCloudQueryRel.setUid(user.getId().toString());
                roleCloudQueryRelRepository.save(roleCloudQueryRel);
            }
        }

        // 写入用户区域信息
        UserArea userArea = new UserArea();
        userArea.setUserId(user.getId());
        userArea.setCode(regUser.getSjsf());
        userArea.setCreateTime(new Date());
        userArea.setState(1);
        userAreaRepository.save(userArea);

       // syncUisWrapperService.addUserArea(userArea);

        //写入云查询区域信息
        UserCloudArea userCloudArea = new UserCloudArea();
        userCloudArea.setUserId(user.getId());
        userCloudArea.setCode(regUser.getSjsf());
        userCloudArea.setCreateTime(new Date());
        userCloudArea.setState(1);
        userCloudAreaDao.save(userCloudArea);


        // 写入用户单位信息
        if (StringUtils.isNotBlank(info.getDepNo())) {
            Organization organization = organizationRepository.findById(info.getDepNo()).orElse(null);
            if (organization == null) {
                throw new RuntimeException("单位不存在");
            }
            Organization2User organization2User = new Organization2User();
            organization2User.setId(UUID.randomUUID().toString());
            organization2User.setOrganizationId(organization.getId());
            organization2User.setUserId(user.getId());
            organization2UserRepository.save(organization2User);
        }

        // 写入默认业务
       /* if (StringUtils.isNotBlank(info.getBiz())) {
            String[] split = info.getBiz().split(";");
            List<UserBiz> list = new ArrayList<>();
            for (int i = 0; i < split.length; i++) {
                UserBiz userBiz = new UserBiz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserId(user.getId());
                userBiz.setBizId(split[i]);
                list.add(userBiz);
            }
            userBizRepository.saveAll(list);
        }*/
    }

    // 判断手机号是否已有对应用户或注册用户
    public boolean isPhoneRegistered(String phone) throws Exception {
        LandRegUser regUser = landRegUserRepository.queryOneByPhoneNum(phone);
        if (regUser != null) {
            return true;
        }
        List<LandUser> landUsers = landUserRepository.queryNormalUserByPhone(phone);
        return !landUsers.isEmpty();
    }

    public void renewPhoneNum(Long userId, String newPhoneNum, String verifyCode) throws Exception {
        LandUser user = landUserRepository.findById(userId).orElse(null);
        if (user == null) {
            throw new RuntimeException("用户不存在");
        }
        if (StringUtils.isBlank(verifyCode)) {
            throw new RuntimeException("验证码为空");
        }
        if (StringUtils.isBlank(newPhoneNum)) {
            throw new RuntimeException("手机号为空");
        }
        if (isPhoneRegistered(newPhoneNum)) {
            throw new RuntimeException("手机号已被使用");
        }
        List<Vertify> curVerty = vertifyService.findByFilter(newPhoneNum, verifyCode);
        if (curVerty.size() == 0) {
            throw new RuntimeException("验证码错误");
        }
        user.setPhone(newPhoneNum);
        landUserRepository.save(user);
        // 同时修改注册表中手机号
        LandRegUser regUser = landRegUserRepository.queryOneByUserId(userId);
        if (regUser != null) {
            regUser.setPhone(newPhoneNum);
            landRegUserRepository.save(regUser);
        }
    }

    //判断了一下旧手机号的验证码
    public int renewPhoneNumSafe(Long userId, String newPhoneNum, String verifyCode, String oldVerify, HttpServletRequest request) throws Exception {
        if (StringUtils.isBlank(verifyCode)) {
            throw new RuntimeException("验证码为空");
        }
        if (StringUtils.isBlank(newPhoneNum)) {
            throw new RuntimeException("手机号为空");
        }
        if (isPhoneRegistered(newPhoneNum)) {
            throw new RuntimeException("手机号已被使用");
        }
        LandUser user = landUserRepository.findById(userId).orElse(null);
        if (user == null) {
            throw new RuntimeException("用户不存在");
        }
        // 验证旧手机验证码
        if (!checkVerifySession(request, oldVerify, "SIMPLE_SMSCODE_SESSION_KEY")) {
            return 1;
        }
        // 验证新手机验证码
        if (!checkVerifySession(request, verifyCode, "SIMPLE_SMSCODE_CHANGEPHONE_KEY")) {
            return 2;
        }
        user.setPhone(newPhoneNum);
        landUserRepository.save(user);
        // 同时修改注册表中手机号
        List<LandRegUser> landRegUsers = landRegUserRepository.queryRegUserByName(user.getName());
        if (landRegUsers.size() > 0) {
            LandRegUser landRegUser = landRegUsers.get(0);
            landRegUser.setPhone(newPhoneNum);
            landRegUserRepository.save(landRegUser);
        }
        return 3;
    }

    public LandUser getUserDetailByUserIdOrName(String key) throws Exception {
        if (StringUtils.isBlank(key)) {
            throw new RuntimeException("查询条件不能为空");
        }
        // 是数字
        if (key.matches("[0-9]+")) {
            LandUser user = landUserRepository.findById(Long.valueOf(key)).orElse(null);
            if (user == null) {
                return getUserDetailByName(key);
            }
            return landRegUserService.getReviewDetailByUserId(user.getId());
        }
        return getUserDetailByName(key);
    }


    private LandUser getUserDetailByName(String userName) throws Exception {
        List<LandUser> landUsers = landUserRepository.queryUserByName(userName);
        if (landUsers.isEmpty()) {
            throw new RuntimeException("用户不存在");
        }
        Long userId = landUsers.get(0).getId();
        return landRegUserService.getReviewDetailByUserId(userId);
    }

    public Boolean checkVerifySession(HttpServletRequest request, String verifyCode, String key) {
        Object smsCodeObj = request.getSession().getAttribute(key);
        // 获取session中验证码
        JSONObject smsCodeJson = null;
        if (smsCodeObj != null) {
            smsCodeJson = JSON.parseObject(smsCodeObj.toString());
            return verifyCode.equalsIgnoreCase(smsCodeJson.getString("verifyCode"));
        } else {
            return false;
        }
    }
}
