package com.geoway.landteam.landcloud.service.user;


import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.base.dto.RegionDto;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVersion;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.user.entity.UserArea;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVersionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;


import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;



@Service
@Transactional(rollbackFor = Exception.class)
public class MUserAreaService {


	@Autowired
    UserAreaRepository userAreaDao;

	@Autowired
	TaskNoticeRepository taskNoticeDao;

	@Autowired
	TaskNoticeUserRepository userDao;

	@Autowired
    RegionVersionRepository regionVersionRepository;

	@Autowired
    RegionRepository regionDao;

	@Autowired
    RegionTownRepository regionTownRepository;

	@Autowired
    RegionVillageRepository regionVillageRepository;



	/*@Resource
	SyncUisWrapperService syncUisWrapperService;*/

	public void updateState(Integer state, Long sendUserId, Long userId, String code) {
		userAreaDao.updateState(state, userId, code);
		//syncUisWrapperService.updateUserAreaState(state, userId, code);

		String receiveId = userId.toString();
		String title = "区域审核通知";
		String xzqmc = "";
		if (code != null && !code.isEmpty()) {
			RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
			xzqmc = regionDao.getNameByCodeAndVersion(code, defaultVersion != null ? defaultVersion.getVersion() : "2018");
		}
		String content = "";
		if (state == 1) {
			content = "你恢复了" + xzqmc + "(" + code + ")区域的操作权限";
		} else if (state == 0) {
			content = "你已经被" + xzqmc + "(" + code + ")区域管理员撤销了该区域的操作权限";
		}
		addTaskNotice(title, content, sendUserId, 1, 4, receiveId, code, 1);
	}

	private TaskNotice addTaskNotice(String title, String content, long sendUserId, int state, int type,
									 String receiveIds, String xzqdm, int action) {
		Date time = new Date();
		TaskNotice taskNotice = null;

		TaskNotice notice = new TaskNotice();
		notice.setTitle(title);
		notice.setSendTime(time);
		notice.setSendUser(sendUserId);
		notice.setState(state);
		notice.setType(type);
		notice.setRegion(xzqdm);
		notice.setAction(action);

		if (type == 3) {
			ArrayList<String> arrayList = new ArrayList<String>();
			String[] ids = content.split(",");
			for (int j = 0; j < ids.length; j++) {
				arrayList.add(ids[j]);
			}
			JSONObject jsonObject = new JSONObject();
			jsonObject.put("tag", 1);
			jsonObject.put("data", arrayList);

			notice.setContent(jsonObject.toString());
		} else {
			notice.setContent(content);
		}

		taskNotice = taskNoticeDao.save(notice);

		String[] receiveId = receiveIds.split(",");
		String noticeId = taskNotice.getId();
		for (int i = 0; i < receiveId.length; i++) {
			if (!receiveId[i].isEmpty()) {
				long userId = Long.parseLong(receiveId[i]);
				TaskNoticeUser noticeUser = new TaskNoticeUser();
				noticeUser.setNoticeId(noticeId);
				noticeUser.setUserId(String.valueOf(userId));
				noticeUser.setState(0);
				userDao.save(noticeUser);
			}
		}

		return taskNotice;
	}

	/**
	 * 获取用户所属政区，如果用户存在多个所属政区，则返回第一个所属政区
	 *
	 * @param userId 用户id
	 * @return 用户所属的第一个政区，如果不存在时则返回空字符串
	 */
	public String getUserRegionCode(Long userId) {
		 GutilAssert.state(userId != null && userId > -1, "parameter: [userId] can not be null " +
				"and must larger then -1");
		String regionCode = "";

		List<UserArea> myAreas = userAreaDao.getMyArea(userId);
		if (!GutilCollection.isEmpty(myAreas)) {
			regionCode = myAreas.get(0).getCode();
		}
		return regionCode;
	}

	public List<RegionDto> userRoleRegions(List<String> areas, String version){
		List<RegionDto> list = new ArrayList<RegionDto>();
		for(String s:areas){
			if("1".equalsIgnoreCase(s)){
				continue;
			}
			RegionDto regionDto = new RegionDto();
			if(s.length() <=6 ){
				if(version != null ){
					regionDto = getRegionByVersion(s,version); //省、市、区县
				}else{
					regionDto = getRegion(s); //省、市、区县
				}
			}else if(s.length() == 9){
				if(version != null ){
					regionDto = getRegionTownAndVersion(s,version); // 乡镇
				}else{
					regionDto = getRegionTown(s); // 乡镇
				}
			}else if(s.length() == 12){
				if(version != null ){
					regionDto = getRegionVillageAndVersion(s,version); // 乡镇
				}else{
					regionDto = getRegionVillage(s); // 村
				}
			}
			list.add(regionDto);
		}
		return list;
	}



	/**
	 * 根据用户作业区获取 行政区树
	 * @param areas
	 * @return
	 */
	public List<RegionDto> regionDtos(List<String> areas){
		List<RegionDto> list = new ArrayList<RegionDto>();
		for(String s:areas){
			if("1".equalsIgnoreCase(s)){
              continue;
			}
			RegionDto regionDto = new RegionDto();
			if(s.length() <=6 ){
					 regionDto =gerParent( getRegion(s)); //省、市、区县
			}else if(s.length() == 9){
				 regionDto =gerParent( getRegionTown(s)); // 乡镇
			}else if(s.length() == 12){
				 regionDto =gerParent( getRegionVillage(s)); // 村
			}

			//添加数据前进行去重
			boolean check = true;
			for(int i =0;i<list.size();i++){
               if(regionDto.getCode().equalsIgnoreCase(list.get(i).getCode())){
				   check = false;
				   list.get(i).setChildren( distinctList1(list.get(i).getChildren(),regionDto.getChildren()));
			   }
			}
			if(check){
				list.add(regionDto);
			}

		}
		return list;
	}

	/**
	 * 递归将两个list数据去重并合成tree
	 * @param list1
	 * @param list2
	 * @return
	 */
	public List<RegionDto> distinctList(List<RegionDto> list1, List<RegionDto> list2){
		List<RegionDto> newList = new ArrayList<>();
             if(!list1.containsAll(list2) || list2.containsAll(list1)){
                for(RegionDto r1 :list1){
                    for(RegionDto r2 :list2){
                  if(r1.getCode().equalsIgnoreCase(r2.getCode())){
                    return distinctList(r1.getChildren(),r2.getChildren());
				  }else{
					  newList = new ArrayList<>(Arrays.asList(new RegionDto[list1.size()]));
					  Collections.copy(newList, list1);
					  newList.add(r2);
				  }
					}
				}
			 }
             return newList;
	}

	public List<RegionDto> distinctList1(List<RegionDto> list1, List<RegionDto> list2){
		//List<RegionDto> newList = new ArrayList<>();
		if(!list1.containsAll(list2) || list2.containsAll(list1)){
			for(RegionDto r1 :list1){
				for(RegionDto r2 :list2){
					if(r1.getCode().equalsIgnoreCase(r2.getCode())){
						//return distinctList(r1.getChildrens(),r2.getChildrens());
						r1.setChildren(distinctList(r1.getChildren(),r2.getChildren()));
					}else{
						List<RegionDto> 	newList = new ArrayList<>(Arrays.asList(new RegionDto[list1.size()]));
						Collections.copy(newList, list1);
						newList.add(r2);
						list1 = newList;
					}
				}
			}
		}
		return list1;
	}


	public static List<RegionDto> distinct(List<RegionDto> list) {
		if (null != list && list.size() > 0) {
			//循环大的list集合
			for (int i = 0; i < list.size(); i++) {
				//得到list中每一个map
				RegionDto map= list.get(i);
				for (int j = 1; j < list.size(); j++) {
					RegionDto map2= list.get(j);
					if (map.equals(map2)) {
						list.remove(j);
						continue;
					}
				}
			}
		}
		//得到最新移除重复元素的list
		return list;
	}


	/**
	 *  递归 获取父节点 形成tree
	 * @param regionDto
	 * @return
	 */
	public RegionDto gerParent(RegionDto regionDto){
            if(regionDto.getPcode() == null || regionDto.getPcode().equalsIgnoreCase("-1")){
             return regionDto;
			}
			RegionDto pareRegionDto = new RegionDto();
			if(regionDto.getPcode().length() == 9){
				   pareRegionDto = getRegionTown(regionDto.getPcode());
			  }else{
				pareRegionDto = getRegion(regionDto.getPcode());
			}
			List<RegionDto> list = new ArrayList<>();
			list.add(regionDto);
			pareRegionDto.setChildren(list);
		return gerParent(pareRegionDto);
	}


	public RegionDto copyProperties1(String code){
		RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
		RegionDto RegionDto = new RegionDto();
		List<com.geoway.landteam.landcloud.core.model.base.dto.RegionDto> list = new ArrayList<com.geoway.landteam.landcloud.core.model.base.dto.RegionDto>();
		Region region = regionDao.findByCodeAndVersion(code,defaultVersion!=null?defaultVersion.getVersion():"2018");
		if(region != null){
			com.geoway.landteam.landcloud.core.model.base.dto.RegionDto regionDto = new RegionDto();
			BeanUtil.copyProperties(region, regionDto,false);
			list.add(regionDto);
		}
		RegionDto.setChildren(list);
		RegionDto.setCode(region.getPcode());
		return RegionDto;
	}


	public List<RegionDto> copyProperties(String code){
		RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
		List<RegionDto> list = new ArrayList<RegionDto>();
			Region region =  regionDao.findByCodeAndVersion(code,defaultVersion!=null?defaultVersion.getVersion():"2018");
			if(region != null){
				RegionDto regionDto = new RegionDto();
				BeanUtil.copyProperties(region, regionDto,false);
				list.add(regionDto);
			}
      return list;
	}




	public RegionDto getRegion(String code){
		RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
		Region region = regionDao.findByCodeAndVersion(code,defaultVersion!=null?defaultVersion.getVersion():"2018");
		RegionDto regionDto = new RegionDto();
		if(region != null) {
			BeanUtil.copyProperties(region, regionDto, false);
		}
		return regionDto;
	}

	public RegionDto getRegionByVersion(String code, String version){
		Region region = regionDao.findByCodeAndVersion(code,version);
		RegionDto regionDto = new RegionDto();
		if(region != null) {
			BeanUtil.copyProperties(region, regionDto, false);
		}
		return regionDto;
	}

	public RegionDto getRegionTown(String code){
		RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
		RegionTown regionTown = regionTownRepository.getByCodeAndVersion(code,defaultVersion!=null?defaultVersion.getVersion():"2018");
		RegionDto regionDto = new RegionDto();
		if(regionTown != null) {
			BeanUtil.copyProperties(regionTown, regionDto, false);
		}
		return regionDto;
	}

	public RegionDto getRegionTownAndVersion(String code, String version){
		RegionTown regionTown = regionTownRepository.getByCodeAndVersion(code,version);
		RegionDto regionDto = new RegionDto();
		if(regionTown != null) {
			BeanUtil.copyProperties(regionTown, regionDto, false);
		}
		return regionDto;
	}

	public RegionDto getRegionVillage(String code){
		RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
		RegionVillage regionVillage = regionVillageRepository.getByCodeAndVersion(code,defaultVersion!=null?defaultVersion.getVersion():"2018");
		RegionDto regionDto = new RegionDto();
		if(regionVillage != null) {
			BeanUtil.copyProperties(regionVillage, regionDto, false);
		}
		return regionDto;
	}

	public RegionDto getRegionVillageAndVersion(String code, String version){
		RegionVillage regionVillage = regionVillageRepository.getByCodeAndVersion(code,version);
		RegionDto regionDto = new RegionDto();
		if(regionVillage != null) {
			BeanUtil.copyProperties(regionVillage, regionDto, false);
		}
		return regionDto;
	}

	/**
	 * 获取政区级别数据
	 * @param code
	 * @param version
	 * @return
	 */
	public RegionDto getRegionDto(String code, String version){
		RegionDto regionDto = new RegionDto();
		if(code.length()<=6){
			regionDto =	getRegionByVersion(code,version);
		}else if(code.length() == 9){
			regionDto = getRegionTownAndVersion(code,version);
		}else if(code.length() == 12){
			regionDto = getRegionVillageAndVersion(code,version);
		}
		return regionDto;
	}

}
