package com.geoway.landteam.landcloud.service.user;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.NoticeNewRepository;
import com.geoway.landteam.customtask.repository.task.NoticeRepository;
import com.geoway.landteam.customtask.repository.task.NoticeSubscribeRepository;
import com.geoway.landteam.customtask.repository.task.NoticeTopicRepository;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.entity.CloudDiskOfGroup;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroup;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroupMember;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.pub.CloudDiskOfGroupRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Department2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.user.*;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.user.FriendsServiceImpl;
 import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgGroupUtil;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
/*import com.gw.base.data.GwValidateException;*/
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Transactional(rollbackFor = Exception.class)
public class MWorkGroupService {

    @Autowired
    WorkGroupRepository workGroupDao;

    @Autowired
    WorkGroupMemberRepository workGroupMemberDao;

    @Autowired
    Organization2UserRepository organization2UserDao;

    @Autowired
    OrganizationRepository organizationDao;

    @Autowired
    YXUserRepository yxUserDao;

    @Autowired
    LandUserRepository landUserDao;

    @Autowired
    FriendsServiceImpl friendsService;

    @Autowired
    LandUserService landUserService;

//    @Autowired
//    AppBasicRepository appBasicDao;

    @Autowired
    CloudDiskOfGroupRepository cloudDiskOfGroupDao;

    @Autowired
    UserAreaRepository userAreaDao;

    @Autowired
    Department2UserRepository department2UserDao;

    @Autowired
    TaskNoticeServiceImpl taskNoticeService;

    @Autowired
    NoticeRepository noticeRepository;

    @Autowired
    NoticeTopicRepository noticeTopicRepository;

    @Autowired
    NoticeNewRepository noticeNewRepository;

    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;

    @Autowired
    UserNameService userNameService;

    // 创建工作组
    public WorkGroup createWorkGroup(Long userId, String ids, String groupName) throws Exception {
        WorkGroup workGroup = new WorkGroup();
        workGroup.setId(UUID.randomUUID().toString());
        workGroup.setName(groupName);
        workGroup.setState(0);
        workGroup.setCreateTime(new Date());

        // 定时30天后删除
//        Quartz quartz = new Quartz();
//        quartz.setId(UUID.randomUUID().toString());
//        quartz.setClazz("com.geoway.land.core.cloud.service.QuartzJobService");
//        quartz.setJobName("deleteWorkGroupOutOfDate");
//        quartz.setArgs(workGroup.getId());
//        quartz.setCronExpression(buildCronExpression());
//        quartz.setStatus(0);
//        Date now = new Date();
//        quartz.setCreateTime(now);
//        quartz.setExcuteTime(DateUtils.addDays(now, 30));
//        quartzDao.save(quartz);

        // 去重
        Set<String> idSet = new HashSet<String>();
        for (String id : ids.split(",")) {
            if (userId.toString().equals(id)) {
                continue;
            }
            idSet.add(id);
        }

        workGroup.setAccid(createYXGroup(userId, idSet, groupName));

        workGroupDao.save(workGroup);

        // 工作组成员 (创建者)
        List<WorkGroupMember> memberList = new ArrayList<WorkGroupMember>();
        WorkGroupMember workGroupOwner = new WorkGroupMember();
        workGroupOwner.setId(UUID.randomUUID().toString());
        workGroupOwner.setRole(2);
        workGroupOwner.setCreateTime(new Date());
        workGroupOwner.setUserId(userId);
        workGroupOwner.setGroupId(workGroup.getId());
        memberList.add(workGroupOwner);

        for (String id : idSet) {
            // 工作组成员
            WorkGroupMember member = new WorkGroupMember();
            member.setId(UUID.randomUUID().toString());
            member.setRole(0);
            member.setCreateTime(new Date());
            member.setUserId(Long.valueOf(id));
            member.setGroupId(workGroup.getId());
            memberList.add(member);
        }
        workGroupMemberDao.saveAll(memberList);

        // 创建工作组云盘
        //cloudDiskUtilService.createOneCloudDiskOfGroup(workGroup.getId(), userId, groupName);
        return workGroup;
    }


    private String buildCronExpression() {
        Date now = new Date();
        Date DateOf30DaysLater = DateUtils.addMinutes(now, 5);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String format = sdf.format(DateOf30DaysLater);
        StringBuilder cronExpression = new StringBuilder();
        String[] strArr = format.split("-");
        // second minute hour dayofMonth month dayofweek year
        return cronExpression
                .append(strArr[5]).append(" ")
                .append(strArr[4]).append(" ")
                .append(strArr[3]).append(" ")
                .append(strArr[2]).append(" ")
                .append(strArr[1]).append(" ")
                .append("?").append(" ")
                .append(strArr[0]).toString();

    }

    private String createYXGroup(Long userId, Set<String> idSet, String groupName) {
        // 创建云信群聊，并将群聊accid保存到工作组对象
        String members = generateMemberJsonStr(idSet, userId);

        YXUser owner = yxUserDao.findById(Long.valueOf(userId)).orElse(null);

        String result = CloudMsgGroupUtil.createYxGroup(groupName, owner.getAccid(), members, "邀请信息", "0", "0");

        @SuppressWarnings("unchecked")
        Map<String, Object> map = (Map<String, Object>) JSON.parse(result);
        if (map == null || map.get("tid") == null) {
            throw new RuntimeException("创建云信工作组失败!");
        }
        return map.get("tid").toString();
    }

    private String generateMemberJsonStr(Set<String> idSet, Long operaterId) {
        StringBuilder sb = new StringBuilder("[");
        for (String userId : idSet) {
            if (operaterId.toString().equals(userId)) {
                continue;
            }
            YXUser yxUser = yxUserDao.findById(Long.valueOf(userId)).orElse(null);
            LandUser landUser = landUserDao.findById(Long.valueOf(userId)).orElse(null);
            if (yxUser != null && landUser!=null && landUser.getState()!=0) {
                sb.append("'" + yxUser.getAccid() + "'");
                sb.append(",");
            } else {
                if(landUser!=null && landUser.getState()==0) {
                    throw new RuntimeException("用户 [" + landUser.getName() + "] 为禁用账号");
                }else{
                    throw new RuntimeException("用户 [" + landUser.getName() + "] 没有云信账号,请先注册账号");
                }
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append("]").toString();
    }

    private String generateMemberJsonStr1(List<Long> idList) {
        StringBuilder sb = new StringBuilder("[");
        for (Long userId : idList) {
            YXUser yxUser = yxUserDao.findById(userId).orElse(null);
            if (yxUser == null) {
                LandUser landUser = landUserDao.findById(Long.valueOf(userId)).orElse(null);
                throw new RuntimeException("用户 [" + landUser.getName() + "] 未启用账号");
            } else {
                sb.append("'" + yxUser.getAccid() + "'");
                sb.append(",");
            }
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.append("]").toString();
    }

    public Page<WorkGroup> getWorkGroupsICreate(Long userId, String filterParam,
                                                String sortParam, int start, int limit) {
        List<String> groupIds = workGroupMemberDao.queryGroupIdOfICreate(userId);
        filterParam += ";Q_state_N_EQ=0";
        Page<WorkGroup> workGroups = getWorkGroupByGroupIds(groupIds, filterParam, sortParam, start, limit);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups)
                completeWorkGroupInfo(workGroup, userId);
        }
        return workGroups;
    }

    public Page<WorkGroup> getWorkGroupsIHave(Long userId, String filterParam,
                                              String sortParam, int start, int limit) {
        List<String> groupIds = workGroupMemberDao.queryGroupIdOfIHave(userId);
        filterParam += ";Q_state_N_EQ=0";
        Page<WorkGroup> workGroups = getWorkGroupByGroupIds(groupIds, filterParam, sortParam, start, limit);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups)
                completeWorkGroupInfo(workGroup, userId);
        }
        return workGroups;
    }

    /**
     * 修改用户在工作组中角色信息
     * 李密浩
     */
    public void updateUserRole(String workGroupId, String userId, Integer role) {
        if (role.equals(2)) {
            throw new RuntimeException("不能设置创建者角色");
        }
        WorkGroupMember workGroupMember = workGroupMemberDao.queryByUserIdAndGroupId(Long.valueOf(userId), workGroupId);
        workGroupMember.setRole(role);
        workGroupMemberDao.save(workGroupMember);
    }


    /**
     * 李密浩 ：获取个人工作组Service
     *
     * @param userId    用户Id
     * @param groupname 工作组名称,模糊查询
     * @param pageIndex 页码
     * @param rows      每页条数
     * @return
     */
    public Page<WorkGroup> getMyWorkGroups(Long userId, String groupname, int pageIndex, int rows) {
        //根据用户Id获取工作组Id
        List<String> groupIds = workGroupMemberDao.queryGroupIdOfIHave(userId);
        StringBuilder stringBuilder = new StringBuilder();
        //判断是否进行模糊查询
        if(!"".equals(groupname)){
            stringBuilder.append("Q_name_S_LK=" + groupname );
        }
        //0表示工作组未被解散
        stringBuilder.append(";Q_state_N_EQ=0");
        //创建查询条件字符串
        String filterParam = stringBuilder.toString();
        //查询工作组
        Page<WorkGroup> workGroups = getWorkGroupByGroupIds(groupIds, filterParam, null, pageIndex, rows);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups) {
                completeWorkGroupInfo(workGroup, userId);
            }
        }
        return workGroups;
    }

    public Page<WorkGroup> getWorkGroupsIManage(Long userId, String filterParam,
                                                String sortParam, int start, int limit) {
        List<String> groupIds = workGroupMemberDao.queryGroupIdIManage(userId);
        filterParam += ";Q_state_N_EQ=0";
        Page<WorkGroup> workGroups = getWorkGroupByGroupIds(groupIds, filterParam, sortParam, start, limit);
        if (workGroups != null) {
            for (WorkGroup workGroup : workGroups)
                completeWorkGroupInfo(workGroup, userId);
        }
        return workGroups;
    }

    private void completeWorkGroupInfo(WorkGroup workGroup, Long userId) {
        // 创建者信息
        Long ownerId = workGroupMemberDao.queryOwnerId(workGroup.getId());
        workGroup.setOwner(ownerId);
        /*
        LandUser temp = landUserDao.findById(ownerId).orElse(null);
        if (temp != null) {
            workGroup.setOwnerName(userNameService.getUserRealNameByUserId(ownerId.toString()));
        }
        */
        workGroup.setOwnerName(userNameService.getUserRealNameByUserId(ownerId.toString()));
        // 完善单位信息
        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(ownerId);
        if (!organization2Users.isEmpty()) {
            String organizationId = organization2Users.get(0).getOrganizationId();
            workGroup.setOrgIdOfOwner(organizationId);
            Organization organization = organizationDao.findById(organizationId).orElse(null);
            if(organization!=null) {
                workGroup.setOrgNameOfOwner(organization.getName());
            }
        }

        // 部分成员信息
        List<Long> memberIdList = workGroupMemberDao.querySomeOfMembers(workGroup.getId());
        String str="";
        int count = 0;
        for (Long memberId : memberIdList) {
            /*
            LandUser member = landUserDao.findById(memberId).orElse(null);
            if (member == null || new Integer(1).equals(member.getIsdel())) {
                continue;
            }
            */
            String memberName = userNameService.getUserRealNameByUserId(memberId.toString());
            str += memberName+",";
            count++;
            if (count >= 6) {
                str = str.substring(0,str.length()-1);
                str +="等";
                break;
            }
        }
        if (StringUtils.isNotBlank(str)) {
            workGroup.setSomeOfmembers(str.endsWith(",") ? str.substring(0,str.length()-1) : str);
        }

        // 用户在此工作组中的角色
        WorkGroupMember member = workGroupMemberDao.queryByUserIdAndGroupId(userId, workGroup.getId());
        if (member != null) {
            workGroup.setMyRole(member.getRole());
        }

//        List<AppBasic> appBasics = appBasicDao.selectByGroupId(workGroup.getId());
//        if (appBasics == null) {
//            workGroup.setPicNum(0);
//        } else {
//            workGroup.setPicNum(appBasics.size());
//        }
        /**
         * 李密浩：增加每个工作组总人数属性
         */
        List<WorkGroupMember> list = workGroupMemberDao.queryByWorkGroupId(workGroup.getId());
        workGroup.setMembersNum(list.size());

        List<Long> glylist = list.stream().filter(r -> r.getRole() == 1 || r.getRole() == 2).map(r -> r.getUserId()).collect(Collectors.toList());

        //用户是否是创建者 或管理员
        if (!glylist.isEmpty() && glylist.indexOf(userId) > -1) {
            workGroup.setIsowner(true);
        } else {
            workGroup.setIsowner(false);
        }

    }

    private Page<WorkGroup> getWorkGroupByGroupIds(List<String> groupIds,
                                                   String filterParam, String sortParam, int start, int limit) {
        if (groupIds.isEmpty()) {
            // 返回空page
            filterParam += ";Q_state_N_EQ=-1";
            return workGroupDao.findAll(new QuerySpecification<WorkGroup>(filterParam), PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String groupId : groupIds) {
            stringBuilder.append(groupId);
            stringBuilder.append(",");
        }
        filterParam += ";Q_state_N_EQ=0;Q_id_S_IN=" + stringBuilder.toString();
        return workGroupDao.findAll(new QuerySpecification<WorkGroup>(filterParam),PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
    }


    // 删除工作组,先确认是否为自己创建的工作组
    public void deleteWorkGroup(String id, Long userId) throws Exception {
        WorkGroupMember member = workGroupMemberDao.queryOfICreate(id, userId);
        if (member == null) {
            throw new RuntimeException("无法解散不是自己创建的工作组");
        }

        //新版本消息通知
        deleteWorkGroupNotice(id,userId);

        WorkGroup myWorkGroup = workGroupDao.findById(id).orElse(null);
        myWorkGroup.setState(1);
        workGroupDao.save(myWorkGroup);
        YXUser yxUser = yxUserDao.findById(userId).orElse(null);

        String result = CloudMsgGroupUtil.deleteYxGroup(myWorkGroup.getAccid(), yxUser.getAccid());
        checkYXResult(result);

        // 删除对应工作组云盘
        CloudDiskOfGroup cloudDiskOfGroup = cloudDiskOfGroupDao.findById(id).orElse(null);
        if (cloudDiskOfGroup != null) {
            try {
                //JFunBoxTeamSpaceUtil.deleteTeamSpace(cloudDiskOfGroup.getId());
            } catch (Exception e) {
                cloudDiskOfGroup.setDescription("删除失败");
            }
            cloudDiskOfGroup.setIsDeleted(1);
            cloudDiskOfGroupDao.save(cloudDiskOfGroup);
        }

        //LandUser one = landUserDao.findById(userId).orElse(null);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

        // 推送消息
        String content = String.format("【工作组解散通知】。%s工作组，已被群主%s解散，时间：%s", myWorkGroup.getName(), userNameService.getUserRealNameByUserId(userId.toString()), format.format(new Date()));

        // 任务通知
        TaskNotice taskNotice = new TaskNotice();
        taskNotice.setData(myWorkGroup.getAccid());
        taskNotice.setContent(content);
        taskNotice.setId(UUID.randomUUID().toString());
        taskNotice.setState(1);
        taskNotice.setSendUser(userId);
        taskNotice.setTitle("工作组解散通知");
        taskNotice.setSendTime(new Date());
        taskNotice.setType(7);// 任务公告
        taskNotice.setAction(18);// 1 工作组解散
        taskNotice = taskNoticeService.save(taskNotice);

        // 推送消息
        List<String> alias = new ArrayList<String>();
        List<WorkGroupMember> workGroupMembers = workGroupMemberDao.queryByWorkGroupId(id);
        for (int i = 0; i < workGroupMembers.size(); i++) {
            // 发送推送消息到个人
            TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            JSONObject data = new JSONObject();
            taskNoticeUser.setData(data.toJSONString());
            taskNoticeUser.setState(0);
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setNoticeId(taskNotice.getId());
            taskNoticeUser.setUserId(workGroupMembers.get(i).getUserId().toString());
            taskNoticeService.save(taskNoticeUser);
            alias.add(workGroupMembers.get(i).getUserId().toString());
        }

        // 删除对应工作组成员
        workGroupMemberDao.deleteByGroupId(id);

        // 推送消息
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("type", 2);
        MixPushServer.sendNotifyToAlias(alias, "工作组解散通知", content, JSON.toJSONString(message));
    }


    public void addUsers(Long ownerId, String workGroupId, String userIds) {
        WorkGroupMember workGroupMember = workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (workGroupMember == null) {
            throw new RuntimeException("无权限");
        }
        // 去重, 去掉已经在群里的
        List<Long> memberIds = workGroupMemberDao.queryMembersId(workGroupId);
        Set<String> idSet = new HashSet<String>();
        for (String id : userIds.split(",")) {
            if (!memberIds.contains(Long.valueOf(id))) {
                idSet.add(id);
            }
        }
        if (idSet.isEmpty()) {
            return;
        }

        for (String userId : idSet) {
            WorkGroupMember member = new WorkGroupMember();
            member.setId(UUID.randomUUID().toString());
            member.setRole(0);
            member.setCreateTime(new Date());
            member.setUserId(Long.valueOf(userId));
            member.setGroupId(workGroupId);
            workGroupMemberDao.save(member);
        }

        // 对应云信群加入用户
        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
        if (workGroup == null || workGroup.getState() != 0) {
            throw new RuntimeException("工作组不存在");
        }
        String membersJsonStr = generateMemberJsonStr(idSet, ownerId);
        if (!"]".equals(membersJsonStr)) {
            String result = CloudMsgGroupUtil.addUsersToYxGroup(workGroup.getAccid(), getCreatorAccid(workGroupId), membersJsonStr, "0", "邀请加入群聊");
            checkYXResult(result);
        }
    }

    public void addUser(String workGroupId, Long userId) {
        WorkGroup workGroup = workGroupDao.queryByID(workGroupId);
        if (workGroup == null) {
            throw new RuntimeException("工作组已解散");
        }
        // 去重, 去掉已经在群里的
        List<Long> memberIds = workGroupMemberDao.queryMembersId(workGroupId);
        if (memberIds.contains(Long.valueOf(userId))) {
            throw new RuntimeException("无需加入，已在工作组内");
        }

        WorkGroupMember member = new WorkGroupMember();
        member.setId(UUID.randomUUID().toString());
        member.setRole(0);
        member.setCreateTime(new Date());
        member.setUserId(Long.valueOf(userId));
        member.setGroupId(workGroupId);
        workGroupMemberDao.save(member);
        Set<String> idSet = new HashSet<String>();
        idSet.add(userId.toString());
        String membersJsonStr = generateMemberJsonStr(idSet, 0L);
        if (!"]".equals(membersJsonStr)) {
            String result = CloudMsgGroupUtil.addUsersToYxGroup(workGroup.getAccid(), getCreatorAccid(workGroupId), membersJsonStr, "0", "邀请加入群聊");
            checkYXResult(result);
        }
    }

    public void removeUsers(Long ownerId, String workGroupId, String userIds) {
        List<Long> adminIdList = workGroupMemberDao.queryAdminAndOwnerId(workGroupId);
        if (!adminIdList.contains(ownerId)) {
            throw new RuntimeException("无权限");
        }
        Set<String> idSet = new HashSet<String>();
        for (String id : userIds.split(",")) {
            idSet.add(id);
        }
        for (String id : idSet) {
            WorkGroupMember member = workGroupMemberDao
                    .queryByWorkGroupIdAndUserId(workGroupId, Long.valueOf(id));
            if (member != null) {
                workGroupMemberDao.delete(member);
            }
        }
        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
        if (workGroup == null || workGroup.getState() != 0) {
            throw new RuntimeException("工作组不存在");
        }
        String memberJsonStr = generateMemberJsonStr(idSet, ownerId);
        if (!"]".equals(memberJsonStr)) {
            String result = CloudMsgGroupUtil.removeUsersFromYxGroup(workGroup.getAccid(), getCreatorAccid(workGroupId), memberJsonStr);
            checkYXResult(result);
        }
    }

    public void quitFromWorkGroup(Long ownerId, String workGroupId, String nextGroupOwnerId) {
        WorkGroupMember workGroupMember = workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (workGroupMember == null) {
            throw new RuntimeException("已经不在此工作组");
        }
        Long creatorId = workGroupMemberDao.queryOwnerId(workGroupId);
        // 群主退群, 需指定管理员接替
        if (workGroupMember.getRole() == 2) {
            WorkGroupMember nextLeader = null;
            if (StringUtils.isBlank(nextGroupOwnerId)) {
                List<WorkGroupMember> admins = workGroupMemberDao.getAdmins(workGroupId);
                if (admins.isEmpty()) {
                    throw new RuntimeException("退出群组失败！当前工作组中没有可接替群主的管理员，请先指定管理员后退出！");
                }
                // 默认最先进群的接替
                nextLeader = admins.get(0);
            } else {
                nextLeader = workGroupMemberDao
                        .queryByUserIdAndGroupId(Long.valueOf(nextGroupOwnerId), workGroupId);
                if (nextLeader == null || nextLeader.getRole() != 1) {
                    throw new RuntimeException("必须指定工作组管理员为群主");
                }
            }
            nextLeader.setRole(2);
            workGroupMemberDao.save(nextLeader);
            // 删除群成员
            workGroupMemberDao.delete(workGroupMember);

            WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
            YXUser yxUserOfOwner = yxUserDao.findById(ownerId).orElse(null);
            YXUser yxUserOfNextOwner = yxUserDao.findById(nextLeader.getUserId()).orElse(null);

            if (yxUserOfOwner != null && yxUserOfNextOwner != null) {
                // 移交云信群组并退群
                CloudMsgGroupUtil.changeOwner(workGroup.getAccid(), yxUserOfOwner.getAccid(), yxUserOfNextOwner.getAccid(), "1");
            }
            // 管理员退群
        } else if (workGroupMember.getRole() == 1) {
            List<Long> list = new ArrayList<Long>();
            list.add(workGroupMember.getUserId());
            // 先设置为普通成员
            removeAdmins(list, workGroupId, creatorId);
            removeUsers(creatorId, workGroupId, ownerId.toString());
        } else {
            // 普通用户退群
            removeUsers(creatorId, workGroupId, ownerId.toString());
        }

    }

    public Map<String, Object> getMembers(String workGroupId, int start, int limit,
                                          String filterParam, String sortParam, String username) {

        List<WorkGroupMember> members = workGroupMemberDao.queryByWorkGroupId(workGroupId);
        if (members.isEmpty()) {
            return new HashMap<String, Object>();
        }

        StringBuilder userIds = new StringBuilder();
        List<Long> membersIdList = new ArrayList<Long>();
        for (WorkGroupMember member : members) {
            userIds.append(member.getUserId());
            userIds.append(",");
            membersIdList.add(Long.valueOf(member.getUserId()));
        }

        // filterParam += ";Q_isdel_N_EQ=0;Q_id_N_IN=" + userIds.toString();

        List<LandUser> landUsers;
        if (StringUtils.isBlank(username)) {
            landUsers = landUserDao.queryUserForWorkGroup(membersIdList, workGroupId);
        } else {
            JSONObject jsonObject= JSONObject.parseObject(username);
            //
            if(jsonObject!=null && jsonObject.get("type").equals("username")) {
                landUsers = landUserDao.queryForWorkGroupWithUserName(membersIdList, workGroupId, "%" + jsonObject.get("name") + "%");
            } else if (jsonObject != null && jsonObject.get("type").equals("rname")) {
                landUsers = landUserDao.queryForWorkGroupWithRName(membersIdList, workGroupId, "%" + jsonObject.get("name") + "%");
            }else{
                landUsers = new ArrayList<>();
            }
        }
        // 手动分页
        List<LandUser> result = new ArrayList<LandUser>();
        int currIdx = (start > 0 ? start * limit : 0);
        for (int i = 0; i < limit && i < landUsers.size() - currIdx; i++) {
            result.add(landUsers.get(currIdx + i));
        }
//        Page<LandUser> users = landUserDao.findAll(new QuerySpecification<LandUser>(filterParam),
//                new PageRequest(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        // 完善用户工作组角色
        for (LandUser user : result) {
            for (WorkGroupMember member : members) {
                if (user.getId().equals(member.getUserId())) {
                    user.setWorkGroupRole(member.getRole());
                }
            }
        }
        // 完善用户accid
        for (LandUser user : result) {
            YXUser yxUser = yxUserDao.findById(user.getId()).orElse(null);
            if (yxUser != null) {
                user.setAccid(yxUser.getAccid());
            }
        }

        //取值设置
        List<Long> userIds1 = new ArrayList<Long>();
        for (LandUser curUser : result) {
            userIds1.add(curUser.getId());
        }

        /**
         * 李密浩：修改查找不存在的用户名会报错的bug 加了if判断
         */
        if (userIds1.size() != 0) {
            //查询角色对应的行政区
            List<Object[]> xzqObjs = userAreaDao.getNameByIds(userIds1);

            //查询用户对应的部门名称
            List<Object[]> departObjs = department2UserDao.getDepartByIds(userIds1);

            for (LandUser curUser : result) {
                for (Object[] xzqObj : xzqObjs) {
                    String name = xzqObj[0].toString();
                    String lsUserId = xzqObj[1].toString();
                    if (curUser.getId().toString().equals(lsUserId)) {
                        curUser.setSjsf(name);
                        break;
                    }
                }

                for (Object[] departObj : departObjs) {
                    String name = departObj[0].toString();
                    String lsUserId = departObj[1].toString();
                    if (curUser.getId().toString().equals(lsUserId)) {
                        curUser.setDepNo(name);
                        break;
                    }
                }
            }


            Map<String, Object> map = new HashMap<String, Object>();
            map.put("total", landUsers.size());
            map.put("content", result);

            return map;
        } else {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("total", 0);
            map.put("content", Collections.emptyList());

            return map;
        }
    }

    public Long getMemberCount(String workGroupId) {
        return workGroupMemberDao.count((root, query, cb) -> cb.equal(root.get("groupId"), workGroupId));
    }

    public Map<String, Object> getContactsForWorkGroup(Long ownerId, String workGroupId) throws Exception {
        List<LandUser> myFriends = friendsService.getMyFriends(ownerId);
        Page<LandUser> myColleagues = landUserService.getMyColleagues1(ownerId, 0, 500, "", "SORT_name_ASC");
        List<WorkGroupMember> workGroupMembers = workGroupMemberDao.queryByWorkGroupId(workGroupId);
        // 联系人在工作组中,则指明其角色
        for (WorkGroupMember member : workGroupMembers) {
            for (LandUser friend : myFriends) {
                if (member.getUserId().equals(friend.getId())) {
                    friend.setWorkGroupRole(member.getRole());
                }
            }
            for (LandUser colleague : myColleagues) {
                if (member.getUserId().equals(colleague.getId())) {
                    colleague.setWorkGroupRole(member.getRole());
                }
            }
        }

        Map<String, Object> myContacts = new HashMap<String, Object>();
        myContacts.put("myFriends", myFriends);
        myContacts.put("myColleagues", myColleagues.getContent());
        return myContacts;
    }


    private void checkYXResult(String result) {
        @SuppressWarnings("unchecked")
        Map<String, Object> map = (Map<String, Object>) JSON.parse(result);
        if (map == null || !"200".equals(map.get("code").toString())) {
            throw new RuntimeException("操作失败! 原因:" + result);
        }
    }


    public void updateUsers(Long ownerId, String workGroupId, String newUserIds) {
        List<Long> oldUserIds = workGroupMemberDao.queryMembersId(workGroupId);

        StringBuilder userIdsOfAdd = new StringBuilder();
        StringBuilder userIdsOfRemove = new StringBuilder();

        Set<Long> oldUserIdSet = new HashSet<Long>(oldUserIds);
        Set<Long> newUserIdSet = new HashSet<Long>();

        // 群主
        Long creatorId = workGroupMemberDao.queryOwnerId(workGroupId);
        // 加上群主和自己
        newUserIds += "," + creatorId.toString() + "," + ownerId.toString();
        for (String userId : newUserIds.split(",")) {
            newUserIdSet.add(Long.valueOf(userId));
        }
        Set<Long> tempSet = new HashSet<Long>();

        // 添加新用户与老用户的差集
        tempSet.addAll(newUserIdSet);
        tempSet.removeAll(oldUserIdSet);
        for (Long userIdOfAdd : tempSet) {
            userIdsOfAdd.append(userIdOfAdd);
            userIdsOfAdd.append(",");
        }

        tempSet.clear();

        // 移除老用户与新用户的差集
        tempSet.addAll(oldUserIds);
        tempSet.removeAll(newUserIdSet);
        for (Long userIdOfRemove : tempSet) {
            userIdsOfRemove.append(userIdOfRemove);
            userIdsOfRemove.append(",");
        }
        if (StringUtils.isNotBlank(userIdsOfAdd)) {
            addUsers(creatorId, workGroupId, userIdsOfAdd.toString());
        }
        if (StringUtils.isNotBlank(userIdsOfRemove)) {
            checkCreatorOrAdmin(ownerId, workGroupId);
            removeUsers(creatorId, workGroupId, userIdsOfRemove.toString());
        }

    }

    private WorkGroupMember checkCreator(Long ownerId, String workGroupId) {
        WorkGroupMember member = workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (member == null || member.getRole() != 2) {
            throw new RuntimeException("无权限");
        }
        return member;
    }

    private WorkGroupMember checkCreatorOrAdmin(Long ownerId, String workGroupId) {
        WorkGroupMember member = workGroupMemberDao.queryByUserIdAndGroupId(ownerId, workGroupId);
        if (member == null || member.getRole() < 1) {
            throw new RuntimeException("无权限");
        }
        return member;
    }

    public void updateAdmins(Long ownerId, String workGroupId, String adminIds) {
        checkCreator(ownerId, workGroupId);
        if (StringUtils.isBlank(adminIds)) {
            workGroupMemberDao.removeAllAdmins(workGroupId);
            return;
        }
        List<Long> adminsIdList = workGroupMemberDao.queryAdminIds(workGroupId);

        Set<Long> oldAdminIdSet = new HashSet<Long>(adminsIdList);
        Set<Long> newAdminIdSet = new HashSet<Long>();
        for (String adminId : adminIds.split(",")) {
            newAdminIdSet.add(Long.valueOf(adminId));
        }

        Set<Long> tempSet = new HashSet<Long>();

        // 添加新管理员与老管理员的差集
        tempSet.addAll(newAdminIdSet);
        tempSet.removeAll(oldAdminIdSet);
        List<Long> idsOfAddAdminList = new ArrayList<Long>(tempSet);

        if (!idsOfAddAdminList.isEmpty()) {
            addAdmins(idsOfAddAdminList, workGroupId, ownerId);
        }

        tempSet.clear();

        // 移除老管理员与新管理员的差集
        tempSet.addAll(oldAdminIdSet);
        tempSet.removeAll(newAdminIdSet);
        List<Long> idsOfRemoveAdminList = new ArrayList<Long>(tempSet);

        if (!idsOfRemoveAdminList.isEmpty()) {
            removeAdmins(idsOfRemoveAdminList, workGroupId, ownerId);
        }
    }

    public void addAdmins(List<Long> idsOfAddAdminList, String workGroupId, Long ownerId) {
        workGroupMemberDao.addAdmins(idsOfAddAdminList, workGroupId);

        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
        String memberJsonStr = generateMemberJsonStr1(idsOfAddAdminList);
        String result = CloudMsgGroupUtil.addAdmins(workGroup.getAccid(), getCreatorAccid(workGroupId), memberJsonStr);
        checkYXResult(result);
    }

    public void removeAdmins(List<Long> idsOfRemoveAdminList, String workGroupId, Long ownerId) {
        workGroupMemberDao.removeAdmins(idsOfRemoveAdminList, workGroupId);

        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
        String memberJsonStr = generateMemberJsonStr1(idsOfRemoveAdminList);

        String result = CloudMsgGroupUtil.removeAdmins(workGroup.getAccid(), getCreatorAccid(workGroupId), memberJsonStr);
        checkYXResult(result);
    }


    // 定时清空到期的工作组
    public void deleteWorkGroupsInTime() throws Exception {
//        List<Quartz> quartzs = quartzDao.queryAllOutOfDateToDo(new Date());
//        if (quartzs.isEmpty()) {
//            return;
//        }
//        for (Quartz quartz : quartzs) {
//            String workGroupId = quartz.getArgs();
//            Long ownerId = workGroupMemberDao.queryOwnerId(workGroupId);
//            deleteWorkGroup(workGroupId, ownerId);
//            quartz.setStatus(1);
//        }

    }

    public WorkGroup getWorkGroupById(String workGroupId, Long userId) throws Exception {
        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
        if (workGroup == null) {
            throw new RuntimeException("工作组已被解散");
        }

        Map<String, Object> map = getMembers(workGroupId, 0, 1000, "", "SORT_name_ASC", "");
        if (!map.isEmpty()) {
            workGroup.setMembers((List<LandUser>) map.get("content"));
            workGroup.setMembersNum((Integer) map.get("total"));
            completeWorkGroupInfo(workGroup, userId);
        }
        return workGroup;
    }

    public WorkGroup rename(String workGroupId, Long ownerId, String newName) {
        // checkCreator(ownerId, workGroupId);
        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);
        if (workGroup == null || workGroup.getState() == 1) {
            throw new RuntimeException("工作组不存在");
        }
//        if (workGroup.getName().equals(newName)){
//            throw new RuntimeException("与原名称相同");
//        }
        workGroup.setName(newName);
        workGroupDao.save(workGroup);

        String result = CloudMsgGroupUtil.renameYxGroup(workGroup.getAccid(), getCreatorAccid(workGroupId), newName);
        checkYXResult(result);

        return workGroup;
    }


    private String getCreatorAccid(String workGroupId) {
        Long creatorId = workGroupMemberDao.queryOwnerId(workGroupId);
        if (creatorId == null) {
            throw new RuntimeException("工作组id有误");
        }
        YXUser yxUserOfCreator = yxUserDao.findById(creatorId).orElse(null);
        if (yxUserOfCreator == null) {
            throw new RuntimeException("群主无云信账号");
        }
        return yxUserOfCreator.getAccid();
    }

    public Map<String, Object> getYxMembers(String workGroupId) {
        WorkGroup workGroup = workGroupDao.findById(workGroupId).orElse(null);

        String result = CloudMsgGroupUtil.getYxGroup(workGroup.getAccid());
        Map<String, Object> map = JSON.parseObject(result);
        return map;
    }

    public Page<WorkGroup> getMyWorkGroupsTree(Long ownerId) {
        List<String> groupIds = workGroupMemberDao.queryGroupIdOfIHave(ownerId);
        Page<WorkGroup> workGroups = getWorkGroupByGroupIds(groupIds, "", "SORT_createTime_ASC", 0, 100);
        if (workGroups.getContent().isEmpty()) {
            return workGroups;
        }
        for (WorkGroup workGroup : workGroups) {
            Map<String, Object> menbersMap = getMembers(workGroup.getId(), 0, 200, "", "SORT_createTime_ASC", "");
            if (!menbersMap.isEmpty()) {
                List<LandUser> members = (List<LandUser>) menbersMap.get("content");
                workGroup.setMembers(members);
            }
        }
        return workGroups;
    }

    public List<String> getMyWorkGroupIdsByUserId(Long userId) {
        return workGroupMemberDao.queryGroupIdOfIHave(userId);
    }

    public List<WorkGroup> getMyWorkGroupsByUserId(Long userId) {
        List<String> ids = workGroupMemberDao.queryGroupIdByUserId(userId);
        List<WorkGroup> wgs = new ArrayList<>();
        if (ids != null && !ids.isEmpty()) {
            wgs = workGroupDao.queryWorkGroupByIds(ids);
        }
        return wgs;
    }

    @Transactional
    public void deleteWorkGroupNotice(String workGroupId,Long userId){
        //工作组用户id
        List<Long> userIds=workGroupMemberDao.queryMembersId(workGroupId);
        if(!userIds.isEmpty()) {
            //解散工作组 先创建topic 不用判断是否存在
            NoticeTopic noticeTopic = new NoticeTopic();
            String id = UUID.randomUUID().toString();
            noticeTopic.setId(id);
            noticeTopic.setDate(new Date());
            noticeTopic.setType("anc");
            noticeTopicRepository.save(noticeTopic);

            //创建news
            NoticeNew noticeNew=new NoticeNew();
            noticeNew.setTopicId(id);
            noticeNew.setSendUser(userId.toString());
            noticeNew.setSendDate(new Date());
            noticeNew.setTitle("工作组解散通知");
            //查询创建者信息
            //LandUser landUser=landUserDao.findById(userId).orElse(null);
            //查询工作组信息
            WorkGroup workGroup=workGroupDao.queryByID(workGroupId);
            //解散时间
            SimpleDateFormat simpleDateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            noticeNew.setContent(
                    String.format("【工作组解散通知】。%s工作组，已被群主%s解散，时间：%s",
                            workGroup.getName(),userNameService.getUserRealNameByUserId(userId.toString()),simpleDateFormat.format(new Date())));
            noticeNewRepository.save(noticeNew);

            //订阅记录表
            List<NoticeSubscribe> noticeSubscribes=new ArrayList<>();
            for (Long uId : userIds) {
                NoticeSubscribe noticeSubscribe=new NoticeSubscribe();
                noticeSubscribe.setCreateTime(new Date());
                noticeSubscribe.setTopicId(id);
                noticeSubscribe.setUserId(uId.toString());
                noticeSubscribes.add(noticeSubscribe);
            }
            noticeSubscribeRepository.saveAll(noticeSubscribes);

        }
    }
}
