package com.geoway.landteam.landcloud.service.user.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.RoleCloudQueryRel;
import com.geoway.landteam.cloudquery.repository.pub.RoleCloudQueryRelRepository;
import com.geoway.landteam.cloudquery.servface.pub.RoleCloudQueryService;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeSubscribe;
import com.geoway.landteam.customtask.repository.task.*;

import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserUpdateInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.*;
import com.geoway.landteam.landcloud.core.model.user.entity.LandRegUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppTaskBizRepository;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.LandRegUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.UserRoleInfoRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.RoleRightService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.OrganizationService;
import com.geoway.landteam.landcloud.core.service.base.ApplicationCodeService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.*;
import com.geoway.landteam.landcloud.core.service.user.*;
import com.geoway.landteam.landcloud.core.service.util.CheckUtil;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.servface.user.MIUserManageService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeNewService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
/*import com.gw.base.data.GwValidateException;*/
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.io.*;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: zhenkaining
 * @Date: 2020/6/11 11:37
 * @Description:
 */
@Service
public class MIUserManageServiceImpl implements MIUserManageService {
    private final GiLoger logger = GwLoger.getLoger(MIUserManageServiceImpl.class);

    private final String CHINA_REGION_CODE = "1";
    protected String uploadDir;
    @Value("${obsSignatureEnable:false}")
    protected boolean obsSignatureEnable;
    protected String appkey;
    @Autowired
    LandUserRepository landUserDao;

    @Autowired
    LandUserService userService;

    @Autowired
    LandRegUserService regUserService;

    @Autowired
    LandRegUserRepository landRegUserDao;

    @Autowired
    RegionService regionService;

    @Autowired
    RoleRightService roleRightService;

    @Autowired
    OrganizationService organizationService;

    /*@Autowired
    UserBizRepository userBizRepository;*/

    @Autowired
    OrganizationRepository organizationRepository;

    @Autowired
    CloudDiskOfOrgRepository cloudDiskOfOrgDao;

    @Autowired
    AppTaskBizRepository appTaskBizRepository;

    @Autowired
    RoleCloudQueryRelRepository roleCloudQueryRelRepository;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    ApplicationCodeService applicationCodeService;

    @Autowired
    UserApplicationRepository userApplicationDao;

    @Autowired
    TskTaskBizRepository tskTaskBizDao;

    @Autowired
    User2BizRepository userBiz2Dao;

    @Autowired
    UserBizSupervisionRepository userBizSupervisionDao;

    @Autowired
    UisApplicationRepository UisApplicationDao;

    @Autowired
    SysRoleInfoRepository SysRoleInfoDao;

    @Autowired
    UserRoleInfoRepository userRoleInfoDao;

    @Autowired
    RoleCloudQueryService roleCloudQueryService;

    @Autowired
    RegisterServiceImpl registerService;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;

    @Autowired
    UserAreaServiceImpl userAreaService;

    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    BizAreaRepository bizAreaRepository;

    @Autowired
    NoticeTopicRepository noticeTopicRepository;

    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;

    @Autowired
    Organization2UserRepository organization2UserRepository;

    @Autowired
    TskRightAreaRepository tskRightAreaRepository;


    @Override
    public List<ImportUserResultInfo> HomesteadImportUserBatch(String filePath, Long userId) throws IOException, InvalidFormatException {
        Workbook workbook = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        List<ImportUserResultInfo> userResultInfos = new ArrayList<>();
        try {
            File file = new File(filePath);
            File parentFile = file.getParentFile();
            if (parentFile != null && (!parentFile.exists())) {
                parentFile.mkdirs();
            }

            inputStream = new FileInputStream(file);
            workbook = WorkbookFactory.create(inputStream);
            inputStream.close();

            // 处理app作业员注册
            List<ImportUserResultInfo> appResultList = readSheet(workbook, false);
            userResultInfos.addAll(appResultList);
            // 处理web管理员注册
            List<ImportUserResultInfo> webResultList = readSheet(workbook, true);
            userResultInfos.addAll(webResultList);

            outputStream = new FileOutputStream(file);
            workbook.write(outputStream);
            outputStream.flush();
            outputStream.close();
        } catch (Exception ex) {
            throw ex;
        } finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }

        return userResultInfos;
    }

    /**
     * 读取sheet
     *
     * @param workbook
     * @param isWebManagerSheet 是否是web管理员sheet
     */
    private List<ImportUserResultInfo> readSheet(Workbook workbook, boolean isWebManagerSheet) {
        List<ImportUserResultInfo> userResultInfos = new ArrayList<>();

        // 公众用户
        SysConfig publicConfig = sysConfigService.findOne("publicConfig");
        String bizId = "";
        String unitId = "";
        if (publicConfig != null) {
            JSONObject jsonObject = JSONObject.parseObject(publicConfig.getValue());
            bizId = jsonObject.getString("zngl");
            unitId = jsonObject.getString("unit");
        }
        Sheet sheet = workbook.getSheet(isWebManagerSheet ? "web管理员注册" : "app作业员注册");
        Row row = sheet.getRow(0);
        if(row == null ){
            return userResultInfos;
        }
        int columnNum = row.getPhysicalNumberOfCells();
        int rowCount = sheet.getPhysicalNumberOfRows();
        // 创建结果列
        createImportResultColumn(workbook, sheet, columnNum);

        for (int i = 2; i < rowCount; i++) {
            ImportUserResultInfo resultInfo = new ImportUserResultInfo();
            resultInfo.setRow(i);
            row = sheet.getRow(i);
            if (row == null) {
                continue;
            }

            try {
                UserAddInfo userInfo = new UserAddInfo();
                // 设置智能管理的业务为宅基地确权业务
                userInfo.setBiz(bizId);
                userInfo.setPassword(Md5Util.calFileMd5ByByte("gtdcy123".getBytes()));
                userInfo.setCreateTime(new Date());

                JSONObject bizRole = new JSONObject();
                if (isWebManagerSheet) {
                    resultInfo = readWebRegisterRow(workbook, row, columnNum, unitId, userInfo);
                    bizRole.put(bizId, '1');
                    userInfo.setBizRoles(bizRole.toJSONString());
                } else {
                    resultInfo = readAppRegisterRow(workbook, row, columnNum, unitId, userInfo);
                    bizRole.put(bizId, '3');
                    userInfo.setBizRoles(bizRole.toJSONString());
                }
                resultInfo.setRow(i);
                if (resultInfo.getState() == 2) {
                    userResultInfos.add(resultInfo);
                    continue;
                }
                // 表示已存在用户 只增加作业区域
                if (resultInfo.getState() == 3) {

                    String info = "";
                    if(updateUserArea(userInfo)){
                        if(isWebManagerSheet){
                            info = "用户已存在，为此用户赋予宅基地作业区管理员权限";
                        }else{
                            info = "用户已存在，为此用户赋予宅基地作业区作业员权限";
                        }
                    }else{
                        info = "手机号已注册，请直接登录";
                    }
                    // 操作完后改为1
                    resultInfo.setState(1);
                    userResultInfos.add(resultInfo);
                    writeSuccessInfo(workbook, row, columnNum,info);
                    continue;
                }
                addNewUser(userInfo);
                resultInfo.setState(1);
                writeSuccessInfo(workbook, row, columnNum);


                userResultInfos.add(resultInfo);
            } catch (Exception e) {
                e.printStackTrace();
                logger.error(e);
                resultInfo.setState(2);
                resultInfo.setErrorInfo(e.getMessage());
                writeErrorInfo(workbook, row, columnNum, e.getMessage());
                userResultInfos.add(resultInfo);
                continue;
            }
        }

        return userResultInfos;
    }

    /**
     * 读取作业员行
     *
     * @param wb
     * @param row
     * @param colNumber
     * @param deptId    单位id
     * @param userInfo
     * @return
     */
    private ImportUserResultInfo readAppRegisterRow(Workbook wb, Row row, int colNumber, String deptId, UserAddInfo userInfo) {
        ImportUserResultInfo resultInfo = new ImportUserResultInfo();
        String nameValue = findCellValue(row.getCell(0));
        String depValue = findCellValue(row.getCell(1));
        String phoneValue = findCellValue(row.getCell(2));
        String regionCodeValue = findCellValue(row.getCell(3));
        String bizRegionCodeValue = findCellValue(row.getCell(4));

        if (StringUtils.isBlank(nameValue)
                && StringUtils.isBlank(depValue)
                && StringUtils.isBlank(phoneValue)
                && StringUtils.isBlank(regionCodeValue)
                && StringUtils.isBlank(bizRegionCodeValue)) {
            resultInfo.setInvalidRow(true);
            resultInfo.setState(2);
            resultInfo.setErrorInfo("必填项为空，此记录无效");
            writeErrorInfo(wb, row, colNumber, "必填项为空，此记录无效");
            return resultInfo;
        }
        if (StringUtils.isBlank(nameValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("姓名不能为空");
            writeErrorInfo(wb, row, colNumber, "姓名不能为空");
            return resultInfo;
        }
        // 姓名
        userInfo.setRname(nameValue);

        List<LandUser> userOfName = landUserDao.queryUserByName(nameValue);
        if (!userOfName.isEmpty()) {
            nameValue = nameValue + String.valueOf(userOfName.size() + 1);
        }
        userInfo.setUsername(nameValue);

        if (StringUtils.isBlank(phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("移动电话不能为空");
            writeErrorInfo(wb, row, colNumber, "移动电话不能为空");
            return resultInfo;
        }
        if (!CheckUtil.isMobile(phoneValue)) {
            //手机号码格式不正确
            resultInfo.setState(2);
            resultInfo.setErrorInfo("移动电话格式不正确");
            writeErrorInfo(wb, row, colNumber, "移动电话格式不正确");
            return resultInfo;
        }


        LandRegUser user1 = landRegUserDao.queryOneByPhoneNum(phoneValue);
        LandUser user2 = userService.queryAppUserByPhone(phoneValue);
        if(user2 != null){
            // 已存在用户 增加作业区权限
            resultInfo.setState(3);
            userInfo.setId(user2.getId()+"");
        }
        if(user1 != null && user2 == null){
            // 已存在待审核用户 增加授权 不跳过
            resultInfo.setState(2);
            resultInfo.setErrorInfo("该手机号已被注册,待审核中");
            writeErrorInfo(wb, row, colNumber, "该手机号已被注册,待审核中");
            return resultInfo;
        }
        // 手机号
        userInfo.setPhone(phoneValue);

        if (StringUtils.isBlank(regionCodeValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("县级区划代码不能为空");
            writeErrorInfo(wb, row, colNumber, "县级区划代码不能为空");
            return resultInfo;
        }
        if (StringUtils.isBlank(depValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("单位不能为空");
            writeErrorInfo(wb, row, colNumber, "单位不能为空");
            return resultInfo;
        }
        userInfo.setDepname(depValue);

        if (StringUtils.isBlank(bizRegionCodeValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("乡（镇）村代码不能为空");
            writeErrorInfo(wb, row, colNumber, "乡（镇）村代码不能为空");
            return resultInfo;
        }


        if (CHINA_REGION_CODE.equalsIgnoreCase(regionCodeValue)) {
            userInfo.setRegionCode(regionCodeValue);
            userInfo.setCloudArea(regionCodeValue);
        } else {
            Region region = regionService.getRegion(regionCodeValue.trim());
            if (region == null) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("行政区划代码【"+regionCodeValue+"】输入错误或不在系统中");
                writeErrorInfo(wb, row, colNumber, "行政区划代码【"+regionCodeValue+"】输入错误或不在系统中");
                return resultInfo;
            } else {
                if (region.getLevel() != 3) {
                    resultInfo.setState(2);
                    resultInfo.setErrorInfo("县级区划代码需填写到县级");
                    writeErrorInfo(wb, row, colNumber, "县级区划代码需填写到县级");
                    return resultInfo;
                }
                userInfo.setRegionCode(region.getCode());
                // 设置云查询区域
                userInfo.setCloudArea(region.getCode());
            }
        }


        String[] workAreaCodes = bizRegionCodeValue.split("/");
        if (workAreaCodes.length > 0) {
            List<String> errorWorkAreaCodes = new ArrayList<>();
            for (String workAreaCode : workAreaCodes) {
                String code = regionCodeValue.trim() + workAreaCode.trim();
                RegionVillage region = regionService.findRegionsVillageByXzqdm(code);
                if (region == null) {
                   errorWorkAreaCodes.add(workAreaCode);
                }
            }
            if (errorWorkAreaCodes.size()>0) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("乡（镇）村代码 【" + StringUtils.join(workAreaCodes, ',') + " 】输入错误或不在系统中");
                writeErrorInfo(wb, row, colNumber, "乡（镇）村代码 【" + StringUtils.join(workAreaCodes, ',') + " 】输入错误或不在系统中");
                return resultInfo;
            }
        } else {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("乡（镇）村代码不能为空");
            writeErrorInfo(wb, row, colNumber, "乡（镇）村代码不能为空");
            return resultInfo;
        }
        bizRegionCodeValue = StringUtils.join(Arrays.asList(workAreaCodes).stream().map(r->regionCodeValue.trim() + r.trim()).collect(Collectors.toList()), ",");
        JSONObject bizJsonObj = new JSONObject();
        bizJsonObj.put(userInfo.getBiz(), bizRegionCodeValue);
        userInfo.setBizRegion(bizJsonObj.toJSONString());

        if (StringUtils.isNotBlank(deptId)) {
            // 单位
            userInfo.setDepNo(deptId);
        }
        // 公众用户角色
        String roleId = "10007";
        userInfo.setRoleIds(roleId);
        // 公众用户云查询角色
        String cloudQueryId = "1000";
        userInfo.setCloudQueryConfig(cloudQueryId);
        return resultInfo;
    }

    /**
     * 读取任务管理员行
     *
     * @param wb
     * @param row
     * @param colNumber
     * @param deptId    单位id
     * @param userInfo
     * @return
     */
    private ImportUserResultInfo readWebRegisterRow(Workbook wb, Row row, int colNumber, String deptId, UserAddInfo
            userInfo) {
        ImportUserResultInfo resultInfo = new ImportUserResultInfo();
        String nameValue = findCellValue(row.getCell(0));
        String deptName = findCellValue(row.getCell(1));
        String phoneValue = findCellValue(row.getCell(2));
        String regionCodeValue = findCellValue(row.getCell(3));
        String bizRegionCodeValue = findCellValue(row.getCell(4));


        if (StringUtils.isBlank(nameValue)
                && StringUtils.isBlank(phoneValue)
                && StringUtils.isBlank(regionCodeValue)
                && StringUtils.isBlank(deptName)) {
            resultInfo.setInvalidRow(true);
            resultInfo.setState(2);
            resultInfo.setErrorInfo("必填项为空，此记录无效");
            writeErrorInfo(wb, row, colNumber, "必填项为空，此记录无效");
            return resultInfo;
        }
        if (StringUtils.isBlank(nameValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("姓名不能为空");
            writeErrorInfo(wb, row, colNumber, "姓名不能为空");
            return resultInfo;
        }
        // 姓名
        userInfo.setRname(nameValue);
        List<LandUser> userOfName = landUserDao.queryUserByName(nameValue);
        if (!userOfName.isEmpty()) {
            nameValue = nameValue + userOfName.size() + 1;
        }
        userInfo.setUsername(nameValue);

        if (StringUtils.isBlank(phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("移动电话不能为空");
            writeErrorInfo(wb, row, colNumber, "移动电话不能为空");
            return resultInfo;
        }
        if (!CheckUtil.isMobile(phoneValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("移动电话格式不正确");
            writeErrorInfo(wb, row, colNumber, "移动电话格式不正确");
            return resultInfo;
        }
        LandRegUser user1 = landRegUserDao.queryOneByPhoneNum(phoneValue);
        LandUser user2 = userService.queryAppUserByPhone(phoneValue);
        if(user2 != null){
            // 已存在用户 增加作业区管理员权限
            resultInfo.setState(3);
            userInfo.setId(user2.getId()+"");
        }
        if(user1 != null && user2 == null){
            // 已存在待审核用户 增加授权 不跳过
            resultInfo.setState(2);
            resultInfo.setErrorInfo("该手机号已被注册,待审核中");
            writeErrorInfo(wb, row, colNumber, "该手机号已被注册,待审核中");
            return resultInfo;
        }
        userInfo.setPhone(phoneValue);

        if (StringUtils.isBlank(regionCodeValue)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("县级行政区代码不能为空");
            writeErrorInfo(wb, row, colNumber, "县级行政区代码不能为空");
            return resultInfo;
        }

        if (CHINA_REGION_CODE.equalsIgnoreCase(regionCodeValue)) {
            userInfo.setRegionCode(regionCodeValue);
            userInfo.setCloudArea(regionCodeValue);
        } else {
            Region region = regionService.getRegion(regionCodeValue);
            if (region == null) {
                resultInfo.setState(2);
                resultInfo.setErrorInfo("行政区划代码【"+regionCodeValue+"】输入错误或不在系统中");
                writeErrorInfo(wb, row, colNumber, "行政区划代码【"+regionCodeValue+"】输入错误或不在系统中");
                return resultInfo;
            } else {
                userInfo.setRegionCode(region.getCode());
                // 设置云查询区域
                userInfo.setCloudArea(region.getCode());
            }
        }

        // 合法的作业区代码
        List<String> zyqs = Arrays.asList(bizRegionCodeValue.split("/")).stream().filter(r -> StringUtils.isNotBlank(r)).map(r -> regionCodeValue + r).collect(Collectors.toList());
        if(!zyqs.isEmpty()){
            bizRegionCodeValue = StringUtils.join(zyqs, ",");
            JSONObject bizJsonObj = new JSONObject();
            bizJsonObj.put(userInfo.getBiz(), bizRegionCodeValue);
            userInfo.setBizRegion(bizJsonObj.toJSONString());
        }
        if (StringUtils.isBlank(deptName)) {
            resultInfo.setState(2);
            resultInfo.setErrorInfo("所属单位不能为空");
            writeErrorInfo(wb, row, colNumber, "所属单位不能为空");
            return resultInfo;
        }
        // 单位是否存在于系统内
        boolean existedDept = false;
        // 单位
        List<Organization> curOrg = organizationRepository.queryOneByName(deptName);
        if (curOrg.size() > 0) {
            existedDept = true;
            userInfo.setDepNo(curOrg.get(0).getId());
        }

        if (existedDept) {
            if (CHINA_REGION_CODE.equalsIgnoreCase(regionCodeValue)) {
                // 国家级管理员
                userInfo.setRoleIds("10012");
                // 国家级云查询角色
                userInfo.setCloudQueryConfig("1002");
            } else {

                if (userInfo.getRegionCode().endsWith("0000")) {
                    // 省级管理员
                    userInfo.setRoleIds("10003");
                    // 省级云查询角色
                    userInfo.setCloudQueryConfig("1001");
                } else if (userInfo.getRegionCode().endsWith("00")) {
                    // 市级管理员
                    userInfo.setRoleIds("10018");
                    // 市级云查询角色
                    userInfo.setCloudQueryConfig("1005");
                } else {
                    // 县级管理员
                    userInfo.setRoleIds("10019");
                    // 县级云查询角色
                    userInfo.setCloudQueryConfig("1006");
                }
            }
        } else {
            // 单位在系统中不存在，则注册到公众用户里面
            userInfo.setDepNo(deptId);
            userInfo.setDepname(deptName);
            // 公众用户角色
            String roleId = "10007";
            userInfo.setRoleIds(roleId);
            // 公众用户云查询角色
            String cloudQueryId = "1000";
            userInfo.setCloudQueryConfig(cloudQueryId);
        }

        return resultInfo;
    }


    private String findCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            org.apache.poi.ss.usermodel.CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: //文本
                    cellValue = cell.getStringCellValue();
                    break;
                case NUMERIC: //数字、日期
                    if (DateUtil.isCellDateFormatted(cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue()); //日期型
                    } else {
                        cellValue = String.valueOf((long) cell.getNumericCellValue()); //数字
                    }
                    break;
                case BOOLEAN: //布尔型
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                case BLANK: //空白
                    cellValue = cell.getStringCellValue();
                    break;
                case ERROR: //错误
                    cellValue = "错误";
                    break;
                case FORMULA: //公式
                    cellValue = "错误";
                    break;
                default:
                    cellValue = "错误";
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue.trim();
    }

    private void writeSuccessInfo(Workbook workbook, Row row, int colNumber) {
        if (workbook != null) {
            if (row != null && colNumber > -1) {
                Cell cell = row.createCell(colNumber);
                if (cell != null) {
                    cell.setCellValue("新增用户成功");
                    cell.setCellStyle(createSuceessinfocellstyle(workbook));
                }
            }
        }
    }
    private void writeSuccessInfo(Workbook workbook, Row row, int colNumber, String info) {
        if (workbook != null) {
            if (row != null && colNumber > -1) {
                Cell cell = row.createCell(colNumber);
                if (cell != null) {
                    cell.setCellValue(info);
                    cell.setCellStyle(createSuceessinfocellstyle(workbook));
                }
            }
        }
    }
    private void writeErrorInfo(Workbook workbook, Row row, int colNumber, String errorInfo) {
        if (workbook != null) {
            if (row != null && colNumber > -1 && StringUtils.isNotBlank(errorInfo)) {
                Cell cell = row.createCell(colNumber);
                if (cell != null) {
                    cell.setCellValue("创建用户失败，" + errorInfo);
                    cell.setCellStyle(createErrorInfoCellStyle(workbook));
                }
            }
        }
    }

    private void createImportResultColumn(Workbook workbook, Sheet sheet, int colNumber) {
        if (workbook != null && sheet != null) {
            Row row = sheet.getRow(1);
            Cell cell = row.createCell(colNumber);
            cell.setCellValue("结果");
            cell.setCellStyle(creatersultecolumnheadercellstyle(workbook));
        }

    }

    private XSSFCellStyle createCommonCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = null;
        if (wb != null) {
            cellStyle = (XSSFCellStyle) wb.createCellStyle();
            if (cellStyle != null) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER); // 居中
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中

                cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
                cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
                cellStyle.setBorderTop(BorderStyle.THIN);//上边框
                cellStyle.setBorderRight(BorderStyle.THIN);//右边框

                XSSFFont font = (XSSFFont) wb.createFont();
                font.setFontName("仿宋_GB2312");
                font.setBold(true);//粗体显示
                font.setFontHeightInPoints((short) 11);  //字体大小
                cellStyle.setFont(font);//选择需要用到的字体格式

                cellStyle.setWrapText(true);//设置自动换行
            }
        }
        return cellStyle;
    }

    private CellStyle creatersultecolumnheadercellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = createCommonCellStyle(wb);
        if (cellStyle != null) {
            cellStyle.setFillForegroundColor((short) 13);// 设置背景色  
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.getFont().setFontHeightInPoints((short) 12);  //字体大小
        }

        return cellStyle;
    }

    /**
     * 错误信息单元格格式
     *
     * @param wb
     * @return
     */
    private CellStyle createErrorInfoCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = createCommonCellStyle(wb);
        if (cellStyle != null) {
           /* cellStyle.getFont().setColor(new XSSFColor(new java.awt.Color(255, 57, 68)));*/
        }
        return cellStyle;
    }

    private CellStyle createSuceessinfocellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = createCommonCellStyle(wb);
        if (cellStyle != null) {
       /*     cellStyle.getFont().setColor(new XSSFColor(new java.awt.Color(255, 255, 255)));*/
        }
        return cellStyle;
    }
    private Boolean updateUserArea(UserAddInfo userInfo){

        if(StringUtils.isNotBlank(userInfo.getId())){
            Long userId = Long.valueOf(userInfo.getId());
            List<User2Biz> bizIdByUserId = userBiz2Dao.getByBizidAndUserid(userInfo.getBiz(),userId);
            List<String> collect = bizIdByUserId.stream().map(r -> r.getRole().toString()).collect(Collectors.toList());
            // 已存在用户如果没有此业务则加入业务的权限
            if (StringUtils.isNotBlank(userInfo.getBizRoles())) {
                JSONObject bizRoleJson = JSONObject.parseObject(userInfo.getBizRoles());

                List<User2Biz> list = new ArrayList<>();

                for (String key : bizRoleJson.keySet()) {
                    // 过滤已存在的角色
                    Arrays.asList(bizRoleJson.getString(key).split(","))
                            .stream().filter(r -> !collect.contains(r))
                            .forEach(r -> list.add(new User2Biz(UUID.randomUUID().toString(), userId, key, Integer.parseInt(r))));
                }
                if(!list.isEmpty()){
                    userBiz2Dao.saveAll(list);
                }
            }

            return appendBizArea(userInfo.getBizRegion(),userInfo.getId());
        }
        return false;
    }
    private void addNewUser(UserAddInfo userInfo) throws Exception {

        // 保存用户业务信息
        LandUser landUser = userService.addUser(userInfo);

        // 写入默认业务
        if (StringUtils.isNotBlank(userInfo.getBizRoles())) {
            JSONObject bizRoleJson = JSONObject.parseObject(userInfo.getBizRoles());
            List<User2Biz> list = new ArrayList<>();
            for (String key : bizRoleJson.keySet()) {
                Arrays.asList(bizRoleJson.getString(key).split(","))
                        .stream()
                        .forEach(r -> list.add(new User2Biz(UUID.randomUUID().toString(), landUser.getId(), key, Integer.parseInt(r))));
            }
            userBiz2Dao.saveAll(list);

            // 绑定任务消息
            List<TaskNoticeSubscribe> noticeSubscribes = new ArrayList<>();
            for (int i=0;i<list.size();i++){
                TaskNoticeSubscribe subscribe = new TaskNoticeSubscribe();
                subscribe.setId(UUID.randomUUID().toString());
                subscribe.setUserid(landUser.getId().toString());
                subscribe.setTopic("tsk|"+list.get(i).getBizid());
                subscribe.setDate(new Date());

                noticeSubscribes.add(subscribe);
            }

            mTaskNoticeNewService.addSubscribe(noticeSubscribes);
        }

        //保存在线业务种类
        List<String> ywCodes = new ArrayList<String>();
        String zxyw = userInfo.getZxyw();
        if (StringUtils.isNotBlank(zxyw)) {
            String sql = "";
            String[] split = zxyw.split(",");
            if (zxyw.indexOf(";") > -1) {
                split = zxyw.split(";");
            }


            List<UserBizSupervision> userAppLists = new ArrayList<UserBizSupervision>();
            for (int i = 0; i < split.length; i++) {
              /*  if (split[i].equals("6")) {
                    UserBiz lsUbiz = new UserBiz();
                    lsUbiz.setBizId("6");
                    lsUbiz.setUserId(landUser.getId());
                    lsUbiz.setId(UUID.randomUUID().toString());
                    userBizRepository.save(lsUbiz);
                    continue;
                }*/

                ywCodes.add(split[i]);
                String uid = UUID.randomUUID().toString();
                UserBizSupervision userApp = new UserBizSupervision();
                userApp.setId(uid);
                userApp.setTaskcode(split[i]);
                userApp.setUserid(landUser.getId());
                userAppLists.add(userApp);
            }
            userBizSupervisionDao.saveAll(userAppLists);
        }
        appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
        if (ywCodes.size() > 0) {
            List<String> keys = applicationCodeService.getKeyByCode(ywCodes);
            if (keys.indexOf(appkey) < 0) {
                keys.add(appkey);
            }

            //通过key获取uis_application中的id
            List<String> appIds = UisApplicationDao.getIdByAppKey(keys);

            List<UserApplication> userAppLists = new ArrayList<UserApplication>();
            for (String key : appIds) {
                UserApplication userApp = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp.setId(uid);
                userApp.setApplicationId(key);
                userApp.setUserId(landUser.getId());
                userAppLists.add(userApp);
            }

            if (userAppLists.size() > 0) {
                userApplicationDao.saveAll(userAppLists);
            }
        } else {
            //单独写关联表
            List<String> keys = new ArrayList<String>();
            keys.add(appkey);
            List<String> appIds = UisApplicationDao.getIdByAppKey(keys);

            for (String key : appIds) {
                UserApplication userApp = new UserApplication();
                String uid = UUID.randomUUID().toString();
                userApp.setId(uid);
                userApp.setApplicationId(key);
                userApp.setUserId(landUser.getId());
                userApplicationDao.save(userApp);
            }
        }


        // 更新云查询配置
        String config = userInfo.getCloudQueryConfig();
        if (StringUtils.isNotBlank(config)) {
            String[] strs = config.split(",");
            List<RoleCloudQueryRel> list = new ArrayList<>();
            for (int i = 0; i < strs.length; i++) {
                RoleCloudQueryRel ucc = new RoleCloudQueryRel();
                ucc.setUid(landUser.getId().toString());
                ucc.setCid(strs[i].trim());
                list.add(ucc);
            }
            roleCloudQueryRelRepository.saveAll(list);
        }

        // 国家级用户创建个人云盘
        if (userInfo.getRoleIds().contains("10012")) {
            List<BigDecimal> list = new ArrayList<>();
            list.add(new BigDecimal(landUser.getId()));
            //cloudDiskUtilService.createByUserIdList(list);
        }

        //  是管理员且无单位云盘, 则创建单位云盘
        if (userInfo.getRoleIds().contains("10020")) {
            Organization organization = organizationRepository.findById(userInfo.getDepNo()).orElse(null);
            if (organization == null) {
                throw new RuntimeException("单位不存在");
            }
            CloudDiskOfOrg cloudDiskOfOrg = cloudDiskOfOrgDao.findById(organization.getId()).orElse(null);
            if (cloudDiskOfOrg == null) {
                List<String> orgIdList = new ArrayList<>();
                orgIdList.add(organization.getId());
                //cloudDiskUtilService.createByOrgIdList(orgIdList, landUser.getId());
            }
        }

        // 更新任务作业区
        addBizArea(userInfo.getBizRegion(), landUser.getId().toString());
    }

    /**
     * 追加用户作业区
     * @param bizRegion
     * @param userId
     */
    private Boolean appendBizArea(String bizRegion, String userId){
        // 追加任务作业区
        Boolean flag = false;
        if (StringUtils.isNotBlank(bizRegion)) {
            JSONObject obj = JSONObject.parseObject(bizRegion);

            for (String key : obj.keySet()) {
                flag = flag | tskTaskBizService.appendRightArea(key, userId, obj.getString(key));
            }
        }
        return flag;
    }
    private void addBizArea(String bizRegion, String userId) {
        // 更新任务作业区
        if (StringUtils.isNotBlank(bizRegion)) {
            JSONObject obj = JSONObject.parseObject(bizRegion);
            for (String key : obj.keySet()) {
                tskTaskBizService.changeRightArea(key, userId, obj.getString(key));
/*                // 先删除
                tskTaskBizService.deleteRightAreaByTaskId(key, userId);

                // 再保存
                String areaStr = obj.getString(key);
                if (StringUtils.isNotBlank(areaStr)) {
                    String[] arr = areaStr.split(",");
                    List<String> areas = Arrays.asList(arr);
                    tskTaskBizService.saveRightAreas(areas, key, userId);
                }*/
            }
        }
    }

    /**
     * 用于2.0更新业务
     * @param userInfo
     * @param currentUserid
     */

    @Transactional
    @Override
    public void modifyUserBiz(UserUpdateInfo userInfo, Long currentUserid){

       String roleIds = userInfo.getRoleIds();
        // 更新业务
        // 先获取当前用户的权限，再将编辑用户的与当前用户权限一样的删除掉，然后再给编辑用户赋值
        List<String> bizIdByUserId = userBiz2Dao.getBizIdByUserId(currentUserid);
        // 获取当前用户的业务范围
        List<String> userBizs = userBiz2Dao.getBizIdByUserId(userInfo.getUserId());
        // 获取这个用户在当前用户拥有的业务范围内的业务
        if (userBizs.size() > 0) {
            userBizs = userBizs.stream().filter(biz -> bizIdByUserId.contains(biz)).collect(Collectors.toList());
        }

        Long userid = userInfo.getUserId();
        String biz = userInfo.getBiz();
        //userBiz2Dao.deleteByUserId(userid);
        List<String> delList = new ArrayList<>();
        if (StringUtils.isNotBlank(biz)) {
            // 查找被去掉的权限和新增的权限
            List<String> arrays = Arrays.asList(biz.split(";"));
            // 前台传来的是 当前选择的 不包含其他业务已经具有的权限
            for (int i = 0; i < userBizs.size(); i++) {
                // 已有的业务 不在 选中的业务范围的删除
                if (!arrays.contains(userBizs.get(i))) {
                    delList.add(userBizs.get(i));
                }
            }
            if (delList.size() > 0) {
                userBiz2Dao.deleteByBizidAndUserIds(delList, userid);
            }

            List<String> addList = new ArrayList<>();
            for (int i = 0; i < arrays.size(); i++) {
                // 选中的业务不在 限定范围内 并且不在当前已有的范围内 就新增
                if (bizIdByUserId.contains(arrays.get(i)) && !userBizs.contains(arrays.get(i))) {
                    addList.add(arrays.get(i));
                }
            }
            List<User2Biz> list = new ArrayList<>();
            for (int i = 0; i < addList.size(); i++) {
                User2Biz userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(userid);
                userBiz.setRole(3);// 默认给业务员
                userBiz.setBizid(addList.get(i));
                list.add(userBiz);
            }
            // 管理员/联络员 增加业务的管理角色
            if(roleIds.contains("10020") || roleIds.contains("10022")){
                for (int i = 0; i < addList.size(); i++) {
                    User2Biz userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(1);// 任务管理员角色
                    userBiz.setBizid(addList.get(i));
                    list.add(userBiz);
                }
            }

            boolean isXian = StringUtils.isNotBlank(userInfo.getRegionCode())  && userInfo.getRegionCode().length() == 6 && Integer.valueOf(new StringBuilder(userInfo.getRegionCode()).reverse().toString()).toString().length() == 6;

            // 县级用户 且 非管理员则赋予作业区
            if(isXian && !(roleIds.contains("10020") || roleIds.contains("10022"))){

                if (addList.size() > 0) {
                    List<TskTaskBiz> filterBizs = tskTaskBizDao.findByIds(addList);
                    // 增加作业区
                    List<TskRightArea>  tskRightAreas = filterBizs.stream()
                            .filter(tskTaskBiz -> tskTaskBiz.getGranularity() == 3)
                            .map(tskTaskBiz -> new TskRightArea(userInfo.getRegionCode(), tskTaskBiz.getId(), userInfo.getUserId().toString()))
                            .collect(Collectors.toList());
                    for (TskRightArea tskRightArea : tskRightAreas) {
                        tskTaskBizService.saveRightArea(tskRightArea,userid.toString());
                    }
                }
            }

            if (delList.size() > 0) {
                // 删除的业务 需要删除作业区
                for (String s : delList) {
                    tskTaskBizService.deleteRightAreaByTaskId(s,userInfo.getUserId().toString());
                }
            }
            userBiz2Dao.saveAll(list);
        } else {
            delList = userBizs;
            // 为空，即为取消所有业务授权
            if (delList.size() > 0) {
                userBiz2Dao.deleteByBizidAndUserIds(delList, userid);
            }
        }
    }

    @Transactional
    @Override
    public void updateUserBiz(UserUpdateInfo userInfo){
       String roleIds = userInfo.getRoleIds();
        Long userid = userInfo.getUserId();
        String biz = userInfo.getBiz();
        //删除该用户对应分组下面的任务权限
        userBiz2Dao.deleteByUserIdLeftTskTaskBiz(userid);
        if (StringUtils.isNotBlank(biz) && !"".equalsIgnoreCase(biz)) {
            // 查找被去掉的权限和新增的权限
            List<String> arrays = Arrays.asList(biz.split(","));
            List<User2Biz> list = new ArrayList<>();
            for (int i = 0; i < arrays.size(); i++) {
                User2Biz userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(userid);
                userBiz.setRole(3);// 默认给业务员
                userBiz.setBizid(arrays.get(i));
                list.add(userBiz);
            }
            // 管理员/联络员 增加业务的管理角色
            if (roleIds.contains("10020") || roleIds.contains("10022")) {
                for (int i = 0; i < arrays.size(); i++) {
                    User2Biz userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(1);// 任务管理员角色
                    userBiz.setBizid(arrays.get(i));
                    list.add(userBiz);
                }
            }
            userBiz2Dao.saveAll(list);
        }
    }
    @Override
    @Transactional
    public void addUserBiz(UserAddInfo userInfo){

        if (StringUtils.isNotBlank(userInfo.getBiz())) {
            Long userid = Long.valueOf(userInfo.getId());
            String[] split = null;
            if (userInfo.getBiz().indexOf(",") != -1) {
                split = userInfo.getBiz().split(",");
            } else {
                split = userInfo.getBiz().split(";");
            }
            List<User2Biz> list = new ArrayList<>();
            for (int i = 0; i < split.length; i++) {
                User2Biz userBiz = new User2Biz();
                userBiz.setId(UUID.randomUUID().toString());
                userBiz.setUserid(Long.valueOf(userInfo.getId()));
                userBiz.setBizid(split[i]);
                //默认用户每日任务权限为作业员权限，3表示作业员
                userBiz.setRole(3);
                list.add(userBiz);
            }
            // 管理员/联络员 增加业务的管理角色
            String roleIds = userInfo.getRoleIds();
            if(roleIds.contains("10020") || roleIds.contains("10022")){
                //新版本消息通知
                //管理员 添加订阅记录
                saveNoticeTopicAndNoticeSub(userInfo.getRegionCode(),userInfo.getId(),userInfo.getBiz(),1);

                for (int i = 0; i < split.length; i++) {
                    User2Biz userBiz = new User2Biz();
                    userBiz.setId(UUID.randomUUID().toString());
                    userBiz.setUserid(userid);
                    userBiz.setRole(1);// 任务管理员角色
                    userBiz.setBizid(split[i]);
                    list.add(userBiz);
                }
            }
            boolean isXian = StringUtils.isNotBlank(userInfo.getRegionCode())  && userInfo.getRegionCode().length() == 6 && Integer.valueOf(new StringBuilder(userInfo.getRegionCode()).reverse().toString()).toString().length() == 6;

            // 县级用户 且 非管理员则赋予作业区
            if(isXian && !(roleIds.contains("10020") || roleIds.contains("10022"))){

                if (split.length > 0) {
                    List<TskTaskBiz> filterBizs = tskTaskBizDao.findByIds(Arrays.asList(split));
                    // 增加作业区
                    List<TskRightArea>  tskRightAreas = filterBizs.stream()
                            .filter(tskTaskBiz -> tskTaskBiz.getGranularity() == 3)
                            .map(tskTaskBiz -> new TskRightArea(userInfo.getRegionCode(), tskTaskBiz.getId(), userid.toString()))
                            .collect(Collectors.toList());
                    for (TskRightArea tskRightArea : tskRightAreas) {
                        tskTaskBizService.saveRightArea(tskRightArea,userid.toString());
                    }
                }
            }else{
                //默认赋予用户所属单位作业区
                if (userInfo.getOptUserid() != null) {
                    //查询用户单位
                    String orgId = organization2UserRepository.findOrgIdByUserId(Long.valueOf(userInfo.getOptUserid()));
                    //查询单位政区
                    Organization one = organizationRepository.findById(orgId).orElse(null);
                    String regionCode = one.getRegionCode();
                    List<TskRightArea> rightAreas = new ArrayList<>();
                    for(int i=0;i<split.length;i++){
                        TskRightArea tskRightArea = new TskRightArea();
                        tskRightArea.setUserId(userInfo.getId());
                        tskRightArea.setXzqdm(regionCode);
                        tskRightArea.setTaskId(split[i]);
                        tskRightArea.setId(UUID.randomUUID().toString());
                        rightAreas.add(tskRightArea);
                    }
                    tskRightAreaRepository.saveAll(rightAreas);
                }
            }
            userBiz2Dao.saveAll(list);
        }
    }

    @Override
    public Map<String,Object> getRoleByUseridAndBizid(Long userId, String bizId) {
        Map map=new HashMap();
        boolean cjz=false;
        boolean gly=false;
        boolean shy=false;
        boolean zyy=false;
        boolean fhy=false;
        String region=null;
        List<String> workRegion=null;
        List<User2Biz> userBiz2s = userBiz2Dao.getByBizidAndUserid(bizId,userId);
        if(!userBiz2s.isEmpty()){
            List<Integer> roles=userBiz2s.stream().map(r->r.getRole()).collect(Collectors.toList());
            if(roles.indexOf(0)>-1){
                cjz=true;
            }
            if(roles.indexOf(1)>-1){
                gly=true;
                region = userAreaService.getUserRegionCode(userId);
            }
            if(roles.indexOf(2)>-1){
               shy=true;
            }
            if(roles.indexOf(3)>-1){
                zyy=true;
                workRegion = tskRightAreaRepository.findByTaskIdAndUserId(bizId, userId.toString()).stream().map(r -> r.getXzqdm()).collect(Collectors.toList());
            }
            if(roles.indexOf(4)>-1){
                fhy=true;
            }
        }
        List<BizArea> bizArea = bizAreaRepository.findByBizId(bizId).stream().distinct().collect(Collectors.toList());
        map.put("cjz",cjz);
        map.put("gly",gly);
        map.put("shy",shy);
        map.put("zyy",zyy);
        map.put("fhy",fhy);
        map.put("region",region);
        map.put("workRegion",workRegion);
        map.put("bizArea",bizArea);
        return map;
    }

    /**
     * 管理员或联络员情况给用户绑定消息通知
     * @param
     */
    @Transactional
    @Override
    public void saveNoticeTopicAndNoticeSub(String region,String userId,String bizS,Integer role) {
        Integer userRole=null;
        if(role==3){
            userRole=4;
        }else if(role==4){
            userRole=8;
        }else{
            userRole=role;
        }
        //topic列表
        List<NoticeTopic> noticeTopics=new ArrayList<>();
        //政区列表
        List<String> regions=new ArrayList<>();
        regions=getRegionList(region);
        //subscribe列表
        List<NoticeSubscribe> noticeSubscribes=new ArrayList<>();

        //转为biz数组
        String[] bizs=bizS.split(",");
        for (int i = 0; i < bizs.length; i++) {
            TskTaskBiz tskTaskBiz=tskTaskBizService.findByTaskId(bizs[i]);
            if(tskTaskBiz!=null){
                for (String tempRegion : regions) {
                    List<NoticeTopic> tempNoticeTopics=noticeTopicRepository.queryNoticeTopicByBizidAndRegionAndRoleAndType(bizs[i],tempRegion,userRole,"tsk");
                    NoticeTopic noticeTopic = null;
                    if(!tempNoticeTopics.isEmpty()){
                        noticeTopic = tempNoticeTopics.get(0);
                    }
                    String topicId=null;
                    //存在该任务的topic 则只需要创建subscribe
                    if(noticeTopic!=null){
                        topicId=noticeTopic.getId();
                    }else{
                        topicId=UUID.randomUUID().toString();
                        NoticeTopic tempTopic=new NoticeTopic();
                        tempTopic.setType("tsk");
                        tempTopic.setRole(userRole);
                        tempTopic.setId(topicId);
                        setRegionDetail(tempTopic,tempRegion);
                        tempTopic.setDate(new Date());
                        tempTopic.setBizid(bizs[i]);
                        noticeTopics.add(tempTopic);
                    }
                    NoticeSubscribe noticeSubscribe=new NoticeSubscribe();
                    noticeSubscribe.setUserId(userId);
                    noticeSubscribe.setTopicId(topicId);
                    noticeSubscribe.setCreateTime(new Date());
                    noticeSubscribes.add(noticeSubscribe);
                }
            }
        }
        noticeSubscribeRepository.saveAll(noticeSubscribes);
        noticeTopicRepository.saveAll(noticeTopics);
    }

    @Override
    public List<String> getRegionList(String region) {
        List<String> regions=new ArrayList<>();
        if(region.length()>=6){
            regions.add(region.substring(0,2)+"0000");
            regions.add(region.substring(0,4)+"00");
            regions.add(region.substring(0,6));
        }
        if(region.length()>=9){
            regions.add(region.substring(0,9));
        }
        if(region.length()>=12){
            regions.add(region);
        }
        if(region.equals("1")){
            regions.add(region);
        }
        return regions.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public NoticeTopic setRegionDetail(NoticeTopic noticeTopic,String region) {
        noticeTopic.setRegion(region);
        if(region.length()==6){
            if(region.endsWith("0000")){
                noticeTopic.setRegionSheng(region.substring(0,2)+"0000");
            }else if(region.endsWith("00")){
                noticeTopic.setRegionSheng(region.substring(0,2)+"0000");
                noticeTopic.setRegionShi(region.substring(0,4)+"00");
            }else{
                noticeTopic.setRegionSheng(region.substring(0,2)+"0000");
                noticeTopic.setRegionShi(region.substring(0,4)+"00");
                noticeTopic.setRegionXian(region);
            }
        }
        if(region.length()==9){
            noticeTopic.setRegionSheng(region.substring(0,2)+"0000");
            noticeTopic.setRegionShi(region.substring(0,4)+"00");
            noticeTopic.setRegionXian(region.substring(0,6));
            noticeTopic.setRegionXiang(region);
        }
        return noticeTopic;
    }
}
