package com.geoway.landteam.landcloud.service.user.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.service.task.TaskNoticeNewService;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorDomain;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorValue;
import com.geoway.landteam.landcloud.core.model.user.dto.UserProsecuteDTO;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.UserProsecute;
import com.geoway.landteam.landcloud.core.model.user.entity.UserProsecuteAppeal;
import com.geoway.landteam.landcloud.core.model.user.entity.UserProsecuteAttach;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OrganizationRepository;
import com.geoway.landteam.landcloud.core.repository.user.*;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.EnumeratorValueServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.SMSUtilHuawei;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.servface.user.MUserProsecuteService;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilCollection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.service.impl
 * @date 2021/6/24 9:52
 */
@Service
public class MUserProsecuteServiceImpl implements MUserProsecuteService {

    @Autowired
    UserProsecuteRepository userProsecuteRepository;

    @Autowired
    UserProsecuteAttachRepository userProsecuteAttachRepository;

    @Autowired
    UserProsecuteAppealRepository userProsecuteAppealRepository;

    @Autowired
    LandUserRepository landUserDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    Organization2UserRepository organization2UserDao;

    @Autowired
    UserRoleInfoRepository userRoleInfoRepository;

    @Autowired
    OrganizationRepository organizationRepository;

    @Autowired
    EnumeratorValueServiceImpl enumeratorValueService;
    @Autowired
    EnumeratorDomainService enumeratorDomainService;

    @Autowired
    TaskNoticeNewService taskNoticeNewService;
    @Autowired
    LandRegUserService regUserService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    UserNameService userNameService;

    @Override
    public UserProsecute findUserProsecutebyId(String id) {
        return userProsecuteRepository.findById(id).orElse(null);
    }

    /**
     * 保存举报信息
     * @param userId
     * @param prosecuteUserId
     * @param prosecuteType
     * @param prosecuteImages
     * @param remark
     */
    @Override
    public void saveUserProsecute(Long userId, Long prosecuteUserId, String prosecuteType, String prosecuteImages, String remark) throws Exception {
        List<UserProsecute> lists = userProsecuteRepository.findByUserIdAndProsecuteUserIdAndType(userId, prosecuteUserId,prosecuteType);
        if(!lists.isEmpty()){
            throw new RuntimeException("该用户已被你举报过，不用重复举报");
        }
         UserProsecute userProsecute = new UserProsecute();
        userProsecute.setUserId(prosecuteUserId);
        userProsecute.setProsecuteUserId(userId);
        userProsecute.setStatus(0);
        userProsecute.setProsecuteType(prosecuteType);
        userProsecute.setRemark(remark);
        userProsecute.setCreateTime(new Timestamp(System.currentTimeMillis()));
        UserProsecute bean = userProsecuteRepository.save(userProsecute);
        //保存附件
        if(prosecuteImages != null && !"".equals(prosecuteImages)){
            saveUserProsecuteAttach(bean.getId(),userId,prosecuteImages);
        }
        //发送通知
        sendMessage(userId,bean.getId());
    }

    public void sendMessage(Long userId,String prosecuteId){
        String title = "举报通知";
        String content = String.format("【举报通知】您已提交举报信息，点击查看详情，感谢您的支持！");
        TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
        taskNoticeUserNew.setSenduser(userId.toString());
        taskNoticeUserNew.setTitle(title);
        taskNoticeUserNew.setContent(content);
        taskNoticeUserNew.setReceiveuser(userId.toString());
        taskNoticeUserNew.setData(prosecuteId);
        taskNoticeUserNew.setAction(1);
        taskNoticeUserNew.setSenddate(new Date());
       taskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
          Map<String, Object> message = new HashMap<String, Object>();
                message.put("type", 8);
        // 推送消息
        List<String> userIds = new ArrayList<>();
           userIds.add(userId.toString());
           try {
                if(userIds.size() > 0 ){
                    MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
                }
             } catch (Exception e){
        }
    }


    @Override
    public JSONArray findUserProsecuteinfo(Long userId) {
        List<String> lists = userProsecuteRepository.findTypeByUserId(userId);
        JSONArray arr = new JSONArray();
        if(!lists.isEmpty()){
            EnumeratorValue ev = enumeratorValueService.findOneByKey("DIC_JBLX");
            List<EnumeratorDomain> result = enumeratorDomainService.findByDicno(ev.getDicno());
            for (EnumeratorDomain ed : result) {
                JSONObject obj = new JSONObject();
                lists.forEach(a->{
                    if(a.equals(ed.getCode())){
                        obj.put("id", ed.getCode());
                        obj.put("text", ed.getName());
                        arr.add(obj);
                    }
                });
            }
        }

        return arr;
    }

    /**
     * 提交解封申请
     * @param userId
     * @param appealInfo
     */
    @Override
    public void submitAppealApply(Long userId, String appealInfo) {
        JSONArray jsonArray = JSONArray.parseArray(appealInfo);
        if(jsonArray.size() > 0){
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
               String type = jsonObject.get("type").toString();
               String state = jsonObject.get("state").toString();
               String images = jsonObject.get("images").toString();
               String remark = jsonObject.get("remark").toString();
            List<Object[]> objects = userProsecuteRepository.findTypeByUserIdAndType(userId, type);
            if(!objects.isEmpty()){
                 for(Object[] object : objects){
                  if(object[2] == null){
                      UserProsecuteAppeal bean = new UserProsecuteAppeal();
                          bean.setProsecuteId(object[1].toString());
                          bean.setRemark(remark);
                          bean.setState(Integer.valueOf(state));
                          bean.setStatus(0);
                          bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
                          bean.setUserId(userId);
                      UserProsecuteAppeal save = userProsecuteAppealRepository.save(bean);
                      //保存附件
                      if(images != null && !"".equals(images)){
                          saveUserProsecuteAttach(save.getId(),userId,images);
                      }
                  }else{
                      UserProsecuteAppeal one = userProsecuteAppealRepository.findById(object[2].toString()).orElse(null);
                      one.setRemark(remark);
                      one.setState(Integer.valueOf(state));
                      one.setStatus(0);
                      one.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                      userProsecuteAppealRepository.save(one);
                      //保存附件
                      if(images != null && !"".equals(images)){
                          saveUserProsecuteAttach(one.getId(),userId,images);
                      }
                  }
                 }
            }
            }
        }
    }

    /**
     * 获取举报数据列表
     * @param userId
     * @param prosecuteStatus
     * @param appealStatus
     * @param prosecuteUserName
     * @param userName
     * @param page
     * @param rows
     * @return
     */
    @Override
    public Map<String, Object> getUserProsecuteRecords(Long userId, Integer prosecuteStatus, Integer appealStatus, String prosecuteUserName, String userName, Integer page, Integer rows) {
        Map<String, Object> resultMap = new HashMap<>();
        StringBuffer sql = new StringBuffer();
        StringBuffer countSql = new StringBuffer();
            sql.append("select u.f_id prosecuteId,a.f_id appealId,u.f_userid userId,u.f_prosecuteuserid " +
                    "prosecuteUserId,u.f_prosecutetype prosecuteType,u.f_createtime prosecuteTime,u.f_status " +
                    "prosecuteStatus,a.f_status appealStatus,a.f_audittime appealAuditTime,u.f_audittime prosecuteAuditTime from " +
                    "tb_user_prosecute u LEFT JOIN tb_user_prosecute_appeal a on (u.f_id = a.f_prosecuteid)");
            countSql.append("select count(1) from tb_user_prosecute u LEFT JOIN tb_user_prosecute_appeal a on (u.f_id = a.f_prosecuteid) ");
            sql.append(" where 1 =1 ");
            countSql.append(" where 1 =1 ");
            if(prosecuteStatus != null){
                sql.append(" and u.f_status =" +prosecuteStatus);
                countSql.append(" and u.f_status =" +prosecuteStatus);
            }
            if(appealStatus != null){
                sql.append(" and u.f_status =" +appealStatus);
                countSql.append(" and u.f_status =" +appealStatus);
            }
            if(userName != null){
                sql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_userid and (pp.f_username like '%"+userName+"%' or pp.f_rname like '%"+userName+"%'  )) ");
                countSql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_userid and (pp.f_username like '%"+userName+"%' or pp.f_rname like '%"+userName+"%'  )) ");
            }
            if(prosecuteUserName != null){
                sql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_prosecuteuserid and (pp.f_username like '%"+prosecuteUserName+"%' or pp.f_rname like '%"+prosecuteUserName+"%'  )) ");
                countSql.append(" and  EXISTS(SELECT pp.f_userid  FROM tbsys_user AS pp WHERE pp.f_userid = u.f_prosecuteuserid and (pp.f_username like '%"+prosecuteUserName+"%' or pp.f_rname like '%"+prosecuteUserName+"%'  )) ");
            }
        //权限管控
        String orgIdByUserId = organization2UserDao.findOrgIdByUserId(userId);
           List<Long> users = new ArrayList<>();
        if(orgIdByUserId != null) {
            List<String> roleIdsByUserId = userRoleInfoRepository.getRoleIdsByUserId(userId);
            if(roleIdsByUserId.contains("10022") ){ //管理员或者联络员审核普通用户
                //获取单位内普通用户
                users = organization2UserDao.queryOrUserTwo(orgIdByUserId);
                //获取下级管理员
                List<String>  orgIds = organizationRepository.getOrganizationsByPid(orgIdByUserId);
                if(!orgIds.isEmpty()){
                    users.addAll(organization2UserDao.queryManagers(orgIds));
                }
            }else if(roleIdsByUserId.contains("10020")){
                //获取单位内普通用户
                users = organization2UserDao.queryOrUser(orgIdByUserId);
            }
        }
        if(!users.isEmpty()){
            sql.append(" and u.f_userid in(" + StringUtils.join(users.toArray(),",") + ") ");
            countSql.append(" and u.f_userid in(" + StringUtils.join(users.toArray(),",") + ") ");
        }
        sql.append(" ORDER BY u.f_createtime desc LIMIT " + rows + " OFFSET " + (page - 1) * rows);
        List<Map<String, Object>> resultList = jdbcTemplate.queryForList(sql.toString());
        List<UserProsecuteDTO> list = new ArrayList<>();
        if (!GutilCollection.isEmpty(resultList)) {
            for (Map<String, Object> map : resultList) {
                try {
                    UserProsecuteDTO bean = new UserProsecuteDTO();
                    bean.setProsecuteId(map.get("prosecuteId") != null? map.get("prosecuteId").toString() : "");
                    bean.setAppealId(map.get("appealId") != null? map.get("appealId").toString() : "");
                    bean.setUserId(map.get("userId") != null? Long.valueOf(map.get("userId").toString()) : null);
                    if(map.get("userId") != null){
                        LandUser landUser = regUserService.getReviewDetailByUserId(Long.valueOf(map.get("userId").toString()));
                        bean.setUserName(userNameService.getUserRealNameByUserId(map.get("userId").toString()));
                        bean.setLandUser(landUser);
                    }
                    bean.setProsecuteUserId(map.get("prosecuteUserId") != null? Long.valueOf(map.get("prosecuteUserId").toString()) : null);
                    if(map.get("prosecuteUserId") != null){
                        LandUser landUser = landUserDao.findById(Long.valueOf(map.get("prosecuteUserId").toString())).orElse(null);
                        bean.setProsecuteUserName(userNameService.getUserRealNameByUserId(map.get("prosecuteUserId").toString()));
                        bean.setProsecuteUserPhone(userNameService.getUserPhoneByUserId(map.get("prosecuteUserId").toString()));
                    }
                    bean.setProsecuteType(map.get("prosecuteType") != null? map.get("prosecuteType").toString() : null);
                    bean.setProsecuteTime(map.get("prosecuteTime") != null?Timestamp.valueOf(map.get("prosecuteTime") .toString())  : null);
                    bean.setProsecuteStatus(map.get("prosecuteStatus") != null? Integer.valueOf(map.get("prosecuteStatus").toString()) : null);
                    bean.setAppealStatus(map.get("appealStatus") != null? Integer.valueOf(map.get("appealStatus").toString()) :  null);
                    bean.setAppealAuditTime(map.get("appealAuditTime") != null?Timestamp.valueOf(map.get("appealAuditTime") .toString())  : null);
                    bean.setProsecuteAuditTime(map.get("prosecuteAuditTime") != null?Timestamp.valueOf(map.get("prosecuteAuditTime").toString())  : null);
                    list.add(bean);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Long count = jdbcTemplate.queryForObject(countSql.toString(),Long.class);
        resultMap.put("list",list);
        resultMap.put("count",count);
        return resultMap;
    }

    @Override
    public UserProsecute getProsecuteInfo(String prosecuteId) throws Exception {
        UserProsecute userProsecute = userProsecuteRepository.findById(prosecuteId).orElse(null);
        if(userProsecute == null){
            throw new RuntimeException("该数据不存在，请检查id");
        }
        List<UserProsecuteAttach> attachs = userProsecuteAttachRepository.findAttachByProsecuteId(prosecuteId);
        if(!attachs.isEmpty()){
            attachs.forEach(a->{
                if (a.getFileUrl() != null && !"".equals(a.getFileUrl()) &&  !a.getFileUrl().contains("AccessKeyId")) {
                    a.setFileNoConversionUrl(a.getFileUrl());
                    String url = temporarySignedUrlService.getTemporarySignedUrl("",a.getFileUrl(), null);
                    a.setFileUrl(url);
                }
            });
            userProsecute.setAttachs(attachs);
        }
        if(userProsecute.getUserId() != null){
            //LandUser landUser = landUserDao.findById(userProsecute.getUserId()).orElse(null);
            userProsecute.setUserName(userNameService.getUserRealNameByUserId(userProsecute.getUserId().toString()));
        }
        if(userProsecute.getAuditUseId() != null){
            //LandUser landUser = landUserDao.findById(userProsecute.getAuditUseId()).orElse(null);
            userProsecute.setAuditUserName(userNameService.getUserRealNameByUserId(userProsecute.getAuditUseId().toString()));
        }
        if(userProsecute.getProsecuteType() != null){
            EnumeratorValue ev = enumeratorValueService.findOneByKey("DIC_JBLX");
            List<EnumeratorDomain> result = enumeratorDomainService.findByDicno(ev.getDicno());
            result.forEach(a ->{
                if(a.getCode().equals(userProsecute.getProsecuteType())){
                    userProsecute.setProsecuteTypeName(a.getName());
                }
            });
        }
        return userProsecute;
    }

    @Override
    public UserProsecuteAppeal getAppealInfo(String prosecuteId) throws Exception {
        UserProsecuteAppeal userProsecuteAppeal = userProsecuteAppealRepository.findById(prosecuteId).orElse(null);
        if(userProsecuteAppeal == null){
            throw new GwValidateException("该数据不存在，请检查id");
        }
        UserProsecute userProsecute = userProsecuteRepository.findById(userProsecuteAppeal.getProsecuteId()).orElse(null);
        if(userProsecute!=null){
            userProsecuteAppeal.setProsecuteType(userProsecute.getProsecuteType());
        }
        if(userProsecuteAppeal.getAuditUseId() != null){
            //LandUser landUser = landUserDao.findById(userProsecuteAppeal.getAuditUseId()).orElse(null);
            userProsecuteAppeal.setAuditUserName(userNameService.getUserRealNameByUserName(userProsecuteAppeal.getAuditUseId().toString()));
        }
        List<UserProsecuteAttach> attachs = userProsecuteAttachRepository.findAttachByProsecuteId(prosecuteId);
        if(!attachs.isEmpty()){
            attachs.forEach(a->{
                if (a.getFileUrl() != null && !"".equals(a.getFileUrl()) && !a.getFileUrl().contains("AccessKeyId")) {
                    a.setFileNoConversionUrl(a.getFileUrl());
                    String url = temporarySignedUrlService.getTemporarySignedUrl("",a.getFileUrl(), null);
                    a.setFileUrl(url);
                }
            });
            userProsecuteAppeal.setAttachs(attachs);
        }
        return userProsecuteAppeal;
    }

    @Override
    public void prosecuteAudit(Long userId, String id, Integer type, Integer status, String auditOpinion) throws Exception {
        if(type == 1){ //举报审核
            UserProsecute userProsecute = userProsecuteRepository.findById(id).orElse(null);
            if(userProsecute == null){
                throw new RuntimeException("该数据不存在，请检查id");
            }
            userProsecute.setStatus(status);
            userProsecute.setAuditUseId(userId);
            userProsecute.setAuditTime(new Timestamp(System.currentTimeMillis()));
            userProsecute.setAuditOpinion(auditOpinion);
            userProsecuteRepository.save(userProsecute);
            //发送通知
          /*  auditSendMessage(userId,userProsecute);*/
        }else if(type == 2){ //解封审核
            UserProsecuteAppeal userProsecuteAppeal = userProsecuteAppealRepository.findById(id).orElse(null);
            if(userProsecuteAppeal == null){
                throw new RuntimeException("该数据不存在，请检查id");
            }
            userProsecuteAppeal.setStatus(status);
            userProsecuteAppeal.setAuditUseId(userId);
            userProsecuteAppeal.setAuditTime(new Timestamp(System.currentTimeMillis()));
            userProsecuteAppeal.setAuditOpinion(auditOpinion);
            userProsecuteAppealRepository.save(userProsecuteAppeal);

            //判断是否已经全部解封通过
            Integer count = userProsecuteRepository.countByUserId(userProsecuteAppeal.getUserId());
            if(count <= 0){
                //发送短信通知
                String telphone = userNameService.getUserPhoneByUserId(userProsecuteAppeal.getUserId().toString());
                String rname =userNameService.getUserRealNameByUserId(userProsecuteAppeal.getUserId().toString());
                if(StringUtils.isNotBlank(telphone))
                {
                    if (!telphone.startsWith("+86")) {
                        telphone = "+86" + telphone;
                    }
                    if(status == 1) {
                        String templateParas = "[\"" + rname + "\",\"" +rname + "\"]";
                        SMSUtilHuawei.sendSMS("csms18120613", "e2c707cb3a7148279a903d3789795f6c", templateParas, telphone);
                    }
                }
            }

        }
    }

    public void auditSendMessage(Long userId,UserProsecute userProsecute){
        String title = "举报通知";
        String content = "";
        TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
        taskNoticeUserNew.setSenduser(userId.toString());
        EnumeratorValue ev = enumeratorValueService.findOneByKey("DIC_JBLX");
        List<EnumeratorDomain> result = enumeratorDomainService.findByDicno(ev.getDicno());
        result.forEach(a ->{
            if(a.getCode().equals(userProsecute.getProsecuteType())){
                userProsecute.setProsecuteTypeName(a.getName());
            }
        });
        if(userProsecute.getUserId() != null){
            userProsecute.setUserName(userNameService.getUserRealNameByUserId(userProsecute.getUserId().toString()));
        }
        if(userProsecute.getStatus() == 1){
             content = String.format("举报对象："+userProsecute.getUserName()+"\n" +
                     "举报内容："+userProsecute.getProsecuteTypeName()+"。\n" +
                     "审核结果：经审核，确认举报对象有违规行为。已对其进行功能限制处理，感谢您的支持！\n");
            taskNoticeUserNew.setAction(2);
        }else{
            content = String.format("举报对象："+userProsecute.getUserName()+"\n" +
                    "举报内容："+userProsecute.getProsecuteTypeName()+"。\n" +
                    "审核结果：经审核，确认举报对象不存在违规行为，感谢您的参与！\n");
            taskNoticeUserNew.setAction(3);
        }
        taskNoticeUserNew.setTitle(title);
        taskNoticeUserNew.setContent(content);
        taskNoticeUserNew.setReceiveuser(userProsecute.getProsecuteUserId().toString());
        taskNoticeUserNew.setData(userProsecute.getId());
        taskNoticeUserNew.setSenddate(new Date());
        taskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("type", 8);
        // 推送消息
        List<String> userIds = new ArrayList<>();
        userIds.add(userId.toString());
        try {
            if(userIds.size() > 0 ){
                MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
            }
        } catch (Exception e){
        }
    }

    /**
     * 获取未审核的解封申请记录
     * @param userId
     * @return
     */
    @Override
    public List<UserProsecuteAppeal> findUserAppealRecords(Long userId) {
        List<UserProsecuteAppeal> list = userProsecuteAppealRepository.findUserAppealRecordsByUserId(userId, 0);
        return list;
    }

    /**
     * 保存投诉附件
     * @param id
     * @param userId
     * @param prosecuteImages
     */
    public void saveUserProsecuteAttach(String id,Long userId,String prosecuteImages){
      List<UserProsecuteAttach> lists = new ArrayList<>();
        List<String> listString = Arrays.asList(prosecuteImages.split(","));
        if(!listString.isEmpty()){
            listString.forEach(a ->{
                UserProsecuteAttach userProsecuteAttach = new UserProsecuteAttach();
                userProsecuteAttach.setFileUrl(a);
                userProsecuteAttach.setProsecuteId(id);
                userProsecuteAttach.setUserId(userId);
                userProsecuteAttach.setCreateTime(new Timestamp(System.currentTimeMillis()));
                lists.add(userProsecuteAttach);
            });
        }
         if(!GutilCollection.isEmpty(lists)){
             userProsecuteAttachRepository.saveAll(lists);
         }
    }



}
