package com.geoway.landteam.landcloud.service.util;

import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class EncryptionTools {

    private static SM2 SM_2 = null;

    static {
        try {
            SM_2 = new SM2("255881E5CD988C418FD879F57AA536A9DEAE5BB48557DA53D484058FA9626015", "04E6D90896FADEA60AA35BB0D17AA714DDCA8D9DB5C3C881C0DECD899DCF95A2F84D2AA8562681747AD0A4C23137D963F38A43ED278BD890BD2F35C96ED0EBDAF0");
//            BouncyCastleProvider BC = new BouncyCastleProvider();
//            String publicKeyStr = "04387CBA4FF4E78EA63987248A5D9E87117B601E2CA3B1F8FFEBC36F5CDE53DD45545E198C0111321C037CB1BBB60C4E044E8AEEB5662EE050B2B12505AE536D62";
//            String privateKeyStr = "F255415AD7FBE7A46CEF63B7A2C58AD172E1A5EDDF8076048CF3999D17DD3EE2";
//            KeyFactory keyFactory = KeyFactory.getInstance("EC", BC);
//            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decode(publicKeyStr)));
//            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.decode(privateKeyStr)));
//            SM_2 = SmUtil.sm2(privateKey, publicKey);
        } catch (Exception e) {
            log.info("SM2密钥初始化错误", e);
        }
    }


    /**
     * 文件加/解密
     *
     * @param source   原始文件路径
     * @param out      输出路径
     * @param fileName 输出文件名
     * @param action   行为（true为加密，false为解密）
     */
    public static void encryptionOrDecryption(String source, String out, String fileName, boolean action) {
        byte[] bytes = FileUtil.fileToByte(source);
//        byte[] data;
        String s = "";
        if (action) {
//            data = SM_2.encrypt(bytes, KeyType.PublicKey);
//            s = SM_2.encryptHex(source, KeyType.PublicKey);
            s = SM_2.encryptHex(bytes, KeyType.PublicKey);
        } else {
//            data = SM_2.decrypt(bytes, KeyType.PrivateKey);
//            s = SM_2.encryptHex(source, KeyType.PublicKey);
//            s = SM_2.decryptHex(bytes, KeyType.PublicKey);
//            SM_2.decryptStr(s, KeyType.PrivateKey);
//            s = SM_2.encrypt(bytes, KeyType.PrivateKey)
            s = SM_2.encryptHex(bytes, KeyType.PublicKey);
        }
        FileUtil.byteToFile(s.getBytes(), out, fileName);
//        FileUtils.hexToFile(s, out, fileName);
    }



    /**
     * 测试方法
     */
    public static void main(String[] args) {
        // 加密
        encryptionOrDecryption("D:\\test\\test.pdf","D:\\test","encrypt.pdf",true);
        // 解密
        encryptionOrDecryption("D:\\test\\encrypt.pdf","D:\\test","decrypt.pdf",false);
    }
}