package com.geoway.landteam.landcloud.service.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;

public class ExceptionUtil {
    public static String getStackTrace(Exception ex)
    {
        StringBuilder sbException = new StringBuilder();
        for (StackTraceElement ele : ex.getStackTrace()) {
            sbException.append(MessageFormat.format("\tat {0}.{1}({2}:{3})\n",
                    ele.getClassName(), ele.getMethodName(), ele.getFileName(), ele.getLineNumber()));;
        }
        return sbException.toString();
    }
    public static String getErrorString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        StringBuffer stringBuffer = stringWriter.getBuffer();
        return stringBuffer.toString();
    }
}
