package com.geoway.landteam.landcloud.service.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
//import org.apache.log4j.Logger;

import com.gw.base.log.GiLoger;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * FileName: HttpUtil.java
 * Author:   chenhao
 * Date:     2023/10/16 15:57
 * Description:
 */
public class HttpUtil {

    public static final String ContentType_Form = "application/x-www-form-urlencoded; charset=UTF-8";
    public static final String ContentType_JSON = "application/json; charset=UTF-8";

//    static Logger logger = Logger.getLogger(HttpUtil.class);
    private final GiLoger logger = GwLoger.getLoger(HttpUtil.class);



    public static byte[] fileConvertToByteArray(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len;
        byte[] buffer = new byte[1024];
        while ((len = fis.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        byte[] data = baos.toByteArray();
        fis.close();
        baos.close();
        return data;
    }


    public static byte[] fileConvertToByteArray(InputStream inputStream) throws Exception {
//        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len;
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        byte[] data = baos.toByteArray();
        inputStream.close();
        baos.close();
        return data;
    }

    public static String httpsRequestPost(String requestUrl, String requestMethod, byte[] bytes, String ContentType) throws Exception {
        String result = null;
        HttpURLConnection conn = null;
        try {
            // 创建 SSLContext
            SSLContext sslContext = SSLContext.getInstance("SSL");
            TrustManager[] tm = {new MyX509TrustManager()};
            // 初始化
            sslContext.init(null, tm, new java.security.SecureRandom());
            // 获取 SSLSocketFactory 对象
            SSLSocketFactory ssf = sslContext.getSocketFactory();

            URL url = new URL(requestUrl);
            conn = (HttpURLConnection) url.openConnection();

            // 如果是HTTPS连接，设置SSLSocketFactory
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection) conn).setSSLSocketFactory(ssf);
            }

            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod(requestMethod);
            // 设置Content-Type
            if(StringUtils.isNotEmpty(ContentType) && ContentType.contains(":")){
                conn.setRequestProperty("Content-Type", ContentType.split(":")[1]);
            }
            conn.connect();

            // 往服务器端写内容
            if (bytes != null) {
                try (OutputStream os = conn.getOutputStream()) {
                    os.write(bytes);
                    os.flush();
                }
            }

            // 读取服务器端返回的内容
            try (InputStream is = conn.getInputStream();
                 ByteArrayOutputStream bytestream = new ByteArrayOutputStream()) {

                byte[] bb = new byte[2048];
                int ch;
                while ((ch = is.read(bb)) != -1) {
                    bytestream.write(bb, 0, ch);
                }
                byte[] by = bytestream.toByteArray();
                result = new String(by, StandardCharsets.UTF_8);
            }

        } catch (Exception e) {
            e.printStackTrace();
            throw e; // 重新抛出异常让调用者处理
        } finally {
            if (conn != null) {
                conn.disconnect(); // 确保连接关闭
            }
        }
        return result;
    }


    public static boolean checkFileExists(String path) throws Exception {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(path);
            conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("HEAD"); // 使用HEAD方法检查文件是否存在，不下载文件内容

            int responseCode = conn.getResponseCode();
            System.out.println("Response Code : " + responseCode);

            if (responseCode == HttpURLConnection.HTTP_OK) {
                return true;
            }
        } catch (Exception e) {

        } finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
        return false;
    }

}
