package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.common.constant.MessageConstants;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.gw.base.user.GwNoLoginException;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Component
public class RedisSessionTestUtils {

    @Resource
    private RedisCacheUtils<AuthUserInfo> redisCache;

    private  static RedisCacheUtils<AuthUserInfo> redisCacheUtils;

    @PostConstruct
    public void init(){
        redisCacheUtils = redisCache;
    }

	public static Long checkWebLogin(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
        boolean hasAppsId=request.getHeader("appsId")!=null && StringUtils.isNotBlank(request.getHeader("appsId"));
        if(hasAppsId){
            appkey = request.getHeader("appsId");
            session.setAttribute("appsId"+appkey, appkey);
        }
        AuthUserInfo authUserInfo = RedisSessionTestUtils.getAuthUserInfo(request);
        if(authUserInfo == null){
            try {
                if(request.getHeader("access_token")!=null && StringUtils.isNotBlank(request.getHeader("access_token")) && !"undefined".equalsIgnoreCase(request.getHeader("access_token"))){
                    String token = request.getHeader("access_token");
                    AuthUserInfo  authUserInfo1 =  redisCacheUtils.getObject(token);
                    if(authUserInfo1 !=null){
                        return authUserInfo1.getUserId();
                    }else{
                        throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
                    }
                }
            }catch (Exception e) {
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }
            throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
        }else{
            return authUserInfo.getUserId();
        }
	}

	public static Long checkAppOrWebLogin(HttpServletRequest request) {
        return checkWebLogin(request);
	}

    public static int getLevel(HttpServletRequest request) {
        int level = -1;
        Object obj = request.getSession(true).getAttribute("user-level");
        if( obj!=null && obj instanceof Integer) {
            level = (int)obj;
        } else {
            throw new GwNoLoginException(MessageConstants.RESPONSE_NOLOGIN);
        }
        return level;
    }

    /***
     * 获取统一用户信息
     * @param request
     * @return
     */
    public static AuthUserInfo getAuthUserInfo(HttpServletRequest request){
        try{
            AuthUserInfo busUserInfo = (AuthUserInfo)request.getSession().getAttribute("authUserInfo");
            return busUserInfo;
        }
        catch (Exception ex){
            return null;
        }
    }
}
