package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.common.constant.MessageConstants;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.user.UisService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.user.GwNoLoginException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*import com.gw.base.user.GwNoLoginException;*/

@Component
public class RedisSessionUtils {
    private static final GiLoger logger = GwLoger.getLoger(RedisSessionUtils.class);
    @Resource
    private RedisCacheUtils<AuthUserInfo> redisCache;

    @Autowired
    UisService uisService;

    private  static UisService  uis;

    private  static RedisCacheUtils<AuthUserInfo> redisCacheUtils;

    @PostConstruct
    public void init(){
        redisCacheUtils = redisCache;
        uis = uisService;
    }
    /*
    public static Long checkAppOrWebLogin(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
        boolean hasAppsId=request.getHeader("appsId")!=null && StringUtils.isNotBlank(request.getHeader("appsId"));
        if(hasAppsId){
            appkey = request.getHeader("appsId");
            session.setAttribute("appsId"+appkey, appkey);
        }
        if(request.getHeader("loginToken")!=null && StringUtils.isNotBlank(request.getHeader("loginToken")) && !"undefined".equalsIgnoreCase(request.getHeader("loginToken"))){
            String token = request.getHeader("loginToken");
            Long userId = null;
            try {
                LandUser landUser =  redisCacheUtils.getObject(token);
                if(landUser != null){
                    userId = landUser.getId();
                }else{
                    userId = uis.getUserId(token);
                    if(userId == null){
                        throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN );
                    }
                }
            } catch (Exception e) {
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }
            return userId;
        }
        else {
            Object accessToken = null;
            if(hasAppsId) {
                accessToken = session.getAttribute(appkey + "accessToken");
            }
            else
            {
                accessToken = session.getAttribute(  "accessToken");
            }
            if (accessToken == null) {
                Object objUserId = session.getAttribute("userId-appserver");
                Object objUserId2 = session.getAttribute("userId");
                if (objUserId != null) {
                    return Long.parseLong(objUserId.toString());
                } else if (objUserId2 != null) {
                    return Long.parseLong(objUserId2.toString());
                }
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }else{
                LandUser landUser =  redisCacheUtils.getObject(accessToken.toString());
                if(landUser == null ){
                    throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
                }
                return landUser.getId();
            }
        }
    }
     public static LandUser checkLoginUser(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
        boolean hasAppsId=request.getHeader("appsId")!=null && StringUtils.isNotBlank(request.getHeader("appsId"));
        if(hasAppsId){
            appkey = request.getHeader("appsId");
            session.setAttribute("appsId"+appkey, appkey);
        }


        Object accessToken = null;
        if(hasAppsId) {
            accessToken = session.getAttribute(appkey + "accessToken");
        }
        else
        {
            accessToken = session.getAttribute(  "accessToken");
        }
        if (accessToken == null) {
            throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
        }else{
            LandUser landUser =  redisCacheUtils.getObject(accessToken.toString());
            if(landUser == null ){
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }
            return landUser;
        }

    }
    public static Long checkAppLogin(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        if(request.getHeader("loginToken")!=null && StringUtils.isNotBlank(request.getHeader("loginToken")) && !"undefined".equalsIgnoreCase(request.getHeader("loginToken"))){
            String token = request.getHeader("loginToken");
            Long userId = null;
            try {
                LandUser landUser =  redisCacheUtils.getObject(token);
                if(landUser != null){
                    userId = landUser.getId();
                }else{
                    userId = uis.getUserId(token);
                    if(userId == null){
                        throw new GwNoLoginException(MessageConstants.RESPONSE_NOLOGIN);
                    }
                }
            } catch (Exception e) {
                throw new GwNoLoginException(MessageConstants.RESPONSE_NOLOGIN);
            }
            return userId;
        }else {
            Object accessToken = session.getAttribute("accessToken");
            if (accessToken == null) {
                Object objUserId = session.getAttribute("userId-appserver");
                if (objUserId != null) {
                    return Long.parseLong(objUserId.toString());
                }
                throw new GwNoLoginException(MessageConstants.RESPONSE_NOLOGIN);
            }else{
                LandUser landUser =  redisCacheUtils.getObject(accessToken.toString());
                if(landUser == null ){
                    throw new GwNoLoginException(MessageConstants.RESPONSE_NOLOGIN);
                }
                return landUser.getId();
            }
        }
    }

    public static Long checkWebLogin(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        Object user = session.getAttribute("gacOAuth2User");
        String appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
        if(request.getHeader("appsId")!=null && StringUtils.isNotBlank(request.getHeader("appsId"))){
            appkey = request.getHeader("appsId");
            session.setAttribute("appsId", appkey);
        }

        if(request.getHeader("loginToken")!=null && StringUtils.isNotBlank(request.getHeader("loginToken")) && !"undefined".equalsIgnoreCase(request.getHeader("loginToken"))){
            String token = request.getHeader("loginToken");
            Long userId = null;
            try {
                LandUser landUser =  redisCacheUtils.getObject(token);
                if(landUser != null){
                    userId = landUser.getId();
                }else{
                    userId = uis.getUserId(token);
                    if(userId == null){
                        throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN );
                    }
                }
            } catch (Exception e) {
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }
            return userId;
        }
        else {
            Object accessToken = session.getAttribute("accessToken");
            if (accessToken == null) {
                Object objUserId = session.getAttribute("userId-appserver");
                Object objUserId2 = session.getAttribute("userId");
                if (objUserId != null) {
                    return Long.parseLong(objUserId.toString());
                } else if (objUserId2 != null) {
                    return Long.parseLong(objUserId2.toString());
                }
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }else{
                LandUser landUser =  redisCacheUtils.getObject(accessToken.toString());
                if(landUser == null ){
                    throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
                }
                return landUser.getId();
            }
        }
    }
    */

    public static Long checkWebLogin(HttpServletRequest reques)
    {
        return checkAppOrWebLogin(reques);
    }
    public static Long checkAppOrWebLogin(HttpServletRequest request) {

        AuthUserInfo authUserInfo = getAuthUserInfo(request);
        return authUserInfo ==null?null:authUserInfo.getUserId();


    }
    public static AuthUserInfo getAuthUserInfo(String sessionId,String appIds){
        try{
            AuthUserInfo busUserInfo = redisCacheUtils.getObject(sessionId);
            if (busUserInfo == null) {
                throw new GwNoLoginException("appId:" + appIds + ";" + MessageConstants.RESPONSE_NOLOGIN);
            }
            return busUserInfo;

        }
        catch (Exception ex){
            throw new GwNoLoginException("appId:"+";"+MessageConstants.RESPONSE_NOLOGIN);
        }
    }

    public static AuthUserInfo getAuthUserInfo(HttpServletRequest request){
        try{
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();

            String appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
            boolean hasAppsId=request.getHeader("appsId")!=null && StringUtils.isNotBlank(request.getHeader("appsId"));
            if(hasAppsId){
                appkey = request.getHeader("appsId");
                //session.setAttribute("appsId", appkey);
            }
            Object accessToken = null;
            if(!hasAppsId) {
                appkey="";
            }

            accessToken = session.getAttribute(appkey + "accessToken");
            if(accessToken==null)
            {
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }
            else {
                logger.info("getAuthUserInfo sessionId:"+sessionId+" key:"+accessToken.toString());
                AuthUserInfo busUserInfo = redisCacheUtils.getObject(accessToken.toString());
                if (busUserInfo == null) {
                    throw new GwNoLoginException("appId:" + appkey + ";" + MessageConstants.RESPONSE_NOLOGIN);
                }
                redisCacheUtils.setObject(accessToken.toString(),busUserInfo,3600*24);
                return busUserInfo;
            }
        }
        catch (Exception ex){
            throw new GwNoLoginException("appId:"+";"+MessageConstants.RESPONSE_NOLOGIN);
        }
    }
    public static AuthUserInfo getErrAuthUserInfo(HttpServletRequest request){
        try{
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();
            String appkey = (String)ProjectConfig.getConfig(ProjectConfigEnum.OAUTH_APPKEY.getKey());
            boolean hasAppsId=request.getHeader("appsId")!=null && StringUtils.isNotBlank(request.getHeader("appsId"));
            if(hasAppsId){
                appkey = request.getHeader("appsId");
                //session.setAttribute("appsId", appkey);
            }
            Object accessToken = null;
            if(!hasAppsId) {
                appkey="";
            }
            logger.warn("getAuthUserInfo2 sessionId:"+sessionId);
            accessToken = session.getAttribute(appkey + "accessToken");
            if(accessToken==null)
            {
                throw new GwNoLoginException("appId:"+appkey+";"+MessageConstants.RESPONSE_NOLOGIN);
            }
            else {
                AuthUserInfo busUserInfo = redisCacheUtils.getObject(accessToken.toString());
                if (busUserInfo == null) {
                    throw new GwNoLoginException("appId:" + appkey + ";" + MessageConstants.RESPONSE_NOLOGIN);
                }

                return busUserInfo;
            }
        }
        catch (Exception ex){
            throw new GwNoLoginException("appId:"+";"+MessageConstants.RESPONSE_NOLOGIN);
        }
    }





    public static final String SESSION_KEY_REDIRECT_URL="redirect_url";
    public static final String SESSION_KEY_GAS_PROVIDER="gas_provider";
    public static final String SESSION_KEY_GAS_PROVIDER_SS01="gas_providerSSO1";
    public static void setSessionAtt(HttpSession session ,String key,Object value)
    {
        session.setAttribute(key,value);
    }
    public static Object getSessionAtt(HttpSession session ,String key)
    {
        return session.getAttribute(key);
    }
}
