package com.geoway.landteam.landcloud.service.util;

import com.geoway.landteam.landcloud.service.formatConversion.utils.ShapeOprate;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.*;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.math.BigDecimal;
import java.util.*;

/**
 * FileName: ShapeFile2Geo.java
 * Author:   chenhao
 * Date:     2020.06.18 18:21
 * Description: 项目边界shapefile解析
 */
public class ShapeFile2Geo {

    String uploadDir;
    private String crsSourceCode = "EPSG:4524";
    private String crsSourceWkt="";

    BigDecimal area = new BigDecimal(0);

    public String getCrsSourceCode() {
        return crsSourceCode;
    }

    public void setCrsSourceCode(String crsSourceCode) {
        this.crsSourceCode = crsSourceCode;
    }

    public BigDecimal getArea() {
        return area;
    }

    public ShapeFile2Geo(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public Map<String,Object> parsingShapeFile(HttpServletRequest request){

        Map<String,Object> result = new HashMap<>();
        try {


        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());

        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                Geometry geometry = null;
                String key = iter.next();
                MultipartFile shapeFile = multiRequest.getFile(key);
                if (shapeFile != null) {
                    String fileName = shapeFile.getOriginalFilename();

                    if (fileName.endsWith(".zip")) {
                        // Todo  shapefile解析
                        geometry = this.shapeFile(shapeFile, key);

                    } else if (fileName.endsWith(".txt")) {
                        // Todo txt文件解析
                        File txtFile = getFileFromMultipartFile(shapeFile, ".txt");
                        Txt2Geo txt2Geo = new Txt2Geo();
                        geometry = txt2Geo.readTxtFile(txtFile);
                        if("file".equals(key)|| "bound".equals(key)){
                            area = txt2Geo.getArea();
                        }
                    }
                    if("file".equalsIgnoreCase(key)){
                        result.put("message", "边界数据文件 "+ fileName +" 上传成功");
                    }
                    result.put(key, geometry);

                }

            }

        }
        }catch (Exception e){
            e.printStackTrace();
            result.put("message", "边界数据文件上传失败");
            area = new BigDecimal(0);
        }
        return result;
    }

    public Geometry shapeFile(MultipartFile shapeFile, String key) throws Exception{
        File shpFile = null;
        File zipFile = getFileFromMultipartFile(shapeFile, ".zip");
        File[] files = ZipUtils.unZip(zipFile, this.uploadDir);
        if (files == null) {
            return null;
        }
        List<Geometry> geoms = null;
        List<Map> fields=null;

        // 解压文件夹名称
        String zipDirFileName = this.uploadDir +File.separator + FilenameUtils.getBaseName(zipFile.getName());;
        File zipDirFile = new File(zipDirFileName);
        // 获取shp文件
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");


        ShapefileDataStore shpDataStore = new ShapefileDataStore(new File(shpFileList.get(0)).toURI().toURL());
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore
                .getFeatureSource(shpDataStore.getTypeNames()[0]);
        //获取图层原始坐标系，转换目标坐标系
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();

        String wkt = sourceCRS.toWKT();
        crsSourceWkt=wkt;


        ShapeOprate shapeOprate = new ShapeOprate();

        if (shpFileList != null && shpFileList.size() > 0) {
            geoms = shapeOprate.readShp(shpFileList.get(0));
        }
        List<String> dbfFileList = FileUtil.findFiles(zipDirFileName, "*.dbf");
        if (dbfFileList != null && dbfFileList.size() > 0) {
            fields = shapeOprate.readDBF(dbfFileList.get(0));
        }
        // 删除解压文件夹
        FileUtil.deleteFileAndDir(zipDirFile);
        GeometryFactory factory = new GeometryFactory();
        List<Polygon> polygons = new ArrayList();
        for(int i = 0; i < geoms.size(); i++){
            CoordinateSystem coordinateSystem = sourceCRS.getCoordinateSystem();
            Set<ReferenceIdentifier> identifiers1 = sourceCRS.getIdentifiers();
            Set<ReferenceIdentifier> identifiers = coordinateSystem.getIdentifiers();
            Iterator<ReferenceIdentifier> iterator = identifiers.iterator();

            Map<String,String> crsDataMap = StrUtil.splitCrsData(coordinateSystem.toString().toLowerCase());
            String crsId = StrUtil.getCrsId(crsDataMap).toString();
            crsSourceCode = "EPSG:" + crsId;
            if(!"4490".equals(crsId)){
                if("file".equals(key)|| "bound".equals(key)){
                   area = area.add(new BigDecimal(geoms.get(i).getArea()));
                }
                polygons = getPolygon(polygons, geoms.get(i), true, factory);
                /*polygons = (Polygon) factory.createPolygon(projectTransform(geoms.get(i).getCoordinates()));*/

            }else{
                if("file".equals(key)|| "bound".equals(key)){
                    area = area.add(new BigDecimal(projectTransform2(geoms.get(i)).getArea()));
                }
                /*polygons[i] = factory.createPolygon(geoms.get(i).getCoordinates());*/
                polygons = getPolygon(polygons, geoms.get(i), false,  factory);
            }

        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private List<Polygon> getPolygon(List<Polygon> polygons, Geometry geometry, boolean transform, GeometryFactory factory) throws Exception{

        if("MultiPolygon".equals(geometry.getGeometryType()) && geometry.getNumGeometries() > 0){
            for(int i = 0; i < geometry.getNumGeometries(); i++){
                polygons = getPolygon(polygons, geometry.getGeometryN(i), transform, factory);
            }


        }else if("Polygon".equals(geometry.getGeometryType())){
            if(transform){
//                polygons.add(factory.createPolygon(projectTransform(geometry.getCoordinates())));
                polygons.add((Polygon)GeoUtils.geoTransform(geometry, crsSourceWkt, "EPSG:4490"));
            }else{
                polygons.add((Polygon) geometry);
            }

        }


        return polygons;
    }


    /**
     * 将MultipartFile转成File
     *
     * @param file
     * @return
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy(is, os);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                os.close();
                is.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return f;
    }

    public Geometry projectTransform2(Geometry geometry) throws FactoryException,
            MismatchedDimensionException, TransformException {

        /*GeometryFactory geoFactory = new GeometryFactory();
        Point sourcePoint = geoFactory.createPoint(coordinate);
        getCoordinateReferenceSystem(coordinate);*/

        CoordinateReferenceSystem crsSource = CRS.decode("EPSG:4490");
        CoordinateReferenceSystem crsTarget = CRS.decode(getEPSG(geometry));
        // 投影转换

        MathTransform transform = CRS.findMathTransform(crsSource, crsTarget);
        geometry = JTS.transform(geometry, transform);

        return geometry;
    }
/*    public Geometry projectTransform(Geometry geometry) throws FactoryException,
            MismatchedDimensionException, TransformException {

        *//*GeometryFactory geoFactory = new GeometryFactory();
        Point sourcePoint = geoFactory.createPoint(coordinate);
        getCoordinateReferenceSystem(coordinate);*//*

        CoordinateReferenceSystem crsSource = CRS.decode(crsSourceCode);
        CoordinateReferenceSystem crsTarget = CRS.decode("EPSG:4490");
        // 投影转换

        MathTransform transform = CRS.findMathTransform(crsSource, crsTarget);
        geometry = JTS.transform(geometry, transform);

        return geometry;
    }*/
    /*public Coordinate[] projectTransform(Coordinate[] coordinates) throws FactoryException,
            MismatchedDimensionException, TransformException {

        for(int i = 0; i < coordinates.length; i++){
            Point sourcePoint = createPoint(coordinates[i].y, coordinates[i].x);

            CoordinateReferenceSystem crsTarget = CRS.decode("EPSG:4490");
            CoordinateReferenceSystem crsSource = CRS.decode(crsSourceCode);
            // 投影转换

            MathTransform transform = CRS.findMathTransform(crsSource, crsTarget);
            Coordinate coordinate = JTS.transform(sourcePoint, transform).getCoordinate();
            coordinates[i] = new Coordinate(coordinate.y,  coordinate.x);
        }


        return coordinates;
    }*/

    public static Point createPoint(double longitude, double latitude){
        GeometryFactory gf = new GeometryFactory();

        Coordinate coord = new Coordinate(longitude, latitude );
        Point point = gf.createPoint( coord );

        return point;
    }

    public String getEPSG(Geometry geometry){
        int srid = 4524;
        try {
            double x = geometry.getCentroid().getX();
            int dh = (int) ((x + 1.5) / 3);
            srid = 4513 + dh - 25;
        }catch (Exception e){
            e.printStackTrace();
        }
        return "EPSG:"+ srid;
    }
}