package com.geoway.landteam.landcloud.service.util;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBiz;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.util.Calendar;

/**
 * @projectName: geoway-landcloud
 * @package: com.geoway.landteam.landcloud.service.util
 * @className: TbbhUtils
 * @author: limihao
 * @description: TODO
 * @date: 2024/8/27 11:11
 * @version: 1.0
 */
@Component
public class TbbhUtils {

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskTaskBizRepository tbtskTaskBizRepository;
    @Autowired
    TbtskTaskClassService tbtskTaskClassService;

    public String getTaskTbbh(String taskId,String regionCode){
        String tbbh = null;
        TbtskTaskBiz tbtskTaskBiz = tbtskTaskBizRepository.findById(taskId).get();
        if (tbtskTaskBiz!=null){
            TbtskTaskClass parentTbtskTaskClass = tbtskTaskClassService.getParentTbtskTaskClass(tbtskTaskBiz.getCalssId());
            if(parentTbtskTaskClass!=null && StringUtils.isNotBlank(parentTbtskTaskClass.getParam())){
                JSONObject param = JSONObject.parseObject(parentTbtskTaskClass.getParam());
                String code = param.getString("code");
                int len = 0;
                String tempCode = code;
                while (tempCode.indexOf("%s")!=-1){
                    len += 1;
                    tempCode = tempCode.substring(tempCode.indexOf("%s")+2);
                }
                if(len > 0 ){
                    for (int i = 1; i <= len; i++) {
                         JSONObject parami =  JSONObject.parseObject(param.getString("param"+i));
                         Integer type = parami.getInteger("type");
                         Integer length = parami.getInteger("length");
                         if(type!=null && length!=null){
                             code =  makeBhByTypeAndLength(taskId,code,regionCode,type,length);
                         }
                    }
                    tbbh = code;
                }
            }
        }
        return tbbh;
    }

    String makeBhByTypeAndLength(String taskId,String code,String regionCode,Integer type,Integer length){
        //行政区代码
        if(type.equals(1)){
            if(regionCode.length()>length){
                regionCode = regionCode.substring(0,length);
            }else if(regionCode.length()<length){
                String ends = "";
                for (int i = 0; i < regionCode.length()-length; i++) {
                    ends += "0";
                }
                regionCode = regionCode + ends;
            }
            code = code.replaceFirst("%s",regionCode);
        }else if(type.equals(2)){
            //年份
            Calendar calendar = Calendar.getInstance();
            String year = calendar.get(Calendar.YEAR) + "";
            int l = year.length()-length;
            if(length==2){
                year = year.substring(l);
            }
            code = code.replaceFirst("%s",year);
        }else if(type.equals(3)){
            //季度
            //年份
            Calendar calendar = Calendar.getInstance();
            int mouth = calendar.get(Calendar.MONTH) + 1;
            int JD = mouth%3 == 0 ? mouth/3 : ((mouth/3) +1);
            String jdStr = "";
            if (length==2){
                jdStr = "0"+ JD;
            }else{
                jdStr = JD + "";
            }
            code = code.replaceFirst("%s",jdStr);
        }else if(type.equals(4)){
            //流水码
            String IndexCode =  "seq_" + taskId + "_" + code.replaceAll("%s","");
            IndexCode = IndexCode.toLowerCase();
            String sql = " select count(1) from pg_class where relname = '" + IndexCode + "'";
            Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
            int num = 0;
            if(count == 0){
                //不存在则创建并返回0
                //不存在则创建
                String sql1 = "CREATE SEQUENCE \"" + IndexCode +"\""+
                        " INCREMENT 1 " +
                        " MINVALUE  1 " +
                        " MAXVALUE 999999 " +
                        " START 1 " +
                        " CACHE 1;";
                jdbcTemplate.execute(sql1);
            }else{
                //存在则获取序列下一个值
                //存在则获取
                String sql1 = " select nextval('" + IndexCode + "')";
                num = jdbcTemplate.queryForObject(sql1, Integer.class);
            }
            String numStr = String.format("%04d", num);
            code = code.replaceFirst("%s",numStr);
        }
        return code;
    }

}
