package com.geoway.landteam.landcloud.service.util;

import org.apache.commons.lang3.tuple.Pair;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.*;

public class TimeUtils {

    public static final String Y = "yyyy-01-01";
    public static final String YM = "yyyy-MM-01";
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMD_CN = "yyyy年MM月dd日";
    public static final String YMD_H = "yyyy-MM-dd HH";
    public static final String YMD_HM = "yyyy-MM-dd HH:mm";
    public static final String YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD_HMS_ZORE = "yyyy-MM-dd 00:00:00";
    public static final String YMD_HMS_ZORE_ZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS Z";

//    public static SimpleDateFormat simpleDateFormat = new SimpleDateFormat();

    public static String dateToString(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat();
        String ymd = "";
        try {
            simpleDateFormat1.applyPattern(pattern);
            ymd = simpleDateFormat1.format(date);
        } catch (Exception e) {
            return "";
        }
        return ymd;
    }

    public static Date StringToDate(String dateStr, String pattern) {
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat();
        Date date = null;
        try {
            simpleDateFormat2.applyPattern(pattern);
            date = simpleDateFormat2.parse(dateStr);
        } catch (ParseException e) {
            if(e instanceof ParseException  && (TimeUtils.YMD_HMS.equals(pattern) || TimeUtils.YMD_HMS_ZORE.equals(pattern))) {
                try {
                    simpleDateFormat2.applyPattern(TimeUtils.YMD);
                    date = simpleDateFormat2.parse(dateStr);
                } catch (ParseException ex) {
                    ex.printStackTrace();
                }
            }
        } catch (Exception e) {

        }
        return date;
    }

    public static Date adapterConvert(String dateStr) {
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat();
        Date date = null;
        try {
            simpleDateFormat3.applyPattern(TimeUtils.YMD_HMS);
            date = simpleDateFormat3.parse(dateStr);
        } catch (ParseException ex) {
            if(ex instanceof ParseException) {
                try {
                    simpleDateFormat3.applyPattern(TimeUtils.YMD_HMS_ZORE);
                    date = simpleDateFormat3.parse(dateStr);
                } catch (ParseException ex1) {
                    if(ex1 instanceof ParseException) {
                        try {
                            simpleDateFormat3.applyPattern(TimeUtils.YMD);
                            date = simpleDateFormat3.parse(dateStr);
                        } catch (ParseException ex2) {

                        }
                    }
                }
            }
        } catch (Exception e) {

        }
        return date;
    }



    /**
     * day = 0  => 获取今日凌晨0点0分0秒
     * day = 1  => 获取明日凌晨0点0分0秒
     * day = -1 => 获取昨日凌晨0点0分0秒
     * @param day
     * @return
     */
    public static Date getTodayDate(int day) {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE,day);
        cal.set(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH),
                cal.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        Date todayOfDate = cal.getTime();
        return todayOfDate;
    }


    // 如果今天是周一， 那么近一周是上周一到周日
    // 如果今天不是周一， 那么近一周是从本周一到昨天
    public static Pair<Date, Date> getNearOneWeek() {
        Calendar.getInstance().getFirstDayOfWeek();
        Date startDate = null;
        Date endDate = null;
        // 如果今天周一，那么近一周是上周一到周五
        int dayNumberOfWeek = Calendar.getInstance().get(Calendar.DAY_OF_WEEK);
        if(dayNumberOfWeek == 2 ) {
            // 获取上周的日期
            endDate = TimeUtils.getTodayDate(0);
            startDate = TimeUtils.getTodayDate(-7);
        } else {
            endDate = TimeUtils.getTodayDate(0);
            startDate = TimeUtils.getTodayDate(2-dayNumberOfWeek);
        }
        return Pair.of(startDate, endDate);
    }

    /**
     * 获取n天前
     * @return
     */
    public static Pair<Date, Date> getDayBefore(int n) {
        Date endDate = TimeUtils.getTodayDate(0);
        Date startDate = TimeUtils.getTodayDate(-n);
        return Pair.of(startDate, endDate);
    }


    // 如果今天不是周一， 那么近一周是从本周一到昨天
    public static Date getNowWeekStartTime() {
        Date startDate = null;
        // 如果今天周一，那么近一周是上周一到周五
        int dayNumberOfWeek = Calendar.getInstance().get(Calendar.DAY_OF_WEEK);
        if(dayNumberOfWeek == 2 ) {
            // 获取上周的日期
            startDate = TimeUtils.getTodayDate(0);
        } else {
            startDate = TimeUtils.getTodayDate(2-dayNumberOfWeek);
        }
        return startDate;
    }


    /**
     * 如果今天是 1号， 那么近一个月是 上月，  如果今天不是1号，那么近一个月是本月1号到今日凌晨
     * @return
     */
    public static Pair<Date, Date> getNearOneMonth() {
        Date startDate = null;
        Date endDate = null;
        // 判断今天是不是1号， 如果是1号，那么最近一个月是上个月，  如果不是那么最近一个月就是本月1号到今日凌晨
        int i = Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
        if(i == 1) {
            startDate = getLastMonthStartTime(-1);
            endDate = TimeUtils.getTodayDate(0);
        } else {
            startDate = TimeUtils.getTodayDate(1 - i);
            endDate = TimeUtils.getTodayDate(0);
        }
        return Pair.of(startDate, endDate);
    }

    /**
     * 如果今天是 1号， 那么近一个月是 上月，  如果今天不是1号，那么近一个月是本月1号到今日凌晨
     * @return
     */
    public static Pair<Date, Date> getNearThreeMonth() {
        Date startDate = null;
        Date endDate = null;
        // 判断今天是不是1号， 如果是1号，那么最近一个月是上个月，  如果不是那么最近一个月就是本月1号到今日凌晨
        int i = Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
        if(i == 1) {
            startDate = getLastMonthStartTime(-3);
            endDate = TimeUtils.getTodayDate(0);
        } else {
            startDate = getLastMonthStartTime(-2);
            endDate = TimeUtils.getTodayDate(0);
        }
        return Pair.of(startDate, endDate);
    }


    public static Date getLastMonthStartTime(int i) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();// 获取当前日期
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(Calendar.YEAR, 0);
        calendar.add(Calendar.MONTH, i);
        calendar.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    public static Date getLastMonthEndTime(int i) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();// 获取当前日期
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(Calendar.YEAR, 0);
        calendar.add(Calendar.MONTH, i);
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return calendar.getTime();
    }


    public static Pair<String, String> getLastNatureWeek() {
        Calendar c = Calendar.getInstance();
        c.set(Calendar.DAY_OF_WEEK,Calendar.MONDAY);
        Date endTime = c.getTime();
        c.add(Calendar.DATE, -7);
        Date startTime = c.getTime();
        return Pair.of(TimeUtils.dateToString(startTime, TimeUtils.YMD_HMS_ZORE), TimeUtils.dateToString(endTime, TimeUtils.YMD_HMS_ZORE));
    }



    public static Date getThisWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        // 获得当前日期是一个星期的第几天
        int dayWeek = cal.get(Calendar.DAY_OF_WEEK);
        if (1 == dayWeek) {
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        // 设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        // 获得当前日期是一个星期的第几天
        int day = cal.get(Calendar.DAY_OF_WEEK);
        // 根据日历的规则，给当前日期减去星期几与一个星期第一天的差值
        cal.add(Calendar.DATE, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getNextWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getThisWeekMonday(date));
        cal.add(Calendar.DATE, 7);
        return cal.getTime();
    }


    public static List<Date> getOneDayDayListBetween(Date startDate, Date endDate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        List<Date> list = new ArrayList<>();
        list.add(instance.getTime());
        while (!instance.getTime().toString().equals(endDate.toString())) {
            instance.add(Calendar.DAY_OF_MONTH, 1);
            list.add(instance.getTime());
        }
        return list;
    }


    /**
     * 不包含本周(时间倒序，最近的时间在前边)
     * @param i
     * @return
     */
    public static List<Pair<String, String>> getLastNatureWeekList(int i, String applyType) {
        List<String> timeList = new ArrayList<>();
        Calendar c = Calendar.getInstance();
        c.set(Calendar.DAY_OF_WEEK,Calendar.MONDAY);
        Date endTime = c.getTime();
        String s = TimeUtils.dateToString(endTime, applyType);
        timeList.add(s);
        for (int j = 1; j <= i; j++) {
            c.add(Calendar.DATE, -7);
            Date time = c.getTime();
            String s1 = TimeUtils.dateToString(time, applyType);
            timeList.add(s1);
        }
        List<Pair<String, String>> pairs = new ArrayList<>();
        Collections.reverse(timeList);
        for (int i1 = 0; i1 < timeList.size() - 1; i1++) {
            pairs.add(Pair.of(timeList.get(i1), timeList.get(i1 + 1)));
        }
        return pairs;
    }

    public static Pair<Date, Date> getNearOneYear() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH) + 1;
        int day = cal.get(Calendar.DATE);
        if(month == 1 && day == 1) {
            Timestamp beginTime = Timestamp.valueOf(LocalDateTime.of(year - 1, 1, 1, 0, 0, 1));
            Timestamp endTime = Timestamp.valueOf(LocalDateTime.of(year - 1, 12, 31, 23, 59, 59));
            Date startDate = new Date(beginTime.getTime());
            Date endDate = new Date(endTime.getTime());
            return Pair.of(startDate, endDate);
        } else {
            Timestamp beginTime = Timestamp.valueOf(LocalDateTime.of(year, 1, 1, 0, 0, 1));
            Date startDate = new Date(beginTime.getTime());
            Date endDate = TimeUtils.getTodayDate(0);
            return Pair.of(startDate, endDate);
        }
    }



    public static Pair<String, String> getNearWeekByDate(Date time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        // 判断要计算的日期是否是周日，如果是则减一天计算周六的，否则会出问题，计算到下一周去了
        int dayWeek = cal.get(Calendar.DAY_OF_WEEK);// 获得当前日期是一个星期的第几天
        if(1 == dayWeek) {
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        cal.setFirstDayOfWeek(Calendar.MONDAY);// 设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        int day = cal.get(Calendar.DAY_OF_WEEK);// 获得当前日期是一个星期的第几天
        cal.add(Calendar.DATE, cal.getFirstDayOfWeek() - day);// 根据日历的规则，给当前日期减去星期几与一个星期第一天的差值
        Date startDate = cal.getTime();
        cal.add(Calendar.DATE, 6);
        Date endDate = cal.getTime();
        return Pair.of(TimeUtils.dateToString(startDate, TimeUtils.YMD), TimeUtils.dateToString(endDate, TimeUtils.YMD));
    }

    /**
     * 获取近 i 周
     * @param i
     * @return
     */
    public static List<Pair<String, String>> getNearWeekList(int i, String applyType) {

        List<Pair<String, String>> lastNatureWeekList = new ArrayList<>();
        Calendar cal = Calendar.getInstance();
        int weekday = cal.get(Calendar.DAY_OF_WEEK);
        if(weekday == 2) {
            // 如果今天是周一
            lastNatureWeekList = TimeUtils.getLastNatureWeekList(i, applyType);
        } else {
            if(i == 1) {
                Pair<Date, Date> nearOneWeek = TimeUtils.getNearOneWeek();
                lastNatureWeekList.add(Pair.of(TimeUtils.dateToString(nearOneWeek.getLeft(), TimeUtils.YMD), TimeUtils.dateToString(nearOneWeek.getRight(), TimeUtils.YMD)));
            } else {
                lastNatureWeekList = TimeUtils.getLastNatureWeekList(i - 1, applyType);
                Pair<String, String> of = Pair.of(lastNatureWeekList.get(lastNatureWeekList.size() - 1).getRight(),
                        TimeUtils.dateToString(new Date(), applyType));
                lastNatureWeekList.add(of);
            }
        }
        return lastNatureWeekList;
    }

    /**
     * 获取近 i 月 (   applyType = "yyyy-MM-01";)
     * @param i
     * @return
     */
    public static List<Pair<String, String>> getNearMonthList(int i, String applyType) {
        List<String> timeList = new ArrayList<>();
        Calendar cal = Calendar.getInstance();
        int dayOfMonth = cal.get(Calendar.DAY_OF_MONTH);
        if(dayOfMonth == 1) {
            // 获取前i个月
            for (int j = i; j >= 1; j--) {
                cal.add(Calendar.MONTH, -1);
                Date time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
        } else {
            // 获取前i-1个月 + 本月
            for (int j = i - 1; j >= 1 ; j--) {
                cal.add(Calendar.MONTH, -1);
                Date time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
            timeList.add(TimeUtils.dateToString(new Date(), TimeUtils.YMD));
        }
        List<Pair<String, String>> pairs = new ArrayList<>();
        for (int i1 = 0; i1 < timeList.size() - 1; i1++) {
            pairs.add(Pair.of(timeList.get(i1), timeList.get(i1 + 1)));
        }
        return pairs;
    }

    public static List<Pair<String, String>> getNearYearList(int i, String applyType) {
        List<String> timeList = new ArrayList<>();
        Calendar cal = Calendar.getInstance();
        int monthOfYear = cal.get(Calendar.MONTH);
        int dayOfMonth = cal.get(Calendar.DAY_OF_MONTH);
        if(dayOfMonth == 1 && monthOfYear == 1) {
            // 获取前i个月
            for (int j = i; j >= 1; j--) {
                cal.add(Calendar.YEAR, -1);
                Date time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
        } else {
            // 获取前i-1个月 + 本月
            for (int j = i - 1; j >= 1 ; j--) {
                cal.add(Calendar.YEAR, -1);
                Date time = cal.getTime();
                timeList.add(TimeUtils.dateToString(time, applyType));
            }
            Collections.reverse(timeList);
            timeList.add(TimeUtils.dateToString(new Date(), applyType));
            timeList.add(TimeUtils.dateToString(new Date(), TimeUtils.YMD));
        }
        List<Pair<String, String>> pairs = new ArrayList<>();
        for (int i1 = 0; i1 < timeList.size() - 1; i1++) {
            pairs.add(Pair.of(timeList.get(i1), timeList.get(i1 + 1)));
        }
        return pairs;
    }

    /**
     * 根据时间类型获取当前时间对应的完整周期    year获取时间所在的一整年，  month获取时间所在的一整月， week获取时间所在的一整周
     * @param date
     * @param type
     * @return
     */
    public static Pair<Date, Date> getCompleteTimePeroid(Date date, String type) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        int year = instance.get(Calendar.YEAR);
        int month = instance.get(Calendar.MONTH);
        Date startDate = null;
        Date endDate = null;
        switch (type) {
            case "year":
                instance.set(year, 0, 1);
                startDate = instance.getTime();
                instance.set(year, 11, 31);
                endDate = instance.getTime();
                break;
            case "month":
                instance.set(year, month, 1);
                startDate = instance.getTime();
                int maximum = instance.getActualMaximum(Calendar.DAY_OF_MONTH);
                instance.set(year, month, maximum);
                endDate = instance.getTime();
                break;
            case "week":
                int dayOfWeek = instance.get(Calendar.DAY_OF_WEEK);
                if(dayOfWeek == 1) {
                    // 如果是在周日
                    endDate = instance.getTime();
                    instance.add(Calendar.DATE, -6);
                    startDate = instance.getTime();
                } else {
                    instance.add(Calendar.DATE, 2 - dayOfWeek);
                    startDate = instance.getTime();
                    instance.add(Calendar.DATE, 6);
                    endDate = instance.getTime();
                }
                break;
            default:
                break;
        }
        return Pair.of(startDate, endDate);
    }

    public static List<Pair<String, String>> getLastNatureWeekListFromTime(Date startTime) {
        List<Pair<String, String>> list = new ArrayList<>();
        Calendar instance = Calendar.getInstance();
        for (int i = 1; i <= 5; i++) {
            instance.setTime(startTime);
            instance.add(Calendar.DAY_OF_YEAR, -7 * (i - 1));
            Date time = instance.getTime();
            Pair<String, String> nearWeekByDate = getNearWeekByDate(time);
            list.add(nearWeekByDate);
        }
        Collections.reverse(list);
        return list;
    }

    public static Pair<Date, Date> getCompleteWeekByDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        // 获得当前日期是一个星期的第几天
        int dayWeek = cal.get(Calendar.DAY_OF_WEEK);
        if (1 == dayWeek) {
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        // 设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        // 获得当前日期是一个星期的第几天
        int day = cal.get(Calendar.DAY_OF_WEEK);
        // 根据日历的规则，给当前日期减去星期几与一个星期第一天的差值
        cal.add(Calendar.DATE, cal.getFirstDayOfWeek() - day);
        Date startDate = cal.getTime();
        cal.add(Calendar.DATE, 7);
        Date endDate = cal.getTime();
        return Pair.of(TimeUtils.StringToDate(TimeUtils.dateToString(startDate, TimeUtils.YMD_HMS_ZORE), TimeUtils.YMD_HMS_ZORE),
                TimeUtils.StringToDate(TimeUtils.dateToString(endDate, TimeUtils.YMD_HMS_ZORE), TimeUtils.YMD_HMS_ZORE));
    }


    public static long getDifferDays(Date startDate, Date endDate) throws Exception {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        if(startTime > endTime) {
            throw new Exception("开始日期必须比结束日期大");
        }
        double days = (endTime - startTime) * 1.0 / 24 / 60 / 60 / 1000;
        double ceil = Math.ceil(days);
        return (long) ceil;
    }



    public static void main(String[] args) throws Exception {
//        Date todayDate = getTodayDate(0);
//        Date todayDate1 = getTodayDate(1);
//        Date todayDate2 = getTodayDate(-1);
//        Date todayDate3 = getTodayDate(-2);
        convertDateAndTimeFromOther("1710916575824");
        Pair<Date, Date> huanBiDate = getHuanBiDate("2023-10-09 00:00:00", "2023-10-15 00:00:00");
        System.out.println(huanBiDate);

        long differDays = getDifferDays(TimeUtils.StringToDate("2023-10-10 00:00:00", TimeUtils.YMD_HMS), TimeUtils.StringToDate("2023-10-15 00:00:00", TimeUtils.YMD_HMS));
        System.out.println(differDays);

        Pair<Date, Date> completeWeekByDate = getCompleteWeekByDate(TimeUtils.StringToDate("2023-10-15 23:59:59", TimeUtils.YMD_HMS));
        System.out.println(completeWeekByDate);

        Date date = StringToDate("2023-06-11T16:00:00.000Z", "yyyy-MM-ddTHH:mm:ssZ");
        System.out.println("---------------");

        Pair<String, String> nearWeekByDate1 = getNearWeekByDate(TimeUtils.StringToDate("2023-03-12 23:59:59", TimeUtils.YMD_HMS));

        List<Pair<String, String>> lastNatureWeekListFromTime = getLastNatureWeekListFromTime(TimeUtils.StringToDate("2022-11-11 00:00:00", TimeUtils.YMD_HMS_ZORE));
        Pair<Date, Date> completeTimePeroid = getCompleteTimePeroid(TimeUtils.StringToDate("2021-2-7 00:00:00", TimeUtils.YMD_HMS), "week");
        Pair<String, String> nearWeekByDate = getNearWeekByDate(new Date());
        List<Pair<String, String>> nearYearList = getNearYearList(4, TimeUtils.Y);
        List<Pair<String, String>> nearMonthList = getNearMonthList(4, TimeUtils.YM);
        List<Pair<String, String>> nearWeekList = getNearWeekList(4, TimeUtils.YMD);
        Pair<Date, Date> nearOneYear = getNearOneYear();
        getNearOneWeek();
        getNearOneMonth();
        getNearThreeMonth();
        List<Pair<String, String>> lastNatureWeekList = getLastNatureWeekList(3, TimeUtils.YMD);
        System.out.println("--------------------");
        System.out.println(getLastNatureWeek());
//        System.out.println(geLastWeekMonday());
        String startTime = "2022-06-01 00:00:00";
        String endTime = "2022-08-31 00:00:00";
        getOneDayDayListBetween(StringToDate(startTime, YMD_HMS_ZORE), StringToDate(endTime, YMD_HMS_ZORE));
    }

    public static Pair<Date, Date> getHuanBiDate(String startTime, String endTime) throws Exception {
        Date startDate = TimeUtils.StringToDate(startTime, TimeUtils.YMD_HMS);
        Date endDate = TimeUtils.StringToDate(endTime, TimeUtils.YMD_HMS);
        int differDays = (int)TimeUtils.getDifferDays(startDate, endDate);
        Calendar instance = Calendar.getInstance();
        instance.setTime(startDate);
        instance.add(Calendar.DAY_OF_MONTH, -differDays);
        Date resStartDate = instance.getTime();
        instance.setTime(endDate);
        instance.add(Calendar.DAY_OF_MONTH, -differDays);
        Date resEndDate = instance.getTime();
        return Pair.of(resStartDate, resEndDate);
    }

    public static String convertDateAndTimeFromOther(String time) {
        try {
            long l = Long.parseLong(time);
            if(time.length() == 10) {
                l = l * 1000;
            }
            Date date = new Date(l);
            return TimeUtils.dateToString(date, TimeUtils.YMD_HMS);
        } catch (NumberFormatException e) {
            return time;
        }
    }
}