package com.geoway.landteam.landcloud.service.util;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.gw.base.Gw;
import org.springframework.http.*;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.util
 * @date 2023/5/12 9:26
 */
public class UserAuthHttpUtils {


    public JSONObject postJson(String url,String clientIdEncode,String clientSecretEncode, Map<String, Object>  params) throws Exception {
        RestTemplate restTemplate = getRestTemplate();
        String auth = HttpHeaders.encodeBasicAuth(clientIdEncode, clientSecretEncode, StandardCharsets.UTF_8);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization","Basic " + auth);
        final MediaType contentType = MediaType.valueOf(MediaType.APPLICATION_FORM_URLENCODED_VALUE + ";charset=UTF-8");
        headers.setContentType(contentType);
        /*headers.setContentType(MediaType.APPLICATION_JSON);*/
        HttpEntity<String> requestEntity = new HttpEntity<>(JSONObject.toJSONString(params), headers);
        ResponseEntity<JSONObject> res = restTemplate.exchange(url, HttpMethod.POST, requestEntity, JSONObject.class);
        return res.getBody();
    }


    public static JSONObject accesstoken(String url,String clientIdEncode,String clientSecretEncode, String
            grant_type, String username, String password) {
        RestTemplate restTemplate = new RestTemplate();
        String auth = HttpHeaders.encodeBasicAuth(clientIdEncode, clientSecretEncode, StandardCharsets.UTF_8);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization","Basic " + auth);
        final MediaType contentType = MediaType.valueOf(MediaType.APPLICATION_FORM_URLENCODED_VALUE + ";charset=UTF-8");
        headers.setContentType(contentType);
        MultiValueMap<String,Object> params = new LinkedMultiValueMap<>();
            params.add("grant_type", grant_type);
            params.add("username", username);
            params.add("password", password);
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<MultiValueMap<String, Object>>(params,headers);
        ResponseEntity<JSONObject> res = restTemplate.postForEntity(url, formEntity, JSONObject.class);
        return res.getBody();
    }

    public static JSONObject oauth2Revoke(String url,String clientIdEncode,String clientSecretEncode, String tokenValue) {
        RestTemplate restTemplate = new RestTemplate();
        String auth = HttpHeaders.encodeBasicAuth(clientIdEncode, clientSecretEncode, StandardCharsets.UTF_8);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization","Basic " + auth);
        final MediaType contentType = MediaType.valueOf(MediaType.APPLICATION_FORM_URLENCODED_VALUE + ";charset=UTF-8");
        headers.setContentType(contentType);
        MultiValueMap<String,Object> params = new LinkedMultiValueMap<>();
        params.add("token", tokenValue);
        HttpEntity<MultiValueMap<String, Object>> formEntity  = new HttpEntity<MultiValueMap<String, Object>>(params,headers);
        ResponseEntity<JSONObject> res = restTemplate.postForEntity(url, formEntity, JSONObject.class);
        Gw.log.info("向认证服务器注销accessToken完毕");
        return res.getBody();
    }


    public static JSONObject getUserInfo(String url,String accessToken) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(new HttpComponentsClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization","Bearer "+accessToken);
        Map<String, Object> map = new HashMap<>();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        HttpEntity<String> formEntity = new HttpEntity<String>(JSONObject.toJSONString(map),headers);
        ResponseEntity<JSONObject> res = restTemplate.exchange(url, HttpMethod.GET, formEntity, JSONObject.class);
        return res.getBody();
    }

    public static JSONObject accessAppsInterface(String url,Map<String, Object> params) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(new HttpComponentsClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        HttpEntity<Map<String, Object>> formEntity = new HttpEntity<Map<String, Object>>(params,headers);
       /* ResponseEntity<JSONObject> res = restTemplate.exchange(url, HttpMethod.POST, formEntity, JSONObject.class);*/
        ResponseEntity<JSONObject> res = restTemplate.exchange(url, HttpMethod.POST, formEntity, JSONObject.class,params);
        return res.getBody();
    }

    public static JSONObject accessCommonInterface(String url,MultiValueMap<String,Object> params,String accessToken) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setRequestFactory(new HttpComponentsClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("Authorization","Bearer "+accessToken);
        RequestEntity requestEntity = RequestEntity
                .post(url) // 可以不填
                .contentType(MediaType.APPLICATION_FORM_URLENCODED) // 参数传输类型 url编码格式 application/x-www-form-urlencoded
                .accept(MediaType.ALL).acceptCharset(StandardCharsets.UTF_8)
                .header("Authorization","Bearer "+accessToken)
                .body(params);
        //基于注解映射对应实体
        ResponseEntity<JSONObject> res = restTemplate.postForEntity(url, requestEntity, JSONObject.class);
        return res.getBody();
    }


   /* public static void main(String[] args) {
        String url = "http://localhost:9118/platform-ws/res3/apps/getAppByAppId1?appId={appId}&stateActive={stateActive}";
        String clientIdEncode = "e2fa7e64-249b-46f0-ae1d-797610e88615";
        String clientSecretEncode = "secret";
        String grant_type = "password";
        String username = "admin";
        String password = "123456";
        MultiValueMap<String,Object> params = new LinkedMultiValueMap<>();
        params.add("appId","5f1e9dbc461544b1b2a7d7fc702d891e");
        params.add("stateActive",1);
        Map<String,Object> map=new HashMap<>();
        map.put("appId","5f1e9dbc461544b1b2a7d7fc702d891e");
        map.put("stateActive",1);
       *//* JSONObject accesstoken = accesstoken(url, clientIdEncode, clientSecretEncode, grant_type, username, password);*//*
        JSONObject accesstoken = accessAppsInterface(url, map);
        System.out.println(accesstoken);
    }*/
    public static void main(String[] args) {
        String url = "http://business.cqlandcloud.org.cn/platform-ws/res3/user/registerUser";
   //参数
        MultiValueMap<String,Object> params = new LinkedMultiValueMap<>();
        params.add("email","");
        params.add("orgId","zzb45479-79b0-4811-868d-ead649602847");
        params.add("phoneNumber","15671641612");
        params.add("regionCode","500000");
        params.add("userName","11");
        params.add("encryptionPassword","{MD5}573e025d2f798421d838a31222792343");
        JSONObject accesstoken = accessCommonInterface(url, params,"Bearer eyJ4NXQjUzI1NiI6IlN4cXFkV1l4VDdCWnJkSC11VnBnQUhmWDJxMzRxUHl4eDRvblg2bXYtcUkiLCJraWQiOiJqb3NlIiwiYWxnIjoiUlMyNTYifQ.eyJzdWIiOiIyYjk1NmNlYjM1ZjA0ZTNiYTZlM2Q0NzNmN2U1MWI4OCIsImF1ZCI6IjJiOTU2Y2ViMzVmMDRlM2JhNmUzZDQ3M2Y3ZTUxYjg4IiwibmJmIjoxNjkzNTU4MTk1LCJzY29wZSI6WyJ1c2VyaW5mbyJdLCJhcHBJZCI6IjU0YmM2M2U4MWUyYjRkYTc5MDY0ZjI4YjQzMDk2ODQ3IiwiaXNzIjoiaHR0cDpcL1wvYnVzaW5lc3MuY3FsYW5kY2xvdWQub3JnLmNuXC9nYXMiLCJleHAiOjE2OTQ0MjIxOTUsImlhdCI6MTY5MzU1ODE5NX0.Y9eKY9Wvfk9tE9x_xKEJPYOw7jbI-YRvyaMRG8r4rLUhTJSgwTMiCxf9uQMXLnExjM99-UqPkw_CNeWUi5LxlmhZFA07u4YU_AWP82A0er1IU-Otq6O49sJGBgbinpTZogCt5CXt8XABoT4L57ObZyq9Wv_ZWOmW6LnbK8ZjGUzXSoXmQ1YZ9nXw_h2gr5k8_5woJZn5DHfypZ4V-eZZQ-DqgBDR9g27bk3niOO4DHWi0X_LZ8jDHLU4bcwI8WoWNrgHtrL-kR2R2Cy3eUAUwIjZT54k5XZReXmTh0TL5hJ_jvRNUFBnfT1y0_920bXxmieO6nKy_0P48mRloldegg");
        System.out.println(accesstoken);
    }
    private RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        List<HttpMessageConverter<?>> converters = restTemplate.getMessageConverters();
        if (converters != null && !converters.isEmpty()) {
            for (int i = 0; i < converters.size(); i++) {
                if (converters.get(i) instanceof StringHttpMessageConverter) {
                    // 更改字符集， 解决中文乱码问题，
                    StringHttpMessageConverter converter = (StringHttpMessageConverter) converters.get(i);
                    converter.setDefaultCharset(Charset.forName("UTF-8"));
                    break;
                }
            }
        }
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }



}
