package com.geoway.landteam.landcloud.service.util;

import org.springframework.data.redis.core.RedisTemplate;

import java.util.concurrent.TimeUnit;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.util
 * @date 2023/5/11 11:08
 */
public class UserRedisSessionUtil {

    public static final Long USERNAME_LOCK_OUTTIME = 600L;

    public static Boolean checkUserNameLock(RedisTemplate redisTemplate, String userName) {
        Boolean tag = false;
        String key = "UserName" + userName;
        if (redisTemplate.hasKey(key)) {
            Long num = redisTemplate.opsForSet().size(key);
            if (num >= 4L) {
                tag = true;
            } else {
                num = num + 1L;
                redisTemplate.opsForSet().add(key, new Object[]{num.toString()});
            }
        } else {
            redisTemplate.opsForSet().add(key, new Object[]{"1"});
            redisTemplate.expire(key, USERNAME_LOCK_OUTTIME, TimeUnit.SECONDS);
        }

        return tag;
    }

    public static void removeUserNameLock(RedisTemplate redisTemplate, String userName) {
        String key = "UserName" + userName;
        if (redisTemplate.hasKey(key)) {
            redisTemplate.delete(key);
        }

    }

    public static Long getUserNameLockNum(RedisTemplate redisTemplate, String userName) {
        Long num = 0L;
        String key = "UserName" + userName;
        if (redisTemplate.hasKey(key)) {
            num = redisTemplate.opsForSet().size(key);
        }

        return num;
    }
}
