package com.geoway.landteam.landcloud.service.util.code;

import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class SM3Utils {
    public SM3Utils() {
    }

    public static String sm3(byte[] data) {
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data, 0, data.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode(md));
        return s.toUpperCase();
    }

    public static String sm3(String data) {
        byte[] md = new byte[32];
        byte[] msg1 = data.getBytes(StandardCharsets.UTF_8);
        SM3Digest sm3 = new SM3Digest();
        sm3.update(msg1, 0, msg1.length);
        sm3.doFinal(md, 0);
        String s = new String(Hex.encode(md));
        return s.toUpperCase();
    }

    public static String sm3(InputStream data) throws IOException {
        int bufferLength = 8096;
        byte[] buffer = new byte[bufferLength];
        byte[] md = new byte[32];
        SM3Digest sm3Digest = new SM3Digest();

        int read;
        while((read = data.read(buffer, 0, bufferLength)) > -1) {
            sm3Digest.update(buffer, 0, read);
        }

        sm3Digest.doFinal(md, 0);
        String s = new String(Hex.encode(md));
        return s.toUpperCase();
    }

    public static String sm3(File dataFile) throws IOException {
        FileInputStream fis = null;

        String var2;
        try {
            fis = new FileInputStream(dataFile);
            var2 = sm3((InputStream)fis);
        } catch (IOException var11) {
            var11.printStackTrace();
            throw new IOException("文件读取异常");
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException var10) {
                    var10.printStackTrace();
                }
            }

        }

        return var2;
    }
}