package com.geoway.landteam.landcloud.service.util.excel;

import lombok.Getter;

@Getter
public enum EnumTextLocation {

    left(0,"居左"),
    right(1,"居右"),
    middle(2,"居中");

    private String name;
    private Integer code;
    EnumTextLocation(Integer code, String name)
    {
        this.name = name;
        this.code = code;
    }
    public static EnumTextLocation getValue(Integer code) {
        EnumTextLocation[] enums = values();
        for (EnumTextLocation ve : enums) {
            if (ve.getCode().equals(code)) {
                return ve;
            }
        }
        return null;
    }
    public static EnumTextLocation getValue(String name) {
        EnumTextLocation[] enums = values();
        for (EnumTextLocation ve : enums) {
            if (ve.getName().equals(name)) {
                return ve;
            }
        }
        return null;
    }
}
