package com.geoway.landteam.landcloud.service.util.excel;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.gw.base.util.GutilAssert;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.*;

import java.io.*;
import java.lang.Boolean;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


public class ExcelUtil {

    private static final String XLS = "xls";
    private static final String XLSX = "xlsx";
    private static final DateFormat FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static WritableWorkbook CreateExcel(String tempFilePath, String fileName) throws Exception {
        String filePath = tempFilePath + "/" + fileName;
        File file = new File(filePath);

        WritableWorkbook wwb = Workbook.createWorkbook(file);
        return wwb;
    }
    public static XSSFWorkbook CreateXSSExcel() throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        return workbook;
    }

    public static SXSSFWorkbook CreateSXSSExcel() throws Exception {
        SXSSFWorkbook  workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
        //压缩临时文件，很重要，否则磁盘很快就会被写满
        workbook.setCompressTempFiles(true);
        return workbook;
    }
    public static XSSFSheet createSheet(XSSFWorkbook wwb,String sheetName)
    {
        XSSFSheet sheet = wwb.createSheet(sheetName);
        return sheet;
    }
    public static WritableSheet createSheet(WritableWorkbook wwb,String sheetName, int sheetIndex)
    {
        WritableSheet sheet = wwb.createSheet(sheetName, sheetIndex);
        return sheet;
    }

    public static Sheet createSheet(SXSSFWorkbook wwb,String sheetName)
    {
        Sheet sheet = wwb.createSheet(sheetName);
        return sheet;
    }
    public static void write(WritableSheet sheet,List<ExcelRowData>rows) throws WriteException {
        if (rows != null) {
            for (ExcelRowData row:rows) {
                List<ExcelColData>cols = row.getColDataList();
                for(ExcelColData col:cols)
                {
                    if(col.isSkip())
                    {
                        continue;
                    }
                    WritableFont font= new WritableFont(WritableFont.ARIAL,col.getFontSize(),col.isBold()?WritableFont.BOLD:WritableFont.NO_BOLD);
                    WritableCellFormat wcf = new WritableCellFormat(font);

                    wcf.setAlignment(getAlignment(col.getTextLocation()));
                    wcf.setVerticalAlignment(VerticalAlignment.CENTRE);
                    wcf.setWrap(true);
                    wcf.setBorder(Border.ALL, BorderLineStyle.THIN);
                    sheet.addCell(new Label(col.getColIndex(), row.getRowIndex(),col.getValue(),wcf));
                    if(col.isMergeCell())
                    {
                        sheet.mergeCells(col.getStartCol(),col.getStartRow(),col.getEndCol(),col.getEndRow());
                    }
                }

            }
        }
    }
    public static void write(XSSFSheet sheet,List<ExcelRowData>rows) throws WriteException {
        if (rows != null) {
            for (ExcelRowData row:rows) {
                XSSFRow xrow = sheet.createRow(row.getRowIndex());
                List<ExcelColData>cols = row.getColDataList();
                for(ExcelColData col:cols)
                {
                    if(col.isSkip())
                    {
                        continue;
                    }
                    XSSFWorkbook workbook = sheet.getWorkbook();
                    XSSFCellStyle cellStyle=  workbook.createCellStyle();
                    XSSFFont font = workbook.createFont();
                    font.setBold(col.isBold());
                    font.setFontHeightInPoints((short) col.getFontSize());
                    cellStyle.setAlignment(getHorizontalAlignment(col.getTextLocation()));
                    cellStyle.setVerticalAlignment(org.apache.poi.ss.usermodel.VerticalAlignment.CENTER);
                    cellStyle.setFont(font);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    XSSFCell xcell  = xrow.createCell(col.getColIndex());
                    xcell.setCellValue(col.getValue());
                    xcell.setCellStyle(cellStyle);
                    if(col.isMergeCell())
                    {
                        CellRangeAddress range = new CellRangeAddress(col.getStartRow(),col.getEndRow(),col.getStartCol(),col.getEndCol());
                        sheet.addMergedRegion(range);
                    }

                }

            }
        }
    }

    public static void write(Sheet sheet,List<ExcelRowData>rows) throws WriteException {
        if (rows != null) {
            for (ExcelRowData row:rows) {
                Row xrow = sheet.createRow(row.getRowIndex());
                if(row.getRowHeight()>0)
                {
                    xrow.setHeightInPoints(row.getRowHeight());
                }
                List<ExcelColData>cols = row.getColDataList();
                for(ExcelColData col:cols)
                {
                    if(col.isSkip())
                    {
                        continue;
                    }
                    CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
                    Font font = sheet.getWorkbook().createFont();
                    font.setBold(col.isBold());
                    font.setFontHeightInPoints((short) col.getFontSize());
                    cellStyle.setFont(font);
                    cellStyle.setWrapText(true);
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    cellStyle.setVerticalAlignment(org.apache.poi.ss.usermodel.VerticalAlignment.CENTER);
                    cellStyle.setFont(font);
                    cellStyle.setBorderTop(BorderStyle.THIN);
                    cellStyle.setBorderBottom(BorderStyle.THIN);
                    cellStyle.setBorderLeft(BorderStyle.THIN);
                    cellStyle.setBorderRight(BorderStyle.THIN);
                    if(col.getColor()!=null) {
                        cellStyle.setFillForegroundColor(col.getColor());
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    Cell xcell  = xrow.createCell(col.getColIndex());
                    xcell.setCellValue(col.getValue());
                    xcell.setCellStyle(cellStyle);

                    if(col.isMergeCell())
                    {
                        CellRangeAddress range = new CellRangeAddress(col.getStartRow(),col.getEndRow(),col.getStartCol(),col.getEndCol());
                        sheet.addMergedRegion(range);
                    }
                }

            }
        }
    }
    private static Alignment getAlignment(EnumTextLocation textLocation)
    {
        switch (textLocation)
        {
            case left:
                return Alignment.LEFT;
            case right:
                return Alignment.RIGHT;
            case middle:
                return Alignment.CENTRE;
            default:
                return Alignment.CENTRE;
        }
    }
    private static HorizontalAlignment getHorizontalAlignment(EnumTextLocation textLocation)
    {
        switch (textLocation)
        {
            case left:
                return HorizontalAlignment.LEFT;
            case right:
                return HorizontalAlignment.RIGHT;
            case middle:
                return HorizontalAlignment.CENTER;
            default:
                return HorizontalAlignment.CENTER;
        }
    }
    private static short getHorizontalAlignmentIndex(EnumTextLocation textLocation)
    {
        switch (textLocation)
        {
            case left:
                return 1;
            case right:
                return 3;
            case middle:
                return 2;
            default:
                return 2;
        }
    }
    /**
     * 创建单sheet的Excel
     */
    public static String CreateExcel(List<Map<String, Object>> data, String tempFilePath, String fileName, String col, String header, String sheetName) throws Exception {
        String filePath = tempFilePath + "/" + fileName;
        File file = new File(filePath);
        String[] columns = col.split(",");
        String[] columnsHeader = header.split(",");

        WritableWorkbook wwb = Workbook.createWorkbook(file);
        WritableSheet ws = wwb.createSheet(sheetName, 0);
        WritableCellFormat wcf = new WritableCellFormat();
        wcf.setBackground(Colour.YELLOW);
        ws.getSettings().setDefaultColumnWidth(20);
        if (columns != null && columns.length > 0 && columnsHeader != null && columnsHeader.length > 0) {
            for (int i = 0; i < columnsHeader.length; i++) {
                ws.addCell(new Label(i, 0, columnsHeader[i], wcf));
            }
            for (int i = 0; i < data.size(); i++) {
                Map<String, Object> temp = data.get(i);
               /* JSONObject json = JSONObject.parseObject(temp.toString());
               *   JSONObject json = JSONObject.fromObject(temp);*/
                JSONObject json = new JSONObject(temp);
                for (int j = 0; j < columns.length; j++) {
                    Object obj = json.get(columns[j]);
                    if (obj != null) {
                        ws.addCell(new Label(j, i + 1, obj.toString()));
                    }
                }
            }
            wwb.write();
            wwb.close();
        }
        if (file.exists()) {
            return filePath;
        } else {
            return null;
        }
    }

    public static void createAndWriteExcelMultipleSheets(WritableWorkbook wwb, List<ExcelData>datas) throws Exception {


        for(ExcelData data:datas)
        {
            WritableSheet ws = wwb.createSheet(data.getSheetName(), data.getSheetIndex());
            WritableCellFormat wcf = new WritableCellFormat();
            wcf.setBackground(Colour.YELLOW);
            String[] columns = data.getCol().split(",");
            String[] columnsHeader = data.getHeader().split(",");

            ws.getSettings().setDefaultColumnWidth(20);
            if (columns != null && columns.length > 0 && columnsHeader != null && columnsHeader.length > 0) {
                for (int i = 0; i < columnsHeader.length; i++) {
                    ws.addCell(new Label(i, 0, columnsHeader[i], wcf));
                }
                for (int i = 0; i < data.getData().size(); i++) {
                    Map<String, Object> temp = data.getData().get(i);
                    /* JSONObject json = JSONObject.parseObject(temp.toString());
                     *   JSONObject json = JSONObject.fromObject(temp);*/
                    JSONObject json = new JSONObject(temp);
                    for (int j = 0; j < columns.length; j++) {
                        Object obj = json.get(columns[j]);
                        if (obj != null) {
                            ws.addCell(new Label(j, i + 1, obj.toString()));
                        }
                    }
                }

            }
        }
    }



    public static String CreateExcel(String tempFilePath, String fileName, List<ExcelData>datas) throws Exception {
        String filePath = tempFilePath + "/" + fileName;
        File file = new File(filePath);
        WritableWorkbook wwb = Workbook.createWorkbook(file);
        for(ExcelData data:datas)
        {
            WritableSheet ws = wwb.createSheet(data.getSheetName(), data.getSheetIndex());
            WritableCellFormat wcf = new WritableCellFormat();
            wcf.setBackground(Colour.YELLOW);
            String[] columns = data.getCol().split(",");
            String[] columnsHeader = data.getHeader().split(",");

            ws.getSettings().setDefaultColumnWidth(20);
            if (columns != null && columns.length > 0 && columnsHeader != null && columnsHeader.length > 0) {
                for (int i = 0; i < columnsHeader.length; i++) {
                    ws.addCell(new Label(i, 0, columnsHeader[i], wcf));
                }
                for (int i = 0; i < data.getData().size(); i++) {
                    Map<String, Object> temp = data.getData().get(i);
                    /* JSONObject json = JSONObject.parseObject(temp.toString());
                     *   JSONObject json = JSONObject.fromObject(temp);*/
                    JSONObject json = new JSONObject(temp);
                    for (int j = 0; j < columns.length; j++) {
                        Object obj = json.get(columns[j]);
                        if (obj != null) {
                            ws.addCell(new Label(j, i + 1, obj.toString()));
                        }
                    }
                }

            }
        }
        wwb.write();
        wwb.close();
        if (file.exists()) {
            return filePath;
        } else {
            return null;
        }
    }




    /**
     * 生成xmlx格式的excel文件
     *
     * @param tempFilePath          目标文件夹
     * @param fileName              文件名
     * @param sheetName             sheet名
     * @param columnNameToHeaderMap 列名和标题名中英文对应关系
     * @param mapList               数据
     * @return 生成的文件的路径
     * @throws Exception
     */
    public static String CreateExcelXlsx(String tempFilePath, String fileName, String sheetName, Map<String, String> columnNameToHeaderMap, List<Map<String, Object>> mapList) throws Exception {
            GutilAssert.notNull(mapList, "mapList can not be null ");
            GutilAssert.notNull(tempFilePath, "tempFilePath can not be null ");
            GutilAssert.notNull(fileName, "fileName can not be null ");
            GutilAssert.notNull(columnNameToHeaderMap, "col can not be null ");
            GutilAssert.notNull(sheetName, "header can not be null ");

        // 允许导出的最大数据行
        int maxRowsSize = 120000;
        String filePath = "";
        SXSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        Map<String, Object> map = null;
        JSONObject jsonObject = null;
        OutputStream os = null;
        List<String> columns = new ArrayList<>();
        List<String> columnsHeader = new ArrayList<>();
        try {
            filePath = tempFilePath + File.separator + fileName;
            FileUtil.creatDirectoryIfNotExist(tempFilePath);
            for (String key : columnNameToHeaderMap.keySet()) {
                columns.add(key);
                columnsHeader.add(columnNameToHeaderMap.get(key));
            }


            workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
            //压缩临时文件，很重要，否则磁盘很快就会被写满
            workbook.setCompressTempFiles(true);

            sheet = workbook.createSheet(sheetName);

            for (int i = 0; i < mapList.size(); i++) {
                if (i >= maxRowsSize) {
                    break;
                }
                if (i == 0) {
                    // 创建表头
                    row = sheet.createRow(i);
                    for (int k = 0; k < columnsHeader.size(); k++) {
                        cell = row.createCell(k);
                        cell.setCellValue(columnsHeader.get(k));
                    }
                }
                row = sheet.createRow(i + 1);
                map = mapList.get(i);
                if (map != null) {
                     jsonObject  = new JSONObject(map);
                    /*jsonObject = JSONObject.parseObject(map.toString());*/
                    if (jsonObject != null) {
                        if (columns != null && columns.size() > 0 && columnsHeader != null && columnsHeader.size() > 0) {
                            for (int j = 0; j < columnsHeader.size(); j++) {
                                if (jsonObject.containsKey(columns.get(j)) && jsonObject.get(columns.get(j)) != null) {
                                    cell = row.createCell(j);
                                    cell.setCellValue(jsonObject.get(columns.get(j)).toString());
                                }
                            }
                        }
                    }
                }
            }

            if (workbook != null) {
                File file = new File(filePath);
                os = new FileOutputStream(file);
                workbook.write(os);
                os.close();
                // 删除临时文件，很重要，否则磁盘可能会被写满
                workbook.dispose();
            }
        } catch (Exception e) {
            throw e;
        } finally {
            if (workbook != null) {
                workbook.dispose();
            }
            if (os != null) {
                os.close();
            }
        }

        return filePath;

    }

    public static String CreateMultiSheetExcelXlsx(String tempFilePath, String fileName, List data) throws Exception {
        GutilAssert.notNull(tempFilePath, "tempFilePath can not be null ");
        GutilAssert.notNull(fileName, "fileName can not be null ");

        JSONArray mateData = JSONArray.parseArray(JSON.toJSONString(data));

        // 允许导出的最大数据行
        int maxRowsSize = 120000;
        String filePath = "";
        SXSSFWorkbook workbook = null;

        OutputStream os = null;

        try {
            filePath = tempFilePath + File.separator + fileName;
            FileUtil.creatDirectoryIfNotExist(tempFilePath);

            workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
            //压缩临时文件，很重要，否则磁盘很快就会被写满
            workbook.setCompressTempFiles(true);
            for(Object object : mateData){
                JSONObject mate =JSONObject.parseObject(JSON.toJSONString(object));
                GutilAssert.notNull(mate.getJSONArray("mapList"), "mapList can not be null ");
                GutilAssert.notNull(mate.getJSONObject("columnNameToHeaderMap"), "col can not be null ");
                GutilAssert.notNull(mate.getString("sheetName"), "header can not be null ");

                String sheetName = mate.getString("sheetName");
                JSONArray sortedHeaders = mate.getJSONArray("sortedHeaders");
                JSONObject columnNameToHeaderMap = mate.getJSONObject("columnNameToHeaderMap");
                JSONArray mapList = mate.getJSONArray("mapList");

                Sheet sheet = null;
                Row row = null;
                Cell cell = null;

                JSONObject jsonObject = null;

                JSONObject map = null;
                List<String> columns = new ArrayList<>();
                List<String> columnsHeader = new ArrayList<>();
                if(sortedHeaders==null || sortedHeaders.isEmpty() || sortedHeaders.size() != columnNameToHeaderMap.size()){
                    sortedHeaders = new JSONArray();
                    sortedHeaders.addAll(columnNameToHeaderMap.keySet());
                }
                for (Object key : sortedHeaders) {
                    if(key.toString().startsWith("tb.")){
                        key = key.toString().substring(3);
                    }
                    columns.add(key.toString());
                    columnsHeader.add(columnNameToHeaderMap.get(key).toString());
                }

                sheet = workbook.createSheet(sheetName);

                for (int i = 0; i < mapList.size(); i++) {
                    if (i >= maxRowsSize) {
                        break;
                    }
                    if (i == 0) {
                        // 创建表头
                        row = sheet.createRow(i);
                        for (int k = 0; k < columnsHeader.size(); k++) {
                            cell = row.createCell(k);
                            cell.setCellValue(columnsHeader.get(k));
                        }
                    }
                    row = sheet.createRow(i + 1);
                    map = mapList.getJSONObject(i);
                    if (map != null) {
                        jsonObject = JSONObject.parseObject(JSON.toJSONString(map));
                        if (jsonObject != null) {
                            if (columns != null && columns.size() > 0 && columnsHeader != null && columnsHeader.size() > 0) {
                                for (int j = 0; j < columnsHeader.size(); j++) {
                                    cell = row.createCell(j);
                                    if (jsonObject.containsKey(columns.get(j)) && jsonObject.get(columns.get(j)) != null && !"null".equals(jsonObject.get(columns.get(j)))) {
                                        cell.setCellValue(jsonObject.get(columns.get(j)).toString());
                                    }else{
                                        cell.setCellValue("");
                                    }
                                }
                            }
                        }
                    }
                }

            }
            if (workbook != null) {
                File file = new File(filePath);
                os = new FileOutputStream(file);
                workbook.write(os);
                os.close();
                // 删除临时文件，很重要，否则磁盘可能会被写满
                workbook.dispose();
            }
        } catch (Exception e) {
            throw e;
        } finally {
            if (workbook != null) {
                workbook.dispose();
            }
            if (os != null) {
                os.close();
            }
        }

        return filePath;

    }

    /**
     * 输出数据到自定义模版的Excel输出流
     *
     * @param excelTemplate 自定义模版文件
     * @param data          数据
     * @param outputStream  Excel输出流
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static void writeDataToTemplateOutputStream(File excelTemplate, List<List<Object>> data, OutputStream outputStream) throws Exception {
        org.apache.poi.ss.usermodel.Workbook book = getWorkbookFromExcel(excelTemplate);
        writeDataToWorkbook(null, data, book, 0);
        writeWorkbookToOutputStream(book, outputStream);
    }

    /**
     * 从Excel文件获取Workbook对象
     *
     * @param excelFile Excel文件
     * @return Workbook对象
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static org.apache.poi.ss.usermodel.Workbook getWorkbookFromExcel(File excelFile) throws Exception {

     /*   if (!excelFile.exists()) {
            if (!excelFile.getParentFile().exists()) {
                excelFile.getParentFile().mkdirs();
            }
            excelFile.createNewFile();
        }*/


       /* if (!inputStream.markSupported()) {
            inputStream = new PushbackInputStream(inputStream, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader(inputStream)) {
            return new HSSFWorkbook(inputStream);
        }
        if (POIXMLDocument.hasOOXMLHeader(inputStream)) {
            return new XSSFWorkbook(OPCPackage.open(inputStream));
        }
        throw new IllegalArgumentException("你的excel版本目前poi解析不了");*/


        if (excelFile.getName().endsWith(XLS)) {
            InputStream inputStream = new FileInputStream(excelFile);
            return new HSSFWorkbook(inputStream);
        } else if (excelFile.getName().endsWith(XLSX)) {
            //return new XSSFWorkbook(inputStream)
            return new XSSFWorkbook(excelFile);
        } else {
            throw new IOException("文件类型错误");
        }

    }

    public static Sheet createSheet(org.apache.poi.ss.usermodel.Workbook workbook, String name) {
        Sheet sheet = workbook.createSheet(name);

        return sheet;
    }

    public static Sheet getSheet(org.apache.poi.ss.usermodel.Workbook workbook, String name) {
        Sheet sheet = workbook.getSheet(name);


        return sheet;
    }



    /**
     * 输出数据到Workbook对象中指定页码
     *
     * @param data      数据
     * @param book      Workbook对象
     * @param rowIndex  rowindex
     * @param sheetName 输出数据到Workbook指定页码的页面数
     */
    public static void writeDataToWorkbook(List<List<Object>> data, org.apache.poi.ss.usermodel.Workbook book, int rowIndex, String sheetName) {


        Sheet sheet = book.getSheet(sheetName);
        //XSSFSheet xsheet = (XSSFSheet)sheet;
        Row row = null;
        Cell cell = null;

        List<Object> rowData = null;
        //XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(xsheet);
        for (int i = 0; i < data.size(); i++) {

          /*  String[]valids = validations.get(i);
            if(valids!=null&&valids.length>0) {
                XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint) dvHelper
                        .createExplicitListConstraint(valids);
                CellRangeAddressList addressList = null;
                XSSFDataValidation validation = null;
                addressList = new CellRangeAddressList(rowIndex, rowIndex, i, i);
                validation = (XSSFDataValidation) dvHelper.createValidation(
                        dvConstraint, addressList);
                // 07默认setSuppressDropDownArrow(true);
                // validation.setSuppressDropDownArrow(true);
                // validation.setShowErrorBox(true);
                sheet.addValidationData(validation);
            }*/
            row = sheet.getRow(rowIndex);
            if (null == row) {
                row = sheet.createRow(rowIndex);
            }
            rowData = data.get(i);
            if (null == rowData) {
                continue;
            }
            for (int j = 0; j < rowData.size(); j++) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                setValue(cell, rowData.get(j));
            }
            rowIndex++;
        }
    }

    /**
     * 把Workbook对象输出到Excel输出流
     *
     * @param book         Workbook对象
     * @param outputStream Excel输出流
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static void writeWorkbookToOutputStream(org.apache.poi.ss.usermodel.Workbook book, OutputStream outputStream) throws IOException {
        book.write(outputStream);
    }

    /**
     * 输出数据到Workbook对象中指定页码
     *
     * @param title 标题，写在第一行，可传null
     * @param data  数据
     */
    public static void writeDataToWorkbook(List<String> title, List<List<Object>> data, File targetFile) throws IOException {
        if (!targetFile.exists()) {
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();


        Row row = null;
        Cell cell = null;

        // 设置表头
        if (null != title && !title.isEmpty()) {
            row = sheet.getRow(0);
            if (null == row) {
                row = sheet.createRow(0);
            }

            for (int i = 0; i < title.size(); i++) {
                cell = row.getCell(i);
                if (null == cell) {
                    cell = row.createCell(i);
                }
                cell.setCellValue(title.get(i));
            }
        }

        List<Object> rowData = null;
        for (int i = 0; i < data.size(); i++) {

            row = sheet.getRow(i + 1);
            if (null == row) {
                row = sheet.createRow(i + 1);
            }

            rowData = data.get(i);
            if (null == rowData) {
                continue;
            }
            for (int j = 0; j < rowData.size(); j++) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                setValue(cell, rowData.get(j));
            }
        }
        FileOutputStream out = new FileOutputStream(targetFile);

        workbook.write(out);
        out.close();
    }

    /**
     * 输出数据到Workbook对象中指定页码
     *
     * @param title 标题，写在第一行，可传null
     * @param data  数据
     * @param book  Workbook对象
     * @param page  输出数据到Workbook指定页码的页面数
     */
    public static void writeDataToWorkbook(List<String> title, List<List<Object>> data, org.apache.poi.ss.usermodel.Workbook book, int page) {

        Sheet sheet = book.getSheetAt(page);

        Row row = null;
        Cell cell = null;

        // 设置表头
        if (null != title && !title.isEmpty()) {
            row = sheet.getRow(0);
            if (null == row) {
                row = sheet.createRow(0);
            }

            for (int i = 0; i < title.size(); i++) {
                cell = row.getCell(i);
                if (null == cell) {
                    cell = row.createCell(i);
                }
                cell.setCellValue(title.get(i));
            }
        }

        List<Object> rowData = null;
        for (int i = 0; i < data.size(); i++) {

            row = sheet.getRow(i + 1);
            if (null == row) {
                row = sheet.createRow(i + 1);
            }

            rowData = data.get(i);
            if (null == rowData) {
                continue;
            }
            for (int j = 0; j < rowData.size(); j++) {
                cell = row.getCell(j);
                if (null == cell) {
                    cell = row.createCell(j);
                }
                setValue(cell, rowData.get(j));
            }
        }
    }

    /**
     * 读取Excel文件第一页
     *
     * @param pathname 文件路径名
     * @return 第一页数据集合
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static List<List<Object>> readExcelFirstSheet(String pathname) throws IOException {
        File file = new File(pathname);
        return readExcelFirstSheet(file);

    }

    /**
     * 读取Excel文件第一页
     *
     * @param file Excel文件
     * @return 第一页数据集合
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static List<List<Object>> readExcelFirstSheet(File file) throws IOException {
        try (
                InputStream inputStream = new FileInputStream(file)
        ) {

            if (file.getName().endsWith(XLS)) {
                return readXlsFirstSheet(inputStream);
            } else if (file.getName().endsWith(XLSX)) {
                return readXlsxFirstSheet(inputStream);
            } else {
                throw new IOException("文件类型错误");
            }
        }

    }

    /**
     * 读取xls格式Excel文件第一页
     *
     * @param inputStream Excel文件输入流
     * @return 第一页数据集合
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static List<List<Object>> readXls(InputStream inputStream, String sheetName) throws IOException {
        org.apache.poi.ss.usermodel.Workbook workbook = new HSSFWorkbook(inputStream);
        return readExcel(workbook, sheetName);
    }

    public static List<List<Object>> readXlsx(InputStream inputStream, String sheetName) throws IOException {
        org.apache.poi.ss.usermodel.Workbook workbook = new XSSFWorkbook(inputStream);
        return readExcel(workbook, sheetName);
    }

    /**
     * 读取xls格式Excel文件第一页
     *
     * @param inputStream Excel文件输入流
     * @return 第一页数据集合
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static List<List<Object>> readXlsFirstSheet(InputStream inputStream) throws IOException {
        org.apache.poi.ss.usermodel.Workbook workbook = new HSSFWorkbook(inputStream);
        return readExcelFirstSheet(workbook);
    }

    /**
     * 读取xlsx格式Excel文件第一页
     *
     * @param inputStream Excel文件输入流
     * @return 第一页数据集合
     * @throws IOException 错误时抛出异常，由调用者处理
     */
    public static List<List<Object>> readXlsxFirstSheet(InputStream inputStream) throws IOException {
        org.apache.poi.ss.usermodel.Workbook workbook = new XSSFWorkbook(inputStream);
        return readExcelFirstSheet(workbook);
    }

    /**
     * 读取Workbook第一页
     *
     * @param book Workbook对象
     * @return 第一页数据集合
     */
    public static List<List<Object>> readExcelFirstSheet(org.apache.poi.ss.usermodel.Workbook book) {
        return readExcel(book, 0);
    }


    /**
     * 读取指定页面的Excel
     *
     * @param book Workbook对象
     * @param page 页码
     * @return 指定页面数据集合
     */
    public static List<List<Object>> readExcel(org.apache.poi.ss.usermodel.Workbook book, int page) {
        List<List<Object>> list = new ArrayList<>();
        Sheet sheet = book.getSheetAt(page);
        for (int i = 0; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            if (null == row) {
                continue;
            }
            boolean isnull=true;
            List<Object> columns = new ArrayList<>();
            for (int j = 0; j < row.getLastCellNum(); j++) {
                Cell cell = row.getCell(j);
                Object value = getValue(cell, null);
                columns.add(value);
                if(value!=null&&StringUtils.isNotBlank(value.toString()))
                {
                    isnull=false;
                }
            }
            if(!isnull) {
                list.add(columns);
            }
        }

        return list;
    }

    /**
     * 读取指定页面的Excel
     *
     * @param book      Workbook对象
     * @param sheetName sheetName
     * @return 指定页面数据集合
     */
    public static List<List<Object>> readExcel(org.apache.poi.ss.usermodel.Workbook book, String sheetName) {
        List<List<Object>> list = new ArrayList<>();
        Sheet sheet = book.getSheet(sheetName);
        for (int i = 0; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            if (null == row) {
                continue;
            }
            boolean isnull=true;
            List<Object> columns = new ArrayList<>();
            for (int j = 0; j < row.getLastCellNum(); j++) {
                Cell cell = row.getCell(j);
                Object value = getValue(cell, null);
                columns.add(value);
                if(value!=null&&StringUtils.isNotBlank(value.toString()))
                {
                    isnull=false;
                }
            }

            if(!isnull) {
                list.add(columns);
            }
        }
        return list;
    }

    /**
     * 解析单元格中的值
     *
     * @param cell 单元格
     * @return 单元格内的值
     */
    public static Object getValue(Cell cell, String cellType) {
        if (null == cell) {
            return null;
        }

        Object value = null;
        CellType type = cell.getCellType();
        switch (type) {
            case BLANK:
                value = null;
                break;
            case BOOLEAN:
                value = cell.getBooleanCellValue();
                break;
            case ERROR:
                value = cell.getErrorCellValue();
                break;
            case FORMULA:
                if (StringUtils.isNotBlank(cellType)) {
                    switch (cellType) {
                        case "text":
                            value = getStr(cell);
                            break;
                        case "number":
                            value = getDouble(cell);
                            break;
                        case "time":
                            value = getTime(cell);
                            break;
                        default:
                            value = null;
                            break;
                    }

                }
                if (value == null) {
                    String str = getStr(cell);
                    if (StringUtils.isNotBlank(str)) {
                        value = str;
                    } else {
                        //此处有问题 时间和数字类型无法区分
                        Double dou = getDouble(cell);
                        if (dou != null) {
                            value = dou;
                        } else {
                            Date time = getTime(cell);
                            if (time != null) {
                                value = time;
                            }
                        }
                    }
                }
                break;
            case NUMERIC:
                if (DateUtil.isCellDateFormatted(cell)) {
                    value = cell.getDateCellValue();
                } else {
                    value = new BigDecimal(cell.getNumericCellValue());
                }
                break;
            case STRING:
            default:
                value = cell.toString();
                break;
        }

        return value;
    }


    private static String getStr(Cell cell) {
        String value = "";
        try {
            value = cell.getStringCellValue();
            return value;
        } catch (Exception ex) {
            return "";
        }
    }

    private static Date getTime(Cell cell) {

        try {
            Date value = cell.getDateCellValue();
            if (value instanceof Date) {
                return value;
            }
            return null;
        } catch (Exception ex) {
            return null;
        }
    }

    private static Double getDouble(Cell cell) {
        try {
            double value = cell.getNumericCellValue();
            return value;
        } catch (Exception ex) {
            return null;
        }
    }

    /**
     * 设置单元格值
     *
     * @param cell  单元格
     * @param value 值
     */
    private static void setValue(Cell cell, Object value) {
        if (null == cell) {
            return;
        }

        if (null == value) {
            cell.setCellValue((String) null);
        } else if (value instanceof Boolean) {
            cell.setCellValue((Boolean) value);
        } else if (value instanceof Date) {
            cell.setCellValue(FORMAT.format((Date) value));
        } else if (value instanceof Double) {
            cell.setCellValue((Double) value);
        } else {
            cell.setCellValue(value.toString());
        }

    }
}
