package com.geoway.landteam.landcloud.service.util.hdfs;


import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @Author Waves
 * @Date 2023/4/3
 * @Description
 **/
public final class DBbuilder {
//    public DBbuilder(String prototype,String workdir){}
//    public DBbuilder(File prototype,Srring workdir){}
    GiLoger logger = GwLoger.getLoger(DBbuilder.class);

    public DBbuilder(String workdir) throws Exception{
        String dbPath = workdir + File.separator + "meta.db";
        File dbFile = new File(dbPath);
        if(!dbFile.exists()){
            ExportDataUtils.copyDataBaseFile(workdir,"dailytaskmeta-submit.db",null);
        }
        this.databaseFile = dbPath;
    }

    String databaseFile;
    private JdbcTemplate jdbcTemplate;

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate){
        Assert.notNull(jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
    }
    public void appendTable(String tablename,String filter){

        logger.info("日常任务下载 开始导出数据 ");
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            connTool = new SqlliteConnTool(databaseFile);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);

            String[] fieldArray = this.getFieldArray(this.getFields(tablename));
            String insertSql = "INSERT INTO '" + tablename + "' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
            insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
            String dataSql = "select * from " + tablename + " " +  filter;
            this.insertTeml(conn,insertSql, dataSql, fieldArray);
        } catch (Exception e) {
            this.logger.error(e.getMessage(),e);
        } finally {
            ExportDataUtils.closeConn(connTool, conn, ps);
        }
    }
    private String[] getFieldArray(List<Map<String, Object>> data){
        String[] result = new String[data.size()];
        for (int i = 0; i < data.size(); i++) {
            Map<String, Object> map = data.get(i);
            result[i] = map.get("attname").toString();
        }
        return result;
    }
    private List<Map<String, Object>> getFields(String tableName) {
        String attributeSql = "select atttypid,attname from pg_attribute where attrelid = " +
                "(select oid from pg_class where relname = '" + tableName + "') and attname like 'f_%' ORDER BY atttypid;";
        return this.jdbcTemplate.queryForList(attributeSql);
    }
    private void insertTeml(Connection connection, String insertSql, String dataSql,
                            String[] fieldArray) throws SQLException {
        PreparedStatement pre = connection.prepareStatement(insertSql);
        List<Map<String, Object>> mapList = this.jdbcTemplate.queryForList(dataSql);
        for (int i = 0; i < mapList.size(); i++) {
            Map<String, Object> map = mapList.get(i);
            for (int j = 0; j < fieldArray.length; j++) {
                ExportDataUtils.setStringData(pre, map, fieldArray[j], j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }
}