package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;

import com.google.common.collect.Lists;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Hdfs {

    GiLoger logger = GwLoger.getLoger(this.getClass());
    private FileSystem fs;
    private final String url;
    private int maxretries=10;
    private int timeout=3000;

    public  Hdfs(String url){
        this.url=url;
    }

    public void open() {
        try {
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", url);
            conf.setInt("ipc.client.connect.max.retries.on.timeouts", this.maxretries);
            conf.setInt("ipc.client.connect.timeout", this.timeout);
            conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            fs = FileSystem.get(conf);
            logger.info("[Hadoop]创建实例成功:"+this.url);
        } catch (Exception e) {
            logger.error("[Hadoop]创建实例失败"+this.url, e);
        }
    }

    public void close() {
        try {
            if (null != fs) {
                fs.close();
                logger.info("[Hadoop]关闭实例成功");
            }
        } catch(Exception e) {
            logger.error("[Hadoop]关闭实例失败", e);
        }
    }

    public boolean isConnected() throws IOException {
        return fs.exists(new Path("/"));
    }

    public boolean exists(String path) throws IOException {
        Path hdfsPath = new Path(path);
        return fs.exists(hdfsPath);
    }


    public FileStatus getFileStatus(String path) throws IOException {
        Path hdfsPath = new Path(path);
        return fs.getFileStatus(hdfsPath);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        ContentSummary contentSummary = null;
        Path hdfsPath = new Path(path);
        if (fs.exists(hdfsPath)) {
            contentSummary = fs.getContentSummary(hdfsPath);
        }
        return contentSummary;
    }


    public List<String> listFileName() throws IOException {
        List<String> res = Lists.newArrayList();
        FileStatus[] fileStatuses = fs.listStatus(new Path("/"));
        for (FileStatus fileStatus : fileStatuses){
            res.add(fileStatus.getPath() +"：类型--"+ (fileStatus.isDirectory()? "文件夹":"文件"));
        }
        return  res;
    }

    public void rmdir(String hdfsp) throws IOException {
        String desinfo = "Despath : " + hdfsp;
        String existPath = "Existpath : " + fs.delete(new Path(this.url + hdfsp), true);
    }

    public char separatorChar() {
        return '/';
    }

    public boolean isDirectory(String path) throws IOException {
        return fs.isDirectory(new Path(this.url + path));
    }

    public List<FileInfo> catChildfile(String hdfsp, Boolean isDetail) throws IOException {
        List<FileInfo> fileInfos = new ArrayList();
        Path path = new Path(this.url + hdfsp);
        FileStatus[] listStatus = fs.listStatus(path);
        FileStatus[] var7 = listStatus;
        int var8 = listStatus.length;

        for(int var9 = 0; var9 < var8; ++var9) {
            FileStatus fileStatus = var7[var9];
            FileInfo fileInfo = isDetail ? new FileDetailInfo() : new FileInfo();
            ((FileInfo)fileInfo).setName(fileStatus.getPath().getName());
            ((FileInfo)fileInfo).setModificationtime(fileStatus.getModificationTime() != 0L ? (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(fileStatus.getModificationTime()) : "0");
            ((FileInfo)fileInfo).setIsdir(fileStatus.isDirectory() ? "true" : "false");
            if (isDetail) {
                FileDetailInfo fileDetailInfo = (FileDetailInfo)fileInfo;
                if (fileStatus.isDirectory()) {
                    ContentSummary contentSummary = fs.getContentSummary(fileStatus.getPath());
                    fileDetailInfo.setDirCount(contentSummary.getDirectoryCount());
                    fileDetailInfo.setFileCount(contentSummary.getFileCount());
                    fileDetailInfo.setLength(contentSummary.getLength());
                } else {
                    fileDetailInfo.setDirCount(0L);
                    fileDetailInfo.setFileCount(0L);
                    fileDetailInfo.setLength(fileStatus.getLen());
                }
            }

            fileInfos.add(fileInfo);
        }

        return fileInfos;
    }

    public Pair<FileSystem, InputStream> getInputStream(String hdfsp) throws IOException {
        InputStream is = fs.open(new Path(this.url + hdfsp));
        return new ImmutablePair(fs, is);
    }

    public OutputStream getOutputStream(String hdfsp) throws IOException {
        OutputStream os = fs.create(new Path(this.url + hdfsp));
        return os;
    }

    public String getFileName(String hdfsp) {
        Path path = new Path(this.url + hdfsp);
        return path.getName();
    }

    public List<String> getSubFilpaths(String hdfsp) throws IOException {
        Path path = new Path(this.url + hdfsp);
        return (List) Arrays.stream(fs.listStatus(path)).map((fileStatus) -> {
            return fileStatus.getPath().toUri().getPath();
        }).collect(Collectors.toList());
    }

    public synchronized void mksubdirByName(String hdfsp, int beginindex, int endindex) throws IOException {
        Path path = new Path(this.url + hdfsp);
        FileStatus[] fss = fs.listStatus(path);
        FileStatus[] var7 = fss;
        int var8 = fss.length;

        for(int var9 = 0; var9 < var8; ++var9) {
            FileStatus subfss = var7[var9];
            String subname = subfss.getPath().getName().substring(beginindex, endindex);
            Path newPath = new Path(path.toString() + this.separatorChar() + subname);
            if (!fs.exists(newPath)) {
                fs.mkdirs(newPath);
            }

            fs.rename(subfss.getPath(), new Path(newPath.toString() + this.separatorChar() + subfss.getPath().getName()));
        }

    }

    public synchronized void renamesubBySplit(String hdfsp, int beginindex, int endindex) throws IOException {
        Path path = new Path(this.url + hdfsp);
        FileStatus[] fss = fs.listStatus(path);
        FileStatus[] var7 = fss;
        int var8 = fss.length;

        for(int var9 = 0; var9 < var8; ++var9) {
            FileStatus subfss = var7[var9];
            String subname = subfss.getPath().getName().substring(beginindex, endindex);
            fs.rename(subfss.getPath(), new Path(path.toString() + this.separatorChar() + subname));
        }

    }

    public Boolean existFile(String hdfsp) throws IOException {
        return fs.exists(new Path(this.url + hdfsp));
    }

}