package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HdfsConfig {

//    @Value("${hadoop.hdfs.ip}")
//    private  String hdfsServerIp;
//
//    @Value("${hadoop.hdfs.port}")
//    private  String hdfsServerPort;

//    @Value("${hadoop.hdfs.pool.maxTotal}")
    private int maxTotal=8;

//    @Value("${hadoop.hdfs.pool.maxIdle}")
    private int maxIdle=8;

//    @Value("${hadoop.hdfs.pool.minIdle}")
    private int minIdle=0;

//    @Value("${hadoop.hdfs.pool.maxWaitMillis}")
    private int maxWaitMillis=3;

//    @Value("${hadoop.hdfs.pool.testWhileIdle}")
    private boolean  testWhileIdle=false;

//    @Value("${hadoop.hdfs.pool.minEvictableIdleTimeMillis}")
    private long minEvictableIdleTimeMillis = 60000;

//    @Value("${hadoop.hdfs.pool.timeBetweenEvictionRunsMillis}")
    private long timeBetweenEvictionRunsMillis = 30000;

//    @Value("${hadoop.hdfs.pool.numTestsPerEvictionRun}")
    private int numTestsPerEvictionRun = -1;


//    @Bean(initMethod = "init", destroyMethod = "stop")
//    public HdfsClient HdfsClient(){
//        HdfsClient client = new HdfsClient();
//        return client;
//    }

    /**
     * TestWhileConfig - 在空闲时检查有效性, 默认false
     * MinEvictableIdleTimeMillis - 逐出连接的最小空闲时间
     * TimeBetweenEvictionRunsMillis - 逐出扫描的时间间隔(毫秒) 如果为负数则不运行逐出线程，默认-1
     * NumTestsPerEvictionRun - 每次逐出检查时 逐出的最大数目
     * */
    @Bean
    public HdfsPoolConfig HdfsPoolConfig(){
        HdfsPoolConfig hdfsPoolConfig = new HdfsPoolConfig();
        hdfsPoolConfig.setTestWhileIdle(testWhileIdle);
        hdfsPoolConfig.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        hdfsPoolConfig.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        hdfsPoolConfig.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        hdfsPoolConfig.setMaxTotal(maxTotal);
        hdfsPoolConfig.setMaxIdlePerKey(maxIdle);
        hdfsPoolConfig.setMinIdlePerKey(minIdle);
        hdfsPoolConfig.setMaxWaitMillis(maxWaitMillis);
        return hdfsPoolConfig;
    }

    @Bean
    public HdfsFactory HdfsFactory(){
        return  new  HdfsFactory();
    }

}
