package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;

import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import java.io.IOException;

public class HdfsFactory implements KeyedPooledObjectFactory<String, Hdfs> {


    @Override
    public PooledObject<Hdfs> makeObject(String key) throws Exception {
        Hdfs hdfs = new Hdfs(key);
        hdfs.open();
        return new DefaultPooledObject<Hdfs>(hdfs);
    }

    @Override
    public void destroyObject(String key, PooledObject<Hdfs> pooledObject) throws Exception {
        Hdfs hdfs = pooledObject.getObject();
        hdfs.close();
    }

    @Override
    public boolean validateObject(String s, PooledObject<Hdfs> pooledObject) {
        Hdfs hdfs = pooledObject.getObject();
        try {
            return  hdfs.isConnected();
        } catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void activateObject(String s, PooledObject<Hdfs> pooledObject) throws Exception {

    }

    @Override
    public void passivateObject(String s, PooledObject<Hdfs> pooledObject) throws Exception {

    }

//    @Override
//    public void activateObject(String s, PooledObject <Hdfs> pooledObject) throws Exception {
//
//    }
//
//    @Override
//    public void passivateObject(String s, PooledObject <Hdfs> pooledObject) throws Exception {
//
//    }


//    @Override
//    public PooledObject<Hdfs> makeObject() throws Exception {
//        Hdfs hdfs = new Hdfs(url);
//        hdfs.open();
//        return new DefaultPooledObject<Hdfs>(hdfs);
//    }
//
//    @Override
//    public void destroyObject(PooledObject<Hdfs> pooledObject) throws Exception {
//        Hdfs hdfs = pooledObject.getObject();
//        hdfs.close();
//    }
//
//    @Override
//    public boolean validateObject(PooledObject<Hdfs> pooledObject) {
//        Hdfs hdfs = pooledObject.getObject();
//        try {
//            return  hdfs.isConnected();
//        } catch (IOException e) {
//            e.printStackTrace();
//            return false;
//        }
//    }
//
//    @Override
//    public void activateObject(PooledObject<Hdfs> pooledObject) throws Exception {
//
//    }
//
//    @Override
//    public void passivateObject(PooledObject<Hdfs> pooledObject) throws Exception {
//
//    }
}