//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool;

import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SmbFSystemImpl implements SrcFileSystem{
    public SmbFSystemImpl() {
    }

    public List<String> getSubFilpaths(String path) throws MalformedURLException, SmbException {
        SmbFile smbFile = this.getSmbFile(path.endsWith(String.valueOf(this.separatorChar())) ? path : path + this.separatorChar());
        return (List)Arrays.stream(smbFile.list()).map((filename) -> {
            return path + this.separatorChar() + filename;
        }).collect(Collectors.toList());
    }

    public String getFilename(String path) {
        int lastindex = path.lastIndexOf(this.separatorChar());
        if (lastindex == path.length() - 1) {
            int startindex = path.substring(0, path.length() - 1).lastIndexOf(this.separatorChar());

            assert startindex != -1;

            return path.substring(startindex + 1, lastindex);
        } else {
            return path.substring(lastindex + 1);
        }
    }

    public boolean isDirectory(String path) throws SmbException, MalformedURLException {
        SmbFile smbFile = this.getSmbFile(path);
        return smbFile.isDirectory();
    }

    public char separatorChar() {
        return '\\';
    }

    public boolean mkdir(String path) throws SmbException, MalformedURLException {
        SmbFile smbFile = this.getSmbFile(path);
        if (smbFile.exists()) {
            return false;
        } else {
            smbFile.mkdirs();
            return true;
        }
    }

    private SmbFile getSmbFile(String shareUrl, String... userinfo) throws MalformedURLException {
        SmbFile smbFile = null;
        String smburl = "smb:" + shareUrl.replace("\\", "/");
        if (userinfo != null && userinfo.length == 2) {
            NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication((String)null, userinfo[0], userinfo[1]);
            smbFile = new SmbFile(smburl, ntlmPasswordAuthentication);
        } else {
            smbFile = new SmbFile(smburl);
        }

        return smbFile;
    }

    public InputStream getInputStream(String shareUrl, String... userinfo) throws IOException {
        SmbFile smbFile = this.getSmbFile(shareUrl);
        return smbFile.getInputStream();
    }

    public OutputStream getOutputStream(String shareUrl, String... userinfo) throws IOException {
        SmbFile smbFile = this.getSmbFile(shareUrl);
        smbFile.createNewFile();
        return smbFile.getOutputStream();
    }
}
