package com.geoway.landteam.landcloud.service.util.hdfs;

import java.util.function.Supplier;

/**
 * @Author Waves
 * @Date 2023/4/4
 * @Description 抄的Rust里面的异常处理机制
 **/
public class Try {
    /**
     * 执行supplier并返回一个结果的包装类
     * @param supplier
     * @param <T>
     * @return
     */
    public static <T>  Result<T> run(Supplier<T> supplier){
        try{
            T value = supplier.get();
            return Result.ok(value);
        }catch (Exception e){
            return Result.err(e);
        }
    }
    public static <T>  Result<T> runException(ExceptionSupplier<T> supplier){
        try{
            T value = supplier.get();
            return Result.ok(value);
        }catch (Exception e){
            return Result.err(e);
        }
    }
}
