package com.geoway.landteam.landcloud.service.wpzf.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskSubmitReportRecordRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.pub.DownloadFileDailyTaskService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskSubmitReportRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtCgtjRepository;
import com.geoway.landteam.landcloud.repository.gjht.TbtskTaskDkpwRepository;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtCgtj;
import com.geoway.landteam.landcloud.service.util.SM3Util;
import com.geoway.landteam.landcloud.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.service.util.TimeUtils;
import com.geoway.landteam.landcloud.model.giht.enm.WpzfDicEnum;
import com.geoway.landteam.landcloud.service.util.EncryptionTools;

import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

//import com.geoway.land.core.third.gj.dto.Data;
//import com.geoway.land.core.third.gj.dto.Head;
//import com.geoway.land.core.third.gj.dto.Message;
import com.geoway.landteam.landcloud.model.giht.dto.Data;
import com.geoway.landteam.landcloud.model.giht.dto.Head;
import com.geoway.landteam.landcloud.model.giht.dto.Message;

import com.geoway.landteam.landcloud.model.giht.entity.TbtskTaskDkpw;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;


import java.io.*;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.geoway.landteam.landcloud.servface.wpzf.WpzfCallBackService;

import javax.annotation.Resource;

@Service
public class WpzfCallBackServiceImpl implements WpzfCallBackService {

//    @Value("#{imeSettings['project.tempDir']}")
    @Value("${project.tempDir}")
    protected String tempDir;


//    @Value("#{imeSettings['gjck.url']}")
    @Value("${gjck.url}")
    protected String gjckUrl;

//    @Value("#{imeSettings['gjck.key']}")
    @Value("${gjck.key}")
    protected String gjckKey;

//    @Value("#{imeSettings['gjck.secret']}")
    @Value("${gjck.secret}")
    protected String gjckSecret;

    @Autowired
    TbtskSubmitReportRecordRepository tbtskSubmitReportRecordRepository;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;

    //    @Autowired
    @Resource
    protected TskTaskBizService tskTaskBizService;
    //    @Autowired
    @Resource
    protected TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    RegionService regionService;
    @Autowired
    DownloadFileDailyTaskService downloadFileDailyTaskService;
    @Autowired
    OssConfigRepository ossConfigRepository;
    @Autowired
    TbGjhtCgtjRepository tbGjhtCgtjRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;

//    @Autowired
    @Resource
    TbtskTaskDkpwRepository tbtskTaskDkpwRepository;

    @Autowired
    LandUserRepository landUserRepository;

    @Override
    public boolean sendResultToJinAo(int xh, String taskId, String regionCode, Map<String, Object> info) throws Exception {
        TbGjhtCgtj tbGjhtCgtj = new TbGjhtCgtj();
        tbGjhtCgtj.setId(UUID.randomUUID().toString());
        tbGjhtCgtj.setBizid(taskId);
        tbGjhtCgtj.setOpertime(new Date());
        tbGjhtCgtj.setSfcg(0);
        tbGjhtCgtj.setYear((long)2023);
        tbGjhtCgtj.setMsg("初始化");
        tbGjhtCgtj.setXzqdm(regionCode);
        try {
            info.put("status", false);
            info.put("idlist", new ArrayList<String>());
            // 1、根据任务找到图斑数据（待成果提交的图斑数据）
            TskTaskBiz one = tskTaskBizService.findByTaskId(taskId);
            if(one == null || StringUtils.isBlank(one.getTableId())) {
                throw new Exception("参数异常或任务异常");
            }
            HashMap<String, String> map = new HashMap<>();
            // 1.1、过滤图斑数据(获取上周提交的数据)  =>   【xml数据、附件数据】
            List<Map<String, Object>> mapList = getLastWeekendsForSubmitData(one, regionCode);
            // 2、将图斑数据 +  附件数据打包，传至OBS，返回的url
            String result = buildZipFile(xh, mapList, map, regionCode);
            // 如果数据存储成功了， 那么保留本次记录
            List<String> idList = mapList.stream().map(u -> u.get("f_id").toString()).collect(Collectors.toList());
            info.put("idlist", idList);
            String join = String.join(",", idList);
            tbGjhtCgtj.setTbid(join);
            tbGjhtCgtj.setUrl(result);
            tbGjhtCgtj.setCount((long)mapList.size());
//            tbGjhtCgtjRepository.save(tbGjhtCgtj);
            // 3、调用接口，将url和其他信息返回出去
            String zipFileFullPath = map.get("zipFileFullPath");
            boolean isSuccess = sendHttpRequest(tbGjhtCgtj, xh, idList.size(), 2023, result.substring(result.lastIndexOf("/") + 1, result.lastIndexOf(".")),
                    result, "2E5F07B4-09E5-334D-4304-9C9217AA5E4C", getMD5Checksum(zipFileFullPath));
            if(isSuccess) {
                tbGjhtCgtj.setSfcg(1);
            } else {
                tbGjhtCgtj.setSfcg(2);
            }
            tbGjhtCgtjRepository.save(tbGjhtCgtj);
        } catch (Exception e) {
            tbGjhtCgtj.setMsg(e.getMessage());
            tbGjhtCgtjRepository.save(tbGjhtCgtj);
            return false;
        }
        info.put("status", true);
        return true;
    }

    private String buildZipFile(int xh, List<Map<String, Object>> mapList, HashMap<String, String> memmap, String regionCode) throws Exception {
        String rootPath = "";
        String secondDir = "";
        if(StringUtils.isBlank(regionCode)) {
            rootPath = getRootDirName(xh,"220000");
            String firstDir = "220000";
            String fixDir = tempDir + File.separator + rootPath  + File.separator + firstDir;
            Map<String, List<Map>> xzqdmList = mapList.stream().collect(Collectors.groupingBy(u -> {
                String f_xzqdmsys = u.get("f_xzqdmsys").toString().substring(0, 6);
                return f_xzqdmsys;
            }));

            Map<String, Map<String, List<AppMedia>>> xzqAndFile = new HashMap<>();
            for (Map.Entry<String, List<Map>> stringListEntry : xzqdmList.entrySet()) {
                String xzqh = stringListEntry.getKey();
                List<Map> value = stringListEntry.getValue();
                Map<String, List<AppMedia>> jcbhAndAppMedia = new HashMap<>();
                for (Map map : value) {
                    String jctbbh = map.get("f_jctbbh").toString();
                    String fId = map.get("f_id").toString();
                    File parentDir = new File(fixDir + File.separator + jctbbh);
                    if(!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    List<AppMedia> appMediaList = appMediaRepository.queryByGid(fId);
                    // 递归创建文件夹，并写入附件数据
                    makedirAndAddFile(fixDir + File.separator + jctbbh, appMediaList, "WY_", true);

                    jcbhAndAppMedia.put(jctbbh, appMediaList);
                }
                xzqAndFile.put(xzqh, jcbhAndAppMedia);
            }
        } else {
            rootPath = getRootDirName(xh, regionCode);
            String firstDir = "220000";
            secondDir = regionService.getRegion(regionCode).getPcode();
            String thirdDir = regionCode;
            String fixDir = tempDir + File.separator + rootPath  + File.separator + firstDir  + File.separator + secondDir  + File.separator + thirdDir;
            Map<String, List<Map>> xzqdmList = mapList.stream().collect(Collectors.groupingBy(u -> {
                String f_xzqdmsys = u.get("f_xzqdmsys").toString().substring(0, 6);
                return f_xzqdmsys;
            }));
            Map<String, Map<String, List<AppMedia>>> xzqAndFile = new HashMap<>();
            for (Map.Entry<String, List<Map>> stringListEntry : xzqdmList.entrySet()) {
                String xzqh = stringListEntry.getKey();
                if(!xzqh.equals(regionCode)) {
                    continue;
                }
                List<Map> value = stringListEntry.getValue();
                Map<String, List<AppMedia>> jcbhAndAppMedia = new HashMap<>();
                for (Map map : value) {
                    String jctbbh = map.get("f_jctbbh").toString();
                    String fId = map.get("f_id").toString();
                    File parentDir = new File(fixDir + File.separator + jctbbh);
                    if(!parentDir.exists()) {
                        parentDir.mkdirs();
                    }

                    List<AppMedia> appMediaList = appMediaRepository.queryByGid(fId);
                    // 内业
                    String f_yszmwj = map.get("f_yszmwj") == null ? "" : map.get("f_yszmwj").toString();
                    String f_tbpdfj = map.get("f_tbpdfj") == null ? "" : map.get("f_tbpdfj").toString();
                    if(StringUtils.isNotBlank(f_yszmwj)) {
                        AppMedia appMedia = new AppMedia();
                        appMedia.setServerpath(f_yszmwj);
                        appMedia.setId("1");
                        List<AppMedia> mediaList = new ArrayList<>();
                        mediaList.add(appMedia);
                        makedirAndAddFile(fixDir + File.separator + jctbbh, mediaList, "NY", true);
                    }
                    if(StringUtils.isNotBlank(f_tbpdfj)) {
                        AppMedia appMedia = new AppMedia();
                        appMedia.setServerpath(f_tbpdfj);
                        appMedia.setId("2");
                        List<AppMedia> mediaList = new ArrayList<>();
                        mediaList.add(appMedia);
                        makedirAndAddFile(fixDir + File.separator + jctbbh, mediaList, "NY", true);
                    }
                    // 外业
                    // 递归创建文件夹，并写入附件数据（外业）
                    List<AppMedia> wyMediaList = new ArrayList<>();
                    int i = 0;
                    for (AppMedia appMedia : appMediaList) {
                        i ++;
                        AppMedia appMedia1 = new AppMedia();
                        appMedia1.setId(i + "");
                        appMedia1.setServerpath(appMedia.getServerpath());
                        wyMediaList.add(appMedia1);
                    }
                    makedirAndAddFile(fixDir + File.separator + jctbbh, wyMediaList, "WY", true);
//                    makedirAndAddFile(fixDir + File.separator + jctbbh, appMediaList, "WY", true);
                    // 批文
                    List<AppMedia> pwMediaList = new ArrayList<>();
                    List<TbtskTaskDkpw> pwListByTaskIdAndTbId = tbtskTaskDkpwRepository.getPwListByTaskIdAndTbId("3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2", fId);
                    for (TbtskTaskDkpw tbtskTaskDkpw : pwListByTaskIdAndTbId) {
                        AppMedia appMedia = new AppMedia();
                        appMedia.setServerpath(tbtskTaskDkpw.getfPwUrl());
                        appMedia.setId(tbtskTaskDkpw.getfPzwh());
                        pwMediaList.add(appMedia);
                    }
                    makedirAndAddFile(fixDir + File.separator + jctbbh, pwMediaList, "PW",  false);
                    jcbhAndAppMedia.put(jctbbh, appMediaList);

                }
                xzqAndFile.put(xzqh, jcbhAndAppMedia);
            }
        }
        String xmlPath = tempDir + File.separator + rootPath + File.separator + rootPath + ".xml";
        File tartDirFile = new File(xmlPath);
        if(!tartDirFile.exists()) {
            tartDirFile.createNewFile();
        }
        String xmlContent = getXmlContentByTbList(mapList, rootPath, secondDir, regionCode);
//        writeText2File(tartDirFile, xmlContent);
        writeText2File(tartDirFile, xmlContent);

        EncryptionTools.encryptionOrDecryption(tempDir + File.separator + rootPath + File.separator + rootPath + ".xml",
                tempDir + File.separator + rootPath,
                rootPath + ".xml",
                true);

        String zip = Zip4jUtils.zip(tempDir + File.separator + rootPath, "gtdcywpzf2023@");
        memmap.put("zipFileFullPath", zip);
//        String s = defaultOssOperatorService.sendObject2Oss("wpzf/result/upload/" + getRootDirName(regionCode) + ".zip", zip);
//        String s = defaultOssOperatorService.sendObject2Oss("wpzf/result/upload/" + getRootDirName(regionCode) + ".zip", zip);
        String s = defaultOssOperatorService.sendObject2OssWithPublicRead("wpzf/result/upload/" + getRootDirName(xh,regionCode) + ".zip", zip);
        return s;
    }

    private void makedirAndAddFile(String fixPath, List<AppMedia> appMediaList, String preffix, boolean nameContainFileId) throws IOException {
//        tempDir = "d:/data/tempDir";

//        for (AppMedia appMedia : appMediaList) {
//            String mediaName = appMedia.getServerpath().substring(appMedia.getServerpath().lastIndexOf("/")+1);
//            String filename = dir + "/" + mediaName;
//
//
//        }
        List<OssConfig> ossConfigs = ossConfigRepository.queryDefault();
        OssConfig ossConfig = null;
        if (!ossConfigs.isEmpty()) {
            ossConfig = ossConfigs.get(0);
        }
        ObsClient obsClient = getObsClient();
        InputStream inputStream = null;
        OutputStream outputStream = null;

        downloadFileDailyTaskService.createAndChangeNameTempFile(appMediaList, ossConfig, obsClient, inputStream, outputStream, fixPath, preffix, nameContainFileId);

        // 保证创建一个新文件
//        File file = new File(jsonPath);
//        if (file.exists()) { // 如果已存在,删除旧文件
//            file.delete();
//        }
//        file.createNewFile();
    }


    private ObsClient getObsClient() {
        ObsClient obsClient = null;
        List<OssConfig> ossConfigs = ossConfigRepository.queryDefault();
        OssConfig ossConfig = null;
        if (!ossConfigs.isEmpty()) {
            ossConfig = ossConfigs.get(0);
        }

        String myEndPoint = ossConfig.getEndPoint();
        ObsConfiguration config = new ObsConfiguration();
        config.setSocketTimeout(30000);
        config.setConnectionTimeout(10000);
        config.setEndPoint(myEndPoint);
        config.setHttpsOnly(false);

        obsClient = new ObsClient(ossConfig.getKey(), ossConfig.getKeySecret(), config);

        return obsClient;
    }

    private File getXmlByTbList(List<Map> mapList) throws Exception {
        Message message = new Message();
        File file = null;
        if(mapList != null && mapList.size() > 0) {
            // 真实业务
            for (Map map : mapList) {
                // 构造message
            }
        } else {
            // 模拟数据
            message = WpzfCallBackServiceImpl.getExample();
            String filename = "d:\\data\\tempDir" + "\\" + UUID.randomUUID() + ".xml";
            file = WpzfCallBackServiceImpl.buildXml(message.toXml(), filename);
        }
        return file;
    }

    private String getXmlContentByTbList(List<Map<String, Object>> mapList, String rootPath, String secondDir, String regionCode) throws Exception {
        Message message = new Message();
        String xmlStr = "";
        if(mapList != null && mapList.size() > 0) {
            Head head = new Head();
            head.setMsgID(rootPath);
            head.setXZQDM(regionCode);
            head.setCommitCode("220");
//            head.setDigitalSign("xxx");
            head.setDataTransTime(TimeUtils.dateToString(new Date(), TimeUtils.YMD_HMS));
            // 补充data节点字段
            Data data = new Data();
            List<Data.ResultTB> resultTBList = new ArrayList<>();
            List<Data.ResultDK> resultDKList = new ArrayList<>();
            // 真实业务
            for (Map map : mapList) {
                // 构造message
                Data.ResultTB resultTB = new Data.ResultTB();
                Data.ResultDK resultDK = new Data.ResultDK();
                String jctbbh = map.get("f_jctbbh") == null ? "": map.get("f_jctbbh").toString();
                resultTB.setJCBH(jctbbh);
                resultTB.setGeoDealType("0");

                resultTB.setXFSJ(map.get("xfsj") == null ? "": map.get("xfsj").toString());
                resultTB.setSF_SK("0");
                resultTB.setDK_Count("1");
                long f_committime = Long.valueOf(map.get("f_committime").toString());
                String s = TimeUtils.dateToString(new Date(f_committime), TimeUtils.YMD_HMS);
                if(map.get("f_committime") == null) {
                    resultTB.setGeoUpdateTime("");
                } else {
                    resultTB.setGeoUpdateTime(s);
                }
                List<Data.DK> dkList = new ArrayList<>();
                Data.DK dk = new Data.DK();
//                dk.setDKBH(map.get("f_jctbbh").toString());
                // 地块编号
                dk.setDKBH(map.get("f_dkbh")  == null ? "":  map.get("f_dkbh").toString());
                // 地块图形面积
                dk.setDKMJ(map.get("f_dkmj")  == null ? "":  map.get("f_dkmj").toString());
                // 地块农用地图形面积
                dk.setNYDMJ(map.get("f_nydmj")  == null ? "": map.get("f_nydmj").toString());
                // 地块耕地图形面积
                dk.setGDMJ(map.get("f_gdmj")  == null ? "": map.get("f_gdmj").toString());
                // 地块水田图形面积
                dk.setSTMJ(map.get("f_dksttxmj")  == null ? "":  map.get("f_dksttxmj").toString());
                // 地块永久基本农田图形面积
                dk.setYJ_JBNTMJ(map.get("f_yjjbntmj")  == null ? "": map.get("f_yjjbntmj").toString());
                // 地块生态保护红线面积
                dk.setSTBHHXMJ(map.get("f_dkstbhhx")  == null ? "0":  map.get("f_dkstbhhx").toString());
                String shape = map.get("f_shape").toString();
                // 地块空间坐标信息矢量数据
                dk.setShape(shape);
                dkList.add(dk);
                resultTB.setDKList(dkList);
                resultTBList.add(resultTB);
                resultDK.setMergeDKlist(new ArrayList<>());
//                List<Data.File> fileList = new ArrayList<>();
//                String tbId = map.get("f_id").toString();
//                appMediaRepository.queryByGid()
                List<AppMedia> appMediaList = appMediaRepository.queryByGid(map.get("f_id").toString());


                List<Data.PW>  pwList = new ArrayList<>();
                List<TbtskTaskDkpw> dkpwList = tbtskTaskDkpwRepository.getPwListByTaskIdAndTbId("3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2",
                        map.get("f_id").toString());
                for (TbtskTaskDkpw tbtskTaskDkpw : dkpwList) {
                    Data.PW pw = new Data.PW();
                    pw.setPZWH(tbtskTaskDkpw.getfPzwh());
                    pw.setXMMC(tbtskTaskDkpw.getfXmmc() == null ? "" : tbtskTaskDkpw.getfXmmc());
                    pw.setPW_Source(tbtskTaskDkpw.getfPwSource() + "");
                    pw.setPWLX(StringUtils.isNotBlank(tbtskTaskDkpw.getfPwlx()) ? tbtskTaskDkpw.getfPwlx() : "");
                    pw.setPZSJ(tbtskTaskDkpw.getfPzsj() == null ? "" : tbtskTaskDkpw.getfPzsj());
                    pw.setYXQZ(tbtskTaskDkpw.getfYxqz() == null ? "" : tbtskTaskDkpw.getfYxqz());
                    pw.setPZJG(tbtskTaskDkpw.getfPzjg() == null ? "" : tbtskTaskDkpw.getfPzjg());
                    pw.setPZMJ(tbtskTaskDkpw.getfPzmj() == null ? "" : tbtskTaskDkpw.getfPzmj());
                    pw.setPZGDMJ(tbtskTaskDkpw.getfPzgdmj());
                    pw.setPZNYDMJ(tbtskTaskDkpw.getfPznydmj());
                    pw.setPZYJJBNTMJ(tbtskTaskDkpw.getfPzyjjbntmj());
                    pw.setPZJSYDMJ(tbtskTaskDkpw.getfPzjsydmj() == null ? "" : tbtskTaskDkpw.getfPzjsydmj());
                    pw.setPZWLYMJ(tbtskTaskDkpw.getfPzwlymj() == null ? "" : tbtskTaskDkpw.getfPzwlymj());
                    pw.setReason(tbtskTaskDkpw.getfReason() == null ? "" : tbtskTaskDkpw.getfReason());
//                    String fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + pw.getPW_URL().substring(pw.getPW_URL().lastIndexOf(".") + 1);
                    String fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + tbtskTaskDkpw.getfPwUrl().substring(tbtskTaskDkpw.getfPwUrl().lastIndexOf(".") + 1);
                    pw.setPW_URL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                    pw.setMD5(tbtskTaskDkpw.getfMd5());
                    pw.setLocationURL(StringUtils.isNotBlank(tbtskTaskDkpw.getfLocationurl()) ? tbtskTaskDkpw.getfLocationurl() : "");
                    pwList.add(pw);
                }
                resultDK.setPWlist(pwList);

                Data.DKAttributes dkAttributes = new Data.DKAttributes();
                resultDK.setFileList(getFileList(map, appMediaList, dkAttributes, secondDir, regionCode));
                // 地块编号
                dkAttributes.setDKBH(map.get("f_dkbh")  == null ? "":  map.get("f_dkbh").toString());
                // 下发时间(暂用提交时间)
                dkAttributes.setXFSJ(map.get("xfsj") == null ? "": map.get("xfsj").toString());
                // 地块填报单元
                dkAttributes.setDK_Unit(1 + "");
                dkAttributes.setDK_Count("1");
                // 暂用（省级定性的判定类型）
//                dkAttributes.setPDLX(map.get("f_sjdxdpdl")  == null ? "":  map.get("f_sjdxdpdl").toString());
                String pdlx = map.get("f_hfpd").toString();
                dkAttributes.setPDLX(WpzfDicEnum.getCodeByTypeAndDesc("pdlx", pdlx));
                // 地块面积
                dkAttributes.setDKMJ(map.get("f_dkmj")  == null ? "":  map.get("f_dkmj").toString());
                // 地块农用地面积
                dkAttributes.setNYDMJ(map.get("f_nydmj")  == null ? "": map.get("f_nydmj").toString());
                // 地块耕地面积
                dkAttributes.setGDMJ(map.get("f_gdmj")  == null ? "": map.get("f_gdmj").toString());
                // 水田面积
                dkAttributes.setSTMJ(map.get("f_dksttxmj")  == null ? "":  map.get("f_dksttxmj").toString());
                // 永久基本农田面积
                dkAttributes.setYJ_JBNTMJ(map.get("f_yjjbntmj")  == null ? "": map.get("f_yjjbntmj").toString());
                // 地块生态保护红线面积
                dkAttributes.setSTBHHXMJ(map.get("f_stbhhxmj")  == null ? "0": map.get("f_stbhhxmj").toString());
//                // 地块外业照片数量
//                dkAttributes.setPhoto_Count(appMediaList == null ? "0" : appMediaList.size() + "");
//                // 地块内业举证材料
//                dkAttributes.setZMCL_Count(map.get("f_dknyjzcl")  == null ? "": map.get("f_dknyjzcl").toString());
//                // 地块涉及批文数量
//                dkAttributes.setPW_Count(map.get("f_dksjpwsl")  == null ? "": map.get("f_dksjpwsl").toString());
                // 地块更新时间(暂用提交时间)
                // 提报填写时间  市级审核时间   省级审核时间
//                String committime = map.get("f_committime").toString();
                String sjshsj3 = map.get("f_sjshsj")  == null ? "": map.get("f_sjshsj").toString();
                String sjdxsj2 = map.get("f_sjdxsj")  == null ? "": map.get("f_sjdxsj").toString();
                String sjshsj =  map.get("f_sjs_n3")  == null ? "": map.get("f_sjs_n3").toString();
                String sjdxsj1 = map.get("f_sjd_n1")  == null ? "": map.get("f_sjd_n1").toString();
                List<Data.File> fileList = resultDK.getFileList();
                if(StringUtils.isNotBlank(sjshsj3)) {
                    dkAttributes.setUpdateTime(sjshsj3);
                } else if(StringUtils.isNotBlank(sjdxsj2)) {
//                    dkAttributes.setUpdateTime(s);
                    dkAttributes.setUpdateTime(TimeUtils.convertDateAndTimeFromOther(sjdxsj2));
                } else if(StringUtils.isNotBlank(sjshsj)) {
                    dkAttributes.setUpdateTime(sjshsj);
                } else if(StringUtils.isNotBlank(sjdxsj1)) {
                    dkAttributes.setUpdateTime(TimeUtils.convertDateAndTimeFromOther(sjdxsj1));
                } else {
                    String maxTime = s;
                    for (Data.File u : fileList) {
                        if(u.getUploadTime().compareTo(s) > 0) {
                            maxTime = u.getUploadTime();
                        }
                    }
                    dkAttributes.setUpdateTime(maxTime);
                }
                // 判定依据
                dkAttributes.setPDYJ(map.get("f_pdyjsm")  == null ? "": map.get("f_pdyjsm").toString());
                // 建设用地面积
                dkAttributes.setJSYDMJ(map.get("f_jsydmj")  == null ? "": map.get("f_jsydmj").toString());
                // 未利用地面积
                dkAttributes.setWLYDMJ(map.get("f_wlydmj")  == null ? "": map.get("f_wlydmj").toString());
                // 乡镇街道
                dkAttributes.setXZJD(map.get("f_xzjd")  == null ? "": map.get("f_xzjd").toString());
                // 村
                dkAttributes.setCUN(map.get("f_c_n5")  == null ? "": map.get("f_c_n5").toString());
                // 详细地址
                dkAttributes.setXXDZ(map.get("f_xxdz")  == null ? "": map.get("f_xxdz").toString());
                // 合法用地实际用途
                dkAttributes.setHF_SJYT(WpzfDicEnum.getCodeByTypeAndDesc("sjyt", map.get("f_sjyt")  == null ? "": map.get("f_sjyt").toString()));
                // 合法具体情形
                String f_hflx = map.get("f_hflx")  == null ? "": map.get("f_hflx").toString();
                String f_yblqthfy = map.get("f_yblqthfy")  == null ? "": map.get("f_yblqthfy").toString();
                if(StringUtils.isNotBlank(f_yblqthfy)) {
                    dkAttributes.setHF_JTQX(WpzfDicEnum.getCodeByTypeAndDesc("jtqx", f_yblqthfy));
                } else {
                    dkAttributes.setHF_JTQX(WpzfDicEnum.getCodeByTypeAndDesc("jtqx", f_hflx));
                }

                String f_qtydsjyt = map.get("f_qtlx")  == null ? "": map.get("f_qtlx").toString();
                String f_sdwbhlx = map.get("f_sdwbhlx")  == null ? "": map.get("f_sdwbhlx").toString();
                if(StringUtils.isNotBlank(f_sdwbhlx)) {
                    // 其他用地实际用途
                    dkAttributes.setQT_SJYT(WpzfDicEnum.getCodeByTypeAndDesc("qtsjyt", f_sdwbhlx));
                } else {
                    // 其他用地实际用途
                    dkAttributes.setQT_SJYT(WpzfDicEnum.getCodeByTypeAndDesc("qtsjyt", f_qtydsjyt));
                }
                // 是否新增乱占耕地建房
                dkAttributes.setSF_LZGDJF(map.get("f_sfxzlzgd")  == null ? "": map.get("f_sfxzlzgd").toString());
                // 是否大棚房
                dkAttributes.setSF_DPF(map.get("f_sfdpf")  == null ? "": map.get("f_sfdpf").toString());
                // 违法实际用途
                dkAttributes.setWFQK_SJYT(WpzfDicEnum.getCodeByTypeAndDesc("sjyt", map.get("f_sjyt")  == null ? "": map.get("f_sjyt").toString()));
                // 是否挖湖造景
                dkAttributes.setWFQK_SF_WHZJ(map.get("f_sfwhzj")  == null ? "": map.get("f_sfwhzj").toString());
                // 违法类型

                String f_wfpzzylx = map.get("f_wfpzzylx")  == null ? "": map.get("f_wfpzzylx").toString();
                String f_wfgdlx = map.get("f_wfgdlx")  == null ? "": map.get("f_wfgdlx").toString();
                String f_wfzdlx = map.get("f_wfzdlx")  == null ? "": map.get("f_wfzdlx").toString();
                String f_wgjylx = map.get("f_wgjylx")  == null ? "": map.get("f_wgjylx").toString();
                String f_clfnjswf = map.get("f_clfnjswf")  == null ? "": map.get("f_clfnjswf").toString();
                String f_nyssjswf = map.get("f_nyssjswf")  == null ? "": map.get("f_nyssjswf").toString();
                String f_sjfzlgyw = map.get("f_sjfzlgyw")  == null ? "": map.get("f_sjfzlgyw").toString();
                String wflx = "";
                if(StringUtils.isNotBlank(f_wfpzzylx)) {
                    wflx = f_wfpzzylx;
                } else if(StringUtils.isNotBlank(f_wfgdlx)) {
                    wflx = f_wfgdlx;
                } else if(StringUtils.isNotBlank(f_wfzdlx)) {
                    wflx = f_wfzdlx;
                } else if(StringUtils.isNotBlank(f_wgjylx)) {
                    wflx = f_wgjylx;
                } else if(StringUtils.isNotBlank(f_clfnjswf)) {
                    wflx = f_clfnjswf;
                } else if(StringUtils.isNotBlank(f_nyssjswf)) {
                    wflx = f_nyssjswf;
                } else if(StringUtils.isNotBlank(f_sjfzlgyw)) {
                    wflx = f_sjfzlgyw;
                }
                dkAttributes.setWFQK_WFLX(WpzfDicEnum.getCodeByTypeAndDesc("wflx", wflx));
                // 整改落实情况
                dkAttributes.setZGLX(WpzfDicEnum.getCodeByTypeAndDesc("zglx", map.get("f_zglsqk")  == null ? "": map.get("f_zglsqk").toString()));
                // 移交部门
                dkAttributes.setYJQK_YJBM(map.get("f_yjdbm")  == null ? "": map.get("f_yjdbm").toString());
                // 省级定性的判定类型
                dkAttributes.setSHENG_PDLX(map.get("f_sjdxdpdl")  == null ? "": map.get("f_sjdxdpdl").toString());
                // 省级定性的判定依据说明
                dkAttributes.setSHENG_PDYJ(map.get("f_sjdxdpdy")  == null ? "": map.get("f_sjdxdpdy").toString());
                // 省级定性人姓名
                dkAttributes.setSHENG_PDR(map.get("f_sjdxrxm")  == null ? "": map.get("f_sjdxrxm").toString());
                // 省级定性时间
                dkAttributes.setSHENG_PDSJ(TimeUtils.convertDateAndTimeFromOther(map.get("f_sjdxsj")  == null ? "": map.get("f_sjdxsj").toString()));
                // 省级定性违法类型
                dkAttributes.setSPD_WFLX(map.get("f_sjdxwflx")  == null ? "": map.get("f_sjdxwflx").toString());
                // 省级定性是否新增乱占耕地建房
                dkAttributes.setSPD_SF_LZGDJF(map.get("f_sjdxsfxz")  == null ? "": map.get("f_sjdxsfxz").toString());
                // 省级定性是否挖湖造景
                dkAttributes.setSPD_SF_WHZJ(map.get("f_sjdxsfwh")  == null ? "": map.get("f_sjdxsfwh").toString());
                // 省级定性是否大棚房
                dkAttributes.setSPD_SF_DPF(map.get("f_sjdxsfdp")  == null ? "": map.get("f_sjdxsfdp").toString());
                // 省级定性是否“基金项目”
                dkAttributes.setSPD_SF_JJXM(map.get("f_sjdxsfjj")  == null ? "": map.get("f_sjdxsfjj").toString());
                // 省级定性是否因防疫和防治重大疫情需要建设的医疗卫生设施
                dkAttributes.setSPD_SF_FZYQ(map.get("f_sjdxsfyf")  == null ? "": map.get("f_sjdxsfyf").toString());
                // 省级定性是否保障性安居房
                dkAttributes.setSPD_SF_BZXZF(map.get("f_sjdxsfbz")  == null ? "": map.get("f_sjdxsfbz").toString());
                // 市级定性的判定类型
                dkAttributes.setSHI_PDLX(map.get("f_sjdxd_n1")  == null ? "": map.get("f_sjdxd_n1").toString());
                // 市级定性的判定依据说明
                dkAttributes.setSHI_PDYJ(map.get("f_sjdxd_n2")  == null ? "": map.get("f_sjdxd_n2").toString());
                // 市级定性人姓名
                dkAttributes.setSHI_PDR(map.get("f_sjdx_n1")  == null ? "": map.get("f_sjdx_n1").toString());
                // 市级定性时间
                dkAttributes.setSHI_PDSJ(TimeUtils.convertDateAndTimeFromOther(map.get("f_sjd_n1")  == null ? "": map.get("f_sjd_n1").toString()));
                // 填表人姓名
//                dkAttributes.setTBR(map.get("f_tbrxm")  == null ? "": map.get("f_tbrxm").toString());
                dkAttributes.setTBR(map.get("f_username")  == null ? "": map.get("f_username").toString());
                // 填表时间
                dkAttributes.setTBSJ(s);
                String sjshjg = map.get("f_sjshjg")  == null ? "": map.get("f_sjshjg").toString();
                dkAttributes.setSHENG_SHJG(sjshjg);
                // 省级审核结果
                if(StringUtils.isNotBlank(sjshjg)) {
                    String sjshyj = map.get("f_sjshyj")  == null ? "": map.get("f_sjshyj").toString();
                    if(StringUtils.isBlank(sjshyj)) {
                        dkAttributes.setSHENG_SHJG("同意");
                    } else {
                        dkAttributes.setSHENG_SHJG(sjshyj);
                    }
                } else {
                    String sjshyj = map.get("f_sjshyj")  == null ? "": map.get("f_sjshyj").toString();
                    dkAttributes.setSHENG_SHJG(sjshyj);
                }
                dkAttributes.setSHENG_SHJG(map.get("f_sjshjg")  == null ? "": map.get("f_sjshjg").toString());
                // 省级审核意见
                dkAttributes.setSHENG_SHYJ(map.get("f_sjshyj")  == null ? "": map.get("f_sjshyj").toString());
                // 省级审核人姓名
                dkAttributes.setSHENG_SHR(map.get("f_sjshrxm")  == null ? "": map.get("f_sjshrxm").toString());
                // 省级审核时间
                dkAttributes.setSHENG_SHSJ(map.get("f_sjshsj")  == null ? "": map.get("f_sjshsj").toString());
                // 市级审核结果
                String sjpdlx = map.get("f_sjdxd_n1")  == null ? "": map.get("f_sjdxd_n1").toString();
                if(StringUtils.isNotBlank(sjpdlx)) {
                    String f_sjs_n2 = map.get("f_sjs_n2")  == null ? "": map.get("f_sjs_n2").toString();
                    if(StringUtils.isBlank(f_sjs_n2)) {
                        dkAttributes.setSHI_SHYJ("同意");
                    } else {
                        dkAttributes.setSHI_SHYJ(map.get("f_sjs_n2")  == null ? "": map.get("f_sjs_n2").toString());
                    }
                } else {
                    dkAttributes.setSHI_SHYJ(map.get("f_sjs_n2")  == null ? "": map.get("f_sjs_n2").toString());
                }
                dkAttributes.setSHI_SHJG(map.get("f_sjs_n1")  == null ? "": map.get("f_sjs_n1").toString());
                // 市级审核意见

                // 市级审核人姓名
                dkAttributes.setSHI_SHR(map.get("f_sjdx_n1")  == null ? "": map.get("f_sjdx_n1").toString());
//                dkAttributes.setSHI_SHR(map.get("f_sjsh_n1")  == null ? "": map.get("f_sjsh_n1").toString());
                // 市级审核时间
                dkAttributes.setSHI_SHSJ(map.get("f_sjs_n3")  == null ? "": map.get("f_sjs_n3").toString());
                // 违法行为编号
                dkAttributes.setWFXW_BH(map.get("f_wfxwbh")  == null ? "": map.get("f_wfxwbh").toString());
                // 项目类型
                dkAttributes.setXMLX(map.get("f_xmlx")  == null ? "": map.get("f_xmlx").toString());
                // 项目名称
                dkAttributes.setXMMC(map.get("f_xmmc")  == null ? "": map.get("f_xmmc").toString());
                // 项目主体
                dkAttributes.setXMZT(map.get("f_xmzt")  == null ? "": map.get("f_xmzt").toString());
                // 立项批准机关
                dkAttributes.setLXPZJG(map.get("f_lxpzjg")  == null ? "": map.get("f_lxpzjg").toString());
                // 立项批准文号
                dkAttributes.setLXPZWH(map.get("f_lxpzwh")  == null ? "": map.get("f_lxpzwh").toString());
                // 是否因防疫和防治重大疫情需要建设的医疗卫生设施
                dkAttributes.setSF_FZYQ(map.get("f_sfyfyhfz")  == null ? "": map.get("f_sfyfyhfz").toString());
                // 是否保障性安居住房
                dkAttributes.setSF_BZXZF(map.get("f_sfbzxajz")  == null ? "": map.get("f_sfbzxajz").toString());
                // 是否“基金项目”
                dkAttributes.setSF_JJXM(map.get("f_sfjjxm")  == null ? "": map.get("f_sfjjxm").toString());
                // 处理方式
                dkAttributes.setCLFS(map.get("f_clfs")  == null ? "": map.get("f_clfs").toString());
                // 立案编号
                dkAttributes.setLABH(map.get("f_labh")  == null ? "": map.get("f_labh").toString());
                // 省外业核查意见
                dkAttributes.setSHENG_HCYJ(map.get("f_swyhcyj")  == null ? "": map.get("f_swyhcyj").toString());
                // 省外业核查人
                dkAttributes.setSHENG_HCR(map.get("f_swyhcr")  == null ? "": map.get("f_swyhcr").toString());
                // 省外业核查时间
                dkAttributes.setSHENG_HCSJ(map.get("f_swyhcsj")  == null ? "": map.get("f_swyhcsj").toString());
                // 拆除复耕省内业审核意见
                dkAttributes.setCCFGS_SHYJ(map.get("f_ccfgsnys")  == null ? "": map.get("f_ccfgsnys").toString());
                // 拆除复耕省内业审核人
                dkAttributes.setCCFGS_SHR(map.get("f_ccfgs_n1")  == null ? "": map.get("f_ccfgs_n1").toString());
                // 拆除复耕省内业审核时间
                dkAttributes.setCCFGS_SHSJ(map.get("f_ccfgs_n2")  == null ? "": map.get("f_ccfgs_n2").toString());
                // 拆除复耕省外业核查意见
                dkAttributes.setCCFGS_HCYJ(map.get("f_ccfgswyh")  == null ? "": map.get("f_ccfgswyh").toString());
                // 拆除复耕省外业核查人
                dkAttributes.setCCFGS_HCR(map.get("f_ccfgs_n3")  == null ? "": map.get("f_ccfgs_n3").toString());
                // 拆除复耕省外业核查时间
                dkAttributes.setCCFGS_HCSJ(map.get("f_ccfgs_n4")  == null ? "": map.get("f_ccfgs_n4").toString());
                resultDK.setDKAttributes(dkAttributes);
                resultDKList.add(resultDK);
            }
            data.setResultTBList(resultTBList);
            data.setResultDKList(resultDKList);
//            String s = digitalSignEncryed(data.toXml());
            String encrypt = SM3Util.encrypt(data.toXml());
            head.setDigitalSign(encrypt);
            message.setHead(head);
            message.setData(data);
        } else {
            // 模拟数据
            message = WpzfCallBackServiceImpl.getExample();
        }
        xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + message.toXml();
        return xmlStr;
    }
    // TODO
    private List<Data.File> getFileList(Map map, List<AppMedia> appMediaList, Data.DKAttributes dkAttributes, String secondDir, String regionCode) {
        List<Data.File> fileList = new ArrayList<>();
        String jctbbh = map.get("f_jctbbh") == null ? "": map.get("f_jctbbh").toString();
        String f_yszmwj = map.get("f_yszmwj") == null ? "" : map.get("f_yszmwj").toString();
        String f_tbpdfj = map.get("f_tbpdfj") == null ? "" : map.get("f_tbpdfj").toString();
        List<TbtskTaskDkpw> dkpwList = tbtskTaskDkpwRepository.getPwListByTaskIdAndTbId("3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2",
                map.get("f_id").toString());
        List<TbtskTaskDkpw> qtydpw = dkpwList.stream().filter(u -> "其他用地批文".equals(u.getfHfpwlx())).collect(Collectors.toList());
        List<TbtskTaskDkpw> scbbsx = dkpwList.stream().filter(u -> "上传补办手续".equals(u.getfHfpwlx())).collect(Collectors.toList());
        List<TbtskTaskDkpw> hfydpw = dkpwList.stream().filter(u -> "合法用地批文".equals(u.getfHfpwlx())).collect(Collectors.toList());
        // 先填外业的
        int i = 0;
        for (AppMedia appMedia : appMediaList) {
            String path = appMedia.getServerpath();
            i ++;
            Data.File file = new Data.File();
            file.setID(i + "");
            file.setX(appMedia.getLon() + "");
            file.setY(appMedia.getLat() + "");
            file.setAngle(appMedia.getAzimuth());
            file.setFileName(path.substring(path.lastIndexOf("/") + 1));
            file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
            file.setFileSource(2 + "");
            if(StringUtils.isNotBlank(appMedia.getCreateTime())) {
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(appMedia.getCreateTime()));
            } else {
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(appMedia.getTime()));
            }
            file.setShootTime(TimeUtils.convertDateAndTimeFromOther(appMedia.getTime()));
            file.setUploadUserName(appMedia.getUsername());
            String fileName = "WY_" + i + "_" + file.getFileName();
            file.setFileURL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
            fileList.add(file);
        }
        if(StringUtils.isNotBlank(f_yszmwj)) {
            String[] split = f_yszmwj.split("/");
            Data.File file = new Data.File();
            file.setID(1 + "");
            file.setFileName(split[split.length - 1]);
            file.setFileExt(f_yszmwj.substring(f_yszmwj.lastIndexOf(".") + 1));
            file.setFileType(1 + "");
            file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
            LandUser landUser = landUserRepository.queryUserById(Long.parseLong(split[split.length - 4]));
            file.setUploadUserName(landUser.getName());
            file.setFileSource("1");
            String fileName = "NY_1_" + file.getFileName();
            file.setFileURL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
            fileList.add(file);
        }

        if(StringUtils.isNotBlank(f_tbpdfj)) {
            String[] split = f_tbpdfj.split("/");
            i ++;
            Data.File file = new Data.File();
            file.setID(2 + "");
            file.setFileName(f_tbpdfj.substring(f_tbpdfj.lastIndexOf("/") + 1));
            file.setFileExt(f_tbpdfj.substring(f_tbpdfj.lastIndexOf(".") + 1));
            file.setFileType(2 + "");
            file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
            LandUser landUser = landUserRepository.queryUserById(Long.parseLong(split[split.length - 4]));
            file.setUploadUserName(landUser.getName());
            file.setFileSource("1");
            String fileName = "NY_2_" + file.getFileName();
            file.setFileURL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
            fileList.add(file);
        }

        int pwCount = 0;
        if(qtydpw != null && qtydpw.size() > 0) {
            for (TbtskTaskDkpw tbtskTaskDkpw : qtydpw) {
                pwCount ++;
                String path = tbtskTaskDkpw.getfPwUrl();
                String[] split = path.split("/");
                Data.File file = new Data.File();
                file.setID(pwCount + "");
                file.setFileName(path.substring(path.lastIndexOf("/") + 1));
                file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
                file.setFileType(2 + "");
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
                LandUser landUser = landUserRepository.queryUserById(Long.parseLong(split[split.length - 4]));
                file.setUploadUserName(landUser.getName());
                file.setFileSource("1");
                String fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + file.getFileExt();
                file.setFileURL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                fileList.add(file);
            }
        }

        if(scbbsx != null && scbbsx.size() > 0) {
            for (TbtskTaskDkpw tbtskTaskDkpw : scbbsx) {
                pwCount ++;
                String path = tbtskTaskDkpw.getfPwUrl();
                String[] split = path.split("/");
                Data.File file = new Data.File();
                file.setID(pwCount + "");
                file.setFileName(path.substring(path.lastIndexOf("/") + 1));
                file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
                file.setFileType(1 + "");
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
                LandUser landUser = landUserRepository.queryUserById(Long.parseLong(split[split.length - 4]));
                file.setUploadUserName(landUser.getName());
                file.setFileSource("1");
                String fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + file.getFileExt();
                file.setFileURL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                fileList.add(file);
            }
        }

        if(hfydpw != null && hfydpw.size() > 0) {
            for (TbtskTaskDkpw tbtskTaskDkpw : hfydpw) {
                pwCount ++;
                String path = tbtskTaskDkpw.getfPwUrl();
                String[] split = path.split("/");
                Data.File file = new Data.File();
                file.setID(pwCount + "");
                file.setFileName(path.substring(path.lastIndexOf("/") + 1));
                file.setFileExt(path.substring(path.lastIndexOf(".") + 1));
                file.setFileType(3 + "");
                file.setUploadTime(TimeUtils.convertDateAndTimeFromOther(split[split.length - 2]));
                LandUser landUser = landUserRepository.queryUserById(Long.parseLong(split[split.length - 4]));
                file.setUploadUserName(landUser.getName());
                file.setFileSource("1");
                String fileName = "PW_" + tbtskTaskDkpw.getfPzwh() + "." + file.getFileExt();
                file.setFileURL(220000 + "\\" + secondDir + "\\" + regionCode + "\\" + jctbbh + "\\" + fileName);
                fileList.add(file);
            }
        }

        dkAttributes.setPW_Count(pwCount + "");
        dkAttributes.setPhoto_Count(appMediaList.size() + "");
        int nyCount = 0;
        if(StringUtils.isNotBlank(f_yszmwj)) {
            nyCount ++;
        }
        if(StringUtils.isNotBlank(f_tbpdfj)) {
            nyCount ++;
        }
        dkAttributes.setZMCL_Count(nyCount + "");
        return fileList;
    }





    private String digitalSignEncryed(String content) throws Exception {
        try {
            MessageDigest digest = MessageDigest.getInstance("SM3");
            byte[] hash = digest.digest(content.getBytes());

            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) hexString.append('0');
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            return "";
        }
    }



    private List<Map<String, Object>> getLastWeekendsForSubmitData(TskTaskBiz one, String regionCode) throws Exception {
        TbtskObjectinfo objectByTableId = tbtskObjectinfoRepository.getObjectByTableId(one.getTableId());
        Pair<String, String> lastNatureWeek = TimeUtils.getLastNatureWeek();
        String startTime = lastNatureWeek.getLeft();
        String endTime = lastNatureWeek.getRight();
//        List<TbtskSubmitReportRecord>  tbtskSubmitReportRecordList = tbtskSubmitReportRecordRepository.queryByTaskIdAndTime(one.getId(),
        List<TbtskSubmitReportRecord>  tbtskSubmitReportRecordList = tbtskSubmitReportRecordRepository.queryByTaskIdAndRegionCodeAndTime(one.getId(), regionCode,
                Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
        if(tbtskSubmitReportRecordList == null || tbtskSubmitReportRecordList.size() == 0) {
            throw new Exception("政区" + regionCode + ":" + startTime + "至" + endTime + "时间段内，无新提交图斑");
        }
//        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(objectByTableId.getfId());
//        List<String> fieldNameList = fields.stream().map(u -> u.getfFieldname()).collect(Collectors.toList());
        List<String> ids = tbtskSubmitReportRecordList.stream().map(u -> u.getDataid()).collect(Collectors.toList());

//        List<Map> maps = dataBizService.selectFieldByIds(objectByTableId.getfTablename(), fieldNameList, "f_id", ids);
        String join = String.join("','", ids);
        String sql = "with tem as(\n" +
                "\tselect tar.*, row_number() over (partition by tar.f_dataid, tar.f_taskid order by tar.f_updatetime desc) from tbtsk_assign_record tar \n" +
                "\twhere tar.f_taskid = '3db2d71b-deb1-4c45-b7d9-a99a9c5f95f2'\n" +
                ")\n" +
                "select ttztask.*, tem.f_createtime as xfsj, tu.f_username from tbtsk_task_znglrw_20231103095016456 ttztask\n" +
                "inner join tem on ttztask.f_id = tem.f_dataid " +
                "inner join tbsys_user tu on ttztask.f_submit_userid = tu.f_userid::TEXT " +
                "where tem.row_number = 1 and ttztask.f_id in('"+join+"')";
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);


        maps.stream().forEach(u -> {
            if(u.containsKey("f_shape")) {
                Object shape = u.get("f_shape");
                if(shape != null && shape.toString().contains("4490")) {
                    String replace = shape.toString().replace("4490", "4326");
                    u.put("f_shape", replace);
                } else if(shape != null){
                    String newShape = "SRID=4326;" + shape;
                    u.put("f_shape", newShape);
                }
            }
        });
        return maps;
    }


    /**
     * 解析返回接口数据
     * @param response
     * @return
     * @throws Exception
     */
    public static String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }

    public static String getRootDirName(int xh,String regionCode) throws Exception {
        if(StringUtils.isBlank(regionCode) || regionCode.length() < 6) {
            throw new Exception("图斑政区代码异常");
        }
        String xzqh = regionCode.substring(0, 6);
        Calendar instance = Calendar.getInstance();
        int year = instance.get(Calendar.YEAR);
        int month = instance.get(Calendar.MONTH) + 1;
        int day = instance.get(Calendar.DAY_OF_MONTH);
        String date = "" + year + month + day;
        String platform = "220";
        String no = getFixLengthNo(xh);
        return xzqh + date + platform + no;
    }

    private static String getFixLengthNo(int xh) {
        String no = "";
        if(xh > 999999) {
            no = xh + "";
        } else {
            int length = 7 - (xh + "").length();
            String repeat = StringUtils.repeat("0", length);
            no = repeat + xh;
        }
        return no;
    }


    public static void main(String[] args) {
        int xh = 33335608;
        String no = "";
        if(xh > 999999) {
            no = xh + "";
        } else {
            int length = 7 - (xh + "").length();
            String repeat = StringUtils.repeat("0", length);
            no = repeat + xh;
        }
        System.out.println(no + "=================");
    }



    public static File buildXml(String text, String filename) throws IllegalAccessException, IOException {

        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + text;
        File file = new File(filename);
        if(!file.exists()) {
            file.createNewFile();
        }
        writeText2File(file, xmlStr);
        return file;
    }

    public static void writeText2File(File file, String text) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(new FileOutputStream(file.getAbsoluteFile()), StandardCharsets.UTF_8);
            writer.write(text);
            writer.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if(writer != null) {
                try {
                    writer.close();
                }catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    public static void writeText2File3(File file, String text) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            writer.getEncoding();



            char[] chars = text.toCharArray();
            writer.write(chars);
            writer.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if(writer != null) {
                try {
                    writer.close();
                }catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }



    public boolean sendHttpRequest(TbGjhtCgtj tbGjhtCgtj, int xh, int tbs, int year, String zipname, String url, String token, String md5) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //回调国家接口进行信息反馈
//        String gjurl=gjckUrl+"/mdc/v1/wpzf/DataRec";
        String gjurl = "https://dc2.landcloud.org.cn:9443/webapi/wpzf/DataRec";
        JSONObject result = new JSONObject();
        HttpClient httpClient = HttpClientBuilder.create().build();

        HttpPost httpPost = new HttpPost();
        httpPost.setURI(URI.create(gjurl));
        httpPost.setHeader("Content-Type","application/json");

        JSONObject param=new JSONObject();
        param.put("xh", xh);
        param.put("tbs", tbs);
        param.put("jgtype", 220);
        param.put("nd", year);
        param.put("sumzip", 1);
        param.put("cfdks", 0);
        param.put("zipname", zipname);
        param.put("tbdks", 0);
        param.put("url", url);
        param.put("token", token);
        param.put("md5", md5);
        httpPost.setEntity(new StringEntity(JSONObject.toJSONString(param, SerializerFeature.WriteMapNullValue),"UTF-8"));

        HttpResponse response = httpClient.execute(httpPost);
        String httpEntityContent = getHttpEntityContent(response);
        result = JSONObject.parseObject(httpEntityContent);
        if (result.containsKey("flag") && "true".equalsIgnoreCase(result.getString("flag"))) {
            tbGjhtCgtj.setMsg(result.getString("message"));
            return true;
        }else{
            tbGjhtCgtj.setMsg(result.getString("message"));
            return false;
        }
    }





    public static Message getExample() throws IllegalAccessException {
        Message message = new Message();
        try {
            Head head = new Head();
            head.setMsgID("h111");
            head.setCommitCode("h222");
            head.setXZQDM("h333");
            head.setDataTransTime("h444");
            head.setDigitalSign("h555");
            Data data = new Data();
            List<Data.ResultDK> resultDKList = new ArrayList<>();
            Data.ResultDK resultDK1 = new Data.ResultDK();
            Data.ResultDK resultDK2 = new Data.ResultDK();
            completeDk(resultDK1);
            resultDKList.add(resultDK1);
            resultDKList.add(resultDK2);
            List<Data.ResultTB> resultTBList = new ArrayList<>();
            Data.ResultTB resultTB1 = new Data.ResultTB();
            Data.ResultTB resultTB2 = new Data.ResultTB();
            completeTB(resultTB1);
            resultTBList.add(resultTB1);
            resultTBList.add(resultTB2);
            data.setResultDKList(resultDKList);
            data.setResultTBList(resultTBList);
            message.setHead(head);
            message.setData(data);
            String s = message.toXml();
            System.out.println("===================");
            System.out.println(s);
            System.out.println("===================");
        } catch (Exception e) {
            System.out.println();
        }
        return message;
    }


    private static void completeTB(Data.ResultTB resultTB1) {
        resultTB1.setJCBH("tb11");
        resultTB1.setXFSJ("tb22");
        resultTB1.setSF_SK("tb33");
        resultTB1.setSK_UserName("tb44");
        resultTB1.setSK_UserPhone("tb55");
        resultTB1.setGeoUpdateTime("tb66");
        resultTB1.setSF_QR_CXBH("tb77");
        resultTB1.setGeoDealType("tb88");
        resultTB1.setDK_Count("tb99");
        List<Data.DK> dkList = new ArrayList<>();
        Data.DK dk = new Data.DK();
        dk.setDKBH("dk11");
        dk.setDKMJ("dk22");
        dk.setNYDMJ("dk33");
        dk.setGDMJ("dk44");
        dk.setSTMJ("dk55");
        dk.setYJ_JBNTMJ("dk66");
        dk.setSTBHHXMJ("dk77");
        dk.setShape("POLYGON ((108.51562988500001 22.808178527999985, 108.51562988500001 22.808178527999985))");
        dkList.add(dk);
        resultTB1.setDKList(dkList);
    }

    private static void completeDk(Data.ResultDK resultDK1) {
        Data.DKAttributes attributes = new Data.DKAttributes();
        attributes.setCCFGS_HCR("attr11");
        attributes.setCCFGS_HCSJ("attr22");
        attributes.setDKBH("attr33");
        resultDK1.setDKAttributes(attributes);

        List<Data.PW> pwList = new ArrayList<>();
        Data.PW pw = new Data.PW();
        Data.PW pw2 = new Data.PW();
        pw.setPZWH("pw11");
        pw.setPW_Source("pw22");
        pw.setLocationURL("pw33");
        pw.setPW_URL("pw44");
        pwList.add(pw);
        pwList.add(pw2);
        resultDK1.setPWlist(pwList);

        List<Data.File> fileList = new ArrayList<>();
        Data.File file = new Data.File();
        Data.File file2 = new Data.File();
        file.setID("file11");
        file.setX("file22");
        file.setFileURL("file3");
        fileList.add(file);
        fileList.add(file2);
        resultDK1.setFileList(fileList);
    }

    public static String getMD5Checksum(String filePath) throws Exception {
        byte[] buffer = new byte[1024];
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");

        try (InputStream fis = new FileInputStream(filePath)) {
            int bytesRead;
            while ((bytesRead = fis.read(buffer)) != -1) {
                md5Digest.update(buffer, 0, bytesRead);
            }
        }

        byte[] digest = md5Digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }


}
