package com.geoway.landteam.landcloud.service.xzjsydmj;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskBizRepository;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBiz;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.AtlasTaskInfo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.xzjsydmj.MXzjsydmjService;
import com.geoway.landteam.landcloud.service.cffx.MCffxTaskServiceImpl;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.io.*;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MXzjsydmjServiceImpl implements MXzjsydmjService {
    private final GiLoger logger = GwLoger.getLoger(MCffxTaskServiceImpl.class);
    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${transmit.url:}")
    String transmitUrl;
    @Value("${transmit.xzjsydmj.appkey:}")
    String transmitAppkey;
    @Value("${transmit.xzjsydmj.module:}")
    String transmitModule;
    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    SysConfigRepository sysConfigRepository;

    @Autowired
    TaskRecordService taskRecordService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    DataBizMapper dataBizMapper;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    String key="xzjsydmj-config";
    @Override
    public boolean needXzjsydmj(String taskId) {
        SysConfig config = sysConfigService.findOne(key);
        if(config!=null)
        {
            JSONObject jsonConfig =  JSONObject.parseObject(config.getValue());
            if(jsonConfig.containsKey("tasks"))
            {
                JSONArray jsonArray = jsonConfig.getJSONArray("tasks");
                Optional<JSONObject> op =  jsonArray.stream().filter(t->taskId.equals(((JSONObject)t).getString("taskId"))).findFirst();
                if(op.isPresent())
                {
                   return true;
                }
            }
        }
        return false;
    }

    @Override
    public void xzjsydmj(List<String> xzjsydmjSql, String table,String taskId, List<String> fields, String shapeField) {
          if(xzjsydmjSql==null||xzjsydmjSql.isEmpty())
              return;
        SqlliteConnTool connTool =null;
        Statement statement=null;
        String destination = uploadDir + File.separator + UUID.randomUUID().toString() + ".db";
          try {

              connTool = createTable(null,table, fields);
              if(connTool==null)
                  return;
              boolean insertSuc = insert(connTool,xzjsydmjSql, table, fields);
              if(!insertSuc)
                  return;
              List<String>recordFields = new ArrayList<>();
              recordFields.add("f_record_id");
              connTool = createTable(connTool,"task_record", recordFields);
              List<String>recordSqls = new ArrayList<>();
              String recordId = UUID.randomUUID().toString();
              recordSqls.add("insert into task_record(f_record_id) values ('"+recordId+"')");
              insertSuc = insert(connTool,recordSqls, "task_record", recordFields);
              if(!insertSuc)
                  return;
              statement = connTool.getConnection().createStatement();
              statement.executeUpdate("backup to '" + destination + "'");
              statement.close();
              connTool.Dispose();
              statement=null;
              connTool=null;
              JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(destination), transmitUrl+"/monitor/trans/transData.action");
              if(httpResult==null||!"200".equals(httpResult.getString("code")))
              {
                  logger.error("计算新增建设用地面积失败,发送文件失败"+httpResult==null?"":httpResult.toJSONString());
                  return;
              }
              TaskRecord record = new TaskRecord();
              record.setId(recordId);
              record.setTasktype(JobConstants.JOB_TYPE_XZJSYDMJ_INNER_ATLAS);
              record.setState(JobConstants.JOB_STATE_RUNNING);
              record.setBizId(taskId);
              taskRecordService.save(record);
          }
          catch (Exception ex)
          {
              try {
                  if (statement != null) {
                      statement.close();
                  }
                  if (connTool != null) {
                      connTool.Dispose();
                  }
              }
              catch (Exception e)
              {
                  logger.error("计算新增建设用地面积释放db失败"+ ExceptionUtil.getErrorString(e));
              }
              logger.error("计算新增建设用地面积失败"+ ExceptionUtil.getErrorString(ex));
          }
          finally {
              FileUtils.deleteQuietly(new File(destination));
          }

    }

    @Override
    public void resoveInner(File recvFile) throws Exception {
        String resultname=null;
        String tablename=null;
        TaskRecord  record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setTasktype(JobConstants.JOB_TYPE_XZJSYDMJ_INNER_ATLAS);
        record.setState(JobConstants.JOB_STATE_FAILED);
        record.setStarttime(new Date());
        try{
        SysConfig sysconfig = sysConfigService.findOne(key);
        if(sysconfig==null)
        {
            logger.error("内网网间传输接收XZJSYDMJ任务处理失败,未配置擦除数据及擦除分析服务");
            return;
        }
        XzjsydmjConfig config = JSONObject.parseObject(sysconfig.getValue(),XzjsydmjConfig.class);
        tablename = "temp_xzjs_" + UUID.randomUUID().toString().replace("-", "");
        String dbleft = getDB();
        String dbright = dbleft;
        if(StringUtils.isNotBlank(config.fjsydDb))
        {
            dbright = config.fjsydDb;
        }
         resultname = "intersect_" + UUID.randomUUID().toString().replace("-", "");

            if(recvFile!=null)
            {
                String id =  importDbData(recvFile, tablename);
                record.setId(id);
            }
            String template = getTemplate("erase.json");
            Map<String,String>mapParam = new HashMap<>();
            mapParam.put("{left}",dbleft+"/"+tablename);
            mapParam.put("{leftPkField}","aid");
            mapParam.put("{leftShapeField}","f_shape");
            mapParam.put("{leftWhere}","1=1");
            mapParam.put("{right}",dbright+"/"+config.fjsydTable);
            mapParam.put("{rightPkField}",config.fjsydPkField);
            mapParam.put("{rightShapeField}",config.fjsydShapeField);
            mapParam.put("{rightWhere}","1=1");
            mapParam.put("{result}",resultname);
            mapParam.put("{resultdb}",dbleft+"/"+resultname);
            for(Map.Entry<String,String>kv:mapParam.entrySet())
            {
                template = template.replace(kv.getKey(), kv.getValue());
            }


            logger.info("atlas service url:" + config.atlasUrl + " param:" + template);
            String result = HttpUtil.createPost(config.atlasUrl).body(template).execute().body();
            logger.info("atlas service url:" + config.atlasUrl + " http result: " + result);
            if(StringUtils.isNotBlank(result)) {
                JSONObject resultJson = JSONObject.parseObject(result);
                if (resultJson.containsKey("code") && resultJson.getString("code").equals("200")) {
                    String taskId = resultJson.getJSONObject("data").getString("taskId");
                    TempParam param = new TempParam();
                    param.setAtlasId(taskId);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(1);
                    record.setParam(JSONObject.toJSONString(param));
                    record.setState(JobConstants.JOB_STATE_CREATE);
                }
                else
                {
                    TempParam param = new TempParam();
                    param.setAtlasId(null);
                    param.setTempTable(tablename);
                    param.setResultTable(resultname);
                    param.setAtlasState(3);
                    record.setParam(JSONObject.toJSONString(param));
                    record.setState(JobConstants.JOB_STATE_FAILED);
                    record.setLog("创建atlas任务失败");
                    TableUtil.dropTable(tablename, jdbcTemplate);
                }
            }


        } catch (Exception ex) {
            if(StringUtils.isNotBlank(tablename)) {
                TableUtil.dropTable(tablename, jdbcTemplate);
            }
            String msg = ex.getMessage();
            if(StringUtils.isBlank(msg))
            {
                msg = ExceptionUtil.getStackTrace(ex);
            }
            record.setState(JobConstants.JOB_STATE_FAILED);
            logger.error("新增建设用地面积计算失败\n"+msg);
            if(msg.length()>1000)
            {
                msg=msg.substring(0,1000);
            }
            record.setLog(msg);
        } finally {
            // 删除文件夹
            taskRecordService.save(record);
        }

    }

    @Override
    public void runTaskInner(TaskRecord record)
    {
        SysConfig sysconfig = sysConfigService.findOne(key);
        if(sysconfig==null)
        {
            logger.error("内网网间传输接收XZJSYDMJ任务处理失败,未配置擦除数据及擦除分析服务");
            return;
        }
        TempParam param = JSONObject.parseObject(record.getParam(),TempParam.class);
        if(param.getAtlasState()!=null&&param.getAtlasState().equals(1)) {
            XzjsydmjConfig config = JSONObject.parseObject(sysconfig.getValue(),XzjsydmjConfig.class);

            String atlasId = param.getAtlasId();
            String atlasUrl = config.atlasUrl;
            String url = atlasUrl.substring(0, atlasUrl.indexOf("/analysis"));
            url = url + "/task/get?id=" + atlasId;
            HttpRequest get = HttpUtil.createGet(url);
            cn.hutool.http.HttpResponse execute = get.execute();
            String bodyStr = execute.body();
            if (execute.getStatus() == 200) {
                JSONObject body = JSONObject.parseObject(bodyStr);
                if (body.get("code").equals(200)) {
                    AtlasTaskInfo taskDto = JSONObject.parseObject(body.get("data").toString(), AtlasTaskInfo.class);
                    if (taskDto.getFinished()) {

                        if (taskDto.getSucceed()) {
                            param.setAtlasState(2);
                            record.setParam(JSONObject.toJSONString(param));
                            record.setState(JobConstants.JOB_STATE_RUNNING);
                        } else {
                            param.setAtlasState(3);
                            record.setParam(JSONObject.toJSONString(param));
                            record.setState(JobConstants.JOB_STATE_FAILED);
                            TableUtil.dropTable(param.tempTable,jdbcTemplate);
                        }

                    }
                    taskRecordService.save(record);
                    String destination=null;
                    try {
                        if (param.getAtlasState().equals(2)) {

                            String resultTable = param.getResultTable();
                            List<String> fields = new ArrayList<>();
                            fields.add("mj");
                            fields.add("f_id");
                            fields.add("f_taskid");
                            fields.add("f_split");
                            List<Map<String,Object>>maps = jdbcTemplate.queryForList("select f_taskid,f_id,f_split,sum(shapearean) as mj from "+resultTable+" group by f_taskid, f_id,f_split");
                            destination = uploadDir + File.separator + record.getId() + ".db";
                            xzjsydmj(destination,maps,fields,record.getId());

                            JSONObject httpResult = com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil.sendRrquestByFile( transmitAppkey, transmitModule, new File(destination), transmitUrl+"/monitor/trans/transData.action");
                            if(httpResult==null||!"200".equals(httpResult.getString("code")))
                            {
                                logger.error("发送文件失败"+httpResult==null?"":httpResult.toJSONString());
                                record.setLog("发送文件失败");
                                record.setState(JobConstants.JOB_STATE_FAILED);
                                taskRecordService.save(record);
                                TableUtil.dropTable(param.tempTable,jdbcTemplate);
                                TableUtil.dropTable(param.resultTable,jdbcTemplate);
                                return;
                            }
                            record.setState(JobConstants.JOB_STATE_SUCCESS);
                            taskRecordService.save(record);

                        }
                    }
                    catch (Exception ex)
                    {
                        logger.error("新增建设用地面积计算失败"+ExceptionUtil.getErrorString(ex));
                        record.setLog("新增建设用地面积计算失败");
                        record.setState(JobConstants.JOB_STATE_FAILED);
                        taskRecordService.save(record);
                        TableUtil.dropTable(param.tempTable,jdbcTemplate);
                        TableUtil.dropTable(param.resultTable,jdbcTemplate);
                    }
                    finally {
                        FileUtils.deleteQuietly(new File(destination));
                    }
                }
            }
        }
    }

    @Override
    public void resoveOuter(File recvFile) throws Exception {
        TaskRecord taskRecord = null;
        try{


            SqlliteConnTool connTool = new SqlliteConnTool(recvFile.getAbsolutePath());
            Object recordObj = connTool.queryScale("select f_record_id from task_record");
            String recordId = recordObj==null?"":recordObj.toString();
            taskRecord =  taskRecordService.findOne(recordId);
            if(taskRecord==null)
            {
                logger.error("新增建设用地面积任务:"+recordId+"不存在");
                return;
            }
            String bizId = taskRecord.getBizId();
            TskTaskBiz task = tskTaskBizService.findByTaskId(bizId);
            if(task==null)
            {
                logger.error("新增建设面积计算异常,业务任务:"+bizId+"不存在");
                throw new RuntimeException("新增建设面积计算异常,业务任务:"+bizId+"不存在");
            }

            TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            if(objectinfo==null)
            {
                logger.error("新增建设面积计算异常,业务任务:"+bizId+"表对象不存在");
                throw new RuntimeException("新增建设面积计算异常,业务任务:"+bizId+"表对象不存在");
            }
            String xzjsydmjField=null;
            SysConfig config = sysConfigService.findOne(key);
            if(config!=null)
            {
                JSONObject jsonConfig =  JSONObject.parseObject(config.getValue());
                if(jsonConfig.containsKey("tasks"))
                {
                    JSONArray jsonArray = jsonConfig.getJSONArray("tasks");
                    Optional<JSONObject> op =  jsonArray.stream().filter(t->bizId.equals(((JSONObject)t).getString("taskId"))).findFirst();
                    if(op.isPresent())
                    {
                        xzjsydmjField = op.get().getString("xzjsydmjField");
                    }
                }
            }
            if(StringUtils.isBlank(xzjsydmjField))
            {
                logger.error("新增建设用地面积字段为空");
                throw new RuntimeException("新增建设用地面积字段为空");
            }
            if(!connTool.isTableExist("xzjsydmj"))
            {

                logger.error("新增建设面积计算异常,db内表:xzjsydmj不存在");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj不存在");
            }
            Object obj = connTool.queryScale("select count(*) as count from xzjsydmj");
            if(obj==null||StringUtils.isBlank(obj.toString()))
            {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj为空");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj为空");
            }
            int count = Integer.parseInt(obj.toString());
            if(count==0)
            {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj为空");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj为空");
            }
            ResultSetInfo resutSetInfo =  connTool.doQuery("select * from xzjsydmj");
            if (resutSetInfo == null) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj读取失败");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj读取失败");
            }
            ResultSet resultSet = resutSetInfo.getResultSet();
            if (resultSet == null) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj读取失败");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj读取失败");
            }
            java.text.DecimalFormat df = new java.text.DecimalFormat("#.00");
            while (resultSet.next())
            {
                String tbid = resultSet.getString("f_id");
                String split = resultSet.getString("f_split");
                Double mj = resultSet.getDouble("mj");
                String mjStr = df.format(mj);
                if("0".equals(split))
                {
                   jdbcTemplate.execute("update "+objectinfo.getfTablename()+" set "+xzjsydmjField+" = "+ mjStr+" where f_id ='"+tbid+"'");
                }
                else if("1".equals(split))
                {
                    jdbcTemplate.execute("update "+objectinfo.getfTablename()+"_child set "+xzjsydmjField+" = "+ mjStr+" where f_id ='"+tbid+"'");
                }
            }

            taskRecord.setState(JobConstants.JOB_STATE_SUCCESS);

        } catch (Exception ex) {

            String msg = ex.getMessage();
            if(StringUtils.isBlank(msg))
            {
                msg = ExceptionUtil.getStackTrace(ex);
            }
            taskRecord.setState(JobConstants.JOB_STATE_FAILED);
            logger.error("新增建设用地面积计算失败\n"+msg);
            if(msg.length()>1000)
            {
                msg=msg.substring(0,1000);
            }
            taskRecord.setLog(msg);
        } finally {

            taskRecordService.save(taskRecord);
        }

    }
    private void xzjsydmj(String dbPath, List<Map<String,Object>>maps,List<String>fields,String recordId) throws Exception {
        SqlliteConnTool connTool =null;
        Statement statement=null;
        try {
            List<String>recordFields = new ArrayList<>();
            recordFields.add("f_record_id");
            connTool = createTable(null,"task_record", recordFields);
            if(connTool==null)
               throw  new Exception("创建任务记录表失败");
            List<String>recordSqls = new ArrayList<>();

            recordSqls.add("insert into task_record(f_record_id) values ('"+recordId+"')");
            boolean insertSuc = insert(connTool,recordSqls, "task_record", recordFields);
            if(!insertSuc)
                throw  new Exception("写任务记录表失败");

            connTool = createTable(connTool,"xzjsydmj", fields);
            if(connTool==null)
                throw  new Exception("创建新增建设用地面积表失败");
            List<String>xzjsydmjSql=new ArrayList<>();
            for(Map m:maps)
            {
                String insert = "insert into xzjsydmj (";
                String values="";
                int index=0;
                int size = fields.size();
                for(String f:fields)
                {
                    insert+=f;
                    values= values + "'"+m.get(f).toString()+"'";
                    index++;
                    if(index<size)
                    {
                        insert+=",";
                        values+=",";
                    }
                }
                insert = insert+") values ("+values+")";
                xzjsydmjSql.add(insert);
                if(xzjsydmjSql.size()==100)
                {
                    insertSuc = insert(connTool,xzjsydmjSql, "xzjsydmj", fields);
                    if(!insertSuc)
                        throw  new Exception("写入新增建设用地面积表失败");
                    xzjsydmjSql.clear();
                }
            }
            insertSuc = insert(connTool,xzjsydmjSql, "xzjsydmj", fields);
            if(!insertSuc)
                throw  new Exception("写入新增建设用地面积表失败");
            xzjsydmjSql.clear();

            statement = connTool.getConnection().createStatement();
            statement.executeUpdate("backup to '" + dbPath + "'");
            statement.close();
            connTool.Dispose();
            statement=null;
            connTool=null;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connTool != null) {
                    connTool.Dispose();
                }
            }
            catch (Exception e)
            {
                logger.error("计算新增建设用地面积释放db失败"+ ExceptionUtil.getErrorString(e));
            }
        }

    }


    private String getDB() {
        DataSource dataSource = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource) dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split(url, "?");
        url = urls[0];// StringUtils.replace(urls[0], "jdbc:", "");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }


    private String importDbData( File file, String tableName) throws Exception {
        SqlliteConnTool connTool=null;
        ResultSetInfo resutSetInfo=null;
        try {
            String db = file.getAbsolutePath();
            connTool = new SqlliteConnTool(db);
            Object recordObj = connTool.queryScale("select f_record_id from task_record");
            String recordId = recordObj == null ? "" : recordObj.toString();
            if (!connTool.isTableExist("xzjsydmj")) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj不存在");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj不存在");
            }
            Object obj = connTool.queryScale("select count(*) as count from xzjsydmj");
            if (obj == null || StringUtils.isBlank(obj.toString())) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj为空");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj为空");
            }
            int count = Integer.parseInt(obj.toString());
            if (count == 0) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj为空");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj为空");
            }
            resutSetInfo = connTool.doQuery("select * from xzjsydmj");
            if (resutSetInfo == null) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj读取失败");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj读取失败");
            }
            ResultSet resultSet = resutSetInfo.getResultSet();
            if (resultSet == null) {
                logger.error("新增建设面积计算异常,db内表:xzjsydmj读取失败");
                throw new RuntimeException("新增建设面积计算异常,db内表:xzjsydmj读取失败");
            }

            Map<String, String> mapFields = getTableColumns();

            createShpTable(mapFields, jdbcTemplate, tableName);
            List<String> fields = mapFields.keySet().stream().collect(Collectors.toList());
            List<Map<String, Object>> tbList = new ArrayList<>();
            while (resultSet.next()) {
                Map<String, Object> tb = new HashMap<>();
                for (String f : fields) {
                    String v = resultSet.getString(f);
                    if(f.equals("f_shape"))
                    {
                        if(!v.toLowerCase().startsWith("srid"))
                        {
                            v ="srid=4490;"+v;
                        }
                    }
                    tb.put(f, v);
                }
                tbList.add(tb);
                if (tbList.size() == 100) {
                    dataBizMapper.insertBatch(tableName, tbList, "f_shape");
                    tbList.clear();
                }
            }
            if (!tbList.isEmpty()) {
                dataBizMapper.insertBatch(tableName, tbList, "f_shape");
                tbList.clear();
            }

            return recordId;
        }
        finally {
            if(resutSetInfo!=null) {
                resutSetInfo.Close();
            }
            if(connTool!=null)
            {
                connTool.Dispose();
            }
        }

    }

    private void createShpTable(Map<String, String> mapFields, JdbcTemplate jdbcTemplate, String tableName) {

        if (!TableUtil.tableExist(tableName, jdbcTemplate)) {
            String sql = "create table " + tableName + " (";
            for (Map.Entry<String, String> kv : mapFields.entrySet()) {
                sql += kv.getKey() + " " + kv.getValue() + ",";
            }
            sql = sql.substring(0, sql.length() - 1);
            sql += " )";
            jdbcTemplate.execute(sql);
            jdbcTemplate.execute("select updategeometrysrid('" + tableName + "','f_shape',4490)");
            TableUtil.createSequence(tableName, "aid", tableName + "_aid", jdbcTemplate);
        }

    }


    private String getTemplate(String fileName) {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/" + fileName);
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result += s;
            }
            return result;
        } catch (Exception ex) {
            logger.error("读取分析模型失败" + ExceptionUtil.getErrorString(ex));
            return null;
        }

    }

    private Map<String,String>getTableColumns()
    {
        Map<String,String>fields = new HashMap<>();
        fields.put("f_id", "varchar(100) NULL");
        fields.put("f_taskid", "varchar(100) NULL");
        fields.put("f_split", "varchar(100) NULL");
        fields.put("f_shape", "public.geometry NOT NULL");
        return fields;
    }

    public class XzjsydmjConfig
    {
        private String atlasUrl;
        private String fjsydDb;
        private String fjsydTable;
        private String fjsydShapeField;
        private String fjsydPkField;


        public String getAtlasUrl() {
            return atlasUrl;
        }

        public void setAtlasUrl(String atlasUrl) {
            this.atlasUrl = atlasUrl;
        }

        public String getFjsydDb() {
            return fjsydDb;
        }

        public void setFjsydDb(String fjsydDb) {
            this.fjsydDb = fjsydDb;
        }

        public String getFjsydTable() {
            return fjsydTable;
        }

        public void setFjsydTable(String fjsydTable) {
            this.fjsydTable = fjsydTable;
        }

        public String getFjsydShapeField() {
            return fjsydShapeField;
        }

        public void setFjsydShapeField(String fjsydShapeField) {
            this.fjsydShapeField = fjsydShapeField;
        }

        public String getFjsydPkField() {
            return fjsydPkField;
        }

        public void setFjsydPkField(String fjsydPkField) {
            this.fjsydPkField = fjsydPkField;
        }
    }

    private class TempParam
    {
        private String atlasId;
        private String tempTable;
        private String resultTable;
        private Integer atlasState;

        public String getAtlasId() {
            return atlasId;
        }

        public void setAtlasId(String atlasId) {
            this.atlasId = atlasId;
        }

        public String getTempTable() {
            return tempTable;
        }

        public void setTempTable(String tempTable) {
            this.tempTable = tempTable;
        }

        public String getResultTable() {
            return resultTable;
        }

        public void setResultTable(String resultTable) {
            this.resultTable = resultTable;
        }

        public Integer getAtlasState() {
            return atlasState;
        }

        public void setAtlasState(Integer atlasState) {
            this.atlasState = atlasState;
        }
    }

    private SqlliteConnTool createTable(SqlliteConnTool dbHelper,String table, List<String> fields)
    {

        try {
            if(dbHelper==null) {
                dbHelper = new SqlliteConnTool();
            }
            dbHelper.beginTransaction();
            String sql = "CREATE TABLE " + table + "(";
            int i = 0;
            for (String f : fields) {
                i++;
                sql += f + " text";
                if (i < fields.size()) {
                    sql += ",";
                }
            }
            sql += ")";
            dbHelper.doSql(sql);
            return dbHelper;
        }
        catch (Exception ex)
        {
            if(dbHelper!=null) {
                dbHelper.rollback();
            }
            logger.error("计算新增建设用地面积失败,create table error"+ ExceptionUtil.getErrorString(ex));
            return null;
        }
    }
    private boolean insert(SqlliteConnTool dbHelper,List<String> xzjsydmjSql, String table, List<String> fields) {

        try {
            dbHelper.beginTransaction();
            int i = 0;
            int page = (int) Math.ceil(xzjsydmjSql.size() * 1.0 / 100);
            for (i = 0; i < page; i++) {
                int from = i * 100;
                int to = (i + 1) * 100;
                if (to >= xzjsydmjSql.size()) {
                    to = xzjsydmjSql.size();
                }
                List<String> subSql = xzjsydmjSql.subList(from, to);
                dbHelper.doSql(String.join(";", subSql));
            }
            dbHelper.commit();
           return true;
        }
        catch (Exception ex)
        {
            if(dbHelper!=null) {
                dbHelper.rollback();
            }
            logger.error("计算新增建设用地面积失败,insert sql error"+ ExceptionUtil.getErrorString(ex));
             return false;
        }

    }
}
