package com.geoway.landteam.landcloud.service.zhdd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.task.entity.TbtskFieldGroupView;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.giht.dto.Data;
import com.geoway.landteam.landcloud.model.zhdd.dto.DroneAlarmInfo;
import com.geoway.landteam.landcloud.model.zhdd.dto.DroneAlarmStatisticalInfo;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumDroneAlarm;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueGroupService;
import com.geoway.landteam.landcloud.servface.zhdd.DroneAlarmService;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFieldGroupView;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueTaskRel;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueSourceService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueTaskRelService;
import com.gw.base.data.result.GiResult;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.criteria.CriteriaBuilder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class DroneAlarmServiceImpl implements DroneAlarmService {

    @Value("${clue.drone.id}")
    String droneClue;

    @Value("${clue.drone.ywfl:f_ywfl}")
    String droneClueYwfl;

    @Value("${clue.drone.location:f_location}")
    String droneClueLocation;

    @Autowired
    JcClueSourceService jcClueSourceService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    MJcClueGroupService jcClueGroupService;

    @Autowired
    MJcClueFieldsService jcClueFieldsService;

    @Autowired
    DataBizMapper dataBizMapper;

    @Autowired
    AppMediaDao appMediaDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Override
    public DroneAlarmStatisticalInfo statistical() throws Exception {
        JcClueSource clueSource = jcClueSourceService.findOne(droneClue);
        if(clueSource==null)
        {
            throw new Exception("无人机预警线索不存在");
        }
        String tableName = clueSource.getfTablename();
        List<Map<String,Object>> maps = jdbcTemplate.queryForList("select "+droneClueYwfl+",count(*) as f_count from "+tableName+" group by "+droneClueYwfl);
        DroneAlarmStatisticalInfo result = new DroneAlarmStatisticalInfo();
        result.setTotalCount(0);
        result.setHyCount(0);
        result.setKsCount(0);
        result.setHyCount(0);
        if(maps!=null)
        {
            int totalCount = 0;
            for (Map map:maps)
            {
                Integer count =Integer.parseInt(map.get("f_count").toString());
                totalCount+=count;
                String ywfl = map.get(droneClueYwfl)==null?"":map.get(droneClueYwfl).toString();
                if(StringUtils.isNotBlank(ywfl))
                {
                    EnumDroneAlarm enumDroneAlarm = EnumDroneAlarm.valueOfName(ywfl);
                    switch (enumDroneAlarm)
                    {
                        case ks:
                            result.setKsCount(count);
                            break;
                        case td:
                            result.setTdCount(count);
                            break;
                        case hy:
                            result.setHyCount(count);
                            break;
                    }
                }

            }
            result.setTotalCount(totalCount);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> getShapes(Integer type) throws Exception {
        JcClueSource clueSource = jcClueSourceService.findOne(droneClue);
        if(clueSource==null)
        {
            throw new Exception("无人机预警线索不存在");
        }
        String tableName = clueSource.getfTablename();
        String where = "1=1";
        if(type==null|| EnumDroneAlarm.all.getCode().equals(type))
        {
            where = "1=1";
        }
        else if(type!=null&& EnumDroneAlarm.td.getCode().equals(type))
        {
            where = droneClueYwfl+" = '"+EnumDroneAlarm.td.getName()+"'";
        }
        else if(type!=null&& EnumDroneAlarm.ks.getCode().equals(type))
        {
            where = droneClueYwfl+" = '"+EnumDroneAlarm.ks.getName()+"'";
        }
        else if(type!=null&& EnumDroneAlarm.hy.getCode().equals(type))
        {
            where = droneClueYwfl+" = '"+EnumDroneAlarm.hy.getName()+"'";
        }

        return jdbcTemplate.queryForList("select f_id,st_astext(f_shape) as f_shape from "+tableName +" where "+where);
    }

    @Override
    public JSONObject getDetail(String id) throws Exception {
        JcClueSource clueSource = jcClueSourceService.findOne(droneClue);
        if(clueSource==null)
        {
            throw new Exception("无人机预警线索不存在");
        }
        String tableName = clueSource.getfTablename();
        List<JcClueFieldGroupView> fieldGroupViews  = jcClueGroupService.getFieldGroupByGroupCode(droneClue,"202");
        List<JcClueFields> jcFields = jcClueFieldsService.findByTableId(droneClue);
        JSONArray fieldArray = new JSONArray();
        for(JcClueFieldGroupView fg:fieldGroupViews)
        {
            JcClueFields f = jcFields.stream().filter(t->t.getfFieldname().equals(fg.getfFieldname())).findFirst().orElse(null);
            if(f!=null)
            {
                JSONObject fJson = (JSONObject)JSONObject.toJSON(f);
                fJson.put("fGroup",fg.getfSubgroupname());
                fJson.put("fGroupOrder",fg.getfGrouporder());
                fieldArray.add(fJson);
            }

        }
        List<String>ids = new ArrayList<>();
        ids.add(id);
        List<AppMedia> appMedias = new ArrayList<>();
        appMedias = appMediaDao.queryByGalleryids(ids);

        if (appMedias.size() > 0) {
            for (AppMedia appMedia : appMedias) {
                if (appMedia.getServerpath() != null && !appMedia.getServerpath().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
                    if (StringUtils.isNotBlank(url)) {
                        appMedia.setServerpath(url);
                    }
                }
            }
        }



        List<String> fieldList = jcFields.stream().map(t->t.getfFieldname()).collect(Collectors.toList());
        Map map = dataBizMapper.selectFieldByID(tableName, fieldList,"f_id", "'"+id+"'");
        JSONObject result = new JSONObject();
        result.put("tbInfo",map);
        result.put("fields",fieldArray);
        result.put("medias",appMedias);

        return result;
    }

    @Override
    public JSONObject listPage(Integer type, Integer orderType,String time,Integer page,Integer rows) throws Exception {
        JcClueSource clueSource = jcClueSourceService.findOne(droneClue);
        if(clueSource==null)
        {
            throw new Exception("无人机预警线索不存在");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String tableName = clueSource.getfTablename();
        String where = "1=1";
        if(type==null|| EnumDroneAlarm.all.getCode().equals(type))
        {
            where = "1=1";
        }
        else if(type!=null&& EnumDroneAlarm.td.getCode().equals(type))
        {
            where = droneClueYwfl+" = '"+EnumDroneAlarm.td.getName()+"'";
        }
        else if(type!=null&& EnumDroneAlarm.ks.getCode().equals(type))
        {
            where = droneClueYwfl+" = '"+EnumDroneAlarm.ks.getName()+"'";
        }
        else if(type!=null&& EnumDroneAlarm.hy.getCode().equals(type))
        {
            where = droneClueYwfl+" = '"+EnumDroneAlarm.hy.getName()+"'";
        }
        if(StringUtils.isNotBlank(time))
        {

            Date date = df.parse(time);
            long start =  date.getTime()/1000;
            long end = start+24*3600;
            where+=" and f_createtime >"+start+" and f_createtime<"+end;
        }
        String countSql = "select count(*) as f_count from "+tableName +" where "+where;
        Map<String,Object>map = jdbcTemplate.queryForMap(countSql);
        JSONObject result = new JSONObject();

        int count = map.get("f_count")==null?0:Integer.parseInt(map.get("f_count").toString());
        if(count>0)
        {
            int offset = (page-1)*rows;
            int limit  = rows;
            String sql = "select f_id,f_createtime,"+droneClueLocation+" from "+tableName+" where "+where+" order by f_createtime "+((orderType!=null&&orderType.equals(0))?"asc":"desc")+" offset "+offset+" limit "+limit;
            List<Map<String,Object>>maps =  jdbcTemplate.queryForList(sql);

            if(maps!=null)
            {
                Calendar calendar = Calendar.getInstance();
                List<String>ids = new ArrayList<>();
                List<DroneAlarmInfo>alarmInfos = new ArrayList<>();
                for(Map m:maps)
                {
                   String id = m.get("f_id").toString();
                   long createtime =Long.parseLong(m.get("f_createtime").toString());
                   String location = m.get(droneClueLocation)!=null?m.get(droneClueLocation).toString():"";
                    calendar.setTimeInMillis(createtime*1000);
                   String cc = df.format(calendar.getTime());
                    DroneAlarmInfo alarmInfo = new DroneAlarmInfo();
                    alarmInfo.setId(id);
                    alarmInfo.setTime(cc);
                    alarmInfo.setLocation(location);
                    alarmInfos.add(alarmInfo);
                    ids.add(id);
                }
                if(!ids.isEmpty())
                {
                   List<AppMedia>medias = appMediaDao.queryByGalleryids(ids);
                   if(medias!=null&&!medias.isEmpty())
                   {
                      Map<String,List<AppMedia>>mapMedias = medias.stream().collect(Collectors.groupingBy(t->t.getGalleryid()));
                      for(DroneAlarmInfo a:alarmInfos)
                      {
                          if(mapMedias.containsKey(a.getId()))
                          {
                              AppMedia media = mapMedias.get(a.getId()).get(0);
                              String url = temporarySignedUrlService.getTemporarySignedUrl(null,media.getServerpath(),null);
                              a.setFjUrl(url);
                          }
                      }
                   }
                }
                result.put("data",alarmInfos);
            }
        }
        result.put("totalCount",count);
        return result;
    }

    @Override
    public List<Map<String, Object>> mapCollect(String level, String leftTopX,  String leftTopY, String rightBotX,  String rightBotY) throws Exception {
        JcClueSource clueSource = jcClueSourceService.findOne(droneClue);
        if(clueSource==null)
        {
            throw new Exception("无人机预警线索不存在");
        }
        String tableName = clueSource.getfTablename();
        List<Map<String, Object>> maps = new ArrayList<>();

        if (Double.valueOf(level) <= 15) {
            String sql = "with t1 as (select f_id, st_x(st_centroid(f_shape)) as f_lon, st_y(st_centroid(f_shape)) as f_lat,f_shape from "+tableName+")\n" +
                    "SELECT \n" +
                    "width_bucket(f_lon, " + leftTopX + " ," + rightBotX +" ,20) grid_x, \n" +
                    "width_bucket(f_lat, "+ rightBotY + " , " + leftTopY +", 20) grid_y,  \n" +
                    "count(*),\n" +
                    "st_astext(st_centroid(st_collect(f_shape))) f_shape\n" +
                    "from t1\n" +
                    "where \n" +
                    "f_shape is not null and \n" +
                    "f_lon between " + leftTopX + " and " + rightBotX + " \n" +
                    "and \n" +
                    "f_lat between " + rightBotY + "  and " + leftTopY + " \n" +
                    "GROUP BY grid_x,grid_y";
            maps = jdbcTemplate.queryForList(sql);
        } else {
            //16级往上则查询具体信息
            String polygon = "SRID=4490;POLYGON((" + leftTopX + " " + leftTopY + "," +
                    leftTopX + " " + rightBotY + "," +
                    rightBotX + " " + rightBotY + "," +
                    rightBotX + " " + leftTopY + "," +
                    leftTopX + " " + leftTopY +
                    "))";
            //查询中心点在范围内的所有图形设备信息

            String query = "select f_id,st_astext(f_shape) as f_shape from "+ tableName+" where st_intersects(st_geometryfromtext('" + polygon + "'),f_shape) = 'true'";
            maps = jdbcTemplate.queryForList(query);
        }


        return maps;
    }

}
