package com.geoway.landteam.landcloud.service.zhdd;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsGroupViewRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskFieldGroupView;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.dao.pub.TbsysUserSubjectRelDao;
import com.geoway.landteam.landcloud.dao.zhdd.*;
import com.geoway.landteam.landcloud.model.oauth.AuthUserInfo;
import com.geoway.landteam.landcloud.model.pub.entity.TbsysUserSubjectRel;
import com.geoway.landteam.landcloud.model.zhdd.dto.*;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumAttachType;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumDispatchSource;
import com.geoway.landteam.landcloud.model.zhdd.enm.EnumDispatchType;
import com.geoway.landteam.landcloud.model.zhdd.entity.*;
import com.geoway.landteam.landcloud.repository.pub.TbsysUserSubjectRelRepository;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskAssignService;
import com.geoway.landteam.landcloud.servface.oauth.OauthUserService;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.geoway.landteam.landcloud.servface.zhdd.TbtskDispatchService;
import com.geoway.landteam.landcloud.service.cffx.MCffxTaskServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.GeometryTrasnUtil;
import com.geoway.landteam.landcloud.service.util.ShpObject;
import com.geoway.landteam.landcloud.service.util.ShpUtil;
import com.geoway.landteam.landcloud.service.util.excel.EnumTextLocation;
import com.geoway.landteam.landcloud.service.util.excel.ExcelColData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelRowData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelUtil;
import com.geoway.landteam.platform.business.res3.api.bususer.reso.BusUserInfoReso;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @projectName: geoway-landcloud-cq
 * @package: com.geoway.landteam.landcloud.service.zhdd
 * @className: TbtskDispatchServiceImpl
 * @author: limihao
 * @description: TODO
 * @date: 2024/6/17 17:38
 * @version: 1.0
 */
@Service
public class TbtskDispatchServiceImpl implements TbtskDispatchService {

    private final GiLoger logger = GwLoger.getLoger(TbtskDispatchServiceImpl.class);
    @Value("${project.downloadDir}")
    String localDownload;
    @Value("${project.uploadDir}")
    String localUpload;

    @Value("${third.url.ygb}")
    String ygbUrl;

    @Value("${third.url.fc}")
    String fcUrl;

    @Value("${third.url.dj}")
    String djUrl;
    private final String SERVICE_PATH = "ttServerPath";

    private final String X_Auth_Token="eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ3b3Jrc3BhY2VfaWQiOiJlM2RlYTBmNS0zN2YyLTRkNzktYWU1OC00OTBhZjMyMjgwNjkiLCJzdWIiOiJDbG91ZEFwaVNhbXBsZSIsInVzZXJfdHlwZSI6IjEiLCJuYmYiOjE3MTE0NDExODksImxvZyI6IkxvZ2dlcltjb20uZGppLnNhbXBsZS5jb21tb24ubW9kZWwuQ3VzdG9tQ2xhaW1dIiwiaXNzIjoiREpJIiwiaWQiOiJhMTU1OWU3Yy04ZGQ4LTQ3ODAtYjk1Mi0xMDBjYzQ3OTdkYTIiLCJleHAiOjQ4MzU0OTIzOTAsImlhdCI6MTcxMTQ0MTE4OSwidXNlcm5hbWUiOiJhZG1pblBDIn0.0D-Jk6FVyB8E0HpxcLeFYyu1Y5B-5qJ0ub0qh91F-9w";

    //创建起飞任务时只能传tbid,所以需要先调用接口创建一个项目，然后将tb导入到这个项目才行，namespaceId就是已创建好得项目id
    private final String namespaceId="a9fa7f5236d62437d9896f6a45a3bd3d7";

    /**
     * 调度任务ID
     */
    private final String ddTaskId = "f7518261-2daa-4aeb-b7a1-67c72edb464b";

    @Resource
    TbtskDispatchInfoDao dispatchInfoDao;
    @Resource
    TbtskDispatchTbTempDao dispatchTbTempDao;
    @Resource
    TbtskDispatchRecordDao dispatchRecordDao;
    @Resource
    TbtskDispatchUserDao dispatchUserDao;

    @Resource
    TbtskDispatchAttachDao dispatchAttachDao;
    @Resource
    JdbcTemplate jdbcTemplate;

    @Resource
    DataBizService dataBizService;

    @Autowired
    OauthUserService oauthUserService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Resource
    TbtskFieldsRepository tbtskFieldsRepository;

    @Resource
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Resource
    TbtskFieldsGroupViewRepository tbtskFieldsGroupViewRepository;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    TbsysUserSubjectRelRepository tbsysUserSubjectRelRepository;

    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;

    @Resource
    AppMediaDao appMediaDao;

    @Autowired
    ImportOtherDataService importOtherDataService;

    @Autowired
    OssConfigRepository ossConfigRepository;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Resource
    UserNameService userNameService;

    @Autowired
    MITaskAssignService taskAssignService;

    @Autowired
    TbsysUserSubjectRelDao tbsysUserSubjectRelDao;


    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TaskAssignJobService taskAssignJobService;

    @Override
    public void runDataAssign()  throws Exception {
        TaskRecord record = taskRecordService.findOne("376d92d5-3bd4-40ea-bfb7-29e1a1f3ae78");
        //System.out.println("rateJobAssignTask 执行----开始-----");
        try {
//            InetAddress localhost = InetAddress.getLocalHost();
            record.setThreadstarttime(new Date());
//            record.setMacIp(localhost.getHostName());
            record.setState(2);
            taskRecordService.save(record);
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            if ("checkFilter".equalsIgnoreCase(paramsObject.getString("filterType"))) {
                TaskDataDbParameter taskDataDbParameter = JSONObject.parseObject(paramsObject.getString("TaskDataDbParameter"),
                        TaskDataDbParameter.class);
                taskAssignJobService.AssignData(taskDataDbParameter);
            }else if("conditionFilter".equalsIgnoreCase(paramsObject.getString("filterType"))){
                taskAssignJobService.assignDataByCondition(paramsObject);
            }

            taskRecordService.state2Success(record.getId());
        } catch (Exception e) {
            taskRecordService.state2Fail(record.getId(), e.getMessage());
        } finally {
            //记录日志
            //JSONObject jsonObject = LogUtils.saveSysLog("web数据分发", "JobRunTask-rateJobAssignTask","web数据分发", record.getId());
            logger.info("rateJobAssignTask--- 结束: {}", record.getId());
        }
    }


    /**
     * 获取大屏业务矿山预警年份下拉框数据
     * @return
     */
    @Override
    public List<Object> findKsjcYear(){
        String sql = "select distinct EXTRACT(year FROM f_fxsj) AS val FROM tbtsk_task_znglrw_20240731183049311 order by EXTRACT(year FROM f_fxsj)";
        List<Map<String,Object>> ls = jdbcTemplate.queryForList(sql);
        List<Object> res = new ArrayList<>();
        if(ls!=null){
            for(Map<String,Object> map : ls){
                res.add(map.get("val"));
            }
        }
        return res;
    }

    /**
     * 获取市县镇三级数据
     * @return
     */
    @Override
    public Map findHbRegionData(){
        Map res = new HashMap();
        String sql = "select f_xzqdm as xzqdm,f_xzqmc as xzqmc,f_pcode as pcode from tb_region where f_pcode = '130000'";
        List<Map<String, Object>> listCitys = jdbcTemplate.queryForList(sql);
        res.put("citys",listCitys);
        String sql2 = "select f_xzqdm as xzqdm,f_xzqmc as xzqmc,f_pcode as pcode from tb_region " +
                "where f_pcode like '13%' and f_level = 3";
        List<Map<String, Object>> listTowns = jdbcTemplate.queryForList(sql2);
        res.put("towns",listTowns);
        String sql3 = "select xzqdm,xzqmc,pcode from tb_region_town " +
                "where pcode like '13%' and f_level = 4";
        List<Map<String, Object>> listVil = jdbcTemplate.queryForList(sql3);
        res.put("vils",listVil);
        return res;
    }

    @Override
    public Map<String,Object> statisticsKsDataByYear(String year){
        Map<String,Object> res = new HashMap<>();
        //视频告警线索月度趋势
        String monthSql = "select EXTRACT(month FROM f_fxsj) as month_value,count(1) as ct from tbtsk_task_znglrw_20240731183049311 \n" +
                "where EXTRACT(year FROM f_fxsj) = " + year + " group by EXTRACT(month FROM f_fxsj)";
        List<Map<String,Object>> ls =jdbcTemplate.queryForList(monthSql);
        Map<String,Object> monthData = new HashMap<>();
        List<String> lsMonthName = new ArrayList<>(Arrays.asList("1月","2月","3月","4月","5月","6月","7月","8月","9月","10月","11月","12月"));
        List<Integer> lsMonthData = new ArrayList<>(Arrays.asList(0,0,0,0,0,0,0,0,0,0,0,0));
        if(ls!=null&&!ls.isEmpty()){
            for(Map<String,Object> data:ls){
                Integer m = Integer.parseInt(data.get("month_value").toString());
                Integer ct = Integer.parseInt(data.get("ct").toString());
                lsMonthData.set(m-1,ct);
            }
        }
        monthData.put("x",lsMonthName);
        monthData.put("y",lsMonthData);
        res.put("monthData",monthData);
        //视频告警线索类型划分
        //采矿权 探矿权 矿山生态修复
        List<Map<String,Object>> ksTypes = new ArrayList<>();
        String sqlCkq = "select count(1) as ct from tbtsk_task_znglrw_20240731183049311 where coalesce(f_ltckqr,'') <> '' and EXTRACT(year FROM f_fxsj) = "+ year;
        String sqlTkq = "select count(1) as ct from tbtsk_task_znglrw_20240731183049311 where coalesce(f_tkqr,'') <> '' and EXTRACT(year FROM f_fxsj) = "+ year;
        String sqlKsstxf = "select count(1) as ct from tbtsk_task_znglrw_20240731183049311 where coalesce(f_tkqr,'')='' and coalesce(f_ltckqr,'')='' and EXTRACT(year FROM f_fxsj) = "+ year;
        Map<String,Object> ckqMap = jdbcTemplate.queryForMap(sqlCkq);
        ckqMap.put("name","采矿权");
        ckqMap.put("value",Integer.parseInt(ckqMap.get("ct").toString()));
        ksTypes.add(ckqMap);
        Map<String,Object> tkqMap = jdbcTemplate.queryForMap(sqlTkq);
        tkqMap.put("name","探矿权");
        tkqMap.put("value",Integer.parseInt(tkqMap.get("ct").toString()));
        ksTypes.add(tkqMap);
        Map<String,Object> ksstxfMap = jdbcTemplate.queryForMap(sqlKsstxf);
        ksstxfMap.put("name","矿山生态修复");
        ksstxfMap.put("value",Integer.parseInt(ksstxfMap.get("ct").toString()));
        ksTypes.add(ksstxfMap);
        res.put("ksTypeData",ksTypes);
        //视频告警线索区域分布
        String xsfbSql ="select r.f_xzqdm  as xzqdm,r.f_xzqmc as xzqmc, count(1) as ct from tbtsk_task_znglrw_20240731183049311 t\n" +
                "inner join tb_region r on r.f_xzqdm = left(t.f_xzqdm,4)||'00'\n" +
                "where EXTRACT(year FROM t.f_fxsj) = " + year +
                " group by r.f_xzqdm,r.f_xzqmc\n" +
                " order by r.f_xzqdm";
        List<Map<String,Object>> lsXsfb =jdbcTemplate.queryForList(xsfbSql);

        Map<String,Object> xsfbData = new HashMap<>();
        List<String> lsXzq = new ArrayList<>();
        List<Integer> lsData = new ArrayList<>();
        if(lsXsfb!=null&&!lsXsfb.isEmpty()){
            for( Map<String,Object> data:lsXsfb){
                lsXzq.add(data.get("xzqmc").toString());
                lsData.add(Integer.parseInt(data.get("ct").toString()));
            }
        }
        xsfbData.put("x",lsXzq);
        xsfbData.put("y",lsData);
        res.put("xsfbData",xsfbData);
        return res;
    }


    private void mapAddState(Map<String,Object> map,SimpleDateFormat sdf) throws java.text.ParseException {
        Long curret = System.currentTimeMillis();
        if(map.get("yxqz")!=null){
            String dateStr = map.get("yxqz").toString()+" 23:59:59";
            if(curret > sdf.parse(dateStr).getTime()){
                map.put("state",1);
            } else {
                map.put("state",0);
            }
        } else {
            map.put("state",0);
        }
    }

    @Override
    public List<Map<String,Object>> findAllKsManageData() throws java.text.ParseException {
        String sql = "select id,xkzh,ksmc, \n" +
                "shimc,xianmc,ckqr,kz,kcfs,mj,yxqq,yxqz,gm,gmdw,zbx,\n" +
                "shape_leng,shape_area,st_astext(geom) as geom,data_type\n" +
                "from tb_ks_tkckq";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<Map<String,Object>> list = jdbcTemplate.queryForList(sql);
        for(Map<String,Object> map : list){
            mapAddState(map,sdf);
        }
        return list;
    }

    @Override
    public List<Map<String,Object>> findKsManageDataByParam(String dataType,String nodeType,String name) throws java.text.ParseException {
        String sql = "select id,xkzh,ksmc, \n" +
                "shimc,xianmc,ckqr,kz,kcfs,mj,yxqq,yxqz,gm,gmdw,zbx,\n" +
                "shape_leng,shape_area,st_astext(geom) as geom,data_type\n" +
                "from tb_ks_tkckq where 1=1 ";
        if("1".equals(dataType)){
            sql += " and data_type=1 " ;
        } else {
            sql += " and data_type=2 " ;
        }
        if("2".equals(nodeType)){
            sql += " and shimc='" +name+ "'" ;
        } else if("3".equals(nodeType)){
            sql += " and xianmc='" +name+ "'" ;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<Map<String,Object>> list = jdbcTemplate.queryForList(sql);
        for(Map<String,Object> map : list){
            mapAddState(map,sdf);
        }
        return list;
    }

    @Override
    public Map<String,Object> getKsManageDataDetail(String id) throws java.text.ParseException {
        String sql = "select id,xkzh,ksmc, \n" +
                "shimc,xianmc,ckqr,kz,kcfs,mj,yxqq,yxqz,gm,gmdw,zbx,\n" +
                "shape_leng,shape_area,st_astext(geom) as geom,data_type\n" +
                "from tb_ks_tkckq where id=" + id;
        Map<String,Object> map = jdbcTemplate.queryForMap(sql);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        mapAddState(map,sdf);
        return map;
    }

    @Override
    public List<KsManageData> ksManageDataTree(String name){
        List<KsManageData> resList = new ArrayList<>();
        String sql = "select data_type,id,ksmc,shimc,xianmc from tb_ks_tkckq";
        if(StringUtils.isNotEmpty(name)){
            sql += " where ksmc like '%" + name +"%'";
        }
        KsManageData ckq = new KsManageData();
        ckq.setId("ckq");
        ckq.setName("采矿权");
        ckq.setNodeType(1);
        ckq.setChildMap(new HashMap<>());
        resList.add(ckq);
        KsManageData tkq = new KsManageData();
        tkq.setId("tkq");
        tkq.setName("探矿权");
        tkq.setNodeType(1);
        tkq.setChildMap(new HashMap<>());
        resList.add(tkq);
        List<Map<String, Object>> listKs = jdbcTemplate.queryForList(sql);
        if(listKs!=null&&!listKs.isEmpty()){
            for(Map<String, Object> data : listKs){
                String dataType = data.get("data_type").toString();
                KsManageData root;
                if("1".equals(dataType)){
                    root = ckq;
                } else{
                    root = tkq;
                }
                KsManageData shiMd;
                String shimc = data.get("shimc").toString();
                if(root.getChildMap().containsKey(shimc)){
                    shiMd = root.getChildMap().get(shimc);
                } else {
                    shiMd = new KsManageData();
                    shiMd.setId(UUID.randomUUID().toString());
                    shiMd.setName(shimc);
                    shiMd.setNodeType(2);
                    shiMd.setChildMap(new HashMap<>());
                    root.getChildMap().put(shimc,shiMd);
                }

                KsManageData xianMd;
                String xianmc = data.get("xianmc").toString();
                if(shiMd.getChildMap().containsKey(xianmc)){
                    xianMd = shiMd.getChildMap().get(xianmc);
                } else {
                    xianMd = new KsManageData();
                    xianMd.setId(UUID.randomUUID().toString());
                    xianMd.setName(xianmc);
                    xianMd.setNodeType(3);
                    xianMd.setChildMap(new HashMap<>());
                    shiMd.getChildMap().put(xianmc,xianMd);
                }
                KsManageData ksMd = new KsManageData();
                ksMd.setId(data.get("id").toString());
                ksMd.setName(data.get("ksmc").toString());
                ksMd.setNodeType(4);
                xianMd.getChildMap().put(ksMd.getId(),ksMd);
            }
        }
        return resList;
    }

    /**
     * 主页统计数据
     * @return
     */
    @Override
    public Map<String,Object> ktdMainstatistics(){
        //调查业务 10+
        //资产总量：1.8T
        Map<String,Object>  map = new HashMap<>();
        map.put("dcyw",10);

        String sql1 = "select count(*) as ct from tbsys_user";
        Map<String,Object> res1 = jdbcTemplate.queryForMap(sql1);
        map.put("zcyhs",res1.get("ct"));
        String sql2= "select ROUND(COUNT(*)*1.0 /10000,2) as ct from tb_app_media";
        Map<String,Object> res2 = jdbcTemplate.queryForMap(sql2);
        map.put("ljzp",res2.get("ct"));
        //String sql3= "SELECT ROUND(SUM(f_tbcount)*1.0 / 10000, 2) as ct FROM tbtsk_task_statis";
        String sql3 ="select count(*) as ct from tbtsk_task_biz where coalesce(f_isdel,0) <>1 and f_classid in (select f_id from tbtsk_task_class)";
        Map<String,Object> res3 = jdbcTemplate.queryForMap(sql3);
        map.put("rws",res3.get("ct"));

        map.put("zczl",1.8);
        return map;
    }


    @Override
    public List<Map<String, Object>> statisticsBusinessDataByClassIdAndTaskId(String classId,String taskId) throws Exception {
        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        if(task==null)
        {
            throw new Exception("任务不存在");
        }
        TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
        if(objectinfo==null)
        {
            throw new Exception("任务表对象不存在");
        }
        if(StringUtils.isBlank(objectinfo.getfTablename()))
        {
            throw new Exception("任务表对象表名为空");
        }
        String sql = "select f_xzqdm,f_xzqmc,f_centerx,f_centery from tb_region where f_pcode = '130000'";
        List<Map<String, Object>> listRegions = jdbcTemplate.queryForList(sql);
        Map<String,Map<String, Object>> maps = new HashMap<>();
        if("73".equals(classId)){
            //土地卫片执法
            if(listRegions!=null&& !listRegions.isEmpty()) {
                for (Map<String, Object> temp : listRegions) {
                    List<QuotaDataDto> list = new ArrayList<>();
                    list.add(QuotaDataDto.create("拆除图斑数量","1",new BigDecimal(0)));
                    list.add(QuotaDataDto.create("拆除图斑面积","2",new BigDecimal(0)));
                    list.add(QuotaDataDto.create("拆除耕地面积","3",new BigDecimal(0)));
                    temp.put("data",list);
                    maps.put(temp.get("f_xzqdm").toString(),temp);
                }
            }
            //拆除图斑数量
            String cctbslSql = "select f_sjxzqdm,f_sjxzqmc,count(*) as dct from (\n" +
                    "\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from "+ objectinfo.getfTablename() +" where f_sjrdzgqk like '%拆除复耕%' and f_sjhfxpd ='违法' and ( f_issplitted != 1 OR f_issplitted IS NULL)\n" +
                    "\tunion all \n" +
                    "\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from " + objectinfo.getfTablename() +"_child where f_sjrdzgqk like '%拆除复耕%' and f_sjhfxpd ='违法'\n" +
                    ") tp group by f_sjxzqdm,f_sjxzqmc \n";
            List<Map<String, Object>> cctbslList = jdbcTemplate.queryForList(cctbslSql);
            for(Map<String, Object> temp : cctbslList){
                String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                if(maps.containsKey(xzqdm)) {
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map<String, Object> regionData = maps.get(xzqdm);
                    List<QuotaDataDto> list = (List<QuotaDataDto>) regionData.get("data");
                    list.get(0).setCount(count);
                }
            }
            //拆除图斑面积
            String cctbmjSql = "select f_sjxzqdm,f_sjxzqmc,sum(f_sjrdccmj) as dct \n" +
                    " from (\n" +
                    "\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from "+ objectinfo.getfTablename() +" where f_sjrdzgqk like '%拆除复耕%' and f_sjhfxpd ='违法' and ( f_issplitted != 1 OR f_issplitted IS NULL)\n" +
                    "\tunion all \n" +
                    "\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from "+ objectinfo.getfTablename() +"_child where f_sjrdzgqk like '%拆除复耕%' and f_sjhfxpd ='违法'\n" +
                    ") tp group by f_sjxzqdm,f_sjxzqmc ";
            List<Map<String, Object>> cctbmjList = jdbcTemplate.queryForList(cctbmjSql);
            for(Map<String, Object> temp : cctbmjList){
                String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                if(maps.containsKey(xzqdm)) {
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map<String, Object> regionData = maps.get(xzqdm);
                    List<QuotaDataDto> list = (List<QuotaDataDto>) regionData.get("data");
                    list.get(1).setCount(count.setScale(2,BigDecimal.ROUND_HALF_UP));
                }
            }
            //拆除耕地面积
            String ccgdmjSql = "select f_sjxzqdm,f_sjxzqmc,sum(f_sjrdccgd) as dct \n" +
                    " from (\n" +
                    "\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from "+ objectinfo.getfTablename() +" where f_sjrdzgqk like '%拆除复耕%' and f_sjhfxpd ='违法' and ( f_issplitted != 1 OR f_issplitted IS NULL)\n" +
                    "\tunion all \n" +
                    "\tselect f_sjxzqdm,f_sjxzqmc,f_sjrdccmj,f_sjrdccgd from "+ objectinfo.getfTablename() + "_child where f_sjrdzgqk like '%拆除复耕%' and f_sjhfxpd ='违法'\n" +
                    ") tp group by f_sjxzqdm,f_sjxzqmc ";
            List<Map<String, Object>> ccgdmjList = jdbcTemplate.queryForList(ccgdmjSql);
            for(Map<String, Object> temp : ccgdmjList){
                String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                if(maps.containsKey(xzqdm)) {
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map<String, Object> regionData = maps.get(xzqdm);
                    List<QuotaDataDto> list = (List<QuotaDataDto>) regionData.get("data");
                    list.get(2).setCount(count.setScale(2,BigDecimal.ROUND_HALF_UP));
                }
            }

        } else if("106".equals(classId)){
            //耕地保护监督
            if(listRegions!=null&& !listRegions.isEmpty()) {
                for (Map<String, Object> temp : listRegions) {
                    List<QuotaDataDto> list = new ArrayList<>();
                    list.add(QuotaDataDto.create("永久基本农田储备区核查","1",new BigDecimal(0)));
                    list.add(QuotaDataDto.create("耕地季度卫片监测","2",new BigDecimal(0)));
                    list.add(QuotaDataDto.create("耕地和基本农田倾倒建筑垃圾核查","3",new BigDecimal(0)));
                    list.add(QuotaDataDto.create("历年督察耕地非粮化问题图斑核查","4",new BigDecimal(0)));
                    temp.put("data",list);
                    maps.put(temp.get("f_xzqdm").toString(),temp);
                }
            }
            String tjSql ="select left(f_xzqdm,4)||'00' as f_sjxzqdm,  CASE \n" +
                    "    WHEN f_taskid = '15f9abd6-21bb-427e-b369-d43b9f898dbb' THEN '耕地季度卫片监测'\n" +
                    "    WHEN f_taskid = '75ca2394-f7a6-41d8-9056-61fbeb0b14df' THEN '永久基本农田储备区核查'\n" +
                    "    WHEN f_taskid = 'a0891767-cae8-4433-b47d-2aab4544ec36' THEN '耕地和基本农田倾倒建筑垃圾核查'\n" +
                    "    ELSE '历年督察耕地非粮化问题图斑核查'\n" +
                    "  END AS tjname,sum(f_tbcount) as dct  from tbtsk_task_statis a  where a.f_taskid  in ('15f9abd6-21bb-427e-b369-d43b9f898dbb','75ca2394-f7a6-41d8-9056-61fbeb0b14df','a0891767-cae8-4433-b47d-2aab4544ec36','960b62d0-5e22-4d59-80ab-a7d7da7b5058') \n" +
                    "group by left(f_xzqdm,4)||'00',f_taskid";
            List<Map<String, Object>> tjList = jdbcTemplate.queryForList(tjSql);
            for(Map<String, Object> temp : tjList){
                String xzqdm = String.valueOf(temp.get("f_sjxzqdm"));
                if(maps.containsKey(xzqdm)) {
                    BigDecimal count = new BigDecimal(temp.get("dct").toString());
                    Map<String, Object> regionData = maps.get(xzqdm);
                    List<QuotaDataDto> list = (List<QuotaDataDto>) regionData.get("data");
                    for(QuotaDataDto dto : list){
                        if(dto.getName().equals(String.valueOf(temp.get("tjname")))){
                            dto.setCount(count);
                            break;
                        }
                    }
                }
            }
        }
        return listRegions;
    }


    @Override
    public List<SumRegionTaskDispatch> sumTaskTbGroupByRegion(String taskId, String regionCode) throws Exception {

        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        if(task==null)
        {
            throw new Exception("任务不存在");
        }
        TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
        if(objectinfo==null)
        {
            throw new Exception("任务表对象不存在");
        }
        if(StringUtils.isBlank(objectinfo.getfTablename()))
        {
            throw new Exception("任务表对象表名为空");
        }
        List<TbtskFields>fields = tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
        if(fields==null||fields.isEmpty())
        {
            throw new Exception("任务表对象字段列表为空");
        }
        TbtskFields tbbhField = fields.stream().filter(t->t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
        if(tbbhField==null)
        {
            List<TbtskFields>uniqueFields = fields.stream().filter(t->t.getfUnique()!=null&&t.getfUnique().equals(1)).collect(Collectors.toList());
            if(uniqueFields==null|uniqueFields.isEmpty())
            {
                throw new Exception("任务表对象不存在唯一值字段");
            }
            tbbhField = uniqueFields.get(0);
        }

        List<String>wheres = new ArrayList<>();
        if(StringUtils.isNotBlank(regionCode))
        {
            if(regionCode.length()==6)
            {
                if(regionCode.endsWith("0000"))
                {
                    wheres.add("f_xzqdmsys like '%"+regionCode.substring(0,2)+"%'");
                }
                else if(regionCode.endsWith("00"))
                {
                    wheres.add("f_xzqdmsys like '%"+regionCode.substring(0,4)+"%'");
                }
                else
                {
                    wheres.add("f_xzqdmsys like '%"+regionCode+"%'");
                }
            }
            else if(regionCode.length()==9)
            {
                wheres.add("f_xzqdmsys like '%"+regionCode.substring(0,9)+"%'");
            }
            else if(regionCode.length()==12)
            {
                wheres.add("f_xzqdmsys = '"+regionCode+"'");
            }
        }
        String where="";
        if(!wheres.isEmpty())
        {
            where = StringUtils.join(wheres," and ");
        }
        JSONObject result = new JSONObject();
        String sql1 = "select f_xzqdmsys,count(1) as ct from " + objectinfo.getfTablename() +" where f_xzqdmsys is not null and f_status <10 ";
        String sql2 = "select f_xzqdmsys,count(1) as ct from " + objectinfo.getfTablename() +" where f_xzqdmsys is not null and f_status =10 and f_review_stage=101 ";
        String sql3 = "select f_xzqdmsys,count(1) as ct from " + objectinfo.getfTablename() +" where f_xzqdmsys is not null ";
        if(StringUtils.isNotBlank(where)) {
            sql1 += " and " + where;
            sql2 += " and " + where;
            sql3 += " and " + where;
        }
        sql1 += " group by f_xzqdmsys";
        sql2 += " group by f_xzqdmsys";
        sql3 += " group by f_xzqdmsys";
        Map<String,SumRegionTaskDispatch> resMap = new HashMap<>();
        //未上报图斑
        List<Map<String,Object>> maps1 =  jdbcTemplate.queryForList(sql1);
        for(Map<String,Object> dt : maps1){
            String rc = objToString(dt.get("f_xzqdmsys"));
            String ct = objToString(dt.get("ct"));
            SumRegionTaskDispatch sr = new SumRegionTaskDispatch();
            sr.setRegionCode(rc);
            sr.setWsb(Long.parseLong(ct));
            resMap.put(rc,sr);
        }
        //核查总数
        List<Map<String,Object>> maps2 =  jdbcTemplate.queryForList(sql2);
        for(Map<String,Object> dt : maps2){
            String rc = objToString(dt.get("f_xzqdmsys"));
            String ct = objToString(dt.get("ct"));
            SumRegionTaskDispatch sr = new SumRegionTaskDispatch();
            if(resMap.containsKey(rc)){
                sr = resMap.get(rc);
            } else {
                sr.setRegionCode(rc);
                resMap.put(rc,sr);
            }
            sr.setHczs(Long.parseLong(ct));
        }
        List<Map<String,Object>> maps3 =  jdbcTemplate.queryForList(sql3);
        for(Map<String,Object> dt : maps3){
            String rc = objToString(dt.get("f_xzqdmsys"));
            String ct = objToString(dt.get("ct"));
            SumRegionTaskDispatch sr = new SumRegionTaskDispatch();
            if(resMap.containsKey(rc)){
                sr = resMap.get(rc);
            } else {
                sr.setRegionCode(rc);
                resMap.put(rc,sr);
            }
            sr.setTotal(Long.parseLong(ct));
        }
        List<SumRegionTaskDispatch> ls = new ArrayList<>(resMap.values());
        return ls;
    }


    @Override
    public JSONObject getTaskTbInfo(String taskId, String regionCode, String tbbh, Integer page, Integer limit,String userId) throws Exception {

        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        if(task==null)
        {
            throw new Exception("任务不存在");
        }
        String configArgs = task.getConfigArgs(); //获取任务配置数据

        String isWpzf = ""; // isWpzf=1为业务用“地块编号”判断，isWpzf=2为业务用“告警编号”判断  isWpzf其他用图斑编号
        if(StringUtils.isNotBlank(configArgs)){
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = mapper.readTree(configArgs);
            if(ObjectUtils.isNotEmpty(rootNode) && ObjectUtils.isNotEmpty(rootNode.get("isWpzf"))){
                isWpzf = rootNode.get("isWpzf").asText();
            }
        }


        TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
        if(objectinfo==null)
        {
            throw new Exception("任务表对象不存在");
        }
        if(StringUtils.isBlank(objectinfo.getfTablename()))
        {
            throw new Exception("任务表对象表名为空");
        }
        List<TbtskFields>fields = tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
        if(fields==null||fields.isEmpty())
        {
            throw new Exception("任务表对象字段列表为空");
        }
        TbtskFields tbbhOrDkbhField = null; // 图斑编号 或 告警编号 或 地块编号
//        TbtskFields tbbhField = fields.stream().filter(t->t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
        if(isWpzf.equals("1")){ // 地块编号
            tbbhOrDkbhField = fields.stream().filter(t->t.getfFieldname().equals("f_dkbh")).findFirst().orElse(null);
        } else if(isWpzf.equals("2")){ // 告警编号
            tbbhOrDkbhField = fields.stream().filter(t->t.getfFieldname().equals("f_gjbh")).findFirst().orElse(null);
        } else{ // 图斑编号
            tbbhOrDkbhField = fields.stream().filter(t->t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
        }
//        f_dkbh

        //if(tbbhField==null)
        if(tbbhOrDkbhField==null)
        {
            List<TbtskFields>uniqueFields = fields.stream().filter(t->t.getfUnique()!=null&&t.getfUnique().equals(1)).collect(Collectors.toList());
            if(uniqueFields==null|uniqueFields.isEmpty())
            {
                throw new Exception("任务表对象不存在唯一值字段");
            }
//            tbbhField = uniqueFields.get(0);
            tbbhOrDkbhField = uniqueFields.get(0);
        }

        List<String>wheres = new ArrayList<>();
        if(StringUtils.isNotBlank(regionCode))
        {
            if(regionCode.length()==6)
            {
                if(regionCode.endsWith("0000"))
                {
                    wheres.add("f_xzqdmsys like '%"+regionCode.substring(0,2)+"%'");
                }
                else if(regionCode.endsWith("00"))
                {
                    wheres.add("f_xzqdmsys like '%"+regionCode.substring(0,4)+"%'");
                }
                else
                {
                    wheres.add("f_xzqdmsys like '%"+regionCode+"%'");
                }
            }
            else if(regionCode.length()==9)
            {
                wheres.add("f_xzqdmsys like '%"+regionCode.substring(0,9)+"%'");
            }
            else if(regionCode.length()==12)
            {
                wheres.add("f_xzqdmsys = '"+regionCode+"'");
            }

        }
        if(StringUtils.isNotBlank(tbbh))
        {
//            wheres.add(tbbhField.getfFieldname()+" like '%"+tbbh+"%'");
            wheres.add(tbbhOrDkbhField.getfFieldname()+" like '%"+tbbh+"%'");
        }
        //图斑编号不能为空
//        wheres.add(tbbhField.getfFieldname()+" is not null ");
        // 图斑编号地块编号 不能为空
        wheres.add(tbbhOrDkbhField.getfFieldname()+" is not null ");
        String where="";
        if(!wheres.isEmpty())
        {
            where = StringUtils.join(wheres," and ");
        }
        JSONObject result = new JSONObject();
        Integer count = dataBizService.getCount(objectinfo.getfTablename(),where);
        if(count==0)
        {
            result.put("totalCount",0);
            return result;
        }
//        String sql="select f_id, st_astext(f_shape) as f_shape, coalesce(f_tbmj,0) f_tbmj,f_xzqdmsys,"+tbbhField.getfFieldname()+" from "+objectinfo.getfTablename();
        String sql="select f_id, st_astext(f_shape) as f_shape, coalesce(f_tbmj,0) f_tbmj,f_xzqdmsys,"+tbbhOrDkbhField.getfFieldname()+" from "+objectinfo.getfTablename();
        if(StringUtils.isNotBlank(where)) {
            sql += " where " + where;
        }
//        sql+=" order by "+tbbhField.getfFieldname();
        sql+=" order by "+tbbhOrDkbhField.getfFieldname();
        int offset = (page-1)*limit;
        sql+=" offset "+offset+" limit "+limit;
        List<Map<String,Object>>maps =  jdbcTemplate.queryForList(sql);
        List<TbtskDispatchTbTemp>temps = new ArrayList<>();
        WKTReader reader =new  WKTReader();
        for(Map map:maps) {
            String id = objToString(map.get("f_id"));
            String ftbmj = objToString(map.get("f_tbmj"));
//            String fxzqdm = objToString(map.get("f_xzqdmsys"));
//            String ftbbh = objToString(map.get(tbbhField.getfFieldname()));
            String ftbbh = objToString(map.get(tbbhOrDkbhField.getfFieldname()));
            String fshape = objToString(map.get("f_shape"));
            TbtskDispatchTbTemp info = new TbtskDispatchTbTemp();
            info.setId(id);
            info.setSource(EnumDispatchSource.task.getCode());
            info.setTbmj(Double.parseDouble(ftbmj));
            if(StringUtils.isNotEmpty(fshape)){
                if(fshape.toLowerCase().startsWith("srid"))
                {
                    fshape = fshape.substring(10);
                }
                Geometry geo = reader.read(fshape);
                Map<String,Object> mapRegion =getXzqdmSys(geo.getCentroid(), fshape,GeometryTrasnUtil.getProjNum(geo));
                fshape = "SRID=4490;"+fshape;
                if(mapRegion!=null)
                {
                    //java.text.DecimalFormat df = new java.text.DecimalFormat("#.00");
                    info.setRegionCode(mapRegion.get("xzqdmsys").toString());
                    info.setRegionName(mapRegion.get("location").toString());
                    //info.setTbmj(Double.parseDouble(df.format(map.get("area").toString())));
                }
            }
            info.setShape(fshape);
            info.setTbbh(ftbbh);
           // info.setUserId(userId);
            info.setTbid(id);
            info.setTaskId(taskId);
            temps.add(info);
        }
        //dispatchTbTempDao.insertBatch(temps);
        result.put("totalCount",count);
        result.put("dispatchTbs",temps);
        return result;

    }

    private String objToString(Object obj){
        if(obj == null)
            return "";
        else {
           return String.valueOf(obj);
        }
    }

    @Override
    public List<TbtskDispatchTbTemp> getShpList(MultipartFile multipartFile,String userId) throws Exception {

        //如果压缩文件大于2.5M则提示异常
        double size = multipartFile.getSize() / 1024.0D / 1024.0D;
        if(size>2.5){
            throw new RuntimeException("文件不可大于2.5M");
        }
        File downdirectory = new File(localDownload);
        File uploaddirectory = new File(localUpload);
        if(!downdirectory.exists() && downdirectory.isDirectory()){
            downdirectory.mkdir();
        }
        if(!uploaddirectory.exists() && uploaddirectory.isDirectory()){
            uploaddirectory.mkdir();
        }
        if(!multipartFile.getOriginalFilename().endsWith(".zip")){
            throw new RuntimeException("请上传zip压缩包");
        }
        FileOutputStream outputStream = null;
        String originalFilename = multipartFile.getOriginalFilename().substring(0,multipartFile.getOriginalFilename().lastIndexOf(".")) + System.currentTimeMillis();
        try {
            //存到本地download路径下
            File localZip = File.createTempFile(originalFilename, ".zip", downdirectory);
            outputStream = new FileOutputStream(localZip);
            outputStream.write(multipartFile.getBytes());
            outputStream.close();
            File file = new File(localDownload+File.separator+originalFilename);
            if(!file.exists()){
                file.mkdir();
            }
            ZipUtil1s.unZip(localZip.getAbsolutePath(),file.getAbsolutePath());

        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }finally {
            if(outputStream!=null){
                outputStream.close();
            }
        }
        //获取shp文件路径
        String filePath = localDownload + File.separator + originalFilename;
        List<File> shpList = new ArrayList<>();
        getFileByType(new File(filePath), ".shp", shpList);
        if(shpList.isEmpty()){
            throw new RuntimeException("未找到shp文件");
        }else{
            List<TbtskDispatchTbTemp>infos = shpInfoList(shpList.stream().map(r->r.getAbsolutePath()).collect(Collectors.toList()),userId);
            dispatchTbTempDao.insertBatch(infos);
            infos.forEach(t->t.setTbInfo(null));
            return infos;
        }
    }

    @Override
    public TbtskDispatchTbTemp getDrawList(String wkt,String userId) throws Exception {

        WKTReader wktReader = new WKTReader();
        Geometry geo = wktReader.read(wkt);
        if(geo==null)
        {
            throw new RuntimeException("绘制图形为空");
        }
        if(!geo.getGeometryType().toLowerCase().equals("polygon")&&!geo.getGeometryType().toLowerCase().equals("multipolygon"))
        {
            throw new RuntimeException("绘制不是面图形");
        }

        int num= GeometryTrasnUtil.getProjNum(geo);
        TbtskDispatchTbTemp info = new TbtskDispatchTbTemp();
        info.setId(UUID.randomUUID().toString().replace("-",""));
        info.setSource(EnumDispatchSource.draw.getCode());
        info.setUserId(userId);
        //info.setDispatch(0);
        //info.setRegionCode();
        //info.setRegionName();
        //info.setTbmj(Double.parseDouble(df.format(area)));
        //info.setTbInfo(JSONObject.toJSONString(tb));
        HashMap<String,Object> map = getXzqdmSys(geo.getCentroid(),wkt,num);
        if(map!=null)
        {
            java.text.DecimalFormat df = new java.text.DecimalFormat("#.00");
            info.setRegionCode(map.get("xzqdmsys").toString());
            info.setRegionName(map.get("location").toString());
            info.setTbmj(Double.parseDouble(df.format(Double.parseDouble(map.get("area").toString()))));
        }
        else
        {
            throw new Exception("绘制范围不在规定区域内");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = sdf.format(new Date());
        //int count=0;
        /*
        if(StringUtils.isNotBlank(dispatchId)) {
            String maxTbbh = dispatchTbTempDao.getMaxTbbh(dispatchId, EnumDispatchSource.draw.getCode());
            if(StringUtils.isBlank(maxTbbh))
            {
                maxTbbh = dispatchInfoDao.getMaxTbbh(dispatchId, EnumDispatchSource.draw.getCode());
            }
            if (StringUtils.isNotBlank(maxTbbh)) {
                maxTbbh = maxTbbh.substring(12);
                while (maxTbbh.startsWith("0")) {
                    maxTbbh = maxTbbh.substring(1);
                }
                count = Integer.parseInt(maxTbbh);
            }
        }
        */
        //count++;
        //String xh = String.valueOf(count);
        //xh = StringUtils.leftPad(xh,4,'0');
        info.setTbbh("TBHZ"+date);
        info.setShape("SRID=4490;"+wkt);
        dispatchTbTempDao.gwAccess(info);
        return info;
    }

    @Override
    public void deleteTbTemp(String tempId)
    {
        dispatchTbTempDao.gwDeleteByPK(tempId);
    }

    @Override
    public void deleteDispatchTb(String tbid) throws Exception {
        TbtskDispatchInfo tbtskDispatchInfo = dispatchInfoDao.gwSearchByPK(tbid);
        if(tbtskDispatchInfo!=null){
            if(StringUtils.isNotEmpty(tbtskDispatchInfo.getPlanTaskid())){
                String tableName = getTableNameByTaskId(tbtskDispatchInfo.getPlanTaskid());
                dataBizService.delete(tableName,"f_tbID",tbtskDispatchInfo.getPlanTbid());
            }
            dispatchAttachDao.deleteByTbid(tbid);
            dispatchInfoDao.gwDeleteByPK(tbid);
        }
    }

    private String getTableNameByTaskId(String taskid) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskid);
        if(tskTaskBiz==null)
        {
            throw new Exception("业务任务不存在");
        }
        TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if(objectinfo==null)
        {
            throw new Exception("业务任务表对象不存在");
        }
        if(StringUtils.isBlank(objectinfo.getfTablename()))
        {
            throw new Exception("业务任务表对象表名为空");
        }
        return objectinfo.getfTablename();
    }

    private Map<String,Object> createPlanTaskTb(String ddid, TbtskDispatchInfo tb,WKTReader reader) throws ParseException {
        Map<String,Object> map = new HashMap<>();
        String id = UUID.randomUUID().toString().replace("-","");
        //主键
        map.put("f_id",id);
        //图斑ID
        map.put("f_tbID",id);
        //图斑名称
        map.put("f_tbmc",tb.getTbbh());
        //图斑编号
        map.put("f_tbbh",tb.getTbbh());
        //行政区代码
        map.put("f_xzqdm",tb.getRegionCode());
        //行政区名称
        map.put("f_xzqmc",tb.getRegionName());
        //图斑面积(亩)
        map.put("f_tbmj",tb.getTbmj());
        //调度任务ID
        map.put("f_ddrwID",ddid);
        //状态值默认是1
        map.put("f_status",1);
        //行政区代码拆分 市 县 镇 村
        if(StringUtils.isNotEmpty(tb.getRegionCode()) && tb.getRegionCode().length()>=6){
            if(tb.getRegionCode().length()>9){
                map.put("f_xzqdmsys",tb.getRegionCode());
                map.put("f_xzqdmtown",tb.getRegionCode().substring(0,9));
            } else if(tb.getRegionCode().length()>6 && tb.getRegionCode().length()<10){
                map.put("f_xzqdmtown",tb.getRegionCode());
            }
            map.put("f_xzqdmcounty",tb.getRegionCode().substring(0,6));
            map.put("f_xzqdmcity",tb.getRegionCode().substring(0,4)+"00");
        }

        if(tb.getShape()!=null){
            String wkt = tb.getShape();
            if(tb.getShape().toUpperCase().contains("SRID")){
                wkt = tb.getShape().substring(10);
            }
            Geometry geo = reader.read(wkt);
            Point p =  geo.getCentroid();
            map.put("f_zxdjd",p.getX());
            map.put("f_zxdwd",p.getY());
            //空间范围
            map.put("f_shape",wkt);
        }
        tb.setPlanTbid(id);
        return map;
    }

    @Override
    public List<Map<String,Object>> getTbDdls(String tbid) throws Exception {
        TbtskDispatchInfo tbtskDispatchInfo = dispatchInfoDao.gwSearchByPK(tbid);
        if(tbtskDispatchInfo==null){
            throw new Exception("图斑信息不存在");
        }
        String tableName = getTableNameByTaskId(ddTaskId);
        String sql = "select t.f_ddsj as ddsj,t.f_ddr_n1 as ddr,t.f_bddzy_n1 as bddzy,t.f_ddjl as ddjl,t.f_ddjl as ddyj,r.f_name as ddname from " + tableName + " t left join tbtsk_dispatch_record r on t.f_ddrwID=r.f_id where t.f_ddzt='1' and t.f_tbbh='" + tbtskDispatchInfo.getTbbh() +"' order by t.f_ddsj desc";
        List<Map<String,Object>> lsMap = jdbcTemplate.queryForList(sql);
        return lsMap;

        //        f_bddzylx	被调度资源类型
//        f_ddsj	调度时间
//        f_ddyj	调度意见
//        f_ddzt	调度状态
//        f_bddzy_n1	被调度资源
//        f_xzqmc	行政区名称
//        f_ddjl	调度结论
//        f_ddr_n1	调度人
    }
    @Override
    public void saveTbJl(String tbid,String zyyid,String ddjl,String ddyj, MultipartFile[] files,String ddr) throws Exception {
        Integer ddlx = 1;
        TbtskDispatchInfo tbtskDispatchInfo = dispatchInfoDao.gwSearchByPK(tbid);
        if(tbtskDispatchInfo == null){
            throw new Exception("图斑信息不存在");
        }
        TbsysUserSubjectRel tbsysUserSubjectRel =  tbsysUserSubjectRelDao.gwSearchByPK(Long.parseLong(zyyid));

        if(!zyyid.equals(tbtskDispatchInfo.getUserid())){
            tbtskDispatchInfo.setDdzy(ddlx);
            tbtskDispatchInfo.setUserid(zyyid);
            tbtskDispatchInfo.setUserName(tbsysUserSubjectRel.getRealName());
            tbtskDispatchInfo.setPhone(tbsysUserSubjectRel.getPhoneNumber());
        }
        tbtskDispatchInfo.setDispatch(1);
        tbtskDispatchInfo.setJl(ddjl);
        tbtskDispatchInfo.setYj(ddyj);
        dispatchInfoDao.gwUpdateByPK(tbtskDispatchInfo);
        TbtskDispatchAttach search = new TbtskDispatchAttach();
        search.setInfoId(tbid);
        List<TbtskDispatchAttach> dbList = dispatchAttachDao.gwSearch(search);
        if(dbList!=null && !dbList.isEmpty()){
            for(TbtskDispatchAttach t : dbList){
                String key = "ddtask/"+ tbid +"/"+t.getName();
                try {
                    ossOperatorService.deleteObject(key);
                }catch (Exception ex){
                    logger.error(ex.getMessage());
                }
                dispatchAttachDao.gwDeleteByPK(t.getId());
            }
        }
        if(files!=null){
            List<TbtskDispatchAttach> ls = new ArrayList<>();
            for(MultipartFile file : files){
                String name =  file.getOriginalFilename();
                String key = "ddtask/"+ tbid +"/"+name;
                String url = ossOperatorService.sendObject2Oss(key, file.getInputStream());
                TbtskDispatchAttach tbtskDispatchAttach = new TbtskDispatchAttach();
                tbtskDispatchAttach.setId(UUID.randomUUID().toString().replace("-",""));
                tbtskDispatchAttach.setInfoId(tbid);
                tbtskDispatchAttach.setName(name);
                tbtskDispatchAttach.setTime(new Date());
                tbtskDispatchAttach.setUrl(url);
                ls.add(tbtskDispatchAttach);
            }
            dispatchAttachDao.insertBatch(ls);
        }

        String tableName = getTableNameByTaskId(ddTaskId);
        Map<String,Object> updateMap = new HashMap<>();
        updateMap.put("f_bddzylx",ddlx==1?"人员":"无人机");
        updateMap.put("f_ddyj",ddyj);
        updateMap.put("f_ddjl",ddjl);
        //updateMap.put("f_ddsj",new Date());
        updateMap.put("f_ddzt",1);
        updateMap.put("f_bddzy_n1",tbsysUserSubjectRel.getRealName());
        updateMap.put("f_ddr_n1",ddr);
        dataBizService.updateData(tableName,updateMap,"f_tbID='"+ tbtskDispatchInfo.getPlanTbid()+"'");
        jdbcTemplate.update("update " + tableName + " set f_ddsj=now() where f_tbID='"+ tbtskDispatchInfo.getPlanTbid()+"'");
    }
    @Override
    public DispatchResultDto curretTbDdJl(String tbid) throws Exception {
        TbtskDispatchInfo tbtskDispatchInfo = dispatchInfoDao.gwSearchByPK(tbid);
        if(tbtskDispatchInfo==null){
            throw new Exception("图斑信息不存在");
        }
        String tableName = getTableNameByTaskId(ddTaskId);
        String sql = "select * from " + tableName + " where f_tbID='" + tbtskDispatchInfo.getPlanTbid() +"'";
        List<Map<String,Object>> lsMap = jdbcTemplate.queryForList(sql);
        if(lsMap!=null && !lsMap.isEmpty()){
            Map<String,Object> map =  lsMap.get(0);
            DispatchResultDto dispatchResultDto = new DispatchResultDto();
            dispatchResultDto.setDdjl(String.valueOf(map.get("f_ddjl")));
            dispatchResultDto.setDdyj(String.valueOf(map.get("f_ddyj")));
            dispatchResultDto.setTbbh(tbtskDispatchInfo.getTbbh());
            TbtskDispatchAttach tbtskDispatchAttach = new TbtskDispatchAttach();
            tbtskDispatchAttach.setInfoId(tbid);
            List<TbtskDispatchAttach> attachList = dispatchAttachDao.gwSearch(tbtskDispatchAttach);
            for(TbtskDispatchAttach attach : attachList){
                attach.setUrl(temporarySignedUrlService.getTemporarySignedUrl("", attach.getUrl(), null));
            }
            dispatchResultDto.setAttacheList(attachList);
            List<AppMediaDTO> lsMedia = getMedia(tbtskDispatchInfo.getPlanTbid());
            List<AppMediaDTO> temp = new ArrayList<>();
            if(lsMedia!=null){
                for(AppMediaDTO appMediaDTO:lsMedia){
                    if(appMediaDTO.getType()==1){
                        temp.add(appMediaDTO);
                    }
                }
            }
            dispatchResultDto.setMediaList(temp);
            return dispatchResultDto;
        }
        return null;

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public TbtskDispatchRecord createTask(DispatchCreateInfo createInfo) throws Exception {
        if(createInfo==null)
        {
            throw new Exception("创建调度任务失败,调度任务信息为空");
        }
        if(StringUtils.isBlank(createInfo.getDispatchName()))
        {
            throw new Exception("创建调度任务失败,调度任务名称为空");
        }
        boolean hasShp=true;
        boolean hasDraw=true;
        boolean hasTask=true;
        if(createInfo.getShpTbids()==null||createInfo.getShpTbids().isEmpty())
        {
            hasShp=false;
        }
        if(createInfo.getDrawTbids()==null||createInfo.getDrawTbids().isEmpty())
        {
            hasDraw=false;
        }
        if(createInfo.getTaskTbids()==null||createInfo.getTaskTbids().isEmpty())
        {
            hasTask=false;
        }
        if(!hasShp&&!hasDraw&&!hasTask)
        {
            throw new Exception("创建调度任务失败,调度图斑为空");
        }
        //调度任务需要将图斑数据都保存到大屏调度
        //if(StringUtils.isBlank(createInfo.getTaskId()))
        {
            WKTReader reader = new WKTReader();
            TbtskDispatchRecord task=null;
            boolean insert=false;
            boolean update=false;
            if(StringUtils.isBlank(createInfo.getDispatchId()))
            {
                task = new TbtskDispatchRecord();
                task.setName(createInfo.getDispatchName());
                task.setId(UUID.randomUUID().toString().replace("-",""));
                task.setTime(new Date());
                task.setUserId(createInfo.getUserId());
                task.setStatus(-1);
                insert=true;

            }
            else {
                task =  dispatchRecordDao.gwSearchByPK(createInfo.getDispatchId());
                if(task==null)
                {
                    throw  new Exception("调度任务不存在");
                }
                if(!createInfo.getDispatchName().equals(task.getName()))
                {
                    task.setName(createInfo.getDispatchName());
                    update=true;
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String date = sdf.format(new Date());
            List<TbtskDispatchInfo> tbs = new ArrayList<>();
            List<Map<String,Object>> taskTbs = new ArrayList<>();
            if(hasShp)
            {
                List<TbtskDispatchTbTemp>temps = dispatchTbTempDao.ListByIds(createInfo.getShpTbids());
                if(temps==null||temps.isEmpty())
                {
                    throw new Exception("创建调度任务失败,调度图斑[shp导入]不存在");
                }
                int count = 0;
                for(TbtskDispatchTbTemp temp:temps)
                {
                    TbtskDispatchInfo tb = new TbtskDispatchInfo();
                    BeanUtils.copyProperties(temp,tb);
                    tb.setDispatch(0);
                    tb.setImportFc(0);
                    tb.setDispatchId(task.getId());
                    count++;
                    String xh = String.valueOf(count);
                    xh = StringUtils.leftPad(xh,4,'0');
                    tb.setTbbh("TBSC"+date+xh);
                    taskTbs.add(createPlanTaskTb(task.getId(),tb,reader));
                    tb.setPlanTaskid(ddTaskId);
                    tbs.add(tb);
                }
            }
            if(hasDraw)
            {
                List<TbtskDispatchTbTemp>temps = dispatchTbTempDao.ListByIds(createInfo.getDrawTbids());
                if(temps==null||temps.isEmpty())
                {
                    throw new Exception("创建调度任务失败,调度图斑[绘制导入]不存在");
                }
                int count = 0;
                for(TbtskDispatchTbTemp temp:temps)
                {
                    TbtskDispatchInfo tb = new TbtskDispatchInfo();
                    BeanUtils.copyProperties(temp,tb);
                    tb.setDispatch(0);
                    tb.setImportFc(0);
                    tb.setDispatchId(task.getId());
                    count++;
                    String xh = String.valueOf(count);
                    xh = StringUtils.leftPad(xh,4,'0');
                    tb.setTbbh("TBHZ"+date+xh);
                    taskTbs.add(createPlanTaskTb(task.getId(),tb,reader));
                    tb.setPlanTaskid(ddTaskId);
                    tbs.add(tb);
                }
            }
            if(hasTask)
            {
               List<TaskTbInfo> taskTbInfos =   createInfo.getTaskTbids();

               for(TaskTbInfo tbInfo:taskTbInfos)
               {
                   if(StringUtils.isBlank(tbInfo.getTaskId()))
                   {
                       throw new Exception("业务任务id为空");
                   }
                   if(tbInfo.getTbids()==null||tbInfo.getTbids().isEmpty())
                   {
                       throw new Exception("业务任务图斑id为空");
                   }
                   TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(tbInfo.getTaskId());
                   if(tskTaskBiz==null)
                   {
                       throw new Exception("业务任务不存在");
                   }
                   TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
                   if(objectinfo==null)
                   {
                       throw new Exception("业务任务表对象不存在");
                   }
                   if(StringUtils.isBlank(objectinfo.getfTablename()))
                   {
                       throw new Exception("业务任务表对象表名为空");
                   }
                   List<TbtskFields>fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
                   if(fields==null||fields.isEmpty())
                   {
                       throw new Exception("任务表对象字段列表为空");
                   }
                   TbtskFields tbbhField = fields.stream().filter(t->t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
                   if(tbbhField==null)
                   {
                       List<TbtskFields>uniqueFields = fields.stream().filter(t->t.getfUnique()!=null&&t.getfUnique().equals(1)).collect(Collectors.toList());
                       if(uniqueFields==null|uniqueFields.isEmpty())
                       {
                           throw new Exception("任务表对象不存在唯一值字段");
                       }
                       tbbhField = uniqueFields.get(0);
                   }
                   String sql="select f_id, st_astext(f_shape) as f_shape, f_tbmj,f_xzqdmsys,"+tbbhField.getfFieldname()+" from "+objectinfo.getfTablename();
                   sql+=" where f_id in('"+StringUtils.join(tbInfo.getTbids(),"','")+"')";

                   List<Map<String,Object>>maps =  jdbcTemplate.queryForList(sql);
                   for(Map map:maps) {
                       String id = map.get("f_id").toString();
                       String ftbmj = map.get("f_tbmj").toString();
                       String fxzqdm = map.get("f_xzqdmsys").toString();
                       String ftbbh = map.get(tbbhField.getfFieldname()).toString();
                       String fshape = map.get("f_shape").toString();
                       if(fshape.toLowerCase().startsWith("srid"))
                       {
                           fshape = fshape.substring(10);
                       }
                       Geometry geo = reader.read(fshape);
                       Map<String,Object> mapRegion =getXzqdmSys(geo.getCentroid(), fshape,GeometryTrasnUtil.getProjNum(geo));
                       fshape="SRID=4490;"+fshape;
                       TbtskDispatchInfo info = new TbtskDispatchInfo();
                       info.setId(UUID.randomUUID().toString().replace("-",""));
                       info.setSource(EnumDispatchSource.task.getCode());
                       info.setDispatch(0);
                       info.setTbmj(Double.parseDouble(ftbmj));
                       info.setShape(fshape);
                       info.setTbbh(ftbbh);
                       info.setDispatchId(task.getId());
                       info.setImportFc(0);
                       if(mapRegion!=null)
                       {
                           //java.text.DecimalFormat df = new java.text.DecimalFormat("#.00");
                           info.setRegionCode(mapRegion.get("xzqdmsys").toString());
                           info.setRegionName(mapRegion.get("location").toString());
                           //info.setTbmj(Double.parseDouble(df.format(map.get("area").toString())));
                       }
                       info.setTbid(id);
                       info.setTaskId(tbInfo.getTaskId());
                       taskTbs.add(createPlanTaskTb(task.getId(),info,reader));
                       info.setPlanTaskid(ddTaskId);
                       tbs.add(info);
                   }

               }
            }

            if(insert)
            {
                dispatchRecordDao.gwAccess(task);
            }
            else if(update)
            {
                dispatchRecordDao.gwUpdateByPK(task);
            }
            dispatchInfoDao.insertBatch(tbs);
            dataBizService.insertDatasBatch(getTableNameByTaskId(ddTaskId),taskTbs,"f_shape");
            TbtskDispatchTbTemp delete = new TbtskDispatchTbTemp();
            delete.setUserId(String.valueOf(createInfo.getUserId()));
            dispatchTbTempDao.gwDeleteBy(delete);
            return task;
        }
        /*
        else
        {
            String dispatchId = createInfo.getDispatchId();
            if(StringUtils.isBlank(dispatchId))
            {
                dispatchId = UUID.randomUUID().toString();
            }
            TbtskDispatchRecord record = null;
            if(StringUtils.isBlank(createInfo.getDispatchId()))
            {
                record = new TbtskDispatchRecord();
                record.setName(createInfo.getDispatchName());
                record.setId(dispatchId);
                record.setTime(new Date());
                record.setUserId(createInfo.getUserId());

            }
            else
            {
                record =  dispatchRecordDao.gwSearchByPK(createInfo.getDispatchId());
                if(record==null)
                {
                    throw new Exception("调度任务不存在");
                }
                record.setName(createInfo.getDispatchName());
                List<TbtskDispatchInfo>exist =  dispatchInfoDao.selectByTask(createInfo.getTbids(),createInfo.getTaskId());
                if(exist!=null&&!exist.isEmpty())
                {
                    String tbbhs =StringUtils.join(exist.stream().map(TbtskDispatchInfo::getTbbh).collect(Collectors.toList()),",");
                    throw new Exception("任务图斑:"+tbbhs+"已加入调度任务");
                }
            }

            TskTaskBiz task = tskTaskBizService.findByTaskId(createInfo.getTaskId());
            if(task==null)
            {
                throw new Exception("任务不存在");
            }
            TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            if(objectinfo==null)
            {
                throw new Exception("任务表对象不存在");
            }
            if(StringUtils.isBlank(objectinfo.getfTablename()))
            {
                throw new Exception("任务表对象表名为空");
            }
            List<TbtskFields>fields = tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
            if(fields==null||fields.isEmpty())
            {
                throw new Exception("任务表对象字段列表为空");
            }
            TbtskFields tbbhField = fields.stream().filter(t->t.getfFieldname().equals("f_tbbh")).findFirst().orElse(null);
            if(tbbhField==null)
            {
                List<TbtskFields>uniqueFields = fields.stream().filter(t->t.getfUnique()!=null&&t.getfUnique().equals(1)).collect(Collectors.toList());
                if(uniqueFields==null|uniqueFields.isEmpty())
                {
                    throw new Exception("任务表对象不存在唯一值字段");
                }
                tbbhField = uniqueFields.get(0);
            }

            String where ="f_id in ('"+StringUtils.join(createInfo.getTbids(),"','")+"')";
            String sql="select f_id, st_astext(f_shape) as f_shape, f_tbmj,f_xzqdmsys,"+tbbhField.getfFieldname()+" from "+objectinfo.getfTablename()+" where "+where;
            List<Map<String,Object>>maps =  jdbcTemplate.queryForList(sql);
            List<TbtskDispatchInfo>temps = new ArrayList<>();
            WKTReader reader = new WKTReader();
            for(Map map:maps) {
                String id = map.get("f_id").toString();
                String ftbmj = map.get("f_tbmj").toString();
                String fxzqdm = map.get("f_xzqdmsys").toString();
                String ftbbh = map.get(tbbhField.getfFieldname()).toString();
                String fshape = map.get("f_shape").toString();
                Geometry geo =  reader.read(fshape);
                Map<String,Object> mapRegion =getXzqdmSys(geo.getCentroid(),fshape,GeometryTrasnUtil.getProjNum(geo));

                TbtskDispatchInfo info = new TbtskDispatchInfo();
                info.setId(UUID.randomUUID().toString());
                info.setSource(EnumDispatchSource.task.getCode());
                info.setTbmj(Double.parseDouble(ftbmj));
                if(!fshape.toLowerCase().startsWith("srid"))
                {
                    fshape="SRID=4490;"+fshape;
                }
                info.setShape(fshape);
                info.setTbbh(ftbbh);
                if(mapRegion!=null)
                {
                    //java.text.DecimalFormat df = new java.text.DecimalFormat("#.00");
                    info.setRegionCode(mapRegion.get("xzqdmsys").toString());
                    info.setRegionName(mapRegion.get("location").toString());
                    //info.setTbmj(Double.parseDouble(df.format(map.get("area").toString())));
                }
                info.setTbid(id);
                info.setTaskId(createInfo.getTaskId());
                info.setDispatchId(dispatchId);
                info.setDispatch(0);
                temps.add(info);
            }
            dispatchInfoDao.insertBatch(temps);
            if(StringUtils.isBlank(createInfo.getDispatchId())) {
                dispatchRecordDao.gwAccess(record);
            }
            else
            {
                dispatchRecordDao.gwUpdateByPK(record);
            }
            return record;
        }
        */
    }

    @Override
    public JSONObject getTaskTbList(DispatchTbSearchInfo searchInfo,Integer page,Integer limit) throws ParseException {

        JSONObject result = new JSONObject();

        if(StringUtils.isNotBlank(searchInfo.getRegionCode()))
        {
            String regionCode = searchInfo.getRegionCode();
            if(regionCode.length()==6)
            {
                if(regionCode.endsWith("0000"))
                {
                   regionCode = regionCode.substring(0,2);
                }
                else if(regionCode.endsWith("00"))
                {
                    regionCode = regionCode.substring(0,4);
                }
                searchInfo.setRegionCode(regionCode);
            }
        }
        int count =  dispatchInfoDao.count(searchInfo);
        result.put("totalCount",count);
        if(count==0)
        {
            return result;
        }
        Integer offset = (page - 1)*limit;
        List<TbtskDispatchInfo> tbs= dispatchInfoDao.selectPage(searchInfo,offset,limit);
        List<DispatchTbDto>dtos = new ArrayList<>();
        WKTReader reader = new WKTReader();
        for(TbtskDispatchInfo tb:tbs)
        {
            DispatchTbDto dto = new DispatchTbDto();
            BeanUtils.copyProperties(tb,dto);
            try {
                Geometry geo = reader.read(tb.getShape());
                Point p =  geo.getCentroid();
                dto.setLon(p.getX());
                dto.setLat(p.getY());
            }
            catch (Exception ex)
            {

            }
            dtos.add(dto);
        }
        result.put("dispatchTbs",dtos);
        return result;
    }

    @Override
    public JSONObject getTaskList(DispatchTaskSearchInfo searchInfo, Integer page, Integer limit) {
        JSONObject result = new JSONObject();

        int count =  dispatchRecordDao.count(searchInfo);
        result.put("totalCount",count);
        if(count==0)
        {
            return result;
        }
        Integer offset = (page - 1)*limit;
        List<TbtskDispatchRecord> records= dispatchRecordDao.selectPage(searchInfo,offset,limit);
        List<String>dispatchIds = records.stream().map(TbtskDispatchRecord::getId).collect(Collectors.toList());
        String sql = "select f_dispatch_id, f_dispatch,count(*) as count from tbtsk_dispatch_info where f_dispatch_id in ('"+StringUtils.join(dispatchIds,"','")+"') group by f_dispatch_id,f_dispatch";
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        List<DispatchTaskInfo>tasks = new ArrayList<>();
        for(TbtskDispatchRecord record:records)
        {
            DispatchTaskInfo task = new DispatchTaskInfo();
            BeanUtils.copyProperties(record,task);
            task.setDispatchCount(0);
            task.setUnDispatchCount(0);
            task.setTotalCount(0);
            task.setFinished(false);
            tasks.add(task);
        }
        for(Map map:maps)
        {
            String id = map.get("f_dispatch_id").toString();
            String dispatch = map.get("f_dispatch").toString();
            Object c = map.get("count");
            Integer disatchCount = 0;
            if(c!=null&&StringUtils.isNotBlank(c.toString()))
            {
                disatchCount = Integer.parseInt(c.toString());
            }
            DispatchTaskInfo task = tasks.stream().filter(t->t.getId().equals(id)).findFirst().get();
            switch (dispatch)
            {
                case "1":
                    task.setDispatchCount(disatchCount);
                    break;
                case "0":
                    task.setUnDispatchCount(disatchCount);
                    break;
            }
        }
        tasks.forEach(t->{
            t.setTotalCount(t.getDispatchCount()+t.getUnDispatchCount());
            t.setFinished(t.getUnDispatchCount().equals(0));
        });


        result.put("dispatchTasks",tasks);
        return result;
    }

    @Override
    public List<TbtskDispatchInfo> searchUnDispatchInfo(String dispathcId){
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(dispathcId);
        search.setDispatch(0);
        List<TbtskDispatchInfo> tbs = dispatchInfoDao.gwSearch(search);
        return tbs;
    }

    @Override
    public void batchSaveDispatchInfo(String jsonStr){
        if(StringUtils.isEmpty(jsonStr)) return;
        List<TbtskDispatchInfo>  ls = JSONArray.parseArray(jsonStr,TbtskDispatchInfo.class);
        for(TbtskDispatchInfo tb :ls){
            if(StringUtils.isNotBlank(tb.getPhone()))
            {
                TbsysUserSubjectRel tbsysUserSubjectRel = new TbsysUserSubjectRel();
                tbsysUserSubjectRel.setPhoneNumber(tb.getPhone());
                TbsysUserSubjectRel dbuser = tbsysUserSubjectRelDao.gwSearchFirst(tbsysUserSubjectRel);
                if(dbuser==null)
                {
                    throw new IllegalStateException("手机号:"+tb.getPhone()+"未注册用户");
                }
//                BusUserInfoReso reso = oauthUserService.getBusUserByPhone(tb.getPhone());
//                if(reso==null)
//                {
//                    throw new IllegalStateException("手机号:"+tb.getPhone()+"未注册用户");
//                }
                String realName = dbuser.getRealName();
                tb.setUserName(realName);
                tb.setUserid(dbuser.getUserId().toString());
            }
            dispatchInfoDao.gwUpdateByPK(tb);
        }
    }



    @Override
    public TbtskDispatchInfo setDispatchInfo(DispatchTbInfo dispatchInfo) throws Exception {
        TbtskDispatchInfo tb = dispatchInfoDao.gwSearchByPK(dispatchInfo.getId());
        if(tb==null)
        {
           throw new IllegalStateException("调度图斑不存在");
        }
        if(tb.getDispatch()!=null&&tb.getDispatch().equals(1))
        {
            throw new IllegalStateException("当前图斑已完成调度，不能更新调度信息");
        }
        if(StringUtils.isNotBlank(dispatchInfo.getPhone()))
        {
            TbsysUserSubjectRel tbsysUserSubjectRel = new TbsysUserSubjectRel();
            tbsysUserSubjectRel.setPhoneNumber(dispatchInfo.getPhone());
            TbsysUserSubjectRel dbuser = tbsysUserSubjectRelDao.gwSearchFirst(tbsysUserSubjectRel);
            if(dbuser==null)
            {
                throw new IllegalStateException("手机号:"+dispatchInfo.getPhone()+"未注册用户");
            }
//           BusUserInfoReso reso = oauthUserService.getBusUserByPhone(dispatchInfo.getPhone());
//           if(reso==null)
//           {
//               throw new IllegalStateException("手机号:"+dispatchInfo.getPhone()+"未注册用户");
//           }
           String realName = dbuser.getRealName();
           tb.setDdzy(dispatchInfo.getDdzy());
           tb.setPhone(dispatchInfo.getPhone());
           tb.setUserName(realName);
           tb.setUserid(dbuser.getUserId().toString());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(StringUtils.isNotBlank(dispatchInfo.getTime()))
        {
            Date time = null;
            try {
                 time = df.parse(dispatchInfo.getTime());
            }
            catch (Exception ex)
            {
                throw new Exception("计划调度时间:"+dispatchInfo.getTime()+"格式不正确");
            }
            tb.setTime(time);
        }

        dispatchInfoDao.gwUpdateByPK(tb);
        return tb;
    }

    /**
     * 当前调度任务计划下达
     * @param userInfo
     * @param ddid
     */
    @Override
    public Integer planTaskAssign(AuthUserInfo userInfo,String ddid) throws IllegalStateException {
        TbtskDispatchRecord record = dispatchRecordDao.gwSearchByPK(ddid);
        if (record == null) {
            throw new IllegalStateException("调度任务不存在");
        }

//        String sql = "select * from  tbtsk_dispatch_info where f_dispatch_id='"+ ddid +"' and f_dispatch=0 and f_userid is not null";
//        List<TbtskDispatchInfo> tbs = jdbcTemplate.queryForList(sql, TbtskDispatchInfo.class);
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(ddid);
        search.setDispatch(0);
        List<TbtskDispatchInfo>tbs = dispatchInfoDao.gwSearch(search);
        if (tbs == null || tbs.isEmpty()) {
            throw new IllegalStateException("没有找到未调度图斑");
        }
        Map<String, List<String>> userTbMap = new HashMap<>();
        //当前固定任务
        String taskId = ddTaskId;
        Integer count = 0;
        for (TbtskDispatchInfo tb : tbs) {
            if (StringUtils.isNotEmpty(tb.getUserid())) {
                if (!userTbMap.containsKey(tb.getUserid())) {
                    userTbMap.put(tb.getUserid(), new ArrayList<>());
                }
                userTbMap.get(tb.getUserid()).add(tb.getPlanTbid());
                count++;
            }
        }
        if (userTbMap.isEmpty()) {
            throw new IllegalStateException("未调度图斑都未设置人员,请先进行计划编辑");
        }
        for (String userid : userTbMap.keySet()) {
            JSONArray orgs = new JSONArray();
            JSONObject cacheArray = new JSONObject();
            JSONArray userids = new JSONArray();
            userids.add(userid);
            cacheArray.put("userids",userids);
            orgs.add(cacheArray);
            JSONArray tasks = JSONArray.parseArray(JSONObject.toJSONString(userTbMap.get(userid)));
            taskAssignService.assignTask(userInfo.getUserId(), taskId, tasks, new JSONArray(), orgs);
        }
        return count;
    }
    @Override
    public void setDispatchInfo(MultipartFile multipartFile,String dispatchId) throws Exception {

        TbtskDispatchRecord record = dispatchRecordDao.gwSearchByPK(dispatchId);
        if(record==null)
        {
            throw new IllegalStateException("调度任务不存在");
        }
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(dispatchId);
        List<TbtskDispatchInfo>tbs = dispatchInfoDao.gwSearch(search);
        if(tbs==null||tbs.isEmpty())
        {
            throw new IllegalStateException("调度任务不存在调度图斑");
        }
        tbs = tbs.stream().filter(t->t.getDispatch().equals(0)).collect(Collectors.toList());
        if(tbs==null||tbs.isEmpty())
        {
            throw new IllegalStateException("调度任务不存在未调度图斑");
        }
        File downdirectory = new File(localDownload);
        File uploaddirectory = new File(localUpload);
        if(!downdirectory.exists() && downdirectory.isDirectory()){
            downdirectory.mkdir();
        }
        if(!uploaddirectory.exists() && uploaddirectory.isDirectory()){
            uploaddirectory.mkdir();
        }
        if(!multipartFile.getOriginalFilename().endsWith(".xlsx")){
            throw new RuntimeException("请上传xlsx文件");
        }
        FileOutputStream outputStream = null;
        String originalFilename = multipartFile.getOriginalFilename().substring(0,multipartFile.getOriginalFilename().lastIndexOf(".")) + System.currentTimeMillis();
        File excel = null;
        try {
            //存到本地download路径下
            excel = File.createTempFile(originalFilename, ".xlsx", downdirectory);
            outputStream = new FileOutputStream(excel);
            outputStream.write(multipartFile.getBytes());
            outputStream.close();

        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }finally {
            if(outputStream!=null){
                outputStream.close();
            }
        }

       List<List<Object>>datas =  ExcelUtil.readExcelFirstSheet(excel);
        if(datas==null||datas.isEmpty()||datas.size()<2)
        {
            throw new Exception("excel内无待更新数据");
        }
        List<Object>colNames = datas.get(0);
        int tbbhFieldIndex = -1;
        int phoneFieldIndex = -1;
        int timeFieldIndex = -1;
        for(int i=0;i<colNames.size();i++)
        {
            Object obj = colNames.get(i);
            String name = obj!=null?obj.toString():"";
            switch (name)
            {
                case "编号":
                  tbbhFieldIndex = i;
                  break;
                case "调度人手机号":
                    phoneFieldIndex = i;
                    break;
                case "调度时间":
                    timeFieldIndex=i;
                    break;
            }
        }
        if(tbbhFieldIndex==-1)
        {
            throw new Exception("excel 未包含图斑编号字段");
        }
        if(phoneFieldIndex==-1)
        {
            throw new Exception("excel 未包含调度人手机号字段");
        }
        if(timeFieldIndex==-1)
        {
            throw new Exception("excel 未包含调度时间字段");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        List<TbtskDispatchInfo>updates = new ArrayList<>();
        for(int i=1;i<datas.size();i++)
        {
            List<Object>data = datas.get(i);
            Object tbbhObj = data.get(tbbhFieldIndex);
            Object phoneObj = data.get(phoneFieldIndex);
            Object timeObj = data.get(timeFieldIndex);
            String tbbh = tbbhObj!=null?tbbhObj.toString().trim():"";
            String phone = phoneObj!=null?phoneObj.toString().trim():"";
            String time = timeObj!=null?timeObj.toString().trim():"";
            if(StringUtils.isBlank(tbbh))
            {
                throw new Exception("excel 存在图斑编号为空的记录");
            }
            if(StringUtils.isBlank(phone))
            {
                throw new Exception("excel 存在调度手机号为空的记录");
            }
            if(StringUtils.isBlank(time))
            {
                throw new Exception("excel 存在调度时间为空的记录");
            }

            TbtskDispatchInfo tb =   tbs.stream().filter(t->t.getTbbh().equals(tbbh)).findFirst().orElse(null);
            if(tb==null)
            {
                continue;
            }
            Date dTime = null;
            if(timeObj instanceof Date)
            {
                dTime = (Date)timeObj;
            }
            else {
                try {
                    dTime = df.parse(time);
                } catch (Exception ex) {
                    try {
                        dTime = df1.parse(time);
                    } catch (Exception ex1) {
                        throw new Exception("excel 图斑编号为:" + tbbh + "的记录调度时间格式错误");
                    }
                }
            }
            tb.setTime(dTime);
            if(StringUtils.isNotBlank(phone))
            {
                BusUserInfoReso reso = oauthUserService.getBusUserByPhone(phone);
                if(reso==null)
                {
                    throw new Exception("手机号:"+phone+"未注册");
                }
                String userRealName = reso.getRealName();
                if(StringUtils.isNotBlank(userRealName))
                {
                    userRealName =  oauthUserService.getRealName(reso.getBusUserId());
                }
                tb.setUserName(userRealName);
            }

            updates.add(tb);


        }
        if(updates==null||updates.isEmpty())
        {
            throw new Exception("excel 未包含待更新记录");
        }
        dispatchInfoDao.gwUpdateByPK(updates);

    }


    @Override
    public JSONObject getDispatchTbDetialInfo(String tbid) throws Exception {
        TbtskDispatchInfo tb=   dispatchInfoDao.gwSearchByPK(tbid);
        if(tb==null)
        {
            throw new Exception("调度图斑不存在");
        }
        WKTReader reader = new WKTReader();
        JSONObject result = new JSONObject();
        if(!tb.getSource().equals(EnumDispatchSource.task.getCode()))
        {
            /*
            Geometry geo =  reader.read(tb.getShape());
            Point p = geo.getCentroid();
            tb.setShape(null);
            JSONObject tbInfo = (JSONObject)JSONObject.toJSON(tb);
            Double lon = p.getX();
            Double lat = p.getY();
            tbInfo.put("lon",lon);
            tbInfo.put("lat",lat);
            */
            JSONArray fieldList = new JSONArray();
            JSONObject tbbh = new JSONObject();
            tbbh.put("fFieldname","tbbh");
            tbbh.put("fAlias","图斑编号");
            tbbh.put("fGroup","基本信息");
            tbbh.put("fGroupOrder",0);
            fieldList.add(tbbh);
            JSONObject regionCode = new JSONObject();
            regionCode.put("fFieldname","regionCode");
            regionCode.put("fAlias","行政区代码");
            regionCode.put("fGroup","基本信息");
            regionCode.put("fGroupOrder",0);
            fieldList.add(regionCode);
            JSONObject regionName = new JSONObject();
            regionName.put("fFieldname","regionName");
            regionName.put("fAlias","行政区名称");
            regionName.put("fGroup","基本信息");
            regionName.put("fGroupOrder",0);
            fieldList.add(regionName);
            JSONObject tbmj = new JSONObject();
            tbmj.put("fFieldname","tbmj");
            tbmj.put("fAlias","图斑面积(m2)");
            tbmj.put("fGroup","基本信息");
            tbmj.put("fGroupOrder",0);
            fieldList.add(tbmj);
            result.put("tbInfo",tb);
            result.put("fields",fieldList);

            List<AppMediaDTO>medias = getMedia(tb.getId());
            result.put("medias",medias);
        }
        else
        {
            String taskId = tb.getTaskId();
            String taskTbid = tb.getTbid();
            TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
            if(task==null)
            {
                throw new Exception("任务不存在");
            }
            TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            if(objectinfo==null)
            {
                throw new Exception("任务表对象不存在");
            }
            if(StringUtils.isBlank(objectinfo.getfTablename()))
            {
                throw new Exception("任务表对象表名为空");
            }
            List<TbtskFields>fields = tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
            if(fields==null||fields.isEmpty())
            {
                throw new Exception("任务表对象字段列表为空");
            }

            List<TbtskFieldGroupView>fieldGroupViews =  tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(task.getTableId(), "web", "202");
            List<String> groupFields =  fieldGroupViews.stream().map(TbtskFieldGroupView::getfFieldname).collect(Collectors.toList());
            List<TbtskFields>allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(task.getTableId());
            JSONArray fieldArray = new JSONArray();
            for(TbtskFieldGroupView fg:fieldGroupViews)
            {
                TbtskFields f = allFields.stream().filter(t->t.getfFieldname().equals(fg.getfFieldname())).findFirst().orElse(null);
                if(f!=null)
                {
                    JSONObject fJson = (JSONObject)JSONObject.toJSON(f);
                    fJson.put("fGroup",fg.getfSubgroupname());
                    fJson.put("fGroupOrder",fg.getfGrouporder());
                    fieldArray.add(fJson);
                }

            }

            Map<String,Object>map=  jdbcTemplate.queryForMap("select "+StringUtils.join(groupFields,",")+" from "+objectinfo.getfTablename()+ " where f_id ='"+taskTbid+"'");
            result.put("tbInfo",map);
            result.put("fields",fieldArray);
            List<AppMediaDTO>medias = getMedia(taskTbid);
            result.put("medias",medias);

            List<ApproveRecordDTO> records = tbtskFlowService.findApproveRecordForThird(taskId, taskTbid);
            result.put("approve",records);

        }
        result.put("ddls",getTbDdls(tbid));
        return result;
    }

    @Override
    public void exportDispatchExcel(HttpServletResponse response,String dispatchId) throws IOException {
        response.setHeader("Access-Control-Expose-Headers","status,Content-disposition");
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            TbtskDispatchRecord record = dispatchRecordDao.gwSearchByPK(dispatchId);
            if (record == null) {
                throw new Exception("调度任务不存在");
            }
            File file = exportDispatchExcel(record,localDownload);
            if (file!=null&&file.exists()) {
                FileInputStream fis = null;
                ByteArrayOutputStream baos=null;
                byte [] bytes = null;
                try {
                    fis = new FileInputStream(file);
                    baos = new ByteArrayOutputStream((int) file.length());
                    byte[] buffer = new byte[1024];
                    int len;
                    while ((len = fis.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    fis.close();
                    baos.close();
                    bytes = baos.toByteArray();
                    fis=null;
                    baos=null;
                }
                catch (Exception ex)
                {
                    throw ex;
                }
                finally {
                    if(fis!=null)
                    {
                        fis.close();
                    }
                    if(baos!=null)
                    {
                        baos.close();
                    }
                    try {
                        FileUtils.deleteQuietly(file);
                    } catch (Exception e) {

                    }
                }
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(record.getName(), "UTF-8") + ".xlsx");
                response.setHeader("status","OK");
                response.setContentType("application/octet-stream");
                response.getOutputStream().write(bytes);
            }
            else {
                throw new Exception("导出调度任务图斑excel失败");
            }
        }
        catch (Exception ex)
        {
            logger.error(ex.getMessage(), ex);
            String msg = ex.getMessage();
            if(StringUtils.isBlank(msg))
            {
                msg="导出调度任务图斑excel失败";
            }
            response.setContentType("application/json");
            response.setHeader("status","FAILD");
            response.getOutputStream().write(msg.getBytes("UTF-8"));
        }
    }

    @Override
    public void exportDispatchShp(HttpServletResponse response, String dispatchId) throws IOException {
        response.setHeader("Access-Control-Expose-Headers","status,Content-disposition");
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        File shpFolder = null;
        File zipFile = null;
        try {
            TbtskDispatchRecord record = dispatchRecordDao.gwSearchByPK(dispatchId);
            if (record == null) {
                throw new Exception("调度任务不存在");
            }
            String folder = localDownload+File.separator+record.getId()+"_"+System.currentTimeMillis();
            shpFolder = new File(folder);
            shpFolder.mkdir();
            File shpFile = exportDispatchShp(record,folder);

            if(shpFile==null||!shpFile.exists())
            {
                throw new Exception("导出调度任务图斑shp失败");
            }

            String zipPath = folder+".zip";
            ZipUtil1s.zip(folder,zipPath);
            zipFile = new File(zipPath);
            if (zipFile.exists()) {
                FileInputStream fis = null;
                ByteArrayOutputStream baos = null;
                byte[] bytes = null;
                try {
                    fis = new FileInputStream(zipFile);
                    baos = new ByteArrayOutputStream((int) zipFile.length());
                    byte[] buffer = new byte[1024];
                    int len;
                    while ((len = fis.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    fis.close();
                    baos.close();
                    bytes = baos.toByteArray();
                    fis = null;
                    baos = null;
                } catch (Exception ex) {
                    throw ex;
                } finally {
                    if (fis != null) {
                        fis.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                    try {
                        FileUtils.deleteQuietly(zipFile);
                    } catch (Exception e) {

                    }
                }
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(record.getName(), "UTF-8") + ".zip");
                response.setHeader("status", "OK");
                response.setContentType("application/octet-stream");
                response.getOutputStream().write(bytes);
            }
            else
            {
                throw new Exception("导出调度任务图斑shp失败,压缩shp失败");
            }
        }
        catch (Exception ex)
        {
            logger.error(ex.getMessage(), ex);
            String msg = ex.getMessage();
            if(StringUtils.isBlank(msg))
            {
                msg="导出调度任务图斑shp失败";
            }
            response.setContentType("application/json");
            response.setHeader("status","FAILD");
            response.getOutputStream().write(msg.getBytes("UTF-8"));
        }
        finally {
            if(shpFolder!=null&&shpFolder.exists())
            {
                FileUtils.deleteQuietly(shpFolder);
            }
            if(zipFile!=null&zipFile.exists())
            {
                FileUtils.deleteQuietly(zipFile);
            }
        }
    }

    @Override
    public void exportDispatchPackage(HttpServletResponse response, String dispatchId) throws IOException {
        response.setHeader("Access-Control-Expose-Headers","status,Content-disposition");
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        File rootFolder = null;
        File zipFile = null;
        try {
            TbtskDispatchRecord record = dispatchRecordDao.gwSearchByPK(dispatchId);
            if (record == null) {
                throw new Exception("调度任务不存在");
            }
            String rootPath = localDownload+File.separator+record.getId()+"_"+System.currentTimeMillis();
            rootFolder = new File(rootPath);
            rootFolder.mkdir();

            File shpFolder = new File(rootPath+File.separator+record.getId()+"_shp");
            shpFolder.mkdir();
            File shp = exportDispatchShp(record,shpFolder.getPath());
            if(shp==null||!shp.exists())
            {
                throw new Exception("导出调度任务图斑shp失败");
            }
            File excel = exportDispatchExcel(record,rootPath);
            if(excel==null||!excel.exists())
            {
                throw new Exception("导出调度任务图斑excel失败");
            }
            File db = exportDispatchDb(record,rootPath);
            if(db==null||!db.exists())
            {
                throw new Exception("导出调度任务图斑db失败");
            }
            File attachFolder = new File(rootPath+File.separator+record.getId()+"_attach");
            attachFolder.mkdir();
            exportDispatchAtt(record,attachFolder.getPath());
            String zipPath = rootFolder+".zip";
            ZipUtil1s.zip(rootPath,zipPath);
            zipFile = new File(zipPath);
            if (zipFile.exists()) {
                FileInputStream fis = null;
                ByteArrayOutputStream baos = null;
                byte[] bytes = null;
                try {
                    fis = new FileInputStream(zipFile);
                    baos = new ByteArrayOutputStream((int) zipFile.length());
                    byte[] buffer = new byte[1024];
                    int len;
                    while ((len = fis.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    fis.close();
                    baos.close();
                    bytes = baos.toByteArray();
                    fis = null;
                    baos = null;
                } catch (Exception ex) {
                    throw ex;
                } finally {
                    if (fis != null) {
                        fis.close();
                    }
                    if (baos != null) {
                        baos.close();
                    }
                    try {
                        FileUtils.deleteQuietly(zipFile);
                    } catch (Exception e) {

                    }
                }
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(record.getName(), "UTF-8") + ".zip");
                response.setHeader("status", "OK");
                response.setContentType("application/octet-stream");
                response.getOutputStream().write(bytes);
            }
            else
            {
                throw new Exception("导出调度任务图斑数据包失败,压缩失败");
            }
        }
        catch (Exception ex)
        {
            logger.error(ex.getMessage(), ex);
            String msg = ex.getMessage();
            if(StringUtils.isBlank(msg))
            {
                msg="导出调度任务图斑数据包失败";
            }
            response.setContentType("application/json");
            response.setHeader("status","FAILD");
            response.getOutputStream().write(msg.getBytes("UTF-8"));
        }
        finally {

            if(zipFile!=null&zipFile.exists())
            {
                FileUtils.deleteQuietly(zipFile);
            }
            if(rootFolder!=null&&rootFolder.exists())
            {
                FileUtils.deleteQuietly(rootFolder);
            }
        }
    }

    @Override
    public JSONArray getNearByDron(Double lon, Double lat, Double distance) throws Exception {
        String sevice = fcUrl+"/fczx-server/api/devices/v1/nearby/radius?lon="+lon+"&lat="+lat;
        Map<String,String>headers = new HashMap<>();
        headers.put("X-Auth-Token",X_Auth_Token);
        HttpResponse response = HttpUtil.createGet(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("蜂巢接口调用失败"+response.body());
            throw new Exception("蜂巢接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONArray result = new JSONArray();
        JSONArray jsonArray =JSONArray.parseArray(body);
        if(jsonArray!=null&&!jsonArray.isEmpty())
        {
            if(distance!=null&&distance>0) {
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if(jsonObject.containsKey("distance"))
                    {
                        double dis= jsonObject.getDouble("distance");
                        if(dis<=distance)
                        {
                            result.add(jsonObject);
                        }
                    }
                }

            }
            else
            {
                result = jsonArray;
            }
        }

        return result;
    }

    @Override
    public JSONArray getNearByCamera(Double lon, Double lat, Double distance) throws Exception {
        String sevice = ygbUrl+"/api/third/getDeviceListByRegionAndName";
        String param="{\"regionCode\":\"500000\",\"name\":\"\",\"streamType\":\"1\",\"netType\":\"1\",\"protocolType\":\"5\",\"contain\":1}";
        if(distance==null)
        {
            distance=5000.0;
        }
        HttpResponse response = HttpUtil.createPost(sevice).body(param).execute();
        if(!response.isOk())
        {
            logger.error("铁塔接口调用失败"+response.body());
            throw new Exception("铁塔接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONArray rows = null;
        JSONObject bodyResult = JSONObject.parseObject(body);
        if(bodyResult.containsKey("status")&&bodyResult.getString("status").equalsIgnoreCase("OK"))
        {
             rows = bodyResult.getJSONArray("rows");
        }
        JSONArray result = new JSONArray();
        if(rows!=null&&!rows.isEmpty())
        {
            Map<Integer,CoordinateReferenceSystem>mapRef = new HashMap<>();
            WKTReader reader = new WKTReader();
            Geometry geo1=  reader.read("POINT("+lon+" "+lat+")");
            int num = GeometryTrasnUtil.getProjNum(geo1);
            CoordinateReferenceSystem ref1 =  GeometryTrasnUtil.getCgcsPrjCoordinateReferenceSystem(num);
            geo1 =  GeometryTrasnUtil.transCgcs2000ToPrj(geo1,ref1);
            mapRef.put(num,ref1);
            if(distance!=null&&distance>0) {
                for (int i = 0; i < rows.size(); i++) {
                    JSONObject jsonObject = rows.getJSONObject(i);
                    if(jsonObject.containsKey("lonlat"))
                    {
                        String lonlat= jsonObject.getString("lonlat");
                        if(StringUtils.isNotBlank(lonlat)) {
                            String[] ll = StringUtils.split(lonlat, ",");
                            Double lona = Double.parseDouble(ll[0]);
                            Double lata = Double.parseDouble(ll[1]);
                            Geometry geo2 = reader.read("POINT(" + lona + " " + lata + ")");
                            num = GeometryTrasnUtil.getProjNum(geo2);
                            CoordinateReferenceSystem ref2 = null;
                            if (!mapRef.containsKey(num)) {
                                ref2 = GeometryTrasnUtil.getCgcsPrjCoordinateReferenceSystem(num);
                                mapRef.put(num, ref2);
                            }
                            else
                            {
                                ref2 =mapRef.get(num);
                            }
                            geo2 =  GeometryTrasnUtil.transCgcs2000ToPrj(geo2,ref2);
                            double leng = geo1.distance(geo2);
                            if(leng<=distance)
                            {
                                result.add(jsonObject);
                            }
                        }

                    }
                }

            }
            else
            {
                result = rows;
            }
        }

        return result;
    }
    @Override
    public JSONObject getPageNearUser(String name,Double lon, Double lat, Double distance,Integer page,Integer limit)throws Exception{
        if(distance==null)
        {
            distance=5000.0;
        }
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE, -3);//10分钟之前的时间
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql =String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\n" +
                "t3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\n" +
                "t4 as (select * from t3 where f_distance <%s order by f_distance)\n" +
                "select  t5.f_userid,t5.f_username,t5.f_mid_userid,t5.f_subject_userid,t4.f_distance,t4.f_lon,t4.f_lat from tbsys_user t5 inner join t4 on t5.f_userid  = t4.f_userid",before5,lon,lat,distance);
        String countSql =String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\n" +
                "t3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\n" +
                "t4 as (select * from t3 where f_distance <%s order by f_distance)\n" +
                "select count(1) from tbsys_user t5 inner join t4 on t5.f_userid  = t4.f_userid",before5,lon,lat,distance);
        if(StringUtils.isNotBlank(name))
        {
            countSql+=" where t5.f_username like '%"+name+"%'";
            sql+=" where t5.f_username like '%"+name+"%'";
        }
        JSONObject result = new JSONObject();
        Map<String,Object>mapCount = jdbcTemplate.queryForMap(countSql);
        int count =Integer.parseInt(mapCount.get("count").toString());
        result.put("count",count);
        if(count==0)
        {
            return result;
        }
        int offset = (page-1)*limit;

        sql+=" order by f_userid "+"offset "+offset+" limit "+limit;
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
            return null;
        List<OnlineUserInfo>users = new ArrayList<>();
        for(Map map:maps)
        {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();
            BusUserInfoReso reso =  oauthUserService.getBusUser(busId);
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.parseLong(userId));
            user.setUserName(map.get("f_username").toString());
            if(reso!=null) {
                user.setUserPhone(reso.getPhone());
                user.setUserOrg(reso.getOrgName());
            }
            user.setDistance(Double.parseDouble(map.get("f_distance").toString()));
            user.setLon(Double.parseDouble(map.get("f_lon").toString()));
            user.setLat(Double.parseDouble(map.get("f_lat").toString()));
            users.add(user);
        }
        result.put("list",users);
        return result;
    }

    @Override
    public List<OnlineUserInfo> getNearByUser(String name,Double lon, Double lat, Double distance) throws Exception {
        if(distance==null)
        {
            distance=5000.0;
        }
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE, -3);//10分钟之前的时间
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql =String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\n" +
                "t3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat,util_computedistance(st_geometryfromtext('POINT('||t2.f_lon||' '||t2.f_lat||')',4490),st_geometryfromtext('POINT(%s %s)',4490)) as f_distance  from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime),\n" +
                "t4 as (select * from t3 where f_distance <%s order by f_distance)\n" +
                "select  t5.f_userid,t5.f_username,t5.f_mid_userid,t5.f_subject_userid,t4.f_distance,t4.f_lon,t4.f_lat from tbsys_user t5 inner join t4 on t5.f_userid  = t4.f_userid",before5,lon,lat,distance);
        if(StringUtils.isNotBlank(name))
        {
            sql+=" where t5.f_username like '%"+name+"%'";
        }
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
            return null;
        List<OnlineUserInfo>users = new ArrayList<>();
        for(Map map:maps)
        {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();
            BusUserInfoReso reso =  oauthUserService.getBusUser(busId);
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.parseLong(userId));
            user.setUserName(map.get("f_username").toString());
            if(reso!=null) {
                user.setUserPhone(reso.getPhone());
                user.setUserOrg(reso.getOrgName());
            }
            user.setDistance(Double.parseDouble(map.get("f_distance").toString()));
            user.setLon(Double.parseDouble(map.get("f_lon").toString()));
            user.setLat(Double.parseDouble(map.get("f_lat").toString()));
            users.add(user);
        }
        return users;
    }


    @Override
    public JSONObject getAllOnlineDron(String name) throws Exception {
        String sevice = fcUrl+"/fczx-server/api/devices/v1/list?status=true&withChild=true";
        Map<String,String>headers = new HashMap<>();
        headers.put("X-Auth-Token",X_Auth_Token);
        HttpResponse response = HttpUtil.createGet(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("蜂巢接口调用失败"+response.body());
            throw new Exception("蜂巢接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONObject result = new JSONObject();
        JSONArray datas = new JSONArray();
        JSONArray jsonArray =JSONArray.parseArray(body);
        if(jsonArray!=null&&!jsonArray.isEmpty())
        {
            if(StringUtils.isNotBlank(name)) {
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if(jsonObject.containsKey("nickname"))
                    {
                        String nickname= jsonObject.getString("nickname");
                        if(StringUtils.isNotBlank(nickname)&&nickname.contains(name))
                        {
                            datas.add(jsonObject);
                        }
                    }
                }

            }
            else
            {
                datas = jsonArray;
            }
        }
        result.put("totalCount",datas.size());
        result.put("data",datas);
        return result;
    }

    @Override
    public JSONObject getAllOnlineCamera(String name) throws Exception {
        String sevice = ygbUrl+"/api/third/getDeviceListByRegionAndName";
        String param="{\"regionCode\":\"500000\",\"name\":\"\",\"streamType\":\"1\",\"netType\":\"1\",\"protocolType\":\"5\",\"contain\":1}";

        HttpResponse response = HttpUtil.createPost(sevice).body(param).execute();
        if(!response.isOk())
        {
            logger.error("铁塔接口调用失败"+response.body());
            throw new Exception("铁塔接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONArray rows = null;
        JSONObject bodyResult = JSONObject.parseObject(body);
        if(bodyResult.containsKey("status")&&bodyResult.getString("status").equalsIgnoreCase("OK"))
        {
            rows = bodyResult.getJSONArray("rows");
        }
        JSONObject result = new JSONObject();
        JSONArray datas = new JSONArray();
        if(rows!=null&&!rows.isEmpty())
        {

            if(StringUtils.isNotBlank(name)) {
                for (int i = 0; i < rows.size(); i++) {
                    JSONObject jsonObject = rows.getJSONObject(i);
                    if(jsonObject.containsKey("name"))
                    {
                        String nickname= jsonObject.getString("name");
                        if(StringUtils.isNotBlank(nickname)&&nickname.contains(name))
                        {
                            datas.add(jsonObject);
                        }

                    }
                }

            }
            else
            {
                datas = rows;
            }
        }
        result.put("totalCount",datas.size());
        result.put("data",datas);
        return result;
    }

    @Override
    public JSONObject getPageOnlineUser(String name, Integer page, Integer limit) throws Exception {
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE, -3);//10分钟之前的时间
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String countSql = String.format("select count(*) as count from tbsys_user  where f_userid in (select distinct (f_userid) from tb_devicetrack td where f_updatetime > '%s')",before5);
        if(StringUtils.isNotBlank(name))
        {
            countSql+=" and f_username like '%"+name+"%'";
        }
        JSONObject result = new JSONObject();
        Map<String,Object>mapCount = jdbcTemplate.queryForMap(countSql);
        int count =Integer.parseInt(mapCount.get("count").toString());
        result.put("count",count);
        if(count==0)
        {
            return result;
        }
        String sql =String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\n" +
                "t3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime)\n" +
                "select  t4.f_userid,t4.f_username,t4.f_mid_userid,t4.f_subject_userid,t3.f_lon,t3.f_lat from tbsys_user t4 inner join t3 on t4.f_userid  = t3.f_userid",before5);
        if(StringUtils.isNotBlank(name))
        {
            sql+=" and t4.f_username like '%"+name+"%'";
        }
        int offset = (page-1)*limit;

        sql+=" order by f_userid "+"offset "+offset+" limit "+limit;
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
        {
            return result;
        }
        List<OnlineUserInfo>users = new ArrayList<>();
        for(Map map:maps)
        {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();

            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.parseLong(userId));
            user.setUserName(map.get("f_username").toString());
            BusUserInfoReso reso =  oauthUserService.getBusUser(busId);
            if(reso!=null) {
                user.setUserPhone(reso.getPhone());
                user.setUserOrg(reso.getOrgName());
            }
            user.setLon(Double.parseDouble(map.get("f_lon").toString()));
            user.setLat(Double.parseDouble(map.get("f_lat").toString()));
            users.add(user);
        }
        result.put("list",users);
        return result;
    }

    @Override
    public JSONObject getAllOnlineUser(String name){
        JSONObject result = new JSONObject();
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE, -3);//10分钟之前的时间
        Date beforeD = beforeTime.getTime();
        String before5 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        String sql =String.format("with t1 as (select f_userid,max(f_updatetime) as f_updatetime from tb_devicetrack td where f_updatetime > '%s' group by f_userid),\n" +
                "t3 as (select t2.f_userid,t2.f_updatetime,t2.f_lon,t2.f_lat from tb_devicetrack t2,t1 where t2.f_userid  = t1.f_userid and t2.f_updatetime = t1.f_updatetime)\n" +
                "select  t4.f_userid,t4.f_username,t4.f_mid_userid,t4.f_subject_userid,t3.f_lon,t3.f_lat from tbsys_user t4 inner join t3 on t4.f_userid  = t3.f_userid",before5);
        if(StringUtils.isNotBlank(name))
        {
            sql+=" and t4.f_username like '%"+name+"'";
        }
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
        {
            result.put("totalCount",0);
            return  result;
        }

        List<OnlineUserInfo>users = new ArrayList<>();
        for(Map map:maps)
        {
            String userId = map.get("f_userid").toString();
            String busId = map.get("f_subject_userid").toString();

            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserId(Long.parseLong(userId));
            user.setUserName(map.get("f_username").toString());

//            BusUserInfoReso reso =  oauthUserService.getBusUser(busId);
//            if(reso!=null) {
//                user.setUserPhone(reso.getPhone());
//                user.setUserOrg(reso.getOrgName());
//            }

            user.setLon(Double.parseDouble(map.get("f_lon").toString()));
            user.setLat(Double.parseDouble(map.get("f_lat").toString()));
            users.add(user);
        }
        result.put("totalCount",users.size());
        result.put("data",users);
        return result;
    }

    @Override
    public OnlineUserInfo getUserInfo(Long userId)
    {
        List<TbsysUserSubjectRel>rels =  tbsysUserSubjectRelRepository.findByUserId(userId);
        if(rels==null||rels.isEmpty())
            return null;
        String busId = rels.get(0).getSubjectUserId();
        if(StringUtils.isBlank(busId))
            return null;

        BusUserInfoReso reso =  oauthUserService.getBusUser(busId);
        if(reso!=null) {
            OnlineUserInfo user = new OnlineUserInfo();
            user.setUserPhone(reso.getPhone());
            user.setUserOrg(reso.getOrgName());
            user.setUserId(userId);
            return user;
        }
        return null;
    }
    @Override
    public JSONObject getCameraVideoRealtimeUrl(String channelCode,String deviceCode) throws Exception {
        String sevice = ygbUrl+"/api/third/getVideoRealtimeUrl";
        String param=String.format("{\"deviceCode\":\"%s\",\"channelCode\":\"%s\",\"streamType\":\"1\",\"protocolType\":\"5\",\"netType\":\"1\"}",deviceCode,channelCode);

        return getVideoRealtimeUrl(JSONObject.parseObject(param));
        /*
        cn.hutool.http.HttpResponse response = HttpUtil.createPost(sevice).body(param).execute();
        if(!response.isOk())
        {
            logger.error("铁塔接口调用失败"+response.body());
            throw new Exception("铁塔接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }

        JSONObject bodyResult = JSONObject.parseObject(body);
        if(bodyResult.containsKey("status")&&bodyResult.getString("status").equalsIgnoreCase("OK"))
        {
            return bodyResult.getJSONObject("data");
        }
        return null;
        */
    }

    @Override
    public String getCameraUrl(String channelCode,String deviceCode) throws Exception {
        JSONObject object2 = new JSONObject();
        object2.put("streamType",2);
        object2.put("protocolType",4);
        object2.put("netType",1);
        object2.put("deviceCode",deviceCode);
        object2.put("channelCode",channelCode);
        JSONObject result = getVideoRealtimeUrl(object2);
        String url =  result.getString("streamUrl");
        return url;
        /*
        String sevice = ygbUrl+"/api/screen/getDeviceUrlByDeviceProperties?deviceCode="+deviceCode+"&channelCode="+channelCode;

        cn.hutool.http.HttpResponse response = HttpUtil.createGet(sevice).execute();
        if(!response.isOk())
        {
            logger.error("铁塔接口调用失败"+response.body());
            throw new Exception("铁塔接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }

        JSONObject bodyResult = JSONObject.parseObject(body);
        if(bodyResult.containsKey("status")&&bodyResult.getString("status").equalsIgnoreCase("OK"))
        {
            return bodyResult.getString("data");
        }
        return null;
        */
    }

    @Override
    public JSONArray getDronCapacity() throws Exception {
        String sevice = djUrl+"/dji-cloud-server/manage/api/v1/live/capacity";
        Map<String,String>headers = new HashMap<>();
        headers.put("X-Auth-Token",X_Auth_Token);
        HttpResponse response = HttpUtil.createGet(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONObject result = JSONObject.parseObject(body);
        if(result.containsKey("data"))
        {
            return  result.getJSONArray("data");
        }
        return null;

    }

    @Override
    public JSONObject startDronLive(JSONObject param) throws Exception {
        //{"url":"webrtc://43.138.231.95/live/1719121093788","url_type":1,"video_id":"7CTDM2V00B2LF2/165-0-7/normal-0","video_quality":1}
        if(param==null)
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("url"))
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("url_type"))
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("video_id"))
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("video_quality"))
        {
            throw new Exception("参数异常");
        }
        String sevice = djUrl+"/dji-cloud-server/manage/api/v1/live/streams/start";
        Map<String,String>headers = new HashMap<>();
        headers.put("X-Auth-Token",X_Auth_Token);
        HttpResponse response = HttpUtil.createPost(sevice).body(param.toJSONString()).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONObject result = JSONObject.parseObject(body);
        if(result.containsKey("data"))
        {
            return  result.getJSONObject("data");
        }
        return null;
    }


    @Override
    public JSONObject stopDronLive(JSONObject param) throws Exception {
        //{"url":"webrtc://43.138.231.95/live/1719121093788","url_type":1,"video_id":"7CTDM2V00B2LF2/165-0-7/normal-0","video_quality":1}
        if(param==null)
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("url"))
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("url_type"))
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("video_id"))
        {
            throw new Exception("参数异常");
        }
        if(!param.containsKey("video_quality"))
        {
            throw new Exception("参数异常");
        }
        String sevice = djUrl+"/dji-cloud-server/manage/api/v1/live/streams/stop";
        Map<String,String>headers = new HashMap<>();
        headers.put("X-Auth-Token",X_Auth_Token);
        HttpResponse response = HttpUtil.createPost(sevice).body(param.toJSONString()).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }
        JSONObject result = JSONObject.parseObject(body);
        if(result.containsKey("data"))
        {
            return  result.getJSONObject("data");
        }
        return null;
    }

    @Override
    public JSONArray getWaylinesCalcRange(JSONObject param) throws Exception {
        String sevice = fcUrl+"/fczx-server/api/waylines/v1/calc/range";
        Map<String,String>headers = new HashMap<>();
        headers.put("X-Auth-Token",X_Auth_Token);
        HttpResponse response = HttpUtil.createPost(sevice).body(param.toJSONString()).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("蜂巢接口调用失败"+response.body());
            throw new Exception("蜂巢接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            return null;
        }

        JSONArray result = JSONArray.parseArray(body);
        return result;
    }

    @Override
    public JSONObject getWaylinesJob(String jobId) throws Exception {
        String sevice = String.format(fcUrl+"/fczx-server/api/waylines/v1/job/%s",jobId);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);

        HttpResponse response = HttpUtil.createGet(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("蜂巢接口调用失败"+response.body());
            throw new Exception("蜂巢接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            throw new Exception("获取任务失败");
        }
        JSONObject result = JSONObject.parseObject(body);
        return result;
    }

    @Override
    public JSONObject createDronWaylinesJobs(LineJobParamDetailInfo detailInfo) throws Exception {
        if (detailInfo == null) {
            throw new Exception("参数异常");
        }
        if (detailInfo.getIds() == null || detailInfo.getIds().size() == 0) {
            throw new Exception("未设置调度图斑id");
        }
        if (StringUtils.isBlank(detailInfo.getDockSn())) {
            throw new Exception("未设置无人机编号");
        }
        List<String> ids = detailInfo.getIds();
        List<TbtskDispatchInfo> tbs = dispatchInfoDao.selectByIds(ids);
        if (tbs == null || tbs.isEmpty()) {
            throw new Exception("调度图斑不存在");
        }
        if (tbs.size() != ids.size()) {
            List<String> notExist = ids.stream().filter(t -> tbs.stream().filter(s -> !s.getId().equals(t)).findFirst().isPresent()).collect(Collectors.toList());
            throw new Exception("调度图斑" + StringUtils.join(notExist, ",") + "不存在");
        }
        TbtskDispatchRecord record = dispatchRecordDao.gwSearchByPK(tbs.get(0).getDispatchId());
        if (record == null) {
            throw new Exception("调度任务不存在");
        }
        List<TbtskDispatchInfo> needImport = tbs.stream().filter(t -> t.getImportFc() == null || t.getImportFc() == 0).collect(Collectors.toList());
        if (needImport != null && !needImport.isEmpty()) {
            File zipFile = null;
            File shpFolder = null;
            try {
                String folder = localUpload + File.separator + namespaceId + System.currentTimeMillis();
                shpFolder = new File(folder);
                if (!shpFolder.exists()) {
                    shpFolder.mkdir();
                }
                String folder1 = folder + File.separator + System.currentTimeMillis();
                shpFolder = new File(folder1);
                if (!shpFolder.exists()) {
                    shpFolder.mkdir();
                }
                File shpFile = exportDispatchShpToImport(folder1, needImport.stream().map(TbtskDispatchInfo::getId).collect(Collectors.toList()));
                ZipUtil1s.zip(folder1, folder1 + ".zip");
                zipFile = new File(folder1 + ".zip");
            } catch (Exception ex) {
                logger.error("下载调度图斑为shp异常" + ExceptionUtil.getErrorString(ex));
            }
            if (shpFolder != null && shpFolder.exists()) {
                FileUtils.deleteQuietly(shpFolder);
            }
            if (zipFile == null || !zipFile.exists()) {
                throw new Exception("当前图斑未推送到无人机巡查系统");
            }

            try {

                String importUrl = fcUrl + "/fczx-server/api/spots/v1/import/shape";
                HttpResponse response = HttpUtil.createPost(importUrl)
                        .form("attributeMap['bsm']", "f_id")
                        .form("attributeMap['dlbm']", "f_dlbm")
                        .form("attributeMap['dlmc']", "f_dlmc")
                        .form("attributeMap['zldwdm']", "f_zldwdm")
                        .form("attributeMap['zldwmc']", "f_zldwmc")
                        .form("attributeMap['tbmj']", "f_tbmj")
                        .form("attributeMap['geom']", "the_geom")
                        .form("charset", "GBK")
                        .form("namespaceId", namespaceId)
                        .form("file", zipFile).execute();

                String body = response.body();
                boolean sucImport = false;
                if (!StringUtils.isBlank(body)) {
                    sucImport = true;
                    try {
                        JSONObject json = JSONObject.parseObject(body);
                        if (json.containsKey("status") && !json.getString("status").equalsIgnoreCase("ok")) {
                            sucImport = false;
                        }
                    } catch (Exception ex) {

                    }

                }

                if (!sucImport) {
                    throw new Exception("当前图斑推送到无人机巡查系统失败");
                }
                dispatchInfoDao.updateImport(ids);
            } catch (Exception ex) {
                logger.error("当前图斑推送到无人机巡查系统失败" + ExceptionUtil.getErrorString(ex));
                throw new Exception("当前图斑推送到无人机巡查系统失败");
            } finally {
                FileUtils.deleteQuietly(zipFile);
            }
        }
        String name = "空天地_" + "_" + ids.get(0);
        if (StringUtils.isBlank(detailInfo.getJobType())) {
            detailInfo.setJobType("waypoint");
        }
        List<String> ids2 = new ArrayList<>();
        ids2.addAll(ids);
        LineJobParamInfo param = new LineJobParamInfo();
        param.setIds(ids2);
        param.setName(name);
        param.setRestrict(new ArrayList<>());
        param.setNamespaceId(namespaceId);

        detailInfo.setXcmj(tbs.stream().mapToDouble(TbtskDispatchInfo::getTbmj).sum());
        List<LineJobParamDetailInfo> details = new ArrayList<>();
        details.add(detailInfo);
        param.setDetails(details);
        String sevice = fcUrl + "/fczx-server/api/waylines/v1/make/job";
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);
        HttpResponse response = HttpUtil.createPost(sevice).body(JSONObject.toJSONString(param)).addHeaders(headers).execute();
        if (!response.isOk()) {
            String body = response.body();
            JSONObject result = JSONObject.parseObject(body);
            if(result.containsKey("status")&&result.getString("status").equals("error"))
            {
                throw new Exception(result.getString("message"));
            }
            logger.error("蜂巢接口调用失败" + response.body() + " param:" + JSONObject.toJSONString(param));
            throw new Exception("蜂巢接口调用失败");
        }
        String body = response.body();
        JSONObject result = JSONObject.parseObject(body);
        String jobId = result.keySet().stream().collect(Collectors.toList()).get(0);

        for (TbtskDispatchInfo info : tbs)
        {
            TbtskDispatchInfo newInfo = new TbtskDispatchInfo();
            newInfo.setId(info.getId());
            newInfo.setDronJob(jobId);
            newInfo.setImportFc(1);
            dispatchInfoDao.gwUpdateByPKSelective(newInfo);
        }

        return result;
    }

    @Override
    public JSONArray getJobLine(String jobId) throws Exception {
        String sevice = String.format(fcUrl+"/fczx-server/api/waylines/v1/polygon/line?jobId=%s",jobId);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);

        HttpResponse response = HttpUtil.createGet(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("蜂巢接口调用失败"+response.body());
            throw new Exception("蜂巢接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            throw new Exception("获取任务航线失败");
        }
        JSONArray result = JSONArray.parseArray(body);
        return result;
    }


    @Override
    public void stopDronJob(String workspaceId, String jobId) throws Exception {
        String sevice = String.format(djUrl+"/wayline/api/v1/workspaces/%s/jobs/%s",workspaceId,jobId);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);
        JSONObject param = new JSONObject();
        param.put("status",0);
        HttpResponse response = HttpUtil.createPost(sevice).body(param.toJSONString()).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            throw new Exception("终止飞行任务失败");
        }
        JSONObject result = JSONObject.parseObject(body);
        if(!result.containsKey("code")||!result.getString("code").equals(0))
        {
            throw new Exception("终止飞行任务失败");
        }

    }

    @Override
    public void restartDronJob(String workspaceId, String jobId) throws Exception {
        String sevice = String.format(djUrl+"/wayline/api/v1/workspaces/%s/jobs/%s",workspaceId,jobId);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);
        JSONObject param = new JSONObject();
        param.put("status",1);
        HttpResponse response = HttpUtil.createPost(sevice).body(param.toJSONString()).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            throw new Exception("恢复飞行任务失败");
        }
        JSONObject result = JSONObject.parseObject(body);
        if(!result.containsKey("code")||!result.getString("code").equals(0))
        {
            throw new Exception("恢复飞行任务失败");
        }

    }

    @Override
    public void returnHomeDron(String deviceSn) throws Exception {
        String sevice = String.format(djUrl+"/control/api/v1/devices/%s/jobs/return_home",deviceSn);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);
        HttpResponse response = HttpUtil.createPost(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            throw new Exception("无人机返航失败");
        }
        JSONObject result = JSONObject.parseObject(body);
        if(!result.containsKey("code")||!result.getString("code").equals(0))
        {
            throw new Exception("无人机返航失败");
        }

    }

    @Override
    public void cancleReturnHomeDron(String deviceSn) throws Exception {
        String sevice = String.format(djUrl+"/control/api/v1/devices/%s/jobs/return_home_cancel",deviceSn);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);
        HttpResponse response = HttpUtil.createPost(sevice).addHeaders(headers).execute();
        if(!response.isOk())
        {
            logger.error("大疆云接口调用失败"+response.body());
            throw new Exception("大疆云接口调用失败");
        }
        String body =response.body();
        if(StringUtils.isBlank(body))
        {
            throw new Exception("取消无人机返航失败");
        }
        JSONObject result = JSONObject.parseObject(body);
        if(!result.containsKey("code")||!result.getString("code").equals(0))
        {
            throw new Exception("取消无人机返航失败");
        }

    }

    @Override
    public void setUserDispatchRecord(JSONObject json) {
        String id = json.getString("dispatchId");
        String url=json.getString("url");
        String snapshotUrl=json.getString("snapshotUrl");
        String fileName = json.getString("fileName");
        String objName="zhhd/"+id+"/"+fileName;
        try {
            url=  uploadFile(url, objName);
        }
        catch (Exception ex)
        {
            logger.error("上传人员调度录屏信息失败"+ExceptionUtil.getErrorString(ex));
        }
        if(StringUtils.isNotBlank(snapshotUrl)) {
            String objName2 = "zhhd/" + id + "/" + fileName.toLowerCase().replace(".mp4", ".png");
            try {
                snapshotUrl = uploadFile(snapshotUrl, objName2);
            } catch (Exception ex) {
                logger.error("上传人员调度录屏首页信息失败" + ExceptionUtil.getErrorString(ex));
            }
        }

        Date time = new Date();
        List<TbtskDispatchAttach>attaches = new ArrayList<>();
        if(StringUtils.isNotBlank(url))
        {
            TbtskDispatchAttach attach = new TbtskDispatchAttach();
            attach.setId(UUID.randomUUID().toString().replace("-",""));
            attach.setUrl(url);
            attach.setInfoId(id);
            attach.setTime(time);
            //attach.setType(EnumAttachType.record.getCode());
            attaches.add(attach);
        }
        if(StringUtils.isNotBlank(snapshotUrl))
        {
            TbtskDispatchAttach attach = new TbtskDispatchAttach();
            attach.setId(UUID.randomUUID().toString().replace("-",""));
            attach.setUrl(snapshotUrl);
            attach.setInfoId(id);
            attach.setTime(time);
           // attach.setType(EnumAttachType.snapshot.getCode());
            attaches.add(attach);
        }
        dispatchAttachDao.insertBatch(attaches);
    }

    @Override
    public TbtskDispatchUser stopDispatch(DispatchResultInfo resultInfo) throws Exception {
        if(resultInfo==null)
        {
            throw new Exception("调度结果参数为空");
        }
        if(StringUtils.isBlank(resultInfo.getJl()))
        {
            throw new Exception("调度结论为空");
        } if(StringUtils.isBlank(resultInfo.getYj()))
        {
            throw new Exception("调度意见为空");
        }
        if(StringUtils.isBlank(resultInfo.getDispatchTbId()))
        {
            throw new Exception("调度图斑id为空");
        }
        if(StringUtils.isBlank(resultInfo.getConnectId()))
        {
            throw new Exception("调度(人员、摄像头、无人机)id为空");
        }
        if(resultInfo.getDispatchType()==null)
        {
            throw new Exception("调度(人员、摄像头、无人机)方式为空");
        }
        EnumDispatchType dispatchType = EnumDispatchType.valueOf(resultInfo.getDispatchType());
        if(dispatchType==null)
        {
            throw new Exception("调度(人员、摄像头、无人机)方式错误");
        }
        TbtskDispatchInfo info =  dispatchInfoDao.gwSearchByPK(resultInfo.getDispatchTbId());
        if(info==null)
        {
            throw new Exception("调度图斑不存在");
        }
        TbtskDispatchUser user = new TbtskDispatchUser();
        user.setId(UUID.randomUUID().toString().replace("-",""));
        user.setInfoId(resultInfo.getDispatchTbId());
        user.setConclusion(resultInfo.getJl());
        user.setOpinion(resultInfo.getYj());
        user.setConnectId(resultInfo.getConnectId());
        user.setType(resultInfo.getDispatchType());
        user.setTime(new Date());
        user.setDispatchId(info.getDispatchId());
        dispatchUserDao.gwAccess(user);

        info.setDispatch(1);
        info.setJl(resultInfo.getJl());
        info.setYj(resultInfo.getYj());
        dispatchInfoDao.gwUpdateByPK(info);
        logger.info("完成调度，调度图斑id:"+info.getId());
        if(resultInfo.getDispatchType().equals(EnumDispatchType.draw.getCode())) {
            logger.info("完成无人机调度，调度图斑id:"+info.getId());
            CompletableFuture.runAsync(() -> {
                getDronJpg(info.getDronJob(), info.getTbid(), info.getTaskId(), info.getId());
            });
        }
        return user;
    }

    @Override
    public List<TbtskDispatchAttach> uploadAttach(MultipartFile[] files, String tbid) throws Exception {
        if(StringUtils.isBlank(tbid))
        {
            throw new Exception("请设置调度任务图斑id");
        }
        if(files==null||files.length==0)
        {
            throw new Exception("上传文件为空");
        }
        TbtskDispatchInfo info =  dispatchInfoDao.gwSearchByPK(tbid);
        if(info==null)
        {
            throw new Exception("调度图斑不存在");
        }
        File uploaddirectory = new File(localUpload);

        if(!uploaddirectory.exists() && uploaddirectory.isDirectory()){
            uploaddirectory.mkdir();
        }
        String uploadFolderPath = localUpload+File.separator+tbid+System.currentTimeMillis();
        File uploadFolder = new File(uploadFolderPath);
        uploadFolder.mkdir();
        List<String>urls = new ArrayList<>();
        for(MultipartFile file:files)
        {

            FileOutputStream outputStream = null;
            String originalFilename = file.getOriginalFilename();

            String objName="zhhd/"+tbid+"/"+originalFilename;
            String url = defaultOssOperatorService.sendObject2Oss(objName,file.getInputStream());
            if(StringUtils.isBlank(url))
            {
                throw new Exception("上传文件:"+originalFilename+"失败");
            }
            urls.add(url);

        }
        Date time = new Date();
        List<TbtskDispatchAttach>attaches = new ArrayList<>();
        for(String url:urls)
        {
            TbtskDispatchAttach attach = new TbtskDispatchAttach();
            attach.setId(UUID.randomUUID().toString().replace("-",""));
            attach.setUrl(url);
            attach.setInfoId(tbid);
            attach.setTime(time);
//            attach.setType(EnumAttachType.comm.getCode());
            attaches.add(attach);
        }
       dispatchAttachDao.insertBatch(attaches);
        return attaches;

    }
    @Override
    public JSONObject getDispatchResult(String tbid)
    {
        TbtskDispatchInfo tb =  dispatchInfoDao.gwSearchByPK(tbid);
        /*
        if(!tb.getDispatch().equals(1))
        {
            return null;
        }
        */
        TbtskDispatchAttach attach = new TbtskDispatchAttach();
        attach.setInfoId(tbid);
        List<TbtskDispatchAttach>attaches =  dispatchAttachDao.gwSearch(attach);
        List<DispatchAttachDto>attachDtos = new ArrayList<>();

        if(attaches!=null&&!attaches.isEmpty())
        {
            for (TbtskDispatchAttach a:attaches)
            {
                String [] names =StringUtils.split(a.getUrl(),"/");
                String name = names[names.length-1];
                String ext = name.substring(name.lastIndexOf(".")+1);
                name = name.substring(0,name.lastIndexOf("."));
                a.setUrl(temporarySignedUrlService.getTemporarySignedUrl("",a.getUrl(),null));
                DispatchAttachDto dto = new DispatchAttachDto();
                BeanUtils.copyProperties(a,dto);
                dto.setName(name);
                dto.setExt(ext);
                attachDtos.add(dto);

            }
        }


        JSONObject result = new JSONObject();
        result.put("dispatchTb",tb);
        result.put("attachs",attachDtos);
        return result;
    }
    @Override
    public void deleteAttach(String attachId)
    {
        dispatchAttachDao.gwDeleteByPK(attachId);
    }
    private File exportDispatchExcel(TbtskDispatchRecord record, String rootFolder) throws Exception {
        TbtskDispatchInfo search = new TbtskDispatchInfo();
        search.setDispatchId(record.getId());
        List<TbtskDispatchInfo> tbs = dispatchInfoDao.gwSearch(search);
        if (tbs == null || tbs.isEmpty()) {
            throw new Exception("调度任务不存在调度图斑");
        }
        tbs.sort((a, b) -> a.getTbbh().compareTo(b.getTbbh()));
        String report = rootFolder + File.separator + record.getId()+"_"+System.currentTimeMillis()+ ".xlsx";
        SXSSFWorkbook excelWorkBook = ExcelUtil.CreateSXSSExcel();
        Sheet excelSheet = ExcelUtil.createSheet(excelWorkBook, record.getName());
        List<Integer> colWidth = new ArrayList<>();
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);

        for (int i = 0; i < colWidth.size(); i++) {
            excelSheet.setColumnWidth(i, colWidth.get(i) * 200);
        }
        List<ExcelRowData> rows = new ArrayList<>();
        List<String> headers = new ArrayList<>();
        headers.add("编号");
        headers.add("政区");
        headers.add("面积(m2)");
        headers.add("状态");
        headers.add("调度人");
        headers.add("调度人手机号");
        headers.add("调度时间");
        headers.add("结论");
        headers.add("意见");
        List<ExcelColData> herderCols = new ArrayList<>();
        for (int i = 0; i < headers.size(); i++) {
            ExcelColData header1 = new ExcelColData();
            header1.setMergeCell(false);
            header1.setBold(true);
            header1.setValue(headers.get(i));
            header1.setFontSize(16);
            header1.setTextLocation(EnumTextLocation.middle);
            header1.setColIndex(i);
            herderCols.add(header1);
        }
        ExcelRowData excelRow1 = new ExcelRowData();
        excelRow1.setColDataList(herderCols);
        excelRow1.setRowIndex(0);
        rows.add(excelRow1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<ExcelColData> dataCols = new ArrayList<>();
        int count = 0;
        for (TbtskDispatchInfo tb : tbs) {
            count++;
            ExcelColData data1 = new ExcelColData();
            data1.setMergeCell(false);
            data1.setBold(false);
            data1.setValue(tb.getTbbh());
            data1.setFontSize(16);
            data1.setTextLocation(EnumTextLocation.middle);
            data1.setColIndex(0);
            dataCols.add(data1);

            ExcelColData data2 = new ExcelColData();
            data2.setMergeCell(false);
            data2.setBold(false);
            data2.setValue(tb.getRegionName());
            data2.setFontSize(16);
            data2.setTextLocation(EnumTextLocation.middle);
            data2.setColIndex(1);
            dataCols.add(data2);

            ExcelColData data3 = new ExcelColData();
            data3.setMergeCell(false);
            data3.setBold(false);
            data3.setValue(tb.getTbmj().toString());
            data3.setFontSize(16);
            data3.setTextLocation(EnumTextLocation.middle);
            data3.setColIndex(2);
            dataCols.add(data3);

            ExcelColData data4 = new ExcelColData();
            data4.setMergeCell(false);
            data4.setBold(false);
            data4.setValue(tb.getDispatch().equals(1) ? "已调度" : "未调度");
            data4.setFontSize(16);
            data4.setTextLocation(EnumTextLocation.middle);
            data4.setColIndex(3);
            dataCols.add(data4);

            ExcelColData data5 = new ExcelColData();
            data5.setMergeCell(false);
            data5.setBold(false);
            data5.setValue(tb.getUserName());
            data5.setFontSize(16);
            data5.setTextLocation(EnumTextLocation.middle);
            data5.setColIndex(4);
            dataCols.add(data5);

            ExcelColData data6 = new ExcelColData();
            data6.setMergeCell(false);
            data6.setBold(false);
            data6.setValue(tb.getPhone());
            data6.setFontSize(16);
            data6.setTextLocation(EnumTextLocation.middle);
            data6.setColIndex(5);
            dataCols.add(data6);

            ExcelColData data7 = new ExcelColData();
            data7.setMergeCell(false);
            data7.setBold(false);
            data7.setValue(tb.getTime() != null ? df.format(tb.getTime()) : "");
            data7.setFontSize(16);
            data7.setTextLocation(EnumTextLocation.middle);
            data7.setColIndex(6);
            dataCols.add(data7);

            ExcelColData data8 = new ExcelColData();
            data8.setMergeCell(false);
            data8.setBold(false);
            data8.setValue(tb.getJl());
            data8.setFontSize(16);
            data8.setTextLocation(EnumTextLocation.middle);
            data8.setColIndex(7);
            dataCols.add(data8);

            ExcelColData data9 = new ExcelColData();
            data9.setMergeCell(false);
            data9.setBold(false);
            data9.setValue(tb.getYj());
            data9.setFontSize(16);
            data9.setTextLocation(EnumTextLocation.middle);
            data9.setColIndex(8);
            dataCols.add(data9);

            ExcelRowData dataRow = new ExcelRowData();
            dataRow.setColDataList(dataCols);
            dataRow.setRowIndex(count);
            rows.add(dataRow);
        }
        ExcelUtil.write(excelSheet, rows);

        FileOutputStream os = null;
        File file = null;
        try {
            file = new File(report);
            os = new FileOutputStream(file);
            excelWorkBook.write(os);

        } catch (Exception ex) {
            logger.error("保存excel到本地异常" + ExceptionUtil.getErrorString(ex));
            return null;
        } finally {
            if (os != null) {
                os.close();
            }
            if (excelWorkBook != null) {
                excelWorkBook.close();
            }
        }
        return file;
    }

    private File exportDispatchShp(TbtskDispatchRecord record,String rootFolder) throws Exception {
        List<Map<String,Object>>maps = jdbcTemplate.queryForList("select f_tbbh,f_regioncode,f_regionname,f_tbmj,f_dispatch,f_username,f_phone,f_time,f_jl,f_yj,st_astext(f_shape) as f_shape from tbtsk_dispatch_info where f_dispatch_id ='"+record.getId()+"' order by f_tbbh");
        if(maps==null||maps.isEmpty())
        {
            throw new Exception("调度任务不存在调度图斑");
        }
        List<String>shpFields = new ArrayList<>();
        shpFields.add("f_id");
        shpFields.add("f_tbbh");
        shpFields.add("f_regioncode");
        shpFields.add("f_regionname");
        shpFields.add("f_tbmj");
        shpFields.add("f_dispatch");
        shpFields.add("f_username");
        shpFields.add("f_phone");
        shpFields.add("f_time");
        shpFields.add("f_jl");
        shpFields.add("f_yj");

        File shpFolder = new File(rootFolder);
        if(!shpFolder.exists())
        {
            shpFolder.mkdir();
        }
        String shpPath = rootFolder+File.separator + record.getId()+".shp";

        ShpObject shpObject = ShpUtil.createShape(shpPath, "GB2312", "MultiPolygon", "f_shape", shpFields);

        try {
            ShpUtil.appendShape(shpObject, "f_shape", maps, shpFields, 100, new Consumer<Integer>() {
                @Override
                public void accept(Integer integer) {

                }
            });
        }
        catch (Exception ex)
        {
            logger.error("导出调度任务图斑shp异常"+ExceptionUtil.getErrorString(ex));
            return null;
        }
        finally {
            if(shpObject!=null) {
                ShpUtil.dispose(shpObject);
            }
        }

        return new File(shpPath);
    }

    private File exportDispatchDb(TbtskDispatchRecord record,String rootFolder) throws Exception {
        List<Map<String,Object>>maps = jdbcTemplate.queryForList("select f_tbbh,f_regioncode,f_regionname,f_tbmj,f_dispatch,f_username,f_phone,f_time,st_astext(f_shape) as f_shape from tbtsk_dispatch_info where f_dispatch_id ='"+record.getId()+"' order by f_tbbh");
        if(maps==null||maps.isEmpty())
        {
            throw new Exception("调度任务不存在调度图斑");
        }
        List<String>fields = new ArrayList<>();
        fields.add("f_tbbh");
        fields.add("f_regioncode");
        fields.add("f_regionname");
        fields.add("f_tbmj");
        fields.add("f_dispatch");
        fields.add("f_username");
        fields.add("f_phone");
        fields.add("f_time");
        fields.add("f_jl");
        fields.add("f_yj");
        fields.add("f_shape");
        SqlliteConnTool sqlliteConnTool = new SqlliteConnTool();
        String createTaskSql = "create table dispatch_task(f_id varchar(36),f_name varchar(255),f_time varchar(255),f_userid varchar(255))";
        String createTbSql="create table dispatch_tb(f_tbbh varchar(36),f_regionname varchar(255),f_tbmj varchar(255),f_dispatch varchar(255),f_phone varchar(255),f_username varchar(255),f_time varchar(255),f_jl varchar(255),f_yj varchar(255),f_shape text)";
        sqlliteConnTool.doSql(createTaskSql);
        sqlliteConnTool.doSql(createTbSql);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String insertSql=String.format("insert into dispatch_task(f_id,f_name,f_time,f_userid) values ('%s','%s','%s','%s')",record.getId(),record.getName(),df.format(record.getTime()),record.getUserId());
        sqlliteConnTool.doSql(insertSql);
        List<String>sqls = new ArrayList<>();
        for(Map map:maps)
        {
            String tbbh = map.get("f_tbbh")!=null?map.get("f_tbbh").toString():"";
            String regionname = map.get("f_regionname")!=null?map.get("f_regionname").toString():"";
            String tbmj = map.get("f_tbmj")!=null?map.get("f_tbmj").toString():"";
            String dispatch = map.get("f_dispatch")!=null?map.get("f_dispatch").toString():"";
            String phone = map.get("f_phone")!=null?map.get("f_phone").toString():"";
            String username = map.get("f_username")!=null?map.get("f_username").toString():"";
            String time = map.get("f_time")!=null?map.get("f_time").toString():"";
            String jl = map.get("f_jl")!=null?map.get("f_jl").toString():"";
            String yj = map.get("f_yj")!=null?map.get("f_yj").toString():"";
            String shape = map.get("f_shape").toString();
            sqls.add(String.format("insert into dispatch_tb(f_tbbh,f_regionname,f_tbmj,f_dispatch,f_phone,f_username,f_time,f_jl,f_yj,f_shape) values('%s','%s','%s','%s','%s','%s','%s','%s','%s','%s')",tbbh,regionname,tbmj,dispatch,phone,username,time,jl,yj,shape));
        }
        sqlliteConnTool.doSql(StringUtils.join(sqls,";"));
        String filePath = rootFolder+File.separator+record.getId()+"_"+System.currentTimeMillis()+".db";
        store(sqlliteConnTool,filePath);
        return new File(filePath);
    }

    private void exportDispatchAtt(TbtskDispatchRecord record,String rootFolder)
    {
        String sql = String.format("select * from tbtsk_dispatch_attach where f_info_id in (select f_id from tbtsk_dispatch_info where f_dispatch_id ='%s')",record.getId());
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
            return;
       Map<String,List<Map<String,Object>>>groupMaps =  maps.stream().collect(Collectors.groupingBy(t->t.get("f_info_id").toString()));
       for(Map.Entry<String,List<Map<String,Object>>> kv:groupMaps.entrySet())
       {
           File folder = new File(rootFolder+File.separator+kv.getKey());
           folder.mkdir();
           for(Map map:kv.getValue())
           {
               String url = map.get("f_url").toString();
               try {
                   String tempUrl = temporarySignedUrlService.getTemporarySignedUrl(null, url, null);
                   String[] paths = url.split("/");
                   String fileName = paths[paths.length - 1]; // 保存的文件名称

                   if (fileName.indexOf("?") > -1) {
                       fileName = fileName.substring(0, fileName.indexOf("?"));
                   }
                   File lsFile = new File(folder, fileName);
                   FileUtils.copyURLToFile(new URL(tempUrl), lsFile);
               }
               catch (Exception ex)
               {
                   logger.error("下载附件:"+url+"失败"+ExceptionUtil.getErrorString(ex));
               }
           }
       }
    }
    private File exportDispatchShpToImport(String rootFolder,List<String>ids) throws Exception {
        List<Map<String,Object>>maps = jdbcTemplate.queryForList("select f_id,f_regioncode as f_zldwdm ,f_regionname as f_zldwmc,f_tbmj,'' as f_dlmc,'' as f_dlbm,st_astext(f_shape) as the_geom from tbtsk_dispatch_info where f_id in('"+StringUtils.join(ids,"','")+"') order by f_tbbh");
        if(maps==null||maps.isEmpty())
        {
            throw new Exception("调度任务不存在调度图斑");
        }
        List<String>shpFields = new ArrayList<>();
        shpFields.add("f_id");

        shpFields.add("f_zldwdm");
        shpFields.add("f_zldwmc");
        shpFields.add("f_tbmj");
        shpFields.add("f_dlmc");
        shpFields.add("f_dlbm");
        File shpFolder = new File(rootFolder);
        if(!shpFolder.exists())
        {
            shpFolder.mkdir();
        }
        String shpPath = rootFolder+File.separator +System.currentTimeMillis()+".shp";

        ShpObject shpObject = ShpUtil.createShape(shpPath, "GBK", "MultiPolygon", "the_geom", shpFields);

        try {
            ShpUtil.appendShape(shpObject, "the_geom", maps, shpFields, 100, new Consumer<Integer>() {
                @Override
                public void accept(Integer integer) {

                }
            });
        }
        catch (Exception ex)
        {
            logger.error("导出调度任务图斑shp异常"+ExceptionUtil.getErrorString(ex));
            return null;
        }
        finally {
            if(shpObject!=null) {
                ShpUtil.dispose(shpObject);
            }
        }

        return new File(shpPath);
    }

    private void getDronJpg(String jobId,String taskTbId,String taskId,String dispatchId)
    {
        logger.info("开始获取无人机调度照片 jobId:"+jobId+" dispatchId:"+dispatchId);
        String sevice = String.format(fcUrl+"/fczx-server/api/files/v1/wayline/job/%s",jobId);
        Map<String, String> headers = new HashMap<>();
        headers.put("X-Auth-Token", X_Auth_Token);
        int count =0;
        JSONArray result = null;

        while (count<4) {
            count++;
            try {
                Thread.sleep(20000);
            }
            catch (Exception ex)
            {

            }
            HttpResponse response = HttpUtil.createGet(sevice).addHeaders(headers).execute();
            if (response.isOk()) {
                String body = response.body();
                if (!StringUtils.isBlank(body)) {
                    result = JSONArray.parseArray(body);
                    if (result == null || result.isEmpty()) {
                        logger.warn("无人机调度照片获取返回空 jobId:" + jobId);
                    }
                    else
                    {
                         break;
                    }

                }
                else {
                    logger.warn("无人机调度照片获取失败 jobId:" + jobId);

                }

            }
            else
            {
                logger.warn("无人机调度照片获取失败 jobId:" + jobId + " " + response.body());

            }


        }
        if(result==null)
        {
            logger.error("无人机调度照片获取返回空 jobId:" + jobId);
            return;
        }
        logger.info("获取无人机调度照片 jobId:"+jobId+" dispatchId:"+dispatchId+" size:"+result.size());
        sevice = String.format(fcUrl+"/fczx-server/api/files/v1/original");
        for(int i=0;i<result.size();i++)
        {

            String fileName = result.getJSONObject(i).getString("fileName");
            String objectKey = result.getJSONObject(i).getString("objectKey");
            String createTime =String.valueOf(System.currentTimeMillis()); //result.getJSONObject(i).getString("createTime");
            logger.info("无人机调度照片开始获取流文件 objectKey:"+objectKey);
            String url = sevice+"?objectKey="+objectKey;
            HttpResponse response = HttpUtil.createGet(url).addHeaders(headers).execute();
            if(!response.isOk())
            {
                logger.error("无人机调度照片获取流文件失败 objectKey:"+objectKey);
                continue;
            }

            InputStream is = response.bodyStream();
            String objName="zhhd/"+dispatchId+"/dron/"+fileName;
            String obsUrl = defaultOssOperatorService.sendObject2Oss(objName,is);
            try {
                is.close();
            }
            catch (Exception e)
            {}
            AppMedia appMedia = new AppMedia();
            appMedia.setGalleryid(dispatchId);
            if(StringUtils.isNotBlank(taskTbId))
            {
                appMedia.setGalleryid(taskTbId);
            }
            appMedia.setServerpath(obsUrl);
            appMedia.setBizId(taskId);
            if(StringUtils.isBlank(taskId))
            {
                appMedia.setBizId("zhdd_shp_draw");
            }
            appMedia.setTime(createTime);
            appMedia.setCreateTime(createTime);
            appMedia.setId(UUID.randomUUID().toString());
            appMediaDao.gwAccess(appMedia);
            logger.info("转存无人机调度照片 jobId:"+jobId+" dispatchId:"+dispatchId+" fileName:"+fileName);
        }




    }
    private   Boolean store(SqlliteConnTool connection, String destination) throws SQLException {
        Statement statement = null;
        try{

            statement =   connection.getConnection().createStatement();
            statement.executeUpdate("backup to '" + destination+"'" );
            return true;
        }
        catch (Exception ex)
        {
            logger.error("保存内存db到:"+destination+"异常",ex);
            return false;
        }
        finally {
            if (statement != null) {
                statement.close();
            }

        }
    }
    public List<File> getFileByType(File file, String type, List<File> list) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; i++) {
            File file1 = files[i];
            if (file1.isDirectory()) {
                list = getFileByType(file1, type, list);
            } else {
                String name = file1.getName();
                if (name.endsWith(type)) {
                    list.add(file1);
                }
            }
        }
        return list;
    }


    /**
     * 读取shp信息
     *
     * @param shpFilePath 需要传给转换方法的.shp路径
     * @return
     */
    public List<TbtskDispatchTbTemp> shpInfoList(List<String> shpFilePath,String userId) throws Exception {
        List<TbtskDispatchTbTemp>dispatchInfos = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = sdf.format(new Date());
        int count = 0;
        //Map<Integer,CoordinateReferenceSystem>mapCoor = new HashMap<>();
        java.text.DecimalFormat df = new java.text.DecimalFormat("#.00");
        for (int i = 0; i < shpFilePath.size(); i++) {
            //遍历shp集合
            ShapefileDataStore shpDataStore = buildDataStore(shpFilePath.get(i));
            shpDataStore.setCharset(Charset.forName("GBK"));
            CoordinateReferenceSystem crs = shpDataStore.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem();
            if (crs == null) {
                throw new Exception("shp空间参考未定义");
            } else {
                String wkt = crs.toWKT();
                if(wkt.contains("PROJCS"))
                {
                    throw new Exception("shp空间参考错误,要求CGCS2000地理坐标");
                }
                if(wkt.contains("SPHEROID"))
                {
                    wkt = wkt.substring(wkt.indexOf("SPHEROID"));
                    wkt = wkt.substring(0,wkt.indexOf("]"));
                    wkt=wkt.replace("SPHEROID[","");
                    wkt=wkt.replace("]","");
                    String [] info = StringUtils.split(wkt,",");
                    if(info.length!=3)
                    {
                        throw new Exception("shp空间参考错误,要求CGCS2000地理坐标");
                    }
                    String SPHEROID = info[0];
                    SPHEROID = SPHEROID.trim();
                    SPHEROID = SPHEROID.replace("\"","");
                    SPHEROID = SPHEROID.trim();
                    if(!SPHEROID.equals("CGCS2000"))
                    {
                        throw new Exception("shp空间参考错误,要求CGCS2000地理坐标");
                    }
                }
                else
                {
                    throw new Exception("shp空间参考错误,要求CGCS2000地理坐标");
                }


            }

            FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
            org.geotools.data.Query query = new org.geotools.data.Query();
            int tbcount=0;
            try {
                tbcount = featureSource.getCount(query);
            } catch (Exception ex) {
                logger.error("shp文件计算图斑数量异常:" + shpFilePath.get(i) + ExceptionUtil.getErrorString(ex));
            }
            if(tbcount==0)
            {
                throw new RuntimeException("shp文件图斑数量为0");
            }
            Map<String, String> mapFields = null;
            try {
                mapFields = ShpUtil.getShpToTableColumns(shpDataStore);
            } catch (Exception ex) {
                logger.error("shp字段获取异常:" +  shpFilePath.get(i) + ExceptionUtil.getErrorString(ex));
                throw new RuntimeException("shp字段获取异常" );
            }
            List<String>fields = mapFields.keySet().stream().collect(Collectors.toList());
            fields.removeIf(t->t.toLowerCase().startsWith("shape_"));
            FeatureCollection<SimpleFeatureType, SimpleFeature> collection = null;
            try {
                collection = featureSource.getFeatures();
            }
            catch (Exception ex)
            {
                logger.error("shp获取要素集合异常:"+shpFilePath.get(i)+ ExceptionUtil.getErrorString(ex));
                throw new RuntimeException("shp获取要素集合异常");
            }
            FeatureIterator<SimpleFeature> itertor = collection.features();
            SimpleFeature sf = null;

            while (itertor.hasNext()) {
                sf = itertor.next();
                Geometry geo = (Geometry) sf.getDefaultGeometry();
                if (geo == null) {
                    throw new RuntimeException("shp图形为空");
                }
                if (!geo.getGeometryType().toLowerCase().equals("polygon") && !geo.getGeometryType().toLowerCase().equals("multipolygon")) {
                    throw new RuntimeException("shp不是面图形");
                }
                int num = GeometryTrasnUtil.getProjNum(geo);
                /*
                CoordinateReferenceSystem coordinateReferenceSystem = null;
                if(!mapCoor.containsKey(num))
                {
                    coordinateReferenceSystem = GeometryTrasnUtil.getCgcsPrjCoordinateReferenceSystem(num);
                    mapCoor.put(num,coordinateReferenceSystem);
                }
                else
                {
                    coordinateReferenceSystem = mapCoor.get(num);
                }
                Geometry prjGeo = GeometryTrasnUtil.transCgcs2000ToPrj(geo,coordinateReferenceSystem);
                double area = prjGeo.getArea();
                */
                Map<String, Object> tb = ShpUtil.getFromSimpleFeatureWithoutShape(sf, fields);
                TbtskDispatchTbTemp info = new TbtskDispatchTbTemp();
                info.setId(UUID.randomUUID().toString().replace("-",""));
                info.setUserId(userId);

                info.setSource(EnumDispatchSource.shp.getCode());
                //info.setDispatch(0);
                //info.setRegionCode();
                //info.setRegionName();
                //info.setTbmj(Double.parseDouble(df.format(area)));

                info.setTbInfo(JSONObject.toJSONString(tb));
                HashMap<String, Object> map = getXzqdmSys(geo.getCentroid(), WKTUtil.geomToWkt(geo), num);
                if (map != null) {
                    info.setRegionCode(map.get("xzqdmsys").toString());
                    info.setRegionName(map.get("location").toString());
                    info.setTbmj(Double.parseDouble(df.format(Double.parseDouble(map.get("area").toString()))));
                }  else
                {
                    throw new Exception("绘制范围不在规定区域内");
                }
                count++;
                String xh =String.valueOf(count);
                if(count<9999)
                {
                    xh =StringUtils.leftPad(xh,4,"0");
                }

                info.setTbbh("TBSC"+date+xh);
                info.setShape("SRID=4490;"+WKTUtil.geomToWkt(geo));
                dispatchInfos.add(info);
            }
            itertor.close();
            shpDataStore.dispose();
        }
        return dispatchInfos;
    }

    /**
     * 构建ShapeDataStore对象。
     *
     * @param shpFilePath shape文件路径。
     * @return
     */
    public static ShapefileDataStore buildDataStore(String shpFilePath) {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        try {
            ShapefileDataStore dataStore = (ShapefileDataStore) factory
                    .createDataStore(new File(shpFilePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(Charset.forName("GB2312"));
            }
            return dataStore;
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HashMap<String,Object> getXzqdmSys(Geometry pt,String wkt,int proNum) throws SQLException {
        HashMap<String, Object> map = new HashMap<>();
        try {

            String sql = "select * from ((select f_xzqdm as xzqdm,f_xzqmc as xzqmc,3 as level from tb_region where st_contains(shape, st_geomfromtext('" + wkt + "',4490)) and f_level =3  limit 1)\n" +
                    "union\n" +
                    "(select xzqdm,xzqmc,4 as level from tb_region_town where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)\n" +
                    "union\n" +
                    "(select xzqdm,xzqmc,5 as level from tb_region_village where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)) as q order by q.level";

            List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);

            Map<String, Object> region = null;
            Map<String, Object> regionTown = null;
            Map<String, Object> regionVillage = null;

            for(int i=0;i<maps.size();i++){
                Object xzqdm = maps.get(i).get("xzqdm");
                if(xzqdm==null)continue;

                if(xzqdm.toString().length()==12){
                    regionVillage = maps.get(i);
                }
                else if(xzqdm.toString().length()==9){
                    regionTown = maps.get(i);
                }
                else if(xzqdm.toString().length()==6){
                    region = maps.get(i);
                }
            }

            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage!=null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown!=null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region!=null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }

            String areasql = "select util_computearea(ST_GeomFromText('" + wkt + "',4490)) as area";
            Map<String, Object> areaMap = jdbcTemplate.queryForMap(areasql);
            String area = areaMap.get("area").toString();
            map.put("area",area);
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e){
            throw new SQLException(e.getMessage());
        }

        return map;
    }
    private HashMap<String,Object> getXzqdmSys(String villageCode) throws SQLException {
        HashMap<String, Object> map = new HashMap<>();
        String townCode = villageCode.substring(0,9);
        String countyCode = villageCode.substring(0,6);
        try {
           String sql = "select f_xzqmc,f_xzqdm from tb_region where f_xzqdm ='"+countyCode+"'\n"+
                        "union\n"+
                        "select xzqmc as f_xzqmc,xzqdm as f_xzqdm from tb_region_town where f_xzqdm ='"+townCode+"'\n"+
                        "union\n"+
                        "select xzqmc as f_xzqmc,xzqdm as f_xzqdm from tb_region_village where f_xzqdm ='"+villageCode+"'";

            List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);

            Map<String, Object> region = null;
            Map<String, Object> regionTown = null;
            Map<String, Object> regionVillage = null;

            for(int i=0;i<maps.size();i++){
                Object xzqdm = maps.get(i).get("xzqdm");
                if(xzqdm==null)continue;

                if(xzqdm.toString().length()==12){
                    regionVillage = maps.get(i);
                }
                else if(xzqdm.toString().length()==9){
                    regionTown = maps.get(i);
                }
                else if(xzqdm.toString().length()==6){
                    region = maps.get(i);
                }
            }

            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage!=null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown!=null && regionTown.get("xzqdm") != null) {
                if (StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region!=null && region.get("xzqdm") != null) {
                if (StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e){
            throw new SQLException(e.getMessage());
        }

        return map;
    }


    private JSONObject getVideoRealtimeUrl(JSONObject param) {
        String path = "/VIDEO-APPLY-API/devices/{deviceCode}/channels/{channelCode}/getVideoRealtimeUrl";
        String deviceCode = param.getString("deviceCode");
        String channelCode = param.getString("channelCode");
        String streamUuid = UUID.randomUUID().toString();
        String plugId = "";
        String streamType = param.getString("streamType");
        String protocolType = param.getString("protocolType");
        String netType = param.getString("netType");
        if (com.meizu.push.sdk.utils.StringUtils.isBlank(netType)) {
            netType = "1";
        }
        path = replacePath(path, deviceCode, channelCode);

        Map<String, String> headers = GetSignUtils.getHeaders(path);
        headers.put("X-StreamUuid", streamUuid);
        headers.put("X-PlugId", plugId);

        JSONObject body = new JSONObject();
        body.put("streamType", streamType);
        body.put("protocolType", protocolType);
        body.put("netType", netType);
        JSONObject result = null;
        HttpResponse response = HttpUtil.createPost(getUrl(path)).body(body.toJSONString()).addHeaders(headers).execute();
        if(response.isOk())
        {
            result = JSONObject.parseObject(response.body());
        }
        response.close();
        return (JSONObject) dealResult(result);
    }
    private Object dealResult(JSONObject object) {
        Object result = null;
        if (object != null) {
            if ((object.containsKey("returnCode") && "8888".equals(object.getString("returnCode"))) || (object.containsKey("code") && !"200".equals(object.getString("code")))) {
                if(object.containsKey("returnCode")) {
                    throw new RuntimeException(object.getString("errorMsg"));
                }else if(object.containsKey("code")){
                    throw new RuntimeException(object.getString("msg"));
                }
            } else {
                if (object.getString("data") != null && object.getString("data").startsWith("{")) {
                    return object.getJSONObject("data");
                } else if (object.getString("data") != null && object.getString("data").startsWith("[")) {
                    return object.getJSONArray("data");
                }
                result = object.getString("data");
            }
        }
        return result;
    }
    private String replacePath(String path, String deviceCode, String channelCode) {
        path = path.replace("{deviceCode}", "%s");
        path = path.replace("{channelCode}", "%s");
        path = String.format(path, deviceCode, channelCode);
        return path;
    }

    private String getUrl(String path) {
        SysConfig one = sysConfigService.findOne(SERVICE_PATH);
        return one.getValue() + path;
    }


    private static Map<String,OssConfig>mapOssConfig = new HashMap<>();

    private List<AppMediaDTO> getMedia(String tbid)
    {
        List<AppMedia> appMedias =  appMedias = appMediaDao.queryALLByGid(tbid);


        List<AppMediaDTO> result = new ArrayList<>();
        List<AppMediaDTO> ja = new ArrayList<>();
        for (int i = 0; i < appMedias.size(); i++) {
            AppMediaDTO newMedia = new AppMediaDTO();
            BeanUtil.copyProperties(appMedias.get(i), newMedia);
            if(StringUtils.isBlank(newMedia.getServerpath())&&StringUtils.isNotBlank(newMedia.getDownloadUrl()))
            {
                newMedia.setServerpath(newMedia.getDownloadUrl());
            }
            if (newMedia.getServerpath() != null) {
                if(StringUtils.isBlank(newMedia.getFromSource())) {
                    //获取文件名
                    String url = newMedia.getServerpath();
                    if (url.contains("?")) {
                        url = StringUtils.split(url, "?")[0];
                    }
                    String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                    newMedia.setFileName(fiename);
                    //获取文件授权有效期
                    url = temporarySignedUrlService.getTemporarySignedUrl("", url, null);
                    if (GutilStr.isNotBlank(url)) {
                        newMedia.setServerpath(url);
                    }
                }
                else
                {
                    String from = newMedia.getFromSource();
                    if(from.startsWith(importOtherDataService.getMediaSourcePrefix()))
                    {
                        //金奥的
                        ja.add(newMedia);
                        continue;
                    }
                    else {
                        OssConfig ossConfig = null;
                        if (mapOssConfig.containsKey(from)) {
                            ossConfig = mapOssConfig.get(from);
                        } else {
                            ossConfig = ossConfigRepository.queryBySource(from);
                            mapOssConfig.put(from, ossConfig);
                        }

                        if (ossConfig != null) {
                            String url = newMedia.getServerpath();
                            if (url.contains("?")) {
                                url = StringUtils.split(url, "?")[0];
                            }
                            String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                            newMedia.setFileName(fiename);
                            url = temporarySignedUrlService.getTemporarySignedUrl(ossConfig.getServerId().toString(), url, null);
                            if (GutilStr.isNotBlank(url)) {
                                newMedia.setServerpath(url);
                            }
                        }
                    }
                }
            }



            result.add(newMedia);
        }
        if(!ja.isEmpty()) {
            try {
                List<String> urls = ja.stream().map(AppMediaDTO::getServerpath).distinct().collect(Collectors.toList());
                urls = importOtherDataService.getTempUrl(urls);
                if(urls!=null)
                {
                    for(String url:urls)
                    {
                        List<AppMediaDTO> temps =  ja.stream().filter(t-> url.startsWith(t.getServerpath())).collect(Collectors.toList());
                        if(temps!=null&&!temps.isEmpty())
                        {
                            for (AppMediaDTO temp : temps) {
                                temp.setServerpath(url);
                            }

                        }
                    }
                }
            }
            catch (Exception ex)
            {
                logger.error("JA获取临时对象存储路径失败",ex);
            }
            result.addAll(ja);
        }
        /*
        for(AppMediaDTO appMediaDTO:result)
        {
            if (GutilStr.isNotBlank(appMediaDTO.getUsername())) {
                String userRealName = userNameService.getUserRealNameByUserName(appMediaDTO.getUsername());
                if (GutilStr.isNotBlank(userRealName)) {
                    appMediaDTO.setUsername(userRealName);
                }
            } else {
                appMediaDTO.setUsername("未记录");
            }
        }
        */
        return result;
    }

    private String uploadFile(String downloadUrl, String objectName) throws IOException {
        //
        URL url = new URL(downloadUrl);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        // 设置超时间为3秒
        conn.setConnectTimeout(3 * 1000);
        // 防止屏蔽程序抓取而返回403错误
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");

        // 得到输入流
        InputStream inputStream = conn.getInputStream();
        String uploadUrl = defaultOssOperatorService.sendObject2Oss(objectName, inputStream);
        inputStream.close();
        conn.disconnect();
        return uploadUrl;
    }
}
