package com.geoway.landteam.landcloud.service.zhjgapprove;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.service.task.AuditJobService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.dao.zhjgapprove.ZhjgApproveAtlasTaskDao;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveConfig;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveDataDto;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveShowField;
import com.geoway.landteam.landcloud.model.zhjgapprove.dto.ZhjgApproveShowFieldValue;
import com.geoway.landteam.landcloud.model.zhjgapprove.enm.ZhjgapproveStateEnum;
import com.geoway.landteam.landcloud.model.zhjgapprove.entity.ZhjgApproveAtlasTask;
import com.geoway.landteam.landcloud.servface.zhjgapprove.MZhjgApproveAtlasService;
import com.geoway.landteam.landcloud.service.autoapprove.MAutoApproveServiceImpl;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.*;

@Service
public class ZhjgApproveAtlasServiceImpl implements MZhjgApproveAtlasService {

    private final GiLoger logger = GwLoger.getLoger(MAutoApproveServiceImpl.class);
    @Autowired
    SysConfigRepository sysConfigRepository;

    @Resource
    TskTaskBizRepository tskTaskBizRepository;

    @Resource
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Resource
    ZhjgApproveAtlasTaskDao zhjgApproveAtlasTaskDao;

    @Resource
    AuditJobService auditJobService;

    @Resource
    JdbcTemplate jdbcTemplate;

    String param;

    final String ZHJC_APPROVE_RESULT="tb_zhjg_approve_result";
    @Override
    public void startAtlas() throws Exception {
        ZhjgApproveConfig config = getConfig();
        if(config==null)
            return;
        if(StringUtils.isBlank(config.getServiceUrl()))
        {
            logger.error("atlas自动审核错误,审核模型服务地址为空");
            return;
        }
        if(StringUtils.isBlank(config.getAtlasUrl()))
        {
            logger.error("atlas自动审核错误,atlas服务地址为空");
            return;
        }
        if(config.getDatas()==null||config.getDatas().isEmpty())
            return;
        for(ZhjgApproveDataDto data:config.getDatas())
        {
            if(StringUtils.isBlank(data.getId())||StringUtils.isBlank(data.getName()))
            {
                logger.error("atlas自动审核错误,任务数据id或表名为空");
                continue;
            }
            Optional<TskTaskBiz>task = tskTaskBizRepository.findById(data.getId());
            if(!task.isPresent())
            {
                logger.error("atlas自动审核错误,任务数据:"+data.getId()+"不存在");
                continue;
            }
            TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.get().getTableId());
            if(objectinfo==null)
            {
                logger.error("atlas自动审核错误,任务数据:"+data.getId()+"不存在");
                continue;
            }
            String id = UUID.randomUUID().toString();
            String resultTable = "temp_zhjg_"+ id.replace("-","");
            ZhjgApproveAtlasTask zhjgApproveAtlasTask = new ZhjgApproveAtlasTask();
            zhjgApproveAtlasTask.setId(id);
            zhjgApproveAtlasTask.setTaskId(data.getId());
            zhjgApproveAtlasTask.setResult(resultTable);
            zhjgApproveAtlasTask.setCreateTime(new Date());
            zhjgApproveAtlasTask.setStatus(ZhjgapproveStateEnum.create.getCode().shortValue());
            String filter = "f_status >=10";
            String db = getDB();
            if (StringUtils.isBlank(param)) {
                param = getTemplate();
            }
            String curParam = param;
            Map<String,String> mapParam = new HashMap<>();
            mapParam.put("{source}",db+"/"+objectinfo.getfTablename());
            mapParam.put("{sourceId}",data.getId());
            mapParam.put("{sourceFilter}",filter);
            mapParam.put("{result}",db+"/"+resultTable);

            for(Map.Entry<String,String>kv:mapParam.entrySet())
            {
                curParam = curParam.replace(kv.getKey(), kv.getValue());
            }


            logger.info("zhjgapprove service url:" + config.getServiceUrl() + " param:" + curParam);
            String result = HttpUtil.createPost(config.getServiceUrl()).body(curParam).execute().body();
            logger.info("zhjgapprove service url:" + config.getServiceUrl() + " http result: " + result);
            if (StringUtils.isBlank(result)) {
                zhjgApproveAtlasTask.setStatus(ZhjgapproveStateEnum.error.getCode().shortValue());
                zhjgApproveAtlasTask.setMsg("通过分析服务创建分析任务失败");
                zhjgApproveAtlasTask.setEndTime(new Date());
            }
            else {
                JSONObject resultJson = JSONObject.parseObject(result);
                if (resultJson.containsKey("code") && resultJson.getString("code").equals("200")) {
                    String taskId = resultJson.getJSONObject("data").getString("taskId");
                    if (StringUtils.isNotBlank(taskId)) {
                        zhjgApproveAtlasTask.setAtlasId(taskId);
                        zhjgApproveAtlasTask.setStatus(ZhjgapproveStateEnum.runing.getCode().shortValue());
                    } else {
                        zhjgApproveAtlasTask.setStatus(ZhjgapproveStateEnum.error.getCode().shortValue());
                        zhjgApproveAtlasTask.setMsg("通过分析服务创建分析任务失败");
                        zhjgApproveAtlasTask.setEndTime(new Date());
                    }
                } else {
                    zhjgApproveAtlasTask.setStatus(ZhjgapproveStateEnum.error.getCode().shortValue());
                    zhjgApproveAtlasTask.setMsg("通过分析服务创建分析任务失败");
                    zhjgApproveAtlasTask.setEndTime(new Date());
                }
            }
            zhjgApproveAtlasTaskDao.gwAccess(zhjgApproveAtlasTask);
        }
    }

    @Override
    public List<ZhjgApproveAtlasTask> list(Short state)
    {
        ZhjgApproveAtlasTask search = new ZhjgApproveAtlasTask();
        search.setStatus(state);
        return zhjgApproveAtlasTaskDao.gwSearch(search);
    }


    @Override
    public void progressQuery(ZhjgApproveAtlasTask task) {
        ZhjgApproveConfig config = getConfig();
        if(config==null)
            return;
        if(StringUtils.isBlank(config.getAtlasUrl()))
        {
            logger.error("atlas自动审核错误进度查询失败,atlas服务地址为空");
            return;
        }
        String atlasUrl = config.getAtlasUrl();
        atlasUrl = atlasUrl + "/atlas/task/get?id=" + task.getAtlasId();
        logger.info("cffx atlas task url:"+atlasUrl);
        String result = HttpUtil.createGet(atlasUrl).execute().body();
        if (StringUtils.isBlank(result)) {
            task.setMsg("获取分析任务进度信息失败");
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
            logger.error("综合监管批量审核:" + task.getId() + "获取分析任务进度信息失败");
            return;
        }
        JSONObject resultJson = JSONObject.parseObject(result);
        String state = "";
        Boolean flag = false;
        if (!resultJson.containsKey("State") || !resultJson.containsKey("IsSucceed")) {
            logger.error("综合监管批量审核:" + task.getId() + "分析任务暂未完成");
            return;
        }
        state = resultJson.getString("State");
        flag = resultJson.getBoolean("IsSucceed");
        if (!state.equalsIgnoreCase("finished")) {
            logger.error("综合监管批量审核:" + task.getId() + "分析任务暂未完成");
            return;
        }
        if (!flag) {
            task.setMsg("分析任务执行失败");
            task.setStatus(ZhjgapproveStateEnum.error.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
            logger.error("综合监管批量审核:" + task.getId() + "分析任务执行失败");
        }
        else {
            task.setMsg("分析任务执行成功");
            task.setStatus(ZhjgapproveStateEnum.success.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
        }
    }

    @Override
    public void startApprove(ZhjgApproveAtlasTask task) {
        ZhjgApproveConfig config = getConfig();
        if(StringUtils.isBlank(config.getTbidField()))
        {
            task.setMsg("参数配置错误，未配置图斑id字段");
            task.setStatus(ZhjgapproveStateEnum.approveerror.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
        }
        if(StringUtils.isBlank(config.getTaskidField()))
        {
            task.setMsg("参数配置错误，未配置任务id字段");
            task.setStatus(ZhjgapproveStateEnum.approveerror.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
        }
        if(config.getShowFields()==null||config.getShowFields().isEmpty())
        {
            task.setMsg("参数配置错误，未配置分析结果信息字段");
            task.setStatus(ZhjgapproveStateEnum.approveerror.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
        }
        if(StringUtils.isBlank(config.getApproveUser())||config.getUserId()==null)
        {
            task.setMsg("参数配置错误，未配置审核用户信息");
            task.setStatus(ZhjgapproveStateEnum.approveerror.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
        }
        try {
            handResult(config, task.getResult(), task.getTaskId());
            approve(config, task.getResult(), task.getTaskId());
            task.setMsg("");
            task.setStatus(ZhjgapproveStateEnum.approvesuccess.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);

        }
        catch (Exception ex)
        {
            logger.error("综合监管批量审核异常"+ ExceptionUtil.getStackTrace(ex));
            task.setMsg("综合监管批量审核异常"+ex.getMessage());
            task.setStatus(ZhjgapproveStateEnum.approveerror.getCode().shortValue());
            zhjgApproveAtlasTaskDao.gwUpdateByPK(task);
        }
        finally {
            TableUtil.dropTable(task.getResult(),jdbcTemplate);
        }
    }

    @Override
    public List<List<ZhjgApproveShowFieldValue>> getDetial(String taskId,String tbid)
    {
        ZhjgApproveConfig config =  getConfig();
        if(config.getDatas()!=null&&config.getDatas().isEmpty())
            return null;
        if(config.getDatas().stream().filter(t->t.getId().equals(taskId)).findFirst().isPresent())
        {
            List<ZhjgApproveShowField>showFields = config.getShowFields();
            if(showFields==null||showFields.isEmpty())
                return null;
            String sql = "select * from "+ ZHJC_APPROVE_RESULT+" where "+config.getTaskidField()+" = '"+taskId+"' and "+config.getTbidField()+" ='"+tbid+"'";
            List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
            if(maps==null||maps.isEmpty())
                return null;
            List<List<ZhjgApproveShowFieldValue>>results = new ArrayList<>();

            for(Map map:maps)
            {
                List<ZhjgApproveShowFieldValue> values = new ArrayList<>();
                for(ZhjgApproveShowField f:showFields)
                {
                    if(map.containsKey(f.getName()))
                    {
                        String value = map.get(f.getName())==null?"":map.get(f.getName()).toString();
                        ZhjgApproveShowFieldValue v = new ZhjgApproveShowFieldValue();
                        v.setAlias(f.getAlias());
                        v.setName(f.getName());
                        v.setValue(value);
                        values.add(v);
                    }

                }
                results.add(values);
            }
            return results;
        }
        return null;
    }

    private void handResult(ZhjgApproveConfig config ,String tempResultTable,String taskid)
    {
        if(!TableUtil.tableExist(ZHJC_APPROVE_RESULT,jdbcTemplate))
        {
            String createSql = "create table "+ ZHJC_APPROVE_RESULT+" ("+config.getTbidField()+" varchar(100) NOT NULL,"+config.getTaskidField()+" varchar(100) NOT NULL,"+config.getPassField()+" varchar(100) NOT NULL";
            if(config.getShowFields()!=null&&!config.getShowFields().isEmpty())
            {
                for (ZhjgApproveShowField f:config.getShowFields()) {
                    createSql+=","+f.getName()+" varchar(100)";
                }
            }
            createSql+=");CREATE INDEX "+ZHJC_APPROVE_RESULT+"_union_idx ON public."+ZHJC_APPROVE_RESULT+" USING btree ("+config.getTbidField()+","+config.getTaskidField()+");";
            jdbcTemplate.execute(createSql);
        }
        String deleteSql = String.format("delete from %s where %s in (select %s from %s t) and %s = '%s'",ZHJC_APPROVE_RESULT,config.getTbidField(),config.getTbidField(),tempResultTable,config.getTaskidField(),taskid);
        jdbcTemplate.execute(deleteSql);

        String insertSql = "insert into "+ZHJC_APPROVE_RESULT+"("+config.getTbidField()+","+config.getTaskidField()+","+config.getPassField();
        if(config.getShowFields()!=null&&!config.getShowFields().isEmpty())
        {
            for (ZhjgApproveShowField f:config.getShowFields()) {
                insertSql+=","+f.getName();
            }
        }
        insertSql+=") select "+config.getTbidField()+","+config.getTaskidField()+","+config.getPassField();
        if(config.getShowFields()!=null&&!config.getShowFields().isEmpty())
        {
            for (ZhjgApproveShowField f:config.getShowFields()) {
                insertSql+=","+f.getName();
            }
        }
        insertSql+=" from "+ tempResultTable;
        jdbcTemplate.execute(insertSql);
    }
    private void approve(ZhjgApproveConfig config,String tempResultTable,String taskId)
    {

            Integer option = 0;
            if (config.getIsPass() != null && config.getIsPass()) {
                option = 1;
            }
            String autoApproveFilter = config.getApproveFilter();
            if (StringUtils.isBlank(autoApproveFilter)) {
                autoApproveFilter = "1=1";
            }
            String filter = "f_id in (select " + config.getTbidField() + " from " + tempResultTable + " where " + autoApproveFilter + ")";
            auditJobService.batchApproveSj(taskId, filter, option, "自动批量审核通过", "自动批量审核通过", config.getUserId(), config.getApproveUser());

    }
    private ZhjgApproveConfig getConfig()
    {
        SysConfig config = this.sysConfigRepository.queryByKey("zhjgApproveConfig");
        ZhjgApproveConfig zhjgApproveConfig = null;
        if (config != null) {
            zhjgApproveConfig = JSONObject.parseObject(config.getValue(), ZhjgApproveConfig.class);

        }
        return zhjgApproveConfig;
    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/zhjgapprove.json");
            BufferedReader reader = new BufferedReader(
                    new InputStreamReader(is,
                            StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result += s;
            }
            return result;
        } catch (Exception ex) {
            logger.error("读取常规监测预警模型失败", ex);
            return null;
        }

    }


    private String getDB() {
        DataSource dataSource = jdbcTemplate.getDataSource();
        com.alibaba.druid.pool.DruidDataSource druidDataSource = (com.alibaba.druid.pool.DruidDataSource) dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split(url, "?");
        url = urls[0];// StringUtils.replace(urls[0], "jdbc:", "");
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;//.replace("49.4.81.80","192.168.1.233");
    }
}
