/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.autoapprove;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.model.autoapprove.dto.AutoApproveConfig;
import com.geoway.landteam.landcloud.model.autoapprove.dto.AutoApproveDetailConfig;
import com.geoway.landteam.landcloud.model.autoapprove.dto.AutoApproveRule;
import com.geoway.landteam.landcloud.servface.autoapprove.MAutoApproveService;
import com.geoway.landteam.landcloud.servface.customtask.thirdData.WpzfService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MAutoApproveServiceImpl
implements MAutoApproveService {
    private final GiLoger logger = GwLoger.getLoger(MAutoApproveServiceImpl.class);
    final String sysConfigKey = "autoApproveConfig";
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SysConfigRepository sysConfigRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;
    @Autowired
    LandUserService landUserService;
    @Autowired
    WpzfService wpzfService;

    public AutoApproveConfig getConfig() {
        SysConfig config = this.sysConfigRepository.queryByKey("autoApproveConfig");
        AutoApproveConfig autoApproveConfig = null;
        if (config != null) {
            autoApproveConfig = (AutoApproveConfig)JSONObject.parseObject((String)config.getValue(), AutoApproveConfig.class);
        }
        return autoApproveConfig;
    }

    public void autoApprove(String taskId, String tbid) throws Exception {
        String result;
        AutoApproveConfig config = this.getConfig();
        if (config == null) {
            return;
        }
        TbtskObjectinfo objectinfo = this.tskTaskBizService.findTableByTaskId(taskId);
        if (objectinfo == null) {
            throw new Exception("\u5e02\u7ea7\u81ea\u52a8\u5ba1\u6838\u5931\u8d25,\u4efb\u52a1:" + taskId + "\u5bf9\u5e94\u7684TbtskObjectinfo\u4e0d\u5b58\u5728");
        }
        List configs = config.getDetailConfigs();
        Optional<AutoApproveDetailConfig> curConfig = configs.stream().filter(t -> t.getId().equalsIgnoreCase(taskId)).findFirst();
        if (!curConfig.isPresent()) {
            throw new Exception("\u5e02\u7ea7\u81ea\u52a8\u5ba1\u6838\u5931\u8d25,\u4efb\u52a1:" + taskId + "\u5bf9\u5e94\u7684\u5ba1\u6838\u89c4\u5219\u4e3a\u7a7a");
        }
        List rules = curConfig.get().getRules();
        if (rules == null || rules.isEmpty()) {
            throw new Exception("\u5e02\u7ea7\u81ea\u52a8\u5ba1\u6838\u5931\u8d25,\u4efb\u52a1:" + taskId + "\u5bf9\u5e94\u7684\u5ba1\u6838\u89c4\u5219\u4e3a\u7a7a");
        }
        LandUser landUser = this.landUserService.queryUserById(curConfig.get().getUserId());
        if (landUser == null) {
            throw new Exception("\u5e02\u7ea7\u81ea\u52a8\u5ba1\u6838\u7528\u6237:" + curConfig.get().getUserId() + "\u4e0d\u5b58\u5728");
        }
        Object[] objectArray = new Object[]{"f_id", "f_lryj", "f_lrej", objectinfo.getfTablename(), "f_id", tbid};
        String sql = String.format("select %s,%s,%s,util_computearea(f_shape) as area from %s where %s = '%s' ", objectArray);
        Map map = this.jdbcTemplate.queryForMap(sql);
        double area = Double.parseDouble(map.get("area").toString());
        if (area >= curConfig.get().getMinArea()) {
            return;
        }
        boolean noPass = true;
        String id = map.get("f_id").toString();
        String lryj = map.get("f_lryj") == null ? "" : map.get("f_lryj").toString();
        String lrej = map.get("f_lrej") == null ? "" : map.get("f_lrej").toString();
        block10: for (AutoApproveRule rule : rules) {
            if (!noPass) break;
            switch (rule.getId()) {
                case "1": {
                    Map param = rule.getParam();
                    double greateThan = Double.parseDouble((String)param.get("greateThan"));
                    String lryjV = (String)param.get("lryj");
                    String lrejV = (String)param.get("lrej");
                    if (!lryj.equals(lryjV) || !lrej.equals(lrejV) || !(area > greateThan)) continue block10;
                    noPass = false;
                    break;
                }
                case "2": {
                    Map param = rule.getParam();
                    double intersectAreaV = Double.parseDouble((String)param.get("intersectArea"));
                    double intersectRateV = Double.parseDouble((String)param.get("intersectRate"));
                    sql = "with t1 as (select util_computearea(f_shape) as f_area,f_shape from " + objectinfo.getfTablename() + " where f_id = '" + id + "'), \nt2 as (select a.f_area,util_computearea(b.geom) as f_area1,util_computearea(st_intersection(a.f_shape,b.geom)) as f_area2 from t1 a, tb_yzzg b where  st_intersects  ( a.f_shape,b.geom ) = 'true') \nselect sum(f_area1) as f_area1,sum(f_area2) as f_area2 from t2";
                    Map areas = this.jdbcTemplate.queryForMap(sql);
                    if (areas == null || areas.isEmpty() || areas.get("f_area2") == null) continue block10;
                    double intersectArea = Double.parseDouble(areas.get("f_area2").toString());
                    double rate = intersectArea * 100.0 / area;
                    if (!(intersectArea > intersectAreaV) || !(rate > intersectRateV)) continue block10;
                    noPass = false;
                    break;
                }
                case "3": {
                    double intersectArea;
                    Map param = rule.getParam();
                    double intersectAreaV = Double.parseDouble((String)param.get("intersectArea"));
                    sql = "with t1 as (select util_computearea(f_shape) as f_area,f_shape from " + objectinfo.getfTablename() + " where f_id = '" + id + "'), \nt2 as (select a.f_area,util_computearea(b.geom) as f_area1,util_computearea(st_intersection(a.f_shape,b.geom)) as f_area2 from t1 a, ynyzzg b where  st_intersects  ( a.f_shape,b.geom ) = 'true') \nselect sum(f_area1) as f_area1,sum(f_area2) as f_area2 from t2";
                    Map areas = this.jdbcTemplate.queryForMap(sql);
                    if (areas == null || areas.isEmpty() || areas.get("f_area2") == null || !((intersectArea = Double.parseDouble(areas.get("f_area2").toString())) > intersectAreaV)) break;
                    noPass = false;
                }
            }
        }
        if (noPass && (result = this.tbtskFlowService.reject(taskId, tbid, null, curConfig.get().getUserId(), "\u5ba1\u6838\u610f\u89c1\uff0c\u9762\u79ef\u8fc7\u5c0f(\u81ea\u52a8\u5ba1\u6838\u4e0d\u901a\u8fc7)", "\u5ba1\u6838\u610f\u89c1\uff0c\u9762\u79ef\u8fc7\u5c0f(\u81ea\u52a8\u5ba1\u6838\u4e0d\u901a\u8fc7)", landUser.getName(), "\u5e02\u7ea7\u5ba1\u6838", "", null)).startsWith("\u6253\u56de\u6210\u529f")) {
            this.wpzfService.pushWpzfReject(tbid, taskId, landUser.getName(), "\u5ba1\u6838\u610f\u89c1\uff0c\u9762\u79ef\u8fc7\u5c0f(\u81ea\u52a8\u5ba1\u6838\u4e0d\u901a\u8fc7)");
        }
    }
}

