/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.base.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.mq.DataDownloadProducerService;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.service.util.TbbhUtil;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.mapper.pub.DmDictValueMapper;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.base.entity.TaskBasicRelation;
import com.geoway.landteam.landcloud.core.model.pub.dto.BasicIdInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.DmDictValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.AppTaskBizRepository;
import com.geoway.landteam.landcloud.core.repository.base.TaskBasicRelationRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDataDownloadTakeHandService;
import com.geoway.landteam.suishoupai.model.pub.entity.APicShare;
import com.geoway.landteam.suishoupai.repository.pub.APicShareRepository;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
@Transactional(rollbackFor={Exception.class})
public class AppBasicServiceImpl
implements AppBasicService {
    private final GiLoger logger = GwLoger.getLoger(AppBasicServiceImpl.class);
    private static final String TAKE_HAND_TASK_ID = "ssp";
    private static final String TAKE_HAND = "\u968f\u624b\u62cd";
    @Value(value="${obsSignatureUrlService.url:}")
    protected String obsSignUrl;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    protected String innerImgUrl;
    @Value(value="${obsSignatureEnable:false}")
    protected boolean obsSignatureEnable;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Resource
    DmDictValueMapper dictValueDao;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TaskBasicRelationRepository taskBasicRelationRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    AppBasicRepository appBasicRepository;
    @Autowired
    APicShareRepository aPicShareRepository;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    Organization2UserRepository organization2UserDao;
    @Autowired
    MDataDownloadTakeHandService MDataDownloadTakeHandService;
    @Autowired
    AppTaskBizRepository appTaskBizRepository;
    @Autowired
    TbbhUtil tbbhUtil;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    DataDownloadProducerService dataDownloadProducerService;
    @Autowired
    private LandUserService landuserService;
    @Autowired
    private RegionService regionService;
    @Autowired
    UserNameService userNameService;

    public void add(HttpServletRequest request, Long userId, boolean addOrg) throws IOException, SQLException {
        String querysql;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile = multipartRequest.getFile("file");
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        File inputFile = new File(this.uploadDir, filename);
        String fileFullName = inputFile.getAbsolutePath();
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)inputFile);
        Connection connection = null;
        Statement tbbhStatement = null;
        Statement statement = null;
        ResultSet tbbhRs = null;
        Object rs = null;
        SqlliteConnTool connPool = new SqlliteConnTool(fileFullName);
        connection = connPool.getConnection();
        tbbhStatement = connection.createStatement();
        statement = connection.createStatement();
        String tableName = "basic";
        boolean isExists = this.isTableExists(statement, tableName);
        ArrayList<AppBasic> basics = new ArrayList<AppBasic>();
        if (isExists) {
            querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            while (tbbhRs.next()) {
                AppBasic basic;
                Object objvillage;
                Object objvillage2;
                Object objvillage3;
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = objId.toString();
                }
                String name = "";
                Object objName = tbbhRs.getObject("f_name");
                if (objName != null && !objName.equals("")) {
                    name = objName.toString();
                }
                String createtime = "";
                Date time = new Date();
                Object objCreatetime = tbbhRs.getObject("f_createtime");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                    time = new Date(Long.parseLong(createtime));
                }
                String type = "";
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }
                String desc = "";
                Object objDesc = tbbhRs.getObject("f_desc");
                if (objDesc != null && !objDesc.equals("")) {
                    desc = objDesc.toString();
                }
                String shape = "";
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }
                String cloudId = null;
                Object objCloudId = tbbhRs.getObject("f_cloudId");
                if (objCloudId != null && !objCloudId.equals("")) {
                    cloudId = objCloudId.toString();
                }
                String vipCloudId = null;
                Object objvCloudId = tbbhRs.getObject("f_vipCloudId");
                if (objvCloudId != null && !objvCloudId.equals("")) {
                    vipCloudId = objvCloudId.toString();
                }
                Integer isCollect = null;
                if (this.isColumnExist(tbbhRs, "f_iscollect")) {
                    Object objIsCollect = tbbhRs.getObject("f_iscollect");
                    isCollect = objIsCollect == null ? null : Integer.valueOf(Integer.parseInt(objIsCollect.toString()));
                }
                String heading = null;
                if (this.isColumnExist(tbbhRs, "f_heading") && (objvillage3 = tbbhRs.getObject("f_heading")) != null && !objvillage3.equals("")) {
                    heading = objvillage3.toString();
                }
                Double lon = null;
                if (this.isColumnExist(tbbhRs, "f_lon") && (objvillage2 = tbbhRs.getObject("f_lon")) != null && !objvillage2.equals("")) {
                    lon = Double.parseDouble(objvillage2.toString());
                }
                Double lat = null;
                if (this.isColumnExist(tbbhRs, "f_lat") && (objvillage = tbbhRs.getObject("f_lat")) != null && !objvillage.equals("")) {
                    lat = Double.parseDouble(objvillage.toString());
                }
                if ((basic = (AppBasic)this.appBasicRepository.findById((Object)id).orElse(null)) == null) {
                    basic = new AppBasic();
                    basic.setId(id);
                }
                basic.setName(name);
                basic.setCreatetime(createtime);
                basic.setTime(new Date());
                basic.setType(type);
                basic.setDesc(desc);
                basic.setShape(shape);
                basic.setUserid(userId + "");
                basic.setUsername(this.landuserService.queryUserById(userId).getName());
                basic.setCloudId(cloudId);
                basic.setVipCloudId(vipCloudId);
                basic.setHeading(heading);
                basic.setIsDeleted(Integer.valueOf(0));
                basic.setIsCollect(Integer.valueOf(0));
                basic.setLon(lon);
                basic.setLat(lat);
                if (lon != null && lat != null) {
                    try {
                        String wkt = "POINT(" + lon + " " + lat + ")";
                        RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
                        if (region == null) {
                            region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
                        }
                        if (region != null) {
                            String county = "";
                            String city = "";
                            String province = "";
                            if (region.getLevel() == 3) {
                                county = region.getCode();
                                city = region.getPcode();
                                province = this.regionService.findRegionByCode(city).getPcode();
                            } else if (region.getLevel() == 2) {
                                city = region.getCode();
                                province = region.getPcode();
                            }
                            RegionVillage village = this.regionService.queryVillageCotain(wkt, 0);
                            basic.setProvince(province);
                            basic.setCity(city);
                            basic.setCounty(county);
                            basic.setVilliage(village != null ? village.getCode() : "");
                        }
                    }
                    catch (Exception wkt) {
                        // empty catch block
                    }
                }
                basics.add(basic);
            }
            this.appBasicRepository.saveAll(basics);
        }
        if (isExists = this.isTableExists(statement, tableName = "media")) {
            querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            ArrayList<AppMedia> medias = new ArrayList<AppMedia>();
            while (tbbhRs.next()) {
                AppMedia media = new AppMedia();
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = objId.toString();
                }
                String galleyid = "";
                Object objGalleyid = tbbhRs.getObject("f_galleryid");
                if (objGalleyid != null && !objGalleyid.equals("")) {
                    galleyid = objGalleyid.toString();
                }
                String type = "0";
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }
                String createtime = "";
                Object objCreatetime = tbbhRs.getObject("f_time");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                }
                String lon = "";
                Object objLon = tbbhRs.getObject("f_lon");
                if (objLon != null && !objLon.equals("")) {
                    lon = objLon.toString();
                }
                String lat = "";
                Object objLat = tbbhRs.getObject("f_lat");
                if (objLat != null && !objLat.equals("")) {
                    lat = objLat.toString();
                }
                String athmus = "";
                Object objAthmus = tbbhRs.getObject("f_azimuth");
                if (objAthmus != null && !objAthmus.equals("")) {
                    athmus = objAthmus.toString();
                }
                String pitch = "";
                Object objPitch = tbbhRs.getObject("f_pitch");
                if (objPitch != null && !objPitch.equals("")) {
                    pitch = objPitch.toString();
                }
                String shape = "";
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }
                String vedioRecord = "";
                Object objVedioRecord = tbbhRs.getObject("f_videorecord");
                if (objVedioRecord != null && !objVedioRecord.equals("")) {
                    vedioRecord = objVedioRecord.toString();
                }
                String serverpath = "";
                Object objServerpath = tbbhRs.getObject("f_serverpath");
                if (objServerpath != null && !objServerpath.equals("")) {
                    if (objServerpath.toString().startsWith("http")) {
                        serverpath = objServerpath.toString();
                    } else {
                        this.innerImgUrl = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
                        serverpath = this.innerImgUrl + objServerpath.toString();
                    }
                }
                String mediatimelength = "0";
                Object objMediatimelength = tbbhRs.getObject("f_mediatimelength");
                if (objMediatimelength != null && !objMediatimelength.equals("")) {
                    mediatimelength = objMediatimelength.toString();
                }
                String mediasize = "0";
                Object objMediasize = tbbhRs.getObject("f_mediasize");
                if (objMediasize != null && !objMediasize.equals("")) {
                    mediasize = objMediasize.toString();
                }
                media.setId(id);
                media.setGalleryid(galleyid);
                media.setType(Integer.valueOf(type));
                if (StringUtils.isNotBlank((CharSequence)createtime)) {
                    Long timeLong = null;
                    try {
                        timeLong = Long.valueOf(createtime);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(createtime);
                            timeLong = date.getTime();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (timeLong != null) {
                        media.setTime(String.valueOf(timeLong));
                    }
                }
                media.setLon(Double.valueOf(lon));
                media.setLat(Double.valueOf(lat));
                media.setAzimuth(athmus);
                media.setPitch(pitch);
                media.setShape(shape);
                media.setVideorecord(vedioRecord);
                media.setServerpath(serverpath);
                media.setMediatimelength(Integer.valueOf(mediatimelength));
                media.setMediasize(Double.valueOf(mediasize));
                medias.add(media);
            }
            this.appMediaRepository.saveAll(medias);
        }
        if (!addOrg || !basics.isEmpty()) {
            // empty if block
        }
    }

    public void addOfRestructure(HttpServletRequest request, Long userId, boolean addOrg) throws Exception {
        boolean appMediaTableExists;
        MultipartFile fileOfDB = ((MultipartHttpServletRequest)request).getFile("file");
        File tempUploadFile = this.buildTempUploadFile();
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        boolean appBasicTableExists = this.isTableExists(statement, "basic");
        if (appBasicTableExists) {
            this.saveAppBasicData(statement, userId, "");
        }
        if (appMediaTableExists = this.isTableExists(statement, "media")) {
            this.saveAppMediaData(statement, new ArrayList<BasicIdInfo>(), userId, false);
        }
        this.closeStream(statement, connection);
    }

    private void closeStream(Statement statement, Connection connection) throws Exception {
        if (statement != null) {
            statement.close();
            statement = null;
        }
        if (connection != null) {
            connection.close();
            connection = null;
        }
    }

    public List<BasicIdInfo> add2OfRestructure(HttpServletRequest request, Long userId, boolean addSelf) throws Exception {
        boolean appMediaTableExists;
        String organizationId = this.checkOrgIdOfUser(userId);
        MultipartFile fileOfDB = ((MultipartHttpServletRequest)request).getFile("file");
        File tempUploadFile = this.buildTempUploadFile();
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        boolean appBasicTableExists = this.isTableExists(statement, "basic");
        ArrayList<BasicIdInfo> basicIdInfos = new ArrayList();
        if (appBasicTableExists) {
            basicIdInfos = this.saveAppBasicData2(statement, userId, organizationId);
        }
        if (appMediaTableExists = this.isTableExists(statement, "media")) {
            this.saveAppMediaData(statement, basicIdInfos, userId, true);
        }
        this.closeStream(statement, connection);
        return basicIdInfos;
    }

    public List<BasicIdInfo> add2OfRestructureBySc(HttpServletRequest request, Long userId, boolean addSelf, String source) throws Exception {
        boolean appMediaTableExists;
        String organizationId = this.checkOrgIdOfUser(userId);
        MultipartFile fileOfDB = ((MultipartHttpServletRequest)request).getFile("file");
        File tempUploadFile = this.buildTempUploadFile();
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        boolean appBasicTableExists = this.isTableExists(statement, "basic");
        ArrayList<BasicIdInfo> basicIdInfos = new ArrayList();
        if (appBasicTableExists) {
            basicIdInfos = this.saveAppBasicDataBySc(statement, userId, organizationId, source);
        }
        if (appMediaTableExists = this.isTableExists(statement, "media")) {
            this.saveAppMediaData(statement, basicIdInfos, userId, true);
        }
        this.closeStream(statement, connection);
        return basicIdInfos;
    }

    private File buildTempUploadFile() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        String fileName = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(this.uploadDir, fileName);
    }

    private List<BasicIdInfo> saveAppBasicData(Statement statement, Long userId, String organizationId) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from basic");
        ArrayList<AppBasic> appBasics = new ArrayList<AppBasic>();
        ArrayList<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();
        while (resultSet.next()) {
            String id = resultSet.getString("f_id");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5df2\u635f\u574f");
            }
            AppBasic basic = null;
            if (StringUtils.isBlank((CharSequence)organizationId)) {
                basic = this.appBasicRepository.findById((Object)id).orElse(null);
                if (basic == null) {
                    basic = new AppBasic();
                    basic.setId(id);
                }
            } else {
                basic = new AppBasic();
                basic.setId(UUID.randomUUID().toString());
            }
            basic.setName(resultSet.getString("f_name"));
            basic.setCreatetime(resultSet.getString("f_createtime"));
            basic.setTime(new Date());
            basic.setType(resultSet.getString("f_type"));
            basic.setDesc(resultSet.getString("f_desc"));
            basic.setShape(resultSet.getString("f_shape"));
            basic.setUsername(this.landuserService.queryUserById(userId).getName());
            basic.setCloudId(resultSet.getString("f_cloudId"));
            basic.setVipCloudId(resultSet.getString("f_vipCloudId"));
            basic.setHeading(resultSet.getString("f_heading"));
            basic.setIsDeleted(Integer.valueOf(0));
            basic.setIsCollect(Integer.valueOf(resultSet.getInt("f_iscollect")));
            basic.setLon(Double.valueOf(resultSet.getDouble("f_lon")));
            basic.setLat(Double.valueOf(resultSet.getDouble("f_lat")));
            basic.setOri(resultSet.getString("f_gallery_type"));
            basic.setMyCloudId(resultSet.getString("f_webCloudId"));
            basic.setMj(Double.valueOf(resultSet.getDouble("f_mj")));
            try {
                basic.setRequestId(resultSet.getString("f_requestid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank((CharSequence)organizationId)) {
                basic.setUserid(userId.toString());
            } else {
                basic.setUserid(organizationId);
                basic.setShareUser(userId);
                basic.setShareId(id);
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            }
            this.completeBasicRegionInfo(basic);
            appBasics.add(basic);
        }
        this.appBasicRepository.saveAll(appBasics);
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
        return idInfos;
    }

    private List<BasicIdInfo> saveAppBasicData2(Statement statement, Long userId, String organizationId) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from basic");
        ArrayList<AppBasic> appBasics = new ArrayList<AppBasic>();
        ArrayList<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();
        while (resultSet.next()) {
            BasicIdInfo basicIdInfo;
            String id = resultSet.getString("f_id");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5df2\u635f\u574f");
            }
            AppBasic basic = null;
            basic = new AppBasic();
            basic.setId(UUID.randomUUID().toString());
            basic.setName(resultSet.getString("f_name"));
            basic.setCreatetime(resultSet.getString("f_createtime"));
            basic.setTime(new Date());
            basic.setType(resultSet.getString("f_type"));
            basic.setDesc(resultSet.getString("f_desc"));
            basic.setShape(resultSet.getString("f_shape"));
            basic.setUsername(this.landuserService.queryUserById(userId).getName());
            basic.setHeading(resultSet.getString("f_heading"));
            basic.setIsDeleted(Integer.valueOf(0));
            basic.setLon(Double.valueOf(resultSet.getDouble("f_lon")));
            basic.setLat(Double.valueOf(resultSet.getDouble("f_lat")));
            basic.setOri(resultSet.getString("f_gallery_type"));
            try {
                basic.setRequestId(resultSet.getString("f_requestid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            basic.setMj(Double.valueOf(resultSet.getDouble("f_mj")));
            String fromId = resultSet.getString("f_fromId");
            String oriType = resultSet.getString("oriType");
            String oriId = resultSet.getString("oriId");
            String tbbh = resultSet.getString("f_tbbh");
            String type = resultSet.getString("f_gallery_type");
            if ("909".equalsIgnoreCase(type)) {
                basic.setUserid(organizationId);
                basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("908".equalsIgnoreCase(type)) {
                if ("1".equalsIgnoreCase(oriType)) {
                    basic.setUserid(oriId);
                } else if ("2".equalsIgnoreCase(oriType)) {
                    basic.setUserid(oriId);
                }
                basic.setShareId(fromId);
                basic.setUserid(oriId);
                basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("907".equalsIgnoreCase(type)) {
                basic.setUserid(organizationId);
                basic.setShareUser(userId);
                basic.setShareId(id);
                basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            }
            this.completeBasicRegionInfo(basic);
            appBasics.add(basic);
        }
        this.appBasicRepository.saveAll(appBasics);
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
        return idInfos;
    }

    private List<BasicIdInfo> saveAppBasicDataBySc(Statement statement, Long userId, String organizationId, String source) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from basic");
        ArrayList<AppBasic> appBasics = new ArrayList<AppBasic>();
        ArrayList<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();
        while (resultSet.next()) {
            BasicIdInfo basicIdInfo;
            String id = resultSet.getString("f_id");
            if (StringUtils.isBlank((CharSequence)id)) {
                throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5df2\u635f\u574f");
            }
            AppBasic basic = null;
            basic = new AppBasic();
            basic.setId(id);
            basic.setName(resultSet.getString("f_name"));
            basic.setCreatetime(resultSet.getString("f_createtime"));
            basic.setTime(new Date());
            basic.setType(resultSet.getString("f_type"));
            basic.setDesc(resultSet.getString("f_desc"));
            basic.setShape(resultSet.getString("f_shape"));
            basic.setUsername(this.landuserService.queryUserById(userId).getName());
            basic.setCloudId(resultSet.getString("f_cloudId"));
            basic.setVipCloudId(resultSet.getString("f_vipCloudId"));
            basic.setMyCloudId(resultSet.getString("f_webCloudId"));
            basic.setHeading(resultSet.getString("f_heading"));
            basic.setIsDeleted(Integer.valueOf(0));
            basic.setIsCollect(Integer.valueOf(resultSet.getInt("f_iscollect")));
            basic.setLon(Double.valueOf(resultSet.getDouble("f_lon")));
            basic.setLat(Double.valueOf(resultSet.getDouble("f_lat")));
            basic.setOri(resultSet.getString("f_gallery_type"));
            try {
                basic.setRequestId(resultSet.getString("f_requestid"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            basic.setMj(Double.valueOf(resultSet.getDouble("f_mj")));
            String fromId = resultSet.getString("f_fromId");
            String oriType = resultSet.getString("oriType");
            String oriId = resultSet.getString("oriId");
            String tbbh = resultSet.getString("f_tbbh");
            String type = resultSet.getString("f_gallery_type");
            if ("909".equalsIgnoreCase(type)) {
                basic.setUserid(organizationId);
                basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("908".equalsIgnoreCase(type)) {
                if ("1".equalsIgnoreCase(oriType)) {
                    basic.setUserid(oriId);
                } else if ("2".equalsIgnoreCase(oriType)) {
                    basic.setUserid(oriId);
                }
                basic.setShareId(fromId);
                basic.setUserid(oriId);
                basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            } else if ("907".equalsIgnoreCase(type)) {
                basic.setUserid(organizationId);
                basic.setShareUser(userId);
                basic.setShareId(id);
                basicIdInfo = new BasicIdInfo();
                basicIdInfo.setOldId(id);
                basicIdInfo.setNewId(basic.getId());
                idInfos.add(basicIdInfo);
            }
            this.completeBasicRegionInfo(basic);
            appBasics.add(basic);
        }
        if (source != null && source.equalsIgnoreCase("sc")) {
            this.addTaskBasicInfo(appBasics, userId);
        }
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
        return idInfos;
    }

    private void addTaskBasicInfo(List<AppBasic> appBasics, Long userId) {
        SysConfig sysConfig = this.sysConfigService.findOne("scgtyBizId");
        TskTaskBiz tskTaskBiz = this.tskTaskBizRepository.findById((Object)sysConfig.getValue()).orElse(null);
        TbtskObjectinfo tableInfo = this.tbtskObjectinfoRepository.findById((Object)tskTaskBiz.getTableId()).orElse(null);
        List tbtskFieldsByTableid = this.tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
        List<String> collect = tbtskFieldsByTableid.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        List dmDictValues = this.dictValueDao.queryTop(Long.valueOf(10048L));
        ArrayList<HashMap<String, Object>> addDataCacheList = new ArrayList<HashMap<String, Object>>();
        ArrayList<TaskBasicRelation> taskBasicRelations = new ArrayList<TaskBasicRelation>();
        for (AppBasic appBasic : appBasics) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            TaskBasicRelation taskBasicRelation = new TaskBasicRelation();
            map.put("f_id", UUID.randomUUID().toString());
            map.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
            map.put("f_review_stage", ReviewStageEnum.COUNTY_VERIFY.getCode());
            map.put("f_lon", appBasic.getLon());
            map.put("f_lat", appBasic.getLat());
            map.put("f_createtime", System.currentTimeMillis() + "");
            map.put("f_committime", System.currentTimeMillis() + "");
            map.put("f_userid", userId.toString());
            map.put("f_upload_userid", userId.toString());
            map.put("f_submit_userid", userId.toString());
            map.put("f_ismy", "0");
            map.put("f_xzqdmsys", appBasic.getVilliage() != null ? appBasic.getVilliage() : appBasic.getCounty());
            map.put("f_xzqdm", appBasic.getCounty());
            map.put("f_tbmc", appBasic.getHeading());
            map.put("f_tbmj", appBasic.getMj());
            map.put("f_shape", appBasic.getShape());
            map.put("f_shape1", appBasic.getShape());
            this.fillRequiredFieldNames(map, collect, appBasic, userId, dmDictValues);
            addDataCacheList.add(map);
            taskBasicRelation.setDataId(map.get("f_id").toString());
            taskBasicRelation.setUserId(userId.toString());
            taskBasicRelation.setCreateDate(new Date());
            taskBasicRelation.setBasicId(appBasic.getId());
            taskBasicRelation.setBizId(this.sysConfigService.findOne("scgtyBizId").getValue());
            taskBasicRelations.add(taskBasicRelation);
            this.taskBasicRelationRepository.save((Object)taskBasicRelation);
        }
        this.dataBizService.insertDatasBatchByTimeStamp(tableInfo.getfTablename(), addDataCacheList, "f_shape");
        this.taskBasicRelationRepository.saveAll(taskBasicRelations);
    }

    private void fillRequiredFieldNames(Map<String, Object> map, List<String> collect, AppBasic appBasic, Long userId, List<DmDictValue> dmDictValues) {
        String type;
        if (collect.contains("f_xsmc")) {
            map.put("f_xsmc", appBasic.getHeading());
        }
        if (collect.contains("f_xsbh")) {
            String xsbh = this.tbbhUtil.generateTbbh(appBasic.getVilliage() != null ? appBasic.getVilliage() : appBasic.getCounty(), "TB", this.tbbhUtil.getUserLevelCode(userId));
            map.put("f_xsbh", xsbh);
            map.put("f_tbbh", xsbh);
        }
        if (collect.contains("f_xzqmc_n1")) {
            map.put("f_xzqmc_n1", this.regionService.getName(appBasic.getCounty()));
        }
        if (collect.contains("f_xsms")) {
            map.put("f_xsms", appBasic.getDesc());
        }
        if (collect.contains("f_wfdd")) {
            map.put("f_wfdd", appBasic.getName());
        }
        if (collect.contains("f_jbsj")) {
            map.put("f_jbsj", new Timestamp(System.currentTimeMillis()));
        }
        if (collect.contains("f_yswflx")) {
            type = appBasic.getType();
            for (DmDictValue dmDictValue : dmDictValues) {
                if (!dmDictValue.getName().equalsIgnoreCase(appBasic.getType())) continue;
                type = dmDictValue.getCode();
            }
            map.put("f_yswflx", type);
        }
        if (collect.contains("f_wflx")) {
            type = appBasic.getType();
            for (DmDictValue dmDictValue : dmDictValues) {
                if (!dmDictValue.getName().equalsIgnoreCase(appBasic.getType())) continue;
                type = dmDictValue.getCode();
            }
            map.put("f_wflx", type);
        }
        if (collect.contains("f_jbr")) {
            map.put("f_jbr", appBasic.getUsername());
        }
    }

    private String generateTbbh(String xzqdm, String type) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)xzqdm)) {
            String sql = "select land_quality_grade_num_getnextvalue('" + xzqdm + "','1','1') ";
            Object obj = this.jdbcTemplate.queryForObject(sql, Object.class);
            int numInt = 0;
            if (obj != null) {
                try {
                    numInt = Integer.parseInt(obj.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String num = "";
            num = numInt <= 9999 ? String.format("%04d", numInt) : String.valueOf(numInt);
            result = xzqdm + type.toUpperCase() + num;
        }
        return result;
    }

    public String getXzqmcByPont(String taskId, double dLon, double dLat) {
        String wkt = "POINT(" + dLon + " " + dLat + ")";
        JSONObject data = new JSONObject();
        String name = "";
        String code = "";
        TskTaskBiz biz = this.tskTaskBizRepository.findById((Object)taskId).orElse(null);
        try {
            if (biz.getGranularity() != null && biz.getGranularity() == 5) {
                RegionVillage village = null;
                village = this.regionService.queryVillageCotain(wkt, 0);
                if (village != null) {
                    name = village.getName();
                    code = village.getCode();
                    String xianName = this.regionService.getName(code.substring(0, 6));
                    String xiangName = this.regionService.getName(code.substring(0, 9));
                    name = xianName + xiangName + name;
                }
            } else if (biz.getGranularity() != null && biz.getGranularity() == 4) {
                Geometry geometry = WKTUtil.wktToGeom((String)wkt);
                RegionTown regionTown = this.regionService.queryRegionTownCotain(geometry);
                if (regionTown != null) {
                    name = regionTown.getName();
                    code = regionTown.getCode();
                    String xianName = this.regionService.getName(code.substring(0, 6));
                    name = xianName + name;
                }
            } else if (biz.getGranularity() != null) {
                RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
                if (region == null) {
                    region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
                }
                if (region == null) {
                    region = this.regionService.queryRegionByGeom(wkt, 4490, 2, 2000.0);
                }
                if (region != null) {
                    name = region.getName();
                    code = region.getCode();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    private void completeBasicRegionInfo(AppBasic basic) throws Exception {
        if (basic.getLon() == null || basic.getLat() == null) {
            return;
        }
        String wkt = "POINT(" + basic.getLon() + " " + basic.getLat() + ")";
        RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
        if (region == null) {
            region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
        }
        if (region == null) {
            return;
        }
        String county = "";
        String city = "";
        String province = "";
        if (region.getLevel() == 3) {
            county = region.getCode();
            city = region.getPcode();
            province = this.regionService.findRegionByCode(city).getPcode();
        } else if (region.getLevel() == 2) {
            city = region.getCode();
            province = region.getPcode();
        }
        RegionVillage village = this.regionService.queryVillageCotain(wkt, 0);
        basic.setProvince(province);
        basic.setCity(city);
        basic.setCounty(county);
        basic.setVilliage(village != null ? village.getCode() : "");
    }

    private void saveAppMediaData(Statement statement, List<BasicIdInfo> basicIdInfos, Long userId, boolean saveOfOrg) throws Exception {
        ResultSet resultSet = statement.executeQuery("select * from media");
        ArrayList<AppMedia> appMedias = new ArrayList<AppMedia>();
        while (resultSet.next()) {
            String oldId = resultSet.getString("f_id");
            if (StringUtils.isBlank((CharSequence)oldId)) {
                throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u5df2\u635f\u574f");
            }
            AppMedia media = this.appMediaRepository.findById((Object)oldId).orElse(null);
            media = media == null ? new AppMedia() : media;
            String oldGalleryid = resultSet.getString("f_galleryid");
            if (!saveOfOrg) {
                media.setId(oldId);
                media.setGalleryid(oldGalleryid);
            } else {
                media = new AppMedia();
                media.setId(UUID.randomUUID().toString());
                for (BasicIdInfo info : basicIdInfos) {
                    if (!StringUtils.isNotBlank((CharSequence)oldGalleryid) || !oldGalleryid.equals(info.getOldId())) continue;
                    media.setGalleryid(info.getNewId());
                    break;
                }
                if (StringUtils.isBlank((CharSequence)media.getGalleryid())) {
                    throw new RuntimeException("\u4e0a\u4f20\u6587\u4ef6\u6570\u636e\u6709\u8bef");
                }
            }
            media.setType(Integer.valueOf(resultSet.getInt("f_type")));
            String time = resultSet.getString("f_time");
            if (StringUtils.isNotBlank((CharSequence)time)) {
                Long timeLong = null;
                try {
                    timeLong = Long.valueOf(time);
                }
                catch (NumberFormatException e) {
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                        timeLong = date.getTime();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (timeLong != null) {
                    media.setTime(String.valueOf(timeLong));
                }
            }
            media.setLon(Double.valueOf(resultSet.getDouble("f_lon")));
            media.setLat(Double.valueOf(resultSet.getDouble("f_lat")));
            media.setAzimuth(resultSet.getString("f_azimuth"));
            media.setPitch(resultSet.getString("f_pitch"));
            media.setShape(resultSet.getString("f_shape"));
            media.setVideorecord(resultSet.getString("f_videorecord"));
            String serverPath = resultSet.getString("f_serverpath");
            if (StringUtils.isNotBlank((CharSequence)serverPath) && !serverPath.startsWith("http://")) {
                this.innerImgUrl = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
                serverPath = this.innerImgUrl + serverPath;
            }
            media.setServerpath(serverPath);
            media.setMediatimelength(Integer.valueOf(resultSet.getInt("f_mediatimelength")));
            media.setMediasize(Double.valueOf(resultSet.getDouble("f_mediasize")));
            media.setMark(Integer.valueOf(resultSet.getObject("f_mark") == null ? 0 : resultSet.getInt("f_mark")));
            media.setTypetype(Integer.valueOf(resultSet.getObject("f_typetype") == null ? 0 : resultSet.getInt("f_typetype")));
            media.setUsername(this.landuserService.queryUserById(userId).getName());
            appMedias.add(media);
        }
        this.appMediaRepository.saveAll(appMedias);
        if (resultSet != null) {
            resultSet.close();
            resultSet = null;
        }
    }

    private String checkOrgIdOfUser(Long userId) {
        List organization2Users = this.organization2UserDao.queryByUserId(userId);
        if (organization2Users.isEmpty()) {
            throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0c\u65e0\u6302\u63a5\u7684\u5355\u4f4d");
        }
        return ((Organization2User)organization2Users.get(0)).getOrganizationId();
    }

    public List<BasicIdInfo> add2(HttpServletRequest request, Long userId, boolean addSelf) throws IOException, SQLException {
        String querysql;
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        MultipartFile multipartFile = multipartRequest.getFile("file");
        this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String filename = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        File inputFile = new File(this.uploadDir, filename);
        String fileFullName = inputFile.getAbsolutePath();
        FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)inputFile);
        List organization2Users = this.organization2UserDao.queryByUserId(userId);
        if (organization2Users.isEmpty()) {
            throw new RuntimeException("\u7528\u6237\u4fe1\u606f\u9519\u8bef\uff0c\u65e0\u6302\u63a5\u7684\u5355\u4f4d");
        }
        String organizationId = ((Organization2User)organization2Users.get(0)).getOrganizationId();
        Connection connection = null;
        Statement tbbhStatement = null;
        Statement statement = null;
        ResultSet tbbhRs = null;
        Object rs = null;
        SqlliteConnTool connPool = new SqlliteConnTool(fileFullName);
        connection = connPool.getConnection();
        tbbhStatement = connection.createStatement();
        statement = connection.createStatement();
        String tableName = "basic";
        boolean isExists = this.isTableExists(statement, tableName);
        ArrayList<AppBasic> basics = new ArrayList<AppBasic>();
        ArrayList<BasicIdInfo> idInfos = new ArrayList<BasicIdInfo>();
        if (isExists) {
            querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            while (tbbhRs.next()) {
                Object objvillage;
                Object objvillage2;
                Object objvillage3;
                BasicIdInfo basicIdInfo = new BasicIdInfo();
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = objId.toString();
                    basicIdInfo.setOldId(id);
                }
                String name = "";
                Object objName = tbbhRs.getObject("f_name");
                if (objName != null && !objName.equals("")) {
                    name = objName.toString();
                }
                String createtime = "";
                Date time = new Date();
                Object objCreatetime = tbbhRs.getObject("f_createtime");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                    time = new Date(Long.parseLong(createtime));
                }
                String type = "";
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }
                String desc = "";
                Object objDesc = tbbhRs.getObject("f_desc");
                if (objDesc != null && !objDesc.equals("")) {
                    desc = objDesc.toString();
                }
                String shape = "";
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }
                String cloudId = null;
                Object objCloudId = tbbhRs.getObject("f_cloudId");
                if (objCloudId != null && !objCloudId.equals("")) {
                    cloudId = objCloudId.toString();
                }
                String vipCloudId = null;
                Object objvCloudId = tbbhRs.getObject("f_vipCloudId");
                if (objvCloudId != null && !objvCloudId.equals("")) {
                    vipCloudId = objvCloudId.toString();
                }
                Integer isCollect = null;
                if (this.isColumnExist(tbbhRs, "f_iscollect")) {
                    Object objIsCollect = tbbhRs.getObject("f_iscollect");
                    isCollect = objIsCollect == null ? null : Integer.valueOf(Integer.parseInt(objIsCollect.toString()));
                }
                String heading = null;
                if (this.isColumnExist(tbbhRs, "f_heading") && (objvillage3 = tbbhRs.getObject("f_heading")) != null && !objvillage3.equals("")) {
                    heading = objvillage3.toString();
                }
                Double lon = null;
                if (this.isColumnExist(tbbhRs, "f_lon") && (objvillage2 = tbbhRs.getObject("f_lon")) != null && !objvillage2.equals("")) {
                    lon = Double.parseDouble(objvillage2.toString());
                }
                Double lat = null;
                if (this.isColumnExist(tbbhRs, "f_lat") && (objvillage = tbbhRs.getObject("f_lat")) != null && !objvillage.equals("")) {
                    lat = Double.parseDouble(objvillage.toString());
                }
                AppBasic basic = new AppBasic();
                String newId = UUID.randomUUID().toString();
                basicIdInfo.setNewId(newId);
                idInfos.add(basicIdInfo);
                basic.setId(newId);
                basic.setName(name);
                basic.setCreatetime(createtime);
                basic.setTime(new Date());
                basic.setType(type);
                basic.setDesc(desc);
                basic.setShape(shape);
                basic.setUsername(this.landuserService.queryUserById(userId).getName());
                basic.setCloudId(cloudId);
                basic.setVipCloudId(vipCloudId);
                basic.setHeading(heading);
                basic.setIsCollect(Integer.valueOf(0));
                basic.setShareUser(userId);
                basic.setShareId(id);
                basic.setUserid(organizationId);
                basic.setShareType(Integer.valueOf(3));
                basic.setIsDeleted(Integer.valueOf(0));
                basic.setLon(lon);
                basic.setLat(lat);
                if (lon != null && lat != null) {
                    try {
                        String wkt = "POINT(" + lon + " " + lat + ")";
                        RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
                        if (region == null) {
                            region = this.regionService.queryRegionByGeom(wkt, 4490, 2);
                        }
                        if (region != null) {
                            String county = "";
                            String city = "";
                            String province = "";
                            if (region.getLevel() == 3) {
                                county = region.getCode();
                                city = region.getPcode();
                                province = this.regionService.findRegionByCode(city).getPcode();
                            } else if (region.getLevel() == 2) {
                                city = region.getCode();
                                province = region.getPcode();
                            }
                            RegionVillage village = this.regionService.queryVillageCotain(wkt, 0);
                            basic.setProvince(province);
                            basic.setCity(city);
                            basic.setCounty(county);
                            basic.setVilliage(village != null ? village.getCode() : "");
                        }
                    }
                    catch (Exception wkt) {
                        // empty catch block
                    }
                }
                basics.add(basic);
            }
            this.appBasicRepository.saveAll(basics);
        }
        if (isExists = this.isTableExists(statement, tableName = "media")) {
            querysql = "select * from " + tableName;
            tbbhRs = tbbhStatement.executeQuery(querysql);
            ArrayList<AppMedia> medias = new ArrayList<AppMedia>();
            while (tbbhRs.next()) {
                AppMedia media = new AppMedia();
                Object objId = tbbhRs.getObject("f_id");
                String id = "";
                if (objId != null && !objId.equals("")) {
                    id = UUID.randomUUID().toString();
                }
                String galleyid = "";
                Object objGalleyid = tbbhRs.getObject("f_galleryid");
                if (objGalleyid != null && !objGalleyid.equals("")) {
                    galleyid = objGalleyid.toString();
                }
                String type = "0";
                Object objType = tbbhRs.getObject("f_type");
                if (objType != null && !objType.equals("")) {
                    type = objType.toString();
                }
                String createtime = "";
                Object objCreatetime = tbbhRs.getObject("f_time");
                if (objCreatetime != null && !objCreatetime.equals("")) {
                    createtime = objCreatetime.toString();
                }
                String lon = "";
                Object objLon = tbbhRs.getObject("f_lon");
                if (objLon != null && !objLon.equals("")) {
                    lon = objLon.toString();
                }
                String lat = "";
                Object objLat = tbbhRs.getObject("f_lat");
                if (objLat != null && !objLat.equals("")) {
                    lat = objLat.toString();
                }
                String athmus = "";
                Object objAthmus = tbbhRs.getObject("f_azimuth");
                if (objAthmus != null && !objAthmus.equals("")) {
                    athmus = objAthmus.toString();
                }
                String pitch = "";
                Object objPitch = tbbhRs.getObject("f_pitch");
                if (objPitch != null && !objPitch.equals("")) {
                    pitch = objPitch.toString();
                }
                String shape = "";
                Object objShape = tbbhRs.getObject("f_shape");
                if (objShape != null && !objShape.equals("")) {
                    shape = objShape.toString();
                }
                String vedioRecord = "";
                Object objVedioRecord = tbbhRs.getObject("f_videorecord");
                if (objVedioRecord != null && !objVedioRecord.equals("")) {
                    vedioRecord = objVedioRecord.toString();
                }
                String serverpath = "";
                Object objServerpath = tbbhRs.getObject("f_serverpath");
                if (objServerpath != null && !objServerpath.equals("")) {
                    if (objServerpath.toString().startsWith("http")) {
                        serverpath = objServerpath.toString();
                    } else {
                        this.innerImgUrl = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
                        serverpath = this.innerImgUrl + objServerpath.toString();
                    }
                }
                String mediatimelength = "0";
                Object objMediatimelength = tbbhRs.getObject("f_mediatimelength");
                if (objMediatimelength != null && !objMediatimelength.equals("")) {
                    mediatimelength = objMediatimelength.toString();
                }
                String mediasize = "0";
                Object objMediasize = tbbhRs.getObject("f_mediasize");
                if (objMediasize != null && !objMediasize.equals("")) {
                    mediasize = objMediasize.toString();
                }
                String newgalleyid = "";
                for (AppBasic ba : basics) {
                    if (!ba.getShareId().equals(galleyid)) continue;
                    newgalleyid = ba.getId();
                    break;
                }
                media.setId(id);
                media.setGalleryid(newgalleyid);
                media.setType(Integer.valueOf(type));
                if (StringUtils.isNotBlank((CharSequence)createtime)) {
                    Long timeLong = null;
                    try {
                        timeLong = Long.valueOf(createtime);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(createtime);
                            timeLong = date.getTime();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (timeLong != null) {
                        media.setTime(String.valueOf(timeLong));
                    }
                }
                media.setLon(Double.valueOf(lon));
                media.setLat(Double.valueOf(lat));
                media.setAzimuth(athmus);
                media.setPitch(pitch);
                media.setShape(shape);
                media.setVideorecord(vedioRecord);
                media.setServerpath(serverpath);
                media.setMediatimelength(Integer.valueOf(mediatimelength));
                media.setMediasize(Double.valueOf(mediasize));
                medias.add(media);
            }
            this.appMediaRepository.saveAll(medias);
        }
        return idInfos;
    }

    public Page<AppBasic> getPageByFilter(String filterParam, String sortParam, int start, Integer limit) {
        return this.appBasicRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
    }

    public List getBasicListByExtent(String userid, Float xmin, Float xmax, Float ymin, Float ymax) {
        JSONArray jsonArray = new JSONArray();
        List list = this.appBasicRepository.getListByExtent(userid, xmin, xmax, ymin, ymax);
        for (int i = 0; i < list.size(); ++i) {
            Object[] objarr = (Object[])list.get(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("f_id", objarr[0]);
            jsonObject.put("f_lon", (Object)Float.valueOf(objarr[1].toString()));
            jsonObject.put("f_lat", (Object)Float.valueOf(objarr[2].toString()));
            jsonObject.put("f_shape", (Object)(objarr[3] == null ? "" : objarr[3].toString()));
            jsonObject.put("f_heading", (Object)(objarr[4] == null ? "" : objarr[4].toString()));
            jsonObject.put("f_type", (Object)(objarr[5] == null ? "" : objarr[5].toString()));
            jsonObject.put("f_name", (Object)(objarr[6] == null ? "" : objarr[6].toString()));
            jsonObject.put("f_time", (Object)(objarr[7] == null ? "" : objarr[7].toString()));
            jsonObject.put("f_username", (Object)(objarr[8] == null ? "" : objarr[8].toString()));
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    public void save(AppBasic basic) {
        this.appBasicRepository.save((Object)basic);
    }

    public AppBasic findOne(String id) {
        return this.appBasicRepository.findById((Object)id).orElse(null);
    }

    public boolean exist(String id) {
        return this.appBasicRepository.existsById((Object)id);
    }

    public void saveAll(List<AppBasic> basics) {
        this.appBasicRepository.saveAll(basics);
    }

    public void deleteBasics(List<AppBasic> basics) {
        this.appBasicRepository.deleteAll(basics);
    }

    public AppBasic uploadMyCloudId(String id, String myCloudId, String wkt) {
        AppBasic basic = this.appBasicRepository.findById((Object)id).orElse(null);
        basic.setRequestId(myCloudId);
        if (StringUtils.isNotBlank((CharSequence)wkt)) {
            basic.setShape(wkt);
        }
        basic = (AppBasic)this.appBasicRepository.save((Object)basic);
        return basic;
    }

    public AppBasic getDetailById(String id, String userId, String filterParam, String sortParam) {
        AppBasic appBasic = this.appBasicRepository.findById((Object)id).orElse(null);
        Date time = appBasic.getTime();
        String timeDT = ";Q_time_D_GT=" + time.getTime();
        String timeLT = ";Q_time_D_LT=" + time.getTime();
        String prevFilterParam = filterParam + ";Q_userid_S_EQ=" + userId;
        String nextFilterParam = filterParam + ";Q_userid_S_EQ=" + userId;
        String prevSort = "";
        String nextSort = "";
        if (sortParam.indexOf("ASC") == -1) {
            prevFilterParam = prevFilterParam + timeDT;
            nextFilterParam = nextFilterParam + timeLT;
            prevSort = "SORT_time_ASC";
            nextSort = "SORT_time_DESC";
        } else {
            prevFilterParam = prevFilterParam + timeLT;
            nextFilterParam = nextFilterParam + timeDT;
            prevSort = "SORT_time_DESC";
            nextSort = "SORT_time_ASC";
        }
        Page<AppBasic> previous = this.getPageByFilter(prevFilterParam, prevSort, 0, 1);
        Page<AppBasic> next = this.getPageByFilter(nextFilterParam, nextSort, 0, 1);
        if (previous.getTotalElements() > 0L) {
            appBasic.setPrevious(((AppBasic)previous.getContent().get(0)).getId());
        }
        if (next.getTotalElements() > 0L) {
            appBasic.setNext(((AppBasic)next.getContent().get(0)).getId());
        }
        List mds = this.appMediaRepository.queryByGid(id);
        appBasic.setCurMedia(this.getFirstPhont(id));
        appBasic.setList(mds);
        return appBasic;
    }

    public AppBasic getDetailById(String id, String userId) {
        AppBasic appBasic = this.appBasicRepository.findById((Object)id).orElse(null);
        List previousappBasic = this.appBasicRepository.getPreviousappBasic(appBasic.getTime(), userId, (Pageable)PageRequest.of((int)0, (int)1));
        List nextappBasic = this.appBasicRepository.getNextappBasic(appBasic.getTime(), userId, (Pageable)PageRequest.of((int)0, (int)1));
        if (!previousappBasic.isEmpty()) {
            appBasic.setPrevious(((AppBasic)previousappBasic.get(0)).getId());
        }
        if (!nextappBasic.isEmpty()) {
            appBasic.setNext(((AppBasic)nextappBasic.get(0)).getId());
        }
        List mds = this.appMediaRepository.queryByGid(id);
        appBasic.setCurMedia(this.getFirstPhont(id));
        appBasic.setList(mds);
        return appBasic;
    }

    public AppBasic getDetailById(String id) throws Exception {
        String county;
        String city;
        AppBasic appBasic = this.appBasicRepository.findById((Object)id).orElse(null);
        if (appBasic.getIsDeleted() == 1) {
            throw new RuntimeException("\u8be5\u968f\u624b\u62cd\u5df2\u88ab\u5220\u9664");
        }
        String regionName = "";
        String province = appBasic.getProvince();
        if (province != null && province != "") {
            regionName = regionName + this.regionService.getNameByCode(province);
        }
        if ((city = appBasic.getCity()) != null && city != "") {
            regionName = regionName + this.regionService.getNameByCode(city);
        }
        if ((county = appBasic.getCounty()) != null && county != "") {
            regionName = regionName + this.regionService.getNameByCode(county);
        }
        appBasic.setRegion(regionName);
        List mds = this.appMediaRepository.queryByGid(id);
        appBasic.setCurMedia(this.getFirstPhont(id));
        appBasic.setList(mds);
        return appBasic;
    }

    public AppMedia getFirstPhont(String id) {
        List mds = null;
        try {
            mds = this.appMediaRepository.queryOfPhoto(id, (Pageable)PageRequest.of((int)0, (int)1));
        }
        catch (Exception e) {
            System.out.println(id);
            return null;
        }
        if (!mds.isEmpty()) {
            return (AppMedia)mds.get(0);
        }
        return null;
    }

    public long queryOfPhotoCount(String id) {
        Long count = this.appMediaRepository.queryOfPhotoCount(id);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public void doCollect(List ids, int isCollect) {
        this.appBasicRepository.updateCollect(ids, isCollect);
    }

    public List<AppBasic> getAppBasicByCollect(int isCollect, Long userId) {
        return this.appBasicRepository.getAppBasicByCollect(isCollect, userId + "");
    }

    public AppBasic deleteOne(String id) {
        AppBasic appBasic = this.appBasicRepository.findById((Object)id).orElse(null);
        appBasic.setIsDeleted(Integer.valueOf(1));
        appBasic.setDeleteTime(new Date());
        this.appBasicRepository.save((Object)appBasic);
        List list = this.aPicShareRepository.getApicShareByOldId(id);
        if (!list.isEmpty()) {
            this.aPicShareRepository.deleteAll((Iterable)list);
        }
        return appBasic;
    }

    public int deleteByIds(String ids) {
        String[] idArr = ids.split(",");
        int count = 0;
        for (int i = 0; i < idArr.length; ++i) {
            List list;
            AppBasic appBasic = this.appBasicRepository.findById((Object)idArr[i]).orElse(null);
            if (appBasic != null) {
                appBasic.setIsDeleted(Integer.valueOf(1));
                appBasic.setDeleteTime(new Date());
                this.appBasicRepository.save((Object)appBasic);
                ++count;
            }
            if ((list = this.aPicShareRepository.getApicShareByOldId(idArr[i])).isEmpty()) continue;
            this.aPicShareRepository.deleteAll((Iterable)list);
        }
        return count;
    }

    public void deleteByIds(List<String> ids) {
        this.appBasicRepository.deleteByIds(ids);
    }

    public void updateServerPath() {
        Iterable list = this.appBasicRepository.findAll();
        for (AppBasic appBasic : list) {
            if (appBasic.getTime() == null) {
                appBasic.setTime(new Date(Long.parseLong(appBasic.getCreatetime())));
                this.appBasicRepository.save((Object)appBasic);
            }
            if (appBasic.getIsDeleted() != 1) continue;
            appBasic.setDeleteTime(new Date());
            this.appBasicRepository.save((Object)appBasic);
        }
        List querys = this.appMediaRepository.findAll();
        this.innerImgUrl = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
        for (AppMedia ab : querys) {
            if (!StringUtils.isNotBlank((CharSequence)ab.getServerpath()) || ab.getServerpath().startsWith("http")) continue;
            ab.setServerpath(this.innerImgUrl + ab.getServerpath());
            this.appMediaRepository.save((Object)ab);
        }
    }

    private boolean isTableExists(Statement statement, String tableName) throws SQLException {
        String sql = String.format("select count(1) from sqlite_master where type = 'table' and name = '%s'", tableName);
        ResultSet rs = statement.executeQuery(sql);
        int iResult = 0;
        while (rs.next()) {
            iResult = rs.getInt(1);
        }
        return iResult > 0;
    }

    private boolean isColumnExist(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    public int recoverByIds(String ids) throws Exception {
        int count = 0;
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            AppBasic appBasic = this.appBasicRepository.findById((Object)idArr[i]).orElse(null);
            appBasic.setIsDeleted(Integer.valueOf(0));
            this.appBasicRepository.save((Object)appBasic);
            ++count;
        }
        return count;
    }

    public void recoverAll(Long userId) throws Exception {
    }

    public int shiftDeleteByIds(String ids) throws Exception {
        int count = 0;
        String[] idArr = ids.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            AppBasic appBasic = this.appBasicRepository.findById((Object)idArr[i]).orElse(null);
            appBasic.setIsDeleted(Integer.valueOf(2));
            this.appBasicRepository.save((Object)appBasic);
            ++count;
        }
        return count;
    }

    public Page<AppBasic> getMyOrgList(Long userId, int start, int limit, String filterParam, String sortParam, String organizationId) {
        List list = this.organization2UserDao.queryByUserId(userId);
        if (list.isEmpty()) {
            throw new RuntimeException("\u65e0\u5355\u4f4d");
        }
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            organizationId = ((Organization2User)list.get(0)).getOrganizationId();
        }
        filterParam = filterParam + ";Q_isDeleted_N_EQ=0;Q_userid_S_EQ=" + organizationId;
        Page appBasics = this.appBasicRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        for (AppBasic appBasic : appBasics) {
            AppMedia appMedia = this.getFirstPhont(appBasic.getId());
            AppMedia app = new AppMedia();
            if (appMedia != null) {
                BeanUtil.copyProperties((Object)appMedia, (Object)app);
                if (StringUtils.isNotBlank((CharSequence)appMedia.getServerpath())) {
                    String temporarySignedUrl = this.temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
                    app.setServerpath(temporarySignedUrl);
                }
            }
            appBasic.setCurMedia(app);
        }
        return appBasics;
    }

    public AppBasic getDetailByIdAndOwnerId(Long userId, String id, String ownerId, String filterParam, String sortParam) {
        if (StringUtils.isBlank((CharSequence)ownerId)) {
            List list = this.organization2UserDao.queryByUserId(userId);
            if (list.isEmpty()) {
                throw new RuntimeException("\u65e0\u5355\u4f4d");
            }
            ownerId = ((Organization2User)list.get(0)).getOrganizationId();
        }
        return this.getDetailById(id, ownerId, filterParam, sortParam);
    }

    public AppBasic getMyShareDetail(String shareId, Long userId, String filter) {
        APicShare share = this.aPicShareRepository.findById((Object)shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("\u8be5\u5206\u4eab\u4e0d\u5b58\u5728");
        }
        String appBasicId = share.getOldId();
        String appBasicInfo = share.getAppBasicInfo();
        AppBasic appBasic = null;
        if (StringUtils.isNotBlank((CharSequence)appBasicInfo)) {
            appBasic = (AppBasic)JSON.parseObject((String)appBasicInfo, AppBasic.class);
            List list = appBasic.getList();
            if (list != null) {
                for (AppMedia appMedia : list) {
                    if (appMedia.getType() != 1 && appMedia.getType() != 2) continue;
                    appBasic.setCurMedia(appMedia);
                    break;
                }
            }
        } else {
            appBasic = this.appBasicRepository.findById((Object)share.getOldId()).orElse(null);
            List mds = this.appMediaRepository.queryByGid(appBasicId);
            appBasic.setCurMedia(this.getFirstPhont(appBasicId));
            appBasic.setList(mds);
        }
        List previousShares = this.aPicShareRepository.getPreviousShare(share.getShareTime(), userId, "%" + filter + "%", (Pageable)PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"f_sharetime"})));
        List nextShares = this.aPicShareRepository.getNextShare(share.getShareTime(), userId, "%" + filter + "%", (Pageable)PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"f_sharetime"})));
        if (!previousShares.isEmpty()) {
            appBasic.setPrevious(((APicShare)previousShares.get(0)).getId());
        }
        if (!nextShares.isEmpty()) {
            appBasic.setNext(((APicShare)nextShares.get(0)).getId());
        }
        return appBasic;
    }

    public List<AppBasic> getBasicListByIds(List tbids, long userId) {
        return this.appBasicRepository.getBasicListByIds(tbids, userId + "");
    }

    public JSONObject buildJSONParam(String userId, String tbId) {
        JSONObject jsonObject = new JSONObject();
        AppBasic appBasic = this.getDetailById(tbId, userId, "", "");
        JSONArray fields = new JSONArray();
        fields.add((Object)this.buildFieldsJSON("heading", "\u540d\u79f0", "", 20L, 0L, 1L, 0L));
        fields.add((Object)this.buildFieldsJSON("type", "\u5feb\u62cd\u7c7b\u578b", "", 20L, 0L, 1L, 0L));
        fields.add((Object)this.buildFieldsJSON("name", "\u62cd\u6444\u5730\u70b9", "", 20L, 0L, 1L, 0L));
        fields.add((Object)this.buildFieldsJSON("time", "\u62cd\u6444\u65f6\u95f4", "", 20L, 0L, 1L, 0L));
        fields.add((Object)this.buildFieldsJSON("username", "\u62cd\u6444\u4eba\u5458", "", 20L, 0L, 1L, 0L));
        fields.add((Object)this.buildFieldsJSON("desc", "\u5916\u4e1a\u63cf\u8ff0", "", 20L, 0L, 1L, 0L));
        jsonObject.put("fields", (Object)fields);
        String userName = appBasic.getUsername();
        userName = this.userNameService.getUserRealNameByUserName(appBasic.getUsername());
        JSONObject tbInfo = new JSONObject();
        tbInfo.put("heading", (Object)appBasic.getHeading());
        tbInfo.put("type", (Object)appBasic.getType());
        tbInfo.put("name", (Object)appBasic.getName());
        tbInfo.put("time", (Object)appBasic.getTime());
        tbInfo.put("username", (Object)userName);
        tbInfo.put("requestId", (Object)appBasic.getRequestId());
        tbInfo.put("shape", (Object)appBasic.getShape());
        tbInfo.put("desc", (Object)appBasic.getDesc());
        jsonObject.put("tbInfo", (Object)tbInfo);
        jsonObject.put("prev", (Object)appBasic.getPrevious());
        jsonObject.put("next", (Object)appBasic.getNext());
        return jsonObject;
    }

    private JSONObject buildFieldsJSON(String fieldName, String alias, String fieldType, Long length, Long order, Long isBase, Long isOutWork) {
        JSONObject field = new JSONObject();
        field.put("fId", (Object)"");
        field.put("fTableid", (Object)TAKE_HAND_TASK_ID);
        field.put("fTablename", (Object)"");
        field.put("fFieldname", (Object)fieldName);
        field.put("fAlias", (Object)alias);
        field.put("fIsprimary", (Object)"");
        field.put("fFieldtype", (Object)fieldType);
        field.put("fLength", (Object)length);
        field.put("fPrecision", (Object)"");
        field.put("fNullable", (Object)"");
        field.put("fDefaultvalue", (Object)"");
        field.put("fCodetableid", (Object)"");
        field.put("fRemark", (Object)"");
        field.put("fOrder", (Object)order);
        field.put("fIsBase", (Object)isBase);
        field.put("fIsOutwork", (Object)isOutWork);
        return field;
    }

    public boolean updateLonLatById(String id) {
        return this.appBasicRepository.updateLonLatById(id) > 0;
    }
}

