/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.businessapps;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.dao.businessapps.BusAppsApproveRecordDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusAppsConfigDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusAppsFunctionRelDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusAppsInfoDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusAppsManagerDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusAppsSchemaDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionDefaultDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionModuleDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionModuleDefaultDao;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusAppsInfoDto;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusAppsSchemaDto;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusFunctionDto;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusFunctionModuleDefaultDto;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsApproveRecordPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsConfigPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsInfoPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsManagerPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusAppsSchemaPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionDefaultPo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionModulePo;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionPo;
import com.geoway.landteam.landcloud.servface.businessapps.BusAppsInfoService;
import com.geoway.landteam.landcloud.servface.businessapps.BusFunctionService;
import com.geoway.landteam.landcloud.servface.filestorage.FileStorageService;
import com.geoway.landteam.landcloud.service.util.UserAuthHttpUtils;
import com.gw.base.data.GwValidateException;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class BusAppsInfoServiceImpl
implements BusAppsInfoService {
    @Value(value="${spring.security.oauth2.client.provider.gas-cqfzx.createAppInfo-uri:}")
    private String createAppInfo_uri;
    @Value(value="${spring.security.oauth2.client.provider.gas-cqfzx.getAppByAppId-uri:}")
    private String getAppByAppId_uri;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.loginBack-uri:}")
    private String loginBack_uri;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.logout-uri:}")
    private String logout_uri;
    @Value(value="${spring.security.oauth2.client.registration.gas-cqfzx.appslogin-uri:}")
    private String appslogin_uri;
    @Autowired
    private BusAppsInfoDao busAppsInfoDao;
    @Autowired
    private BusAppsManagerDao busAppsManagerDao;
    @Autowired
    private BusAppsConfigDao busAppsConfigDao;
    @Autowired
    private BusAppsApproveRecordDao busAppsApproveRecordDao;
    @Autowired
    private BusFunctionService busFunctionService;
    @Autowired
    private BusAppsFunctionRelDao busAppsFunctionRelDao;
    @Autowired
    private BusFunctionDefaultDao busFunctionDefaultDao;
    @Autowired
    private BusFunctionModuleDao busFunctionModuleDao;
    @Autowired
    private BusFunctionModuleDefaultDao busFunctionModuleDefaultDao;
    @Autowired
    FileStorageService fileStorageService;
    @Autowired
    private BusFunctionDao busFunctionDao;
    @Autowired
    private BusAppsSchemaDao busAppsSchemaDao;

    public BusAppsInfoPo addBusApps(String userId, MultipartFile logfile, MultipartFile loginfile, MultipartFile backgroundfile, BusAppsInfoPo busAppsInfoPo, List<String> busFunctionIds) {
        BusAppsInfoPo bean = new BusAppsInfoPo(null);
        BeanUtils.copyProperties((Object)busAppsInfoPo, (Object)bean, (String[])new String[]{"id", "status"});
        String ossPath = "busapps/" + System.currentTimeMillis() + "/";
        String logfileupload = this.fileStorageService.saveFile(logfile, ossPath);
        String loginfileupload = this.fileStorageService.saveFile(loginfile, ossPath);
        String backgroundfileupload = this.fileStorageService.saveFile(backgroundfile, ossPath);
        bean.setLoginUrl(loginfileupload);
        bean.setLogUrl(logfileupload);
        bean.setBackgroundUrl(backgroundfileupload);
        bean.setStatus(Integer.valueOf(0));
        bean.setStage(Integer.valueOf(1));
        bean.setIsFinish(Integer.valueOf(0));
        bean.setUserId(userId);
        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.busAppsInfoDao.gwAccessSelective((GiEntitySaveable)bean);
        if (busFunctionIds.size() > 0) {
            for (String s : busFunctionIds) {
                this.insertFunctionAndModule(s, bean.getId());
            }
        }
        String schemaName = this.getSchemaName(busAppsInfoPo.getAppsName());
        String sql = "CREATE SCHEMA  \"" + schemaName + "\" ;COMMENT ON SCHEMA \"" + schemaName + "\" IS 'standard " + schemaName + " schema';";
        this.busAppsSchemaDao.excuteSql(sql);
        BusAppsSchemaPo busAppsSchemaPo = new BusAppsSchemaPo(null);
        busAppsSchemaPo.setAppsId(bean.getId());
        busAppsSchemaPo.setSchema(schemaName);
        busAppsSchemaPo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.busAppsSchemaDao.gwAccessSelective((GiEntitySaveable)busAppsSchemaPo);
        this.busAppsSchemaDao.insertClassTask(busAppsInfoPo.getAppsName(), Integer.valueOf(101), bean.getLogUrl(), bean.getId());
        Integer classId = this.busAppsSchemaDao.excuteSeqCurrValue("seq_tbtsk_task_class_num_id");
        String userClassSql = "INSERT INTO public.tbtsk_user_task_class (f_id, f_userid, f_classid,f_createdate)VALUES(uuid_generate_v4(), '" + userId + "' ,'" + classId + "', now()); ";
        this.busAppsSchemaDao.excuteSql(userClassSql);
        return bean;
    }

    public void insertFunctionAndModule(String functionId, String appsId) {
        BusFunctionDefaultPo busFunctionDefaultPo = (BusFunctionDefaultPo)this.busFunctionDefaultDao.gwSearchByPK((Serializable)((Object)functionId));
        BusFunctionPo busFunctionPo = new BusFunctionPo(null);
        BeanUtils.copyProperties((Object)busFunctionDefaultPo, (Object)busFunctionPo, (String[])new String[]{"id"});
        busFunctionPo.setAppsId(appsId);
        busFunctionPo.setDefaultFunctionId(functionId);
        busFunctionPo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.busFunctionDao.gwAccessSelective((GiEntitySaveable)busFunctionPo);
        List byFunctionId = this.busFunctionModuleDefaultDao.findByFunctionId(functionId);
        for (BusFunctionModuleDefaultDto b : byFunctionId) {
            BusFunctionModulePo busFunctionModulePo = new BusFunctionModulePo(null);
            BeanUtils.copyProperties((Object)b, (Object)busFunctionModulePo, (String[])new String[]{"id"});
            busFunctionModulePo.setFunctionId(busFunctionPo.getId());
            busFunctionModulePo.setPlatformUrl(b.getPlatformUrl() != null ? b.getPlatformUrl() + "?appsId=" + busFunctionPo.getAppsId() : null);
            busFunctionModulePo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.busFunctionModuleDao.gwAccessSelective((GiEntitySaveable)busFunctionModulePo);
        }
    }

    public BusAppsInfoPo updateBusApps(String userId, MultipartFile logfile, MultipartFile loginfile, MultipartFile backgroundfile, BusAppsInfoPo busAppsInfoPo, List<String> busFunctionIds) throws Exception {
        String url;
        BusAppsInfoPo bean = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)busAppsInfoPo.getId()));
        if (bean.getStatus() == 1 && bean.getStage() == 1) {
            throw new GwValidateException("\u5e94\u7528\u521b\u5efa\u7533\u8bf7\u5df2\u5ba1\u6838\u901a\u8fc7\u4e0d\u80fd\u518d\u8fdb\u884c\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
        }
        BeanUtils.copyProperties((Object)busAppsInfoPo, (Object)bean, (String[])new String[]{"id", "status"});
        String ossPath = "busapps/" + System.currentTimeMillis() + "/";
        if (logfile != null) {
            url = this.fileStorageService.saveFile(logfile, ossPath);
            bean.setLogUrl(url);
        }
        if (loginfile != null) {
            url = this.fileStorageService.saveFile(loginfile, ossPath);
            bean.setLoginUrl(url);
        }
        if (backgroundfile != null) {
            url = this.fileStorageService.saveFile(backgroundfile, ossPath);
            bean.setBackgroundUrl(url);
        }
        bean.setUserId(userId);
        bean.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.busAppsInfoDao.gwUpdateByPKSelective((GiEntityAlterable)bean);
        if (busFunctionIds.size() > 0) {
            List busFunctionsByappId = this.busFunctionDao.findBusFunctionsByappId(bean.getId());
            List defaultFunctionId = busFunctionsByappId.stream().map(BusFunctionPo::getDefaultFunctionId).collect(Collectors.toList());
            List collect = Stream.of(busFunctionIds, defaultFunctionId).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            for (String s : collect) {
                if (busFunctionIds.contains(s) && !defaultFunctionId.contains(s)) {
                    this.insertFunctionAndModule(s, bean.getId());
                    continue;
                }
                if (!defaultFunctionId.contains(s) || busFunctionIds.contains(s)) continue;
                Integer getNoModuleConfigCount = this.busFunctionModuleDao.getNoModuleConfigCount(s, bean.getId());
                if (getNoModuleConfigCount <= 0) {
                    for (BusFunctionDto busFunctionDto : busFunctionsByappId) {
                        if (!s.equals(busFunctionDto.getDefaultFunctionId())) continue;
                        throw new GwValidateException(busFunctionDto.getFunctionName() + "\u5df2\u914d\u7f6e\u5b8c\u6210\u4e0d\u80fd\u79fb\u9664\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
                    }
                    continue;
                }
                this.busFunctionModuleDao.delModuleByFunctionId(s, bean.getId());
                this.busFunctionDao.delByFunctionId(s, busAppsInfoPo.getId());
            }
        }
        return bean;
    }

    public BusAppsInfoDto findBusAppsDetailsById(String appsId) {
        String url;
        BusAppsInfoPo busAppsInfoPo = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)appsId));
        BusAppsConfigPo busAppsConfigPo = (BusAppsConfigPo)this.busAppsConfigDao.gwSearchByPK((Serializable)((Object)appsId));
        if (busAppsConfigPo != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appId", appsId);
            params.put("stateActive", 1);
            JSONObject jsonObject = UserAuthHttpUtils.accessAppsInterface(this.getAppByAppId_uri, params);
            if (jsonObject != null) {
                String appId = jsonObject.getString("appId");
                Integer n = jsonObject.getInteger("stateActive");
            }
        }
        BusAppsInfoDto bean = new BusAppsInfoDto();
        BeanUtils.copyProperties((Object)busAppsInfoPo, (Object)bean);
        List busFunctionAndModulesByappId = this.busFunctionService.findBusFunctionAndModulesByappId(appsId);
        bean.setBusFunctionList(busFunctionAndModulesByappId);
        List busAppsManagerDtos = this.busAppsManagerDao.findByAppsId(appsId);
        bean.setBusAppsManagerDtos(busAppsManagerDtos);
        if (bean.getLogUrl() != null && !bean.getLogUrl().contains("AccessKeyId")) {
            url = this.fileStorageService.generatePresignedUrlByUrl(bean.getLogUrl());
            bean.setLogUrl(url);
        }
        if (bean.getLoginUrl() != null && !bean.getLoginUrl().contains("AccessKeyId")) {
            url = this.fileStorageService.generatePresignedUrlByUrl(bean.getLoginUrl());
            bean.setLoginUrl(url);
        }
        if (bean.getBackgroundUrl() != null && !bean.getBackgroundUrl().contains("AccessKeyId")) {
            url = this.fileStorageService.generatePresignedUrlByUrl(bean.getBackgroundUrl());
            bean.setBackgroundUrl(url);
        }
        return bean;
    }

    public void delBusApps(String userId, String appsId) {
        BusAppsInfoPo busAppsInfoPo = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)appsId));
        if (busAppsInfoPo.getStatus() == 1) {
            throw new GwValidateException("\u5df2\u5ba1\u6838\u901a\u8fc7\u4e0d\u80fd\u79fb\u9664\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        }
        this.busAppsInfoDao.gwDeleteByPK((Serializable)((Object)appsId));
        this.busAppsFunctionRelDao.delByAppId(appsId);
        BusAppsSchemaDto byAppsId = this.busAppsSchemaDao.findByAppsId(appsId);
        if (byAppsId != null) {
            String delsql = " ------------\u7ebf\u7d22\u914d\u7f6e\u76f8\u5173\u6570\u636e\u5220\u9664---------------------\n--\u6a21\u677f\u5b57\u6bb5\ndelete from jc_clue_fields jcf where f_tableid  in (select jct.f_id  from jc_clue_template jct where f_appsid  = '" + appsId + "');\n--\u6a21\u677f\u6570\u636e\ndelete from jc_clue_template jct where f_appsid  = '" + appsId + "';\n--\u7ebf\u7d22\u914d\u7f6e\u5b57\u6bb5\ndelete from jc_clue_fields jcf where f_tableid  in (select jct.f_id  from jc_clue_source  jct where f_appsid  = '" + appsId + "');\n--\u7ebf\u7d22\u914d\u7f6egroup\ndelete from jc_clue_group jcg  where f_tablename  in (select jcs.f_tablename  from jc_clue_source jcs  where jcs.f_appsid ='" + appsId + "' );\n-----------\u8c03\u67e5\u4efb\u52a1\u76f8\u5173\u6570\u636e\u5220\u9664\n--\u6a21\u677ftbtsk_fields\ndelete from tbtsk_fields   where f_tableid in (select tt.f_tableid  from tbtsk_template tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "'));  \n--\u6a21\u677ftbtsk_group\ndelete from tbtsk_group  where f_tablename in (select tt.f_tableid  from tbtsk_template tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "'));\n--\u7ebf\u7d22\u6570\u636ejc_clue_source\ndelete from jc_clue_source jcs  where jcs.f_appsid  = '" + appsId + "'; --\u6a21\u677f\u6570\u636etbtsk_template\ndelete from  tbtsk_template tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "');\n--\u4efb\u52a1tbtsk_fields\ndelete from tbtsk_fields where f_tableid in (select tt.f_tableid  from tbtsk_task_biz  tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "')); \n--tbtsk_group\ndelete from tbtsk_group where f_tablename  in(select to2.f_tablename  from tbtsk_task_biz  tt,tbtsk_objectinfo to2  where to2.f_id  =tt.f_tableid  and tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "') );\n--\u4efb\u52a1tbtsk_objectinfo\ndelete from tbtsk_objectinfo where f_id  in (select tt.f_tableid  from tbtsk_task_biz  tt where tt.f_classid  = (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "') );\n--\u4efb\u52a1\u4fe1\u606ftbtsk_task_biz\ndelete from tbtsk_task_biz where f_classid in (select f_id  from tbtsk_task_class ttc  where f_appkey ='" + appsId + "');\n--\u4e1a\u52a1\u5927\u7c7b\ndelete from tbtsk_task_class ttc  where f_appkey ='" + appsId + "';";
            this.busAppsSchemaDao.excuteSql(delsql);
            String sql = "DROP SCHEMA  \"" + byAppsId.getSchema() + "\" CASCADE;";
            this.busAppsSchemaDao.excuteSql(sql);
        }
    }

    public void saveBusAppsConfig(String userId, String orgId, String appsId) throws Exception {
        BusAppsInfoPo busAppsInfoPo = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)appsId));
        Integer noFinishConfigCount = this.busFunctionModuleDao.getNoFinishConfigCount(appsId);
        if (noFinishConfigCount > 0) {
            throw new GwValidateException("\u914d\u7f6e\u672a\u5b8c\u6210\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        }
        busAppsInfoPo.setIsFinish(Integer.valueOf(1));
        busAppsInfoPo.setStage(Integer.valueOf(1));
        this.busAppsInfoDao.gwUpdateByPKSelective((GiEntityAlterable)busAppsInfoPo);
    }

    public void addBusAppsManagers(String appsId, List<String> userIds) {
        for (String s : userIds) {
            BusAppsManagerPo busAppsManagerPo = new BusAppsManagerPo(null);
            busAppsManagerPo.setAppsId(appsId);
            busAppsManagerPo.setUserId(s);
            busAppsManagerPo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.busAppsManagerDao.gwAccessSelective((GiEntitySaveable)busAppsManagerPo);
            Map map = this.busAppsSchemaDao.selectByID("tbsys_user_area ", "f_userid", "'" + s + "'");
            if (map == null) continue;
            String f_regioncode = map.get("f_regioncode").toString();
            int level = 1;
            if (f_regioncode.length() >= 6) {
                level = f_regioncode.endsWith("0000") ? 1 : (f_regioncode.endsWith("00") ? 2 : 3);
            } else if (f_regioncode.length() >= 9) {
                level = 4;
            } else if (f_regioncode.length() >= 12) {
                level = 5;
            }
            String biz2sql = "INSERT INTO public.tbsys_user_biz2 (f_userid, f_bizid, f_id, f_role) select '" + s + "',ttb.f_id,uuid_generate_v4(),'1' from tbtsk_task_biz ttb  inner join tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  )and ttc.f_appkey ='" + appsId + "' and  NOT exists (select 1 from tbsys_user_biz2 biz where biz.f_bizid = ttb.f_id and biz.f_userid  ='" + s + "'  and biz.f_role = '1') ;";
            this.busAppsSchemaDao.excuteSql(biz2sql);
            String managersql = "INSERT INTO public.tbtsk_user_manage_area ( f_taskid, f_userid, f_level,f_regioncode)  select ttb.f_id,'" + s + "','" + level + "','" + f_regioncode + "' from tbtsk_task_biz ttb  inner join tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  ) and ttc.f_appkey ='" + appsId + "' and not exists (select * from tbtsk_user_manage_area a where a.f_taskid = ttb.f_id and a.f_regioncode ='" + f_regioncode + "' and a.f_userid ='" + s + "' and a.f_level ='" + level + "');";
            this.busAppsSchemaDao.excuteSql(managersql);
        }
    }

    public void addOrUpdateBusAppsManagers(String appsId, List<BusAppsManagerPo> busAppsManagerPos) {
        this.busAppsManagerDao.delByAppsId(appsId);
        for (BusAppsManagerPo bean : busAppsManagerPos) {
            bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.busAppsManagerDao.gwAccessSelective((GiEntitySaveable)bean);
            String s = bean.getUserId();
            Map map = this.busAppsSchemaDao.selectByID("tbsys_user_area ", "f_userid", "'" + s + "'");
            if (map == null) continue;
            String f_regioncode = map.get("f_regioncode").toString();
            int level = 1;
            if (f_regioncode.length() >= 6) {
                level = f_regioncode.endsWith("0000") ? 1 : (f_regioncode.endsWith("00") ? 2 : 3);
            } else if (f_regioncode.length() >= 9) {
                level = 4;
            } else if (f_regioncode.length() >= 12) {
                level = 5;
            }
            String biz2sql = "INSERT INTO public.tbsys_user_biz2 (f_userid, f_bizid, f_id, f_role) select '" + s + "',ttb.f_id,uuid_generate_v4(),'1' from tbtsk_task_biz ttb  inner join tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  )and ttc.f_appkey ='" + appsId + "' and  NOT exists (select 1 from tbsys_user_biz2 biz where biz.f_bizid = ttb.f_id and biz.f_userid  ='" + s + "'  and biz.f_role = '1') ;";
            this.busAppsSchemaDao.excuteSql(biz2sql);
            String managersql = "INSERT INTO public.tbtsk_user_manage_area ( f_taskid, f_userid, f_level,f_regioncode)  select ttb.f_id,'" + s + "','" + level + "','" + f_regioncode + "' from tbtsk_task_biz ttb  inner join tbtsk_task_class ttc on (ttb.f_classid =ttc.f_id  ) and ttc.f_appkey ='" + appsId + "' and not exists (select * from tbtsk_user_manage_area a where a.f_taskid = ttb.f_id and a.f_regioncode ='" + f_regioncode + "' and a.f_userid ='" + s + "' and a.f_level ='" + level + "');";
            this.busAppsSchemaDao.excuteSql(managersql);
        }
    }

    public void publishBusApplication(String appsId) {
        BusAppsInfoPo busAppsInfoPo = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)appsId));
        if (busAppsInfoPo.getIsFinish() != 1) {
            throw new GwValidateException("\u914d\u7f6e\u672a\u5b8c\u6210\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        }
        busAppsInfoPo.setStage(Integer.valueOf(1));
        busAppsInfoPo.setStatus(Integer.valueOf(0));
        this.busAppsInfoDao.gwUpdateByPK((GiEntityAlterable)busAppsInfoPo);
    }

    public void cancelBusApplication(String appsId) {
        BusAppsInfoPo busAppsInfoPo = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)appsId));
        if (busAppsInfoPo.getIsFinish() != 1 || busAppsInfoPo.getStage() != 1 || busAppsInfoPo.getStatus() != 1) {
            throw new GwValidateException("\u4e1a\u52a1\u4efb\u52a1\u9636\u6bb5\u8fd8\u4e0d\u6ee1\u8db3\u4e0b\u67b6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff01");
        }
        busAppsInfoPo.setStage(Integer.valueOf(2));
        busAppsInfoPo.setStatus(Integer.valueOf(0));
        this.busAppsInfoDao.gwUpdateByPK((GiEntityAlterable)busAppsInfoPo);
    }

    public BusAppsApproveRecordPo addBusAppsApproveRecord(String userId, String orgId, BusAppsApproveRecordPo record) throws Exception {
        BusAppsInfoPo busAppsInfoPo = (BusAppsInfoPo)this.busAppsInfoDao.gwSearchByPK((Serializable)((Object)record.getAppsId()));
        record.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.busAppsApproveRecordDao.gwAccessSelective((GiEntitySaveable)record);
        if (record.getApproveStatus() == 1) {
            busAppsInfoPo.setStatus(Integer.valueOf(1));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appsName", busAppsInfoPo.getAppsName());
            params.put("appsDesc", busAppsInfoPo.getAppsDesc());
            params.put("platformUrl", this.appslogin_uri + busAppsInfoPo.getPlatformUrl());
            params.put("bqszdw", busAppsInfoPo.getBqszdw());
            params.put("jszcdw", busAppsInfoPo.getJszcdw());
            params.put("logUrl", busAppsInfoPo.getLogUrl());
            params.put("loginUrl", busAppsInfoPo.getLoginUrl());
            params.put("backgroundUrl", busAppsInfoPo.getBackgroundUrl());
            params.put("userId", busAppsInfoPo.getUserId());
            params.put("busAppId", busAppsInfoPo.getId());
            params.put("redirectUri", this.loginBack_uri);
            params.put("writeoffUrl", this.logout_uri);
            JSONObject jsonObject = UserAuthHttpUtils.accessAppsInterface(this.createAppInfo_uri, params);
            if (jsonObject != null) {
                String appKey = jsonObject.getString("appKey");
                String appSecret = jsonObject.getString("appSecret");
                String appId = jsonObject.getString("appId");
                if (StringUtils.isNotBlank((CharSequence)appKey)) {
                    BusAppsConfigPo busAppsConfigPo = new BusAppsConfigPo();
                    busAppsConfigPo.setAppKey(appKey);
                    busAppsConfigPo.setAppSecret(appSecret);
                    busAppsConfigPo.setAppsId(busAppsInfoPo.getId());
                    busAppsConfigPo.setDesc(busAppsInfoPo.getAppsName());
                    busAppsConfigPo.setDataId(appId);
                    this.busAppsConfigDao.gwAccessSelective((GiEntitySaveable)busAppsConfigPo);
                }
            }
        } else if (record.getApproveStatus() == 2) {
            busAppsInfoPo.setStatus(Integer.valueOf(2));
        }
        busAppsInfoPo.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.busAppsInfoDao.gwUpdateByPKSelective((GiEntityAlterable)busAppsInfoPo);
        return record;
    }

    public List<BusAppsInfoDto> loginInfo(String platformUrl) {
        List list = this.busAppsInfoDao.findByPlatformUrl(platformUrl);
        return list;
    }

    public int getCount(String primaryField, String Fid) {
        return this.busAppsInfoDao.getCount(primaryField, Fid);
    }

    private String getSchemaName(String schemaName) {
        Integer count;
        String alias = schemaName;
        String pinYin = BusAppsInfoServiceImpl.getFirstSpell(alias);
        if (pinYin.length() > 8) {
            pinYin = pinYin.substring(0, 8);
        }
        if ((count = this.busAppsSchemaDao.excuteCountSql((pinYin = "business_apps_" + pinYin) + "%")) > 0) {
            pinYin = pinYin + "_" + (count + 1);
        }
        return pinYin;
    }

    public static String getFirstSpell(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination var6) {
                    var6.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }
}

