/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.businessapps;

import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionDao;
import com.geoway.landteam.landcloud.dao.businessapps.BusFunctionModuleDao;
import com.geoway.landteam.landcloud.model.businessapps.dto.BusFunctionDto;
import com.geoway.landteam.landcloud.model.businessapps.entity.BusFunctionPo;
import com.geoway.landteam.landcloud.model.businessapps.seo.BusFunctionSeo;
import com.geoway.landteam.landcloud.servface.businessapps.BusFunctionService;
import com.gw.base.gpa.entity.GiEntityAlterable;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BusFunctionServiceImpl
implements BusFunctionService {
    @Autowired
    private BusFunctionDao busFunctionDao;
    @Autowired
    private BusFunctionModuleDao busFunctionModuleDao;

    public List<BusFunctionDto> findBusFunctions(BusFunctionSeo seo) {
        return this.busFunctionDao.searchList(seo);
    }

    public List<BusFunctionDto> findBusFunctionsByappId(String appsId) {
        return this.busFunctionDao.findBusFunctionsByappId(appsId);
    }

    public List<BusFunctionDto> findBusFunctionAndModulesByappId(String appsId) {
        List busFunctionDtos = this.busFunctionDao.findBusFunctionsByappId(appsId);
        for (BusFunctionDto bean : busFunctionDtos) {
            List busFunctionModuleDtos = this.busFunctionModuleDao.findByFunctionId(bean.getId());
            bean.setBusFunctionModuleList(busFunctionModuleDtos);
        }
        return busFunctionDtos;
    }

    public BusFunctionPo updateFunctionName(String functionId, String functionName) {
        BusFunctionPo busFunctionPo = (BusFunctionPo)this.busFunctionDao.gwSearchByPK((Serializable)((Object)functionId));
        busFunctionPo.setFunctionName(functionName);
        this.busFunctionDao.gwUpdateByPKSelective((GiEntityAlterable)busFunctionPo);
        return busFunctionPo;
    }
}

