/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.cffx;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TaskRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskDataLogService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.dao.cffx.CffxTaskDao;
import com.geoway.landteam.landcloud.dao.cffx.CffxTaskDetailDao;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDataDto;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailConfig;
import com.geoway.landteam.landcloud.model.cffx.dto.CffxDetailInfo;
import com.geoway.landteam.landcloud.model.cffx.enm.CffxStateEnum;
import com.geoway.landteam.landcloud.model.cffx.entity.CffxTask;
import com.geoway.landteam.landcloud.model.cffx.entity.CffxTaskDetail;
import com.geoway.landteam.landcloud.servface.cffx.MCffxTaskService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.geotools.data.Query;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MCffxTaskServiceImpl
implements MCffxTaskService {
    private final GiLoger logger = GwLoger.getLoger(MCffxTaskServiceImpl.class);
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    SysConfigRepository sysConfigRepository;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TaskRecordRepository taskRecordRepository;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    TbtskDataLogService tbtskDataLogService;
    @Autowired
    CffxTaskDetailDao cffxTaskDetailDao;
    @Autowired
    CffxTaskDao cffxTaskDao;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    String uploadDir;
    String param;
    final String sysConfigKey = "cffxconfig";
    WKTReader wktReader = new WKTReader();

    public CffxConfig getConfig() {
        SysConfig config = this.sysConfigRepository.queryByKey("cffxconfig");
        CffxConfig cffxConfig = null;
        if (config != null) {
            cffxConfig = (CffxConfig)JSONObject.parseObject((String)config.getValue(), CffxConfig.class);
        }
        return cffxConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCffxTask(TaskRecord record) {
        HttpURLConnection httpURLConnection = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap dataUploadLog = new HashMap();
        TskTaskBiz task = null;
        Long userId = null;
        String tempTable = "";
        try {
            JSONObject paramsObject = JSONObject.parseObject((String)record.getParam());
            String uploadurl = this.temporarySignedUrlService.getTemporarySignedUrl("", paramsObject.getString("unzipFileDir"), null);
            userId = paramsObject.getLong("userId");
            URL url = new URL(uploadurl);
            URLConnection urlConnection = url.openConnection();
            httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(600000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            URLConnection con = url.openConnection();
            File zipFile = null;
            this.uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            File dir = new File(this.uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            zipFile = File.createTempFile("tmp", ".gty", dir);
            FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)zipFile);
            String zipName = zipFile.getAbsolutePath();
            String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
            Zip4jUtils.unzip((String)zipName, (String)unzipFileDir, (String)"gtdcy2019");
            tempTable = "cffx_temp_" + StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)"");
            if (!this.importData(record, unzipFileDir, tempTable)) {
                record.setState(JobConstants.JOB_STATE_FAILED);
                record.setRemark("\u91cd\u590d\u5206\u6790\u5bfc\u5165\u6570\u636e\u5230\u4e34\u65f6\u8868\u5931\u8d25");
                this.jdbcTemplate.execute("drop table " + tempTable);
                this.taskRecordRepository.gwUpdateByPK((GiEntityAlterable)record);
            }
            ArrayList<CffxTaskDetail> taskDetails = new ArrayList<CffxTaskDetail>();
            String taskId = paramsObject.getString("taskId");
            task = this.tskTaskBizService.findByTaskId(taskId);
            String cffxId = UUID.randomUUID().toString();
            CffxTask cffxTask = new CffxTask();
            cffxTask.setId(cffxId);
            cffxTask.setName(task.getName() + "\u5165\u5e93\u91cd\u590d\u5224\u65ad");
            cffxTask.setParam("");
            cffxTask.setState(CffxStateEnum.create.getCode());
            cffxTask.setCreateTime(new Date());
            cffxTask.setLeftName(tempTable);
            cffxTask.setProgress(Integer.valueOf(0));
            cffxTask.setRecordId(record.getId());
            cffxTask.setRelId(taskId);
            cffxTask.setUserId(userId);
            CffxConfig config = this.getConfig();
            CffxDetailConfig detailConfig = this.getDetailConfig(config, taskId);
            TbtskObjectinfo objectinfo = this.tskTaskBizService.getTableByTableId(task.getTableId());
            if (detailConfig.isSelf()) {
                CffxTaskDetail detail = new CffxTaskDetail();
                detail.setId(UUID.randomUUID().toString());
                detail.setState(CffxStateEnum.create.getCode());
                detail.setTaskId(cffxId);
                detail.setCreateTime(new Date());
                detail.setName(task.getName() + "-\u5185\u90e8\u91cd\u590d\u5224\u65ad");
                detail.setResultName("cffx_" + StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)""));
                detail.setRightName(objectinfo.getfTablename());
                taskDetails.add(detail);
            }
            if (detailConfig.isOther()) {
                for (CffxDataDto dataDto : detailConfig.getOthers()) {
                    CffxTaskDetail detail = new CffxTaskDetail();
                    detail.setId(UUID.randomUUID().toString());
                    detail.setState(CffxStateEnum.create.getCode());
                    detail.setTaskId(cffxId);
                    detail.setCreateTime(new Date());
                    detail.setName(task.getName() + "-" + dataDto.getAlias() + "-\u91cd\u590d\u5224\u65ad");
                    detail.setResultName("cffx_" + StringUtils.replace((String)UUID.randomUUID().toString(), (String)"-", (String)""));
                    detail.setRightName(dataDto.getName());
                    taskDetails.add(detail);
                }
            }
            this.insertCffxTask(cffxTask, taskDetails);
        }
        catch (Exception e) {
            if (StringUtils.isNotBlank((CharSequence)tempTable)) {
                this.jdbcTemplate.execute("drop table " + tempTable);
            }
            record.setEndtime(new Date());
            record.setState(JobConstants.JOB_STATE_FAILED);
            String msg = ExceptionUtils.getStackTrace((Throwable)e);
            this.logger.error("rateJobDataCffxCreateTask error " + msg, new Object[0]);
            if (msg.length() > 1000) {
                msg = msg.substring(0, 1000);
            }
            record.setRemark(msg);
            this.taskRecordService.save(record);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.logger.info("JobRunTask-rateJobCffx \u5e73\u53f0\u4efb\u52a1\u6570\u636e\u52a0\u8f7d\u91cd\u590d\u5206\u6790\u6267\u884c\u7ed3\u675f" + record.getId() + "-" + record.getState() + "-" + df.format(new Date()), new Object[0]);
        }
    }

    public void startCffxTask(CffxTask task) {
        block19: {
            try {
                CffxConfig cffxConfig = this.getConfig();
                if (!task.getState().equals(CffxStateEnum.create.getCode())) break block19;
                CffxTaskDetail search = new CffxTaskDetail();
                search.setTaskId(task.getId());
                List taskDetails = this.cffxTaskDetailDao.gwSearch((GiEntityQueryable)search);
                if (taskDetails == null || taskDetails.isEmpty()) {
                    task.setState(CffxStateEnum.error.getCode());
                    task.setProgress(Integer.valueOf(0));
                    this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                    return;
                }
                String db = this.getDB();
                for (CffxTaskDetail detail : taskDetails) {
                    if (detail.getState().equals(CffxStateEnum.create.getCode())) {
                        if (!TableUtil.hasField(detail.getRightName(), "aid", this.jdbcTemplate)) {
                            TableUtil.createSequence(detail.getRightName(), "aid", detail.getRightName() + "_seq", this.jdbcTemplate);
                        }
                        if (StringUtils.isBlank((CharSequence)this.param)) {
                            this.param = this.getTemplate();
                        }
                        String curParam = this.param;
                        HashMap<String, String> mapParam = new HashMap<String, String>();
                        mapParam.put("{left}", db + "/" + task.getLeftName());
                        mapParam.put("{leftPkField}", "aid");
                        mapParam.put("{leftShapeField}", "f_shape");
                        mapParam.put("{leftWhere}", "1=1");
                        mapParam.put("{right}", db + "/" + detail.getRightName());
                        mapParam.put("{rightPkField}", "aid");
                        mapParam.put("{rightShapeField}", "f_shape");
                        mapParam.put("{rightWhere}", "1=1");
                        mapParam.put("{result}", detail.getResultName());
                        mapParam.put("{resultdb}", db + "/" + detail.getResultName());
                        for (Map.Entry kv : mapParam.entrySet()) {
                            curParam = curParam.replace((CharSequence)kv.getKey(), (CharSequence)kv.getValue());
                        }
                        this.logger.info("cffx service url:" + cffxConfig.getServiceUrl() + " param:" + curParam, new Object[0]);
                        String result = HttpUtil.createPost((String)cffxConfig.getServiceUrl()).body(curParam).execute().body();
                        this.logger.info("cffx service url:" + cffxConfig.getServiceUrl() + " http result: " + result, new Object[0]);
                        if (StringUtils.isBlank((CharSequence)result)) {
                            detail.setState(CffxStateEnum.error.getCode());
                            detail.setMsg("\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                            detail.setEndTime(new Date());
                            this.logger.error("\u91cd\u590d\u5206\u6790\u5b50\u4efb\u52a1:" + detail.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25", new Object[0]);
                        } else {
                            JSONObject resultJson = JSONObject.parseObject((String)result);
                            if (resultJson.containsKey((Object)"code") && resultJson.getString("code").equals("200")) {
                                String taskId = resultJson.getJSONObject("data").getString("taskId");
                                if (StringUtils.isNotBlank((CharSequence)taskId)) {
                                    detail.setAtlasId(taskId);
                                    detail.setState(CffxStateEnum.runing.getCode());
                                } else {
                                    detail.setState(CffxStateEnum.error.getCode());
                                    detail.setMsg("\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                                    detail.setEndTime(new Date());
                                    this.logger.error("\u91cd\u590d\u5206\u6790\u5b50\u4efb\u52a1:" + detail.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25," + result, new Object[0]);
                                }
                            } else {
                                detail.setState(CffxStateEnum.error.getCode());
                                detail.setMsg("\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                                detail.setEndTime(new Date());
                                this.logger.error("\u91cd\u590d\u5206\u6790\u5b50\u4efb\u52a1:" + detail.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25," + result, new Object[0]);
                            }
                        }
                        this.cffxTaskDetailDao.gwUpdateByPK((GiEntityAlterable)detail);
                        continue;
                    }
                    if (!detail.getState().equals(CffxStateEnum.runing.getCode()) && !detail.getState().equals(CffxStateEnum.error.getCode()) && !detail.getState().equals(CffxStateEnum.success.getCode())) continue;
                }
                if (taskDetails.stream().allMatch(t -> t.getState().equals(CffxStateEnum.success.getCode()))) {
                    task.setState(CffxStateEnum.success.getCode());
                    task.setProgress(Integer.valueOf(100));
                    this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                } else if (taskDetails.stream().anyMatch(t -> t.getState().equals(CffxStateEnum.error.getCode()))) {
                    task.setState(CffxStateEnum.error.getCode());
                    this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                } else {
                    task.setState(CffxStateEnum.runing.getCode());
                    this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                }
            }
            catch (Exception ex) {
                String msg = "\u91cd\u590d\u5206\u6790\u4efb\u52a1:" + task.getId() + "\u542f\u52a8\u4efb\u52a1\u5f02\u5e38";
                if (ex != null && StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                    msg = msg + "," + ex.getMessage();
                }
                this.logger.error(msg + "\n" + ExceptionUtils.getStackTrace((Throwable)ex), new Object[]{ex});
                task.setState(CffxStateEnum.error.getCode());
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            }
        }
    }

    public void progressQuery(CffxTask task) {
        try {
            CffxConfig cffxConfig = this.getConfig();
            CffxTaskDetail search = new CffxTaskDetail();
            search.setTaskId(task.getId());
            List taskDetails = this.cffxTaskDetailDao.gwSearch((GiEntityQueryable)search);
            if (taskDetails == null || taskDetails.isEmpty()) {
                task.setState(CffxStateEnum.error.getCode());
                task.setProgress(Integer.valueOf(0));
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                return;
            }
            int sucCount = 0;
            int errorCount = 0;
            for (CffxTaskDetail detail : taskDetails) {
                String atlasUrl = cffxConfig.getAtlasUrl();
                atlasUrl = atlasUrl + "/atlas/task/get?id=" + detail.getAtlasId();
                this.logger.info("cffx atlas task url:" + atlasUrl, new Object[0]);
                String result = HttpUtil.createGet((String)atlasUrl).execute().body();
                if (StringUtils.isBlank((CharSequence)result)) {
                    this.logger.error("\u91cd\u590d\u5206\u6790\u4efb\u52a1:" + detail.getId() + "\u83b7\u53d6\u5206\u6790\u4efb\u52a1\u8fdb\u5ea6\u4fe1\u606f\u5931\u8d25", new Object[0]);
                    continue;
                }
                JSONObject resultJson = JSONObject.parseObject((String)result);
                String state = "";
                Boolean flag = false;
                if (!resultJson.containsKey((Object)"State") || !resultJson.containsKey((Object)"IsSucceed")) {
                    this.logger.info("\u91cd\u590d\u5206\u6790\u4efb\u52a1:" + detail.getId() + "\u5206\u6790\u4efb\u52a1\u6682\u672a\u5b8c\u6210", new Object[0]);
                    continue;
                }
                state = resultJson.getString("State");
                flag = resultJson.getBoolean("IsSucceed");
                if (!state.equalsIgnoreCase("finished")) {
                    this.logger.info("\u91cd\u590d\u5206\u6790\u4efb\u52a1:" + detail.getId() + "\u5206\u6790\u4efb\u52a1\u6682\u672a\u5b8c\u6210", new Object[0]);
                    continue;
                }
                if (!flag.booleanValue()) {
                    detail.setState(CffxStateEnum.error.getCode());
                    ++errorCount;
                } else {
                    detail.setState(CffxStateEnum.success.getCode());
                    ++sucCount;
                }
                this.cffxTaskDetailDao.gwUpdateByPK((GiEntityAlterable)detail);
            }
            if (taskDetails.size() == sucCount) {
                task.setState(CffxStateEnum.success.getCode());
                task.setProgress(Integer.valueOf(100));
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            } else if (errorCount > 0) {
                task.setState(CffxStateEnum.error.getCode());
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            } else {
                task.setProgress(Integer.valueOf(sucCount * 100 / taskDetails.size()));
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            }
        }
        catch (Exception ex) {
            String msg = "\u91cd\u590d\u5206\u6790\u4efb\u52a1:" + task.getId() + "\u67e5\u8be2\u8fdb\u5ea6\u5f02\u5e38";
            if (ex != null && StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                msg = msg + "," + ex.getMessage();
            }
            this.logger.error(msg + "\n" + ExceptionUtils.getStackTrace((Throwable)ex), new Object[]{ex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCfLog(CffxTask task) {
        block26: {
            CffxConfig config = this.getConfig();
            CffxDetailConfig detailConfig = this.getDetailConfig(config, task.getRelId());
            TaskRecord taskRecord = null;
            List taskDetails = null;
            try {
                CffxTaskDetail search = new CffxTaskDetail();
                search.setTaskId(task.getId());
                taskDetails = this.cffxTaskDetailDao.gwSearch((GiEntityQueryable)search);
                taskRecord = this.taskRecordService.findOne(task.getRecordId());
                if (task.getState().equals(CffxStateEnum.error.getCode())) {
                    task.setState(CffxStateEnum.writeLogErr.getCode());
                    this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                    taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                    taskRecord.setLog("\u91cd\u590d\u5206\u6790\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                    this.taskRecordRepository.gwUpdateByPK((GiEntityAlterable)taskRecord);
                    break block26;
                }
                if (!task.getState().equals(CffxStateEnum.success.getCode())) break block26;
                task.setState(CffxStateEnum.writeLogErr.getCode());
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                if (taskDetails == null || taskDetails.isEmpty()) {
                    taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                    taskRecord.setLog("\u91cd\u590d\u8f93\u51fa\u65e5\u5fd7\u5206\u6790\u5931\u8d25\uff0c\u91cd\u590d\u5206\u6790\u65e0\u5b50\u4efb\u52a1");
                    this.taskRecordRepository.gwUpdateByPK((GiEntityAlterable)taskRecord);
                    return;
                }
                JSONObject paramsObject = JSONObject.parseObject((String)taskRecord.getParam());
                String taskId = paramsObject.getString("taskId");
                Long userId = paramsObject.getLongValue("userId");
                String uesrName = this.landUserRepository.queryUserById(userId).getName();
                TskTaskBiz tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
                TbtskObjectinfo tableInfo = this.tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
                List uniqueFields = this.tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), Integer.valueOf(1));
                String where = "";
                ArrayList<String> filters = new ArrayList<String>();
                if (detailConfig.getMinIntersectArea() != null) {
                    filters.add("shapearean >= " + detailConfig.getMinIntersectArea());
                }
                if (detailConfig.getMinIntersectRateSelf() != null) {
                    filters.add("leftsparkrate >= " + detailConfig.getMinIntersectRateSelf());
                }
                if (detailConfig.getMinIntersectRateOther() != null) {
                    filters.add("rightsparkrate >= " + detailConfig.getMinIntersectRateOther());
                }
                if (StringUtils.isBlank((CharSequence)(where = StringUtils.join(filters, (String)" and ")))) {
                    where = " 1 = 1";
                }
                ArrayList<Map<String, Object>> cftbRecords = new ArrayList<Map<String, Object>>();
                ArrayList<String> col = new ArrayList<String>();
                ArrayList<String> colAlias = new ArrayList<String>();
                col.add("rightname");
                colAlias.add("\u91cd\u590d\u56fe\u5c42");
                String queryLeftFields = "";
                for (TbtskFields f : uniqueFields) {
                    col.add(f.getfFieldname() + "_1");
                    colAlias.add("\u5165\u5e93\u6570\u636e" + f.getfAlias());
                    queryLeftFields = queryLeftFields + f.getfFieldname() + "_1,";
                }
                queryLeftFields = queryLeftFields.substring(0, queryLeftFields.length() - 1);
                col.add("rightPkField_2");
                colAlias.add("\u91cd\u590d\u56fe\u5c42\u56fe\u6591ID");
                col.add("shapearean");
                colAlias.add("\u91cd\u590d\u9762\u79ef");
                col.add("leftsparkrate");
                colAlias.add("\u91cd\u590d\u6bd4\u4f8b1");
                col.add("rightsparkrate");
                colAlias.add("\u91cd\u590d\u6bd4\u4f8b2");
                col.add("uploadUser");
                colAlias.add("\u4e0a\u4f20\u7528\u6237");
                col.add("msg");
                colAlias.add("\u91cd\u590d\u4fe1\u606f");
                for (CffxTaskDetail detail : taskDetails) {
                    String filter = where;
                    String resultTable = detail.getResultName();
                    String rightTable = detail.getRightName();
                    String rightAlias = "";
                    String rightPkField = "";
                    Optional<CffxDataDto> opRightData = detailConfig.getOthers().stream().filter(t -> t.getName().equals(rightTable)).findFirst();
                    if (opRightData.isPresent()) {
                        rightPkField = opRightData.get().getPkField();
                        rightAlias = opRightData.get().getAlias();
                    } else {
                        Optional<CffxDataDto> opSelfData = null;
                        if (detailConfig.getSelfs() != null) {
                            opSelfData = detailConfig.getSelfs().stream().filter(t -> t.getName().equals(rightTable)).findFirst();
                        }
                        if (opSelfData.isPresent()) {
                            rightPkField = ((CffxDataDto)opSelfData.get()).getPkField();
                            rightAlias = opSelfData.get().getAlias();
                        } else {
                            rightPkField = "f_id";
                            rightAlias = tskTaskBiz.getName();
                        }
                        for (TbtskFields f : uniqueFields) {
                            filter = filter + " and " + f.getfFieldname() + "_1 != " + f.getfFieldname() + "_2";
                        }
                    }
                    String countSql = String.format("select count(*) as count from %s where %s", resultTable, filter);
                    Map mapCount = this.jdbcTemplate.queryForMap(countSql);
                    int count = Integer.parseInt(mapCount.get("count").toString());
                    if (count == 0) continue;
                    String sql = String.format("select %s,%s as rightPkField_2,%s,%s,%s from %s where %s", queryLeftFields, rightPkField + "_2", "shapearean", "leftsparkrate", "rightsparkrate", resultTable, filter);
                    int page = (int)Math.ceil((double)count * 1.0 / 1000.0);
                    for (int i = 0; i < page; ++i) {
                        int offset = i * 1000;
                        String pageSql = sql + " order by shapearean desc limit " + 1000 + " offset " + offset;
                        List maps = this.jdbcTemplate.queryForList(pageSql);
                        for (Map map : maps) {
                            map.put("rightname", rightAlias);
                            map.put("msg", "\u5f85\u5165\u5e93\u56fe\u6591\u91cd\u590d");
                            map.put("uploadUser", uesrName);
                        }
                        cftbRecords.addAll(maps);
                    }
                }
                if (!cftbRecords.isEmpty()) {
                    this.writeExcel(cftbRecords, col, colAlias, tskTaskBiz.getName(), tskTaskBiz.getId(), userId);
                    taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                    taskRecord.setLog("\u5b58\u5728\u91cd\u590d\u6570\u636e,\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u6587\u4ef6");
                    this.taskRecordService.save(taskRecord);
                } else {
                    taskRecord.setState(JobConstants.JOB_STATE_CREATE);
                    this.taskRecordService.save(taskRecord);
                }
                task.setState(CffxStateEnum.writeLogSuc.getCode());
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            }
            catch (Exception ex) {
                String msg = "\u91cd\u590d\u5206\u6790\u5199excel\u65e5\u5fd7\u5f02\u5e38" + ExceptionUtils.getStackTrace((Throwable)ex);
                if (msg.length() > 1000) {
                    msg = msg.substring(0, 1000);
                }
                taskRecord.setState(JobConstants.JOB_STATE_FAILED);
                taskRecord.setRemark(msg);
                this.taskRecordService.save(taskRecord);
                task.setState(CffxStateEnum.writeLogErr.getCode());
                this.cffxTaskDao.gwUpdateByPK((GiEntityAlterable)task);
            }
            finally {
                TableUtil.dropTable(task.getLeftName(), this.jdbcTemplate);
                if (taskDetails == null || taskDetails.isEmpty()) break block26;
                for (CffxTaskDetail detail : taskDetails) {
                    TableUtil.dropTable(detail.getResultName(), this.jdbcTemplate);
                }
            }
        }
    }

    @Transactional
    public void insertCffxTask(CffxTask cffxTask, List<CffxTaskDetail> details) {
        this.cffxTaskDetailDao.insertBatch(details);
        this.cffxTaskDao.gwAccess((GiEntitySaveable)cffxTask);
    }

    public List<CffxTask> list(Integer state) {
        CffxTask search = new CffxTask();
        search.setState(state);
        return this.cffxTaskDao.gwSearch((GiEntityQueryable)search);
    }

    public CffxDetailConfig getDetailConfig(CffxConfig config, String taskId) {
        CffxDetailConfig detailConfig = null;
        List cffxDetailConfigs = config.getDetailConfigs();
        for (CffxDetailConfig dconfig : cffxDetailConfigs) {
            List cffxDataDtos = dconfig.getSelfs();
            if (cffxDataDtos == null || cffxDataDtos.isEmpty()) {
                detailConfig = dconfig;
                break;
            }
            if (!cffxDataDtos.stream().filter(t -> t.getId().equalsIgnoreCase(taskId)).findFirst().isPresent()) continue;
            detailConfig = dconfig;
            break;
        }
        return detailConfig;
    }

    public CffxDetailInfo cffx(Map<String, Object> map, CffxDetailConfig detailConfig, TskTaskBiz task, String splitTableName) {
        String id;
        String shape;
        String string = shape = map.get("f_shape") == null ? null : map.get("f_shape").toString();
        if (StringUtils.isBlank((CharSequence)shape)) {
            return null;
        }
        String sourceTableName = null;
        String pkField = null;
        if (StringUtils.isNotBlank((CharSequence)splitTableName)) {
            sourceTableName = splitTableName;
        } else {
            TbtskObjectinfo tableByTableId = this.tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
            sourceTableName = tableByTableId.getfTablename();
        }
        if (detailConfig.getSelfs() == null || detailConfig.getSelfs().isEmpty()) {
            pkField = "f_id";
        } else {
            CffxDataDto cffxDataDto = detailConfig.getSelfs().stream().filter(t -> t.getId().equals(task.getId())).findFirst().get();
            pkField = cffxDataDto.getPkField();
        }
        String string2 = id = map.get("f_id") == null ? null : map.get("f_id").toString();
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        String tbName = id;
        if (!pkField.equalsIgnoreCase("f_id")) {
            if (map.containsKey(pkField)) {
                tbName = map.get(pkField) == null ? "" : map.get(pkField).toString();
            } else {
                Map tbNameMap = this.jdbcTemplate.queryForMap(String.format("select %s from %s where f_id = '%s'", pkField, sourceTableName, id));
                if (tbNameMap != null) {
                    tbName = tbNameMap.get(pkField) == null ? "" : tbNameMap.get(pkField).toString();
                }
            }
        }
        try {
            Geometry geometry;
            if (shape.toLowerCase().startsWith("srid=4490;")) {
                shape = StringUtils.split((String)shape, (String)";")[1];
            }
            if (!(geometry = this.wktReader.read(shape)).isValid()) {
                CffxDetailInfo result = new CffxDetailInfo();
                result.setTbName(tbName);
                result.setMsg("\u56fe\u6591:" + tbName + "\u5b58\u5728\u62d3\u6251\u9519\u8bef");
                return result;
            }
        }
        catch (Exception ex) {
            this.logger.error("\u56fe\u6591\u91cd\u590d\u5206\u6790\u5f02\u5e38", new Object[]{ex});
            CffxDetailInfo result = new CffxDetailInfo();
            result.setTbName(tbName);
            result.setMsg("\u56fe\u6591:" + tbName + "\u5b58\u5728\u62d3\u6251\u9519\u8bef");
            return result;
        }
        if (detailConfig.isSelf()) {
            String sql = String.format("select %s from %s where st_intersects(st_geometryfromtext(?,4490),f_shape)=true and f_id not in ('%s')", pkField, sourceTableName, id);
            Object[] args = new Object[]{shape};
            final ArrayList cftb = new ArrayList();
            final String finalPkField = pkField;
            this.jdbcTemplate.query(sql, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    cftb.add(rs.getString(finalPkField));
                }
            }, args);
            if (!cftb.isEmpty()) {
                CffxDetailInfo result = new CffxDetailInfo();
                result.setCfTaskTbName(cftb);
                result.setTbName(tbName);
                result.setCfTaskName(task.getName());
                result.setCfTaskTbName(cftb);
                result.setMsg("\u56fe\u6591:" + tbName + "\u4e0e[" + StringUtils.join(cftb, (String)",") + "]\u51b2\u7a81");
                return result;
            }
        }
        if (detailConfig.isOther()) {
            for (CffxDataDto data : detailConfig.getOthers()) {
                String sql = String.format("select %s from %s where st_intersects(st_geometryfromtext(?,4490),f_shape)=true", data.getPkField(), data.getName());
                Object[] args = new Object[]{shape};
                final ArrayList cftb = new ArrayList();
                final String finalPkField = pkField;
                this.jdbcTemplate.query(sql, new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        cftb.add(rs.getString(finalPkField));
                    }
                }, args);
                if (cftb.isEmpty()) continue;
                CffxDetailInfo result = new CffxDetailInfo();
                result.setCfTaskTbName(cftb);
                result.setTbName(tbName);
                result.setCfTaskName(data.getAlias());
                result.setCfTaskTbName(cftb);
                result.setMsg("\u56fe\u6591:" + tbName + "\u4e0e\u4efb\u52a1:" + data.getAlias() + "\u56fe\u6591[" + StringUtils.join(cftb, (String)",") + "]\u51b2\u7a81");
                return result;
            }
        }
        return null;
    }

    private void writeExcel(List<Map<String, Object>> cftbRecords, List<String> col, List<String> colName, String taskName, String taskId, Long userId) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = taskName + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + System.currentTimeMillis() + ".xls";
        String fileName1 = taskName + "-\u6570\u636e\u5bfc\u5165\u65e5\u5fd7-" + new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss").format(new Date()) + ".xls";
        String filePath = null;
        try {
            filePath = ExcelUtil.CreateExcel(cftbRecords, (String)tempDir, (String)fileName, (String)StringUtils.join(col, (String)","), (String)StringUtils.join(colName, (String)","), (String)"\u65e5\u5fd7\u5bfc\u51fa");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sendObjName = "taskManagerUploadLog/" + fileName1;
        String downloadPath = this.ossOperatorService.sendObject2Oss(sendObjName, filePath);
        TbtskDataLog tbtskDataLog = new TbtskDataLog();
        tbtskDataLog.setCreateTime(new Date());
        tbtskDataLog.setLogUrl(downloadPath);
        tbtskDataLog.setName(fileName1);
        tbtskDataLog.setTaskId(taskId);
        tbtskDataLog.setUserId(userId.toString());
        this.tbtskDataLogService.saveDataLog(tbtskDataLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importData(TaskRecord record, String unzipFileDir, String tempTable) {
        File zipFile = null;
        File unzipFile = null;
        try {
            JSONObject param = JSONObject.parseObject((String)record.getParam());
            unzipFile = new File(unzipFileDir);
            List content = Arrays.stream(unzipFile.listFiles()).collect(Collectors.toList());
            Optional<File> opShp = content.stream().filter(t -> t.getPath().endsWith(".shp")).findFirst();
            URL url = opShp.get().toURI().toURL();
            int totalcount = 0;
            int importcount = 0;
            ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
            ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
            Query query = new Query();
            if ((totalcount += featureSource.getCount(query)) == 0) {
                boolean bl = false;
                return bl;
            }
            Map<String, String> mapFields = this.getShpToTableColumns(shpDataStore);
            this.createShpTable(mapFields, this.jdbcTemplate, tempTable);
            List<String> fields = mapFields.keySet().stream().collect(Collectors.toList());
            FeatureCollection collection = featureSource.getFeatures();
            FeatureIterator itertor = collection.features();
            SimpleFeature sf = null;
            ArrayList<Map<String, Object>> tbList = new ArrayList<Map<String, Object>>();
            param.put("totalCount", (Object)totalcount);
            while (itertor.hasNext()) {
                sf = (SimpleFeature)itertor.next();
                Map<String, Object> tb = this.getFromSimpleFeature(sf, fields);
                tbList.add(tb);
                if (tbList.size() != 100) continue;
                this.dataBizService.insertDatasBatch(tempTable, tbList, "f_shape");
                tbList.clear();
                param.put("importCountCffx", (Object)(importcount += 100));
                record.setParam(param.toJSONString());
                this.taskRecordService.save(record);
            }
            if (!tbList.isEmpty()) {
                this.dataBizService.insertDatasBatch(tempTable, tbList, "f_shape");
                tbList.clear();
                param.put("importCountCffx", (Object)(importcount += tbList.size()));
                record.setParam(param.toJSONString());
                this.taskRecordService.save(record);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.logger.error("cffx import shp error", new Object[]{ExceptionUtil.stacktraceToString((Throwable)ex)});
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null && zipFile.exists()) {
                try {
                    zipFile.delete();
                }
                catch (Exception ex) {
                    this.logger.error("\u5220\u9664\u6587\u4ef6:" + zipFile.getPath() + "\u5931\u8d25", new Object[0]);
                }
            }
            if (unzipFile != null && unzipFile.exists()) {
                try {
                    File[] files = unzipFile.listFiles();
                    if (files != null && files.length > 0) {
                        for (File f : files) {
                            f.delete();
                        }
                    }
                    unzipFile.delete();
                }
                catch (Exception ex) {
                    this.logger.error("\u5220\u9664\u6587\u4ef6\u5939:" + unzipFile.getPath() + "\u5931\u8d25", new Object[0]);
                }
            }
        }
    }

    private Map<String, String> getShpToTableColumns(ShapefileDataStore shpDataStore) throws IOException {
        String[] typeNames = shpDataStore.getTypeNames();
        String typeName = typeNames[0];
        SimpleFeatureType featureType = shpDataStore.getSchema(typeName);
        String shapeField = featureType.getGeometryDescriptor().getLocalName();
        String idField = featureType.getGeometryDescriptor().getName().getLocalPart();
        HashMap<String, String> mapFields = new HashMap<String, String>();
        List propertyDescriptors = featureType.getDescriptors().stream().collect(Collectors.toList());
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String fieldName = descriptor.getName().getLocalPart();
            String fieldType = descriptor.getType().getBinding().getSimpleName();
            int fieldLength = 250;
            if (descriptor.getType().getDescription() != null) {
                fieldLength = descriptor.getType().getDescription().length();
            }
            if (fieldName.equals(shapeField)) {
                mapFields.put("f_shape", "public.geometry NOT NULL");
                continue;
            }
            mapFields.put(fieldName, "varchar(" + fieldLength + ") NULL");
        }
        return mapFields;
    }

    private void createShpTable(Map<String, String> mapFields, JdbcTemplate jdbcTemplate, String tableName) {
        jdbcTemplate.execute("CREATE SEQUENCE " + tableName + "_seq");
        String sql = "create table " + tableName + " (";
        sql = sql + "aid int4 NOT NULL DEFAULT nextval('" + tableName + "_seq'::regclass),";
        for (Map.Entry<String, String> kv : mapFields.entrySet()) {
            sql = sql + kv.getKey() + " " + kv.getValue() + ",";
        }
        sql = sql + "CONSTRAINT " + tableName + "_pk PRIMARY KEY (aid)";
        sql = sql + " );ALTER SEQUENCE " + tableName + "_seq OWNED BY " + tableName + ".aid;select updategeometrysrid('" + tableName + "','f_shape',4490)";
        jdbcTemplate.execute(sql);
    }

    private Map<String, Object> getFromSimpleFeature(SimpleFeature sf, List<String> fields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Geometry geo = (Geometry)sf.getDefaultGeometry();
        for (String f : fields) {
            if (f.equals("f_shape")) continue;
            map.put(f, sf.getAttribute(f));
        }
        map.put("f_shape", "SRID=4490;" + WKTUtil.geomToWkt((Geometry)geo));
        return map;
    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/intersect.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u6a21\u578b\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    private String getDB() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split((String)url, (String)"?");
        url = urls[0];
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }

    private class CftbRecord {
        private String leftDataAlias;
        private String rightDataAlias;
        private String leftTbid;
        private String rightTbid;
        private String intersectArea;
        private String intersectLeftRate;
        private String intersectRightRate;
        private String msg;

        private CftbRecord() {
        }

        public String getIntersectArea() {
            return this.intersectArea;
        }

        public String getIntersectLeftRate() {
            return this.intersectLeftRate;
        }

        public String getIntersectRightRate() {
            return this.intersectRightRate;
        }

        public String getLeftDataAlias() {
            return this.leftDataAlias;
        }

        public String getLeftTbid() {
            return this.leftTbid;
        }

        public String getRightDataAlias() {
            return this.rightDataAlias;
        }

        public String getRightTbid() {
            return this.rightTbid;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setIntersectArea(String intersectArea) {
            this.intersectArea = intersectArea;
        }

        public void setIntersectLeftRate(String intersectLeftRate) {
            this.intersectLeftRate = intersectLeftRate;
        }

        public void setIntersectRightRate(String intersectRightRate) {
            this.intersectRightRate = intersectRightRate;
        }

        public void setLeftDataAlias(String leftDataAlias) {
            this.leftDataAlias = leftDataAlias;
        }

        public void setLeftTbid(String leftTbid) {
            this.leftTbid = leftTbid;
        }

        public void setRightDataAlias(String rightDataAlias) {
            this.rightDataAlias = rightDataAlias;
        }

        public void setRightTbid(String rightTbid) {
            this.rightTbid = rightTbid;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }
    }
}

