/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.cgjcyj;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorDomain;
import com.geoway.landteam.landcloud.core.model.pub.entity.EnumeratorValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.service.pub.impl.EnumeratorValueServiceImpl;
import com.geoway.landteam.landcloud.dao.cgjcyj.CgjcyjDlVersionDao;
import com.geoway.landteam.landcloud.dao.cgjcyj.CgjcyjNeighbourTbDao;
import com.geoway.landteam.landcloud.dao.cgjcyj.CgjcyjResultDao;
import com.geoway.landteam.landcloud.dao.cgjcyj.CgjcyjTaskDao;
import com.geoway.landteam.landcloud.dao.cgjcyj.CgjcyjUpdateRecordDao;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjBatchList;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjClueImportRecord;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjConfig;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjResutList;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjSearch;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjShowField;
import com.geoway.landteam.landcloud.model.cgjcyj.dto.CgjcyjTbidbh;
import com.geoway.landteam.landcloud.model.cgjcyj.enm.CgjcyjStateEnum;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjDlVersion;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjNeighbourTb;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjResult;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjTask;
import com.geoway.landteam.landcloud.model.cgjcyj.entity.CgjcyjUpdateRecord;
import com.geoway.landteam.landcloud.servface.cgjcyj.MCgjcyjTaskService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.resultshare.impl.MAnalysisTaskServiceImpl;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueImportTaskRelDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueImportTaskRelFieldsDao;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueTaskRelDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFields;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueTaskRel;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.gw.base.gpa.entity.GiEntityAlterable;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.base.gpa.entity.GiEntitySaveable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class MCgjcyjTaskServiceImpl
implements MCgjcyjTaskService {
    private final GiLoger logger = GwLoger.getLoger(MAnalysisTaskServiceImpl.class);
    @Autowired
    EnumeratorDomainService enumeratorDomainService;
    @Autowired
    EnumeratorValueServiceImpl enumeratorValueService;
    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    MJcClueFieldsService jcClueFieldsService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    CgjcyjTaskDao cgjcyjTaskDao;
    @Autowired
    CgjcyjResultDao cgjcyjResultDao;
    @Autowired
    CgjcyjNeighbourTbDao cgjcyjNeighbourTbDao;
    @Autowired
    CgjcyjDlVersionDao cgjcyjDlVersionDao;
    @Autowired
    CgjcyjUpdateRecordDao cgjcyjUpdateRecordDao;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    JcClueTaskRelDao jcClueTaskRelDao;
    @Autowired
    JcClueImportTaskRelDao jcClueImportTaskRelDao;
    @Autowired
    JcClueImportTaskRelFieldsDao jcClueImportTaskRelFieldsDao;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    final String samepreField = "samepre";
    final String isconnectField = "isconnect";
    final String sysConfigKey = "cgjcyjconfig";
    String param;
    CgjcyjConfig cgjcyjConfig;
    List<EnumeratorDomain> yjdl;
    List<EnumeratorDomain> ejdl;
    List<EnumeratorDomain> jcrw;

    @PostConstruct
    public void init() {
        SysConfig config;
        if (this.cgjcyjConfig == null && (config = this.sysConfigService.findOne("cgjcyjconfig")) != null) {
            this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
        }
    }

    public CgjcyjConfig getConfig() {
        return this.cgjcyjConfig;
    }

    public void UpdateClue(List<Map<String, Object>> updateDatas, JcClueSource clue, String taskId) {
        this.logger.info("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u540c\u6b65\u7ebf\u7d22,\u540c\u6b65\u6570\u91cf:" + updateDatas.size(), new Object[0]);
        if (updateDatas != null && !updateDatas.isEmpty()) {
            ArrayList<String> clueTbids = new ArrayList<String>();
            List ids = updateDatas.stream().map(t -> t.get(this.cgjcyjConfig.getFieldUniqueId()).toString()).collect(Collectors.toList());
            List clueTaskRels = this.jcClueTaskRelDao.getClueTaskRelsByTbids(this.cgjcyjConfig.getRelId(), taskId, ids);
            if (clueTaskRels != null) {
                for (Map<String, Object> m : updateDatas) {
                    String id = m.get(this.cgjcyjConfig.getFieldUniqueId()).toString();
                    Optional<JcClueTaskRel> op = clueTaskRels.stream().filter(t -> t.getfTbid().equals(id)).findFirst();
                    if (!op.isPresent()) continue;
                    clueTbids.add(op.get().getfClueid());
                    m.remove(this.cgjcyjConfig.getFieldUniqueId());
                    this.dataBizService.updateData(clue.getfTablename(), m, this.cgjcyjConfig.getFieldUniqueId() + " = '" + op.get().getfClueid() + "'");
                }
            }
            if (!clueTbids.isEmpty()) {
                String where = this.cgjcyjConfig.getFieldUniqueId() + " in ('" + StringUtils.join(clueTbids, (String)"','") + "')";
                String sql = "select f_sjpc,count(*) as f_count from " + clue.getfTablename() + " where " + where + " group by f_sjpc";
                List maps = this.jdbcTemplate.queryForList(sql);
                if (maps == null || maps.isEmpty()) {
                    return;
                }
                for (Map map : maps) {
                    String sjpc = map.get("f_sjpc").toString();
                    Integer count = Integer.parseInt(map.get("f_count").toString());
                    CgjcyjUpdateRecord updateRecord = (CgjcyjUpdateRecord)this.cgjcyjUpdateRecordDao.gwSearchByPK((Serializable)((Object)sjpc));
                    if (updateRecord == null) {
                        updateRecord = new CgjcyjUpdateRecord();
                        updateRecord.setId(sjpc);
                        updateRecord.setUpdateCount(count);
                        this.cgjcyjUpdateRecordDao.gwAccess((GiEntitySaveable)updateRecord);
                        continue;
                    }
                    updateRecord.setUpdateCount(count);
                    this.cgjcyjUpdateRecordDao.gwUpdateByPK((GiEntityAlterable)updateRecord);
                }
            }
        }
    }

    public Integer getUpdateCount(String batchId) {
        CgjcyjUpdateRecord updateRecord = (CgjcyjUpdateRecord)this.cgjcyjUpdateRecordDao.gwSearchByPK((Serializable)((Object)batchId));
        return updateRecord == null ? 0 : updateRecord.getUpdateCount();
    }

    public CgjcyjTask createCgjcyjTask(String sourceId, String batchId, String sourceName, String userId) throws Exception {
        try {
            if (this.cgjcyjConfig == null) {
                SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
                if (config == null) {
                    this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u4e0d\u5b58\u5728\uff1acgjcyjconfig", new Object[0]);
                    throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((CharSequence)config.getValue())) {
                    throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef");
                }
                this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
            }
            if (!sourceId.equals(this.cgjcyjConfig.getRelId())) {
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef");
            }
            if (this.getUpdateCount(batchId) == 0) {
                throw new Exception("\u6682\u65e0\u6570\u636e\u8fdb\u884c\u9884\u8b66\u5206\u6790");
            }
            this.logger.info("\u7ebf\u7d22:" + sourceId + "[" + sourceName + "]\u542f\u52a8\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u5206\u6790", new Object[0]);
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getServiceUrl())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u5206\u6790\u670d\u52a1\u5730\u5740", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u5206\u6790\u670d\u52a1\u5730\u5740");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldYjdl())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e00\u7ea7\u5730\u7c7b\u5b57\u6bb5", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e00\u7ea7\u5730\u7c7b\u5b57\u6bb5");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldEjdl())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e8c\u7ea7\u5730\u7c7b\u5b57\u6bb5", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e8c\u7ea7\u5730\u7c7b\u5b57\u6bb5");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldTbbh())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7\u5b57\u6bb5", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7\u5b57\u6bb5");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getSameBhSql())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7sql", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7sql");
            }
            if (this.cgjcyjConfig.getBufferMeter() == null || this.cgjcyjConfig.getBufferMeter() <= 0.0) {
                this.cgjcyjConfig.setBufferMeter(Double.valueOf(50.0));
            }
            if (this.cgjcyjConfig.getMaxArea() == null || this.cgjcyjConfig.getMaxArea() <= 0.0) {
                this.cgjcyjConfig.setMaxArea(Double.valueOf(20.0));
            }
            if (this.cgjcyjConfig.getMaxAreaLimit() == null || this.cgjcyjConfig.getMaxAreaLimit() <= 0) {
                this.cgjcyjConfig.setMaxAreaLimit(Integer.valueOf(30));
            }
            CgjcyjTask cgjcyjTask = new CgjcyjTask();
            cgjcyjTask.setId(UUID.randomUUID().toString());
            cgjcyjTask.setName("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66");
            cgjcyjTask.setStatus(Short.valueOf(CgjcyjStateEnum.create.getCode().shortValue()));
            cgjcyjTask.setCreateTime(new Date());
            cgjcyjTask.setClueId(sourceId);
            cgjcyjTask.setUserId(userId);
            cgjcyjTask.setBatchId(batchId);
            cgjcyjTask.setResult("cgjcyj_" + cgjcyjTask.getId());
            this.cgjcyjTaskDao.gwAccess((GiEntitySaveable)cgjcyjTask);
            CgjcyjUpdateRecord record = new CgjcyjUpdateRecord();
            record.setId(this.cgjcyjConfig.getRelId());
            record.setUpdateCount(Integer.valueOf(0));
            this.cgjcyjUpdateRecordDao.gwUpdateByPK((GiEntityAlterable)record);
            return cgjcyjTask;
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1\u5931\u8d25", new Object[]{ex});
            throw new Exception("\u521b\u5efa\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1\u5931\u8d25");
        }
    }

    public CgjcyjTask createCgjcyjTask(String userId, String batchId) {
        try {
            if (this.cgjcyjConfig == null) {
                SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
                if (config == null) {
                    this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u4e0d\u5b58\u5728\uff1acgjcyjconfig", new Object[0]);
                    throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((CharSequence)config.getValue())) {
                    throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef");
                }
                this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
            }
            if (StringUtils.isBlank((CharSequence)batchId)) {
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1\u5931\u8d25,\u672a\u8bbe\u7f6e\u53c2\u6570:batchId");
            }
            if (this.getUpdateCount(batchId) == 0) {
                throw new Exception("\u6682\u65e0\u6570\u636e\u8fdb\u884c\u9884\u8b66\u5206\u6790");
            }
            this.logger.info("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u6279\u6b21:" + batchId + " \u542f\u52a8\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u5206\u6790", new Object[0]);
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getServiceUrl())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u5206\u6790\u670d\u52a1\u5730\u5740", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u5206\u6790\u670d\u52a1\u5730\u5740");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldYjdl())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e00\u7ea7\u5730\u7c7b\u5b57\u6bb5", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e00\u7ea7\u5730\u7c7b\u5b57\u6bb5");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldEjdl())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e8c\u7ea7\u5730\u7c7b\u5b57\u6bb5", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u4e8c\u7ea7\u5730\u7c7b\u5b57\u6bb5");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldTbbh())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7\u5b57\u6bb5", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7\u5b57\u6bb5");
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getSameBhSql())) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7sql", new Object[0]);
                throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e\u9519\u8bef:\u672a\u914d\u7f6e\u76f8\u540c\u7f16\u53f7sql");
            }
            if (this.cgjcyjConfig.getBufferMeter() == null || this.cgjcyjConfig.getBufferMeter() <= 0.0) {
                this.cgjcyjConfig.setBufferMeter(Double.valueOf(50.0));
            }
            if (this.cgjcyjConfig.getMaxArea() == null || this.cgjcyjConfig.getMaxArea() <= 0.0) {
                this.cgjcyjConfig.setMaxArea(Double.valueOf(20.0));
            }
            if (this.cgjcyjConfig.getMaxAreaLimit() == null || this.cgjcyjConfig.getMaxAreaLimit() <= 0) {
                this.cgjcyjConfig.setMaxAreaLimit(Integer.valueOf(30));
            }
            CgjcyjTask cgjcyjTask = new CgjcyjTask();
            cgjcyjTask.setId(UUID.randomUUID().toString());
            cgjcyjTask.setName("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66");
            cgjcyjTask.setStatus(Short.valueOf(CgjcyjStateEnum.create.getCode().shortValue()));
            cgjcyjTask.setCreateTime(new Date());
            cgjcyjTask.setClueId(this.cgjcyjConfig.getRelId());
            cgjcyjTask.setBatchId(batchId);
            cgjcyjTask.setUserId(userId);
            cgjcyjTask.setResult("cgjcyj_" + cgjcyjTask.getId().replace("-", ""));
            this.cgjcyjTaskDao.gwAccess((GiEntitySaveable)cgjcyjTask);
            CgjcyjUpdateRecord record = new CgjcyjUpdateRecord();
            record.setId(batchId);
            record.setUpdateCount(Integer.valueOf(0));
            this.cgjcyjUpdateRecordDao.gwUpdateByPK((GiEntityAlterable)record);
            return cgjcyjTask;
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    public List<CgjcyjTask> getCreateByShard(int total, int index) {
        return this.cgjcyjTaskDao.getCreateByShard(total, index);
    }

    public List<CgjcyjTask> getRunningByShard(int total, int index) {
        return this.cgjcyjTaskDao.getRunningByShard(total, index);
    }

    public boolean startTask(CgjcyjTask task) {
        try {
            JcClueSource jcClueSource;
            List jcCluefields;
            Optional<JcClueFields> opFieldDlbm1;
            if (this.cgjcyjConfig == null) {
                SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
                this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
                if (this.cgjcyjConfig.getBufferMeter() == null || this.cgjcyjConfig.getBufferMeter() <= 0.0) {
                    this.cgjcyjConfig.setBufferMeter(Double.valueOf(50.0));
                }
                if (this.cgjcyjConfig.getMaxArea() == null || this.cgjcyjConfig.getMaxArea() <= 0.0) {
                    this.cgjcyjConfig.setMaxArea(Double.valueOf(20.0));
                }
                if (this.cgjcyjConfig.getMaxAreaLimit() == null || this.cgjcyjConfig.getMaxAreaLimit() <= 0) {
                    this.cgjcyjConfig.setMaxAreaLimit(Integer.valueOf(30));
                }
                if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldPrimary())) {
                    this.cgjcyjConfig.setFieldPrimary("f_id");
                }
            }
            if (!(opFieldDlbm1 = (jcCluefields = this.jcClueFieldsService.findByTableId((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())).getfId())).stream().filter(t -> t.getfFieldname().equals(this.cgjcyjConfig.getFieldYjdl())).findFirst()).isPresent()) {
                this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u65e0\u5730\u7c7b\u7f16\u7801\u5b57\u6bb5:" + this.cgjcyjConfig.getFieldYjdl() + ",\u8bf7\u68c0\u67e5\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e");
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u65e0\u5730\u7c7b\u7f16\u7801\u5b57\u6bb5:" + this.cgjcyjConfig.getFieldYjdl() + ",\u8bf7\u68c0\u67e5\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e", new Object[0]);
                return false;
            }
            Optional<JcClueFields> opFieldDlbm2 = jcCluefields.stream().filter(t -> t.getfFieldname().equals(this.cgjcyjConfig.getFieldEjdl())).findFirst();
            if (!opFieldDlbm2.isPresent()) {
                this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u65e0\u5730\u7c7b\u7f16\u7801\u5b57\u6bb5:" + this.cgjcyjConfig.getFieldEjdl() + ",\u8bf7\u68c0\u67e5\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e");
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u65e0\u5730\u7c7b\u7f16\u7801\u5b57\u6bb5:" + this.cgjcyjConfig.getFieldEjdl() + ",\u8bf7\u68c0\u67e5\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e", new Object[0]);
                return false;
            }
            Optional<JcClueFields> opFieldBh = jcCluefields.stream().filter(t -> t.getfFieldname().equals(this.cgjcyjConfig.getFieldTbbh())).findFirst();
            if (!opFieldBh.isPresent()) {
                this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u65e0\u7f16\u53f7\u5b57\u6bb5:" + this.cgjcyjConfig.getFieldTbbh() + ",\u8bf7\u68c0\u67e5\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e");
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u65e0\u7f16\u53f7\u5b57\u6bb5:" + this.cgjcyjConfig.getFieldTbbh() + ",\u8bf7\u68c0\u67e5\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u914d\u7f6e", new Object[0]);
                return false;
            }
            String where = "";
            where = StringUtils.isBlank((CharSequence)task.getBatchId()) ? String.format("%s is not null or %s is not null", this.cgjcyjConfig.getFieldYjdl(), this.cgjcyjConfig.getFieldEjdl()) : "f_sjpc ='" + task.getBatchId() + "' and (" + String.format("%s is not null or %s is not null", this.cgjcyjConfig.getFieldYjdl(), this.cgjcyjConfig.getFieldEjdl()) + ")";
            if (StringUtils.isBlank((CharSequence)this.param)) {
                this.param = this.getTemplate();
            }
            String curParam = this.param;
            String db = this.getDB();
            String outFields = String.format("%s,%s,%s,%s,%s,%s", this.cgjcyjConfig.getFieldPrimary(), this.cgjcyjConfig.getFieldUniqueId(), this.cgjcyjConfig.getFieldTbbh(), this.cgjcyjConfig.getFieldYjdl(), this.cgjcyjConfig.getFieldEjdl(), this.cgjcyjConfig.getFieldShape());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("{sourcedata}", db + "/" + jcClueSource.getfTablename());
            params.put("{outfields}", outFields);
            params.put("{sourcefilter}", where);
            params.put("{samepre}", "samepre");
            params.put("{samepresql}", this.cgjcyjConfig.getSameBhSql());
            params.put("{buffer}", this.cgjcyjConfig.getBufferMeter() + "m");
            params.put("{isconnect}", "isconnect");
            params.put("{pk}", this.cgjcyjConfig.getFieldPrimary());
            params.put("{result}", task.getResult());
            params.put("{resultdb}", db + "/" + task.getResult());
            for (Map.Entry p : params.entrySet()) {
                curParam = curParam.replace((CharSequence)p.getKey(), (CharSequence)p.getValue());
            }
            this.logger.info("cgjcyj service url:" + this.cgjcyjConfig.getServiceUrl() + " param:" + curParam, new Object[0]);
            String result = HttpUtil.createPost((String)this.cgjcyjConfig.getServiceUrl()).body(curParam).execute().body();
            this.logger.info("cgjcyj service url:" + this.cgjcyjConfig.getServiceUrl() + " http result: " + result, new Object[0]);
            if (StringUtils.isBlank((CharSequence)result)) {
                this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25", new Object[0]);
                return false;
            }
            JSONObject resultJson = JSONObject.parseObject((String)result);
            if (resultJson.containsKey((Object)"code") && resultJson.getString("code").equals("200")) {
                String taskId = resultJson.getJSONObject("data").getString("taskId");
                if (StringUtils.isNotBlank((CharSequence)taskId)) {
                    task.setAnalysisId(taskId);
                    task.setStatus(Short.valueOf(CgjcyjStateEnum.runing.getCode().shortValue()));
                    this.cgjcyjTaskDao.gwUpdateByPK((GiEntityAlterable)task);
                    return true;
                }
                this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25," + result, new Object[0]);
                return false;
            }
            this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25");
            this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u901a\u8fc7\u5206\u6790\u670d\u52a1\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5931\u8d25," + result, new Object[0]);
            return false;
        }
        catch (Exception ex) {
            String msg = "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u521b\u5efa\u5206\u6790\u4efb\u52a1\u5f02\u5e38";
            if (ex != null && StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                msg = msg + "," + ex.getMessage();
            }
            this.cgjcyjTaskDao.startTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), msg);
            this.logger.error(msg + "\n" + this.getStackTraceInfo(ex), new Object[]{ex});
            return false;
        }
    }

    public boolean progressQuery(CgjcyjTask task) {
        try {
            List inserts;
            int totalCount;
            JcClueSource jcClueSource;
            if (this.cgjcyjConfig == null) {
                SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
                this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
            }
            if ((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())) == null) {
                this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728", new Object[0]);
                return false;
            }
            String atlasUrl = this.cgjcyjConfig.getAtlasUrl();
            atlasUrl = atlasUrl + "/atlas/task/get?id=" + task.getAnalysisId();
            this.logger.info("cgjcyj atlas task url:" + atlasUrl, new Object[0]);
            String result = HttpUtil.createGet((String)atlasUrl).execute().body();
            if (StringUtils.isBlank((CharSequence)result)) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u83b7\u53d6\u5206\u6790\u4efb\u52a1\u8fdb\u5ea6\u4fe1\u606f\u5931\u8d25", new Object[0]);
                return false;
            }
            JSONObject resultJson = JSONObject.parseObject((String)result);
            String state = "";
            Boolean flag = false;
            if (!resultJson.containsKey((Object)"State") || !resultJson.containsKey((Object)"IsSucceed")) {
                this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u5206\u6790\u4efb\u52a1\u6682\u672a\u5b8c\u6210", new Object[0]);
                return false;
            }
            state = resultJson.getString("State");
            flag = resultJson.getBoolean("IsSucceed");
            if (!state.equalsIgnoreCase("finished")) {
                return false;
            }
            if (!flag.booleanValue()) {
                this.cgjcyjTaskDao.updateStatus(task.getId(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()));
                return false;
            }
            String resultTable = task.getResult();
            if (this.cgjcyjConfig.getBufferMeter() == null || this.cgjcyjConfig.getBufferMeter() <= 0.0) {
                this.cgjcyjConfig.setBufferMeter(Double.valueOf(50.0));
            }
            if (this.cgjcyjConfig.getMaxArea() == null || this.cgjcyjConfig.getMaxArea() <= 0.0) {
                this.cgjcyjConfig.setMaxArea(Double.valueOf(20.0));
            }
            if (this.cgjcyjConfig.getMaxAreaLimit() == null || this.cgjcyjConfig.getMaxAreaLimit() <= 0) {
                this.cgjcyjConfig.setMaxAreaLimit(Integer.valueOf(30));
            }
            if (StringUtils.isBlank((CharSequence)this.cgjcyjConfig.getFieldPrimary())) {
                this.cgjcyjConfig.setFieldPrimary("f_id");
            }
            List excluteDlbm = null;
            if (StringUtils.isNotBlank((CharSequence)this.cgjcyjConfig.getExcludeDlbm())) {
                excluteDlbm = Arrays.stream(StringUtils.split((String)this.cgjcyjConfig.getExcludeDlbm(), (String)",")).collect(Collectors.toList());
            }
            if ((totalCount = this.dataBizService.getCount(resultTable, "1=1")) == 0) {
                return true;
            }
            int page = (int)Math.ceil((double)totalCount * 1.0 / 500.0);
            List fields = ListUtil.of((Object[])new String[]{this.cgjcyjConfig.getFieldPrimary(), this.cgjcyjConfig.getFieldUniqueId(), this.cgjcyjConfig.getFieldTbbh(), this.cgjcyjConfig.getFieldYjdl(), this.cgjcyjConfig.getFieldEjdl(), "samepre", "isconnect"});
            ArrayList<Temp> temps = new ArrayList<Temp>();
            for (int i = 0; i < page; ++i) {
                List pageResult = this.dataBizService.queryPageData(resultTable, fields, 500, i + 1, "1=1");
                for (Iterator map : pageResult) {
                    String tbbh;
                    String string = map.get(this.cgjcyjConfig.getFieldPrimary()).toString();
                    String unique = map.get(this.cgjcyjConfig.getFieldUniqueId()).toString();
                    Object o0 = map.get(this.cgjcyjConfig.getFieldYjdl());
                    Object o1 = map.get(this.cgjcyjConfig.getFieldEjdl());
                    Object o2 = map.get("samepre");
                    Object o3 = map.get("isconnect");
                    Object o4 = map.get(this.cgjcyjConfig.getFieldTbbh());
                    String yjdl = o0 == null ? "" : o0.toString();
                    String ejdl = o1 == null ? "" : o1.toString();
                    String samepre = o2 == null ? "" : o2.toString();
                    String isconnect = o3 == null ? "" : o3.toString();
                    String string2 = tbbh = o4 == null ? "" : o4.toString();
                    if (excluteDlbm != null && excluteDlbm.contains(yjdl) || excluteDlbm.contains(ejdl)) continue;
                    List<String> connects = new ArrayList<String>();
                    if (StringUtils.isNotBlank((CharSequence)isconnect)) {
                        connects = Arrays.stream(StringUtils.split((String)isconnect, (String)",")).collect(Collectors.toList());
                    }
                    if (!connects.contains(string)) {
                        connects.add(string);
                    }
                    Temp t2 = new Temp();
                    t2.pk = string;
                    t2.unique = unique;
                    t2.yjdl = yjdl;
                    t2.ejdl = ejdl;
                    t2.samepre = samepre;
                    t2.isconnect = connects;
                    t2.tbbh = tbbh;
                    temps.add(t2);
                }
            }
            this.logger.error("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u5206\u6790\u7ed3\u679c\u6570\u91cf:" + temps.size(), new Object[0]);
            HashMap<String, Object> mapResults = new HashMap<String, Object>();
            HashMap<String, CgjcyjNeighbourTb> mapNeighboutTbs = new HashMap<String, CgjcyjNeighbourTb>();
            Map<String, List<Temp>> sameTemp = temps.stream().collect(Collectors.groupingBy(t -> t.samepre));
            for (Map.Entry entry : sameTemp.entrySet()) {
                String yjdl = ((Temp)((List)entry.getValue()).get((int)0)).yjdl;
                String ejdl = ((Temp)((List)entry.getValue()).get((int)0)).ejdl;
                boolean sameDlbm = ((List)entry.getValue()).stream().allMatch(t -> t.yjdl.equals(yjdl) && t.ejdl.equals(ejdl));
                if (sameDlbm) continue;
                CgjcyjResult search = new CgjcyjResult();
                search.setSamepre((String)entry.getKey());
                List sames = this.cgjcyjResultDao.gwSearch((GiEntityQueryable)search);
                boolean sameCount = false;
                if (sames != null && sames.size() == ((List)entry.getValue()).size()) {
                    sameCount = true;
                }
                for (Object t3 : (List)entry.getValue()) {
                    if (sameCount) {
                        Optional<CgjcyjResult> texist = sames.stream().filter(arg_0 -> MCgjcyjTaskServiceImpl.lambda$progressQuery$7((Temp)t3, arg_0)).findFirst();
                        if (!texist.isPresent() || !texist.get().getSamepreun().equals(-1) && !texist.get().getSamepreun().equals(1)) continue;
                        mapResults.put(texist.get().getId(), texist.get());
                        continue;
                    }
                    CgjcyjResult cgjcyjResult = new CgjcyjResult();
                    cgjcyjResult.setId(((Temp)t3).unique);
                    cgjcyjResult.setSamepre(((Temp)t3).samepre);
                    cgjcyjResult.setSamepreun(Integer.valueOf(1));
                    cgjcyjResult.setConnectun(Integer.valueOf(0));
                    cgjcyjResult.setMaxarea(Integer.valueOf(0));
                    cgjcyjResult.setBatchId(task.getBatchId());
                    mapResults.put(((Temp)t3).unique, cgjcyjResult);
                }
            }
            for (Temp temp : temps) {
                Object t3;
                if (temp.isconnect.size() == 1) continue;
                ArrayList<Temp> connects = new ArrayList<Temp>();
                for (String con : temp.isconnect) {
                    Optional<Temp> opt = temps.stream().filter(b -> b.pk.equals(con)).findFirst();
                    if (!opt.isPresent()) continue;
                    connects.add(opt.get());
                }
                if (connects.isEmpty() || connects.size() == 1) continue;
                String yjdl = ((Temp)connects.get((int)0)).yjdl;
                String ejdl = ((Temp)connects.get((int)0)).ejdl;
                boolean sameDlbm = connects.stream().allMatch(a -> a.yjdl.equals(yjdl) && a.ejdl.equals(ejdl));
                if (sameDlbm) continue;
                CgjcyjNeighbourTb search = new CgjcyjNeighbourTb();
                search.setTbid(temp.unique);
                List sames = this.cgjcyjNeighbourTbDao.gwSearch((GiEntityQueryable)search);
                boolean sameCount = false;
                if (sames != null && sames.size() == connects.size()) {
                    sameCount = true;
                }
                t3 = connects.iterator();
                while (t3.hasNext()) {
                    Object cgjcyjResult;
                    Temp t1 = (Temp)t3.next();
                    if (sameCount) {
                        CgjcyjResult exist = (CgjcyjResult)this.cgjcyjResultDao.gwSearchByPK((Serializable)((Object)t1.unique));
                        if (exist == null || !exist.getConnectun().equals(-1) && !exist.getConnectun().equals(1)) continue;
                        mapResults.put(exist.getId(), exist);
                        continue;
                    }
                    if (mapResults.containsKey(t1.unique)) {
                        ((CgjcyjResult)mapResults.get(t1.unique)).setConnectun(Integer.valueOf(1));
                    } else {
                        cgjcyjResult = new CgjcyjResult();
                        cgjcyjResult.setId(t1.unique);
                        cgjcyjResult.setSamepre(temp.samepre);
                        cgjcyjResult.setSamepreun(Integer.valueOf(0));
                        cgjcyjResult.setConnectun(Integer.valueOf(1));
                        cgjcyjResult.setMaxarea(Integer.valueOf(0));
                        cgjcyjResult.setBatchId(task.getBatchId());
                        mapResults.put(t1.unique, cgjcyjResult);
                    }
                    cgjcyjResult = connects.iterator();
                    while (cgjcyjResult.hasNext()) {
                        Temp t2 = (Temp)cgjcyjResult.next();
                        CgjcyjNeighbourTb tb = new CgjcyjNeighbourTb();
                        tb.setTbid(t1.unique);
                        tb.setTbbh(t2.tbbh);
                        tb.setBhid(t2.unique);
                        tb.setBatchId(task.getBatchId());
                        String key = t1.unique + t2.tbbh;
                        if (mapNeighboutTbs.containsKey(key)) continue;
                        mapNeighboutTbs.put(key, tb);
                    }
                }
            }
            List maxAreas = null;
            List list = ListUtil.of((Object[])new String[]{this.cgjcyjConfig.getFieldPrimary(), this.cgjcyjConfig.getFieldUniqueId(), this.cgjcyjConfig.getFieldTbbh(), this.cgjcyjConfig.getFieldYjdl(), this.cgjcyjConfig.getFieldEjdl()});
            switch (this.cgjcyjConfig.getFieldAreaUnit()) {
                case 1: {
                    maxAreas = this.dataBizService.queryAllData(jcClueSource.getfTablename(), list, this.cgjcyjConfig.getFieldArea() + "/666.67 > " + this.cgjcyjConfig.getMaxArea() + " order by " + this.cgjcyjConfig.getFieldArea() + " desc limit " + this.cgjcyjConfig.getMaxAreaLimit());
                    break;
                }
                case 2: {
                    maxAreas = this.dataBizService.queryAllData(jcClueSource.getfTablename(), list, this.cgjcyjConfig.getFieldArea() + " > " + this.cgjcyjConfig.getMaxArea() + " order by " + this.cgjcyjConfig.getFieldArea() + " desc limit " + this.cgjcyjConfig.getMaxAreaLimit());
                }
            }
            for (Map map : maxAreas) {
                String tbbh;
                String unique = map.get(this.cgjcyjConfig.getFieldUniqueId()).toString();
                CgjcyjResult exist = (CgjcyjResult)this.cgjcyjResultDao.gwSearchByPK((Serializable)((Object)unique));
                if (exist != null && exist.getMaxarea().equals(-1)) {
                    mapResults.put(exist.getId(), exist);
                    continue;
                }
                Object o2 = map.get(this.cgjcyjConfig.getFieldTbbh());
                String string = tbbh = o2 == null ? "" : o2.toString();
                if (mapResults.containsKey(unique)) {
                    ((CgjcyjResult)mapResults.get(unique)).setMaxarea(Integer.valueOf(1));
                    continue;
                }
                CgjcyjResult cgjcyjResult = new CgjcyjResult();
                cgjcyjResult.setId(unique);
                cgjcyjResult.setSamepre(tbbh);
                cgjcyjResult.setSamepreun(Integer.valueOf(0));
                cgjcyjResult.setConnectun(Integer.valueOf(0));
                cgjcyjResult.setMaxarea(Integer.valueOf(1));
                cgjcyjResult.setBatchId(task.getBatchId());
                mapResults.put(unique, cgjcyjResult);
            }
            List cgjcyjResults = mapResults.values().stream().collect(Collectors.toList());
            int batchCount = 100;
            page = (int)Math.ceil((double)cgjcyjResults.size() * 1.0 / (double)batchCount);
            for (int i = 0; i < page; ++i) {
                List subs;
                List ids;
                List exists;
                int startIndex = i * batchCount;
                int endIndex = (i + 1) * batchCount;
                if (startIndex >= cgjcyjResults.size()) break;
                if (endIndex >= cgjcyjResults.size()) {
                    endIndex = cgjcyjResults.size();
                }
                if ((exists = this.cgjcyjResultDao.findIds(ids = (subs = cgjcyjResults.subList(startIndex, endIndex)).stream().map(CgjcyjResult::getId).collect(Collectors.toList()))) == null || exists.isEmpty()) {
                    this.cgjcyjResultDao.batchInsert(subs);
                    continue;
                }
                List updates = subs.stream().filter(t -> exists.contains(t.getId())).collect(Collectors.toList());
                inserts = subs.stream().filter(t -> !exists.contains(t.getId())).collect(Collectors.toList());
                if (updates != null && !updates.isEmpty()) {
                    this.cgjcyjResultDao.batchUpdate(updates);
                }
                if (inserts == null || inserts.isEmpty()) continue;
                this.cgjcyjResultDao.batchInsert(inserts);
            }
            List neighbourTbs = mapNeighboutTbs.values().stream().collect(Collectors.toList());
            page = (int)Math.ceil((double)neighbourTbs.size() * 1.0 / (double)batchCount);
            for (int i = 0; i < page; ++i) {
                List subs;
                List ids;
                List exists;
                int startIndex = i * batchCount;
                int endIndex = (i + 1) * batchCount;
                if (startIndex >= neighbourTbs.size()) break;
                if (endIndex >= neighbourTbs.size()) {
                    endIndex = neighbourTbs.size();
                }
                if ((exists = this.cgjcyjNeighbourTbDao.ListByIds(ids = (subs = neighbourTbs.subList(startIndex, endIndex)).stream().map(CgjcyjNeighbourTb::getTbid).collect(Collectors.toList()), task.getBatchId())) == null || exists.isEmpty()) {
                    this.cgjcyjNeighbourTbDao.batchInsert(subs);
                    continue;
                }
                inserts = subs.stream().filter(e -> !exists.stream().filter(t -> t.getTbid().equals(e.getTbid()) && t.getTbbh().equals(e.getTbbh())).findFirst().isPresent()).collect(Collectors.toList());
                if (inserts == null || inserts.isEmpty()) continue;
                this.cgjcyjNeighbourTbDao.batchInsert(inserts);
            }
            this.cgjcyjTaskDao.updateStatus(task.getId(), Short.valueOf(CgjcyjStateEnum.success.getCode().shortValue()));
            this.dataBizService.excuteSql("drop table " + task.getResult());
            return true;
        }
        catch (Exception ex) {
            String msg = "\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u4efb\u52a1:" + task.getId() + "\u67e5\u8be2\u8fdb\u5ea6\u5f02\u5e38";
            if (ex != null && StringUtils.isNotBlank((CharSequence)ex.getMessage())) {
                msg = msg + "," + ex.getMessage();
            }
            this.cgjcyjTaskDao.finishTask(task.id(), Short.valueOf(CgjcyjStateEnum.error.getCode().shortValue()), msg);
            this.logger.error(msg + "\n" + this.getStackTraceInfo(ex), new Object[]{ex});
            return false;
        }
    }

    public CgjcyjResutList list(CgjcyjSearch param) throws Exception {
        JcClueSource jcClueSource;
        if (this.cgjcyjConfig == null) {
            SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
            this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
        }
        if ((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())) == null) {
            this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728", new Object[0]);
            throw new Exception("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728");
        }
        ArrayList<String> queryFieldNames = new ArrayList<String>();
        List fields = this.cgjcyjConfig.getFields();
        for (CgjcyjShowField ff : fields) {
            String nn = ff.getName();
            if (nn.equals(this.cgjcyjConfig.getFieldArea()) && this.cgjcyjConfig.getFieldAreaUnit().equals(1)) {
                nn = nn + "/666.67 as " + nn;
            }
            queryFieldNames.add(nn);
        }
        if (!queryFieldNames.stream().filter(t -> t.equals(this.cgjcyjConfig.getFieldUniqueId())).findFirst().isPresent()) {
            queryFieldNames.add(this.cgjcyjConfig.getFieldUniqueId());
        }
        if (!queryFieldNames.stream().filter(t -> t.equals(this.cgjcyjConfig.getFieldTbbh())).findFirst().isPresent()) {
            queryFieldNames.add(this.cgjcyjConfig.getFieldTbbh());
        }
        String where = "";
        ArrayList<String> wheres = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)param.getXzqdm())) {
            wheres.add(this.cgjcyjConfig.getFieldXzqdm() + " = '" + param.getXzqdm() + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getJcrw())) {
            wheres.add(this.cgjcyjConfig.getFieldJcrw() + " = '" + param.getJcrw() + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getYjdl())) {
            wheres.add(this.cgjcyjConfig.getFieldYjdl() + " = '" + param.getYjdl() + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEjdl())) {
            wheres.add(this.cgjcyjConfig.getFieldEjdl() + " = '" + param.getEjdl() + "'");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getTbbh())) {
            wheres.add(this.cgjcyjConfig.getFieldTbbh() + " like '%" + param.getTbbh() + "%'");
        }
        String frontFilter = String.join((CharSequence)" and ", wheres);
        switch (param.getWarnType()) {
            case 1: {
                wheres.add(this.cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_samepreun = 1 and f_batch_id ='" + param.getBatchId() + "')");
                break;
            }
            case 2: {
                wheres.add(this.cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_connectun = 1 and f_batch_id ='" + param.getBatchId() + "')");
                break;
            }
            case 3: {
                wheres.add(this.cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_maxarea = 1 and f_batch_id ='" + param.getBatchId() + "')");
            }
        }
        where = String.join((CharSequence)" and ", wheres);
        int totalCount = 0;
        int page = param.getPage();
        int rows = param.getRows();
        CgjcyjResutList resutList = new CgjcyjResutList();
        switch (param.getWarnType()) {
            case 1: {
                String countSql = String.format("select count(distinct(f_samepre)) as count from tb_cgjcyj_result where %s in  (select %s from %s where %s) ", this.cgjcyjConfig.getFieldUniqueId(), this.cgjcyjConfig.getFieldUniqueId(), jcClueSource.getfTablename(), where);
                List countMap = this.dataBizService.queryDataBySql(countSql);
                totalCount = Integer.parseInt(((Map)countMap.get(0)).get("count").toString());
                ArrayList resultMap = new ArrayList();
                HashMap samepreResults = new HashMap();
                if (totalCount > 0) {
                    int offset = (page - 1) * rows;
                    List samepreMap = this.jdbcTemplate.queryForList(String.format("select distinct(f_samepre) as f_samepre from tb_cgjcyj_result where %s in  (select %s from %s where %s)  offset %d limit %d", this.cgjcyjConfig.getFieldUniqueId(), this.cgjcyjConfig.getFieldUniqueId(), jcClueSource.getfTablename(), where, offset, rows));
                    ArrayList<String> samepres = new ArrayList<String>();
                    for (Map map : samepreMap) {
                        String samepre = map.get("f_samepre").toString();
                        samepres.add(samepre);
                        HashMap<String, String> r = new HashMap<String, String>();
                        for (String f : queryFieldNames) {
                            if (f.equals(this.cgjcyjConfig.getFieldTbbh())) {
                                r.put(f, samepre);
                                continue;
                            }
                            r.put(f, "");
                        }
                        resultMap.add(r);
                    }
                    List ids = this.cgjcyjResultDao.findIdsBySamepres(samepres);
                    String filter = this.cgjcyjConfig.getFieldUniqueId() + " in ('" + StringUtils.join((Iterable)ids, (String)"','") + "')";
                    if (StringUtils.isNotBlank((CharSequence)frontFilter)) {
                        filter = filter + " and " + frontFilter;
                    }
                    List maps = this.dataBizService.queryAllData(jcClueSource.getfTablename(), queryFieldNames, filter);
                    for (Map map : maps) {
                        String tbbh = map.get(this.cgjcyjConfig.getFieldTbbh()).toString();
                        Optional<String> op = samepres.stream().filter(t -> tbbh.startsWith((String)t)).findFirst();
                        if (samepreResults.containsKey(op.get())) {
                            ((List)samepreResults.get(op.get())).add(map);
                            continue;
                        }
                        ArrayList<Map> temp = new ArrayList<Map>();
                        temp.add(map);
                        samepreResults.put(op.get(), temp);
                    }
                }
                resutList.setFields(fields);
                resutList.setResults(resultMap);
                resutList.setSamepres(samepreResults);
                resutList.setTotalCount(Long.valueOf(totalCount));
                resutList.setRows(Integer.valueOf(rows));
                resutList.setPage(Integer.valueOf(page));
                break;
            }
            case 2: {
                totalCount = this.dataBizService.getCount(jcClueSource.getfTablename(), where);
                List maps = new ArrayList();
                if (totalCount > 0) {
                    maps = this.dataBizService.queryPageData(jcClueSource.getfTablename(), queryFieldNames, rows, page, where);
                }
                resutList.setFields(fields);
                resutList.setResults(maps);
                resutList.setTotalCount(Long.valueOf(totalCount));
                resutList.setRows(Integer.valueOf(rows));
                resutList.setPage(Integer.valueOf(page));
            }
            case 3: {
                totalCount = this.dataBizService.getCount(jcClueSource.getfTablename(), where);
                List maps = new ArrayList();
                if (totalCount > 0) {
                    String order = " order by " + this.cgjcyjConfig.getFieldArea() + " desc";
                    maps = this.dataBizService.queryPageData(jcClueSource.getfTablename(), queryFieldNames, rows, page, where + order);
                }
                resutList.setFields(fields);
                resutList.setResults(maps);
                resutList.setTotalCount(Long.valueOf(totalCount));
                resutList.setRows(Integer.valueOf(rows));
                resutList.setPage(Integer.valueOf(page));
            }
        }
        return resutList;
    }

    public Boolean cancleWarn(String id, Integer warnType) {
        switch (warnType) {
            case 1: {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id}) && id.contains(",")) {
                    this.cgjcyjResultDao.cancleWarnSamebhs(Arrays.stream(id.split(",")).collect(Collectors.toList()));
                } else {
                    this.cgjcyjResultDao.cancleWarnSamebh(id);
                }
                return true;
            }
            case 2: {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id}) && id.contains(",")) {
                    this.cgjcyjResultDao.cancleWarnConnects(Arrays.stream(id.split(",")).collect(Collectors.toList()));
                } else {
                    this.cgjcyjResultDao.cancleWarnConnect(id);
                }
                return true;
            }
            case 3: {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id}) && id.contains(",")) {
                    this.cgjcyjResultDao.cancleWarnMaxareas(Arrays.stream(id.split(",")).collect(Collectors.toList()));
                } else {
                    this.cgjcyjResultDao.cancleWarnMaxarea(id);
                }
                return true;
            }
        }
        return false;
    }

    public Boolean updateDl(String id, String yjdl, String ejdl, String userId) {
        JcClueSource jcClueSource;
        if (this.cgjcyjConfig == null) {
            SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
            this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
        }
        if ((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())) == null) {
            this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728", new Object[0]);
            return false;
        }
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(this.cgjcyjConfig.getFieldYjdl());
        fields.add(this.cgjcyjConfig.getFieldEjdl());
        String where = this.cgjcyjConfig.getFieldUniqueId() + " ='" + id + "'";
        List mapExist = this.dataBizService.queryAllData(jcClueSource.getfTablename(), fields, where);
        if (mapExist == null || mapExist.isEmpty()) {
            this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728\u56fe\u6591:" + id, new Object[0]);
            return false;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.cgjcyjConfig.getFieldYjdl(), yjdl);
        map.put(this.cgjcyjConfig.getFieldEjdl(), ejdl);
        this.dataBizService.updateData(jcClueSource.getfTablename(), map, where);
        Map mapDl = (Map)mapExist.get(0);
        String oldYjdl = mapDl.get(this.cgjcyjConfig.getFieldYjdl()) == null ? "" : mapDl.get(this.cgjcyjConfig.getFieldYjdl()).toString();
        String oldEjdl = mapDl.get(this.cgjcyjConfig.getFieldEjdl()) == null ? "" : mapDl.get(this.cgjcyjConfig.getFieldEjdl()).toString();
        CgjcyjDlVersion dl = new CgjcyjDlVersion();
        dl.setId(UUID.randomUUID().toString());
        dl.setTbid(id);
        dl.setYjdl(oldYjdl);
        dl.setEjdl(oldEjdl);
        dl.setTime(new Date());
        dl.setUserId(userId);
        this.cgjcyjDlVersionDao.gwAccess((GiEntitySaveable)dl);
        return true;
    }

    public List<CgjcyjDlVersion> getDlVersion(String id) {
        CgjcyjDlVersion search = new CgjcyjDlVersion();
        search.setTbid(id);
        return this.cgjcyjDlVersionDao.gwSearch((GiEntityQueryable)search);
    }

    public List<CgjcyjTbidbh> getSameBhTbBySameBh(String sameBh, String batchId) {
        JcClueSource jcClueSource;
        if (this.cgjcyjConfig == null) {
            SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
            this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
        }
        if ((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())) == null) {
            this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728", new Object[0]);
            return null;
        }
        ArrayList<CgjcyjTbidbh> results = new ArrayList<CgjcyjTbidbh>();
        if (StringUtils.isNotBlank((CharSequence)sameBh)) {
            List nxftbs = Arrays.stream(StringUtils.split((String)this.cgjcyjConfig.getNxftbValue(), (String)",")).collect(Collectors.toList());
            ArrayList<String> queryFieldNames = new ArrayList<String>();
            queryFieldNames.add(this.cgjcyjConfig.getFieldUniqueId());
            queryFieldNames.add(this.cgjcyjConfig.getFieldYjdl());
            queryFieldNames.add(this.cgjcyjConfig.getFieldEjdl());
            queryFieldNames.add(this.cgjcyjConfig.getFieldTbbh());
            queryFieldNames.add(this.cgjcyjConfig.getFieldNxftb());
            queryFieldNames.add("st_astext(" + this.cgjcyjConfig.getFieldShape() + ") as f_wkt");
            List maps = this.dataBizService.queryAllData(jcClueSource.getfTablename(), queryFieldNames, this.cgjcyjConfig.getFieldUniqueId() + " in (select f_id from tb_cgjcyj_result where f_batch_id='" + batchId + "' and f_samepreun = 1 and f_samepre ='" + sameBh + "')");
            if (maps != null) {
                for (Map m : maps) {
                    CgjcyjTbidbh cs = new CgjcyjTbidbh();
                    cs.setSourceId(this.cgjcyjConfig.getRelId());
                    cs.setTbid(m.get(this.cgjcyjConfig.getFieldUniqueId()).toString());
                    cs.setTbbh(m.get(this.cgjcyjConfig.getFieldTbbh()).toString());
                    cs.setWkt(m.get("f_wkt").toString());
                    Object xftb = m.get(this.cgjcyjConfig.getFieldNxftb());
                    if (xftb != null && nxftbs.contains(xftb.toString())) {
                        cs.setOuter(Boolean.valueOf(true));
                    } else {
                        cs.setOuter(Boolean.valueOf(false));
                    }
                    Object yjdl = m.get(this.cgjcyjConfig.getFieldYjdl());
                    Object ejdl = m.get(this.cgjcyjConfig.getFieldEjdl());
                    cs.setYjdl(yjdl == null ? "" : yjdl.toString());
                    cs.setEjdl(ejdl == null ? "" : ejdl.toString());
                    results.add(cs);
                }
            }
        }
        if (results != null && !results.isEmpty()) {
            List<EnumeratorDomain> yjdlDomain = this.getYjdl();
            List<EnumeratorDomain> ejdlDomain = this.getEjdl();
            for (CgjcyjTbidbh item : results) {
                Optional<EnumeratorDomain> op;
                if (StringUtils.isNotBlank((CharSequence)item.getYjdl())) {
                    op = yjdlDomain.stream().filter(t -> t.getCode().equals(item.getYjdl())).findFirst();
                    if (op.isPresent()) {
                        item.setYjdlAlias(op.get().getName());
                    } else {
                        item.setYjdlAlias(item.getYjdl());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)item.getEjdl())) continue;
                op = ejdlDomain.stream().filter(t -> t.getCode().equals(item.getEjdl())).findFirst();
                if (op.isPresent()) {
                    item.setEjdlAlias(op.get().getName());
                    continue;
                }
                item.setEjdlAlias(item.getEjdl());
            }
        }
        return results;
    }

    public List<CgjcyjTbidbh> getNeighbourTbByTbid(String tbid, String batchId) {
        JcClueSource jcClueSource;
        if (this.cgjcyjConfig == null) {
            SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
            this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
        }
        if ((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())) == null) {
            this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728", new Object[0]);
            return null;
        }
        ArrayList<CgjcyjTbidbh> results = new ArrayList<CgjcyjTbidbh>();
        if (tbid != null) {
            List bhids;
            List cancleTbs;
            List<String> tbids = new ArrayList<String>();
            tbids.add(tbid);
            List neighbourTbs = this.cgjcyjNeighbourTbDao.ListByIds(tbids, batchId);
            if (neighbourTbs != null && !neighbourTbs.isEmpty() && (cancleTbs = this.cgjcyjResultDao.findCancleConnectIds(bhids = neighbourTbs.stream().map(CgjcyjNeighbourTb::getBhid).collect(Collectors.toList()))) != null && !cancleTbs.isEmpty()) {
                cancleTbs.forEach(t -> neighbourTbs.removeIf(a -> a.getBhid().equalsIgnoreCase((String)t)));
            }
            if (neighbourTbs != null && !neighbourTbs.isEmpty()) {
                tbids = neighbourTbs.stream().map(CgjcyjNeighbourTb::getBhid).collect(Collectors.toList());
                String where = this.cgjcyjConfig.getFieldUniqueId() + " in ('" + StringUtils.join(tbids, (String)"','") + "')";
                List nxftbs = Arrays.stream(StringUtils.split((String)this.cgjcyjConfig.getNxftbValue(), (String)",")).collect(Collectors.toList());
                ArrayList<String> queryFieldNames = new ArrayList<String>();
                queryFieldNames.add(this.cgjcyjConfig.getFieldUniqueId());
                queryFieldNames.add(this.cgjcyjConfig.getFieldYjdl());
                queryFieldNames.add(this.cgjcyjConfig.getFieldEjdl());
                queryFieldNames.add(this.cgjcyjConfig.getFieldTbbh());
                queryFieldNames.add(this.cgjcyjConfig.getFieldNxftb());
                queryFieldNames.add("st_astext(" + this.cgjcyjConfig.getFieldShape() + ") as f_wkt");
                List maps = this.dataBizService.queryAllData(jcClueSource.getfTablename(), queryFieldNames, where);
                if (maps != null) {
                    for (Map m : maps) {
                        CgjcyjTbidbh cs = new CgjcyjTbidbh();
                        cs.setSourceId(this.cgjcyjConfig.getRelId());
                        cs.setTbid(m.get(this.cgjcyjConfig.getFieldUniqueId()).toString());
                        cs.setTbbh(m.get(this.cgjcyjConfig.getFieldTbbh()).toString());
                        cs.setWkt(m.get("f_wkt").toString());
                        Object xftb = m.get(this.cgjcyjConfig.getFieldNxftb());
                        if (xftb != null && nxftbs.contains(xftb.toString())) {
                            cs.setOuter(Boolean.valueOf(true));
                        } else {
                            cs.setOuter(Boolean.valueOf(false));
                        }
                        Object yjdl = m.get(this.cgjcyjConfig.getFieldYjdl());
                        Object ejdl = m.get(this.cgjcyjConfig.getFieldEjdl());
                        cs.setYjdl(yjdl == null ? "" : yjdl.toString());
                        cs.setEjdl(ejdl == null ? "" : ejdl.toString());
                        results.add(cs);
                    }
                }
            }
        }
        if (results != null && !results.isEmpty()) {
            List<EnumeratorDomain> yjdlDomain = this.getYjdl();
            List<EnumeratorDomain> ejdlDomain = this.getEjdl();
            for (CgjcyjTbidbh item : results) {
                Optional<EnumeratorDomain> op;
                if (StringUtils.isNotBlank((CharSequence)item.getYjdl())) {
                    op = yjdlDomain.stream().filter(t -> t.getCode().equals(item.getYjdl())).findFirst();
                    if (op.isPresent()) {
                        item.setYjdlAlias(op.get().getName());
                    } else {
                        item.setYjdlAlias(item.getYjdl());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)item.getEjdl())) continue;
                op = ejdlDomain.stream().filter(t -> t.getCode().equals(item.getEjdl())).findFirst();
                if (op.isPresent()) {
                    item.setEjdlAlias(op.get().getName());
                    continue;
                }
                item.setEjdlAlias(item.getEjdl());
            }
        }
        return results;
    }

    public List<CgjcyjTbidbh> getMaxAreaTbByTbid(String tbid, String batchId) {
        JcClueSource jcClueSource;
        if (this.cgjcyjConfig == null) {
            SysConfig config = this.sysConfigService.findOne("cgjcyjconfig");
            this.cgjcyjConfig = (CgjcyjConfig)JSONObject.parseObject((String)config.getValue(), CgjcyjConfig.class);
        }
        if ((jcClueSource = this.jcClueSourceService.findOne(this.cgjcyjConfig.getRelId())) == null) {
            this.logger.error("\u7ebf\u7d22:" + this.cgjcyjConfig.getRelId() + "\u4e0d\u5b58\u5728", new Object[0]);
            return null;
        }
        ArrayList<CgjcyjTbidbh> results = new ArrayList<CgjcyjTbidbh>();
        if (StringUtils.isNotBlank((CharSequence)tbid)) {
            List nxftbs = Arrays.stream(StringUtils.split((String)this.cgjcyjConfig.getNxftbValue(), (String)",")).collect(Collectors.toList());
            ArrayList<String> queryFieldNames = new ArrayList<String>();
            queryFieldNames.add(this.cgjcyjConfig.getFieldUniqueId());
            queryFieldNames.add(this.cgjcyjConfig.getFieldYjdl());
            queryFieldNames.add(this.cgjcyjConfig.getFieldEjdl());
            queryFieldNames.add(this.cgjcyjConfig.getFieldTbbh());
            queryFieldNames.add(this.cgjcyjConfig.getFieldNxftb());
            queryFieldNames.add("st_astext(" + this.cgjcyjConfig.getFieldShape() + ") as f_wkt");
            List maps = this.dataBizService.queryAllData(jcClueSource.getfTablename(), queryFieldNames, this.cgjcyjConfig.getFieldUniqueId() + " ='" + tbid + "'");
            if (maps != null) {
                for (Map m : maps) {
                    CgjcyjTbidbh cs = new CgjcyjTbidbh();
                    cs.setSourceId(this.cgjcyjConfig.getRelId());
                    cs.setTbid(m.get(this.cgjcyjConfig.getFieldUniqueId()).toString());
                    cs.setTbbh(m.get(this.cgjcyjConfig.getFieldTbbh()).toString());
                    cs.setWkt(m.get("f_wkt").toString());
                    Object xftb = m.get(this.cgjcyjConfig.getFieldNxftb());
                    if (xftb != null && nxftbs.contains(xftb.toString())) {
                        cs.setOuter(Boolean.valueOf(true));
                    } else {
                        cs.setOuter(Boolean.valueOf(false));
                    }
                    Object yjdl = m.get(this.cgjcyjConfig.getFieldYjdl());
                    Object ejdl = m.get(this.cgjcyjConfig.getFieldEjdl());
                    cs.setYjdl(yjdl == null ? "" : yjdl.toString());
                    cs.setEjdl(ejdl == null ? "" : ejdl.toString());
                    results.add(cs);
                }
            }
        }
        if (results != null && !results.isEmpty()) {
            List<EnumeratorDomain> yjdlDomain = this.getYjdl();
            List<EnumeratorDomain> ejdlDomain = this.getEjdl();
            for (CgjcyjTbidbh item : results) {
                Optional<EnumeratorDomain> op;
                if (StringUtils.isNotBlank((CharSequence)item.getYjdl())) {
                    op = yjdlDomain.stream().filter(t -> t.getCode().equals(item.getYjdl())).findFirst();
                    if (op.isPresent()) {
                        item.setYjdlAlias(op.get().getName());
                    } else {
                        item.setYjdlAlias(item.getYjdl());
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)item.getEjdl())) continue;
                op = ejdlDomain.stream().filter(t -> t.getCode().equals(item.getEjdl())).findFirst();
                if (op.isPresent()) {
                    item.setEjdlAlias(op.get().getName());
                    continue;
                }
                item.setEjdlAlias(item.getEjdl());
            }
        }
        return results;
    }

    public Integer getWarnCount(String batchId) {
        return this.cgjcyjResultDao.getWarnCount(batchId);
    }

    public CgjcyjBatchList getBatchList(int page, int pageSize, int state, String name) {
        CgjcyjBatchList result = new CgjcyjBatchList();
        result.setPage(Integer.valueOf(page));
        result.setRows(Integer.valueOf(pageSize));
        int start = (page - 1) * pageSize;
        List list = this.jcClueImportRecordService.findClueSources(this.cgjcyjConfig.getRelId(), name, state, start, pageSize);
        int count = this.jcClueImportRecordService.countClueSources(this.cgjcyjConfig.getRelId(), name, state);
        result.setTotalCount(Long.valueOf(count));
        if (list != null && !list.isEmpty()) {
            ArrayList<CgjcyjClueImportRecord> batchs = new ArrayList<CgjcyjClueImportRecord>();
            for (JcClueImportRecord record : list) {
                CgjcyjClueImportRecord batch = new CgjcyjClueImportRecord();
                BeanUtil.copyProperties((Object)record, (Object)batch);
                batch.setWarnCount(this.getWarnCount(batch.getfId()));
                batchs.add(batch);
            }
            result.setBatchs(batchs);
        }
        return result;
    }

    public List<EnumeratorDomain> getYjdl() {
        String key;
        EnumeratorValue ev;
        if (this.yjdl == null && (ev = this.enumeratorValueService.findOneByKey(key = "yjdl_cgjc")) != null) {
            this.yjdl = this.enumeratorDomainService.findByDicno(ev.getDicno());
        }
        return this.yjdl;
    }

    public List<EnumeratorDomain> getEjdl() {
        String key;
        EnumeratorValue ev;
        if (this.ejdl == null && (ev = this.enumeratorValueService.findOneByKey(key = "ejdl_cgjc")) != null) {
            this.ejdl = this.enumeratorDomainService.findByDicno(ev.getDicno());
        }
        return this.ejdl;
    }

    public List<EnumeratorDomain> getJcrw() {
        String key;
        EnumeratorValue ev;
        if (this.jcrw == null && (ev = this.enumeratorValueService.findOneByKey(key = "JCLX_CGJC")) != null) {
            this.jcrw = this.enumeratorDomainService.findByDicno(ev.getDicno());
        }
        return this.jcrw;
    }

    public String readFile(String filePath) throws Exception {
        try {
            String content = "";
            String encoding = "UTF8";
            File file = new File(filePath);
            if (file.isFile() && file.exists()) {
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    content = content + lineTxt;
                }
                read.close();
            }
            return content;
        }
        catch (Exception var8) {
            throw new Exception("\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u6a21\u578b\u6a21\u677f\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
        }
    }

    private String getTemplate() {
        try {
            InputStream is = FileUtil.class.getClassLoader().getResourceAsStream("static/cgjcyj.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String s = "";
            String result = "";
            while ((s = reader.readLine()) != null) {
                result = result + s;
            }
            return result;
        }
        catch (Exception ex) {
            this.logger.error("\u8bfb\u53d6\u5e38\u89c4\u76d1\u6d4b\u9884\u8b66\u6a21\u578b\u5931\u8d25", new Object[]{ex});
            return null;
        }
    }

    private String getDB() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        DruidDataSource druidDataSource = (DruidDataSource)dataSource;
        String url = druidDataSource.getUrl();
        String username = druidDataSource.getUsername();
        String password = druidDataSource.getPassword();
        String[] urls = StringUtils.split((String)url, (String)"?");
        url = urls[0];
        String pre = url.substring(0, url.indexOf("/"));
        url = url.substring(url.indexOf("/") + 2);
        String result = pre + "//" + username + "/" + password + "@" + url;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStackTraceInfo(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            e.printStackTrace(pw);
            pw.flush();
            sw.flush();
            String string = sw.toString();
            return string;
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                sw.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static /* synthetic */ boolean lambda$progressQuery$7(Temp t, CgjcyjResult a) {
        return a.getId().equals(t.unique);
    }

    private class Temp {
        public String pk;
        public String unique;
        public String samepre;
        public String yjdl;
        public String ejdl;
        public List<String> isconnect;
        public String tbbh;

        private Temp() {
        }
    }
}

