/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.cgk;

import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.cgk.dto.CgkGeoSearchDto;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CgkSearchService {
    final String certCode = "1D5BC394E7454BB4B56D808911463460";
    final String publicKey = "04D964FD6AE472FC3367C09935DEBFC9A613F6F084ED8CA5B4C2EBF0E9F9FA5146E1631B842FED8FD55B488674C37B5FE695A49EE5A52BBEEA0868C2E816E5C47C";
    final String privateKey = "93EF84E31C27016FBAF3DED662E2C5F47B7941EFA6533E1A113C9F2E8816FB19";
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    private final GiLoger logger = GwLoger.getLoger(CgkSearchService.class);

    public List<AppMedia> saveSharedData(String taskId, String tbbhId, JSONArray jsonArray) throws Exception {
        ArrayList<AppMedia> returnMediaList = null;
        if (StringUtils.isEmpty((CharSequence)taskId) || ObjectUtils.isEmpty((Object)jsonArray) || StringUtils.isBlank((CharSequence)tbbhId)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List appMediaList = this.appMediaDao.queryALLByGid(tbbhId);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String sm3 = jsonObject.getString("sm3");
            if (ObjectUtils.isEmpty(returnMediaList)) {
                returnMediaList = new ArrayList<AppMedia>();
            }
            if (appMediaList != null && appMediaList.stream().filter(t -> sm3.equals(t.getSm3())).findFirst().isPresent()) continue;
            AppMedia media = new AppMedia();
            media.setId(UUID.randomUUID().toString());
            media.setFromSource("FROM_HB_CGK");
            media.setType(jsonObject.getInteger("fileType"));
            media.setGalleryid(tbbhId);
            media.setCreateTime(String.valueOf(System.currentTimeMillis()));
            String serverPath = jsonObject.getString("serverPath");
            this.logger.error("\u7701\u7ea7\u590d\u7528\u65e5\u5fd7=========>\u6210\u679c\u5e93\u79c1\u6709\u4ed3\u5e93\u5730\u5740:" + serverPath, new Object[0]);
            String downloadPath = this.signUrl(serverPath);
            this.logger.error("\u7701\u7ea7\u590d\u7528\u65e5\u5fd7=========>\u53ef\u4e0b\u8f7d\u5730\u5740:" + downloadPath, new Object[0]);
            String tempUrl = "";
            tempUrl = downloadPath.contains("?") ? StringUtils.split((String)downloadPath, (String)"?")[0] : downloadPath;
            String fileName = tempUrl.substring(tempUrl.lastIndexOf("/") + 1, tempUrl.length());
            fileName = URLDecoder.decode(fileName, "utf-8");
            if (fileName.contains("?")) {
                fileName = StringUtils.split((String)fileName, (String)"?")[0];
            }
            String uploadDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
            String dir = uploadDir + File.separator + "gjcgk";
            String ruid = UUID.randomUUID().toString();
            String objectname = "media/" + taskId + "/" + tbbhId + "/" + ruid + "/" + fileName;
            String uploadUrl = this.uploadFile(downloadPath, dir, fileName, objectname);
            media.setServerpath(uploadUrl);
            media.setMediasize(jsonObject.getDouble("fileSize"));
            media.setMark(Integer.valueOf(0));
            media.setTypetype(Integer.valueOf(0));
            media.setUsername(jsonObject.getString("userName"));
            media.setLon(jsonObject.getDouble("longitude"));
            media.setLat(jsonObject.getDouble("latitude"));
            media.setDeviceSource(jsonObject.getInteger("device"));
            media.setBizId(taskId);
            String pssj = jsonObject.getString("photoTime");
            if (StringUtils.isNotBlank((CharSequence)pssj)) {
                try {
                    Date date = df.parse(pssj);
                    media.setTime(String.valueOf(date.getTime()));
                }
                catch (Exception ex) {
                    media.setTime(pssj);
                }
            }
            media.setPsfyj(jsonObject.getString("pitch"));
            media.setPitch(jsonObject.getString("pitch"));
            media.setRoll(jsonObject.getInteger("roll"));
            media.setDimHeight(jsonObject.getInteger("dimHeight"));
            media.setDimWidth(jsonObject.getInteger("dimWidth"));
            media.setAzimuth(jsonObject.getString("azimuth"));
            media.setF35mmfocal(jsonObject.getInteger("focal35mm"));
            media.setZsdm(jsonObject.getString("zsdm"));
            media.setPsgd(jsonObject.getDouble("psgd"));
            media.setJdgd(jsonObject.getDouble("jdgd"));
            AppMedia returnMedia = (AppMedia)this.appMediaDao.save((Object)media);
            returnMediaList.add(returnMedia);
        }
        return returnMediaList;
    }

    public String uploadFile(String fileUrl, String dir, String fileName, String objectname) throws Exception {
        String downloadUrl = dir + File.separator + fileName;
        File downdirectory = new File(dir);
        if (!downdirectory.exists()) {
            downdirectory.mkdirs();
        }
        File out = new File(downloadUrl);
        URL url = new URL(fileUrl);
        this.logger.error("\u7701\u7ea7\u590d\u7528\u65e5\u5fd7=========>\u53ef\u4e0b\u8f7d\u5730\u57402:" + fileUrl, new Object[0]);
        this.logger.error("\u7701\u7ea7\u590d\u7528\u65e5\u5fd7=========>\u4fdd\u5b58\u5730\u5740:" + downloadUrl, new Object[0]);
        try {
            FileUtils.copyURLToFile((URL)url, (File)out);
            this.logger.error("\u7701\u7ea7\u590d\u7528\u65e5\u5fd7=========>\u5bf9\u8c61\u5b58\u50a8\u4f4d\u7f6e:" + objectname, new Object[0]);
            String string = this.defaultOssOperatorService.sendObject2Oss(objectname, out);
            return string;
        }
        catch (Exception ex) {
            throw new Exception(objectname + "\u5bf9\u8c61\u5b58\u50a8\u5931\u8d25" + ex.getMessage());
        }
        finally {
            if (out.exists()) {
                out.delete();
            }
        }
    }

    public String signUrl(String url) throws Exception {
        long a = System.currentTimeMillis();
        String c = "1D5BC394E7454BB4B56D808911463460" + a;
        byte[] d = c.getBytes(StandardCharsets.UTF_8);
        try {
            SM2 sm2 = SmUtil.sm2((String)"93EF84E31C27016FBAF3DED662E2C5F47B7941EFA6533E1A113C9F2E8816FB19", null);
            byte[] e = sm2.sign(d);
            String f = Base64.getEncoder().encodeToString(e);
            String token = "1D5BC394E7454BB4B56D808911463460." + a + "." + f;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("x-cgk-token", token);
            JSONObject j = new JSONObject();
            j.put("url", (Object)url);
            String strBody = j.toJSONString();
            HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)"http://121.29.50.223:8085/artifact/api/storage/v1/third/signUrl").addHeaders(headerMap)).contentType("application/json").body(strBody).execute();
            String body = response.body();
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            if (jsonObject.getInteger("code") == 200 && jsonObject.getBoolean("status").booleanValue()) {
                return jsonObject.getString("data");
            }
            throw new Exception(jsonObject.getString("msg"));
        }
        catch (Exception ex) {
            Gw.log.error((Throwable)ex);
            throw ex;
        }
    }

    public JSONObject geoSearch(CgkGeoSearchDto cgkGeoSearchDto) throws Exception {
        long a = System.currentTimeMillis();
        String c = "1D5BC394E7454BB4B56D808911463460" + a;
        byte[] d = c.getBytes(StandardCharsets.UTF_8);
        try {
            SM2 sm2 = SmUtil.sm2((String)"93EF84E31C27016FBAF3DED662E2C5F47B7941EFA6533E1A113C9F2E8816FB19", null);
            byte[] e = sm2.sign(d);
            String f = Base64.getEncoder().encodeToString(e);
            String token = "1D5BC394E7454BB4B56D808911463460." + a + "." + f;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("x-cgk-token", token);
            String strBody = JSONObject.toJSONString((Object)cgkGeoSearchDto);
            HttpResponse response = ((HttpRequest)HttpUtil.createPost((String)"http://121.29.50.223:8085/artifact/api/media/filter/geo").addHeaders(headerMap)).contentType("application/json").body(strBody).execute();
            String body = response.body();
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            if (jsonObject.getInteger("code") == 200 && jsonObject.getBoolean("status").booleanValue()) {
                return jsonObject.getJSONObject("data");
            }
            throw new Exception(jsonObject.getString("msg"));
        }
        catch (Exception ex) {
            Gw.log.error((Throwable)ex);
            throw ex;
        }
    }
}

