/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.cloudquery;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.cloudquery.dao.pub.CloudQueryThemeDao;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudAnalysisReport;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQueryItem;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQueryNode;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQueryTheme;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryItemRepository;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryNodeRepository;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryRepository;
import com.geoway.landteam.cloudquery.servface.pub.CloudAnalysisReportService;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.customtask.util.ObjectReference;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorDomainService;
import com.geoway.landteam.landcloud.core.servface.core.EnumeratorValueService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.YnbhInfo;
import com.geoway.landteam.landcloud.model.datacq.dto.CloudResult;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeService;
import com.gw.base.gpa.entity.GiEntityQueryable;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CloudQueryCQService {
    private GiLoger logger = GwLoger.getLoger(CloudQueryCQService.class);
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    private CloudQueryNodeRepository cloudQueryNodeRepository;
    @Autowired
    private CloudQueryService cloudQueryService;
    @Autowired
    private CloudQueryItemRepository cloudQueryItemRepository;
    @Resource
    CloudQueryRepository cloudQueryRepository;
    @Autowired
    CloudAnalyzeService cloudAnalyzeService;
    @Resource
    CloudQueryThemeDao cloudQueryThemeDao;
    @Autowired
    CloudAnalysisReportService cloudAnalysisReportService;
    @Value(value="${project.downloadDir}")
    String downloadDir;
    @Autowired
    EnumeratorValueService enumeratorValueService;
    @Autowired
    EnumeratorDomainService enumeratorDomainService;

    public List<CloudResult> getCloudResultUrl(String requestId, String userId, String type, boolean theme) throws Exception {
        List cloudQueryList = this.cloudQueryRepository.getByRequestId(requestId);
        if (cloudQueryList == null || cloudQueryList.isEmpty()) {
            return null;
        }
        ArrayList<CloudResult> result = new ArrayList<CloudResult>();
        List nodeIds = cloudQueryList.stream().map(CloudQuery::getNodeId).collect(Collectors.toList());
        List nodes = this.cloudQueryNodeRepository.findAll().stream().collect(Collectors.toList());
        nodes.removeIf(t -> !nodeIds.contains(t.getId()));
        Map<String, List<CloudQuery>> maps = cloudQueryList.stream().collect(Collectors.groupingBy(CloudQuery::getNodeId));
        for (Map.Entry<String, List<CloudQuery>> kv : maps.entrySet()) {
            String nodeId = kv.getKey();
            Optional<CloudQueryNode> opNode = nodes.stream().filter(t -> t.getId().equals(nodeId)).findFirst();
            if (!opNode.isPresent()) continue;
            CloudQueryNode node = opNode.get();
            String cloudUrl = node.getIp();
            String resultJSON = this.getResultJSON(requestId, cloudUrl);
            String metaJSON = "";
            CloudQuery cq = kv.getValue().get(0);
            metaJSON = cq.getType() != null && cq.getType().equals(3) || theme ? this.getMetaByTheme(userId, cq.getTag(), node.getId()) : this.getMeta(userId, type, node.getId());
            String url = this.getDetailUrl(metaJSON, resultJSON, requestId, cloudUrl);
            CloudResult obj = new CloudResult(node.getId(), node.getName(), url);
            result.add(obj);
        }
        return result;
    }

    private String getMeta(String userId, String type, String nodeId) {
        CloudQueryItem t;
        int i;
        ArrayList<CloudQueryItem> cloudQueryItems = new ArrayList<CloudQueryItem>();
        List temps = this.cloudQueryItemRepository.getItemByUserAndNode(userId, nodeId);
        if ("1".equalsIgnoreCase(type)) {
            for (i = 0; i < temps.size(); ++i) {
                t = new CloudQueryItem();
                BeanUtils.copyProperties(temps.get(i), (Object)t);
                if (StringUtils.isNotBlank((CharSequence)t.getTag()) && !t.getTag().contains("\u65f6\u5e8f")) {
                    if (t.getTag().contains("\u91cd\u5e86")) {
                        t.setTag("\u91cd\u5e86\u9ad8\u7ea7");
                    } else {
                        t.setTag("\u9ad8\u7ea7\u67e5\u8be2");
                    }
                }
                cloudQueryItems.add(t);
            }
        } else {
            for (i = 0; i < temps.size(); ++i) {
                t = new CloudQueryItem();
                BeanUtils.copyProperties(temps.get(i), (Object)t);
                t.setTag("\u4e91\u67e5\u8be2");
                cloudQueryItems.add(t);
            }
        }
        String metaJSON = JSONObject.toJSONString(cloudQueryItems);
        JSONArray metaJSONArray = JSONArray.parseArray((String)metaJSON, (Feature[])new Feature[0]);
        for (int i2 = 0; i2 < metaJSONArray.size(); ++i2) {
            JSONObject item = metaJSONArray.getJSONObject(i2);
            item.put("tablecontent", (Object)item.getString("tableContent"));
        }
        metaJSON = metaJSONArray.toString();
        return metaJSON;
    }

    private String getMetaByTheme(String userId, String theme, String nodeId) {
        CloudQueryTheme search = new CloudQueryTheme();
        search.setName(theme);
        search.setNodeId(nodeId);
        List themes = this.cloudQueryThemeDao.gwSearch((GiEntityQueryable)search);
        List reports = this.cloudAnalysisReportService.listByName(theme);
        if ((themes == null || themes.isEmpty()) && (reports == null || reports.isEmpty())) {
            return null;
        }
        List items = new ArrayList();
        if (themes != null && !themes.isEmpty()) {
            List itemIds = themes.stream().map(CloudQueryTheme::getItemId).collect(Collectors.toList());
            items = this.cloudQueryItemRepository.findByIds(itemIds);
        } else if (reports != null && !reports.isEmpty()) {
            CloudAnalysisReport report = (CloudAnalysisReport)reports.get(0);
            items = this.cloudQueryItemRepository.findByTagAndNode(0, report.getTag(), report.getCloudQueryNode());
        }
        ArrayList<CloudQueryItem> newItems = new ArrayList<CloudQueryItem>();
        if (items != null) {
            for (int i = 0; i < items.size(); ++i) {
                CloudQueryItem newItem = new CloudQueryItem();
                BeanUtils.copyProperties(items.get(i), (Object)newItem);
                newItem.setTag(theme);
                newItems.add(newItem);
            }
        }
        String metaJSON = null;
        if (newItems != null) {
            metaJSON = JSONObject.toJSONString(newItems);
            JSONArray metaJSONArray = JSONArray.parseArray((String)metaJSON, (Feature[])new Feature[0]);
            for (int i = 0; i < metaJSONArray.size(); ++i) {
                JSONObject item = metaJSONArray.getJSONObject(i);
                item.put("tablecontent", (Object)item.getString("tableContent"));
            }
            metaJSON = metaJSONArray.toString();
        }
        return metaJSON;
    }

    public String getDetailUrl(String metaJSON, String resultJSON, String requestId, String cloudUrl) throws Exception {
        String token = this.cloudQueryService.getToken();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost();
        httpPost.setHeader("appkey", (String)ProjectConfig.getConfig((String)ProjectConfigEnum.CLOUD_SERVICE_APP_KEY.getKey()));
        httpPost.setHeader("token", token);
        httpPost.setURI(URI.create(cloudUrl + "/cloudQuery/result/addResult"));
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("id", requestId));
        formparams.add(new BasicNameValuePair("metaJson", metaJSON));
        formparams.add(new BasicNameValuePair("detailResultJson", resultJSON));
        UrlEncodedFormEntity paramEntity = new UrlEncodedFormEntity(formparams, "UTF-8");
        httpPost.setEntity((HttpEntity)paramEntity);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String httpEntityContent = this.getHttpEntityContent(response);
        JSONObject jsonObject = JSONObject.parseObject((String)httpEntityContent);
        if ("OK".equalsIgnoreCase(jsonObject.getString("status"))) {
            return cloudUrl + jsonObject.getString("data");
        }
        return "";
    }

    public String getResultJSON(String requestId, String cloudUrl) {
        return this.getResultJSON(requestId, cloudUrl, 0);
    }

    public String getResultJSON(String requestId, String cloudUrl, int times) {
        try {
            List<CloudQuery> list = this.getQueryList(requestId, times);
            if (list.size() < 1) {
                return "";
            }
            JSONObject jsonObject = null;
            for (int i = 0; i < list.size(); ++i) {
                String result = this.getResultJSONById(list.get(i).getId(), cloudUrl);
                if (StringUtils.isBlank((CharSequence)result)) continue;
                JSONObject jsObj = JSONObject.parseObject((String)result);
                if (jsonObject == null) {
                    jsonObject = jsObj;
                    continue;
                }
                for (String temp : jsObj.keySet()) {
                    if (jsonObject.containsKey((Object)temp)) {
                        JSONObject jsonObjTmp = jsObj.getJSONObject(temp);
                        for (String key : jsonObjTmp.keySet()) {
                            jsonObject.getJSONObject(temp).put(key, (Object)jsonObjTmp.getJSONObject(key));
                        }
                        continue;
                    }
                    jsonObject.put(temp, (Object)jsObj.getJSONObject(temp));
                }
            }
            if (jsonObject == null) {
                return "";
            }
            if (list.size() > 0) {
                CloudQuery cloudQuery = list.get(0);
                Double area = cloudQuery.getArea();
                String name = cloudQuery.getName();
                Date querytime = cloudQuery.getQuerytime();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("area", area);
                data.put("name", name);
                data.put("queryTime", df.format(querytime));
                jsonObject.put("data", data);
            }
            return JSONObject.toJSONString(jsonObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getResultJSONById(String id, String cloudQueryUrl) {
        try {
            String token = this.cloudQueryService.getToken();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet();
            httpGet.setHeader("appkey", (String)ProjectConfig.getConfig((String)ProjectConfigEnum.CLOUD_SERVICE_APP_KEY.getKey()));
            httpGet.setHeader("token", token);
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            httpGet.setURI(URI.create(cloudQueryUrl + "/cloudQuery/v3/getDetailRecordById?" + param));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            String httpEntityContent = this.getHttpEntityContent(response);
            JSONObject jsonObject = JSONObject.parseObject((String)httpEntityContent);
            if ("OK".equalsIgnoreCase(jsonObject.getString("status"))) {
                return jsonObject.getString("data");
            }
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public List<CloudQuery> getQueryList(String requestId, int times) throws Exception {
        if (times > 120) {
            return new ArrayList<CloudQuery>();
        }
        String sql = "select * from tb_cloud_query where f_requestId ='" + requestId + "' and (f_mark=0 or f_mark is null)";
        List results = this.jdbcTemplate.queryForList(sql);
        List<Object> list = new ArrayList();
        list = this.mapToList(results);
        boolean success = true;
        for (int i = 0; i < list.size(); ++i) {
            if (((CloudQuery)list.get(i)).getState() == 1 || ((CloudQuery)list.get(i)).getState() == 2) continue;
            success = false;
            break;
        }
        if (success) {
            return list;
        }
        Thread.sleep(1000L);
        return this.getQueryList(requestId, ++times);
    }

    private List<CloudQuery> mapToList(List<Map<String, Object>> results) throws ParseException {
        ArrayList<CloudQuery> list = new ArrayList<CloudQuery>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < results.size(); ++i) {
            CloudQuery cloudQuery = new CloudQuery();
            Map<String, Object> map = results.get(i);
            cloudQuery.setId(map.get("f_id") == null ? "" : map.get("f_id").toString());
            cloudQuery.setParam(map.get("f_param") == null ? "" : map.get("f_param").toString());
            cloudQuery.setUserId(map.get("f_useridstr") == null ? "" : map.get("f_useridstr").toString());
            cloudQuery.setXzqdm(map.get("f_xzqdm") == null ? "" : map.get("f_xzqdm").toString());
            cloudQuery.setQuerytime(map.get("f_querytime") == null ? null : format.parse(map.get("f_querytime").toString()));
            cloudQuery.setResult(map.get("f_result") == null ? "" : map.get("f_result").toString());
            cloudQuery.setReplyTime(map.get("f_replytime") == null ? null : format.parse(map.get("f_replytime").toString()));
            cloudQuery.setState(Integer.valueOf(map.get("f_state") == null ? -1 : Integer.valueOf(map.get("f_state").toString())));
            cloudQuery.setWeight(Integer.valueOf(map.get("f_weight") == null ? -1 : Integer.valueOf(map.get("f_weight").toString())));
            cloudQuery.setDeviceGuid(map.get("f_device_guid") == null ? "" : map.get("f_device_guid").toString());
            cloudQuery.setIsDeleted(Integer.valueOf(map.get("f_isdeleted") == null ? -1 : Integer.valueOf(map.get("f_isdeleted").toString())));
            cloudQuery.setType(Integer.valueOf(map.get("f_type") == null ? -1 : Integer.valueOf(map.get("f_type").toString())));
            cloudQuery.setQueryType(Integer.valueOf(map.get("f_querytype") == null ? -1 : Integer.valueOf(map.get("f_querytype").toString())));
            cloudQuery.setRelId(map.get("f_relid") == null ? "" : map.get("f_relid").toString());
            cloudQuery.setArea(Double.valueOf(map.get("f_area") == null ? 0.0 : Double.valueOf(map.get("f_area").toString())));
            cloudQuery.setIsCollect(Integer.valueOf(map.get("f_iscollect") == null ? -1 : Integer.valueOf(map.get("f_iscollect").toString())));
            cloudQuery.setName(map.get("f_name") == null ? "" : map.get("f_name").toString());
            cloudQuery.setShareId(map.get("f_shareid") == null ? "" : map.get("f_shareid").toString());
            cloudQuery.setShareUser(Long.valueOf(map.get("f_shareuser") == null ? -1L : Long.valueOf(map.get("f_shareuser").toString())));
            cloudQuery.setNum(map.get("f_num") == null ? "" : map.get("f_num").toString());
            cloudQuery.setRequestId(map.get("f_requestid") == null ? "" : map.get("f_requestid").toString());
            cloudQuery.setTag(map.get("f_tag") == null ? "" : map.get("f_tag").toString());
            cloudQuery.setMark(Integer.valueOf(map.get("f_mark") == null ? -1 : Integer.valueOf(map.get("f_mark").toString())));
            list.add(cloudQuery);
        }
        return list;
    }

    public String getResultJSONById(String id) {
        try {
            String token = this.cloudQueryService.getToken();
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet();
            httpGet.setHeader("appkey", (String)ProjectConfig.getConfig((String)ProjectConfigEnum.CLOUD_SERVICE_APP_KEY.getKey()));
            httpGet.setHeader("token", token);
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("id", id));
            String param = URLEncodedUtils.format(formparams, (String)"UTF-8");
            httpGet.setURI(URI.create((String)ProjectConfig.getConfig((String)ProjectConfigEnum.CLOUD_SERVICE_URL.getKey()) + "/cloudQuery/v3/getDetailRecordById?" + param));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            String httpEntityContent = this.getHttpEntityContent(response);
            JSONObject jsonObject = JSONObject.parseObject((String)httpEntityContent);
            if ("OK".equalsIgnoreCase(jsonObject.getString("status"))) {
                return jsonObject.getString("data");
            }
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public byte[] getCloudAnalysisReportSelf(String requestId, String userName, String type, Integer narrow, String title, String tag, String nodeId, ObjectReference ref) throws Exception {
        int len;
        ref.setTag("pdf");
        String filePath = String.format("%s%s%s_%d_%s.pdf", this.downloadDir, File.separator, title, narrow, requestId);
        switch (type) {
            case "1": {
                File file = new File(filePath);
                if (file.exists()) break;
                YnbhInfo info = this.cloudAnalyzeService.Parse(requestId, "", userName, 1, tag, false);
                if (info == null) {
                    return null;
                }
                info.userName = userName;
                info.outFile = filePath;
                info.narrow = narrow > 0;
                this.cloudAnalyzeService.ExportReport((ProjectInfo)info, false);
                break;
            }
            case "3": {
                File file = new File(filePath);
                if (file.exists()) break;
                YnbhInfo info = this.cloudAnalyzeService.Parse(requestId, "", userName, 1, tag, true);
                if (info == null) {
                    return null;
                }
                info.userName = userName;
                info.outFile = filePath;
                info.narrow = narrow > 0;
                this.cloudAnalyzeService.ExportReport((ProjectInfo)info, true);
                break;
            }
            case "4": {
                File file = new File(filePath);
                if (file.exists()) break;
                YnbhInfo info = this.cloudAnalyzeService.ParseYnbh(requestId, "", userName, 1, tag);
                if (info == null) {
                    return null;
                }
                info.userName = userName;
                info.outFile = filePath;
                info.narrow = narrow > 0;
                this.cloudAnalyzeService.ExportReportYn(info);
            }
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)file.length());
        byte[] buffer = new byte[1024];
        while ((len = fis.read(buffer)) != -1) {
            baos.write(buffer, 0, len);
        }
        fis.close();
        baos.close();
        byte[] result = baos.toByteArray();
        try {
            Files.delete(Paths.get(filePath, new String[0]));
        }
        catch (Exception ex) {
            this.logger.warn("\u5220\u9664\u6587\u4ef6" + filePath + "\u5931\u8d25", new Object[0]);
            this.logger.warn("", new Object[]{ex});
        }
        return result;
    }

    public void pdfToLongJpg(File pdfFile, String outJpg) throws IOException {
        try {
            PDDocument document = PDDocument.load((File)pdfFile);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage longImage = null;
            int y = 0;
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage image = pdfRenderer.renderImageWithDPI(i, 300.0f, ImageType.RGB);
                if (longImage == null) {
                    longImage = new BufferedImage(image.getWidth(), image.getHeight() * document.getNumberOfPages(), 1);
                }
                int pageHeight = image.getHeight();
                longImage.createGraphics().drawImage((Image)image, 0, y, null);
                y += pageHeight;
            }
            File outputFile = new File(outJpg);
            ImageIO.write(longImage, "jpg", outputFile);
            document.close();
        }
        catch (Exception ex) {
            this.logger.error("pdf to jpg error", new Object[]{ex});
        }
    }

    private String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }
}

