/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.atlas.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalcuationDef;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationDefRepository;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationTaskRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.CloudCalculationTaskService;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.DatasourceFactory;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.util.hdfs.CloudCalculationTaskVo;
import com.geoway.landteam.landcloud.service.util.hdfs.DBbuilder;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CloudCalculationTaskServiceImpl
implements CloudCalculationTaskService {
    GiLoger logger = GwLoger.getLoger(CloudCalculationTaskServiceImpl.class);
    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ExportDataService exportDataService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    CloudCalculationDefRepository cloudCalculationDefRepository;
    @Autowired
    CloudCalculationTaskRepository cloudCalculationTaskRepository;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    DatasourceFactory datasourceFactory;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${project.tempDir}")
    protected String tempdir;
    private static final String RESULTURL = "http://192.168.19.55:8099/atlas/task/get?thin=true";

    @Override
    public String createTask(String definitionId, Long userid, String name) {
        Assert.hasText((String)definitionId, (String)"invalid definitionId");
        Optional<CloudCalcuationDef> def = Optional.of(definitionId).map(arg_0 -> ((CloudCalculationDefRepository)this.cloudCalculationDefRepository).findById(arg_0)).map(e -> (CloudCalcuationDef)e.orElseThrow(RuntimeException::new));
        String params = def.map(CloudCalcuationDef::getParam).filter(StringUtils::isNotBlank).orElseThrow(() -> new RuntimeException("invalid Cloud_Calculation_Definition"));
        JSONArray inputConfig = def.map(CloudCalcuationDef::getInputConfig).map(x$0 -> JSONArray.parseArray((String)x$0, (Feature[])new Feature[0])).orElseThrow(() -> new RuntimeException("invalid Cloud_Calculation_Definition_initparam"));
        ArrayList<CloudCalculationTask> tasks = new ArrayList<CloudCalculationTask>();
        String taskid = UUID.randomUUID().toString();
        for (int i = 0; i < inputConfig.size(); ++i) {
            String id = UUID.randomUUID().toString();
            JSONObject inputConfigJson = inputConfig.getJSONObject(i);
            String itemParam = params;
            for (String key : inputConfigJson.keySet()) {
                String regix = "#" + key + "#";
                itemParam = itemParam.replaceAll(regix, inputConfigJson.getString(key));
            }
            CloudCalculationTask task = new CloudCalculationTask();
            task.setCreateTime(new Timestamp(System.currentTimeMillis()));
            task.setDefinitionId(definitionId);
            task.setParam(itemParam);
            task.setStatus(Integer.valueOf(0));
            task.setId(id);
            task.setUserid(userid);
            task.setTaskid(taskid);
            task.setName(name);
            tasks.add(task);
        }
        this.cloudCalculationTaskRepository.saveAll(tasks);
        return taskid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void push(MultipartFile file, String bizId, String tbid, String templateId, String taskid) {
        boolean disabelTransfer = Optional.ofNullable(this.sysConfigService.findOne("transfer.disable")).map(SysConfig::getValue).map(String::toLowerCase).map("true"::equals).orElse(false);
        String safeFilePath = this.tempdir + "/calc/" + taskid;
        File zipFile = null;
        try {
            File dir = new File(safeFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (file != null) {
                String zipPath = safeFilePath + File.separator + taskid + ".zip";
                File tempFile = new File(zipPath);
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)tempFile);
            }
            if (StringUtils.isNotBlank((CharSequence)bizId)) {
                this.exportDataService.createExportData(safeFilePath, bizId, tbid);
            }
            DBbuilder dBbuilder = new DBbuilder(safeFilePath);
            dBbuilder.setJdbcTemplate(this.jdbcTemplate);
            dBbuilder.appendTable("tb_cloud_calculatiton_def", String.format("where f_id = '%s'", templateId));
            dBbuilder.appendTable("tb_cloud_calculation_task", String.format("where f_taskid = '%s'", taskid));
            Zip4jUtils.zip((String)safeFilePath, null, (boolean)false, null);
            ExportFileUtil.deleteFileAndDir(new File(safeFilePath));
            zipFile = new File(safeFilePath + ".zip");
            zipFile.renameTo(new File(safeFilePath + ".calc"));
            if (!disabelTransfer) {
                this.fileTransferService.sendFile(safeFilePath + ".calc", "wydc");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[]{e});
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)taskid)) {
                this.cloudCalculationTaskRepository.updataStatusByTaskid(taskid, 1);
            }
            if (!disabelTransfer && zipFile != null) {
                zipFile.delete();
            }
        }
    }

    @Override
    public void startTask(String taskid) {
        List tasks = this.cloudCalculationTaskRepository.queryByTaskid(taskid);
        String url = Optional.ofNullable(taskid).map(arg_0 -> ((CloudCalculationDefRepository)this.cloudCalculationDefRepository).queryByTask(arg_0)).map(CloudCalcuationDef::getServiceUrl).orElseThrow(() -> new RuntimeException("\u67e5\u8be2\u670d\u52a1\u5b9a\u4e49\u9519\u8bef"));
        for (CloudCalculationTask task : tasks) {
            JSONArray param = Optional.of(task).map(CloudCalculationTask::getParam).map(JSON::parseObject).map(json -> json.getJSONArray("param")).orElseThrow(RuntimeException::new);
            String queryStr = param.toString().replace("#taskid#", taskid);
            String itemurl = url + "?svcparams=" + queryStr;
            OkHttpClient client = new OkHttpClient().newBuilder().readTimeout(30L, TimeUnit.SECONDS).build();
            client.readTimeoutMillis();
            Request _request = new Request.Builder().url(itemurl).get().build();
            String itemid = null;
            try {
                Response resp = client.newCall(_request).execute();
                String responseStr = resp.body().string();
                JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
                if (jsonObject.getBooleanValue("flag")) {
                    itemid = jsonObject.getString("taskId");
                    this.cloudCalculationTaskRepository.setStarted(task.getId(), itemid);
                    continue;
                }
                this.logger.error("\u4efb\u52a1\u521b\u5efa\u5931\u8d25:" + jsonObject.toJSONString(), new Object[0]);
                Integer status = CloudCalculationTask.STATUS_PUSH | CloudCalculationTask.STATUS_LAN_RECEIVED | CloudCalculationTask.STATUS_FINISHED;
                this.cloudCalculationTaskRepository.updataStatusByTaskid(taskid, status.intValue());
            }
            catch (Exception e) {
                this.logger.error("\u4efb\u52a1\u521b\u5efa\u5931\u8d25", new Object[0]);
                Integer status = CloudCalculationTask.STATUS_PUSH | CloudCalculationTask.STATUS_LAN_RECEIVED | CloudCalculationTask.STATUS_FINISHED;
                this.cloudCalculationTaskRepository.updataStatusByTaskid(taskid, status.intValue());
            }
        }
    }

    @Override
    public List<CloudCalculationTask> queryUnfinishedTask() {
        Integer status = CloudCalculationTask.STATUS_PUSH | CloudCalculationTask.STATUS_LAN_RECEIVED | CloudCalculationTask.STATUS_STARTED;
        return this.cloudCalculationTaskRepository.queryByStatus(status);
    }

    @Override
    public List<CloudCalculationTask> queryByIds(List<String> ids) {
        return this.cloudCalculationTaskRepository.queryByIds(ids);
    }

    @Override
    public CloudCalculationTask updateTaskResult(CloudCalculationTask task) {
        String item = task.getItemid();
        String url = "http://192.168.19.55:8099/atlas/task/get?thin=true&id=" + item;
        JSONObject result = this.httpGet(url);
        int curState = task.getStatus();
        Boolean hasTask = result.getBoolean("flag");
        if (hasTask != null && !hasTask.booleanValue()) {
            task.setStatus(Integer.valueOf(curState |= CloudCalculationTask.STATUS_FINISHED.intValue()));
            task.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            return (CloudCalculationTask)this.cloudCalculationTaskRepository.save((Object)task);
        }
        String state = result.getString("State");
        boolean success = result.getBoolean("IsSucceed");
        String timecost = result.getString("TimeCost");
        if (success) {
            try {
                this.getResult(task);
                curState |= CloudCalculationTask.STATUS_SUCCESS.intValue();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        if ("Finished".equals(state)) {
            task.setStatus(Integer.valueOf(curState |= CloudCalculationTask.STATUS_FINISHED.intValue()));
            task.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            task.setTimecost(timecost);
            return (CloudCalculationTask)this.cloudCalculationTaskRepository.save((Object)task);
        }
        return task;
    }

    @Override
    public void getResult(CloudCalculationTask task) {
        Optional<CloudCalcuationDef> defOptional = Optional.of(task.getTaskid()).map(arg_0 -> ((CloudCalculationDefRepository)this.cloudCalculationDefRepository).queryByTask(arg_0));
        JSONArray datasources = defOptional.map(CloudCalcuationDef::getOutputDataSource).map(x$0 -> JSONObject.parseArray((String)x$0, (Feature[])new Feature[0])).orElseThrow(() -> new RuntimeException());
        JSONArray outputConfigs = defOptional.map(CloudCalcuationDef::getOutputConfig).map(x$0 -> JSONObject.parseArray((String)x$0, (Feature[])new Feature[0])).orElseThrow(() -> new RuntimeException());
        JSONObject jsonObject = new JSONObject();
        for (int i = 0; i < datasources.size(); ++i) {
            JSONObject datasource = datasources.getJSONObject(i);
            JSONObject taskParamJson = Optional.of(task).map(CloudCalculationTask::getParam).map(JSON::parseObject).orElseGet(JSONObject::new);
            String type = datasource.getString("type");
            Datasource ds = this.datasourceFactory.getDatasource(type);
            String source = datasource.getString("dataSource");
            if (!"hdfs".equalsIgnoreCase(type)) {
                String dbuser = datasource.getString("dbuser");
                String password = datasource.getString("dbpassword");
                String tablename = datasource.getString("tablename");
                boolean shapeData = datasource.getBooleanValue("shapeData");
                ds.startConnectionPool(source, dbuser, password);
                if (!ds.testConnection(source, dbuser, password)) {
                    throw new RuntimeException("\u8f93\u5165\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25");
                }
                JdbcTemplate outputTemplate = (JdbcTemplate)ds.getDaoObject(source, dbuser, password);
                for (int j = 0; j < outputConfigs.size(); ++j) {
                    JSONObject config = outputConfigs.getJSONObject(j);
                    String fxx = config.getString("fxx");
                    String shpName = config.getString("shpName");
                    try {
                        String countsql = String.format("select count(*) from %s where taskid ='%s' and fxx='%s'", tablename, task.getTaskid(), fxx);
                        long count = (Long)outputTemplate.queryForObject(countsql, Long.class);
                        String sql = shapeData && count > 0L && count < 100000L ? String.format("select taskid,fxx,xjmj,shape from %s where taskid ='%s' and fxx='%s'", tablename, task.getTaskid(), fxx) : String.format("select taskid,fxx,xjmj from %s where taskid ='%s' and fxx='%s'", tablename, task.getTaskid(), fxx);
                        if (count == 0L) {
                            jsonObject.put(shpName, (Object)0.0);
                            continue;
                        }
                        List result = outputTemplate.queryForList(sql);
                        if (shapeData && count < 100000L) {
                            String shpPath = this.tempdir + File.separator + "calc" + File.separator + "result" + File.separator + task.getTaskid() + File.separator + "shape" + File.separator + shpName + "\u538b\u5360\u56fe\u6591.shp";
                            List<String> fields = Arrays.asList("taskid", "fxx", "xjmj", "shape");
                            this.createShp(shpPath, fields, result);
                        }
                        Double sum = result.stream().mapToDouble(e -> Double.parseDouble((String)e.get("xjmj"))).sum();
                        jsonObject.put(shpName, (Object)sum);
                        continue;
                    }
                    catch (Exception e2) {
                        jsonObject.put(shpName, (Object)0.0);
                        this.logger.error((Throwable)e2);
                    }
                }
            }
            task.setResult(jsonObject.toJSONString());
        }
        int curState = task.getStatus() | CloudCalculationTask.STATUS_SUCCESS;
        task.setStatus(Integer.valueOf(curState));
        this.cloudCalculationTaskRepository.save((Object)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(String taskid) {
        boolean disabelTransfer = Optional.ofNullable(this.sysConfigService.findOne("transfer.disable")).map(SysConfig::getValue).map(String::toLowerCase).map("true"::equals).orElse(false);
        String safeFilePath = this.tempdir + File.separator + "calc" + File.separator + "result" + File.separator + taskid;
        File zipFile = null;
        try {
            File dir = new File(safeFilePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            DBbuilder dBbuilder = new DBbuilder(safeFilePath);
            dBbuilder.setJdbcTemplate(this.jdbcTemplate);
            dBbuilder.appendTable("tb_cloud_calculation_task", String.format("where f_taskid = '%s'", taskid));
            String shapePath = safeFilePath + File.separator + "shape";
            if (new File(shapePath).exists()) {
                Zip4jUtils.zip((String)shapePath, null, (boolean)false, null);
                ExportFileUtil.deleteFileAndDir(new File(shapePath));
            }
            Zip4jUtils.zip((String)safeFilePath, null, (boolean)false, null);
            ExportFileUtil.deleteFileAndDir(new File(safeFilePath));
            zipFile = new File(safeFilePath + ".zip");
            zipFile.renameTo(new File(safeFilePath + ".calc"));
            zipFile = new File(safeFilePath + ".calc");
            if (!disabelTransfer) {
                this.fileTransferService.sendFile(safeFilePath + ".calc", "wydc");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[]{e});
        }
        finally {
            this.addStatusByTaskid(taskid, CloudCalculationTask.STATUS_RETURN);
            if (zipFile != null && zipFile.exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public List<CloudCalculationTaskVo> getUserVo(Long userid, Integer state, String name) {
        List tasks = this.cloudCalculationTaskRepository.queryByUserid(userid);
        return this.convert(tasks, state, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createShp(String shpPath, List<String> attrKeys, List<Map<String, Object>> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        String parent = FilenameUtils.getFullPath((String)shpPath);
        new File(parent).mkdirs();
        HashMap<String, URL> params = null;
        ShapefileDataStore ds = null;
        FeatureWriter writer = null;
        SimpleFeatureTypeBuilder tb = null;
        SimpleFeature feature = null;
        Map<String, Object> row = null;
        Geometry geom = null;
        try {
            File file = new File(shpPath);
            params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            tb = new SimpleFeatureTypeBuilder();
            tb.setCRS(CRS.decode((String)"EPSG:4490"));
            tb.setName("shapefile");
            for (String field : attrKeys) {
                if ("shape".equals(field)) {
                    tb.add(field.toUpperCase(), MultiPolygon.class);
                    continue;
                }
                if ("xjmj".equals(field)) {
                    tb.add(field.toUpperCase(), Double.class);
                    continue;
                }
                tb.add(field.toUpperCase(), String.class);
            }
            SimpleFeatureType sft = tb.buildFeatureType();
            ds.createSchema(sft);
            ds.setCharset(Charset.forName("UTF-8"));
            writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader wtkreader = new WKTReader(geometryFactory);
            for (int i = 0; i < data.size(); ++i) {
                feature = (SimpleFeature)writer.next();
                row = data.get(i);
                String wkt = row.get("shape").toString();
                if (wkt.toLowerCase().startsWith("srid")) {
                    wkt = wkt.substring(wkt.indexOf(";") + 1);
                }
                geom = wtkreader.read(wkt);
                feature.setAttribute("the_geom", (Object)geom);
                for (String key : row.keySet()) {
                    if (key.equals("shape")) continue;
                    if (row.get(key) != null && StringUtils.isNotBlank((CharSequence)row.get(key).toString())) {
                        if (key.length() >= 10) {
                            feature.setAttribute(key.substring(0, 10).toUpperCase(), (Object)row.get(key).toString());
                            continue;
                        }
                        feature.setAttribute(key.toUpperCase(), (Object)row.get(key).toString());
                        continue;
                    }
                    if (key.length() >= 10) {
                        feature.setAttribute(key.substring(0, 10).toUpperCase(), (Object)"");
                        continue;
                    }
                    feature.setAttribute(key.toUpperCase(), (Object)"");
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (params != null) {
                params = null;
            }
            if (tb != null) {
                tb = null;
            }
            if (feature != null) {
                feature = null;
            }
            if (row != null) {
                row = null;
            }
            if (geom != null) {
                geom = null;
            }
            if (ds != null) {
                ds.dispose();
                ds = null;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                writer = null;
            }
        }
    }

    private JSONObject httpGet(String url) {
        OkHttpClient client = new OkHttpClient().newBuilder().readTimeout(30L, TimeUnit.SECONDS).build();
        client.readTimeoutMillis();
        Request _request = new Request.Builder().url(url).get().build();
        try {
            Response resp = client.newCall(_request).execute();
            String responseStr = resp.body().string();
            return JSONObject.parseObject((String)responseStr);
        }
        catch (IOException e) {
            throw new RuntimeException("atlas\u8bf7\u6c42\u5931\u8d25");
        }
    }

    private List<CloudCalculationTaskVo> convert(List<CloudCalculationTask> list, Integer state, String name) {
        int _state = Optional.ofNullable(state).orElse(-1);
        Map<String, List<CloudCalculationTask>> groupedTask = list.stream().collect(Collectors.groupingBy(CloudCalculationTask::getTaskid));
        List<CloudCalculationTaskVo> result = groupedTask.entrySet().stream().map(Map.Entry::getValue).map(this::mapToVo).filter(e -> StringUtils.isBlank((CharSequence)name) || e.getName() == name).filter(e -> _state == -1 || _state == e.getState()).collect(Collectors.toList());
        return result;
    }

    private CloudCalculationTaskVo mapToVo(List<CloudCalculationTask> list) {
        Assert.notEmpty(list);
        List taskids = list.stream().map(CloudCalculationTask::getTaskid).distinct().collect(Collectors.toList());
        Assert.isTrue((taskids.size() == 1 ? 1 : 0) != 0);
        CloudCalculationTask task = list.get(0);
        String taskid = task.getTaskid();
        String name = task.getName();
        String userName = Optional.of(task).map(CloudCalculationTask::getUserid).map(arg_0 -> ((LandUserRepository)this.landUserRepository).findById(arg_0)).map(e -> e.orElse(null)).map(LandUser::getName).orElse("");
        Date date = new Date(task.getCreateTime().getTime());
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        String createtime = sdf.format(date);
        List status = list.stream().map(CloudCalculationTask::getStatus).map(i -> i & (CloudCalculationTask.STATUS_SUCCESS | CloudCalculationTask.STATUS_RETURNED)).distinct().collect(Collectors.toList());
        int state = 0;
        state = status.contains(CloudCalculationTask.STATUS_RETURNED) ? 2 : (status.contains(0) ? 0 : 1);
        CloudCalculationTaskVo vo = new CloudCalculationTaskVo();
        if ((task.getStatus() & CloudCalculationTask.STATUS_RETURNED) == CloudCalculationTask.STATUS_RETURNED) {
            JSONObject statistics = new JSONObject();
            list.stream().map(this::getResultJson).forEach(arg_0 -> ((JSONObject)statistics).putAll(arg_0));
            String url = statistics.getString("shape");
            if (StringUtils.isNotBlank((CharSequence)url)) {
                url = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
            }
            statistics.remove((Object)"shape");
            vo.setUrl(url);
            vo.setStatistics(statistics);
            String excel = statistics.getString("excel");
            if (StringUtils.isNotBlank((CharSequence)excel)) {
                excel = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
            }
            vo.setExcelUrl(excel);
        }
        vo.setName(name);
        vo.setTaskid(taskid);
        vo.setUsername(userName);
        vo.setCreatetime(createtime);
        vo.setState(state);
        return vo;
    }

    private JSONObject getResultJson(CloudCalculationTask task) {
        return Optional.of(task).map(CloudCalculationTask::getResult).map(JSON::parseObject).orElseGet(JSONObject::new);
    }

    @Override
    public String queryNewUnstartedTaskid() {
        List tasks = this.cloudCalculationTaskRepository.queryByStatus(Integer.valueOf(CloudCalculationTask.STATUS_PUSH | CloudCalculationTask.STATUS_LAN_RECEIVED));
        return tasks.stream().min(Comparator.comparing(CloudCalculationTask::getCreateTime)).map(CloudCalculationTask::getTaskid).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createStatistics(String fileName, String taskId) {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = pathRoot + "excel" + File.separator + "\u8fdb\u51fa\u5e73\u8861\u8d28\u68c0\u89c4\u5219\u610f\u89c1\u8868.xls";
        String ouputFile = this.tempdir + File.separator + "excel" + File.separator + (fileName + System.currentTimeMillis() + ".xlsx");
        JSONObject statistics = new JSONObject();
        Optional.ofNullable(taskId).map(arg_0 -> ((CloudCalculationTaskRepository)this.cloudCalculationTaskRepository).queryByTaskid(arg_0)).orElseGet(ArrayList::new).stream().map(CloudCalculationTask::getResult).filter(StringUtils::isNotBlank).map(JSON::parseObject).forEach(arg_0 -> ((JSONObject)statistics).putAll(arg_0));
        Workbook workbook = null;
        FileInputStream finp = null;
        FileOutputStream fos = null;
        try {
            FileUtil.copyFile(srcFileName, ouputFile);
            finp = new FileInputStream(ouputFile);
            workbook = WorkbookFactory.create((InputStream)finp);
            Sheet sheet1 = workbook.getSheetAt(0);
            this.parseSheet(sheet1, 0, (Map<String, Object>)statistics);
            fos = new FileOutputStream(ouputFile);
            workbook.write((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            ouputFile = "";
            e.printStackTrace();
        }
        finally {
            if (finp != null) {
                try {
                    finp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ouputFile;
    }

    private void parseSheet(Sheet sheet, int idFieldIndex, Map<String, Object> data) {
        if (data.isEmpty()) {
            return;
        }
        int rowCount = sheet.getPhysicalNumberOfRows();
        Row row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = sheet.getRow(i);
            if (row == null) continue;
            try {
                Cell idCell = row.getCell(idFieldIndex);
                String key = this.getCellStringValue(idCell);
                if (StringUtils.isBlank((CharSequence)key)) continue;
                for (String _key : data.keySet()) {
                    if (!_key.equals(key)) continue;
                    Double value = Double.valueOf(String.valueOf(data.get(_key)));
                    row.getCell(5).setCellValue(value.doubleValue());
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Throwable)e);
            }
        }
        sheet.setForceFormulaRecalculation(true);
    }

    private String getCellStringValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue());
                        break;
                    }
                    cellValue = String.valueOf((long)cell.getNumericCellValue());
                    break;
                }
                case BOOLEAN: {
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case BLANK: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case ERROR: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
                default: {
                    cellValue = "\u9519\u8bef";
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue;
    }

    @Override
    public void addStatusByTaskid(String taskid, int status) {
        String sql = String.format("update tb_cloud_calculation_task  set f_status = (f_status|%s) where f_taskid = '%s'", status, taskid);
        this.jdbcTemplate.update(sql);
    }
}

